/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r5.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationSupportUtils {
    private static final Logger ourLog = LoggerFactory.getLogger(ValidationSupportUtils.class);

    private ValidationSupportUtils() {
    }

    public static String extractCodeSystemForCode(IBaseResource theValueSet, String theCode) {
        if (theValueSet instanceof org.hl7.fhir.dstu3.model.ValueSet) {
            return ValidationSupportUtils.extractCodeSystemForCodeDSTU3((org.hl7.fhir.dstu3.model.ValueSet)theValueSet, theCode);
        }
        if (theValueSet instanceof org.hl7.fhir.r4.model.ValueSet) {
            return ValidationSupportUtils.extractCodeSystemForCodeR4((org.hl7.fhir.r4.model.ValueSet)theValueSet, theCode);
        }
        if (theValueSet instanceof ValueSet) {
            return ValidationSupportUtils.extractCodeSystemForCodeR5((ValueSet)theValueSet, theCode);
        }
        return null;
    }

    private static String extractCodeSystemForCodeDSTU3(org.hl7.fhir.dstu3.model.ValueSet theValueSet, String theCode) {
        if (theValueSet.getCompose().getInclude().isEmpty()) {
            return null;
        }
        if (theValueSet.getCompose().getInclude().size() == 1) {
            ValueSet.ConceptSetComponent include = (ValueSet.ConceptSetComponent)theValueSet.getCompose().getInclude().iterator().next();
            return include.hasSystem() ? ValidationSupportUtils.getVersionedCodeSystem(include.getSystem(), include.getVersion()) : null;
        }
        for (ValueSet.ConceptSetComponent include : theValueSet.getCompose().getInclude()) {
            if (!include.hasSystem()) continue;
            for (ValueSet.ConceptReferenceComponent concept : include.getConcept()) {
                if (!concept.hasCodeElement() || !concept.getCode().equals(theCode)) continue;
                return ValidationSupportUtils.getVersionedCodeSystem(include.getSystem(), include.getVersion());
            }
        }
        ValidationSupportUtils.logCodeAndValueSet(theCode, theValueSet.getId());
        return null;
    }

    private static String extractCodeSystemForCodeR4(org.hl7.fhir.r4.model.ValueSet theValueSet, String theCode) {
        if (theValueSet.getCompose().getInclude().isEmpty()) {
            return null;
        }
        if (theValueSet.getCompose().getInclude().size() == 1) {
            ValueSet.ConceptSetComponent include = (ValueSet.ConceptSetComponent)theValueSet.getCompose().getInclude().iterator().next();
            return include.hasSystem() ? ValidationSupportUtils.getVersionedCodeSystem(include.getSystem(), include.getVersion()) : null;
        }
        for (ValueSet.ConceptSetComponent include : theValueSet.getCompose().getInclude()) {
            if (!include.hasSystem()) continue;
            for (ValueSet.ConceptReferenceComponent concept : include.getConcept()) {
                if (!concept.hasCodeElement() || !concept.getCode().equals(theCode)) continue;
                return ValidationSupportUtils.getVersionedCodeSystem(include.getSystem(), include.getVersion());
            }
        }
        ValidationSupportUtils.logCodeAndValueSet(theCode, theValueSet.getId());
        return null;
    }

    private static String getVersionedCodeSystem(String theCodeSystem, String theVersion) {
        if (!theCodeSystem.contains("|") && theVersion != null) {
            return theCodeSystem + "|" + theVersion;
        }
        return theCodeSystem;
    }

    private static String extractCodeSystemForCodeR5(ValueSet theValueSet, String theCode) {
        if (theValueSet.getCompose().getInclude().isEmpty()) {
            return null;
        }
        if (theValueSet.getCompose().getInclude().size() == 1) {
            ValueSet.ConceptSetComponent include = (ValueSet.ConceptSetComponent)theValueSet.getCompose().getInclude().iterator().next();
            return include.hasSystem() ? ValidationSupportUtils.getVersionedCodeSystem(include.getSystem(), include.getVersion()) : null;
        }
        for (ValueSet.ConceptSetComponent include : theValueSet.getCompose().getInclude()) {
            if (!include.hasSystem()) continue;
            for (ValueSet.ConceptReferenceComponent concept : include.getConcept()) {
                if (!concept.hasCodeElement() || !concept.getCode().equals(theCode)) continue;
                return ValidationSupportUtils.getVersionedCodeSystem(include.getSystem(), include.getVersion());
            }
        }
        ValidationSupportUtils.logCodeAndValueSet(theCode, theValueSet.getId());
        return null;
    }

    private static void logCodeAndValueSet(String theCode, String theValueSet) {
        ourLog.trace("CodeSystem couldn't be extracted for code: {} for ValueSet: {}", (Object)theCode, (Object)theValueSet);
    }
}

