/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.validator;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.sl.cache.CacheFactory;
import ca.uhn.fhir.sl.cache.LoadingCache;
import ca.uhn.fhir.system.HapiSystemProperties;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.context.IContextResourceLoader;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.utilities.CodingValidationRequest;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionSpecificWorkerContextWrapper
extends I18nBase
implements IWorkerContext {
    private static final Logger ourLog = LoggerFactory.getLogger(VersionSpecificWorkerContextWrapper.class);
    private final ValidationSupportContext myValidationSupportContext;
    private final VersionCanonicalizer myVersionCanonicalizer;
    private final LoadingCache<ResourceKey, IBaseResource> myFetchResourceCache;
    private volatile List<StructureDefinition> myAllStructures;
    private Parameters myExpansionProfile;

    public VersionSpecificWorkerContextWrapper(ValidationSupportContext theValidationSupportContext, VersionCanonicalizer theVersionCanonicalizer) {
        this.myValidationSupportContext = theValidationSupportContext;
        this.myVersionCanonicalizer = theVersionCanonicalizer;
        long timeoutMillis = HapiSystemProperties.getTestValidationResourceCachesMs();
        this.myFetchResourceCache = CacheFactory.build((long)timeoutMillis, (long)10000L, key -> {
            StructureDefinition canonicalSd;
            String fetchResourceName = key.getResourceName();
            if (this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getVersion().getVersion() == FhirVersionEnum.DSTU2 && "CodeSystem".equals(fetchResourceName)) {
                fetchResourceName = "ValueSet";
            }
            Class fetchResourceType = fetchResourceName.equals("Resource") ? null : this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getResourceDefinition(fetchResourceName).getImplementingClass();
            IBaseResource fetched = this.myValidationSupportContext.getRootValidationSupport().fetchResource(fetchResourceType, key.getUri());
            Resource canonical = this.myVersionCanonicalizer.resourceToValidatorCanonical(fetched);
            if (canonical instanceof StructureDefinition && (canonicalSd = (StructureDefinition)canonical).getSnapshot().isEmpty()) {
                ourLog.info("Generating snapshot for StructureDefinition: {}", (Object)canonicalSd.getUrl());
                fetched = this.myValidationSupportContext.getRootValidationSupport().generateSnapshot(theValidationSupportContext, fetched, "", null, "");
                Validate.isTrue((fetched != null ? 1 : 0) != 0, (String)"StructureDefinition %s has no snapshot, and no snapshot generator is configured", (Object[])new Object[]{key.getUri()});
                canonical = this.myVersionCanonicalizer.resourceToValidatorCanonical(fetched);
            }
            return canonical;
        });
        this.setValidationMessageLanguage(this.getLocale());
    }

    public Set<String> getBinaryKeysAsSet() {
        throw new UnsupportedOperationException(Msg.code((int)2118));
    }

    public boolean hasBinaryKey(String s) {
        return this.myValidationSupportContext.getRootValidationSupport().fetchBinary(s) != null;
    }

    public byte[] getBinaryForKey(String s) {
        return this.myValidationSupportContext.getRootValidationSupport().fetchBinary(s);
    }

    public int loadFromPackage(NpmPackage pi, IContextResourceLoader loader) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)652));
    }

    public int loadFromPackage(NpmPackage pi, IContextResourceLoader loader, List<String> types) throws FileNotFoundException, IOException, FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)653));
    }

    public int loadFromPackageAndDependencies(NpmPackage pi, IContextResourceLoader loader, BasePackageCacheManager pcm) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)654));
    }

    public boolean hasPackage(String id, String ver) {
        throw new UnsupportedOperationException(Msg.code((int)655));
    }

    public boolean hasPackage(PackageInformation packageInformation) {
        return false;
    }

    public PackageInformation getPackage(String id, String ver) {
        return null;
    }

    public int getClientRetryCount() {
        throw new UnsupportedOperationException(Msg.code((int)656));
    }

    public IWorkerContext setClientRetryCount(int value) {
        throw new UnsupportedOperationException(Msg.code((int)657));
    }

    public TimeTracker clock() {
        return null;
    }

    public IWorkerContextManager.IPackageLoadingTracker getPackageTracker() {
        throw new UnsupportedOperationException(Msg.code((int)2235));
    }

    public IWorkerContext setPackageTracker(IWorkerContextManager.IPackageLoadingTracker packageTracker) {
        throw new UnsupportedOperationException(Msg.code((int)2266));
    }

    public String getSpecUrl() {
        return "";
    }

    public PEBuilder getProfiledElementBuilder(PEBuilder.PEElementPropertiesPolicy thePEElementPropertiesPolicy, boolean theB) {
        throw new UnsupportedOperationException(Msg.code((int)2264));
    }

    public PackageInformation getPackageForUrl(String s) {
        throw new UnsupportedOperationException(Msg.code((int)2236));
    }

    public Parameters getExpansionParameters() {
        return this.myExpansionProfile;
    }

    public void setExpansionParameters(Parameters expParameters) {
        this.setExpansionProfile(expParameters);
    }

    public void setExpansionProfile(Parameters expParameters) {
        this.myExpansionProfile = expParameters;
    }

    private List<StructureDefinition> allStructures() {
        List<StructureDefinition> retVal = this.myAllStructures;
        if (retVal == null) {
            retVal = new ArrayList<StructureDefinition>();
            for (IBaseResource next : this.myValidationSupportContext.getRootValidationSupport().fetchAllStructureDefinitions()) {
                try {
                    StructureDefinition converted = this.myVersionCanonicalizer.structureDefinitionToCanonical(next);
                    retVal.add(converted);
                }
                catch (FHIRException e) {
                    throw new InternalErrorException(Msg.code((int)659) + e);
                }
            }
            this.myAllStructures = retVal;
        }
        return retVal;
    }

    public void cacheResource(Resource res) {
    }

    public void cacheResourceFromPackage(Resource res, PackageInformation packageDetails) throws FHIRException {
    }

    public void cachePackage(PackageInformation packageInformation) {
    }

    @Nonnull
    private ValidationResult convertValidationResult(String theSystem, @Nullable IValidationSupport.CodeValidationResult theResult) {
        ValidationResult retVal = null;
        if (theResult != null) {
            String code = theResult.getCode();
            String display = theResult.getDisplay();
            String issueSeverityCode = theResult.getSeverityCode();
            String message = theResult.getMessage();
            ValidationMessage.IssueSeverity issueSeverity = null;
            if (issueSeverityCode != null) {
                issueSeverity = ValidationMessage.IssueSeverity.fromCode((String)issueSeverityCode);
            } else if (StringUtils.isNotBlank((CharSequence)message)) {
                issueSeverity = ValidationMessage.IssueSeverity.INFORMATION;
            }
            CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent = null;
            if (code != null) {
                conceptDefinitionComponent = new CodeSystem.ConceptDefinitionComponent().setCode(code).setDisplay(display);
            }
            retVal = new ValidationResult(issueSeverity, message, theSystem, theResult.getCodeSystemVersion(), conceptDefinitionComponent, display, this.getIssuesForCodeValidation(theResult.getCodeValidationIssues()));
        }
        if (retVal == null) {
            retVal = new ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Validation failed", null);
        }
        return retVal;
    }

    private List<OperationOutcome.OperationOutcomeIssueComponent> getIssuesForCodeValidation(List<IValidationSupport.CodeValidationIssue> codeValidationIssues) {
        ArrayList<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
        for (IValidationSupport.CodeValidationIssue codeValidationIssue : codeValidationIssues) {
            CodeableConcept codeableConcept = new CodeableConcept().setText(codeValidationIssue.getMessage());
            codeableConcept.addCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", this.getIssueCodingFromCodeValidationIssue(codeValidationIssue), null);
            OperationOutcome.OperationOutcomeIssueComponent issue = new OperationOutcome.OperationOutcomeIssueComponent().setSeverity(this.getIssueSeverityFromCodeValidationIssue(codeValidationIssue)).setCode(this.getIssueTypeFromCodeValidationIssue(codeValidationIssue)).setDetails(codeableConcept);
            issue.getDetails().setText(codeValidationIssue.getMessage());
            issue.addExtension().setUrl("http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id").setValue((DataType)new StringType("Terminology_PassThrough_TX_Message"));
            issues.add(issue);
        }
        return issues;
    }

    private String getIssueCodingFromCodeValidationIssue(IValidationSupport.CodeValidationIssue codeValidationIssue) {
        switch (codeValidationIssue.getCoding()) {
            case VS_INVALID: {
                return "vs-invalid";
            }
            case NOT_FOUND: {
                return "not-found";
            }
            case NOT_IN_VS: {
                return "not-in-vs";
            }
            case INVALID_CODE: {
                return "invalid-code";
            }
            case INVALID_DISPLAY: {
                return "invalid-display";
            }
        }
        return null;
    }

    private OperationOutcome.IssueType getIssueTypeFromCodeValidationIssue(IValidationSupport.CodeValidationIssue codeValidationIssue) {
        switch (codeValidationIssue.getCode()) {
            case NOT_FOUND: {
                return OperationOutcome.IssueType.NOTFOUND;
            }
            case CODE_INVALID: {
                return OperationOutcome.IssueType.CODEINVALID;
            }
            case INVALID: {
                return OperationOutcome.IssueType.INVALID;
            }
        }
        return null;
    }

    private OperationOutcome.IssueSeverity getIssueSeverityFromCodeValidationIssue(IValidationSupport.CodeValidationIssue codeValidationIssue) {
        switch (codeValidationIssue.getSeverity()) {
            case FATAL: {
                return OperationOutcome.IssueSeverity.FATAL;
            }
            case ERROR: {
                return OperationOutcome.IssueSeverity.ERROR;
            }
            case WARNING: {
                return OperationOutcome.IssueSeverity.WARNING;
            }
            case INFORMATION: {
                return OperationOutcome.IssueSeverity.INFORMATION;
            }
        }
        return null;
    }

    public ValueSetExpansionOutcome expandVS(ValueSet source, boolean cacheOk, boolean Hierarchical) {
        IBaseResource convertedSource;
        try {
            convertedSource = this.myVersionCanonicalizer.valueSetFromValidatorCanonical(source);
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)661) + e);
        }
        IValidationSupport.ValueSetExpansionOutcome expanded = this.myValidationSupportContext.getRootValidationSupport().expandValueSet(this.myValidationSupportContext, null, convertedSource);
        ValueSet convertedResult = null;
        if (expanded.getValueSet() != null) {
            try {
                convertedResult = this.myVersionCanonicalizer.valueSetToValidatorCanonical(expanded.getValueSet());
            }
            catch (FHIRException e) {
                throw new InternalErrorException(Msg.code((int)662) + e);
            }
        }
        String error = expanded.getError();
        TerminologyServiceErrorClass result = null;
        return new ValueSetExpansionOutcome(convertedResult, error, result, expanded.getErrorIsFromServer());
    }

    public ValueSetExpansionOutcome expandVS(Resource src, ElementDefinition.ElementDefinitionBindingComponent binding, boolean cacheOk, boolean Hierarchical) {
        ValueSet valueSet = this.fetchResource(ValueSet.class, binding.getValueSet(), src);
        return this.expandVS(valueSet, cacheOk, Hierarchical);
    }

    public ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent inc, boolean hierarchical, boolean noInactive) throws TerminologyServiceException {
        throw new UnsupportedOperationException(Msg.code((int)664));
    }

    public Locale getLocale() {
        return this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getLocalizer().getLocale();
    }

    public void setLocale(Locale locale) {
    }

    public CodeSystem fetchCodeSystem(String system) {
        IBaseResource fetched = this.myValidationSupportContext.getRootValidationSupport().fetchCodeSystem(system);
        if (fetched == null) {
            return null;
        }
        try {
            return this.myVersionCanonicalizer.codeSystemToValidatorCanonical(fetched);
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)665) + e);
        }
    }

    public CodeSystem fetchCodeSystem(String system, String verison) {
        IBaseResource fetched = this.myValidationSupportContext.getRootValidationSupport().fetchCodeSystem(system);
        if (fetched == null) {
            return null;
        }
        try {
            return this.myVersionCanonicalizer.codeSystemToValidatorCanonical(fetched);
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)1992) + e);
        }
    }

    public CodeSystem fetchCodeSystem(String system, FhirPublication fhirVersion) {
        return null;
    }

    public CodeSystem fetchCodeSystem(String system, String version, FhirPublication fhirVersion) {
        return null;
    }

    public CodeSystem fetchSupplementedCodeSystem(String system) {
        return null;
    }

    public CodeSystem fetchSupplementedCodeSystem(String system, String version) {
        return null;
    }

    public CodeSystem fetchSupplementedCodeSystem(String system, FhirPublication fhirVersion) {
        return null;
    }

    public CodeSystem fetchSupplementedCodeSystem(String system, String version, FhirPublication fhirVersion) {
        return null;
    }

    public <T extends Resource> T fetchResourceRaw(Class<T> class_, String uri) {
        return this.fetchResource(class_, uri);
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String theUri) {
        if (StringUtils.isBlank((CharSequence)theUri)) {
            return null;
        }
        String uri = theUri;
        if (theUri.contains("|")) {
            String[] parts = theUri.split("\\|");
            if (parts.length == 2) {
                uri = parts[0];
            } else {
                ourLog.warn("Unrecognized profile uri: {}", (Object)theUri);
            }
        }
        ResourceKey key = new ResourceKey(class_.getSimpleName(), uri);
        Resource retVal = (Resource)this.myFetchResourceCache.get((Object)key);
        return (T)retVal;
    }

    public Resource fetchResourceById(String type, String uri) {
        throw new UnsupportedOperationException(Msg.code((int)666));
    }

    public Resource fetchResourceById(String type, String uri, FhirPublication fhirVersion) {
        return null;
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri) throws FHIRException {
        T retVal = this.fetchResource(class_, uri);
        if (retVal == null) {
            throw new FHIRException(Msg.code((int)667) + "Can not find resource of type " + class_.getSimpleName() + " with uri " + uri);
        }
        return retVal;
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, String version) {
        return this.fetchResource(class_, uri + "|" + version);
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, FhirPublication fhirVersion) {
        return null;
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, String version, FhirPublication fhirVersion) {
        return null;
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, Resource canonicalForSource) {
        return this.fetchResource(class_, uri);
    }

    public <T extends Resource> List<T> fetchResourcesByType(Class<T> class_, FhirPublication fhirVersion) {
        return null;
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri, Resource sourceOfReference) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)2214));
    }

    public List<String> getResourceNames() {
        return new ArrayList<String>(this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getResourceTypes());
    }

    public List<String> getResourceNames(FhirPublication fhirVersion) {
        return null;
    }

    public Set<String> getResourceNamesAsSet() {
        return this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getResourceTypes();
    }

    public Set<String> getResourceNamesAsSet(FhirPublication theFhirVersion) {
        return null;
    }

    public StructureDefinition fetchTypeDefinition(String theTypeName) {
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + theTypeName);
    }

    public StructureDefinition fetchTypeDefinition(String theTypeName, FhirPublication theFhirVersion) {
        return null;
    }

    public List<StructureDefinition> fetchTypeDefinitions(String theTypeName) {
        ArrayList<StructureDefinition> allStructures = new ArrayList<StructureDefinition>(this.allStructures());
        allStructures.removeIf(sd -> !sd.hasType() || !sd.getType().equals(theTypeName));
        return allStructures;
    }

    public List<StructureDefinition> fetchTypeDefinitions(String theTypeName, FhirPublication theFhirVersion) {
        return null;
    }

    public boolean isPrimitiveType(String theType) {
        ArrayList<StructureDefinition> allStructures = new ArrayList<StructureDefinition>(this.allStructures());
        return allStructures.stream().filter(structureDefinition -> structureDefinition.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE).anyMatch(structureDefinition -> theType.equals(structureDefinition.getName()));
    }

    public boolean isDataType(String theType) {
        return !this.isPrimitiveType(theType);
    }

    public UcumService getUcumService() {
        throw new UnsupportedOperationException(Msg.code((int)676));
    }

    public void setUcumService(UcumService ucumService) {
        throw new UnsupportedOperationException(Msg.code((int)677));
    }

    public String getVersion() {
        return this.myValidationSupportContext.getRootValidationSupport().getFhirContext().getVersion().getVersion().getFhirVersionString();
    }

    public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return false;
        }
        ResourceKey key = new ResourceKey(class_.getSimpleName(), uri);
        return this.myFetchResourceCache.get((Object)key) != null;
    }

    public <T extends Resource> boolean hasResource(Class<T> class_, String uri, Resource sourceOfReference) {
        return false;
    }

    public <T extends Resource> boolean hasResource(Class<T> class_, String uri, FhirPublication fhirVersion) {
        return false;
    }

    public boolean isNoTerminologyServer() {
        return false;
    }

    public Set<String> getCodeSystemsUsed() {
        throw new UnsupportedOperationException(Msg.code((int)681));
    }

    public IResourceValidator newValidator() {
        throw new UnsupportedOperationException(Msg.code((int)684));
    }

    public Map<String, NamingSystem> getNSUrlMap() {
        throw new UnsupportedOperationException(Msg.code((int)2265));
    }

    public ILoggingService getLogger() {
        return null;
    }

    public void setLogger(ILoggingService logger) {
        throw new UnsupportedOperationException(Msg.code((int)687));
    }

    public boolean supportsSystem(String system) {
        return this.myValidationSupportContext.getRootValidationSupport().isCodeSystemSupported(this.myValidationSupportContext, system);
    }

    public boolean supportsSystem(String system, FhirPublication fhirVersion) throws TerminologyServiceException {
        return this.supportsSystem(system);
    }

    public ValueSetExpansionOutcome expandVS(ValueSet source, boolean cacheOk, boolean heiarchical, boolean incompleteOk) {
        return null;
    }

    public ValidationResult validateCode(ValidationOptions theOptions, String system, String version, String code, String display) {
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions);
        return this.doValidation(null, validationOptions, system, code, display);
    }

    public ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String version, String theCode, String display, ValueSet theValueSet) {
        IBaseResource convertedVs = null;
        try {
            if (theValueSet != null) {
                convertedVs = this.myVersionCanonicalizer.valueSetFromValidatorCanonical(theValueSet);
            }
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)689) + e);
        }
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions);
        return this.doValidation(convertedVs, validationOptions, theSystem, theCode, display);
    }

    public ValidationResult validateCode(ValidationOptions theOptions, String code, ValueSet theValueSet) {
        IBaseResource convertedVs = null;
        try {
            if (theValueSet != null) {
                convertedVs = this.myVersionCanonicalizer.valueSetFromValidatorCanonical(theValueSet);
            }
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)690) + e);
        }
        String system = ValidationSupportUtils.extractCodeSystemForCode((IBaseResource)theValueSet, code);
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions).setInferSystem(true);
        return this.doValidation(convertedVs, validationOptions, system, code, null);
    }

    public ValidationResult validateCode(ValidationOptions theOptions, Coding theCoding, ValueSet theValueSet) {
        IBaseResource convertedVs = null;
        try {
            if (theValueSet != null) {
                convertedVs = this.myVersionCanonicalizer.valueSetFromValidatorCanonical(theValueSet);
            }
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)691) + e);
        }
        ConceptValidationOptions validationOptions = VersionSpecificWorkerContextWrapper.convertConceptValidationOptions(theOptions);
        String system = theCoding.getSystem();
        String code = theCoding.getCode();
        String display = theCoding.getDisplay();
        return this.doValidation(convertedVs, validationOptions, system, code, display);
    }

    public ValidationResult validateCode(ValidationOptions options, Coding code, ValueSet vs, ValidationContextCarrier ctxt) {
        return this.validateCode(options, code, vs);
    }

    public void validateCodeBatch(ValidationOptions options, List<? extends CodingValidationRequest> codes, ValueSet vs) {
        for (CodingValidationRequest codingValidationRequest : codes) {
            ValidationResult outcome = this.validateCode(options, codingValidationRequest.getCoding(), vs);
            codingValidationRequest.setResult(outcome);
        }
    }

    public void validateCodeBatchByRef(ValidationOptions validationOptions, List<? extends CodingValidationRequest> list, String s) {
        ValueSet valueSet = this.fetchResource(ValueSet.class, s);
        this.validateCodeBatch(validationOptions, list, valueSet);
    }

    @Nonnull
    private ValidationResult doValidation(IBaseResource theValueSet, ConceptValidationOptions theValidationOptions, String theSystem, String theCode, String theDisplay) {
        IValidationSupport.CodeValidationResult result = theValueSet != null ? this.validateCodeInValueSet(theValueSet, theValidationOptions, theSystem, theCode, theDisplay) : this.validateCodeInCodeSystem(theValidationOptions, theSystem, theCode, theDisplay);
        return this.convertValidationResult(theSystem, result);
    }

    private IValidationSupport.CodeValidationResult validateCodeInValueSet(IBaseResource theValueSet, ConceptValidationOptions theValidationOptions, String theSystem, String theCode, String theDisplay) {
        IValidationSupport.CodeValidationResult result = this.myValidationSupportContext.getRootValidationSupport().validateCodeInValueSet(this.myValidationSupportContext, theValidationOptions, theSystem, theCode, theDisplay, theValueSet);
        if (result != null) {
            IValidationSupport.CodeValidationResult codeSystemResult = this.validateCodeInCodeSystem(theValidationOptions, theSystem, theCode, theDisplay);
            boolean valueSetResultContainsInvalidDisplay = result.getCodeValidationIssues().stream().anyMatch(codeValidationIssue -> codeValidationIssue.getCoding() == IValidationSupport.CodeValidationIssueCoding.INVALID_DISPLAY);
            if (codeSystemResult != null) {
                for (IValidationSupport.CodeValidationIssue codeValidationIssue2 : codeSystemResult.getCodeValidationIssues()) {
                    if (codeValidationIssue2.getCoding() == IValidationSupport.CodeValidationIssueCoding.INVALID_DISPLAY && valueSetResultContainsInvalidDisplay) continue;
                    result.addCodeValidationIssue(codeValidationIssue2);
                }
            }
        }
        return result;
    }

    private IValidationSupport.CodeValidationResult validateCodeInCodeSystem(ConceptValidationOptions theValidationOptions, String theSystem, String theCode, String theDisplay) {
        return this.myValidationSupportContext.getRootValidationSupport().validateCode(this.myValidationSupportContext, theValidationOptions, theSystem, theCode, theDisplay, null);
    }

    public ValidationResult validateCode(ValidationOptions theOptions, CodeableConcept code, ValueSet theVs) {
        ArrayList<ValidationResult> validationResultsOk = new ArrayList<ValidationResult>();
        ArrayList<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
        for (Coding next : code.getCoding()) {
            ValidationResult retVal;
            if (!next.hasSystem()) {
                String message = "Coding has no system. A code with no system has no defined meaning, and it cannot be validated. A system should be provided";
                OperationOutcome.OperationOutcomeIssueComponent issue = new OperationOutcome.OperationOutcomeIssueComponent().setSeverity(OperationOutcome.IssueSeverity.WARNING).setCode(OperationOutcome.IssueType.NOTFOUND).setDiagnostics(message).setDetails(new CodeableConcept().setText(message));
                issues.add(issue);
            }
            if ((retVal = this.validateCode(theOptions, next, theVs)).isOk()) {
                validationResultsOk.add(retVal);
                continue;
            }
            for (OperationOutcome.OperationOutcomeIssueComponent issue : retVal.getIssues()) {
                issues.add(issue);
            }
        }
        if (code.getCoding().size() > 0 && (!this.myValidationSupportContext.isEnabledValidationForCodingsLogicalAnd() ? validationResultsOk.size() == code.getCoding().size() : validationResultsOk.size() > 0)) {
            return (ValidationResult)validationResultsOk.get(0);
        }
        return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, null, issues);
    }

    private static OperationOutcome.OperationOutcomeIssueComponent getOperationOutcomeTxIssueComponent(String message, OperationOutcome.IssueType issueCode, String txIssueTypeCode) {
        OperationOutcome.OperationOutcomeIssueComponent issue = new OperationOutcome.OperationOutcomeIssueComponent().setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics(message);
        issue.getDetails().setText(message);
        issue.setCode(issueCode);
        issue.getDetails().addCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", txIssueTypeCode, null);
        return issue;
    }

    public void invalidateCaches() {
        this.myFetchResourceCache.invalidateAll();
    }

    public <T extends Resource> List<T> fetchResourcesByType(Class<T> theClass) {
        if (theClass.equals(StructureDefinition.class)) {
            return this.allStructures();
        }
        throw new UnsupportedOperationException(Msg.code((int)650) + "Unable to fetch resources of type: " + theClass);
    }

    public <T extends Resource> List<T> fetchResourcesByUrl(Class<T> class_, String url) {
        throw new UnsupportedOperationException(Msg.code((int)2509) + "Can't fetch all resources of url: " + url);
    }

    public boolean isForPublication() {
        return false;
    }

    public void setForPublication(boolean b) {
        throw new UnsupportedOperationException(Msg.code((int)2351));
    }

    public IWorkerContext.OIDSummary urlsForOid(String oid, String resourceType) {
        return null;
    }

    public <T extends Resource> T findTxResource(Class<T> class_, String canonical, Resource sourceOfReference) {
        if (canonical == null) {
            return null;
        }
        return this.fetchResource(class_, canonical, sourceOfReference);
    }

    public <T extends Resource> T findTxResource(Class<T> class_, String canonical) {
        if (canonical == null) {
            return null;
        }
        return this.fetchResource(class_, canonical);
    }

    public <T extends Resource> T findTxResource(Class<T> class_, String canonical, String version) {
        if (canonical == null) {
            return null;
        }
        return this.fetchResource(class_, canonical, version);
    }

    public static ConceptValidationOptions convertConceptValidationOptions(ValidationOptions theOptions) {
        ConceptValidationOptions retVal = new ConceptValidationOptions();
        if (theOptions.isGuessSystem()) {
            retVal = retVal.setInferSystem(true);
        }
        return retVal;
    }

    @Nonnull
    public static VersionSpecificWorkerContextWrapper newVersionSpecificWorkerContextWrapper(IValidationSupport theValidationSupport) {
        VersionCanonicalizer versionCanonicalizer = new VersionCanonicalizer(theValidationSupport.getFhirContext());
        return new VersionSpecificWorkerContextWrapper(new ValidationSupportContext(theValidationSupport), versionCanonicalizer);
    }

    public Boolean subsumes(ValidationOptions optionsArg, Coding parent, Coding child) {
        throw new UnsupportedOperationException(Msg.code((int)2489));
    }

    public boolean isServerSideSystem(String url) {
        return false;
    }

    private static class ResourceKey {
        private final int myHashCode;
        private final String myResourceName;
        private final String myUri;

        private ResourceKey(String theResourceName, String theUri) {
            this.myResourceName = theResourceName;
            this.myUri = theUri;
            this.myHashCode = new HashCodeBuilder(17, 37).append((Object)this.myResourceName).append((Object)this.myUri).toHashCode();
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (theO == null || this.getClass() != theO.getClass()) {
                return false;
            }
            ResourceKey that = (ResourceKey)theO;
            return new EqualsBuilder().append((Object)this.myResourceName, (Object)that.myResourceName).append((Object)this.myUri, (Object)that.myUri).isEquals();
        }

        public String getResourceName() {
            return this.myResourceName;
        }

        public String getUri() {
            return this.myUri;
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }
}

