/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Narrative;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Composition", profile="http://hl7.org/fhir/Profile/Composition")
public class Composition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical identifier of composition (version-independent)", formalDefinition="Logical identifier for the composition, assigned when created. This identifier stays constant as the composition is changed over time.")
    protected Identifier identifier;
    @Child(name="date", type={DateTimeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Composition editing time", formalDefinition="The composition editing time, when the composition was last logically changed by the author.")
    protected DateTimeType date;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of composition (LOINC if possible)", formalDefinition="Specifies the particular kind of composition (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the composition.")
    protected CodeableConcept type;
    @Child(name="class", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Categorization of Composition", formalDefinition="A categorization for the type of the composition - helps for indexing and searching. This may be implied by or derived from the code specified in the Composition Type.")
    protected CodeableConcept class_;
    @Child(name="title", type={StringType.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human Readable name/title", formalDefinition="Official human-readable label for the composition.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="preliminary | final | amended | entered-in-error", formalDefinition="The workflow/clinical status of this composition. The status is a marker for the clinical standing of the document.")
    protected Enumeration<CompositionStatus> status;
    @Child(name="confidentiality", type={CodeType.class}, order=6, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="As defined by affinity domain", formalDefinition="The code specifying the level of confidentiality of the Composition.")
    protected CodeType confidentiality;
    @Child(name="subject", type={}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what the composition is about", formalDefinition="Who or what the composition is about. The composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="author", type={Practitioner.class, Device.class, Patient.class, RelatedPerson.class}, order=8, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what authored the composition", formalDefinition="Identifies who is responsible for the information in the composition, not necessarily who typed it in.")
    protected List<Reference> author;
    protected List<Resource> authorTarget;
    @Child(name="attester", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Attests to accuracy of composition", formalDefinition="A participant who has attested to the accuracy of the composition/document.")
    protected List<CompositionAttesterComponent> attester;
    @Child(name="custodian", type={Organization.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization which maintains the composition", formalDefinition="Identifies the organization or group who is responsible for ongoing maintenance of and access to the composition/document information.")
    protected Reference custodian;
    protected Organization custodianTarget;
    @Child(name="event", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The clinical service(s) being documented", formalDefinition="The clinical service, such as a colonoscopy or an appendectomy, being documented.")
    protected List<CompositionEventComponent> event;
    @Child(name="encounter", type={Encounter.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Context of the Composition", formalDefinition="Describes the clinical encounter or type of care this documentation is associated with.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="section", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Composition is broken into sections", formalDefinition="The root of the sections that make up the composition.")
    protected List<SectionComponent> section;
    private static final long serialVersionUID = 2127852326L;
    @SearchParamDefinition(name="date", path="Composition.date", description="Composition editing time", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="identifier", path="Composition.identifier", description="Logical identifier of composition (version-independent)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="period", path="Composition.event.period", description="The period covered by the documentation", type="date")
    public static final String SP_PERIOD = "period";
    @SearchParamDefinition(name="subject", path="Composition.subject", description="Who and/or what the composition is about", type="reference")
    public static final String SP_SUBJECT = "subject";
    @SearchParamDefinition(name="author", path="Composition.author", description="Who and/or what authored the composition", type="reference")
    public static final String SP_AUTHOR = "author";
    @SearchParamDefinition(name="confidentiality", path="Composition.confidentiality", description="As defined by affinity domain", type="token")
    public static final String SP_CONFIDENTIALITY = "confidentiality";
    @SearchParamDefinition(name="section", path="Composition.section.code", description="Classification of section (recommended)", type="token")
    public static final String SP_SECTION = "section";
    @SearchParamDefinition(name="encounter", path="Composition.encounter", description="Context of the Composition", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    @SearchParamDefinition(name="type", path="Composition.type", description="Kind of composition (LOINC if possible)", type="token")
    public static final String SP_TYPE = "type";
    @SearchParamDefinition(name="title", path="Composition.title", description="Human Readable name/title", type="string")
    public static final String SP_TITLE = "title";
    @SearchParamDefinition(name="attester", path="Composition.attester.party", description="Who attested the composition", type="reference")
    public static final String SP_ATTESTER = "attester";
    @SearchParamDefinition(name="entry", path="Composition.section.entry", description="A reference to data that supports this section", type="reference")
    public static final String SP_ENTRY = "entry";
    @SearchParamDefinition(name="patient", path="Composition.subject", description="Who and/or what the composition is about", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="context", path="Composition.event.code", description="Code(s) that apply to the event being documented", type="token")
    public static final String SP_CONTEXT = "context";
    @SearchParamDefinition(name="class", path="Composition.class", description="Categorization of Composition", type="token")
    public static final String SP_CLASS = "class";
    @SearchParamDefinition(name="status", path="Composition.status", description="preliminary | final | amended | entered-in-error", type="token")
    public static final String SP_STATUS = "status";

    public Composition() {
    }

    public Composition(DateTimeType date, CodeableConcept type, StringType title, Enumeration<CompositionStatus> status, Reference subject) {
        this.date = date;
        this.type = type;
        this.title = title;
        this.status = status;
        this.subject = subject;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public Composition setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public Composition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public Composition setDate(Date value) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(value);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Composition setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getClass_() {
        if (this.class_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.class_");
            }
            if (Configuration.doAutoCreate()) {
                this.class_ = new CodeableConcept();
            }
        }
        return this.class_;
    }

    public boolean hasClass_() {
        return this.class_ != null && !this.class_.isEmpty();
    }

    public Composition setClass_(CodeableConcept value) {
        this.class_ = value;
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public Composition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public Composition setTitle(String value) {
        if (this.title == null) {
            this.title = new StringType();
        }
        this.title.setValue(value);
        return this;
    }

    public Enumeration<CompositionStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<CompositionStatus>(new CompositionStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Composition setStatusElement(Enumeration<CompositionStatus> value) {
        this.status = value;
        return this;
    }

    public CompositionStatus getStatus() {
        return this.status == null ? null : (CompositionStatus)((Object)this.status.getValue());
    }

    public Composition setStatus(CompositionStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<CompositionStatus>(new CompositionStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeType getConfidentialityElement() {
        if (this.confidentiality == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.confidentiality");
            }
            if (Configuration.doAutoCreate()) {
                this.confidentiality = new CodeType();
            }
        }
        return this.confidentiality;
    }

    public boolean hasConfidentialityElement() {
        return this.confidentiality != null && !this.confidentiality.isEmpty();
    }

    public boolean hasConfidentiality() {
        return this.confidentiality != null && !this.confidentiality.isEmpty();
    }

    public Composition setConfidentialityElement(CodeType value) {
        this.confidentiality = value;
        return this;
    }

    public String getConfidentiality() {
        return this.confidentiality == null ? null : (String)this.confidentiality.getValue();
    }

    public Composition setConfidentiality(String value) {
        if (Utilities.noString((String)value)) {
            this.confidentiality = null;
        } else {
            if (this.confidentiality == null) {
                this.confidentiality = new CodeType();
            }
            this.confidentiality.setValue(value);
        }
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Composition setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Composition setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (Reference item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAuthor() {
        Reference t = new Reference();
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return t;
    }

    public Composition addAuthor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return this;
    }

    public List<Resource> getAuthorTarget() {
        if (this.authorTarget == null) {
            this.authorTarget = new ArrayList<Resource>();
        }
        return this.authorTarget;
    }

    public List<CompositionAttesterComponent> getAttester() {
        if (this.attester == null) {
            this.attester = new ArrayList<CompositionAttesterComponent>();
        }
        return this.attester;
    }

    public boolean hasAttester() {
        if (this.attester == null) {
            return false;
        }
        for (CompositionAttesterComponent item : this.attester) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CompositionAttesterComponent addAttester() {
        CompositionAttesterComponent t = new CompositionAttesterComponent();
        if (this.attester == null) {
            this.attester = new ArrayList<CompositionAttesterComponent>();
        }
        this.attester.add(t);
        return t;
    }

    public Composition addAttester(CompositionAttesterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.attester == null) {
            this.attester = new ArrayList<CompositionAttesterComponent>();
        }
        this.attester.add(t);
        return this;
    }

    public Reference getCustodian() {
        if (this.custodian == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.custodian");
            }
            if (Configuration.doAutoCreate()) {
                this.custodian = new Reference();
            }
        }
        return this.custodian;
    }

    public boolean hasCustodian() {
        return this.custodian != null && !this.custodian.isEmpty();
    }

    public Composition setCustodian(Reference value) {
        this.custodian = value;
        return this;
    }

    public Organization getCustodianTarget() {
        if (this.custodianTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.custodian");
            }
            if (Configuration.doAutoCreate()) {
                this.custodianTarget = new Organization();
            }
        }
        return this.custodianTarget;
    }

    public Composition setCustodianTarget(Organization value) {
        this.custodianTarget = value;
        return this;
    }

    public List<CompositionEventComponent> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<CompositionEventComponent>();
        }
        return this.event;
    }

    public boolean hasEvent() {
        if (this.event == null) {
            return false;
        }
        for (CompositionEventComponent item : this.event) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CompositionEventComponent addEvent() {
        CompositionEventComponent t = new CompositionEventComponent();
        if (this.event == null) {
            this.event = new ArrayList<CompositionEventComponent>();
        }
        this.event.add(t);
        return t;
    }

    public Composition addEvent(CompositionEventComponent t) {
        if (t == null) {
            return this;
        }
        if (this.event == null) {
            this.event = new ArrayList<CompositionEventComponent>();
        }
        this.event.add(t);
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Composition setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public Composition setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public List<SectionComponent> getSection() {
        if (this.section == null) {
            this.section = new ArrayList<SectionComponent>();
        }
        return this.section;
    }

    public boolean hasSection() {
        if (this.section == null) {
            return false;
        }
        for (SectionComponent item : this.section) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SectionComponent addSection() {
        SectionComponent t = new SectionComponent();
        if (this.section == null) {
            this.section = new ArrayList<SectionComponent>();
        }
        this.section.add(t);
        return t;
    }

    public Composition addSection(SectionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.section == null) {
            this.section = new ArrayList<SectionComponent>();
        }
        this.section.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Logical identifier for the composition, assigned when created. This identifier stays constant as the composition is changed over time.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_DATE, "dateTime", "The composition editing time, when the composition was last logically changed by the author.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "Specifies the particular kind of composition (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the composition.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_CLASS, "CodeableConcept", "A categorization for the type of the composition - helps for indexing and searching. This may be implied by or derived from the code specified in the Composition Type.", 0, Integer.MAX_VALUE, this.class_));
        childrenList.add(new Property(SP_TITLE, "string", "Official human-readable label for the composition.", 0, Integer.MAX_VALUE, this.title));
        childrenList.add(new Property(SP_STATUS, "code", "The workflow/clinical status of this composition. The status is a marker for the clinical standing of the document.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_CONFIDENTIALITY, "code", "The code specifying the level of confidentiality of the Composition.", 0, Integer.MAX_VALUE, this.confidentiality));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Any)", "Who or what the composition is about. The composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_AUTHOR, "Reference(Practitioner|Device|Patient|RelatedPerson)", "Identifies who is responsible for the information in the composition, not necessarily who typed it in.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property(SP_ATTESTER, "", "A participant who has attested to the accuracy of the composition/document.", 0, Integer.MAX_VALUE, this.attester));
        childrenList.add(new Property("custodian", "Reference(Organization)", "Identifies the organization or group who is responsible for ongoing maintenance of and access to the composition/document information.", 0, Integer.MAX_VALUE, this.custodian));
        childrenList.add(new Property("event", "", "The clinical service, such as a colonoscopy or an appendectomy, being documented.", 0, Integer.MAX_VALUE, this.event));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "Describes the clinical encounter or type of care this documentation is associated with.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property(SP_SECTION, "", "The root of the sections that make up the composition.", 0, Integer.MAX_VALUE, this.section));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CLASS)) {
            this.class_ = this.castToCodeableConcept(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new CompositionStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_CONFIDENTIALITY)) {
            this.confidentiality = this.castToCode(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.getAuthor().add(this.castToReference(value));
        } else if (name.equals(SP_ATTESTER)) {
            this.getAttester().add((CompositionAttesterComponent)value);
        } else if (name.equals("custodian")) {
            this.custodian = this.castToReference(value);
        } else if (name.equals("event")) {
            this.getEvent().add((CompositionEventComponent)value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals(SP_SECTION)) {
            this.getSection().add((SectionComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.date");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_CLASS)) {
            this.class_ = new CodeableConcept();
            return this.class_;
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.status");
        }
        if (name.equals(SP_CONFIDENTIALITY)) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.confidentiality");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_AUTHOR)) {
            return this.addAuthor();
        }
        if (name.equals(SP_ATTESTER)) {
            return this.addAttester();
        }
        if (name.equals("custodian")) {
            this.custodian = new Reference();
            return this.custodian;
        }
        if (name.equals("event")) {
            return this.addEvent();
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_SECTION)) {
            return this.addSection();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Composition";
    }

    @Override
    public Composition copy() {
        Composition dst = new Composition();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.class_ = this.class_ == null ? null : this.class_.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.confidentiality = this.confidentiality == null ? null : this.confidentiality.copy();
        Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.author != null) {
            dst.author = new ArrayList<Reference>();
            for (Reference reference2 : this.author) {
                dst.author.add(reference2.copy());
            }
        }
        if (this.attester != null) {
            dst.attester = new ArrayList<CompositionAttesterComponent>();
            for (CompositionAttesterComponent compositionAttesterComponent : this.attester) {
                dst.attester.add(compositionAttesterComponent.copy());
            }
        }
        Reference reference3 = dst.custodian = this.custodian == null ? null : this.custodian.copy();
        if (this.event != null) {
            dst.event = new ArrayList<CompositionEventComponent>();
            for (CompositionEventComponent compositionEventComponent : this.event) {
                dst.event.add(compositionEventComponent.copy());
            }
        }
        Reference reference4 = dst.encounter = this.encounter == null ? null : this.encounter.copy();
        if (this.section != null) {
            dst.section = new ArrayList<SectionComponent>();
            for (SectionComponent sectionComponent : this.section) {
                dst.section.add(sectionComponent.copy());
            }
        }
        return dst;
    }

    protected Composition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Composition)) {
            return false;
        }
        Composition o = (Composition)other;
        return Composition.compareDeep(this.identifier, o.identifier, true) && Composition.compareDeep(this.date, o.date, true) && Composition.compareDeep(this.type, o.type, true) && Composition.compareDeep(this.class_, o.class_, true) && Composition.compareDeep(this.title, o.title, true) && Composition.compareDeep(this.status, o.status, true) && Composition.compareDeep(this.confidentiality, o.confidentiality, true) && Composition.compareDeep(this.subject, o.subject, true) && Composition.compareDeep(this.author, o.author, true) && Composition.compareDeep(this.attester, o.attester, true) && Composition.compareDeep(this.custodian, o.custodian, true) && Composition.compareDeep(this.event, o.event, true) && Composition.compareDeep(this.encounter, o.encounter, true) && Composition.compareDeep(this.section, o.section, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Composition)) {
            return false;
        }
        Composition o = (Composition)other;
        return Composition.compareValues(this.date, o.date, true) && Composition.compareValues(this.title, o.title, true) && Composition.compareValues(this.status, o.status, true) && Composition.compareValues(this.confidentiality, o.confidentiality, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.date != null && !this.date.isEmpty() || this.type != null && !this.type.isEmpty() || this.class_ != null && !this.class_.isEmpty() || this.title != null && !this.title.isEmpty() || this.status != null && !this.status.isEmpty() || this.confidentiality != null && !this.confidentiality.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.author != null && !this.author.isEmpty() || this.attester != null && !this.attester.isEmpty() || this.custodian != null && !this.custodian.isEmpty() || this.event != null && !this.event.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.section != null && !this.section.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Composition;
    }

    @Block
    public static class SectionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for section (e.g. for ToC)", formalDefinition="The label for this particular section.  This will be part of the rendered content for the document, and is often used to build a table of contents.")
        protected StringType title;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Classification of section (recommended)", formalDefinition="A code identifying the kind of content contained within the section. This must be consistent with the section title.")
        protected CodeableConcept code;
        @Child(name="text", type={Narrative.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text summary of the section, for human interpretation", formalDefinition="A human-readable narrative that contains the attested content of the section, used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative.")
        protected Narrative text;
        @Child(name="mode", type={CodeType.class}, order=4, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="working | snapshot | changes", formalDefinition="How the entry list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.")
        protected CodeType mode;
        @Child(name="orderedBy", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Order of section entries", formalDefinition="Specifies the order applied to the items in the section entries.")
        protected CodeableConcept orderedBy;
        @Child(name="entry", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A reference to data that supports this section", formalDefinition="A reference to the actual resource from which the narrative in the section is derived.")
        protected List<Reference> entry;
        protected List<Resource> entryTarget;
        @Child(name="emptyReason", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Why the section is empty", formalDefinition="If the section is empty, why the list is empty. An empty section typically has some text explaining the empty reason.")
        protected CodeableConcept emptyReason;
        @Child(name="section", type={SectionComponent.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Section", formalDefinition="A nested sub-section within this section.")
        protected List<SectionComponent> section;
        private static final long serialVersionUID = -726390626L;

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public SectionComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public SectionComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SectionComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Narrative getText() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new Narrative();
                }
            }
            return this.text;
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public SectionComponent setText(Narrative value) {
            this.text = value;
            return this;
        }

        public CodeType getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new CodeType();
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public SectionComponent setModeElement(CodeType value) {
            this.mode = value;
            return this;
        }

        public String getMode() {
            return this.mode == null ? null : (String)this.mode.getValue();
        }

        public SectionComponent setMode(String value) {
            if (Utilities.noString((String)value)) {
                this.mode = null;
            } else {
                if (this.mode == null) {
                    this.mode = new CodeType();
                }
                this.mode.setValue(value);
            }
            return this;
        }

        public CodeableConcept getOrderedBy() {
            if (this.orderedBy == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.orderedBy");
                }
                if (Configuration.doAutoCreate()) {
                    this.orderedBy = new CodeableConcept();
                }
            }
            return this.orderedBy;
        }

        public boolean hasOrderedBy() {
            return this.orderedBy != null && !this.orderedBy.isEmpty();
        }

        public SectionComponent setOrderedBy(CodeableConcept value) {
            this.orderedBy = value;
            return this;
        }

        public List<Reference> getEntry() {
            if (this.entry == null) {
                this.entry = new ArrayList<Reference>();
            }
            return this.entry;
        }

        public boolean hasEntry() {
            if (this.entry == null) {
                return false;
            }
            for (Reference item : this.entry) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addEntry() {
            Reference t = new Reference();
            if (this.entry == null) {
                this.entry = new ArrayList<Reference>();
            }
            this.entry.add(t);
            return t;
        }

        public SectionComponent addEntry(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.entry == null) {
                this.entry = new ArrayList<Reference>();
            }
            this.entry.add(t);
            return this;
        }

        public List<Resource> getEntryTarget() {
            if (this.entryTarget == null) {
                this.entryTarget = new ArrayList<Resource>();
            }
            return this.entryTarget;
        }

        public CodeableConcept getEmptyReason() {
            if (this.emptyReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.emptyReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.emptyReason = new CodeableConcept();
                }
            }
            return this.emptyReason;
        }

        public boolean hasEmptyReason() {
            return this.emptyReason != null && !this.emptyReason.isEmpty();
        }

        public SectionComponent setEmptyReason(CodeableConcept value) {
            this.emptyReason = value;
            return this;
        }

        public List<SectionComponent> getSection() {
            if (this.section == null) {
                this.section = new ArrayList<SectionComponent>();
            }
            return this.section;
        }

        public boolean hasSection() {
            if (this.section == null) {
                return false;
            }
            for (SectionComponent item : this.section) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SectionComponent addSection() {
            SectionComponent t = new SectionComponent();
            if (this.section == null) {
                this.section = new ArrayList<SectionComponent>();
            }
            this.section.add(t);
            return t;
        }

        public SectionComponent addSection(SectionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.section == null) {
                this.section = new ArrayList<SectionComponent>();
            }
            this.section.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Composition.SP_TITLE, "string", "The label for this particular section.  This will be part of the rendered content for the document, and is often used to build a table of contents.", 0, Integer.MAX_VALUE, this.title));
            childrenList.add(new Property("code", "CodeableConcept", "A code identifying the kind of content contained within the section. This must be consistent with the section title.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("text", "Narrative", "A human-readable narrative that contains the attested content of the section, used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative.", 0, Integer.MAX_VALUE, this.text));
            childrenList.add(new Property("mode", "code", "How the entry list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.", 0, Integer.MAX_VALUE, this.mode));
            childrenList.add(new Property("orderedBy", "CodeableConcept", "Specifies the order applied to the items in the section entries.", 0, Integer.MAX_VALUE, this.orderedBy));
            childrenList.add(new Property(Composition.SP_ENTRY, "Reference(Any)", "A reference to the actual resource from which the narrative in the section is derived.", 0, Integer.MAX_VALUE, this.entry));
            childrenList.add(new Property("emptyReason", "CodeableConcept", "If the section is empty, why the list is empty. An empty section typically has some text explaining the empty reason.", 0, Integer.MAX_VALUE, this.emptyReason));
            childrenList.add(new Property(Composition.SP_SECTION, "@Composition.section", "A nested sub-section within this section.", 0, Integer.MAX_VALUE, this.section));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Composition.SP_TITLE)) {
                this.title = this.castToString(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("text")) {
                this.text = this.castToNarrative(value);
            } else if (name.equals("mode")) {
                this.mode = this.castToCode(value);
            } else if (name.equals("orderedBy")) {
                this.orderedBy = this.castToCodeableConcept(value);
            } else if (name.equals(Composition.SP_ENTRY)) {
                this.getEntry().add(this.castToReference(value));
            } else if (name.equals("emptyReason")) {
                this.emptyReason = this.castToCodeableConcept(value);
            } else if (name.equals(Composition.SP_SECTION)) {
                this.getSection().add((SectionComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Composition.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Composition.title");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("text")) {
                this.text = new Narrative();
                return this.text;
            }
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type Composition.mode");
            }
            if (name.equals("orderedBy")) {
                this.orderedBy = new CodeableConcept();
                return this.orderedBy;
            }
            if (name.equals(Composition.SP_ENTRY)) {
                return this.addEntry();
            }
            if (name.equals("emptyReason")) {
                this.emptyReason = new CodeableConcept();
                return this.emptyReason;
            }
            if (name.equals(Composition.SP_SECTION)) {
                return this.addSection();
            }
            return super.addChild(name);
        }

        @Override
        public SectionComponent copy() {
            SectionComponent dst = new SectionComponent();
            this.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.text = this.text == null ? null : this.text.copy();
            dst.mode = this.mode == null ? null : this.mode.copy();
            CodeableConcept codeableConcept = dst.orderedBy = this.orderedBy == null ? null : this.orderedBy.copy();
            if (this.entry != null) {
                dst.entry = new ArrayList<Reference>();
                for (Reference reference : this.entry) {
                    dst.entry.add(reference.copy());
                }
            }
            CodeableConcept codeableConcept2 = dst.emptyReason = this.emptyReason == null ? null : this.emptyReason.copy();
            if (this.section != null) {
                dst.section = new ArrayList<SectionComponent>();
                for (SectionComponent sectionComponent : this.section) {
                    dst.section.add(sectionComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SectionComponent)) {
                return false;
            }
            SectionComponent o = (SectionComponent)other;
            return SectionComponent.compareDeep(this.title, o.title, true) && SectionComponent.compareDeep(this.code, o.code, true) && SectionComponent.compareDeep(this.text, o.text, true) && SectionComponent.compareDeep(this.mode, o.mode, true) && SectionComponent.compareDeep(this.orderedBy, o.orderedBy, true) && SectionComponent.compareDeep(this.entry, o.entry, true) && SectionComponent.compareDeep(this.emptyReason, o.emptyReason, true) && SectionComponent.compareDeep(this.section, o.section, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SectionComponent)) {
                return false;
            }
            SectionComponent o = (SectionComponent)other;
            return SectionComponent.compareValues(this.title, o.title, true) && SectionComponent.compareValues(this.mode, o.mode, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.title != null && !this.title.isEmpty() || this.code != null && !this.code.isEmpty() || this.text != null && !this.text.isEmpty() || this.mode != null && !this.mode.isEmpty() || this.orderedBy != null && !this.orderedBy.isEmpty() || this.entry != null && !this.entry.isEmpty() || this.emptyReason != null && !this.emptyReason.isEmpty() || this.section != null && !this.section.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Composition.section";
        }
    }

    @Block
    public static class CompositionEventComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Code(s) that apply to the event being documented", formalDefinition="This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.")
        protected List<CodeableConcept> code;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The period covered by the documentation", formalDefinition="The period of time covered by the documentation. There is no assertion that the documentation is a complete representation for this period, only that it documents events during this time.")
        protected Period period;
        @Child(name="detail", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The event(s) being documented", formalDefinition="The description and/or reference of the event(s) being documented. For example, this could be used to document such a colonoscopy or an appendectomy.")
        protected List<Reference> detail;
        protected List<Resource> detailTarget;
        private static final long serialVersionUID = -1581379774L;

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public CompositionEventComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompositionEventComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public CompositionEventComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public List<Reference> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            return this.detail;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (Reference item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addDetail() {
            Reference t = new Reference();
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return t;
        }

        public CompositionEventComponent addDetail(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return this;
        }

        public List<Resource> getDetailTarget() {
            if (this.detailTarget == null) {
                this.detailTarget = new ArrayList<Resource>();
            }
            return this.detailTarget;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "CodeableConcept", "This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property(Composition.SP_PERIOD, "Period", "The period of time covered by the documentation. There is no assertion that the documentation is a complete representation for this period, only that it documents events during this time.", 0, Integer.MAX_VALUE, this.period));
            childrenList.add(new Property("detail", "Reference(Any)", "The description and/or reference of the event(s) being documented. For example, this could be used to document such a colonoscopy or an appendectomy.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.getCode().add(this.castToCodeableConcept(value));
            } else if (name.equals(Composition.SP_PERIOD)) {
                this.period = this.castToPeriod(value);
            } else if (name.equals("detail")) {
                this.getDetail().add(this.castToReference(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                return this.addCode();
            }
            if (name.equals(Composition.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public CompositionEventComponent copy() {
            CompositionEventComponent dst = new CompositionEventComponent();
            this.copyValues(dst);
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            Period period = dst.period = this.period == null ? null : this.period.copy();
            if (this.detail != null) {
                dst.detail = new ArrayList<Reference>();
                for (Reference reference : this.detail) {
                    dst.detail.add(reference.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CompositionEventComponent)) {
                return false;
            }
            CompositionEventComponent o = (CompositionEventComponent)other;
            return CompositionEventComponent.compareDeep(this.code, o.code, true) && CompositionEventComponent.compareDeep(this.period, o.period, true) && CompositionEventComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CompositionEventComponent)) {
                return false;
            }
            CompositionEventComponent o = (CompositionEventComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.period != null && !this.period.isEmpty() || this.detail != null && !this.detail.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Composition.event";
        }
    }

    @Block
    public static class CompositionAttesterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="personal | professional | legal | official", formalDefinition="The type of attestation the authenticator offers.")
        protected List<Enumeration<CompositionAttestationMode>> mode;
        @Child(name="time", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When composition attested", formalDefinition="When composition was attested by the party.")
        protected DateTimeType time;
        @Child(name="party", type={Patient.class, Practitioner.class, Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who attested the composition", formalDefinition="Who attested the composition in the specified way.")
        protected Reference party;
        protected Resource partyTarget;
        private static final long serialVersionUID = -436604745L;

        public List<Enumeration<CompositionAttestationMode>> getMode() {
            if (this.mode == null) {
                this.mode = new ArrayList<Enumeration<CompositionAttestationMode>>();
            }
            return this.mode;
        }

        public boolean hasMode() {
            if (this.mode == null) {
                return false;
            }
            for (Enumeration<CompositionAttestationMode> item : this.mode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<CompositionAttestationMode> addModeElement() {
            Enumeration<CompositionAttestationMode> t = new Enumeration<CompositionAttestationMode>(new CompositionAttestationModeEnumFactory());
            if (this.mode == null) {
                this.mode = new ArrayList<Enumeration<CompositionAttestationMode>>();
            }
            this.mode.add(t);
            return t;
        }

        public CompositionAttesterComponent addMode(CompositionAttestationMode value) {
            Enumeration<CompositionAttestationMode> t = new Enumeration<CompositionAttestationMode>(new CompositionAttestationModeEnumFactory());
            t.setValue((Object)value);
            if (this.mode == null) {
                this.mode = new ArrayList<Enumeration<CompositionAttestationMode>>();
            }
            this.mode.add(t);
            return this;
        }

        public boolean hasMode(CompositionAttestationMode value) {
            if (this.mode == null) {
                return false;
            }
            for (Enumeration<CompositionAttestationMode> v : this.mode) {
                if (!v.equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public DateTimeType getTimeElement() {
            if (this.time == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompositionAttesterComponent.time");
                }
                if (Configuration.doAutoCreate()) {
                    this.time = new DateTimeType();
                }
            }
            return this.time;
        }

        public boolean hasTimeElement() {
            return this.time != null && !this.time.isEmpty();
        }

        public boolean hasTime() {
            return this.time != null && !this.time.isEmpty();
        }

        public CompositionAttesterComponent setTimeElement(DateTimeType value) {
            this.time = value;
            return this;
        }

        public Date getTime() {
            return this.time == null ? null : (Date)this.time.getValue();
        }

        public CompositionAttesterComponent setTime(Date value) {
            if (value == null) {
                this.time = null;
            } else {
                if (this.time == null) {
                    this.time = new DateTimeType();
                }
                this.time.setValue(value);
            }
            return this;
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompositionAttesterComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public CompositionAttesterComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        public Resource getPartyTarget() {
            return this.partyTarget;
        }

        public CompositionAttesterComponent setPartyTarget(Resource value) {
            this.partyTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("mode", "code", "The type of attestation the authenticator offers.", 0, Integer.MAX_VALUE, this.mode));
            childrenList.add(new Property("time", "dateTime", "When composition was attested by the party.", 0, Integer.MAX_VALUE, this.time));
            childrenList.add(new Property("party", "Reference(Patient|Practitioner|Organization)", "Who attested the composition in the specified way.", 0, Integer.MAX_VALUE, this.party));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                this.getMode().add(new CompositionAttestationModeEnumFactory().fromType(value));
            } else if (name.equals("time")) {
                this.time = this.castToDateTime(value);
            } else if (name.equals("party")) {
                this.party = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type Composition.mode");
            }
            if (name.equals("time")) {
                throw new FHIRException("Cannot call addChild on a primitive type Composition.time");
            }
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            return super.addChild(name);
        }

        @Override
        public CompositionAttesterComponent copy() {
            CompositionAttesterComponent dst = new CompositionAttesterComponent();
            this.copyValues(dst);
            if (this.mode != null) {
                dst.mode = new ArrayList<Enumeration<CompositionAttestationMode>>();
                for (Enumeration<CompositionAttestationMode> i : this.mode) {
                    dst.mode.add((Enumeration<CompositionAttestationMode>)i.copy());
                }
            }
            dst.time = this.time == null ? null : this.time.copy();
            dst.party = this.party == null ? null : this.party.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CompositionAttesterComponent)) {
                return false;
            }
            CompositionAttesterComponent o = (CompositionAttesterComponent)other;
            return CompositionAttesterComponent.compareDeep(this.mode, o.mode, true) && CompositionAttesterComponent.compareDeep(this.time, o.time, true) && CompositionAttesterComponent.compareDeep(this.party, o.party, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CompositionAttesterComponent)) {
                return false;
            }
            CompositionAttesterComponent o = (CompositionAttesterComponent)other;
            return CompositionAttesterComponent.compareValues(this.mode, o.mode, true) && CompositionAttesterComponent.compareValues(this.time, o.time, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.mode != null && !this.mode.isEmpty() || this.time != null && !this.time.isEmpty() || this.party != null && !this.party.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Composition.attester";
        }
    }

    public static class CompositionAttestationModeEnumFactory
    implements EnumFactory<CompositionAttestationMode> {
        @Override
        public CompositionAttestationMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("personal".equals(codeString)) {
                return CompositionAttestationMode.PERSONAL;
            }
            if ("professional".equals(codeString)) {
                return CompositionAttestationMode.PROFESSIONAL;
            }
            if ("legal".equals(codeString)) {
                return CompositionAttestationMode.LEGAL;
            }
            if ("official".equals(codeString)) {
                return CompositionAttestationMode.OFFICIAL;
            }
            throw new IllegalArgumentException("Unknown CompositionAttestationMode code '" + codeString + "'");
        }

        public Enumeration<CompositionAttestationMode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("personal".equals(codeString)) {
                return new Enumeration<CompositionAttestationMode>(this, CompositionAttestationMode.PERSONAL);
            }
            if ("professional".equals(codeString)) {
                return new Enumeration<CompositionAttestationMode>(this, CompositionAttestationMode.PROFESSIONAL);
            }
            if ("legal".equals(codeString)) {
                return new Enumeration<CompositionAttestationMode>(this, CompositionAttestationMode.LEGAL);
            }
            if ("official".equals(codeString)) {
                return new Enumeration<CompositionAttestationMode>(this, CompositionAttestationMode.OFFICIAL);
            }
            throw new FHIRException("Unknown CompositionAttestationMode code '" + codeString + "'");
        }

        @Override
        public String toCode(CompositionAttestationMode code) {
            if (code == CompositionAttestationMode.PERSONAL) {
                return "personal";
            }
            if (code == CompositionAttestationMode.PROFESSIONAL) {
                return "professional";
            }
            if (code == CompositionAttestationMode.LEGAL) {
                return "legal";
            }
            if (code == CompositionAttestationMode.OFFICIAL) {
                return "official";
            }
            return "?";
        }
    }

    public static enum CompositionAttestationMode {
        PERSONAL,
        PROFESSIONAL,
        LEGAL,
        OFFICIAL,
        NULL;


        public static CompositionAttestationMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("personal".equals(codeString)) {
                return PERSONAL;
            }
            if ("professional".equals(codeString)) {
                return PROFESSIONAL;
            }
            if ("legal".equals(codeString)) {
                return LEGAL;
            }
            if ("official".equals(codeString)) {
                return OFFICIAL;
            }
            throw new FHIRException("Unknown CompositionAttestationMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PERSONAL: {
                    return "personal";
                }
                case PROFESSIONAL: {
                    return "professional";
                }
                case LEGAL: {
                    return "legal";
                }
                case OFFICIAL: {
                    return "official";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PERSONAL: {
                    return "http://hl7.org/fhir/composition-attestation-mode";
                }
                case PROFESSIONAL: {
                    return "http://hl7.org/fhir/composition-attestation-mode";
                }
                case LEGAL: {
                    return "http://hl7.org/fhir/composition-attestation-mode";
                }
                case OFFICIAL: {
                    return "http://hl7.org/fhir/composition-attestation-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PERSONAL: {
                    return "The person authenticated the content in their personal capacity.";
                }
                case PROFESSIONAL: {
                    return "The person authenticated the content in their professional capacity.";
                }
                case LEGAL: {
                    return "The person authenticated the content and accepted legal responsibility for its content.";
                }
                case OFFICIAL: {
                    return "The organization authenticated the content as consistent with their policies and procedures.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PERSONAL: {
                    return "Personal";
                }
                case PROFESSIONAL: {
                    return "Professional";
                }
                case LEGAL: {
                    return "Legal";
                }
                case OFFICIAL: {
                    return "Official";
                }
            }
            return "?";
        }
    }

    public static class CompositionStatusEnumFactory
    implements EnumFactory<CompositionStatus> {
        @Override
        public CompositionStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preliminary".equals(codeString)) {
                return CompositionStatus.PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return CompositionStatus.FINAL;
            }
            if ("amended".equals(codeString)) {
                return CompositionStatus.AMENDED;
            }
            if ("entered-in-error".equals(codeString)) {
                return CompositionStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown CompositionStatus code '" + codeString + "'");
        }

        public Enumeration<CompositionStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preliminary".equals(codeString)) {
                return new Enumeration<CompositionStatus>(this, CompositionStatus.PRELIMINARY);
            }
            if ("final".equals(codeString)) {
                return new Enumeration<CompositionStatus>(this, CompositionStatus.FINAL);
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<CompositionStatus>(this, CompositionStatus.AMENDED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<CompositionStatus>(this, CompositionStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown CompositionStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CompositionStatus code) {
            if (code == CompositionStatus.PRELIMINARY) {
                return "preliminary";
            }
            if (code == CompositionStatus.FINAL) {
                return "final";
            }
            if (code == CompositionStatus.AMENDED) {
                return "amended";
            }
            if (code == CompositionStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }
    }

    public static enum CompositionStatus {
        PRELIMINARY,
        FINAL,
        AMENDED,
        ENTEREDINERROR,
        NULL;


        public static CompositionStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preliminary".equals(codeString)) {
                return PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return FINAL;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            throw new FHIRException("Unknown CompositionStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PRELIMINARY: {
                    return "preliminary";
                }
                case FINAL: {
                    return "final";
                }
                case AMENDED: {
                    return "amended";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PRELIMINARY: {
                    return "http://hl7.org/fhir/composition-status";
                }
                case FINAL: {
                    return "http://hl7.org/fhir/composition-status";
                }
                case AMENDED: {
                    return "http://hl7.org/fhir/composition-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/composition-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PRELIMINARY: {
                    return "This is a preliminary composition or document (also known as initial or interim). The content may be incomplete or unverified.";
                }
                case FINAL: {
                    return "This version of the composition is complete and verified by an appropriate person and no further work is planned. Any subsequent updates would be on a new version of the composition.";
                }
                case AMENDED: {
                    return "The composition content or the referenced resources have been modified (edited or added to) subsequent to being released as \"final\" and the composition is complete and verified by an authorized person.";
                }
                case ENTEREDINERROR: {
                    return "The composition or document was originally created/issued in error, and this is an amendment that marks that the entire series should not be considered as valid.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PRELIMINARY: {
                    return "Preliminary";
                }
                case FINAL: {
                    return "Final";
                }
                case AMENDED: {
                    return "Amended";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

