/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.AllergyIntolerance;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Immunization;
import org.hl7.fhir.dstu2.model.IntegerType;
import org.hl7.fhir.dstu2.model.Observation;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.PositiveIntType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImmunizationRecommendation", profile="http://hl7.org/fhir/Profile/ImmunizationRecommendation")
public class ImmunizationRecommendation
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="A unique identifier assigned to this particular recommendation record.")
    protected List<Identifier> identifier;
    @Child(name="patient", type={Patient.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who this profile is for", formalDefinition="The patient for whom the recommendations are for.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="recommendation", type={}, order=2, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Vaccine administration recommendations", formalDefinition="Vaccine administration recommendations.")
    protected List<ImmunizationRecommendationRecommendationComponent> recommendation;
    private static final long serialVersionUID = 641058495L;
    @SearchParamDefinition(name="date", path="ImmunizationRecommendation.recommendation.date", description="Date recommendation created", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="identifier", path="ImmunizationRecommendation.identifier", description="Business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="dose-sequence", path="ImmunizationRecommendation.recommendation.protocol.doseSequence", description="Dose number within sequence", type="number")
    public static final String SP_DOSESEQUENCE = "dose-sequence";
    @SearchParamDefinition(name="patient", path="ImmunizationRecommendation.patient", description="Who this profile is for", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="vaccine-type", path="ImmunizationRecommendation.recommendation.vaccineCode", description="Vaccine recommendation applies to", type="token")
    public static final String SP_VACCINETYPE = "vaccine-type";
    @SearchParamDefinition(name="dose-number", path="ImmunizationRecommendation.recommendation.doseNumber", description="Recommended dose number", type="number")
    public static final String SP_DOSENUMBER = "dose-number";
    @SearchParamDefinition(name="information", path="ImmunizationRecommendation.recommendation.supportingPatientInformation", description="Patient observations supporting recommendation", type="reference")
    public static final String SP_INFORMATION = "information";
    @SearchParamDefinition(name="support", path="ImmunizationRecommendation.recommendation.supportingImmunization", description="Past immunizations supporting recommendation", type="reference")
    public static final String SP_SUPPORT = "support";
    @SearchParamDefinition(name="status", path="ImmunizationRecommendation.recommendation.forecastStatus", description="Vaccine administration status", type="token")
    public static final String SP_STATUS = "status";

    public ImmunizationRecommendation() {
    }

    public ImmunizationRecommendation(Reference patient) {
        this.patient = patient;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ImmunizationRecommendation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationRecommendation.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ImmunizationRecommendation setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationRecommendation.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ImmunizationRecommendation setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public List<ImmunizationRecommendationRecommendationComponent> getRecommendation() {
        if (this.recommendation == null) {
            this.recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
        }
        return this.recommendation;
    }

    public boolean hasRecommendation() {
        if (this.recommendation == null) {
            return false;
        }
        for (ImmunizationRecommendationRecommendationComponent item : this.recommendation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImmunizationRecommendationRecommendationComponent addRecommendation() {
        ImmunizationRecommendationRecommendationComponent t = new ImmunizationRecommendationRecommendationComponent();
        if (this.recommendation == null) {
            this.recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
        }
        this.recommendation.add(t);
        return t;
    }

    public ImmunizationRecommendation addRecommendation(ImmunizationRecommendationRecommendationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.recommendation == null) {
            this.recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
        }
        this.recommendation.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this particular recommendation record.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient for whom the recommendations are for.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("recommendation", "", "Vaccine administration recommendations.", 0, Integer.MAX_VALUE, this.recommendation));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("recommendation")) {
            this.getRecommendation().add((ImmunizationRecommendationRecommendationComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("recommendation")) {
            return this.addRecommendation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImmunizationRecommendation";
    }

    @Override
    public ImmunizationRecommendation copy() {
        ImmunizationRecommendation dst = new ImmunizationRecommendation();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Reference reference = dst.patient = this.patient == null ? null : this.patient.copy();
        if (this.recommendation != null) {
            dst.recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
            for (ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent : this.recommendation) {
                dst.recommendation.add(immunizationRecommendationRecommendationComponent.copy());
            }
        }
        return dst;
    }

    protected ImmunizationRecommendation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ImmunizationRecommendation)) {
            return false;
        }
        ImmunizationRecommendation o = (ImmunizationRecommendation)other;
        return ImmunizationRecommendation.compareDeep(this.identifier, o.identifier, true) && ImmunizationRecommendation.compareDeep(this.patient, o.patient, true) && ImmunizationRecommendation.compareDeep(this.recommendation, o.recommendation, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ImmunizationRecommendation)) {
            return false;
        }
        ImmunizationRecommendation o = (ImmunizationRecommendation)other;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.recommendation != null && !this.recommendation.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImmunizationRecommendation;
    }

    @Block
    public static class ImmunizationRecommendationRecommendationProtocolComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="doseSequence", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Dose number within sequence", formalDefinition="Indicates the nominal position in a series of the next dose.  This is the recommended dose number as per a specified protocol.")
        protected IntegerType doseSequence;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Protocol details", formalDefinition="Contains the description about the protocol under which the vaccine was administered.")
        protected StringType description;
        @Child(name="authority", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who is responsible for protocol", formalDefinition="Indicates the authority who published the protocol.  For example, ACIP.")
        protected Reference authority;
        protected Organization authorityTarget;
        @Child(name="series", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of vaccination series", formalDefinition="One possible path to achieve presumed immunity against a disease - within the context of an authority.")
        protected StringType series;
        private static final long serialVersionUID = -512702014L;

        public IntegerType getDoseSequenceElement() {
            if (this.doseSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationProtocolComponent.doseSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.doseSequence = new IntegerType();
                }
            }
            return this.doseSequence;
        }

        public boolean hasDoseSequenceElement() {
            return this.doseSequence != null && !this.doseSequence.isEmpty();
        }

        public boolean hasDoseSequence() {
            return this.doseSequence != null && !this.doseSequence.isEmpty();
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setDoseSequenceElement(IntegerType value) {
            this.doseSequence = value;
            return this;
        }

        public int getDoseSequence() {
            return this.doseSequence == null || this.doseSequence.isEmpty() ? 0 : (Integer)this.doseSequence.getValue();
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setDoseSequence(int value) {
            if (this.doseSequence == null) {
                this.doseSequence = new IntegerType();
            }
            this.doseSequence.setValue((Object)value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationProtocolComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Reference getAuthority() {
            if (this.authority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationProtocolComponent.authority");
                }
                if (Configuration.doAutoCreate()) {
                    this.authority = new Reference();
                }
            }
            return this.authority;
        }

        public boolean hasAuthority() {
            return this.authority != null && !this.authority.isEmpty();
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setAuthority(Reference value) {
            this.authority = value;
            return this;
        }

        public Organization getAuthorityTarget() {
            if (this.authorityTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationProtocolComponent.authority");
                }
                if (Configuration.doAutoCreate()) {
                    this.authorityTarget = new Organization();
                }
            }
            return this.authorityTarget;
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setAuthorityTarget(Organization value) {
            this.authorityTarget = value;
            return this;
        }

        public StringType getSeriesElement() {
            if (this.series == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationProtocolComponent.series");
                }
                if (Configuration.doAutoCreate()) {
                    this.series = new StringType();
                }
            }
            return this.series;
        }

        public boolean hasSeriesElement() {
            return this.series != null && !this.series.isEmpty();
        }

        public boolean hasSeries() {
            return this.series != null && !this.series.isEmpty();
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setSeriesElement(StringType value) {
            this.series = value;
            return this;
        }

        public String getSeries() {
            return this.series == null ? null : (String)this.series.getValue();
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setSeries(String value) {
            if (Utilities.noString((String)value)) {
                this.series = null;
            } else {
                if (this.series == null) {
                    this.series = new StringType();
                }
                this.series.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("doseSequence", "integer", "Indicates the nominal position in a series of the next dose.  This is the recommended dose number as per a specified protocol.", 0, Integer.MAX_VALUE, this.doseSequence));
            childrenList.add(new Property("description", "string", "Contains the description about the protocol under which the vaccine was administered.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("authority", "Reference(Organization)", "Indicates the authority who published the protocol.  For example, ACIP.", 0, Integer.MAX_VALUE, this.authority));
            childrenList.add(new Property("series", "string", "One possible path to achieve presumed immunity against a disease - within the context of an authority.", 0, Integer.MAX_VALUE, this.series));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("doseSequence")) {
                this.doseSequence = this.castToInteger(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("authority")) {
                this.authority = this.castToReference(value);
            } else if (name.equals("series")) {
                this.series = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("doseSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.doseSequence");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.description");
            }
            if (name.equals("authority")) {
                this.authority = new Reference();
                return this.authority;
            }
            if (name.equals("series")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.series");
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationRecommendationRecommendationProtocolComponent copy() {
            ImmunizationRecommendationRecommendationProtocolComponent dst = new ImmunizationRecommendationRecommendationProtocolComponent();
            this.copyValues(dst);
            dst.doseSequence = this.doseSequence == null ? null : this.doseSequence.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.authority = this.authority == null ? null : this.authority.copy();
            dst.series = this.series == null ? null : this.series.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImmunizationRecommendationRecommendationProtocolComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationProtocolComponent o = (ImmunizationRecommendationRecommendationProtocolComponent)other;
            return ImmunizationRecommendationRecommendationProtocolComponent.compareDeep(this.doseSequence, o.doseSequence, true) && ImmunizationRecommendationRecommendationProtocolComponent.compareDeep(this.description, o.description, true) && ImmunizationRecommendationRecommendationProtocolComponent.compareDeep(this.authority, o.authority, true) && ImmunizationRecommendationRecommendationProtocolComponent.compareDeep(this.series, o.series, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImmunizationRecommendationRecommendationProtocolComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationProtocolComponent o = (ImmunizationRecommendationRecommendationProtocolComponent)other;
            return ImmunizationRecommendationRecommendationProtocolComponent.compareValues(this.doseSequence, o.doseSequence, true) && ImmunizationRecommendationRecommendationProtocolComponent.compareValues(this.description, o.description, true) && ImmunizationRecommendationRecommendationProtocolComponent.compareValues(this.series, o.series, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.doseSequence != null && !this.doseSequence.isEmpty() || this.description != null && !this.description.isEmpty() || this.authority != null && !this.authority.isEmpty() || this.series != null && !this.series.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImmunizationRecommendation.recommendation.protocol";
        }
    }

    @Block
    public static class ImmunizationRecommendationRecommendationDateCriterionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of date", formalDefinition="Date classification of recommendation.  For example, earliest date to give, latest date to give, etc.")
        protected CodeableConcept code;
        @Child(name="value", type={DateTimeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recommended date", formalDefinition="The date whose meaning is specified by dateCriterion.code.")
        protected DateTimeType value;
        private static final long serialVersionUID = 1036994566L;

        public ImmunizationRecommendationRecommendationDateCriterionComponent() {
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent(CodeableConcept code, DateTimeType value) {
            this.code = code;
            this.value = value;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationDateCriterionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public DateTimeType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationDateCriterionComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DateTimeType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent setValueElement(DateTimeType value) {
            this.value = value;
            return this;
        }

        public Date getValue() {
            return this.value == null ? null : (Date)this.value.getValue();
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent setValue(Date value) {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "CodeableConcept", "Date classification of recommendation.  For example, earliest date to give, latest date to give, etc.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("value", "dateTime", "The date whose meaning is specified by dateCriterion.code.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = this.castToDateTime(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.value");
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationRecommendationRecommendationDateCriterionComponent copy() {
            ImmunizationRecommendationRecommendationDateCriterionComponent dst = new ImmunizationRecommendationRecommendationDateCriterionComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImmunizationRecommendationRecommendationDateCriterionComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationDateCriterionComponent o = (ImmunizationRecommendationRecommendationDateCriterionComponent)other;
            return ImmunizationRecommendationRecommendationDateCriterionComponent.compareDeep(this.code, o.code, true) && ImmunizationRecommendationRecommendationDateCriterionComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImmunizationRecommendationRecommendationDateCriterionComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationDateCriterionComponent o = (ImmunizationRecommendationRecommendationDateCriterionComponent)other;
            return ImmunizationRecommendationRecommendationDateCriterionComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImmunizationRecommendation.recommendation.dateCriterion";
        }
    }

    @Block
    public static class ImmunizationRecommendationRecommendationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="date", type={DateTimeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date recommendation created", formalDefinition="The date the immunization recommendation was created.")
        protected DateTimeType date;
        @Child(name="vaccineCode", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Vaccine recommendation applies to", formalDefinition="Vaccine that pertains to the recommendation.")
        protected CodeableConcept vaccineCode;
        @Child(name="doseNumber", type={PositiveIntType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Recommended dose number", formalDefinition="This indicates the next recommended dose number (e.g. dose 2 is the next recommended dose).")
        protected PositiveIntType doseNumber;
        @Child(name="forecastStatus", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Vaccine administration status", formalDefinition="Vaccine administration status.")
        protected CodeableConcept forecastStatus;
        @Child(name="dateCriterion", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dates governing proposed immunization", formalDefinition="Vaccine date recommendations.  For example, earliest date to administer, latest date to administer, etc.")
        protected List<ImmunizationRecommendationRecommendationDateCriterionComponent> dateCriterion;
        @Child(name="protocol", type={}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Protocol used by recommendation", formalDefinition="Contains information about the protocol under which the vaccine was administered.")
        protected ImmunizationRecommendationRecommendationProtocolComponent protocol;
        @Child(name="supportingImmunization", type={Immunization.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Past immunizations supporting recommendation", formalDefinition="Immunization event history that supports the status and recommendation.")
        protected List<Reference> supportingImmunization;
        protected List<Immunization> supportingImmunizationTarget;
        @Child(name="supportingPatientInformation", type={Observation.class, AllergyIntolerance.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Patient observations supporting recommendation", formalDefinition="Patient Information that supports the status and recommendation.  This includes patient observations, adverse reactions and allergy/intolerance information.")
        protected List<Reference> supportingPatientInformation;
        protected List<Resource> supportingPatientInformationTarget;
        private static final long serialVersionUID = 1501347482L;

        public ImmunizationRecommendationRecommendationComponent() {
        }

        public ImmunizationRecommendationRecommendationComponent(DateTimeType date, CodeableConcept vaccineCode, CodeableConcept forecastStatus) {
            this.date = date;
            this.vaccineCode = vaccineCode;
            this.forecastStatus = forecastStatus;
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public ImmunizationRecommendationRecommendationComponent setDate(Date value) {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
            return this;
        }

        public CodeableConcept getVaccineCode() {
            if (this.vaccineCode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.vaccineCode");
                }
                if (Configuration.doAutoCreate()) {
                    this.vaccineCode = new CodeableConcept();
                }
            }
            return this.vaccineCode;
        }

        public boolean hasVaccineCode() {
            return this.vaccineCode != null && !this.vaccineCode.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setVaccineCode(CodeableConcept value) {
            this.vaccineCode = value;
            return this;
        }

        public PositiveIntType getDoseNumberElement() {
            if (this.doseNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.doseNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.doseNumber = new PositiveIntType();
                }
            }
            return this.doseNumber;
        }

        public boolean hasDoseNumberElement() {
            return this.doseNumber != null && !this.doseNumber.isEmpty();
        }

        public boolean hasDoseNumber() {
            return this.doseNumber != null && !this.doseNumber.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setDoseNumberElement(PositiveIntType value) {
            this.doseNumber = value;
            return this;
        }

        public int getDoseNumber() {
            return this.doseNumber == null || this.doseNumber.isEmpty() ? 0 : (Integer)this.doseNumber.getValue();
        }

        public ImmunizationRecommendationRecommendationComponent setDoseNumber(int value) {
            if (this.doseNumber == null) {
                this.doseNumber = new PositiveIntType();
            }
            this.doseNumber.setValue((Object)value);
            return this;
        }

        public CodeableConcept getForecastStatus() {
            if (this.forecastStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.forecastStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.forecastStatus = new CodeableConcept();
                }
            }
            return this.forecastStatus;
        }

        public boolean hasForecastStatus() {
            return this.forecastStatus != null && !this.forecastStatus.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setForecastStatus(CodeableConcept value) {
            this.forecastStatus = value;
            return this;
        }

        public List<ImmunizationRecommendationRecommendationDateCriterionComponent> getDateCriterion() {
            if (this.dateCriterion == null) {
                this.dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
            }
            return this.dateCriterion;
        }

        public boolean hasDateCriterion() {
            if (this.dateCriterion == null) {
                return false;
            }
            for (ImmunizationRecommendationRecommendationDateCriterionComponent item : this.dateCriterion) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent addDateCriterion() {
            ImmunizationRecommendationRecommendationDateCriterionComponent t = new ImmunizationRecommendationRecommendationDateCriterionComponent();
            if (this.dateCriterion == null) {
                this.dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
            }
            this.dateCriterion.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addDateCriterion(ImmunizationRecommendationRecommendationDateCriterionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dateCriterion == null) {
                this.dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
            }
            this.dateCriterion.add(t);
            return this;
        }

        public ImmunizationRecommendationRecommendationProtocolComponent getProtocol() {
            if (this.protocol == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.protocol");
                }
                if (Configuration.doAutoCreate()) {
                    this.protocol = new ImmunizationRecommendationRecommendationProtocolComponent();
                }
            }
            return this.protocol;
        }

        public boolean hasProtocol() {
            return this.protocol != null && !this.protocol.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setProtocol(ImmunizationRecommendationRecommendationProtocolComponent value) {
            this.protocol = value;
            return this;
        }

        public List<Reference> getSupportingImmunization() {
            if (this.supportingImmunization == null) {
                this.supportingImmunization = new ArrayList<Reference>();
            }
            return this.supportingImmunization;
        }

        public boolean hasSupportingImmunization() {
            if (this.supportingImmunization == null) {
                return false;
            }
            for (Reference item : this.supportingImmunization) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSupportingImmunization() {
            Reference t = new Reference();
            if (this.supportingImmunization == null) {
                this.supportingImmunization = new ArrayList<Reference>();
            }
            this.supportingImmunization.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addSupportingImmunization(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.supportingImmunization == null) {
                this.supportingImmunization = new ArrayList<Reference>();
            }
            this.supportingImmunization.add(t);
            return this;
        }

        public List<Immunization> getSupportingImmunizationTarget() {
            if (this.supportingImmunizationTarget == null) {
                this.supportingImmunizationTarget = new ArrayList<Immunization>();
            }
            return this.supportingImmunizationTarget;
        }

        public Immunization addSupportingImmunizationTarget() {
            Immunization r = new Immunization();
            if (this.supportingImmunizationTarget == null) {
                this.supportingImmunizationTarget = new ArrayList<Immunization>();
            }
            this.supportingImmunizationTarget.add(r);
            return r;
        }

        public List<Reference> getSupportingPatientInformation() {
            if (this.supportingPatientInformation == null) {
                this.supportingPatientInformation = new ArrayList<Reference>();
            }
            return this.supportingPatientInformation;
        }

        public boolean hasSupportingPatientInformation() {
            if (this.supportingPatientInformation == null) {
                return false;
            }
            for (Reference item : this.supportingPatientInformation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSupportingPatientInformation() {
            Reference t = new Reference();
            if (this.supportingPatientInformation == null) {
                this.supportingPatientInformation = new ArrayList<Reference>();
            }
            this.supportingPatientInformation.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addSupportingPatientInformation(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.supportingPatientInformation == null) {
                this.supportingPatientInformation = new ArrayList<Reference>();
            }
            this.supportingPatientInformation.add(t);
            return this;
        }

        public List<Resource> getSupportingPatientInformationTarget() {
            if (this.supportingPatientInformationTarget == null) {
                this.supportingPatientInformationTarget = new ArrayList<Resource>();
            }
            return this.supportingPatientInformationTarget;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ImmunizationRecommendation.SP_DATE, "dateTime", "The date the immunization recommendation was created.", 0, Integer.MAX_VALUE, this.date));
            childrenList.add(new Property("vaccineCode", "CodeableConcept", "Vaccine that pertains to the recommendation.", 0, Integer.MAX_VALUE, this.vaccineCode));
            childrenList.add(new Property("doseNumber", "positiveInt", "This indicates the next recommended dose number (e.g. dose 2 is the next recommended dose).", 0, Integer.MAX_VALUE, this.doseNumber));
            childrenList.add(new Property("forecastStatus", "CodeableConcept", "Vaccine administration status.", 0, Integer.MAX_VALUE, this.forecastStatus));
            childrenList.add(new Property("dateCriterion", "", "Vaccine date recommendations.  For example, earliest date to administer, latest date to administer, etc.", 0, Integer.MAX_VALUE, this.dateCriterion));
            childrenList.add(new Property("protocol", "", "Contains information about the protocol under which the vaccine was administered.", 0, Integer.MAX_VALUE, this.protocol));
            childrenList.add(new Property("supportingImmunization", "Reference(Immunization)", "Immunization event history that supports the status and recommendation.", 0, Integer.MAX_VALUE, this.supportingImmunization));
            childrenList.add(new Property("supportingPatientInformation", "Reference(Observation|AllergyIntolerance)", "Patient Information that supports the status and recommendation.  This includes patient observations, adverse reactions and allergy/intolerance information.", 0, Integer.MAX_VALUE, this.supportingPatientInformation));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ImmunizationRecommendation.SP_DATE)) {
                this.date = this.castToDateTime(value);
            } else if (name.equals("vaccineCode")) {
                this.vaccineCode = this.castToCodeableConcept(value);
            } else if (name.equals("doseNumber")) {
                this.doseNumber = this.castToPositiveInt(value);
            } else if (name.equals("forecastStatus")) {
                this.forecastStatus = this.castToCodeableConcept(value);
            } else if (name.equals("dateCriterion")) {
                this.getDateCriterion().add((ImmunizationRecommendationRecommendationDateCriterionComponent)value);
            } else if (name.equals("protocol")) {
                this.protocol = (ImmunizationRecommendationRecommendationProtocolComponent)value;
            } else if (name.equals("supportingImmunization")) {
                this.getSupportingImmunization().add(this.castToReference(value));
            } else if (name.equals("supportingPatientInformation")) {
                this.getSupportingPatientInformation().add(this.castToReference(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ImmunizationRecommendation.SP_DATE)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.date");
            }
            if (name.equals("vaccineCode")) {
                this.vaccineCode = new CodeableConcept();
                return this.vaccineCode;
            }
            if (name.equals("doseNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.doseNumber");
            }
            if (name.equals("forecastStatus")) {
                this.forecastStatus = new CodeableConcept();
                return this.forecastStatus;
            }
            if (name.equals("dateCriterion")) {
                return this.addDateCriterion();
            }
            if (name.equals("protocol")) {
                this.protocol = new ImmunizationRecommendationRecommendationProtocolComponent();
                return this.protocol;
            }
            if (name.equals("supportingImmunization")) {
                return this.addSupportingImmunization();
            }
            if (name.equals("supportingPatientInformation")) {
                return this.addSupportingPatientInformation();
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationRecommendationRecommendationComponent copy() {
            ImmunizationRecommendationRecommendationComponent dst = new ImmunizationRecommendationRecommendationComponent();
            this.copyValues(dst);
            dst.date = this.date == null ? null : this.date.copy();
            dst.vaccineCode = this.vaccineCode == null ? null : this.vaccineCode.copy();
            dst.doseNumber = this.doseNumber == null ? null : this.doseNumber.copy();
            CodeableConcept codeableConcept = dst.forecastStatus = this.forecastStatus == null ? null : this.forecastStatus.copy();
            if (this.dateCriterion != null) {
                dst.dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
                for (ImmunizationRecommendationRecommendationDateCriterionComponent immunizationRecommendationRecommendationDateCriterionComponent : this.dateCriterion) {
                    dst.dateCriterion.add(immunizationRecommendationRecommendationDateCriterionComponent.copy());
                }
            }
            ImmunizationRecommendationRecommendationProtocolComponent immunizationRecommendationRecommendationProtocolComponent = dst.protocol = this.protocol == null ? null : this.protocol.copy();
            if (this.supportingImmunization != null) {
                dst.supportingImmunization = new ArrayList<Reference>();
                for (Reference reference : this.supportingImmunization) {
                    dst.supportingImmunization.add(reference.copy());
                }
            }
            if (this.supportingPatientInformation != null) {
                dst.supportingPatientInformation = new ArrayList<Reference>();
                for (Reference reference : this.supportingPatientInformation) {
                    dst.supportingPatientInformation.add(reference.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImmunizationRecommendationRecommendationComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationComponent o = (ImmunizationRecommendationRecommendationComponent)other;
            return ImmunizationRecommendationRecommendationComponent.compareDeep(this.date, o.date, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.vaccineCode, o.vaccineCode, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.doseNumber, o.doseNumber, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.forecastStatus, o.forecastStatus, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.dateCriterion, o.dateCriterion, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.protocol, o.protocol, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.supportingImmunization, o.supportingImmunization, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.supportingPatientInformation, o.supportingPatientInformation, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImmunizationRecommendationRecommendationComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationComponent o = (ImmunizationRecommendationRecommendationComponent)other;
            return ImmunizationRecommendationRecommendationComponent.compareValues(this.date, o.date, true) && ImmunizationRecommendationRecommendationComponent.compareValues(this.doseNumber, o.doseNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.date != null && !this.date.isEmpty() || this.vaccineCode != null && !this.vaccineCode.isEmpty() || this.doseNumber != null && !this.doseNumber.isEmpty() || this.forecastStatus != null && !this.forecastStatus.isEmpty() || this.dateCriterion != null && !this.dateCriterion.isEmpty() || this.protocol != null && !this.protocol.isEmpty() || this.supportingImmunization != null && !this.supportingImmunization.isEmpty() || this.supportingPatientInformation != null && !this.supportingPatientInformation.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImmunizationRecommendation.recommendation";
        }
    }
}

