/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="HumanName")
public class HumanName
extends Type
implements ICompositeType {
    @Child(name="use", type={CodeType.class}, order=0, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="usual | official | temp | nickname | anonymous | old | maiden", formalDefinition="Identifies the purpose for this name.")
    protected Enumeration<NameUse> use;
    @Child(name="text", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Text representation of the full name", formalDefinition="A full text representation of the name.")
    protected StringType text;
    @Child(name="family", type={StringType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Family name (often called 'Surname')", formalDefinition="The part of a name that links to the genealogy. In some cultures (e.g. Eritrea) the family name of a son is the first name of his father.")
    protected List<StringType> family;
    @Child(name="given", type={StringType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Given names (not always 'first'). Includes middle names", formalDefinition="Given name.")
    protected List<StringType> given;
    @Child(name="prefix", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Parts that come before the name", formalDefinition="Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the start of the name.")
    protected List<StringType> prefix;
    @Child(name="suffix", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Parts that come after the name", formalDefinition="Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the end of the name.")
    protected List<StringType> suffix;
    @Child(name="period", type={Period.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time period when name was/is in use", formalDefinition="Indicates the period of time when this name was valid for the named person.")
    protected Period period;
    private static final long serialVersionUID = -210174642L;

    public Enumeration<NameUse> getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HumanName.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new Enumeration<NameUse>(new NameUseEnumFactory());
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public HumanName setUseElement(Enumeration<NameUse> value) {
        this.use = value;
        return this;
    }

    public NameUse getUse() {
        return this.use == null ? null : (NameUse)((Object)this.use.getValue());
    }

    public HumanName setUse(NameUse value) {
        if (value == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration<NameUse>(new NameUseEnumFactory());
            }
            this.use.setValue((Object)value);
        }
        return this;
    }

    public StringType getTextElement() {
        if (this.text == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HumanName.text");
            }
            if (Configuration.doAutoCreate()) {
                this.text = new StringType();
            }
        }
        return this.text;
    }

    public boolean hasTextElement() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    public HumanName setTextElement(StringType value) {
        this.text = value;
        return this;
    }

    public String getText() {
        return this.text == null ? null : (String)this.text.getValue();
    }

    public HumanName setText(String value) {
        if (Utilities.noString((String)value)) {
            this.text = null;
        } else {
            if (this.text == null) {
                this.text = new StringType();
            }
            this.text.setValue(value);
        }
        return this;
    }

    public List<StringType> getFamily() {
        if (this.family == null) {
            this.family = new ArrayList<StringType>();
        }
        return this.family;
    }

    public boolean hasFamily() {
        if (this.family == null) {
            return false;
        }
        for (StringType item : this.family) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addFamilyElement() {
        StringType t = new StringType();
        if (this.family == null) {
            this.family = new ArrayList<StringType>();
        }
        this.family.add(t);
        return t;
    }

    public HumanName addFamily(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.family == null) {
            this.family = new ArrayList<StringType>();
        }
        this.family.add(t);
        return this;
    }

    public boolean hasFamily(String value) {
        if (this.family == null) {
            return false;
        }
        for (StringType v : this.family) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getGiven() {
        if (this.given == null) {
            this.given = new ArrayList<StringType>();
        }
        return this.given;
    }

    public boolean hasGiven() {
        if (this.given == null) {
            return false;
        }
        for (StringType item : this.given) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addGivenElement() {
        StringType t = new StringType();
        if (this.given == null) {
            this.given = new ArrayList<StringType>();
        }
        this.given.add(t);
        return t;
    }

    public HumanName addGiven(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.given == null) {
            this.given = new ArrayList<StringType>();
        }
        this.given.add(t);
        return this;
    }

    public boolean hasGiven(String value) {
        if (this.given == null) {
            return false;
        }
        for (StringType v : this.given) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getPrefix() {
        if (this.prefix == null) {
            this.prefix = new ArrayList<StringType>();
        }
        return this.prefix;
    }

    public boolean hasPrefix() {
        if (this.prefix == null) {
            return false;
        }
        for (StringType item : this.prefix) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addPrefixElement() {
        StringType t = new StringType();
        if (this.prefix == null) {
            this.prefix = new ArrayList<StringType>();
        }
        this.prefix.add(t);
        return t;
    }

    public HumanName addPrefix(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.prefix == null) {
            this.prefix = new ArrayList<StringType>();
        }
        this.prefix.add(t);
        return this;
    }

    public boolean hasPrefix(String value) {
        if (this.prefix == null) {
            return false;
        }
        for (StringType v : this.prefix) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getSuffix() {
        if (this.suffix == null) {
            this.suffix = new ArrayList<StringType>();
        }
        return this.suffix;
    }

    public boolean hasSuffix() {
        if (this.suffix == null) {
            return false;
        }
        for (StringType item : this.suffix) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addSuffixElement() {
        StringType t = new StringType();
        if (this.suffix == null) {
            this.suffix = new ArrayList<StringType>();
        }
        this.suffix.add(t);
        return t;
    }

    public HumanName addSuffix(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.suffix == null) {
            this.suffix = new ArrayList<StringType>();
        }
        this.suffix.add(t);
        return this;
    }

    public boolean hasSuffix(String value) {
        if (this.suffix == null) {
            return false;
        }
        for (StringType v : this.suffix) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HumanName.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public HumanName setPeriod(Period value) {
        this.period = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("use", "code", "Identifies the purpose for this name.", 0, Integer.MAX_VALUE, this.use));
        childrenList.add(new Property("text", "string", "A full text representation of the name.", 0, Integer.MAX_VALUE, this.text));
        childrenList.add(new Property("family", "string", "The part of a name that links to the genealogy. In some cultures (e.g. Eritrea) the family name of a son is the first name of his father.", 0, Integer.MAX_VALUE, this.family));
        childrenList.add(new Property("given", "string", "Given name.", 0, Integer.MAX_VALUE, this.given));
        childrenList.add(new Property("prefix", "string", "Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the start of the name.", 0, Integer.MAX_VALUE, this.prefix));
        childrenList.add(new Property("suffix", "string", "Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the end of the name.", 0, Integer.MAX_VALUE, this.suffix));
        childrenList.add(new Property("period", "Period", "Indicates the period of time when this name was valid for the named person.", 0, Integer.MAX_VALUE, this.period));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("use")) {
            this.use = new NameUseEnumFactory().fromType(value);
        } else if (name.equals("text")) {
            this.text = this.castToString(value);
        } else if (name.equals("family")) {
            this.getFamily().add(this.castToString(value));
        } else if (name.equals("given")) {
            this.getGiven().add(this.castToString(value));
        } else if (name.equals("prefix")) {
            this.getPrefix().add(this.castToString(value));
        } else if (name.equals("suffix")) {
            this.getSuffix().add(this.castToString(value));
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("use")) {
            throw new FHIRException("Cannot call addChild on a primitive type HumanName.use");
        }
        if (name.equals("text")) {
            throw new FHIRException("Cannot call addChild on a primitive type HumanName.text");
        }
        if (name.equals("family")) {
            throw new FHIRException("Cannot call addChild on a primitive type HumanName.family");
        }
        if (name.equals("given")) {
            throw new FHIRException("Cannot call addChild on a primitive type HumanName.given");
        }
        if (name.equals("prefix")) {
            throw new FHIRException("Cannot call addChild on a primitive type HumanName.prefix");
        }
        if (name.equals("suffix")) {
            throw new FHIRException("Cannot call addChild on a primitive type HumanName.suffix");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "HumanName";
    }

    @Override
    public HumanName copy() {
        HumanName dst = new HumanName();
        this.copyValues(dst);
        dst.use = this.use == null ? null : this.use.copy();
        StringType stringType = dst.text = this.text == null ? null : this.text.copy();
        if (this.family != null) {
            dst.family = new ArrayList<StringType>();
            for (StringType i : this.family) {
                dst.family.add(i.copy());
            }
        }
        if (this.given != null) {
            dst.given = new ArrayList<StringType>();
            for (StringType i : this.given) {
                dst.given.add(i.copy());
            }
        }
        if (this.prefix != null) {
            dst.prefix = new ArrayList<StringType>();
            for (StringType i : this.prefix) {
                dst.prefix.add(i.copy());
            }
        }
        if (this.suffix != null) {
            dst.suffix = new ArrayList<StringType>();
            for (StringType i : this.suffix) {
                dst.suffix.add(i.copy());
            }
        }
        dst.period = this.period == null ? null : this.period.copy();
        return dst;
    }

    @Override
    protected HumanName typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof HumanName)) {
            return false;
        }
        HumanName o = (HumanName)other;
        return HumanName.compareDeep(this.use, o.use, true) && HumanName.compareDeep(this.text, o.text, true) && HumanName.compareDeep(this.family, o.family, true) && HumanName.compareDeep(this.given, o.given, true) && HumanName.compareDeep(this.prefix, o.prefix, true) && HumanName.compareDeep(this.suffix, o.suffix, true) && HumanName.compareDeep(this.period, o.period, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof HumanName)) {
            return false;
        }
        HumanName o = (HumanName)other;
        return HumanName.compareValues(this.use, o.use, true) && HumanName.compareValues(this.text, o.text, true) && HumanName.compareValues(this.family, o.family, true) && HumanName.compareValues(this.given, o.given, true) && HumanName.compareValues(this.prefix, o.prefix, true) && HumanName.compareValues(this.suffix, o.suffix, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.use != null && !this.use.isEmpty() || this.text != null && !this.text.isEmpty() || this.family != null && !this.family.isEmpty() || this.given != null && !this.given.isEmpty() || this.prefix != null && !this.prefix.isEmpty() || this.suffix != null && !this.suffix.isEmpty() || this.period != null && !this.period.isEmpty());
    }

    public static class NameUseEnumFactory
    implements EnumFactory<NameUse> {
        @Override
        public NameUse fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("usual".equals(codeString)) {
                return NameUse.USUAL;
            }
            if ("official".equals(codeString)) {
                return NameUse.OFFICIAL;
            }
            if ("temp".equals(codeString)) {
                return NameUse.TEMP;
            }
            if ("nickname".equals(codeString)) {
                return NameUse.NICKNAME;
            }
            if ("anonymous".equals(codeString)) {
                return NameUse.ANONYMOUS;
            }
            if ("old".equals(codeString)) {
                return NameUse.OLD;
            }
            if ("maiden".equals(codeString)) {
                return NameUse.MAIDEN;
            }
            throw new IllegalArgumentException("Unknown NameUse code '" + codeString + "'");
        }

        public Enumeration<NameUse> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("usual".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.USUAL);
            }
            if ("official".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.OFFICIAL);
            }
            if ("temp".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.TEMP);
            }
            if ("nickname".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.NICKNAME);
            }
            if ("anonymous".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.ANONYMOUS);
            }
            if ("old".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.OLD);
            }
            if ("maiden".equals(codeString)) {
                return new Enumeration<NameUse>(this, NameUse.MAIDEN);
            }
            throw new FHIRException("Unknown NameUse code '" + codeString + "'");
        }

        @Override
        public String toCode(NameUse code) {
            if (code == NameUse.USUAL) {
                return "usual";
            }
            if (code == NameUse.OFFICIAL) {
                return "official";
            }
            if (code == NameUse.TEMP) {
                return "temp";
            }
            if (code == NameUse.NICKNAME) {
                return "nickname";
            }
            if (code == NameUse.ANONYMOUS) {
                return "anonymous";
            }
            if (code == NameUse.OLD) {
                return "old";
            }
            if (code == NameUse.MAIDEN) {
                return "maiden";
            }
            return "?";
        }
    }

    public static enum NameUse {
        USUAL,
        OFFICIAL,
        TEMP,
        NICKNAME,
        ANONYMOUS,
        OLD,
        MAIDEN,
        NULL;


        public static NameUse fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("usual".equals(codeString)) {
                return USUAL;
            }
            if ("official".equals(codeString)) {
                return OFFICIAL;
            }
            if ("temp".equals(codeString)) {
                return TEMP;
            }
            if ("nickname".equals(codeString)) {
                return NICKNAME;
            }
            if ("anonymous".equals(codeString)) {
                return ANONYMOUS;
            }
            if ("old".equals(codeString)) {
                return OLD;
            }
            if ("maiden".equals(codeString)) {
                return MAIDEN;
            }
            throw new FHIRException("Unknown NameUse code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case USUAL: {
                    return "usual";
                }
                case OFFICIAL: {
                    return "official";
                }
                case TEMP: {
                    return "temp";
                }
                case NICKNAME: {
                    return "nickname";
                }
                case ANONYMOUS: {
                    return "anonymous";
                }
                case OLD: {
                    return "old";
                }
                case MAIDEN: {
                    return "maiden";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case USUAL: {
                    return "http://hl7.org/fhir/name-use";
                }
                case OFFICIAL: {
                    return "http://hl7.org/fhir/name-use";
                }
                case TEMP: {
                    return "http://hl7.org/fhir/name-use";
                }
                case NICKNAME: {
                    return "http://hl7.org/fhir/name-use";
                }
                case ANONYMOUS: {
                    return "http://hl7.org/fhir/name-use";
                }
                case OLD: {
                    return "http://hl7.org/fhir/name-use";
                }
                case MAIDEN: {
                    return "http://hl7.org/fhir/name-use";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case USUAL: {
                    return "Known as/conventional/the one you normally use";
                }
                case OFFICIAL: {
                    return "The formal name as registered in an official (government) registry, but which name might not be commonly used. May be called \"legal name\".";
                }
                case TEMP: {
                    return "A temporary name. Name.period can provide more detailed information. This may also be used for temporary names assigned at birth or in emergency situations.";
                }
                case NICKNAME: {
                    return "A name that is used to address the person in an informal manner, but is not part of their formal or usual name";
                }
                case ANONYMOUS: {
                    return "Anonymous assigned name, alias, or pseudonym (used to protect a person's identity for privacy reasons)";
                }
                case OLD: {
                    return "This name is no longer in use (or was never correct, but retained for records)";
                }
                case MAIDEN: {
                    return "A name used prior to marriage. Marriage naming customs vary greatly around the world. This name use is for use by applications that collect and store \"maiden\" names. Though the concept of maiden name is often gender specific, the use of this term is not gender specific. The use of this term does not imply any particular history for a person's name, nor should the maiden name be determined algorithmically.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case USUAL: {
                    return "Usual";
                }
                case OFFICIAL: {
                    return "Official";
                }
                case TEMP: {
                    return "Temp";
                }
                case NICKNAME: {
                    return "Nickname";
                }
                case ANONYMOUS: {
                    return "Anonymous";
                }
                case OLD: {
                    return "Old";
                }
                case MAIDEN: {
                    return "Maiden";
                }
            }
            return "?";
        }
    }
}

