/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ReferralRequest", profile="http://hl7.org/fhir/Profile/ReferralRequest")
public class ReferralRequest
extends DomainResource {
    @Child(name="status", type={CodeType.class}, order=0, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | requested | active | cancelled | accepted | rejected | completed", formalDefinition="The workflow status of the referral or transfer of care request.")
    protected Enumeration<ReferralStatus> status;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business identifier", formalDefinition="Business identifier that uniquely identifies the referral/care transfer request instance.")
    protected List<Identifier> identifier;
    @Child(name="date", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date of creation/activation", formalDefinition="Date/DateTime of creation for draft requests and date of activation for active requests.")
    protected DateTimeType date;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Referral/Transition of care request type", formalDefinition="An indication of the type of referral (or where applicable the type of transfer of care) request.")
    protected CodeableConcept type;
    @Child(name="specialty", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The clinical specialty (discipline) that the referral is requested for", formalDefinition="Indication of the clinical domain or discipline to which the referral or transfer of care request is sent.  For example: Cardiology Gastroenterology Diabetology.")
    protected CodeableConcept specialty;
    @Child(name="priority", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Urgency of referral / transfer of care request", formalDefinition="An indication of the urgency of referral (or where applicable the type of transfer of care) request.")
    protected CodeableConcept priority;
    @Child(name="patient", type={Patient.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient referred to care or transfer", formalDefinition="The patient who is the subject of a referral or transfer of care request.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="requester", type={Practitioner.class, Organization.class, Patient.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Requester of referral / transfer of care", formalDefinition="The healthcare provider or provider organization who/which initiated the referral/transfer of care request. Can also be  Patient (a self referral).")
    protected Reference requester;
    protected Resource requesterTarget;
    @Child(name="recipient", type={Practitioner.class, Organization.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Receiver of referral / transfer of care request", formalDefinition="The healthcare provider(s) or provider organization(s) who/which is to receive the referral/transfer of care request.")
    protected List<Reference> recipient;
    protected List<Resource> recipientTarget;
    @Child(name="encounter", type={Encounter.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Originating encounter", formalDefinition="The encounter at which the request for referral or transfer of care is initiated.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="dateSent", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date referral/transfer of care request is sent", formalDefinition="Date/DateTime the request for referral or transfer of care is sent by the author.")
    protected DateTimeType dateSent;
    @Child(name="reason", type={CodeableConcept.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for referral / transfer of care request", formalDefinition="Description of clinical condition indicating why referral/transfer of care is requested.  For example:  Pathological Anomalies, Disabled (physical or mental),  Behavioral Management.")
    protected CodeableConcept reason;
    @Child(name="description", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A textual description of the referral", formalDefinition="The reason element gives a short description of why the referral is being made, the description expands on this to support a more complete clinical summary.")
    protected StringType description;
    @Child(name="serviceRequested", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Actions requested as part of the referral", formalDefinition="The service(s) that is/are requested to be provided to the patient.  For example: cardiac pacemaker insertion.")
    protected List<CodeableConcept> serviceRequested;
    @Child(name="supportingInformation", type={}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additonal information to support referral or transfer of care request", formalDefinition="Any additional (administrative, financial or clinical) information required to support request for referral or transfer of care.  For example: Presenting problems/chief complaints Medical History Family History Alerts Allergy/Intolerance and Adverse Reactions Medications Observations/Assessments (may include cognitive and fundtional assessments) Diagnostic Reports Care Plan.")
    protected List<Reference> supportingInformation;
    protected List<Resource> supportingInformationTarget;
    @Child(name="fulfillmentTime", type={Period.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Requested service(s) fulfillment time", formalDefinition="The period of time within which the services identified in the referral/transfer of care is specified or required to occur.")
    protected Period fulfillmentTime;
    private static final long serialVersionUID = 1948652599L;
    @SearchParamDefinition(name="date", path="ReferralRequest.date", description="Creation or activation date", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="requester", path="ReferralRequest.requester", description="Requester of referral / transfer of care", type="reference")
    public static final String SP_REQUESTER = "requester";
    @SearchParamDefinition(name="specialty", path="ReferralRequest.specialty", description="The specialty that the referral is for", type="token")
    public static final String SP_SPECIALTY = "specialty";
    @SearchParamDefinition(name="patient", path="ReferralRequest.patient", description="Who the referral is about", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="recipient", path="ReferralRequest.recipient", description="The person that the referral was sent to", type="reference")
    public static final String SP_RECIPIENT = "recipient";
    @SearchParamDefinition(name="type", path="ReferralRequest.type", description="The type of the referral", type="token")
    public static final String SP_TYPE = "type";
    @SearchParamDefinition(name="priority", path="ReferralRequest.priority", description="The priority assigned to the referral", type="token")
    public static final String SP_PRIORITY = "priority";
    @SearchParamDefinition(name="status", path="ReferralRequest.status", description="The status of the referral", type="token")
    public static final String SP_STATUS = "status";

    public ReferralRequest() {
    }

    public ReferralRequest(Enumeration<ReferralStatus> status) {
        this.status = status;
    }

    public Enumeration<ReferralStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ReferralStatus>(new ReferralStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ReferralRequest setStatusElement(Enumeration<ReferralStatus> value) {
        this.status = value;
        return this;
    }

    public ReferralStatus getStatus() {
        return this.status == null ? null : (ReferralStatus)((Object)this.status.getValue());
    }

    public ReferralRequest setStatus(ReferralStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ReferralStatus>(new ReferralStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ReferralRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ReferralRequest setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ReferralRequest setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ReferralRequest setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getSpecialty() {
        if (this.specialty == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.specialty");
            }
            if (Configuration.doAutoCreate()) {
                this.specialty = new CodeableConcept();
            }
        }
        return this.specialty;
    }

    public boolean hasSpecialty() {
        return this.specialty != null && !this.specialty.isEmpty();
    }

    public ReferralRequest setSpecialty(CodeableConcept value) {
        this.specialty = value;
        return this;
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public ReferralRequest setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ReferralRequest setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ReferralRequest setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new Reference();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public ReferralRequest setRequester(Reference value) {
        this.requester = value;
        return this;
    }

    public Resource getRequesterTarget() {
        return this.requesterTarget;
    }

    public ReferralRequest setRequesterTarget(Resource value) {
        this.requesterTarget = value;
        return this;
    }

    public List<Reference> getRecipient() {
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        return this.recipient;
    }

    public boolean hasRecipient() {
        if (this.recipient == null) {
            return false;
        }
        for (Reference item : this.recipient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRecipient() {
        Reference t = new Reference();
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return t;
    }

    public ReferralRequest addRecipient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return this;
    }

    public List<Resource> getRecipientTarget() {
        if (this.recipientTarget == null) {
            this.recipientTarget = new ArrayList<Resource>();
        }
        return this.recipientTarget;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public ReferralRequest setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public ReferralRequest setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public DateTimeType getDateSentElement() {
        if (this.dateSent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.dateSent");
            }
            if (Configuration.doAutoCreate()) {
                this.dateSent = new DateTimeType();
            }
        }
        return this.dateSent;
    }

    public boolean hasDateSentElement() {
        return this.dateSent != null && !this.dateSent.isEmpty();
    }

    public boolean hasDateSent() {
        return this.dateSent != null && !this.dateSent.isEmpty();
    }

    public ReferralRequest setDateSentElement(DateTimeType value) {
        this.dateSent = value;
        return this;
    }

    public Date getDateSent() {
        return this.dateSent == null ? null : (Date)this.dateSent.getValue();
    }

    public ReferralRequest setDateSent(Date value) {
        if (value == null) {
            this.dateSent = null;
        } else {
            if (this.dateSent == null) {
                this.dateSent = new DateTimeType();
            }
            this.dateSent.setValue(value);
        }
        return this;
    }

    public CodeableConcept getReason() {
        if (this.reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.reason");
            }
            if (Configuration.doAutoCreate()) {
                this.reason = new CodeableConcept();
            }
        }
        return this.reason;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public ReferralRequest setReason(CodeableConcept value) {
        this.reason = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ReferralRequest setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ReferralRequest setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getServiceRequested() {
        if (this.serviceRequested == null) {
            this.serviceRequested = new ArrayList<CodeableConcept>();
        }
        return this.serviceRequested;
    }

    public boolean hasServiceRequested() {
        if (this.serviceRequested == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceRequested) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceRequested() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceRequested == null) {
            this.serviceRequested = new ArrayList<CodeableConcept>();
        }
        this.serviceRequested.add(t);
        return t;
    }

    public ReferralRequest addServiceRequested(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceRequested == null) {
            this.serviceRequested = new ArrayList<CodeableConcept>();
        }
        this.serviceRequested.add(t);
        return this;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public ReferralRequest addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public List<Resource> getSupportingInformationTarget() {
        if (this.supportingInformationTarget == null) {
            this.supportingInformationTarget = new ArrayList<Resource>();
        }
        return this.supportingInformationTarget;
    }

    public Period getFulfillmentTime() {
        if (this.fulfillmentTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.fulfillmentTime");
            }
            if (Configuration.doAutoCreate()) {
                this.fulfillmentTime = new Period();
            }
        }
        return this.fulfillmentTime;
    }

    public boolean hasFulfillmentTime() {
        return this.fulfillmentTime != null && !this.fulfillmentTime.isEmpty();
    }

    public ReferralRequest setFulfillmentTime(Period value) {
        this.fulfillmentTime = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_STATUS, "code", "The workflow status of the referral or transfer of care request.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("identifier", "Identifier", "Business identifier that uniquely identifies the referral/care transfer request instance.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_DATE, "dateTime", "Date/DateTime of creation for draft requests and date of activation for active requests.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "An indication of the type of referral (or where applicable the type of transfer of care) request.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_SPECIALTY, "CodeableConcept", "Indication of the clinical domain or discipline to which the referral or transfer of care request is sent.  For example: Cardiology Gastroenterology Diabetology.", 0, Integer.MAX_VALUE, this.specialty));
        childrenList.add(new Property(SP_PRIORITY, "CodeableConcept", "An indication of the urgency of referral (or where applicable the type of transfer of care) request.", 0, Integer.MAX_VALUE, this.priority));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient who is the subject of a referral or transfer of care request.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_REQUESTER, "Reference(Practitioner|Organization|Patient)", "The healthcare provider or provider organization who/which initiated the referral/transfer of care request. Can also be  Patient (a self referral).", 0, Integer.MAX_VALUE, this.requester));
        childrenList.add(new Property(SP_RECIPIENT, "Reference(Practitioner|Organization)", "The healthcare provider(s) or provider organization(s) who/which is to receive the referral/transfer of care request.", 0, Integer.MAX_VALUE, this.recipient));
        childrenList.add(new Property("encounter", "Reference(Encounter)", "The encounter at which the request for referral or transfer of care is initiated.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property("dateSent", "dateTime", "Date/DateTime the request for referral or transfer of care is sent by the author.", 0, Integer.MAX_VALUE, this.dateSent));
        childrenList.add(new Property("reason", "CodeableConcept", "Description of clinical condition indicating why referral/transfer of care is requested.  For example:  Pathological Anomalies, Disabled (physical or mental),  Behavioral Management.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property("description", "string", "The reason element gives a short description of why the referral is being made, the description expands on this to support a more complete clinical summary.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("serviceRequested", "CodeableConcept", "The service(s) that is/are requested to be provided to the patient.  For example: cardiac pacemaker insertion.", 0, Integer.MAX_VALUE, this.serviceRequested));
        childrenList.add(new Property("supportingInformation", "Reference(Any)", "Any additional (administrative, financial or clinical) information required to support request for referral or transfer of care.  For example: Presenting problems/chief complaints Medical History Family History Alerts Allergy/Intolerance and Adverse Reactions Medications Observations/Assessments (may include cognitive and fundtional assessments) Diagnostic Reports Care Plan.", 0, Integer.MAX_VALUE, this.supportingInformation));
        childrenList.add(new Property("fulfillmentTime", "Period", "The period of time within which the services identified in the referral/transfer of care is specified or required to occur.", 0, Integer.MAX_VALUE, this.fulfillmentTime));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_STATUS)) {
            this.status = new ReferralStatusEnumFactory().fromType(value);
        } else if (name.equals("identifier")) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SPECIALTY)) {
            this.specialty = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PRIORITY)) {
            this.priority = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = this.castToReference(value);
        } else if (name.equals(SP_RECIPIENT)) {
            this.getRecipient().add(this.castToReference(value));
        } else if (name.equals("encounter")) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("dateSent")) {
            this.dateSent = this.castToDateTime(value);
        } else if (name.equals("reason")) {
            this.reason = this.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("serviceRequested")) {
            this.getServiceRequested().add(this.castToCodeableConcept(value));
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(this.castToReference(value));
        } else if (name.equals("fulfillmentTime")) {
            this.fulfillmentTime = this.castToPeriod(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ReferralRequest.status");
        }
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ReferralRequest.date");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_SPECIALTY)) {
            this.specialty = new CodeableConcept();
            return this.specialty;
        }
        if (name.equals(SP_PRIORITY)) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new Reference();
            return this.requester;
        }
        if (name.equals(SP_RECIPIENT)) {
            return this.addRecipient();
        }
        if (name.equals("encounter")) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("dateSent")) {
            throw new FHIRException("Cannot call addChild on a primitive type ReferralRequest.dateSent");
        }
        if (name.equals("reason")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type ReferralRequest.description");
        }
        if (name.equals("serviceRequested")) {
            return this.addServiceRequested();
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        if (name.equals("fulfillmentTime")) {
            this.fulfillmentTime = new Period();
            return this.fulfillmentTime;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ReferralRequest";
    }

    @Override
    public ReferralRequest copy() {
        ReferralRequest dst = new ReferralRequest();
        this.copyValues(dst);
        Enumeration<ReferralStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.specialty = this.specialty == null ? null : this.specialty.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        Reference reference = dst.requester = this.requester == null ? null : this.requester.copy();
        if (this.recipient != null) {
            dst.recipient = new ArrayList<Reference>();
            for (Reference reference2 : this.recipient) {
                dst.recipient.add(reference2.copy());
            }
        }
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.dateSent = this.dateSent == null ? null : this.dateSent.copy();
        dst.reason = this.reason == null ? null : this.reason.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.serviceRequested != null) {
            dst.serviceRequested = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.serviceRequested) {
                dst.serviceRequested.add(codeableConcept.copy());
            }
        }
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference3 : this.supportingInformation) {
                dst.supportingInformation.add(reference3.copy());
            }
        }
        dst.fulfillmentTime = this.fulfillmentTime == null ? null : this.fulfillmentTime.copy();
        return dst;
    }

    protected ReferralRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ReferralRequest)) {
            return false;
        }
        ReferralRequest o = (ReferralRequest)other;
        return ReferralRequest.compareDeep(this.status, o.status, true) && ReferralRequest.compareDeep(this.identifier, o.identifier, true) && ReferralRequest.compareDeep(this.date, o.date, true) && ReferralRequest.compareDeep(this.type, o.type, true) && ReferralRequest.compareDeep(this.specialty, o.specialty, true) && ReferralRequest.compareDeep(this.priority, o.priority, true) && ReferralRequest.compareDeep(this.patient, o.patient, true) && ReferralRequest.compareDeep(this.requester, o.requester, true) && ReferralRequest.compareDeep(this.recipient, o.recipient, true) && ReferralRequest.compareDeep(this.encounter, o.encounter, true) && ReferralRequest.compareDeep(this.dateSent, o.dateSent, true) && ReferralRequest.compareDeep(this.reason, o.reason, true) && ReferralRequest.compareDeep(this.description, o.description, true) && ReferralRequest.compareDeep(this.serviceRequested, o.serviceRequested, true) && ReferralRequest.compareDeep(this.supportingInformation, o.supportingInformation, true) && ReferralRequest.compareDeep(this.fulfillmentTime, o.fulfillmentTime, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ReferralRequest)) {
            return false;
        }
        ReferralRequest o = (ReferralRequest)other;
        return ReferralRequest.compareValues(this.status, o.status, true) && ReferralRequest.compareValues(this.date, o.date, true) && ReferralRequest.compareValues(this.dateSent, o.dateSent, true) && ReferralRequest.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.status != null && !this.status.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.date != null && !this.date.isEmpty() || this.type != null && !this.type.isEmpty() || this.specialty != null && !this.specialty.isEmpty() || this.priority != null && !this.priority.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.requester != null && !this.requester.isEmpty() || this.recipient != null && !this.recipient.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.dateSent != null && !this.dateSent.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.description != null && !this.description.isEmpty() || this.serviceRequested != null && !this.serviceRequested.isEmpty() || this.supportingInformation != null && !this.supportingInformation.isEmpty() || this.fulfillmentTime != null && !this.fulfillmentTime.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ReferralRequest;
    }

    public static class ReferralStatusEnumFactory
    implements EnumFactory<ReferralStatus> {
        @Override
        public ReferralStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return ReferralStatus.DRAFT;
            }
            if ("requested".equals(codeString)) {
                return ReferralStatus.REQUESTED;
            }
            if ("active".equals(codeString)) {
                return ReferralStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return ReferralStatus.CANCELLED;
            }
            if ("accepted".equals(codeString)) {
                return ReferralStatus.ACCEPTED;
            }
            if ("rejected".equals(codeString)) {
                return ReferralStatus.REJECTED;
            }
            if ("completed".equals(codeString)) {
                return ReferralStatus.COMPLETED;
            }
            throw new IllegalArgumentException("Unknown ReferralStatus code '" + codeString + "'");
        }

        public Enumeration<ReferralStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ReferralStatus>(this, ReferralStatus.DRAFT);
            }
            if ("requested".equals(codeString)) {
                return new Enumeration<ReferralStatus>(this, ReferralStatus.REQUESTED);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ReferralStatus>(this, ReferralStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ReferralStatus>(this, ReferralStatus.CANCELLED);
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<ReferralStatus>(this, ReferralStatus.ACCEPTED);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<ReferralStatus>(this, ReferralStatus.REJECTED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ReferralStatus>(this, ReferralStatus.COMPLETED);
            }
            throw new FHIRException("Unknown ReferralStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ReferralStatus code) {
            if (code == ReferralStatus.DRAFT) {
                return "draft";
            }
            if (code == ReferralStatus.REQUESTED) {
                return "requested";
            }
            if (code == ReferralStatus.ACTIVE) {
                return "active";
            }
            if (code == ReferralStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ReferralStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == ReferralStatus.REJECTED) {
                return "rejected";
            }
            if (code == ReferralStatus.COMPLETED) {
                return "completed";
            }
            return "?";
        }
    }

    public static enum ReferralStatus {
        DRAFT,
        REQUESTED,
        ACTIVE,
        CANCELLED,
        ACCEPTED,
        REJECTED,
        COMPLETED,
        NULL;


        public static ReferralStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("requested".equals(codeString)) {
                return REQUESTED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            throw new FHIRException("Unknown ReferralStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case REQUESTED: {
                    return "requested";
                }
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ACCEPTED: {
                    return "accepted";
                }
                case REJECTED: {
                    return "rejected";
                }
                case COMPLETED: {
                    return "completed";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/referralstatus";
                }
                case REQUESTED: {
                    return "http://hl7.org/fhir/referralstatus";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/referralstatus";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/referralstatus";
                }
                case ACCEPTED: {
                    return "http://hl7.org/fhir/referralstatus";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/referralstatus";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/referralstatus";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "A draft referral that has yet to be send.";
                }
                case REQUESTED: {
                    return "The referral has been transmitted, but not yet acknowledged by the recipient.";
                }
                case ACTIVE: {
                    return "The referral has been acknowledged by the recipient, and is in the process of being actioned.";
                }
                case CANCELLED: {
                    return "The referral has been cancelled without being completed. For example it is no longer needed.";
                }
                case ACCEPTED: {
                    return "The recipient has agreed to deliver the care requested by the referral.";
                }
                case REJECTED: {
                    return "The recipient has declined to accept the referral.";
                }
                case COMPLETED: {
                    return "The referral has been completely actioned.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case REQUESTED: {
                    return "Requested";
                }
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ACCEPTED: {
                    return "Accepted";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case COMPLETED: {
                    return "Completed";
                }
            }
            return "?";
        }
    }
}

