/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.formats;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.math.BigDecimal;
import org.hl7.fhir.dstu2.formats.JsonParserBase;
import org.hl7.fhir.dstu2.model.Account;
import org.hl7.fhir.dstu2.model.Address;
import org.hl7.fhir.dstu2.model.Age;
import org.hl7.fhir.dstu2.model.AllergyIntolerance;
import org.hl7.fhir.dstu2.model.Annotation;
import org.hl7.fhir.dstu2.model.Appointment;
import org.hl7.fhir.dstu2.model.AppointmentResponse;
import org.hl7.fhir.dstu2.model.Attachment;
import org.hl7.fhir.dstu2.model.AuditEvent;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base64BinaryType;
import org.hl7.fhir.dstu2.model.Basic;
import org.hl7.fhir.dstu2.model.Binary;
import org.hl7.fhir.dstu2.model.BodySite;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.Bundle;
import org.hl7.fhir.dstu2.model.CarePlan;
import org.hl7.fhir.dstu2.model.Claim;
import org.hl7.fhir.dstu2.model.ClaimResponse;
import org.hl7.fhir.dstu2.model.ClinicalImpression;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Communication;
import org.hl7.fhir.dstu2.model.CommunicationRequest;
import org.hl7.fhir.dstu2.model.Composition;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.Condition;
import org.hl7.fhir.dstu2.model.Conformance;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.Contract;
import org.hl7.fhir.dstu2.model.Count;
import org.hl7.fhir.dstu2.model.Coverage;
import org.hl7.fhir.dstu2.model.DataElement;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DateType;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.DetectedIssue;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DeviceComponent;
import org.hl7.fhir.dstu2.model.DeviceMetric;
import org.hl7.fhir.dstu2.model.DeviceUseRequest;
import org.hl7.fhir.dstu2.model.DeviceUseStatement;
import org.hl7.fhir.dstu2.model.DiagnosticOrder;
import org.hl7.fhir.dstu2.model.DiagnosticReport;
import org.hl7.fhir.dstu2.model.Distance;
import org.hl7.fhir.dstu2.model.DocumentManifest;
import org.hl7.fhir.dstu2.model.DocumentReference;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Duration;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.ElementDefinition;
import org.hl7.fhir.dstu2.model.EligibilityRequest;
import org.hl7.fhir.dstu2.model.EligibilityResponse;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnrollmentRequest;
import org.hl7.fhir.dstu2.model.EnrollmentResponse;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.EpisodeOfCare;
import org.hl7.fhir.dstu2.model.ExplanationOfBenefit;
import org.hl7.fhir.dstu2.model.Extension;
import org.hl7.fhir.dstu2.model.ExtensionHelper;
import org.hl7.fhir.dstu2.model.FamilyMemberHistory;
import org.hl7.fhir.dstu2.model.Flag;
import org.hl7.fhir.dstu2.model.Goal;
import org.hl7.fhir.dstu2.model.Group;
import org.hl7.fhir.dstu2.model.HealthcareService;
import org.hl7.fhir.dstu2.model.HumanName;
import org.hl7.fhir.dstu2.model.IdType;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.ImagingObjectSelection;
import org.hl7.fhir.dstu2.model.ImagingStudy;
import org.hl7.fhir.dstu2.model.Immunization;
import org.hl7.fhir.dstu2.model.ImmunizationRecommendation;
import org.hl7.fhir.dstu2.model.ImplementationGuide;
import org.hl7.fhir.dstu2.model.InstantType;
import org.hl7.fhir.dstu2.model.IntegerType;
import org.hl7.fhir.dstu2.model.List_;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.MarkdownType;
import org.hl7.fhir.dstu2.model.Media;
import org.hl7.fhir.dstu2.model.Medication;
import org.hl7.fhir.dstu2.model.MedicationAdministration;
import org.hl7.fhir.dstu2.model.MedicationDispense;
import org.hl7.fhir.dstu2.model.MedicationOrder;
import org.hl7.fhir.dstu2.model.MedicationStatement;
import org.hl7.fhir.dstu2.model.MessageHeader;
import org.hl7.fhir.dstu2.model.Meta;
import org.hl7.fhir.dstu2.model.Money;
import org.hl7.fhir.dstu2.model.NamingSystem;
import org.hl7.fhir.dstu2.model.Narrative;
import org.hl7.fhir.dstu2.model.NutritionOrder;
import org.hl7.fhir.dstu2.model.Observation;
import org.hl7.fhir.dstu2.model.OidType;
import org.hl7.fhir.dstu2.model.OperationDefinition;
import org.hl7.fhir.dstu2.model.OperationOutcome;
import org.hl7.fhir.dstu2.model.Order;
import org.hl7.fhir.dstu2.model.OrderResponse;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Parameters;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.PaymentNotice;
import org.hl7.fhir.dstu2.model.PaymentReconciliation;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Person;
import org.hl7.fhir.dstu2.model.PositiveIntType;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.Procedure;
import org.hl7.fhir.dstu2.model.ProcedureRequest;
import org.hl7.fhir.dstu2.model.ProcessRequest;
import org.hl7.fhir.dstu2.model.ProcessResponse;
import org.hl7.fhir.dstu2.model.Provenance;
import org.hl7.fhir.dstu2.model.Quantity;
import org.hl7.fhir.dstu2.model.Questionnaire;
import org.hl7.fhir.dstu2.model.QuestionnaireResponse;
import org.hl7.fhir.dstu2.model.Range;
import org.hl7.fhir.dstu2.model.Ratio;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ReferralRequest;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.RiskAssessment;
import org.hl7.fhir.dstu2.model.SampledData;
import org.hl7.fhir.dstu2.model.Schedule;
import org.hl7.fhir.dstu2.model.SearchParameter;
import org.hl7.fhir.dstu2.model.Signature;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.Slot;
import org.hl7.fhir.dstu2.model.Specimen;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu2.model.Subscription;
import org.hl7.fhir.dstu2.model.Substance;
import org.hl7.fhir.dstu2.model.SupplyDelivery;
import org.hl7.fhir.dstu2.model.SupplyRequest;
import org.hl7.fhir.dstu2.model.TestScript;
import org.hl7.fhir.dstu2.model.TimeType;
import org.hl7.fhir.dstu2.model.Timing;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.dstu2.model.UnsignedIntType;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.dstu2.model.UuidType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.model.VisionPrescription;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;

public class JsonParser
extends JsonParserBase {
    public JsonParser() {
    }

    public JsonParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    @Override
    protected void parseElementProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
        super.parseElementProperties(json, element);
        if (json.has("extension")) {
            JsonArray array = json.getAsJsonArray("extension");
            for (int i = 0; i < array.size(); ++i) {
                element.getExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected void parseBackboneProperties(JsonObject json, BackboneElement element) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, element);
        if (json.has("modifierExtension")) {
            JsonArray array = json.getAsJsonArray("modifierExtension");
            for (int i = 0; i < array.size(); ++i) {
                element.getModifierExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected void parseTypeProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, element);
    }

    protected <E extends Enum<E>> Enumeration<E> parseEnumeration(String s, E item, EnumFactory e) throws IOException, FHIRFormatError {
        Enumeration res = new Enumeration(e);
        if (s != null) {
            res.setValue(e.fromCode(s));
        }
        return res;
    }

    protected DateType parseDate(String v) throws IOException, FHIRFormatError {
        DateType res = new DateType(v);
        return res;
    }

    protected DateTimeType parseDateTime(String v) throws IOException, FHIRFormatError {
        DateTimeType res = new DateTimeType(v);
        return res;
    }

    protected CodeType parseCode(String v) throws IOException, FHIRFormatError {
        CodeType res = new CodeType(v);
        return res;
    }

    protected StringType parseString(String v) throws IOException, FHIRFormatError {
        StringType res = new StringType(v);
        return res;
    }

    protected IntegerType parseInteger(Long v) throws IOException, FHIRFormatError {
        IntegerType res = new IntegerType(v);
        return res;
    }

    protected OidType parseOid(String v) throws IOException, FHIRFormatError {
        OidType res = new OidType(v);
        return res;
    }

    protected UriType parseUri(String v) throws IOException, FHIRFormatError {
        UriType res = new UriType(v);
        return res;
    }

    protected UuidType parseUuid(String v) throws IOException, FHIRFormatError {
        UuidType res = new UuidType(v);
        return res;
    }

    protected InstantType parseInstant(String v) throws IOException, FHIRFormatError {
        InstantType res = new InstantType(v);
        return res;
    }

    protected BooleanType parseBoolean(Boolean v) throws IOException, FHIRFormatError {
        BooleanType res = new BooleanType(v);
        return res;
    }

    protected Base64BinaryType parseBase64Binary(String v) throws IOException, FHIRFormatError {
        Base64BinaryType res = new Base64BinaryType(v);
        return res;
    }

    protected UnsignedIntType parseUnsignedInt(String v) throws IOException, FHIRFormatError {
        UnsignedIntType res = new UnsignedIntType(v);
        return res;
    }

    protected MarkdownType parseMarkdown(String v) throws IOException, FHIRFormatError {
        MarkdownType res = new MarkdownType(v);
        return res;
    }

    protected TimeType parseTime(String v) throws IOException, FHIRFormatError {
        TimeType res = new TimeType(v);
        return res;
    }

    protected IdType parseId(String v) throws IOException, FHIRFormatError {
        IdType res = new IdType(v);
        return res;
    }

    protected PositiveIntType parsePositiveInt(String v) throws IOException, FHIRFormatError {
        PositiveIntType res = new PositiveIntType(v);
        return res;
    }

    protected DecimalType parseDecimal(BigDecimal v) throws IOException, FHIRFormatError {
        DecimalType res = new DecimalType(v);
        return res;
    }

    protected Extension parseExtension(JsonObject json) throws IOException, FHIRFormatError {
        Type value;
        Extension res = new Extension();
        this.parseElementProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        return res;
    }

    protected Narrative parseNarrative(JsonObject json) throws IOException, FHIRFormatError {
        Narrative res = new Narrative();
        this.parseElementProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("div")) {
            res.setDiv(this.parseXhtml(json.get("div").getAsString()));
        }
        return res;
    }

    protected Identifier parseIdentifier(JsonObject json) throws IOException, FHIRFormatError {
        Identifier res = new Identifier();
        this.parseTypeProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("assigner")) {
            res.setAssigner(this.parseReference(json.getAsJsonObject("assigner")));
        }
        return res;
    }

    protected Coding parseCoding(JsonObject json) throws IOException, FHIRFormatError {
        Coding res = new Coding();
        this.parseTypeProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("userSelected")) {
            res.setUserSelectedElement(this.parseBoolean(json.get("userSelected").getAsBoolean()));
        }
        if (json.has("_userSelected")) {
            this.parseElementProperties(json.getAsJsonObject("_userSelected"), res.getUserSelectedElement());
        }
        return res;
    }

    protected Reference parseReference(JsonObject json) throws IOException, FHIRFormatError {
        Reference res = new Reference();
        this.parseTypeProperties(json, res);
        if (json.has("reference")) {
            res.setReferenceElement(this.parseString(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        return res;
    }

    protected Signature parseSignature(JsonObject json) throws IOException, FHIRFormatError {
        Type who;
        Signature res = new Signature();
        this.parseTypeProperties(json, res);
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("when")) {
            res.setWhenElement(this.parseInstant(json.get("when").getAsString()));
        }
        if (json.has("_when")) {
            this.parseElementProperties(json.getAsJsonObject("_when"), res.getWhenElement());
        }
        if ((who = this.parseType("who", json)) != null) {
            res.setWho(who);
        }
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("blob")) {
            res.setBlobElement(this.parseBase64Binary(json.get("blob").getAsString()));
        }
        if (json.has("_blob")) {
            this.parseElementProperties(json.getAsJsonObject("_blob"), res.getBlobElement());
        }
        return res;
    }

    protected SampledData parseSampledData(JsonObject json) throws IOException, FHIRFormatError {
        SampledData res = new SampledData();
        this.parseTypeProperties(json, res);
        if (json.has("origin")) {
            res.setOrigin(this.parseSimpleQuantity(json.getAsJsonObject("origin")));
        }
        if (json.has("period")) {
            res.setPeriodElement(this.parseDecimal(json.get("period").getAsBigDecimal()));
        }
        if (json.has("_period")) {
            this.parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("lowerLimit")) {
            res.setLowerLimitElement(this.parseDecimal(json.get("lowerLimit").getAsBigDecimal()));
        }
        if (json.has("_lowerLimit")) {
            this.parseElementProperties(json.getAsJsonObject("_lowerLimit"), res.getLowerLimitElement());
        }
        if (json.has("upperLimit")) {
            res.setUpperLimitElement(this.parseDecimal(json.get("upperLimit").getAsBigDecimal()));
        }
        if (json.has("_upperLimit")) {
            this.parseElementProperties(json.getAsJsonObject("_upperLimit"), res.getUpperLimitElement());
        }
        if (json.has("dimensions")) {
            res.setDimensionsElement(this.parsePositiveInt(json.get("dimensions").getAsString()));
        }
        if (json.has("_dimensions")) {
            this.parseElementProperties(json.getAsJsonObject("_dimensions"), res.getDimensionsElement());
        }
        if (json.has("data")) {
            res.setDataElement(this.parseString(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
        }
        return res;
    }

    protected Quantity parseQuantity(JsonObject json) throws IOException, FHIRFormatError {
        Quantity res = new Quantity();
        this.parseTypeProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected Period parsePeriod(JsonObject json) throws IOException, FHIRFormatError {
        Period res = new Period();
        this.parseTypeProperties(json, res);
        if (json.has("start")) {
            res.setStartElement(this.parseDateTime(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseDateTime(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        return res;
    }

    protected Attachment parseAttachment(JsonObject json) throws IOException, FHIRFormatError {
        Attachment res = new Attachment();
        this.parseTypeProperties(json, res);
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("data")) {
            res.setDataElement(this.parseBase64Binary(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("size")) {
            res.setSizeElement(this.parseUnsignedInt(json.get("size").getAsString()));
        }
        if (json.has("_size")) {
            this.parseElementProperties(json.getAsJsonObject("_size"), res.getSizeElement());
        }
        if (json.has("hash")) {
            res.setHashElement(this.parseBase64Binary(json.get("hash").getAsString()));
        }
        if (json.has("_hash")) {
            this.parseElementProperties(json.getAsJsonObject("_hash"), res.getHashElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("creation")) {
            res.setCreationElement(this.parseDateTime(json.get("creation").getAsString()));
        }
        if (json.has("_creation")) {
            this.parseElementProperties(json.getAsJsonObject("_creation"), res.getCreationElement());
        }
        return res;
    }

    protected Ratio parseRatio(JsonObject json) throws IOException, FHIRFormatError {
        Ratio res = new Ratio();
        this.parseTypeProperties(json, res);
        if (json.has("numerator")) {
            res.setNumerator(this.parseQuantity(json.getAsJsonObject("numerator")));
        }
        if (json.has("denominator")) {
            res.setDenominator(this.parseQuantity(json.getAsJsonObject("denominator")));
        }
        return res;
    }

    protected Range parseRange(JsonObject json) throws IOException, FHIRFormatError {
        Range res = new Range();
        this.parseTypeProperties(json, res);
        if (json.has("low")) {
            res.setLow(this.parseSimpleQuantity(json.getAsJsonObject("low")));
        }
        if (json.has("high")) {
            res.setHigh(this.parseSimpleQuantity(json.getAsJsonObject("high")));
        }
        return res;
    }

    protected Annotation parseAnnotation(JsonObject json) throws IOException, FHIRFormatError {
        Annotation res = new Annotation();
        this.parseTypeProperties(json, res);
        Type author = this.parseType("author", json);
        if (author != null) {
            res.setAuthor(author);
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        return res;
    }

    protected CodeableConcept parseCodeableConcept(JsonObject json) throws IOException, FHIRFormatError {
        CodeableConcept res = new CodeableConcept();
        this.parseTypeProperties(json, res);
        if (json.has("coding")) {
            JsonArray array = json.getAsJsonArray("coding");
            for (int i = 0; i < array.size(); ++i) {
                res.getCoding().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        return res;
    }

    protected Money parseMoney(JsonObject json) throws IOException, FHIRFormatError {
        Money res = new Money();
        this.parseElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected SimpleQuantity parseSimpleQuantity(JsonObject json) throws IOException, FHIRFormatError {
        SimpleQuantity res = new SimpleQuantity();
        this.parseElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected Duration parseDuration(JsonObject json) throws IOException, FHIRFormatError {
        Duration res = new Duration();
        this.parseElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected Count parseCount(JsonObject json) throws IOException, FHIRFormatError {
        Count res = new Count();
        this.parseElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected Distance parseDistance(JsonObject json) throws IOException, FHIRFormatError {
        Distance res = new Distance();
        this.parseElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected Age parseAge(JsonObject json) throws IOException, FHIRFormatError {
        Age res = new Age();
        this.parseElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected HumanName parseHumanName(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        HumanName res = new HumanName();
        this.parseElementProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("family")) {
            array = json.getAsJsonArray("family");
            for (i = 0; i < array.size(); ++i) {
                res.getFamily().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_family")) {
            array = json.getAsJsonArray("_family");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getFamily().size()) {
                    res.getFamily().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getFamily().get(i));
            }
        }
        if (json.has("given")) {
            array = json.getAsJsonArray("given");
            for (i = 0; i < array.size(); ++i) {
                res.getGiven().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_given")) {
            array = json.getAsJsonArray("_given");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getGiven().size()) {
                    res.getGiven().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getGiven().get(i));
            }
        }
        if (json.has("prefix")) {
            array = json.getAsJsonArray("prefix");
            for (i = 0; i < array.size(); ++i) {
                res.getPrefix().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_prefix")) {
            array = json.getAsJsonArray("_prefix");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPrefix().size()) {
                    res.getPrefix().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPrefix().get(i));
            }
        }
        if (json.has("suffix")) {
            array = json.getAsJsonArray("suffix");
            for (i = 0; i < array.size(); ++i) {
                res.getSuffix().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_suffix")) {
            array = json.getAsJsonArray("_suffix");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSuffix().size()) {
                    res.getSuffix().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSuffix().get(i));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected ContactPoint parseContactPoint(JsonObject json) throws IOException, FHIRFormatError {
        ContactPoint res = new ContactPoint();
        this.parseElementProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseEnumeration(json.get("system").getAsString(), ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("rank")) {
            res.setRankElement(this.parsePositiveInt(json.get("rank").getAsString()));
        }
        if (json.has("_rank")) {
            this.parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected Meta parseMeta(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Meta res = new Meta();
        this.parseElementProperties(json, res);
        if (json.has("versionId")) {
            res.setVersionIdElement(this.parseId(json.get("versionId").getAsString()));
        }
        if (json.has("_versionId")) {
            this.parseElementProperties(json.getAsJsonObject("_versionId"), res.getVersionIdElement());
        }
        if (json.has("lastUpdated")) {
            res.setLastUpdatedElement(this.parseInstant(json.get("lastUpdated").getAsString()));
        }
        if (json.has("_lastUpdated")) {
            this.parseElementProperties(json.getAsJsonObject("_lastUpdated"), res.getLastUpdatedElement());
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i = 0; i < array.size(); ++i) {
                res.getProfile().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_profile")) {
            array = json.getAsJsonArray("_profile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProfile().size()) {
                    res.getProfile().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
            }
        }
        if (json.has("security")) {
            array = json.getAsJsonArray("security");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurity().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("tag")) {
            array = json.getAsJsonArray("tag");
            for (i = 0; i < array.size(); ++i) {
                res.getTag().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Address parseAddress(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Address res = new Address();
        this.parseElementProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("line")) {
            array = json.getAsJsonArray("line");
            for (i = 0; i < array.size(); ++i) {
                res.getLine().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_line")) {
            array = json.getAsJsonArray("_line");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLine().size()) {
                    res.getLine().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getLine().get(i));
            }
        }
        if (json.has("city")) {
            res.setCityElement(this.parseString(json.get("city").getAsString()));
        }
        if (json.has("_city")) {
            this.parseElementProperties(json.getAsJsonObject("_city"), res.getCityElement());
        }
        if (json.has("district")) {
            res.setDistrictElement(this.parseString(json.get("district").getAsString()));
        }
        if (json.has("_district")) {
            this.parseElementProperties(json.getAsJsonObject("_district"), res.getDistrictElement());
        }
        if (json.has("state")) {
            res.setStateElement(this.parseString(json.get("state").getAsString()));
        }
        if (json.has("_state")) {
            this.parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
        }
        if (json.has("postalCode")) {
            res.setPostalCodeElement(this.parseString(json.get("postalCode").getAsString()));
        }
        if (json.has("_postalCode")) {
            this.parseElementProperties(json.getAsJsonObject("_postalCode"), res.getPostalCodeElement());
        }
        if (json.has("country")) {
            res.setCountryElement(this.parseString(json.get("country").getAsString()));
        }
        if (json.has("_country")) {
            this.parseElementProperties(json.getAsJsonObject("_country"), res.getCountryElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected Timing parseTiming(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Timing res = new Timing();
        this.parseElementProperties(json, res);
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseDateTime(array.get(i).getAsString()));
            }
        }
        if (json.has("_event")) {
            array = json.getAsJsonArray("_event");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getEvent().size()) {
                    res.getEvent().add(this.parseDateTime(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getEvent().get(i));
            }
        }
        if (json.has("repeat")) {
            res.setRepeat(this.parseTimingTimingRepeatComponent(json.getAsJsonObject("repeat"), res));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        return res;
    }

    protected Timing.TimingRepeatComponent parseTimingTimingRepeatComponent(JsonObject json, Timing owner) throws IOException, FHIRFormatError {
        Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
        this.parseElementProperties(json, res);
        Type bounds = this.parseType("bounds", json);
        if (bounds != null) {
            res.setBounds(bounds);
        }
        if (json.has("count")) {
            res.setCountElement(this.parseInteger(json.get("count").getAsLong()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
        }
        if (json.has("duration")) {
            res.setDurationElement(this.parseDecimal(json.get("duration").getAsBigDecimal()));
        }
        if (json.has("_duration")) {
            this.parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
        }
        if (json.has("durationMax")) {
            res.setDurationMaxElement(this.parseDecimal(json.get("durationMax").getAsBigDecimal()));
        }
        if (json.has("_durationMax")) {
            this.parseElementProperties(json.getAsJsonObject("_durationMax"), res.getDurationMaxElement());
        }
        if (json.has("durationUnits")) {
            res.setDurationUnitsElement(this.parseEnumeration(json.get("durationUnits").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        }
        if (json.has("_durationUnits")) {
            this.parseElementProperties(json.getAsJsonObject("_durationUnits"), res.getDurationUnitsElement());
        }
        if (json.has("frequency")) {
            res.setFrequencyElement(this.parseInteger(json.get("frequency").getAsLong()));
        }
        if (json.has("_frequency")) {
            this.parseElementProperties(json.getAsJsonObject("_frequency"), res.getFrequencyElement());
        }
        if (json.has("frequencyMax")) {
            res.setFrequencyMaxElement(this.parseInteger(json.get("frequencyMax").getAsLong()));
        }
        if (json.has("_frequencyMax")) {
            this.parseElementProperties(json.getAsJsonObject("_frequencyMax"), res.getFrequencyMaxElement());
        }
        if (json.has("period")) {
            res.setPeriodElement(this.parseDecimal(json.get("period").getAsBigDecimal()));
        }
        if (json.has("_period")) {
            this.parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
        }
        if (json.has("periodMax")) {
            res.setPeriodMaxElement(this.parseDecimal(json.get("periodMax").getAsBigDecimal()));
        }
        if (json.has("_periodMax")) {
            this.parseElementProperties(json.getAsJsonObject("_periodMax"), res.getPeriodMaxElement());
        }
        if (json.has("periodUnits")) {
            res.setPeriodUnitsElement(this.parseEnumeration(json.get("periodUnits").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        }
        if (json.has("_periodUnits")) {
            this.parseElementProperties(json.getAsJsonObject("_periodUnits"), res.getPeriodUnitsElement());
        }
        if (json.has("when")) {
            res.setWhenElement(this.parseEnumeration(json.get("when").getAsString(), Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
        }
        if (json.has("_when")) {
            this.parseElementProperties(json.getAsJsonObject("_when"), res.getWhenElement());
        }
        return res;
    }

    protected ElementDefinition parseElementDefinition(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type maxValue;
        Type minValue;
        Type example;
        Type pattern;
        Type fixed;
        Type defaultValue;
        int i2;
        JsonArray array2;
        ElementDefinition res = new ElementDefinition();
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("representation")) {
            array2 = json.getAsJsonArray("representation");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getRepresentation().add(this.parseEnumeration(array2.get(i2).getAsString(), ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
            }
        }
        if (json.has("_representation")) {
            array2 = json.getAsJsonArray("_representation");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getRepresentation().size()) {
                    res.getRepresentation().add(this.parseEnumeration(null, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getRepresentation().get(i2));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
        }
        if (json.has("code")) {
            array2 = json.getAsJsonArray("code");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getCode().add(this.parseCoding(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("slicing")) {
            res.setSlicing(this.parseElementDefinitionElementDefinitionSlicingComponent(json.getAsJsonObject("slicing"), res));
        }
        if (json.has("short")) {
            res.setShortElement(this.parseString(json.get("short").getAsString()));
        }
        if (json.has("_short")) {
            this.parseElementProperties(json.getAsJsonObject("_short"), res.getShortElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseMarkdown(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
        }
        if (json.has("comments")) {
            res.setCommentsElement(this.parseMarkdown(json.get("comments").getAsString()));
        }
        if (json.has("_comments")) {
            this.parseElementProperties(json.getAsJsonObject("_comments"), res.getCommentsElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseMarkdown(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("alias")) {
            array2 = json.getAsJsonArray("alias");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getAlias().add(this.parseString(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_alias")) {
            array2 = json.getAsJsonArray("_alias");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getAlias().size()) {
                    res.getAlias().add(this.parseString(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getAlias().get(i2));
            }
        }
        if (json.has("min")) {
            res.setMinElement(this.parseInteger(json.get("min").getAsLong()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
        }
        if (json.has("base")) {
            res.setBase(this.parseElementDefinitionElementDefinitionBaseComponent(json.getAsJsonObject("base"), res));
        }
        if (json.has("type")) {
            array2 = json.getAsJsonArray("type");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getType().add(this.parseElementDefinitionTypeRefComponent(array2.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("nameReference")) {
            res.setNameReferenceElement(this.parseString(json.get("nameReference").getAsString()));
        }
        if (json.has("_nameReference")) {
            this.parseElementProperties(json.getAsJsonObject("_nameReference"), res.getNameReferenceElement());
        }
        if ((defaultValue = this.parseType("defaultValue", json)) != null) {
            res.setDefaultValue(defaultValue);
        }
        if (json.has("meaningWhenMissing")) {
            res.setMeaningWhenMissingElement(this.parseMarkdown(json.get("meaningWhenMissing").getAsString()));
        }
        if (json.has("_meaningWhenMissing")) {
            this.parseElementProperties(json.getAsJsonObject("_meaningWhenMissing"), res.getMeaningWhenMissingElement());
        }
        if ((fixed = this.parseType("fixed", json)) != null) {
            res.setFixed(fixed);
        }
        if ((pattern = this.parseType("pattern", json)) != null) {
            res.setPattern(pattern);
        }
        if ((example = this.parseType("example", json)) != null) {
            res.setExample(example);
        }
        if ((minValue = this.parseType("minValue", json)) != null) {
            res.setMinValue(minValue);
        }
        if ((maxValue = this.parseType("maxValue", json)) != null) {
            res.setMaxValue(maxValue);
        }
        if (json.has("maxLength")) {
            res.setMaxLengthElement(this.parseInteger(json.get("maxLength").getAsLong()));
        }
        if (json.has("_maxLength")) {
            this.parseElementProperties(json.getAsJsonObject("_maxLength"), res.getMaxLengthElement());
        }
        if (json.has("condition")) {
            array = json.getAsJsonArray("condition");
            for (i = 0; i < array.size(); ++i) {
                res.getCondition().add(this.parseId(array.get(i).getAsString()));
            }
        }
        if (json.has("_condition")) {
            array = json.getAsJsonArray("_condition");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getCondition().size()) {
                    res.getCondition().add(this.parseId(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getCondition().get(i));
            }
        }
        if (json.has("constraint")) {
            array = json.getAsJsonArray("constraint");
            for (i = 0; i < array.size(); ++i) {
                res.getConstraint().add(this.parseElementDefinitionElementDefinitionConstraintComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("mustSupport")) {
            res.setMustSupportElement(this.parseBoolean(json.get("mustSupport").getAsBoolean()));
        }
        if (json.has("_mustSupport")) {
            this.parseElementProperties(json.getAsJsonObject("_mustSupport"), res.getMustSupportElement());
        }
        if (json.has("isModifier")) {
            res.setIsModifierElement(this.parseBoolean(json.get("isModifier").getAsBoolean()));
        }
        if (json.has("_isModifier")) {
            this.parseElementProperties(json.getAsJsonObject("_isModifier"), res.getIsModifierElement());
        }
        if (json.has("isSummary")) {
            res.setIsSummaryElement(this.parseBoolean(json.get("isSummary").getAsBoolean()));
        }
        if (json.has("_isSummary")) {
            this.parseElementProperties(json.getAsJsonObject("_isSummary"), res.getIsSummaryElement());
        }
        if (json.has("binding")) {
            res.setBinding(this.parseElementDefinitionElementDefinitionBindingComponent(json.getAsJsonObject("binding"), res));
        }
        if (json.has("mapping")) {
            array = json.getAsJsonArray("mapping");
            for (i = 0; i < array.size(); ++i) {
                res.getMapping().add(this.parseElementDefinitionElementDefinitionMappingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionElementDefinitionSlicingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
        this.parseElementProperties(json, res);
        if (json.has("discriminator")) {
            array = json.getAsJsonArray("discriminator");
            for (i = 0; i < array.size(); ++i) {
                res.getDiscriminator().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_discriminator")) {
            array = json.getAsJsonArray("_discriminator");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDiscriminator().size()) {
                    res.getDiscriminator().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDiscriminator().get(i));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("ordered")) {
            res.setOrderedElement(this.parseBoolean(json.get("ordered").getAsBoolean()));
        }
        if (json.has("_ordered")) {
            this.parseElementProperties(json.getAsJsonObject("_ordered"), res.getOrderedElement());
        }
        if (json.has("rules")) {
            res.setRulesElement(this.parseEnumeration(json.get("rules").getAsString(), ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
        }
        if (json.has("_rules")) {
            this.parseElementProperties(json.getAsJsonObject("_rules"), res.getRulesElement());
        }
        return res;
    }

    protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionElementDefinitionBaseComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseInteger(json.get("min").getAsLong()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
        }
        return res;
    }

    protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
        this.parseElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i = 0; i < array.size(); ++i) {
                res.getProfile().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_profile")) {
            array = json.getAsJsonArray("_profile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProfile().size()) {
                    res.getProfile().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
            }
        }
        if (json.has("aggregation")) {
            array = json.getAsJsonArray("aggregation");
            for (i = 0; i < array.size(); ++i) {
                res.getAggregation().add(this.parseEnumeration(array.get(i).getAsString(), ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
            }
        }
        if (json.has("_aggregation")) {
            array = json.getAsJsonArray("_aggregation");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getAggregation().size()) {
                    res.getAggregation().add(this.parseEnumeration(null, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getAggregation().get(i));
            }
        }
        return res;
    }

    protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionElementDefinitionConstraintComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
        this.parseElementProperties(json, res);
        if (json.has("key")) {
            res.setKeyElement(this.parseId(json.get("key").getAsString()));
        }
        if (json.has("_key")) {
            this.parseElementProperties(json.getAsJsonObject("_key"), res.getKeyElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
        }
        if (json.has("human")) {
            res.setHumanElement(this.parseString(json.get("human").getAsString()));
        }
        if (json.has("_human")) {
            this.parseElementProperties(json.getAsJsonObject("_human"), res.getHumanElement());
        }
        if (json.has("xpath")) {
            res.setXpathElement(this.parseString(json.get("xpath").getAsString()));
        }
        if (json.has("_xpath")) {
            this.parseElementProperties(json.getAsJsonObject("_xpath"), res.getXpathElement());
        }
        return res;
    }

    protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionElementDefinitionBindingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        Type valueSet;
        ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
        this.parseElementProperties(json, res);
        if (json.has("strength")) {
            res.setStrengthElement(this.parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
        }
        if (json.has("_strength")) {
            this.parseElementProperties(json.getAsJsonObject("_strength"), res.getStrengthElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if ((valueSet = this.parseType("valueSet", json)) != null) {
            res.setValueSet(valueSet);
        }
        return res;
    }

    protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionElementDefinitionMappingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
        this.parseElementProperties(json, res);
        if (json.has("identity")) {
            res.setIdentityElement(this.parseId(json.get("identity").getAsString()));
        }
        if (json.has("_identity")) {
            this.parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("map")) {
            res.setMapElement(this.parseString(json.get("map").getAsString()));
        }
        if (json.has("_map")) {
            this.parseElementProperties(json.getAsJsonObject("_map"), res.getMapElement());
        }
        return res;
    }

    protected void parseDomainResourceProperties(JsonObject json, DomainResource res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseResourceProperties(json, res);
        if (json.has("text")) {
            res.setText(this.parseNarrative(json.getAsJsonObject("text")));
        }
        if (json.has("contained")) {
            array = json.getAsJsonArray("contained");
            for (i = 0; i < array.size(); ++i) {
                res.getContained().add(this.parseResource(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("extension")) {
            array = json.getAsJsonArray("extension");
            for (i = 0; i < array.size(); ++i) {
                res.getExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("modifierExtension")) {
            array = json.getAsJsonArray("modifierExtension");
            for (i = 0; i < array.size(); ++i) {
                res.getModifierExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Parameters parseParameters(JsonObject json) throws IOException, FHIRFormatError {
        Parameters res = new Parameters();
        this.parseResourceProperties(json, res);
        if (json.has("parameter")) {
            JsonArray array = json.getAsJsonArray("parameter");
            for (int i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Parameters.ParametersParameterComponent parseParametersParametersParameterComponent(JsonObject json, Parameters owner) throws IOException, FHIRFormatError {
        Type value;
        Parameters.ParametersParameterComponent res = new Parameters.ParametersParameterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("resource")) {
            res.setResource(this.parseResource(json.getAsJsonObject("resource")));
        }
        if (json.has("part")) {
            JsonArray array = json.getAsJsonArray("part");
            for (int i = 0; i < array.size(); ++i) {
                res.getPart().add(this.parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected void parseResourceProperties(JsonObject json, Resource res) throws IOException, FHIRFormatError {
        if (json.has("id")) {
            res.setIdElement(this.parseId(json.get("id").getAsString()));
        }
        if (json.has("_id")) {
            this.parseElementProperties(json.getAsJsonObject("_id"), res.getIdElement());
        }
        if (json.has("meta")) {
            res.setMeta(this.parseMeta(json.getAsJsonObject("meta")));
        }
        if (json.has("implicitRules")) {
            res.setImplicitRulesElement(this.parseUri(json.get("implicitRules").getAsString()));
        }
        if (json.has("_implicitRules")) {
            this.parseElementProperties(json.getAsJsonObject("_implicitRules"), res.getImplicitRulesElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
    }

    protected Account parseAccount(JsonObject json) throws IOException, FHIRFormatError {
        Account res = new Account();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("activePeriod")) {
            res.setActivePeriod(this.parsePeriod(json.getAsJsonObject("activePeriod")));
        }
        if (json.has("currency")) {
            res.setCurrency(this.parseCoding(json.getAsJsonObject("currency")));
        }
        if (json.has("balance")) {
            res.setBalance(this.parseMoney(json.getAsJsonObject("balance")));
        }
        if (json.has("coveragePeriod")) {
            res.setCoveragePeriod(this.parsePeriod(json.getAsJsonObject("coveragePeriod")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("owner")) {
            res.setOwner(this.parseReference(json.getAsJsonObject("owner")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        return res;
    }

    protected AllergyIntolerance parseAllergyIntolerance(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        AllergyIntolerance res = new AllergyIntolerance();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("onset")) {
            res.setOnsetElement(this.parseDateTime(json.get("onset").getAsString()));
        }
        if (json.has("_onset")) {
            this.parseElementProperties(json.getAsJsonObject("_onset"), res.getOnsetElement());
        }
        if (json.has("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(json.get("recordedDate").getAsString()));
        }
        if (json.has("_recordedDate")) {
            this.parseElementProperties(json.getAsJsonObject("_recordedDate"), res.getRecordedDateElement());
        }
        if (json.has("recorder")) {
            res.setRecorder(this.parseReference(json.getAsJsonObject("recorder")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("reporter")) {
            res.setReporter(this.parseReference(json.getAsJsonObject("reporter")));
        }
        if (json.has("substance")) {
            res.setSubstance(this.parseCodeableConcept(json.getAsJsonObject("substance")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), AllergyIntolerance.AllergyIntoleranceStatus.NULL, new AllergyIntolerance.AllergyIntoleranceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("criticality")) {
            res.setCriticalityElement(this.parseEnumeration(json.get("criticality").getAsString(), AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
        }
        if (json.has("_criticality")) {
            this.parseElementProperties(json.getAsJsonObject("_criticality"), res.getCriticalityElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
        }
        if (json.has("lastOccurence")) {
            res.setLastOccurenceElement(this.parseDateTime(json.get("lastOccurence").getAsString()));
        }
        if (json.has("_lastOccurence")) {
            this.parseElementProperties(json.getAsJsonObject("_lastOccurence"), res.getLastOccurenceElement());
        }
        if (json.has("note")) {
            res.setNote(this.parseAnnotation(json.getAsJsonObject("note")));
        }
        if (json.has("reaction")) {
            array = json.getAsJsonArray("reaction");
            for (i = 0; i < array.size(); ++i) {
                res.getReaction().add(this.parseAllergyIntoleranceAllergyIntoleranceReactionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceAllergyIntoleranceReactionComponent(JsonObject json, AllergyIntolerance owner) throws IOException, FHIRFormatError {
        AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("substance")) {
            res.setSubstance(this.parseCodeableConcept(json.getAsJsonObject("substance")));
        }
        if (json.has("certainty")) {
            res.setCertaintyElement(this.parseEnumeration(json.get("certainty").getAsString(), AllergyIntolerance.AllergyIntoleranceCertainty.NULL, new AllergyIntolerance.AllergyIntoleranceCertaintyEnumFactory()));
        }
        if (json.has("_certainty")) {
            this.parseElementProperties(json.getAsJsonObject("_certainty"), res.getCertaintyElement());
        }
        if (json.has("manifestation")) {
            JsonArray array = json.getAsJsonArray("manifestation");
            for (int i = 0; i < array.size(); ++i) {
                res.getManifestation().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("onset")) {
            res.setOnsetElement(this.parseDateTime(json.get("onset").getAsString()));
        }
        if (json.has("_onset")) {
            this.parseElementProperties(json.getAsJsonObject("_onset"), res.getOnsetElement());
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
        }
        if (json.has("exposureRoute")) {
            res.setExposureRoute(this.parseCodeableConcept(json.getAsJsonObject("exposureRoute")));
        }
        if (json.has("note")) {
            res.setNote(this.parseAnnotation(json.getAsJsonObject("note")));
        }
        return res;
    }

    protected Appointment parseAppointment(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Appointment res = new Appointment();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseUnsignedInt(json.get("priority").getAsString()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("start")) {
            res.setStartElement(this.parseInstant(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("minutesDuration")) {
            res.setMinutesDurationElement(this.parsePositiveInt(json.get("minutesDuration").getAsString()));
        }
        if (json.has("_minutesDuration")) {
            this.parseElementProperties(json.getAsJsonObject("_minutesDuration"), res.getMinutesDurationElement());
        }
        if (json.has("slot")) {
            array = json.getAsJsonArray("slot");
            for (i = 0; i < array.size(); ++i) {
                res.getSlot().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseAppointmentAppointmentParticipantComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Appointment.AppointmentParticipantComponent parseAppointmentAppointmentParticipantComponent(JsonObject json, Appointment owner) throws IOException, FHIRFormatError {
        Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("required")) {
            res.setRequiredElement(this.parseEnumeration(json.get("required").getAsString(), Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
        }
        if (json.has("_required")) {
            this.parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        return res;
    }

    protected AppointmentResponse parseAppointmentResponse(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        AppointmentResponse res = new AppointmentResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("appointment")) {
            res.setAppointment(this.parseReference(json.getAsJsonObject("appointment")));
        }
        if (json.has("start")) {
            res.setStartElement(this.parseInstant(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("participantType")) {
            array = json.getAsJsonArray("participantType");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipantType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("participantStatus")) {
            res.setParticipantStatusElement(this.parseEnumeration(json.get("participantStatus").getAsString(), AppointmentResponse.ParticipantStatus.NULL, new AppointmentResponse.ParticipantStatusEnumFactory()));
        }
        if (json.has("_participantStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_participantStatus"), res.getParticipantStatusElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        return res;
    }

    protected AuditEvent parseAuditEvent(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        AuditEvent res = new AuditEvent();
        this.parseDomainResourceProperties(json, res);
        if (json.has("event")) {
            res.setEvent(this.parseAuditEventAuditEventEventComponent(json.getAsJsonObject("event"), res));
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseAuditEventAuditEventParticipantComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("source")) {
            res.setSource(this.parseAuditEventAuditEventSourceComponent(json.getAsJsonObject("source"), res));
        }
        if (json.has("object")) {
            array = json.getAsJsonArray("object");
            for (i = 0; i < array.size(); ++i) {
                res.getObject().add(this.parseAuditEventAuditEventObjectComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected AuditEvent.AuditEventEventComponent parseAuditEventAuditEventEventComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        AuditEvent.AuditEventEventComponent res = new AuditEvent.AuditEventEventComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("subtype")) {
            array = json.getAsJsonArray("subtype");
            for (i = 0; i < array.size(); ++i) {
                res.getSubtype().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            res.setActionElement(this.parseEnumeration(json.get("action").getAsString(), AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
        }
        if (json.has("_action")) {
            this.parseElementProperties(json.getAsJsonObject("_action"), res.getActionElement());
        }
        if (json.has("dateTime")) {
            res.setDateTimeElement(this.parseInstant(json.get("dateTime").getAsString()));
        }
        if (json.has("_dateTime")) {
            this.parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
        }
        if (json.has("outcomeDesc")) {
            res.setOutcomeDescElement(this.parseString(json.get("outcomeDesc").getAsString()));
        }
        if (json.has("_outcomeDesc")) {
            this.parseElementProperties(json.getAsJsonObject("_outcomeDesc"), res.getOutcomeDescElement());
        }
        if (json.has("purposeOfEvent")) {
            array = json.getAsJsonArray("purposeOfEvent");
            for (i = 0; i < array.size(); ++i) {
                res.getPurposeOfEvent().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected AuditEvent.AuditEventParticipantComponent parseAuditEventAuditEventParticipantComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        AuditEvent.AuditEventParticipantComponent res = new AuditEvent.AuditEventParticipantComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            array = json.getAsJsonArray("role");
            for (i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(json.getAsJsonObject("reference")));
        }
        if (json.has("userId")) {
            res.setUserId(this.parseIdentifier(json.getAsJsonObject("userId")));
        }
        if (json.has("altId")) {
            res.setAltIdElement(this.parseString(json.get("altId").getAsString()));
        }
        if (json.has("_altId")) {
            this.parseElementProperties(json.getAsJsonObject("_altId"), res.getAltIdElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("requestor")) {
            res.setRequestorElement(this.parseBoolean(json.get("requestor").getAsBoolean()));
        }
        if (json.has("_requestor")) {
            this.parseElementProperties(json.getAsJsonObject("_requestor"), res.getRequestorElement());
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("policy")) {
            array = json.getAsJsonArray("policy");
            for (i = 0; i < array.size(); ++i) {
                res.getPolicy().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_policy")) {
            array = json.getAsJsonArray("_policy");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPolicy().size()) {
                    res.getPolicy().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
            }
        }
        if (json.has("media")) {
            res.setMedia(this.parseCoding(json.getAsJsonObject("media")));
        }
        if (json.has("network")) {
            res.setNetwork(this.parseAuditEventAuditEventParticipantNetworkComponent(json.getAsJsonObject("network"), owner));
        }
        if (json.has("purposeOfUse")) {
            array = json.getAsJsonArray("purposeOfUse");
            for (i = 0; i < array.size(); ++i) {
                res.getPurposeOfUse().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected AuditEvent.AuditEventParticipantNetworkComponent parseAuditEventAuditEventParticipantNetworkComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventParticipantNetworkComponent res = new AuditEvent.AuditEventParticipantNetworkComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("address")) {
            res.setAddressElement(this.parseString(json.get("address").getAsString()));
        }
        if (json.has("_address")) {
            this.parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), AuditEvent.AuditEventParticipantNetworkType.NULL, new AuditEvent.AuditEventParticipantNetworkTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        return res;
    }

    protected AuditEvent.AuditEventSourceComponent parseAuditEventAuditEventSourceComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("site")) {
            res.setSiteElement(this.parseString(json.get("site").getAsString()));
        }
        if (json.has("_site")) {
            this.parseElementProperties(json.getAsJsonObject("_site"), res.getSiteElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected AuditEvent.AuditEventObjectComponent parseAuditEventAuditEventObjectComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        AuditEvent.AuditEventObjectComponent res = new AuditEvent.AuditEventObjectComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(json.getAsJsonObject("reference")));
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCoding(json.getAsJsonObject("role")));
        }
        if (json.has("lifecycle")) {
            res.setLifecycle(this.parseCoding(json.getAsJsonObject("lifecycle")));
        }
        if (json.has("securityLabel")) {
            array = json.getAsJsonArray("securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("query")) {
            res.setQueryElement(this.parseBase64Binary(json.get("query").getAsString()));
        }
        if (json.has("_query")) {
            this.parseElementProperties(json.getAsJsonObject("_query"), res.getQueryElement());
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseAuditEventAuditEventObjectDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected AuditEvent.AuditEventObjectDetailComponent parseAuditEventAuditEventObjectDetailComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventObjectDetailComponent res = new AuditEvent.AuditEventObjectDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseString(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseBase64Binary(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected Basic parseBasic(JsonObject json) throws IOException, FHIRFormatError {
        Basic res = new Basic();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDate(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        return res;
    }

    protected Binary parseBinary(JsonObject json) throws IOException, FHIRFormatError {
        Binary res = new Binary();
        this.parseResourceProperties(json, res);
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("content")) {
            res.setContentElement(this.parseBase64Binary(json.get("content").getAsString()));
        }
        if (json.has("_content")) {
            this.parseElementProperties(json.getAsJsonObject("_content"), res.getContentElement());
        }
        return res;
    }

    protected BodySite parseBodySite(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        BodySite res = new BodySite();
        this.parseDomainResourceProperties(json, res);
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("image")) {
            array = json.getAsJsonArray("image");
            for (i = 0; i < array.size(); ++i) {
                res.getImage().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Bundle parseBundle(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Bundle res = new Bundle();
        this.parseResourceProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("total")) {
            res.setTotalElement(this.parseUnsignedInt(json.get("total").getAsString()));
        }
        if (json.has("_total")) {
            this.parseElementProperties(json.getAsJsonObject("_total"), res.getTotalElement());
        }
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("entry")) {
            array = json.getAsJsonArray("entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseBundleBundleEntryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("signature")) {
            res.setSignature(this.parseSignature(json.getAsJsonObject("signature")));
        }
        return res;
    }

    protected Bundle.BundleLinkComponent parseBundleBundleLinkComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("relation")) {
            res.setRelationElement(this.parseString(json.get("relation").getAsString()));
        }
        if (json.has("_relation")) {
            this.parseElementProperties(json.getAsJsonObject("_relation"), res.getRelationElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        return res;
    }

    protected Bundle.BundleEntryComponent parseBundleBundleEntryComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("link")) {
            JsonArray array = json.getAsJsonArray("link");
            for (int i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("fullUrl")) {
            res.setFullUrlElement(this.parseUri(json.get("fullUrl").getAsString()));
        }
        if (json.has("_fullUrl")) {
            this.parseElementProperties(json.getAsJsonObject("_fullUrl"), res.getFullUrlElement());
        }
        if (json.has("resource")) {
            res.setResource(this.parseResource(json.getAsJsonObject("resource")));
        }
        if (json.has("search")) {
            res.setSearch(this.parseBundleBundleEntrySearchComponent(json.getAsJsonObject("search"), owner));
        }
        if (json.has("request")) {
            res.setRequest(this.parseBundleBundleEntryRequestComponent(json.getAsJsonObject("request"), owner));
        }
        if (json.has("response")) {
            res.setResponse(this.parseBundleBundleEntryResponseComponent(json.getAsJsonObject("response"), owner));
        }
        return res;
    }

    protected Bundle.BundleEntrySearchComponent parseBundleBundleEntrySearchComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("score")) {
            res.setScoreElement(this.parseDecimal(json.get("score").getAsBigDecimal()));
        }
        if (json.has("_score")) {
            this.parseElementProperties(json.getAsJsonObject("_score"), res.getScoreElement());
        }
        return res;
    }

    protected Bundle.BundleEntryRequestComponent parseBundleBundleEntryRequestComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("method")) {
            res.setMethodElement(this.parseEnumeration(json.get("method").getAsString(), Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
        }
        if (json.has("_method")) {
            this.parseElementProperties(json.getAsJsonObject("_method"), res.getMethodElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("ifNoneMatch")) {
            res.setIfNoneMatchElement(this.parseString(json.get("ifNoneMatch").getAsString()));
        }
        if (json.has("_ifNoneMatch")) {
            this.parseElementProperties(json.getAsJsonObject("_ifNoneMatch"), res.getIfNoneMatchElement());
        }
        if (json.has("ifModifiedSince")) {
            res.setIfModifiedSinceElement(this.parseInstant(json.get("ifModifiedSince").getAsString()));
        }
        if (json.has("_ifModifiedSince")) {
            this.parseElementProperties(json.getAsJsonObject("_ifModifiedSince"), res.getIfModifiedSinceElement());
        }
        if (json.has("ifMatch")) {
            res.setIfMatchElement(this.parseString(json.get("ifMatch").getAsString()));
        }
        if (json.has("_ifMatch")) {
            this.parseElementProperties(json.getAsJsonObject("_ifMatch"), res.getIfMatchElement());
        }
        if (json.has("ifNoneExist")) {
            res.setIfNoneExistElement(this.parseString(json.get("ifNoneExist").getAsString()));
        }
        if (json.has("_ifNoneExist")) {
            this.parseElementProperties(json.getAsJsonObject("_ifNoneExist"), res.getIfNoneExistElement());
        }
        return res;
    }

    protected Bundle.BundleEntryResponseComponent parseBundleBundleEntryResponseComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseString(json.get("status").getAsString()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("location")) {
            res.setLocationElement(this.parseUri(json.get("location").getAsString()));
        }
        if (json.has("_location")) {
            this.parseElementProperties(json.getAsJsonObject("_location"), res.getLocationElement());
        }
        if (json.has("etag")) {
            res.setEtagElement(this.parseString(json.get("etag").getAsString()));
        }
        if (json.has("_etag")) {
            this.parseElementProperties(json.getAsJsonObject("_etag"), res.getEtagElement());
        }
        if (json.has("lastModified")) {
            res.setLastModifiedElement(this.parseInstant(json.get("lastModified").getAsString()));
        }
        if (json.has("_lastModified")) {
            this.parseElementProperties(json.getAsJsonObject("_lastModified"), res.getLastModifiedElement());
        }
        return res;
    }

    protected CarePlan parseCarePlan(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        CarePlan res = new CarePlan();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanStatus.NULL, new CarePlan.CarePlanStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("modified")) {
            res.setModifiedElement(this.parseDateTime(json.get("modified").getAsString()));
        }
        if (json.has("_modified")) {
            this.parseElementProperties(json.getAsJsonObject("_modified"), res.getModifiedElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("addresses")) {
            array = json.getAsJsonArray("addresses");
            for (i = 0; i < array.size(); ++i) {
                res.getAddresses().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("support")) {
            array = json.getAsJsonArray("support");
            for (i = 0; i < array.size(); ++i) {
                res.getSupport().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relatedPlan")) {
            array = json.getAsJsonArray("relatedPlan");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedPlan().add(this.parseCarePlanCarePlanRelatedPlanComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseCarePlanCarePlanParticipantComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("goal")) {
            array = json.getAsJsonArray("goal");
            for (i = 0; i < array.size(); ++i) {
                res.getGoal().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("activity")) {
            array = json.getAsJsonArray("activity");
            for (i = 0; i < array.size(); ++i) {
                res.getActivity().add(this.parseCarePlanCarePlanActivityComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("note")) {
            res.setNote(this.parseAnnotation(json.getAsJsonObject("note")));
        }
        return res;
    }

    protected CarePlan.CarePlanRelatedPlanComponent parseCarePlanCarePlanRelatedPlanComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
        CarePlan.CarePlanRelatedPlanComponent res = new CarePlan.CarePlanRelatedPlanComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), CarePlan.CarePlanRelationship.NULL, new CarePlan.CarePlanRelationshipEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("plan")) {
            res.setPlan(this.parseReference(json.getAsJsonObject("plan")));
        }
        return res;
    }

    protected CarePlan.CarePlanParticipantComponent parseCarePlanCarePlanParticipantComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
        CarePlan.CarePlanParticipantComponent res = new CarePlan.CarePlanParticipantComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("member")) {
            res.setMember(this.parseReference(json.getAsJsonObject("member")));
        }
        return res;
    }

    protected CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("actionResulting")) {
            array = json.getAsJsonArray("actionResulting");
            for (i = 0; i < array.size(); ++i) {
                res.getActionResulting().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("progress")) {
            array = json.getAsJsonArray("progress");
            for (i = 0; i < array.size(); ++i) {
                res.getProgress().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(json.getAsJsonObject("reference")));
        }
        if (json.has("detail")) {
            res.setDetail(this.parseCarePlanCarePlanActivityDetailComponent(json.getAsJsonObject("detail"), owner));
        }
        return res;
    }

    protected CarePlan.CarePlanActivityDetailComponent parseCarePlanCarePlanActivityDetailComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
        Type product;
        Type scheduled;
        int i;
        JsonArray array;
        CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("reasonCode")) {
            array = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            array = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("goal")) {
            array = json.getAsJsonArray("goal");
            for (i = 0; i < array.size(); ++i) {
                res.getGoal().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(json.getAsJsonObject("statusReason")));
        }
        if (json.has("prohibited")) {
            res.setProhibitedElement(this.parseBoolean(json.get("prohibited").getAsBoolean()));
        }
        if (json.has("_prohibited")) {
            this.parseElementProperties(json.getAsJsonObject("_prohibited"), res.getProhibitedElement());
        }
        if ((scheduled = this.parseType("scheduled", json)) != null) {
            res.setScheduled(scheduled);
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("performer")) {
            JsonArray array2 = json.getAsJsonArray("performer");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getPerformer().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((product = this.parseType("product", json)) != null) {
            res.setProduct(product);
        }
        if (json.has("dailyAmount")) {
            res.setDailyAmount(this.parseSimpleQuantity(json.getAsJsonObject("dailyAmount")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        return res;
    }

    protected Claim parseClaim(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Claim res = new Claim();
        this.parseDomainResourceProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Claim.ClaimType.NULL, new Claim.ClaimTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Claim.Use.NULL, new Claim.UseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCoding(json.getAsJsonObject("priority")));
        }
        if (json.has("fundsReserve")) {
            res.setFundsReserve(this.parseCoding(json.getAsJsonObject("fundsReserve")));
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(json.getAsJsonObject("enterer")));
        }
        if (json.has("facility")) {
            res.setFacility(this.parseReference(json.getAsJsonObject("facility")));
        }
        if (json.has("prescription")) {
            res.setPrescription(this.parseReference(json.getAsJsonObject("prescription")));
        }
        if (json.has("originalPrescription")) {
            res.setOriginalPrescription(this.parseReference(json.getAsJsonObject("originalPrescription")));
        }
        if (json.has("payee")) {
            res.setPayee(this.parseClaimPayeeComponent(json.getAsJsonObject("payee"), res));
        }
        if (json.has("referral")) {
            res.setReferral(this.parseReference(json.getAsJsonObject("referral")));
        }
        if (json.has("diagnosis")) {
            array = json.getAsJsonArray("diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseClaimDiagnosisComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("condition")) {
            array = json.getAsJsonArray("condition");
            for (i = 0; i < array.size(); ++i) {
                res.getCondition().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("coverage")) {
            array = json.getAsJsonArray("coverage");
            for (i = 0; i < array.size(); ++i) {
                res.getCoverage().add(this.parseClaimCoverageComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("exception")) {
            array = json.getAsJsonArray("exception");
            for (i = 0; i < array.size(); ++i) {
                res.getException().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("school")) {
            res.setSchoolElement(this.parseString(json.get("school").getAsString()));
        }
        if (json.has("_school")) {
            this.parseElementProperties(json.getAsJsonObject("_school"), res.getSchoolElement());
        }
        if (json.has("accident")) {
            res.setAccidentElement(this.parseDate(json.get("accident").getAsString()));
        }
        if (json.has("_accident")) {
            this.parseElementProperties(json.getAsJsonObject("_accident"), res.getAccidentElement());
        }
        if (json.has("accidentType")) {
            res.setAccidentType(this.parseCoding(json.getAsJsonObject("accidentType")));
        }
        if (json.has("interventionException")) {
            array = json.getAsJsonArray("interventionException");
            for (i = 0; i < array.size(); ++i) {
                res.getInterventionException().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseClaimItemsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("additionalMaterials")) {
            array = json.getAsJsonArray("additionalMaterials");
            for (i = 0; i < array.size(); ++i) {
                res.getAdditionalMaterials().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("missingTeeth")) {
            array = json.getAsJsonArray("missingTeeth");
            for (i = 0; i < array.size(); ++i) {
                res.getMissingTeeth().add(this.parseClaimMissingTeethComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Claim.PayeeComponent parseClaimPayeeComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.PayeeComponent res = new Claim.PayeeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("person")) {
            res.setPerson(this.parseReference(json.getAsJsonObject("person")));
        }
        return res;
    }

    protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("diagnosis")) {
            res.setDiagnosis(this.parseCoding(json.getAsJsonObject("diagnosis")));
        }
        return res;
    }

    protected Claim.CoverageComponent parseClaimCoverageComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Claim.CoverageComponent res = new Claim.CoverageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(json.getAsJsonObject("coverage")));
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCoding(json.getAsJsonObject("relationship")));
        }
        if (json.has("preAuthRef")) {
            array = json.getAsJsonArray("preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = json.getAsJsonArray("_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
            }
        }
        if (json.has("claimResponse")) {
            res.setClaimResponse(this.parseReference(json.getAsJsonObject("claimResponse")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        return res;
    }

    protected Claim.ItemsComponent parseClaimItemsComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Claim.ItemsComponent res = new Claim.ItemsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("diagnosisLinkId")) {
            array = json.getAsJsonArray("diagnosisLinkId");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosisLinkId().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_diagnosisLinkId")) {
            array = json.getAsJsonArray("_diagnosisLinkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDiagnosisLinkId().size()) {
                    res.getDiagnosisLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDiagnosisLinkId().get(i));
            }
        }
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("serviceDate")) {
            res.setServiceDateElement(this.parseDate(json.get("serviceDate").getAsString()));
        }
        if (json.has("_serviceDate")) {
            this.parseElementProperties(json.getAsJsonObject("_serviceDate"), res.getServiceDateElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            res.setUdi(this.parseCoding(json.getAsJsonObject("udi")));
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCoding(json.getAsJsonObject("bodySite")));
        }
        if (json.has("subSite")) {
            array = json.getAsJsonArray("subSite");
            for (i = 0; i < array.size(); ++i) {
                res.getSubSite().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("prosthesis")) {
            res.setProsthesis(this.parseClaimProsthesisComponent(json.getAsJsonObject("prosthesis"), owner));
        }
        return res;
    }

    protected Claim.DetailComponent parseClaimDetailComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.DetailComponent res = new Claim.DetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            res.setUdi(this.parseCoding(json.getAsJsonObject("udi")));
        }
        if (json.has("subDetail")) {
            JsonArray array = json.getAsJsonArray("subDetail");
            for (int i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseClaimSubDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Claim.SubDetailComponent parseClaimSubDetailComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.SubDetailComponent res = new Claim.SubDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            res.setUdi(this.parseCoding(json.getAsJsonObject("udi")));
        }
        return res;
    }

    protected Claim.ProsthesisComponent parseClaimProsthesisComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.ProsthesisComponent res = new Claim.ProsthesisComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("initial")) {
            res.setInitialElement(this.parseBoolean(json.get("initial").getAsBoolean()));
        }
        if (json.has("_initial")) {
            this.parseElementProperties(json.getAsJsonObject("_initial"), res.getInitialElement());
        }
        if (json.has("priorDate")) {
            res.setPriorDateElement(this.parseDate(json.get("priorDate").getAsString()));
        }
        if (json.has("_priorDate")) {
            this.parseElementProperties(json.getAsJsonObject("_priorDate"), res.getPriorDateElement());
        }
        if (json.has("priorMaterial")) {
            res.setPriorMaterial(this.parseCoding(json.getAsJsonObject("priorMaterial")));
        }
        return res;
    }

    protected Claim.MissingTeethComponent parseClaimMissingTeethComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.MissingTeethComponent res = new Claim.MissingTeethComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("tooth")) {
            res.setTooth(this.parseCoding(json.getAsJsonObject("tooth")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
        if (json.has("extractionDate")) {
            res.setExtractionDateElement(this.parseDate(json.get("extractionDate").getAsString()));
        }
        if (json.has("_extractionDate")) {
            this.parseElementProperties(json.getAsJsonObject("_extractionDate"), res.getExtractionDateElement());
        }
        return res;
    }

    protected ClaimResponse parseClaimResponse(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ClaimResponse res = new ClaimResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(json.getAsJsonObject("requestProvider")));
        }
        if (json.has("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(json.getAsJsonObject("requestOrganization")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("payeeType")) {
            res.setPayeeType(this.parseCoding(json.getAsJsonObject("payeeType")));
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseClaimResponseItemsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("addItem")) {
            array = json.getAsJsonArray("addItem");
            for (i = 0; i < array.size(); ++i) {
                res.getAddItem().add(this.parseClaimResponseAddedItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("error")) {
            array = json.getAsJsonArray("error");
            for (i = 0; i < array.size(); ++i) {
                res.getError().add(this.parseClaimResponseErrorsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("totalCost")) {
            res.setTotalCost(this.parseMoney(json.getAsJsonObject("totalCost")));
        }
        if (json.has("unallocDeductable")) {
            res.setUnallocDeductable(this.parseMoney(json.getAsJsonObject("unallocDeductable")));
        }
        if (json.has("totalBenefit")) {
            res.setTotalBenefit(this.parseMoney(json.getAsJsonObject("totalBenefit")));
        }
        if (json.has("paymentAdjustment")) {
            res.setPaymentAdjustment(this.parseMoney(json.getAsJsonObject("paymentAdjustment")));
        }
        if (json.has("paymentAdjustmentReason")) {
            res.setPaymentAdjustmentReason(this.parseCoding(json.getAsJsonObject("paymentAdjustmentReason")));
        }
        if (json.has("paymentDate")) {
            res.setPaymentDateElement(this.parseDate(json.get("paymentDate").getAsString()));
        }
        if (json.has("_paymentDate")) {
            this.parseElementProperties(json.getAsJsonObject("_paymentDate"), res.getPaymentDateElement());
        }
        if (json.has("paymentAmount")) {
            res.setPaymentAmount(this.parseMoney(json.getAsJsonObject("paymentAmount")));
        }
        if (json.has("paymentRef")) {
            res.setPaymentRef(this.parseIdentifier(json.getAsJsonObject("paymentRef")));
        }
        if (json.has("reserved")) {
            res.setReserved(this.parseCoding(json.getAsJsonObject("reserved")));
        }
        if (json.has("form")) {
            res.setForm(this.parseCoding(json.getAsJsonObject("form")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseClaimResponseNotesComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("coverage")) {
            array = json.getAsJsonArray("coverage");
            for (i = 0; i < array.size(); ++i) {
                res.getCoverage().add(this.parseClaimResponseCoverageComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ClaimResponse.ItemsComponent parseClaimResponseItemsComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ClaimResponse.ItemsComponent res = new ClaimResponse.ItemsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(json.get("sequenceLinkId").getAsString()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseItemAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimResponseItemDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ClaimResponse.ItemAdjudicationComponent parseClaimResponseItemAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.ItemAdjudicationComponent res = new ClaimResponse.ItemAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCoding(json.getAsJsonObject("code")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(json.get("sequenceLinkId").getAsString()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseDetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("subDetail")) {
            array = json.getAsJsonArray("subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseClaimResponseSubDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ClaimResponse.DetailAdjudicationComponent parseClaimResponseDetailAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.DetailAdjudicationComponent res = new ClaimResponse.DetailAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCoding(json.getAsJsonObject("code")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(json.get("sequenceLinkId").getAsString()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        if (json.has("adjudication")) {
            JsonArray array = json.getAsJsonArray("adjudication");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseSubdetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ClaimResponse.SubdetailAdjudicationComponent parseClaimResponseSubdetailAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.SubdetailAdjudicationComponent res = new ClaimResponse.SubdetailAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCoding(json.getAsJsonObject("code")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            array = json.getAsJsonArray("sequenceLinkId");
            for (i = 0; i < array.size(); ++i) {
                res.getSequenceLinkId().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_sequenceLinkId")) {
            array = json.getAsJsonArray("_sequenceLinkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSequenceLinkId().size()) {
                    res.getSequenceLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSequenceLinkId().get(i));
            }
        }
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("fee")) {
            res.setFee(this.parseMoney(json.getAsJsonObject("fee")));
        }
        if (json.has("noteNumberLinkId")) {
            array = json.getAsJsonArray("noteNumberLinkId");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumberLinkId().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumberLinkId")) {
            array = json.getAsJsonArray("_noteNumberLinkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumberLinkId().size()) {
                    res.getNoteNumberLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumberLinkId().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAddedItemAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimResponseAddedItemsDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ClaimResponse.AddedItemAdjudicationComponent parseClaimResponseAddedItemAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemAdjudicationComponent res = new ClaimResponse.AddedItemAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCoding(json.getAsJsonObject("code")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ClaimResponse.AddedItemsDetailComponent parseClaimResponseAddedItemsDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemsDetailComponent res = new ClaimResponse.AddedItemsDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("fee")) {
            res.setFee(this.parseMoney(json.getAsJsonObject("fee")));
        }
        if (json.has("adjudication")) {
            JsonArray array = json.getAsJsonArray("adjudication");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAddedItemDetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ClaimResponse.AddedItemDetailAdjudicationComponent parseClaimResponseAddedItemDetailAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemDetailAdjudicationComponent res = new ClaimResponse.AddedItemDetailAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCoding(json.getAsJsonObject("code")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ClaimResponse.ErrorsComponent parseClaimResponseErrorsComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.ErrorsComponent res = new ClaimResponse.ErrorsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(json.get("sequenceLinkId").getAsString()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        if (json.has("detailSequenceLinkId")) {
            res.setDetailSequenceLinkIdElement(this.parsePositiveInt(json.get("detailSequenceLinkId").getAsString()));
        }
        if (json.has("_detailSequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_detailSequenceLinkId"), res.getDetailSequenceLinkIdElement());
        }
        if (json.has("subdetailSequenceLinkId")) {
            res.setSubdetailSequenceLinkIdElement(this.parsePositiveInt(json.get("subdetailSequenceLinkId").getAsString()));
        }
        if (json.has("_subdetailSequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_subdetailSequenceLinkId"), res.getSubdetailSequenceLinkIdElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCoding(json.getAsJsonObject("code")));
        }
        return res;
    }

    protected ClaimResponse.NotesComponent parseClaimResponseNotesComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.NotesComponent res = new ClaimResponse.NotesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("number")) {
            res.setNumberElement(this.parsePositiveInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        return res;
    }

    protected ClaimResponse.CoverageComponent parseClaimResponseCoverageComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ClaimResponse.CoverageComponent res = new ClaimResponse.CoverageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(json.getAsJsonObject("coverage")));
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCoding(json.getAsJsonObject("relationship")));
        }
        if (json.has("preAuthRef")) {
            array = json.getAsJsonArray("preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = json.getAsJsonArray("_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
            }
        }
        if (json.has("claimResponse")) {
            res.setClaimResponse(this.parseReference(json.getAsJsonObject("claimResponse")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        return res;
    }

    protected ClinicalImpression parseClinicalImpression(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type trigger;
        ClinicalImpression res = new ClinicalImpression();
        this.parseDomainResourceProperties(json, res);
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("assessor")) {
            res.setAssessor(this.parseReference(json.getAsJsonObject("assessor")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ClinicalImpression.ClinicalImpressionStatus.NULL, new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("previous")) {
            res.setPrevious(this.parseReference(json.getAsJsonObject("previous")));
        }
        if (json.has("problem")) {
            JsonArray array = json.getAsJsonArray("problem");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getProblem().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if ((trigger = this.parseType("trigger", json)) != null) {
            res.setTrigger(trigger);
        }
        if (json.has("investigations")) {
            JsonArray array = json.getAsJsonArray("investigations");
            for (i = 0; i < array.size(); ++i) {
                res.getInvestigations().add(this.parseClinicalImpressionClinicalImpressionInvestigationsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("protocol")) {
            res.setProtocolElement(this.parseUri(json.get("protocol").getAsString()));
        }
        if (json.has("_protocol")) {
            this.parseElementProperties(json.getAsJsonObject("_protocol"), res.getProtocolElement());
        }
        if (json.has("summary")) {
            res.setSummaryElement(this.parseString(json.get("summary").getAsString()));
        }
        if (json.has("_summary")) {
            this.parseElementProperties(json.getAsJsonObject("_summary"), res.getSummaryElement());
        }
        if (json.has("finding")) {
            JsonArray array = json.getAsJsonArray("finding");
            for (i = 0; i < array.size(); ++i) {
                res.getFinding().add(this.parseClinicalImpressionClinicalImpressionFindingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("resolved")) {
            JsonArray array = json.getAsJsonArray("resolved");
            for (i = 0; i < array.size(); ++i) {
                res.getResolved().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("ruledOut")) {
            JsonArray array = json.getAsJsonArray("ruledOut");
            for (i = 0; i < array.size(); ++i) {
                res.getRuledOut().add(this.parseClinicalImpressionClinicalImpressionRuledOutComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("prognosis")) {
            res.setPrognosisElement(this.parseString(json.get("prognosis").getAsString()));
        }
        if (json.has("_prognosis")) {
            this.parseElementProperties(json.getAsJsonObject("_prognosis"), res.getPrognosisElement());
        }
        if (json.has("plan")) {
            JsonArray array = json.getAsJsonArray("plan");
            for (i = 0; i < array.size(); ++i) {
                res.getPlan().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            JsonArray array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ClinicalImpression.ClinicalImpressionInvestigationsComponent parseClinicalImpressionClinicalImpressionInvestigationsComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionInvestigationsComponent res = new ClinicalImpression.ClinicalImpressionInvestigationsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("item")) {
            JsonArray array = json.getAsJsonArray("item");
            for (int i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionClinicalImpressionFindingComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("item")) {
            res.setItem(this.parseCodeableConcept(json.getAsJsonObject("item")));
        }
        if (json.has("cause")) {
            res.setCauseElement(this.parseString(json.get("cause").getAsString()));
        }
        if (json.has("_cause")) {
            this.parseElementProperties(json.getAsJsonObject("_cause"), res.getCauseElement());
        }
        return res;
    }

    protected ClinicalImpression.ClinicalImpressionRuledOutComponent parseClinicalImpressionClinicalImpressionRuledOutComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionRuledOutComponent res = new ClinicalImpression.ClinicalImpressionRuledOutComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("item")) {
            res.setItem(this.parseCodeableConcept(json.getAsJsonObject("item")));
        }
        if (json.has("reason")) {
            res.setReasonElement(this.parseString(json.get("reason").getAsString()));
        }
        if (json.has("_reason")) {
            this.parseElementProperties(json.getAsJsonObject("_reason"), res.getReasonElement());
        }
        return res;
    }

    protected Communication parseCommunication(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Communication res = new Communication();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("sender")) {
            res.setSender(this.parseReference(json.getAsJsonObject("sender")));
        }
        if (json.has("recipient")) {
            array = json.getAsJsonArray("recipient");
            for (i = 0; i < array.size(); ++i) {
                res.getRecipient().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("payload")) {
            array = json.getAsJsonArray("payload");
            for (i = 0; i < array.size(); ++i) {
                res.getPayload().add(this.parseCommunicationCommunicationPayloadComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("medium")) {
            array = json.getAsJsonArray("medium");
            for (i = 0; i < array.size(); ++i) {
                res.getMedium().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Communication.CommunicationStatus.NULL, new Communication.CommunicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("sent")) {
            res.setSentElement(this.parseDateTime(json.get("sent").getAsString()));
        }
        if (json.has("_sent")) {
            this.parseElementProperties(json.getAsJsonObject("_sent"), res.getSentElement());
        }
        if (json.has("received")) {
            res.setReceivedElement(this.parseDateTime(json.get("received").getAsString()));
        }
        if (json.has("_received")) {
            this.parseElementProperties(json.getAsJsonObject("_received"), res.getReceivedElement());
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("requestDetail")) {
            res.setRequestDetail(this.parseReference(json.getAsJsonObject("requestDetail")));
        }
        return res;
    }

    protected Communication.CommunicationPayloadComponent parseCommunicationCommunicationPayloadComponent(JsonObject json, Communication owner) throws IOException, FHIRFormatError {
        Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
        return res;
    }

    protected CommunicationRequest parseCommunicationRequest(JsonObject json) throws IOException, FHIRFormatError {
        Type scheduled;
        int i;
        JsonArray array;
        CommunicationRequest res = new CommunicationRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("sender")) {
            res.setSender(this.parseReference(json.getAsJsonObject("sender")));
        }
        if (json.has("recipient")) {
            array = json.getAsJsonArray("recipient");
            for (i = 0; i < array.size(); ++i) {
                res.getRecipient().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("payload")) {
            array = json.getAsJsonArray("payload");
            for (i = 0; i < array.size(); ++i) {
                res.getPayload().add(this.parseCommunicationRequestCommunicationRequestPayloadComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("medium")) {
            array = json.getAsJsonArray("medium");
            for (i = 0; i < array.size(); ++i) {
                res.getMedium().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requester")) {
            res.setRequester(this.parseReference(json.getAsJsonObject("requester")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CommunicationRequest.CommunicationRequestStatus.NULL, new CommunicationRequest.CommunicationRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if ((scheduled = this.parseType("scheduled", json)) != null) {
            res.setScheduled(scheduled);
        }
        if (json.has("reason")) {
            JsonArray array2 = json.getAsJsonArray("reason");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getReason().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("requestedOn")) {
            res.setRequestedOnElement(this.parseDateTime(json.get("requestedOn").getAsString()));
        }
        if (json.has("_requestedOn")) {
            this.parseElementProperties(json.getAsJsonObject("_requestedOn"), res.getRequestedOnElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(json.getAsJsonObject("priority")));
        }
        return res;
    }

    protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestCommunicationRequestPayloadComponent(JsonObject json, CommunicationRequest owner) throws IOException, FHIRFormatError {
        CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
        return res;
    }

    protected Composition parseComposition(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Composition res = new Composition();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("class")) {
            res.setClass_(this.parseCodeableConcept(json.getAsJsonObject("class")));
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Composition.CompositionStatus.NULL, new Composition.CompositionStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("confidentiality")) {
            res.setConfidentialityElement(this.parseCode(json.get("confidentiality").getAsString()));
        }
        if (json.has("_confidentiality")) {
            this.parseElementProperties(json.getAsJsonObject("_confidentiality"), res.getConfidentialityElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("attester")) {
            array = json.getAsJsonArray("attester");
            for (i = 0; i < array.size(); ++i) {
                res.getAttester().add(this.parseCompositionCompositionAttesterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(json.getAsJsonObject("custodian")));
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseCompositionCompositionEventComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("section")) {
            array = json.getAsJsonArray("section");
            for (i = 0; i < array.size(); ++i) {
                res.getSection().add(this.parseCompositionSectionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            array = json.getAsJsonArray("mode");
            for (i = 0; i < array.size(); ++i) {
                res.getMode().add(this.parseEnumeration(array.get(i).getAsString(), Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
            }
        }
        if (json.has("_mode")) {
            array = json.getAsJsonArray("_mode");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getMode().size()) {
                    res.getMode().add(this.parseEnumeration(null, Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getMode().get(i));
            }
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(json.getAsJsonObject("party")));
        }
        return res;
    }

    protected Composition.CompositionEventComponent parseCompositionCompositionEventComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Composition.SectionComponent parseCompositionSectionComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Composition.SectionComponent res = new Composition.SectionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("text")) {
            res.setText(this.parseNarrative(json.getAsJsonObject("text")));
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseCode(json.get("mode").getAsString()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(json.getAsJsonObject("orderedBy")));
        }
        if (json.has("entry")) {
            array = json.getAsJsonArray("entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(json.getAsJsonObject("emptyReason")));
        }
        if (json.has("section")) {
            array = json.getAsJsonArray("section");
            for (i = 0; i < array.size(); ++i) {
                res.getSection().add(this.parseCompositionSectionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ConceptMap parseConceptMap(JsonObject json) throws IOException, FHIRFormatError {
        Type target;
        Type source;
        int i;
        JsonArray array;
        ConceptMap res = new ConceptMap();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseConceptMapConceptMapContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if ((source = this.parseType("source", json)) != null) {
            res.setSource(source);
        }
        if ((target = this.parseType("target", json)) != null) {
            res.setTarget(target);
        }
        if (json.has("element")) {
            JsonArray array2 = json.getAsJsonArray("element");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getElement().add(this.parseConceptMapSourceElementComponent(array2.get(i2).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ConceptMap.ConceptMapContactComponent parseConceptMapConceptMapContactComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
        ConceptMap.ConceptMapContactComponent res = new ConceptMap.ConceptMapContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
        ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("codeSystem")) {
            res.setCodeSystemElement(this.parseUri(json.get("codeSystem").getAsString()));
        }
        if (json.has("_codeSystem")) {
            this.parseElementProperties(json.getAsJsonObject("_codeSystem"), res.getCodeSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("target")) {
            JsonArray array = json.getAsJsonArray("target");
            for (int i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseConceptMapTargetElementComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("codeSystem")) {
            res.setCodeSystemElement(this.parseUri(json.get("codeSystem").getAsString()));
        }
        if (json.has("_codeSystem")) {
            this.parseElementProperties(json.getAsJsonObject("_codeSystem"), res.getCodeSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("equivalence")) {
            res.setEquivalenceElement(this.parseEnumeration(json.get("equivalence").getAsString(), Enumerations.ConceptMapEquivalence.NULL, new Enumerations.ConceptMapEquivalenceEnumFactory()));
        }
        if (json.has("_equivalence")) {
            this.parseElementProperties(json.getAsJsonObject("_equivalence"), res.getEquivalenceElement());
        }
        if (json.has("comments")) {
            res.setCommentsElement(this.parseString(json.get("comments").getAsString()));
        }
        if (json.has("_comments")) {
            this.parseElementProperties(json.getAsJsonObject("_comments"), res.getCommentsElement());
        }
        if (json.has("dependsOn")) {
            array = json.getAsJsonArray("dependsOn");
            for (i = 0; i < array.size(); ++i) {
                res.getDependsOn().add(this.parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("product")) {
            array = json.getAsJsonArray("product");
            for (i = 0; i < array.size(); ++i) {
                res.getProduct().add(this.parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
        ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("element")) {
            res.setElementElement(this.parseUri(json.get("element").getAsString()));
        }
        if (json.has("_element")) {
            this.parseElementProperties(json.getAsJsonObject("_element"), res.getElementElement());
        }
        if (json.has("codeSystem")) {
            res.setCodeSystemElement(this.parseUri(json.get("codeSystem").getAsString()));
        }
        if (json.has("_codeSystem")) {
            this.parseElementProperties(json.getAsJsonObject("_codeSystem"), res.getCodeSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseString(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected Condition parseCondition(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type abatement;
        Type onset;
        Condition res = new Condition();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array2 = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("asserter")) {
            res.setAsserter(this.parseReference(json.getAsJsonObject("asserter")));
        }
        if (json.has("dateRecorded")) {
            res.setDateRecordedElement(this.parseDate(json.get("dateRecorded").getAsString()));
        }
        if (json.has("_dateRecorded")) {
            this.parseElementProperties(json.getAsJsonObject("_dateRecorded"), res.getDateRecordedElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("clinicalStatus")) {
            res.setClinicalStatusElement(this.parseCode(json.get("clinicalStatus").getAsString()));
        }
        if (json.has("_clinicalStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_clinicalStatus"), res.getClinicalStatusElement());
        }
        if (json.has("verificationStatus")) {
            res.setVerificationStatusElement(this.parseEnumeration(json.get("verificationStatus").getAsString(), Condition.ConditionVerificationStatus.NULL, new Condition.ConditionVerificationStatusEnumFactory()));
        }
        if (json.has("_verificationStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_verificationStatus"), res.getVerificationStatusElement());
        }
        if (json.has("severity")) {
            res.setSeverity(this.parseCodeableConcept(json.getAsJsonObject("severity")));
        }
        if ((onset = this.parseType("onset", json)) != null) {
            res.setOnset(onset);
        }
        if ((abatement = this.parseType("abatement", json)) != null) {
            res.setAbatement(abatement);
        }
        if (json.has("stage")) {
            res.setStage(this.parseConditionConditionStageComponent(json.getAsJsonObject("stage"), res));
        }
        if (json.has("evidence")) {
            array = json.getAsJsonArray("evidence");
            for (i = 0; i < array.size(); ++i) {
                res.getEvidence().add(this.parseConditionConditionEvidenceComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("bodySite")) {
            array = json.getAsJsonArray("bodySite");
            for (i = 0; i < array.size(); ++i) {
                res.getBodySite().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("notes")) {
            res.setNotesElement(this.parseString(json.get("notes").getAsString()));
        }
        if (json.has("_notes")) {
            this.parseElementProperties(json.getAsJsonObject("_notes"), res.getNotesElement());
        }
        return res;
    }

    protected Condition.ConditionStageComponent parseConditionConditionStageComponent(JsonObject json, Condition owner) throws IOException, FHIRFormatError {
        Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("summary")) {
            res.setSummary(this.parseCodeableConcept(json.getAsJsonObject("summary")));
        }
        if (json.has("assessment")) {
            JsonArray array = json.getAsJsonArray("assessment");
            for (int i = 0; i < array.size(); ++i) {
                res.getAssessment().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(JsonObject json, Condition owner) throws IOException, FHIRFormatError {
        Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("detail")) {
            JsonArray array = json.getAsJsonArray("detail");
            for (int i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Conformance parseConformance(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Conformance res = new Conformance();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseConformanceConformanceContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), Conformance.ConformanceStatementKind.NULL, new Conformance.ConformanceStatementKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("software")) {
            res.setSoftware(this.parseConformanceConformanceSoftwareComponent(json.getAsJsonObject("software"), res));
        }
        if (json.has("implementation")) {
            res.setImplementation(this.parseConformanceConformanceImplementationComponent(json.getAsJsonObject("implementation"), res));
        }
        if (json.has("fhirVersion")) {
            res.setFhirVersionElement(this.parseId(json.get("fhirVersion").getAsString()));
        }
        if (json.has("_fhirVersion")) {
            this.parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
        }
        if (json.has("acceptUnknown")) {
            res.setAcceptUnknownElement(this.parseEnumeration(json.get("acceptUnknown").getAsString(), Conformance.UnknownContentCode.NULL, new Conformance.UnknownContentCodeEnumFactory()));
        }
        if (json.has("_acceptUnknown")) {
            this.parseElementProperties(json.getAsJsonObject("_acceptUnknown"), res.getAcceptUnknownElement());
        }
        if (json.has("format")) {
            array = json.getAsJsonArray("format");
            for (i = 0; i < array.size(); ++i) {
                res.getFormat().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_format")) {
            array = json.getAsJsonArray("_format");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getFormat().size()) {
                    res.getFormat().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getFormat().get(i));
            }
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i = 0; i < array.size(); ++i) {
                res.getProfile().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("rest")) {
            array = json.getAsJsonArray("rest");
            for (i = 0; i < array.size(); ++i) {
                res.getRest().add(this.parseConformanceConformanceRestComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("messaging")) {
            array = json.getAsJsonArray("messaging");
            for (i = 0; i < array.size(); ++i) {
                res.getMessaging().add(this.parseConformanceConformanceMessagingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("document")) {
            array = json.getAsJsonArray("document");
            for (i = 0; i < array.size(); ++i) {
                res.getDocument().add(this.parseConformanceConformanceDocumentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Conformance.ConformanceContactComponent parseConformanceConformanceContactComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceContactComponent res = new Conformance.ConformanceContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Conformance.ConformanceSoftwareComponent parseConformanceConformanceSoftwareComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceSoftwareComponent res = new Conformance.ConformanceSoftwareComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("releaseDate")) {
            res.setReleaseDateElement(this.parseDateTime(json.get("releaseDate").getAsString()));
        }
        if (json.has("_releaseDate")) {
            this.parseElementProperties(json.getAsJsonObject("_releaseDate"), res.getReleaseDateElement());
        }
        return res;
    }

    protected Conformance.ConformanceImplementationComponent parseConformanceConformanceImplementationComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceImplementationComponent res = new Conformance.ConformanceImplementationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        return res;
    }

    protected Conformance.ConformanceRestComponent parseConformanceConformanceRestComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Conformance.ConformanceRestComponent res = new Conformance.ConformanceRestComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Conformance.RestfulConformanceMode.NULL, new Conformance.RestfulConformanceModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("security")) {
            res.setSecurity(this.parseConformanceConformanceRestSecurityComponent(json.getAsJsonObject("security"), owner));
        }
        if (json.has("resource")) {
            array = json.getAsJsonArray("resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseConformanceConformanceRestResourceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("interaction")) {
            array = json.getAsJsonArray("interaction");
            for (i = 0; i < array.size(); ++i) {
                res.getInteraction().add(this.parseConformanceSystemInteractionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("transactionMode")) {
            res.setTransactionModeElement(this.parseEnumeration(json.get("transactionMode").getAsString(), Conformance.TransactionMode.NULL, new Conformance.TransactionModeEnumFactory()));
        }
        if (json.has("_transactionMode")) {
            this.parseElementProperties(json.getAsJsonObject("_transactionMode"), res.getTransactionModeElement());
        }
        if (json.has("searchParam")) {
            array = json.getAsJsonArray("searchParam");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchParam().add(this.parseConformanceConformanceRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("operation")) {
            array = json.getAsJsonArray("operation");
            for (i = 0; i < array.size(); ++i) {
                res.getOperation().add(this.parseConformanceConformanceRestOperationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("compartment")) {
            array = json.getAsJsonArray("compartment");
            for (i = 0; i < array.size(); ++i) {
                res.getCompartment().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_compartment")) {
            array = json.getAsJsonArray("_compartment");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getCompartment().size()) {
                    res.getCompartment().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getCompartment().get(i));
            }
        }
        return res;
    }

    protected Conformance.ConformanceRestSecurityComponent parseConformanceConformanceRestSecurityComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Conformance.ConformanceRestSecurityComponent res = new Conformance.ConformanceRestSecurityComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("cors")) {
            res.setCorsElement(this.parseBoolean(json.get("cors").getAsBoolean()));
        }
        if (json.has("_cors")) {
            this.parseElementProperties(json.getAsJsonObject("_cors"), res.getCorsElement());
        }
        if (json.has("service")) {
            array = json.getAsJsonArray("service");
            for (i = 0; i < array.size(); ++i) {
                res.getService().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("certificate")) {
            array = json.getAsJsonArray("certificate");
            for (i = 0; i < array.size(); ++i) {
                res.getCertificate().add(this.parseConformanceConformanceRestSecurityCertificateComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Conformance.ConformanceRestSecurityCertificateComponent parseConformanceConformanceRestSecurityCertificateComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceRestSecurityCertificateComponent res = new Conformance.ConformanceRestSecurityCertificateComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("blob")) {
            res.setBlobElement(this.parseBase64Binary(json.get("blob").getAsString()));
        }
        if (json.has("_blob")) {
            this.parseElementProperties(json.getAsJsonObject("_blob"), res.getBlobElement());
        }
        return res;
    }

    protected Conformance.ConformanceRestResourceComponent parseConformanceConformanceRestResourceComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Conformance.ConformanceRestResourceComponent res = new Conformance.ConformanceRestResourceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        if (json.has("interaction")) {
            array = json.getAsJsonArray("interaction");
            for (i = 0; i < array.size(); ++i) {
                res.getInteraction().add(this.parseConformanceResourceInteractionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("versioning")) {
            res.setVersioningElement(this.parseEnumeration(json.get("versioning").getAsString(), Conformance.ResourceVersionPolicy.NULL, new Conformance.ResourceVersionPolicyEnumFactory()));
        }
        if (json.has("_versioning")) {
            this.parseElementProperties(json.getAsJsonObject("_versioning"), res.getVersioningElement());
        }
        if (json.has("readHistory")) {
            res.setReadHistoryElement(this.parseBoolean(json.get("readHistory").getAsBoolean()));
        }
        if (json.has("_readHistory")) {
            this.parseElementProperties(json.getAsJsonObject("_readHistory"), res.getReadHistoryElement());
        }
        if (json.has("updateCreate")) {
            res.setUpdateCreateElement(this.parseBoolean(json.get("updateCreate").getAsBoolean()));
        }
        if (json.has("_updateCreate")) {
            this.parseElementProperties(json.getAsJsonObject("_updateCreate"), res.getUpdateCreateElement());
        }
        if (json.has("conditionalCreate")) {
            res.setConditionalCreateElement(this.parseBoolean(json.get("conditionalCreate").getAsBoolean()));
        }
        if (json.has("_conditionalCreate")) {
            this.parseElementProperties(json.getAsJsonObject("_conditionalCreate"), res.getConditionalCreateElement());
        }
        if (json.has("conditionalUpdate")) {
            res.setConditionalUpdateElement(this.parseBoolean(json.get("conditionalUpdate").getAsBoolean()));
        }
        if (json.has("_conditionalUpdate")) {
            this.parseElementProperties(json.getAsJsonObject("_conditionalUpdate"), res.getConditionalUpdateElement());
        }
        if (json.has("conditionalDelete")) {
            res.setConditionalDeleteElement(this.parseEnumeration(json.get("conditionalDelete").getAsString(), Conformance.ConditionalDeleteStatus.NULL, new Conformance.ConditionalDeleteStatusEnumFactory()));
        }
        if (json.has("_conditionalDelete")) {
            this.parseElementProperties(json.getAsJsonObject("_conditionalDelete"), res.getConditionalDeleteElement());
        }
        if (json.has("searchInclude")) {
            array = json.getAsJsonArray("searchInclude");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchInclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_searchInclude")) {
            array = json.getAsJsonArray("_searchInclude");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSearchInclude().size()) {
                    res.getSearchInclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchInclude().get(i));
            }
        }
        if (json.has("searchRevInclude")) {
            array = json.getAsJsonArray("searchRevInclude");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchRevInclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_searchRevInclude")) {
            array = json.getAsJsonArray("_searchRevInclude");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSearchRevInclude().size()) {
                    res.getSearchRevInclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchRevInclude().get(i));
            }
        }
        if (json.has("searchParam")) {
            array = json.getAsJsonArray("searchParam");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchParam().add(this.parseConformanceConformanceRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Conformance.ResourceInteractionComponent parseConformanceResourceInteractionComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ResourceInteractionComponent res = new Conformance.ResourceInteractionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), Conformance.TypeRestfulInteraction.NULL, new Conformance.TypeRestfulInteractionEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        return res;
    }

    protected Conformance.ConformanceRestResourceSearchParamComponent parseConformanceConformanceRestResourceSearchParamComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Conformance.ConformanceRestResourceSearchParamComponent res = new Conformance.ConformanceRestResourceSearchParamComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseUri(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("target")) {
            array = json.getAsJsonArray("target");
            for (i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_target")) {
            array = json.getAsJsonArray("_target");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getTarget().size()) {
                    res.getTarget().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getTarget().get(i));
            }
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseEnumeration(array.get(i).getAsString(), Conformance.SearchModifierCode.NULL, new Conformance.SearchModifierCodeEnumFactory()));
            }
        }
        if (json.has("_modifier")) {
            array = json.getAsJsonArray("_modifier");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getModifier().size()) {
                    res.getModifier().add(this.parseEnumeration(null, Conformance.SearchModifierCode.NULL, new Conformance.SearchModifierCodeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getModifier().get(i));
            }
        }
        if (json.has("chain")) {
            array = json.getAsJsonArray("chain");
            for (i = 0; i < array.size(); ++i) {
                res.getChain().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_chain")) {
            array = json.getAsJsonArray("_chain");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getChain().size()) {
                    res.getChain().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getChain().get(i));
            }
        }
        return res;
    }

    protected Conformance.SystemInteractionComponent parseConformanceSystemInteractionComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.SystemInteractionComponent res = new Conformance.SystemInteractionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), Conformance.SystemRestfulInteraction.NULL, new Conformance.SystemRestfulInteractionEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        return res;
    }

    protected Conformance.ConformanceRestOperationComponent parseConformanceConformanceRestOperationComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceRestOperationComponent res = new Conformance.ConformanceRestOperationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("definition")) {
            res.setDefinition(this.parseReference(json.getAsJsonObject("definition")));
        }
        return res;
    }

    protected Conformance.ConformanceMessagingComponent parseConformanceConformanceMessagingComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Conformance.ConformanceMessagingComponent res = new Conformance.ConformanceMessagingComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseConformanceConformanceMessagingEndpointComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("reliableCache")) {
            res.setReliableCacheElement(this.parseUnsignedInt(json.get("reliableCache").getAsString()));
        }
        if (json.has("_reliableCache")) {
            this.parseElementProperties(json.getAsJsonObject("_reliableCache"), res.getReliableCacheElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseConformanceConformanceMessagingEventComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Conformance.ConformanceMessagingEndpointComponent parseConformanceConformanceMessagingEndpointComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceMessagingEndpointComponent res = new Conformance.ConformanceMessagingEndpointComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("protocol")) {
            res.setProtocol(this.parseCoding(json.getAsJsonObject("protocol")));
        }
        if (json.has("address")) {
            res.setAddressElement(this.parseUri(json.get("address").getAsString()));
        }
        if (json.has("_address")) {
            this.parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
        }
        return res;
    }

    protected Conformance.ConformanceMessagingEventComponent parseConformanceConformanceMessagingEventComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceMessagingEventComponent res = new Conformance.ConformanceMessagingEventComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCoding(json.getAsJsonObject("code")));
        }
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), Conformance.MessageSignificanceCategory.NULL, new Conformance.MessageSignificanceCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Conformance.ConformanceEventMode.NULL, new Conformance.ConformanceEventModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("focus")) {
            res.setFocusElement(this.parseCode(json.get("focus").getAsString()));
        }
        if (json.has("_focus")) {
            this.parseElementProperties(json.getAsJsonObject("_focus"), res.getFocusElement());
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseReference(json.getAsJsonObject("response")));
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        return res;
    }

    protected Conformance.ConformanceDocumentComponent parseConformanceConformanceDocumentComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceDocumentComponent res = new Conformance.ConformanceDocumentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Conformance.DocumentMode.NULL, new Conformance.DocumentModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        return res;
    }

    protected Contract parseContract(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type binding;
        int i2;
        JsonArray array;
        Contract res = new Contract();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseDateTime(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
        }
        if (json.has("applies")) {
            res.setApplies(this.parsePeriod(json.getAsJsonObject("applies")));
        }
        if (json.has("subject")) {
            array = json.getAsJsonArray("subject");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSubject().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("authority")) {
            array = json.getAsJsonArray("authority");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAuthority().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("domain")) {
            array = json.getAsJsonArray("domain");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDomain().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("subType")) {
            array = json.getAsJsonArray("subType");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSubType().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAction().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("actionReason")) {
            array = json.getAsJsonArray("actionReason");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getActionReason().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            array = json.getAsJsonArray("actor");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getActor().add(this.parseContractActorComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("valuedItem")) {
            array = json.getAsJsonArray("valuedItem");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getValuedItem().add(this.parseContractValuedItemComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("signer")) {
            array = json.getAsJsonArray("signer");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSigner().add(this.parseContractSignatoryComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("term")) {
            array = json.getAsJsonArray("term");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getTerm().add(this.parseContractTermComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if ((binding = this.parseType("binding", json)) != null) {
            res.setBinding(binding);
        }
        if (json.has("friendly")) {
            JsonArray array2 = json.getAsJsonArray("friendly");
            for (i = 0; i < array2.size(); ++i) {
                res.getFriendly().add(this.parseContractFriendlyLanguageComponent(array2.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("legal")) {
            JsonArray array3 = json.getAsJsonArray("legal");
            for (i = 0; i < array3.size(); ++i) {
                res.getLegal().add(this.parseContractLegalLanguageComponent(array3.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("rule")) {
            JsonArray array4 = json.getAsJsonArray("rule");
            for (i = 0; i < array4.size(); ++i) {
                res.getRule().add(this.parseContractComputableLanguageComponent(array4.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Contract.ActorComponent parseContractActorComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.ActorComponent res = new Contract.ActorComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("entity")) {
            res.setEntity(this.parseReference(json.getAsJsonObject("entity")));
        }
        if (json.has("role")) {
            JsonArray array = json.getAsJsonArray("role");
            for (int i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Contract.ValuedItemComponent parseContractValuedItemComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
        this.parseBackboneProperties(json, res);
        Type entity = this.parseType("entity", json);
        if (entity != null) {
            res.setEntity(entity);
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("effectiveTime")) {
            res.setEffectiveTimeElement(this.parseDateTime(json.get("effectiveTime").getAsString()));
        }
        if (json.has("_effectiveTime")) {
            this.parseElementProperties(json.getAsJsonObject("_effectiveTime"), res.getEffectiveTimeElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        return res;
    }

    protected Contract.SignatoryComponent parseContractSignatoryComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.SignatoryComponent res = new Contract.SignatoryComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(json.getAsJsonObject("party")));
        }
        if (json.has("signature")) {
            res.setSignatureElement(this.parseString(json.get("signature").getAsString()));
        }
        if (json.has("_signature")) {
            this.parseElementProperties(json.getAsJsonObject("_signature"), res.getSignatureElement());
        }
        return res;
    }

    protected Contract.TermComponent parseContractTermComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Contract.TermComponent res = new Contract.TermComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseDateTime(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
        }
        if (json.has("applies")) {
            res.setApplies(this.parsePeriod(json.getAsJsonObject("applies")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("subType")) {
            res.setSubType(this.parseCodeableConcept(json.getAsJsonObject("subType")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actionReason")) {
            array = json.getAsJsonArray("actionReason");
            for (i = 0; i < array.size(); ++i) {
                res.getActionReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            array = json.getAsJsonArray("actor");
            for (i = 0; i < array.size(); ++i) {
                res.getActor().add(this.parseContractTermActorComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("valuedItem")) {
            array = json.getAsJsonArray("valuedItem");
            for (i = 0; i < array.size(); ++i) {
                res.getValuedItem().add(this.parseContractTermValuedItemComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("group")) {
            array = json.getAsJsonArray("group");
            for (i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseContractTermComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Contract.TermActorComponent parseContractTermActorComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.TermActorComponent res = new Contract.TermActorComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("entity")) {
            res.setEntity(this.parseReference(json.getAsJsonObject("entity")));
        }
        if (json.has("role")) {
            JsonArray array = json.getAsJsonArray("role");
            for (int i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Contract.TermValuedItemComponent parseContractTermValuedItemComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.TermValuedItemComponent res = new Contract.TermValuedItemComponent();
        this.parseBackboneProperties(json, res);
        Type entity = this.parseType("entity", json);
        if (entity != null) {
            res.setEntity(entity);
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("effectiveTime")) {
            res.setEffectiveTimeElement(this.parseDateTime(json.get("effectiveTime").getAsString()));
        }
        if (json.has("_effectiveTime")) {
            this.parseElementProperties(json.getAsJsonObject("_effectiveTime"), res.getEffectiveTimeElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        return res;
    }

    protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
        return res;
    }

    protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
        return res;
    }

    protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
        return res;
    }

    protected Coverage parseCoverage(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Coverage res = new Coverage();
        this.parseDomainResourceProperties(json, res);
        if (json.has("issuer")) {
            res.setIssuer(this.parseReference(json.getAsJsonObject("issuer")));
        }
        if (json.has("bin")) {
            res.setBin(this.parseIdentifier(json.getAsJsonObject("bin")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("subscriberId")) {
            res.setSubscriberId(this.parseIdentifier(json.getAsJsonObject("subscriberId")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("group")) {
            res.setGroupElement(this.parseString(json.get("group").getAsString()));
        }
        if (json.has("_group")) {
            this.parseElementProperties(json.getAsJsonObject("_group"), res.getGroupElement());
        }
        if (json.has("plan")) {
            res.setPlanElement(this.parseString(json.get("plan").getAsString()));
        }
        if (json.has("_plan")) {
            this.parseElementProperties(json.getAsJsonObject("_plan"), res.getPlanElement());
        }
        if (json.has("subPlan")) {
            res.setSubPlanElement(this.parseString(json.get("subPlan").getAsString()));
        }
        if (json.has("_subPlan")) {
            this.parseElementProperties(json.getAsJsonObject("_subPlan"), res.getSubPlanElement());
        }
        if (json.has("dependent")) {
            res.setDependentElement(this.parsePositiveInt(json.get("dependent").getAsString()));
        }
        if (json.has("_dependent")) {
            this.parseElementProperties(json.getAsJsonObject("_dependent"), res.getDependentElement());
        }
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("subscriber")) {
            res.setSubscriber(this.parseReference(json.getAsJsonObject("subscriber")));
        }
        if (json.has("network")) {
            res.setNetwork(this.parseIdentifier(json.getAsJsonObject("network")));
        }
        if (json.has("contract")) {
            array = json.getAsJsonArray("contract");
            for (i = 0; i < array.size(); ++i) {
                res.getContract().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DataElement parseDataElement(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataElement res = new DataElement();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseDataElementDataElementContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("stringency")) {
            res.setStringencyElement(this.parseEnumeration(json.get("stringency").getAsString(), DataElement.DataElementStringency.NULL, new DataElement.DataElementStringencyEnumFactory()));
        }
        if (json.has("_stringency")) {
            this.parseElementProperties(json.getAsJsonObject("_stringency"), res.getStringencyElement());
        }
        if (json.has("mapping")) {
            array = json.getAsJsonArray("mapping");
            for (i = 0; i < array.size(); ++i) {
                res.getMapping().add(this.parseDataElementDataElementMappingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("element")) {
            array = json.getAsJsonArray("element");
            for (i = 0; i < array.size(); ++i) {
                res.getElement().add(this.parseElementDefinition(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DataElement.DataElementContactComponent parseDataElementDataElementContactComponent(JsonObject json, DataElement owner) throws IOException, FHIRFormatError {
        DataElement.DataElementContactComponent res = new DataElement.DataElementContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DataElement.DataElementMappingComponent parseDataElementDataElementMappingComponent(JsonObject json, DataElement owner) throws IOException, FHIRFormatError {
        DataElement.DataElementMappingComponent res = new DataElement.DataElementMappingComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identity")) {
            res.setIdentityElement(this.parseId(json.get("identity").getAsString()));
        }
        if (json.has("_identity")) {
            this.parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("comments")) {
            res.setCommentsElement(this.parseString(json.get("comments").getAsString()));
        }
        if (json.has("_comments")) {
            this.parseElementProperties(json.getAsJsonObject("_comments"), res.getCommentsElement());
        }
        return res;
    }

    protected DetectedIssue parseDetectedIssue(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DetectedIssue res = new DetectedIssue();
        this.parseDomainResourceProperties(json, res);
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
        }
        if (json.has("implicated")) {
            array = json.getAsJsonArray("implicated");
            for (i = 0; i < array.size(); ++i) {
                res.getImplicated().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            res.setDetailElement(this.parseString(json.get("detail").getAsString()));
        }
        if (json.has("_detail")) {
            this.parseElementProperties(json.getAsJsonObject("_detail"), res.getDetailElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseUri(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
        }
        if (json.has("mitigation")) {
            array = json.getAsJsonArray("mitigation");
            for (i = 0; i < array.size(); ++i) {
                res.getMitigation().add(this.parseDetectedIssueDetectedIssueMitigationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueDetectedIssueMitigationComponent(JsonObject json, DetectedIssue owner) throws IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("action")) {
            res.setAction(this.parseCodeableConcept(json.getAsJsonObject("action")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        return res;
    }

    protected Device parseDevice(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Device res = new Device();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Device.DeviceStatus.NULL, new Device.DeviceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("manufacturer")) {
            res.setManufacturerElement(this.parseString(json.get("manufacturer").getAsString()));
        }
        if (json.has("_manufacturer")) {
            this.parseElementProperties(json.getAsJsonObject("_manufacturer"), res.getManufacturerElement());
        }
        if (json.has("model")) {
            res.setModelElement(this.parseString(json.get("model").getAsString()));
        }
        if (json.has("_model")) {
            this.parseElementProperties(json.getAsJsonObject("_model"), res.getModelElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("manufactureDate")) {
            res.setManufactureDateElement(this.parseDateTime(json.get("manufactureDate").getAsString()));
        }
        if (json.has("_manufactureDate")) {
            this.parseElementProperties(json.getAsJsonObject("_manufactureDate"), res.getManufactureDateElement());
        }
        if (json.has("expiry")) {
            res.setExpiryElement(this.parseDateTime(json.get("expiry").getAsString()));
        }
        if (json.has("_expiry")) {
            this.parseElementProperties(json.getAsJsonObject("_expiry"), res.getExpiryElement());
        }
        if (json.has("udi")) {
            res.setUdiElement(this.parseString(json.get("udi").getAsString()));
        }
        if (json.has("_udi")) {
            this.parseElementProperties(json.getAsJsonObject("_udi"), res.getUdiElement());
        }
        if (json.has("lotNumber")) {
            res.setLotNumberElement(this.parseString(json.get("lotNumber").getAsString()));
        }
        if (json.has("_lotNumber")) {
            this.parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
        }
        if (json.has("owner")) {
            res.setOwner(this.parseReference(json.getAsJsonObject("owner")));
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        return res;
    }

    protected DeviceComponent parseDeviceComponent(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DeviceComponent res = new DeviceComponent();
        this.parseDomainResourceProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("lastSystemChange")) {
            res.setLastSystemChangeElement(this.parseInstant(json.get("lastSystemChange").getAsString()));
        }
        if (json.has("_lastSystemChange")) {
            this.parseElementProperties(json.getAsJsonObject("_lastSystemChange"), res.getLastSystemChangeElement());
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("parent")) {
            res.setParent(this.parseReference(json.getAsJsonObject("parent")));
        }
        if (json.has("operationalStatus")) {
            array = json.getAsJsonArray("operationalStatus");
            for (i = 0; i < array.size(); ++i) {
                res.getOperationalStatus().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("parameterGroup")) {
            res.setParameterGroup(this.parseCodeableConcept(json.getAsJsonObject("parameterGroup")));
        }
        if (json.has("measurementPrinciple")) {
            res.setMeasurementPrincipleElement(this.parseEnumeration(json.get("measurementPrinciple").getAsString(), DeviceComponent.MeasmntPrinciple.NULL, new DeviceComponent.MeasmntPrincipleEnumFactory()));
        }
        if (json.has("_measurementPrinciple")) {
            this.parseElementProperties(json.getAsJsonObject("_measurementPrinciple"), res.getMeasurementPrincipleElement());
        }
        if (json.has("productionSpecification")) {
            array = json.getAsJsonArray("productionSpecification");
            for (i = 0; i < array.size(); ++i) {
                res.getProductionSpecification().add(this.parseDeviceComponentDeviceComponentProductionSpecificationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("languageCode")) {
            res.setLanguageCode(this.parseCodeableConcept(json.getAsJsonObject("languageCode")));
        }
        return res;
    }

    protected DeviceComponent.DeviceComponentProductionSpecificationComponent parseDeviceComponentDeviceComponentProductionSpecificationComponent(JsonObject json, DeviceComponent owner) throws IOException, FHIRFormatError {
        DeviceComponent.DeviceComponentProductionSpecificationComponent res = new DeviceComponent.DeviceComponentProductionSpecificationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("specType")) {
            res.setSpecType(this.parseCodeableConcept(json.getAsJsonObject("specType")));
        }
        if (json.has("componentId")) {
            res.setComponentId(this.parseIdentifier(json.getAsJsonObject("componentId")));
        }
        if (json.has("productionSpec")) {
            res.setProductionSpecElement(this.parseString(json.get("productionSpec").getAsString()));
        }
        if (json.has("_productionSpec")) {
            this.parseElementProperties(json.getAsJsonObject("_productionSpec"), res.getProductionSpecElement());
        }
        return res;
    }

    protected DeviceMetric parseDeviceMetric(JsonObject json) throws IOException, FHIRFormatError {
        DeviceMetric res = new DeviceMetric();
        this.parseDomainResourceProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCodeableConcept(json.getAsJsonObject("unit")));
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("parent")) {
            res.setParent(this.parseReference(json.getAsJsonObject("parent")));
        }
        if (json.has("operationalStatus")) {
            res.setOperationalStatusElement(this.parseEnumeration(json.get("operationalStatus").getAsString(), DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
        }
        if (json.has("_operationalStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_operationalStatus"), res.getOperationalStatusElement());
        }
        if (json.has("color")) {
            res.setColorElement(this.parseEnumeration(json.get("color").getAsString(), DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
        }
        if (json.has("_color")) {
            this.parseElementProperties(json.getAsJsonObject("_color"), res.getColorElement());
        }
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
        }
        if (json.has("measurementPeriod")) {
            res.setMeasurementPeriod(this.parseTiming(json.getAsJsonObject("measurementPeriod")));
        }
        if (json.has("calibration")) {
            JsonArray array = json.getAsJsonArray("calibration");
            for (int i = 0; i < array.size(); ++i) {
                res.getCalibration().add(this.parseDeviceMetricDeviceMetricCalibrationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricDeviceMetricCalibrationComponent(JsonObject json, DeviceMetric owner) throws IOException, FHIRFormatError {
        DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("state")) {
            res.setStateElement(this.parseEnumeration(json.get("state").getAsString(), DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
        }
        if (json.has("_state")) {
            this.parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseInstant(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
        }
        return res;
    }

    protected DeviceUseRequest parseDeviceUseRequest(JsonObject json) throws IOException, FHIRFormatError {
        Type timing;
        int i;
        JsonArray array;
        DeviceUseRequest res = new DeviceUseRequest();
        this.parseDomainResourceProperties(json, res);
        Type bodySite = this.parseType("bodySite", json);
        if (bodySite != null) {
            res.setBodySite(bodySite);
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DeviceUseRequest.DeviceUseRequestStatus.NULL, new DeviceUseRequest.DeviceUseRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(json.getAsJsonObject("device")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("indication")) {
            array = json.getAsJsonArray("indication");
            for (i = 0; i < array.size(); ++i) {
                res.getIndication().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("notes")) {
            array = json.getAsJsonArray("notes");
            for (i = 0; i < array.size(); ++i) {
                res.getNotes().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_notes")) {
            array = json.getAsJsonArray("_notes");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNotes().size()) {
                    res.getNotes().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNotes().get(i));
            }
        }
        if (json.has("prnReason")) {
            array = json.getAsJsonArray("prnReason");
            for (i = 0; i < array.size(); ++i) {
                res.getPrnReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("orderedOn")) {
            res.setOrderedOnElement(this.parseDateTime(json.get("orderedOn").getAsString()));
        }
        if (json.has("_orderedOn")) {
            this.parseElementProperties(json.getAsJsonObject("_orderedOn"), res.getOrderedOnElement());
        }
        if (json.has("recordedOn")) {
            res.setRecordedOnElement(this.parseDateTime(json.get("recordedOn").getAsString()));
        }
        if (json.has("_recordedOn")) {
            this.parseElementProperties(json.getAsJsonObject("_recordedOn"), res.getRecordedOnElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), DeviceUseRequest.DeviceUseRequestPriority.NULL, new DeviceUseRequest.DeviceUseRequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        return res;
    }

    protected DeviceUseStatement parseDeviceUseStatement(JsonObject json) throws IOException, FHIRFormatError {
        Type timing;
        int i;
        JsonArray array;
        DeviceUseStatement res = new DeviceUseStatement();
        this.parseDomainResourceProperties(json, res);
        Type bodySite = this.parseType("bodySite", json);
        if (bodySite != null) {
            res.setBodySite(bodySite);
        }
        if (json.has("whenUsed")) {
            res.setWhenUsed(this.parsePeriod(json.getAsJsonObject("whenUsed")));
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(json.getAsJsonObject("device")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("indication")) {
            array = json.getAsJsonArray("indication");
            for (i = 0; i < array.size(); ++i) {
                res.getIndication().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("notes")) {
            array = json.getAsJsonArray("notes");
            for (i = 0; i < array.size(); ++i) {
                res.getNotes().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_notes")) {
            array = json.getAsJsonArray("_notes");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNotes().size()) {
                    res.getNotes().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNotes().get(i));
            }
        }
        if (json.has("recordedOn")) {
            res.setRecordedOnElement(this.parseDateTime(json.get("recordedOn").getAsString()));
        }
        if (json.has("_recordedOn")) {
            this.parseElementProperties(json.getAsJsonObject("_recordedOn"), res.getRecordedOnElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        return res;
    }

    protected DiagnosticOrder parseDiagnosticOrder(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DiagnosticOrder res = new DiagnosticOrder();
        this.parseDomainResourceProperties(json, res);
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("orderer")) {
            res.setOrderer(this.parseReference(json.getAsJsonObject("orderer")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInformation")) {
            array = json.getAsJsonArray("supportingInformation");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInformation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specimen")) {
            array = json.getAsJsonArray("specimen");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecimen().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), DiagnosticOrder.DiagnosticOrderPriority.NULL, new DiagnosticOrder.DiagnosticOrderPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseDiagnosticOrderDiagnosticOrderEventComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseDiagnosticOrderDiagnosticOrderItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DiagnosticOrder.DiagnosticOrderEventComponent parseDiagnosticOrderDiagnosticOrderEventComponent(JsonObject json, DiagnosticOrder owner) throws IOException, FHIRFormatError {
        DiagnosticOrder.DiagnosticOrderEventComponent res = new DiagnosticOrder.DiagnosticOrderEventComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("description")) {
            res.setDescription(this.parseCodeableConcept(json.getAsJsonObject("description")));
        }
        if (json.has("dateTime")) {
            res.setDateTimeElement(this.parseDateTime(json.get("dateTime").getAsString()));
        }
        if (json.has("_dateTime")) {
            this.parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        return res;
    }

    protected DiagnosticOrder.DiagnosticOrderItemComponent parseDiagnosticOrderDiagnosticOrderItemComponent(JsonObject json, DiagnosticOrder owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DiagnosticOrder.DiagnosticOrderItemComponent res = new DiagnosticOrder.DiagnosticOrderItemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("specimen")) {
            array = json.getAsJsonArray("specimen");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecimen().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(json.getAsJsonObject("bodySite")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseDiagnosticOrderDiagnosticOrderEventComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected DiagnosticReport parseDiagnosticReport(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type effective;
        DiagnosticReport res = new DiagnosticReport();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseInstant(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
        if (json.has("request")) {
            JsonArray array = json.getAsJsonArray("request");
            for (i = 0; i < array.size(); ++i) {
                res.getRequest().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specimen")) {
            JsonArray array = json.getAsJsonArray("specimen");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecimen().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("result")) {
            JsonArray array = json.getAsJsonArray("result");
            for (i = 0; i < array.size(); ++i) {
                res.getResult().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("imagingStudy")) {
            JsonArray array = json.getAsJsonArray("imagingStudy");
            for (i = 0; i < array.size(); ++i) {
                res.getImagingStudy().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("image")) {
            JsonArray array = json.getAsJsonArray("image");
            for (i = 0; i < array.size(); ++i) {
                res.getImage().add(this.parseDiagnosticReportDiagnosticReportImageComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("conclusion")) {
            res.setConclusionElement(this.parseString(json.get("conclusion").getAsString()));
        }
        if (json.has("_conclusion")) {
            this.parseElementProperties(json.getAsJsonObject("_conclusion"), res.getConclusionElement());
        }
        if (json.has("codedDiagnosis")) {
            JsonArray array = json.getAsJsonArray("codedDiagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getCodedDiagnosis().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("presentedForm")) {
            JsonArray array = json.getAsJsonArray("presentedForm");
            for (i = 0; i < array.size(); ++i) {
                res.getPresentedForm().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DiagnosticReport.DiagnosticReportImageComponent parseDiagnosticReportDiagnosticReportImageComponent(JsonObject json, DiagnosticReport owner) throws IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportImageComponent res = new DiagnosticReport.DiagnosticReportImageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("link")) {
            res.setLink(this.parseReference(json.getAsJsonObject("link")));
        }
        return res;
    }

    protected DocumentManifest parseDocumentManifest(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DocumentManifest res = new DocumentManifest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("masterIdentifier")) {
            res.setMasterIdentifier(this.parseIdentifier(json.getAsJsonObject("masterIdentifier")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("recipient")) {
            array = json.getAsJsonArray("recipient");
            for (i = 0; i < array.size(); ++i) {
                res.getRecipient().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("source")) {
            res.setSourceElement(this.parseUri(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("content")) {
            array = json.getAsJsonArray("content");
            for (i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseDocumentManifestDocumentManifestContentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("related")) {
            array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseDocumentManifestDocumentManifestRelatedComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected DocumentManifest.DocumentManifestContentComponent parseDocumentManifestDocumentManifestContentComponent(JsonObject json, DocumentManifest owner) throws IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestContentComponent res = new DocumentManifest.DocumentManifestContentComponent();
        this.parseBackboneProperties(json, res);
        Type p = this.parseType("p", json);
        if (p != null) {
            res.setP(p);
        }
        return res;
    }

    protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestDocumentManifestRelatedComponent(JsonObject json, DocumentManifest owner) throws IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("ref")) {
            res.setRef(this.parseReference(json.getAsJsonObject("ref")));
        }
        return res;
    }

    protected DocumentReference parseDocumentReference(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DocumentReference res = new DocumentReference();
        this.parseDomainResourceProperties(json, res);
        if (json.has("masterIdentifier")) {
            res.setMasterIdentifier(this.parseIdentifier(json.getAsJsonObject("masterIdentifier")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("class")) {
            res.setClass_(this.parseCodeableConcept(json.getAsJsonObject("class")));
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(json.getAsJsonObject("custodian")));
        }
        if (json.has("authenticator")) {
            res.setAuthenticator(this.parseReference(json.getAsJsonObject("authenticator")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("indexed")) {
            res.setIndexedElement(this.parseInstant(json.get("indexed").getAsString()));
        }
        if (json.has("_indexed")) {
            this.parseElementProperties(json.getAsJsonObject("_indexed"), res.getIndexedElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("docStatus")) {
            res.setDocStatus(this.parseCodeableConcept(json.getAsJsonObject("docStatus")));
        }
        if (json.has("relatesTo")) {
            array = json.getAsJsonArray("relatesTo");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatesTo().add(this.parseDocumentReferenceDocumentReferenceRelatesToComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("securityLabel")) {
            array = json.getAsJsonArray("securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("content")) {
            array = json.getAsJsonArray("content");
            for (i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseDocumentReferenceDocumentReferenceContentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("context")) {
            res.setContext(this.parseDocumentReferenceDocumentReferenceContextComponent(json.getAsJsonObject("context"), res));
        }
        return res;
    }

    protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), DocumentReference.DocumentRelationshipType.NULL, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        return res;
    }

    protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceDocumentReferenceContentComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("attachment")) {
            res.setAttachment(this.parseAttachment(json.getAsJsonObject("attachment")));
        }
        if (json.has("format")) {
            JsonArray array = json.getAsJsonArray("format");
            for (int i = 0; i < array.size(); ++i) {
                res.getFormat().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("facilityType")) {
            res.setFacilityType(this.parseCodeableConcept(json.getAsJsonObject("facilityType")));
        }
        if (json.has("practiceSetting")) {
            res.setPracticeSetting(this.parseCodeableConcept(json.getAsJsonObject("practiceSetting")));
        }
        if (json.has("sourcePatientInfo")) {
            res.setSourcePatientInfo(this.parseReference(json.getAsJsonObject("sourcePatientInfo")));
        }
        if (json.has("related")) {
            array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseDocumentReferenceDocumentReferenceContextRelatedComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected DocumentReference.DocumentReferenceContextRelatedComponent parseDocumentReferenceDocumentReferenceContextRelatedComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContextRelatedComponent res = new DocumentReference.DocumentReferenceContextRelatedComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("ref")) {
            res.setRef(this.parseReference(json.getAsJsonObject("ref")));
        }
        return res;
    }

    protected EligibilityRequest parseEligibilityRequest(JsonObject json) throws IOException, FHIRFormatError {
        EligibilityRequest res = new EligibilityRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        return res;
    }

    protected EligibilityResponse parseEligibilityResponse(JsonObject json) throws IOException, FHIRFormatError {
        EligibilityResponse res = new EligibilityResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(json.getAsJsonObject("requestProvider")));
        }
        if (json.has("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(json.getAsJsonObject("requestOrganization")));
        }
        return res;
    }

    protected Encounter parseEncounter(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Encounter res = new Encounter();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Encounter.EncounterState.NULL, new Encounter.EncounterStateEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("statusHistory")) {
            array = json.getAsJsonArray("statusHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getStatusHistory().add(this.parseEncounterEncounterStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("class")) {
            res.setClass_Element(this.parseEnumeration(json.get("class").getAsString(), Encounter.EncounterClass.NULL, new Encounter.EncounterClassEnumFactory()));
        }
        if (json.has("_class")) {
            this.parseElementProperties(json.getAsJsonObject("_class"), res.getClass_Element());
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(json.getAsJsonObject("priority")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("episodeOfCare")) {
            array = json.getAsJsonArray("episodeOfCare");
            for (i = 0; i < array.size(); ++i) {
                res.getEpisodeOfCare().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("incomingReferral")) {
            array = json.getAsJsonArray("incomingReferral");
            for (i = 0; i < array.size(); ++i) {
                res.getIncomingReferral().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseEncounterEncounterParticipantComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("appointment")) {
            res.setAppointment(this.parseReference(json.getAsJsonObject("appointment")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("length")) {
            res.setLength(this.parseDuration(json.getAsJsonObject("length")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("indication")) {
            array = json.getAsJsonArray("indication");
            for (i = 0; i < array.size(); ++i) {
                res.getIndication().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("hospitalization")) {
            res.setHospitalization(this.parseEncounterEncounterHospitalizationComponent(json.getAsJsonObject("hospitalization"), res));
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseEncounterEncounterLocationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("serviceProvider")) {
            res.setServiceProvider(this.parseReference(json.getAsJsonObject("serviceProvider")));
        }
        if (json.has("partOf")) {
            res.setPartOf(this.parseReference(json.getAsJsonObject("partOf")));
        }
        return res;
    }

    protected Encounter.EncounterStatusHistoryComponent parseEncounterEncounterStatusHistoryComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        Encounter.EncounterStatusHistoryComponent res = new Encounter.EncounterStatusHistoryComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Encounter.EncounterState.NULL, new Encounter.EncounterStateEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("individual")) {
            res.setIndividual(this.parseReference(json.getAsJsonObject("individual")));
        }
        return res;
    }

    protected Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("preAdmissionIdentifier")) {
            res.setPreAdmissionIdentifier(this.parseIdentifier(json.getAsJsonObject("preAdmissionIdentifier")));
        }
        if (json.has("origin")) {
            res.setOrigin(this.parseReference(json.getAsJsonObject("origin")));
        }
        if (json.has("admitSource")) {
            res.setAdmitSource(this.parseCodeableConcept(json.getAsJsonObject("admitSource")));
        }
        if (json.has("admittingDiagnosis")) {
            array = json.getAsJsonArray("admittingDiagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getAdmittingDiagnosis().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reAdmission")) {
            res.setReAdmission(this.parseCodeableConcept(json.getAsJsonObject("reAdmission")));
        }
        if (json.has("dietPreference")) {
            array = json.getAsJsonArray("dietPreference");
            for (i = 0; i < array.size(); ++i) {
                res.getDietPreference().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialCourtesy")) {
            array = json.getAsJsonArray("specialCourtesy");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialCourtesy().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialArrangement")) {
            array = json.getAsJsonArray("specialArrangement");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialArrangement().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("destination")) {
            res.setDestination(this.parseReference(json.getAsJsonObject("destination")));
        }
        if (json.has("dischargeDisposition")) {
            res.setDischargeDisposition(this.parseCodeableConcept(json.getAsJsonObject("dischargeDisposition")));
        }
        if (json.has("dischargeDiagnosis")) {
            array = json.getAsJsonArray("dischargeDiagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDischargeDiagnosis().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected EnrollmentRequest parseEnrollmentRequest(JsonObject json) throws IOException, FHIRFormatError {
        EnrollmentRequest res = new EnrollmentRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(json.getAsJsonObject("coverage")));
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCoding(json.getAsJsonObject("relationship")));
        }
        return res;
    }

    protected EnrollmentResponse parseEnrollmentResponse(JsonObject json) throws IOException, FHIRFormatError {
        EnrollmentResponse res = new EnrollmentResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(json.getAsJsonObject("requestProvider")));
        }
        if (json.has("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(json.getAsJsonObject("requestOrganization")));
        }
        return res;
    }

    protected EpisodeOfCare parseEpisodeOfCare(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        EpisodeOfCare res = new EpisodeOfCare();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("statusHistory")) {
            array = json.getAsJsonArray("statusHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getStatusHistory().add(this.parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("condition")) {
            array = json.getAsJsonArray("condition");
            for (i = 0; i < array.size(); ++i) {
                res.getCondition().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("referralRequest")) {
            array = json.getAsJsonArray("referralRequest");
            for (i = 0; i < array.size(); ++i) {
                res.getReferralRequest().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("careManager")) {
            res.setCareManager(this.parseReference(json.getAsJsonObject("careManager")));
        }
        if (json.has("careTeam")) {
            array = json.getAsJsonArray("careTeam");
            for (i = 0; i < array.size(); ++i) {
                res.getCareTeam().add(this.parseEpisodeOfCareEpisodeOfCareCareTeamComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(JsonObject json, EpisodeOfCare owner) throws IOException, FHIRFormatError {
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected EpisodeOfCare.EpisodeOfCareCareTeamComponent parseEpisodeOfCareEpisodeOfCareCareTeamComponent(JsonObject json, EpisodeOfCare owner) throws IOException, FHIRFormatError {
        EpisodeOfCare.EpisodeOfCareCareTeamComponent res = new EpisodeOfCare.EpisodeOfCareCareTeamComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            JsonArray array = json.getAsJsonArray("role");
            for (int i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("member")) {
            res.setMember(this.parseReference(json.getAsJsonObject("member")));
        }
        return res;
    }

    protected ExplanationOfBenefit parseExplanationOfBenefit(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit res = new ExplanationOfBenefit();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(json.getAsJsonObject("requestProvider")));
        }
        if (json.has("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(json.getAsJsonObject("requestOrganization")));
        }
        return res;
    }

    protected FamilyMemberHistory parseFamilyMemberHistory(JsonObject json) throws IOException, FHIRFormatError {
        Type deceased;
        Type age;
        Type born;
        FamilyMemberHistory res = new FamilyMemberHistory();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(json.getAsJsonObject("relationship")));
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if ((born = this.parseType("born", json)) != null) {
            res.setBorn(born);
        }
        if ((age = this.parseType("age", json)) != null) {
            res.setAge(age);
        }
        if ((deceased = this.parseType("deceased", json)) != null) {
            res.setDeceased(deceased);
        }
        if (json.has("note")) {
            res.setNote(this.parseAnnotation(json.getAsJsonObject("note")));
        }
        if (json.has("condition")) {
            JsonArray array = json.getAsJsonArray("condition");
            for (int i = 0; i < array.size(); ++i) {
                res.getCondition().add(this.parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(JsonObject json, FamilyMemberHistory owner) throws IOException, FHIRFormatError {
        Type onset;
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if ((onset = this.parseType("onset", json)) != null) {
            res.setOnset(onset);
        }
        if (json.has("note")) {
            res.setNote(this.parseAnnotation(json.getAsJsonObject("note")));
        }
        return res;
    }

    protected Flag parseFlag(JsonObject json) throws IOException, FHIRFormatError {
        Flag res = new Flag();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        return res;
    }

    protected Goal parseGoal(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type target;
        Type start;
        Goal res = new Goal();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array2 = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if ((start = this.parseType("start", json)) != null) {
            res.setStart(start);
        }
        if ((target = this.parseType("target", json)) != null) {
            res.setTarget(target);
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Goal.GoalStatus.NULL, new Goal.GoalStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("statusDate")) {
            res.setStatusDateElement(this.parseDate(json.get("statusDate").getAsString()));
        }
        if (json.has("_statusDate")) {
            this.parseElementProperties(json.getAsJsonObject("_statusDate"), res.getStatusDateElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(json.getAsJsonObject("statusReason")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(json.getAsJsonObject("priority")));
        }
        if (json.has("addresses")) {
            array = json.getAsJsonArray("addresses");
            for (i = 0; i < array.size(); ++i) {
                res.getAddresses().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("outcome")) {
            array = json.getAsJsonArray("outcome");
            for (i = 0; i < array.size(); ++i) {
                res.getOutcome().add(this.parseGoalGoalOutcomeComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Goal.GoalOutcomeComponent parseGoalGoalOutcomeComponent(JsonObject json, Goal owner) throws IOException, FHIRFormatError {
        Goal.GoalOutcomeComponent res = new Goal.GoalOutcomeComponent();
        this.parseBackboneProperties(json, res);
        Type result = this.parseType("result", json);
        if (result != null) {
            res.setResult(result);
        }
        return res;
    }

    protected Group parseGroup(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Group res = new Group();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("actual")) {
            res.setActualElement(this.parseBoolean(json.get("actual").getAsBoolean()));
        }
        if (json.has("_actual")) {
            this.parseElementProperties(json.getAsJsonObject("_actual"), res.getActualElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("quantity")) {
            res.setQuantityElement(this.parseUnsignedInt(json.get("quantity").getAsString()));
        }
        if (json.has("_quantity")) {
            this.parseElementProperties(json.getAsJsonObject("_quantity"), res.getQuantityElement());
        }
        if (json.has("characteristic")) {
            array = json.getAsJsonArray("characteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getCharacteristic().add(this.parseGroupGroupCharacteristicComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("member")) {
            array = json.getAsJsonArray("member");
            for (i = 0; i < array.size(); ++i) {
                res.getMember().add(this.parseGroupGroupMemberComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(JsonObject json, Group owner) throws IOException, FHIRFormatError {
        Type value;
        Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("exclude")) {
            res.setExcludeElement(this.parseBoolean(json.get("exclude").getAsBoolean()));
        }
        if (json.has("_exclude")) {
            this.parseElementProperties(json.getAsJsonObject("_exclude"), res.getExcludeElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected Group.GroupMemberComponent parseGroupGroupMemberComponent(JsonObject json, Group owner) throws IOException, FHIRFormatError {
        Group.GroupMemberComponent res = new Group.GroupMemberComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("entity")) {
            res.setEntity(this.parseReference(json.getAsJsonObject("entity")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("inactive")) {
            res.setInactiveElement(this.parseBoolean(json.get("inactive").getAsBoolean()));
        }
        if (json.has("_inactive")) {
            this.parseElementProperties(json.getAsJsonObject("_inactive"), res.getInactiveElement());
        }
        return res;
    }

    protected HealthcareService parseHealthcareService(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        HealthcareService res = new HealthcareService();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("providedBy")) {
            res.setProvidedBy(this.parseReference(json.getAsJsonObject("providedBy")));
        }
        if (json.has("serviceCategory")) {
            res.setServiceCategory(this.parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
        }
        if (json.has("serviceType")) {
            array = json.getAsJsonArray("serviceType");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceType().add(this.parseHealthcareServiceServiceTypeComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("serviceName")) {
            res.setServiceNameElement(this.parseString(json.get("serviceName").getAsString()));
        }
        if (json.has("_serviceName")) {
            this.parseElementProperties(json.getAsJsonObject("_serviceName"), res.getServiceNameElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("extraDetails")) {
            res.setExtraDetailsElement(this.parseString(json.get("extraDetails").getAsString()));
        }
        if (json.has("_extraDetails")) {
            this.parseElementProperties(json.getAsJsonObject("_extraDetails"), res.getExtraDetailsElement());
        }
        if (json.has("photo")) {
            res.setPhoto(this.parseAttachment(json.getAsJsonObject("photo")));
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("coverageArea")) {
            array = json.getAsJsonArray("coverageArea");
            for (i = 0; i < array.size(); ++i) {
                res.getCoverageArea().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("serviceProvisionCode")) {
            array = json.getAsJsonArray("serviceProvisionCode");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceProvisionCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("eligibility")) {
            res.setEligibility(this.parseCodeableConcept(json.getAsJsonObject("eligibility")));
        }
        if (json.has("eligibilityNote")) {
            res.setEligibilityNoteElement(this.parseString(json.get("eligibilityNote").getAsString()));
        }
        if (json.has("_eligibilityNote")) {
            this.parseElementProperties(json.getAsJsonObject("_eligibilityNote"), res.getEligibilityNoteElement());
        }
        if (json.has("programName")) {
            array = json.getAsJsonArray("programName");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramName().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_programName")) {
            array = json.getAsJsonArray("_programName");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProgramName().size()) {
                    res.getProgramName().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getProgramName().get(i));
            }
        }
        if (json.has("characteristic")) {
            array = json.getAsJsonArray("characteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getCharacteristic().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("referralMethod")) {
            array = json.getAsJsonArray("referralMethod");
            for (i = 0; i < array.size(); ++i) {
                res.getReferralMethod().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("publicKey")) {
            res.setPublicKeyElement(this.parseString(json.get("publicKey").getAsString()));
        }
        if (json.has("_publicKey")) {
            this.parseElementProperties(json.getAsJsonObject("_publicKey"), res.getPublicKeyElement());
        }
        if (json.has("appointmentRequired")) {
            res.setAppointmentRequiredElement(this.parseBoolean(json.get("appointmentRequired").getAsBoolean()));
        }
        if (json.has("_appointmentRequired")) {
            this.parseElementProperties(json.getAsJsonObject("_appointmentRequired"), res.getAppointmentRequiredElement());
        }
        if (json.has("availableTime")) {
            array = json.getAsJsonArray("availableTime");
            for (i = 0; i < array.size(); ++i) {
                res.getAvailableTime().add(this.parseHealthcareServiceHealthcareServiceAvailableTimeComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("notAvailable")) {
            array = json.getAsJsonArray("notAvailable");
            for (i = 0; i < array.size(); ++i) {
                res.getNotAvailable().add(this.parseHealthcareServiceHealthcareServiceNotAvailableComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("availabilityExceptions")) {
            res.setAvailabilityExceptionsElement(this.parseString(json.get("availabilityExceptions").getAsString()));
        }
        if (json.has("_availabilityExceptions")) {
            this.parseElementProperties(json.getAsJsonObject("_availabilityExceptions"), res.getAvailabilityExceptionsElement());
        }
        return res;
    }

    protected HealthcareService.ServiceTypeComponent parseHealthcareServiceServiceTypeComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
        HealthcareService.ServiceTypeComponent res = new HealthcareService.ServiceTypeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("specialty")) {
            JsonArray array = json.getAsJsonArray("specialty");
            for (int i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceHealthcareServiceAvailableTimeComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("daysOfWeek")) {
            array = json.getAsJsonArray("daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                res.getDaysOfWeek().add(this.parseEnumeration(array.get(i).getAsString(), HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
            }
        }
        if (json.has("_daysOfWeek")) {
            array = json.getAsJsonArray("_daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDaysOfWeek().size()) {
                    res.getDaysOfWeek().add(this.parseEnumeration(null, HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
            }
        }
        if (json.has("allDay")) {
            res.setAllDayElement(this.parseBoolean(json.get("allDay").getAsBoolean()));
        }
        if (json.has("_allDay")) {
            this.parseElementProperties(json.getAsJsonObject("_allDay"), res.getAllDayElement());
        }
        if (json.has("availableStartTime")) {
            res.setAvailableStartTimeElement(this.parseTime(json.get("availableStartTime").getAsString()));
        }
        if (json.has("_availableStartTime")) {
            this.parseElementProperties(json.getAsJsonObject("_availableStartTime"), res.getAvailableStartTimeElement());
        }
        if (json.has("availableEndTime")) {
            res.setAvailableEndTimeElement(this.parseTime(json.get("availableEndTime").getAsString()));
        }
        if (json.has("_availableEndTime")) {
            this.parseElementProperties(json.getAsJsonObject("_availableEndTime"), res.getAvailableEndTimeElement());
        }
        return res;
    }

    protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceHealthcareServiceNotAvailableComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("during")) {
            res.setDuring(this.parsePeriod(json.getAsJsonObject("during")));
        }
        return res;
    }

    protected ImagingObjectSelection parseImagingObjectSelection(JsonObject json) throws IOException, FHIRFormatError {
        ImagingObjectSelection res = new ImagingObjectSelection();
        this.parseDomainResourceProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("title")) {
            res.setTitle(this.parseCodeableConcept(json.getAsJsonObject("title")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("authoringTime")) {
            res.setAuthoringTimeElement(this.parseDateTime(json.get("authoringTime").getAsString()));
        }
        if (json.has("_authoringTime")) {
            this.parseElementProperties(json.getAsJsonObject("_authoringTime"), res.getAuthoringTimeElement());
        }
        if (json.has("study")) {
            JsonArray array = json.getAsJsonArray("study");
            for (int i = 0; i < array.size(); ++i) {
                res.getStudy().add(this.parseImagingObjectSelectionStudyComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ImagingObjectSelection.StudyComponent parseImagingObjectSelectionStudyComponent(JsonObject json, ImagingObjectSelection owner) throws IOException, FHIRFormatError {
        ImagingObjectSelection.StudyComponent res = new ImagingObjectSelection.StudyComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("imagingStudy")) {
            res.setImagingStudy(this.parseReference(json.getAsJsonObject("imagingStudy")));
        }
        if (json.has("series")) {
            JsonArray array = json.getAsJsonArray("series");
            for (int i = 0; i < array.size(); ++i) {
                res.getSeries().add(this.parseImagingObjectSelectionSeriesComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ImagingObjectSelection.SeriesComponent parseImagingObjectSelectionSeriesComponent(JsonObject json, ImagingObjectSelection owner) throws IOException, FHIRFormatError {
        ImagingObjectSelection.SeriesComponent res = new ImagingObjectSelection.SeriesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("instance")) {
            JsonArray array = json.getAsJsonArray("instance");
            for (int i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseImagingObjectSelectionInstanceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ImagingObjectSelection.InstanceComponent parseImagingObjectSelectionInstanceComponent(JsonObject json, ImagingObjectSelection owner) throws IOException, FHIRFormatError {
        ImagingObjectSelection.InstanceComponent res = new ImagingObjectSelection.InstanceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sopClass")) {
            res.setSopClassElement(this.parseOid(json.get("sopClass").getAsString()));
        }
        if (json.has("_sopClass")) {
            this.parseElementProperties(json.getAsJsonObject("_sopClass"), res.getSopClassElement());
        }
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("frames")) {
            JsonArray array = json.getAsJsonArray("frames");
            for (int i = 0; i < array.size(); ++i) {
                res.getFrames().add(this.parseImagingObjectSelectionFramesComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ImagingObjectSelection.FramesComponent parseImagingObjectSelectionFramesComponent(JsonObject json, ImagingObjectSelection owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImagingObjectSelection.FramesComponent res = new ImagingObjectSelection.FramesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("frameNumbers")) {
            array = json.getAsJsonArray("frameNumbers");
            for (i = 0; i < array.size(); ++i) {
                res.getFrameNumbers().add(this.parseUnsignedInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_frameNumbers")) {
            array = json.getAsJsonArray("_frameNumbers");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getFrameNumbers().size()) {
                    res.getFrameNumbers().add(this.parseUnsignedInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getFrameNumbers().get(i));
            }
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        return res;
    }

    protected ImagingStudy parseImagingStudy(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImagingStudy res = new ImagingStudy();
        this.parseDomainResourceProperties(json, res);
        if (json.has("started")) {
            res.setStartedElement(this.parseDateTime(json.get("started").getAsString()));
        }
        if (json.has("_started")) {
            this.parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("accession")) {
            res.setAccession(this.parseIdentifier(json.getAsJsonObject("accession")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("order")) {
            array = json.getAsJsonArray("order");
            for (i = 0; i < array.size(); ++i) {
                res.getOrder().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("modalityList")) {
            array = json.getAsJsonArray("modalityList");
            for (i = 0; i < array.size(); ++i) {
                res.getModalityList().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("referrer")) {
            res.setReferrer(this.parseReference(json.getAsJsonObject("referrer")));
        }
        if (json.has("availability")) {
            res.setAvailabilityElement(this.parseEnumeration(json.get("availability").getAsString(), ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
        }
        if (json.has("_availability")) {
            this.parseElementProperties(json.getAsJsonObject("_availability"), res.getAvailabilityElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("numberOfSeries")) {
            res.setNumberOfSeriesElement(this.parseUnsignedInt(json.get("numberOfSeries").getAsString()));
        }
        if (json.has("_numberOfSeries")) {
            this.parseElementProperties(json.getAsJsonObject("_numberOfSeries"), res.getNumberOfSeriesElement());
        }
        if (json.has("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(json.get("numberOfInstances").getAsString()));
        }
        if (json.has("_numberOfInstances")) {
            this.parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
        }
        if (json.has("procedure")) {
            array = json.getAsJsonArray("procedure");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedure().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("interpreter")) {
            res.setInterpreter(this.parseReference(json.getAsJsonObject("interpreter")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("series")) {
            array = json.getAsJsonArray("series");
            for (i = 0; i < array.size(); ++i) {
                res.getSeries().add(this.parseImagingStudyImagingStudySeriesComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("number")) {
            res.setNumberElement(this.parseUnsignedInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
        }
        if (json.has("modality")) {
            res.setModality(this.parseCoding(json.getAsJsonObject("modality")));
        }
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(json.get("numberOfInstances").getAsString()));
        }
        if (json.has("_numberOfInstances")) {
            this.parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
        }
        if (json.has("availability")) {
            res.setAvailabilityElement(this.parseEnumeration(json.get("availability").getAsString(), ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
        }
        if (json.has("_availability")) {
            this.parseElementProperties(json.getAsJsonObject("_availability"), res.getAvailabilityElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCoding(json.getAsJsonObject("bodySite")));
        }
        if (json.has("laterality")) {
            res.setLaterality(this.parseCoding(json.getAsJsonObject("laterality")));
        }
        if (json.has("started")) {
            res.setStartedElement(this.parseDateTime(json.get("started").getAsString()));
        }
        if (json.has("_started")) {
            this.parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
        }
        if (json.has("instance")) {
            JsonArray array = json.getAsJsonArray("instance");
            for (int i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseImagingStudyImagingStudySeriesInstanceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("number")) {
            res.setNumberElement(this.parseUnsignedInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
        }
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("sopClass")) {
            res.setSopClassElement(this.parseOid(json.get("sopClass").getAsString()));
        }
        if (json.has("_sopClass")) {
            this.parseElementProperties(json.getAsJsonObject("_sopClass"), res.getSopClassElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseString(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("content")) {
            JsonArray array = json.getAsJsonArray("content");
            for (int i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Immunization parseImmunization(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Immunization res = new Immunization();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseCode(json.get("status").getAsString()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("vaccineCode")) {
            res.setVaccineCode(this.parseCodeableConcept(json.getAsJsonObject("vaccineCode")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("wasNotGiven")) {
            res.setWasNotGivenElement(this.parseBoolean(json.get("wasNotGiven").getAsBoolean()));
        }
        if (json.has("_wasNotGiven")) {
            this.parseElementProperties(json.getAsJsonObject("_wasNotGiven"), res.getWasNotGivenElement());
        }
        if (json.has("reported")) {
            res.setReportedElement(this.parseBoolean(json.get("reported").getAsBoolean()));
        }
        if (json.has("_reported")) {
            this.parseElementProperties(json.getAsJsonObject("_reported"), res.getReportedElement());
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
        if (json.has("requester")) {
            res.setRequester(this.parseReference(json.getAsJsonObject("requester")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("manufacturer")) {
            res.setManufacturer(this.parseReference(json.getAsJsonObject("manufacturer")));
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("lotNumber")) {
            res.setLotNumberElement(this.parseString(json.get("lotNumber").getAsString()));
        }
        if (json.has("_lotNumber")) {
            this.parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
        }
        if (json.has("expirationDate")) {
            res.setExpirationDateElement(this.parseDate(json.get("expirationDate").getAsString()));
        }
        if (json.has("_expirationDate")) {
            this.parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
        }
        if (json.has("site")) {
            res.setSite(this.parseCodeableConcept(json.getAsJsonObject("site")));
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(json.getAsJsonObject("route")));
        }
        if (json.has("doseQuantity")) {
            res.setDoseQuantity(this.parseSimpleQuantity(json.getAsJsonObject("doseQuantity")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("explanation")) {
            res.setExplanation(this.parseImmunizationImmunizationExplanationComponent(json.getAsJsonObject("explanation"), res));
        }
        if (json.has("reaction")) {
            array = json.getAsJsonArray("reaction");
            for (i = 0; i < array.size(); ++i) {
                res.getReaction().add(this.parseImmunizationImmunizationReactionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("vaccinationProtocol")) {
            array = json.getAsJsonArray("vaccinationProtocol");
            for (i = 0; i < array.size(); ++i) {
                res.getVaccinationProtocol().add(this.parseImmunizationImmunizationVaccinationProtocolComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Immunization.ImmunizationExplanationComponent parseImmunizationImmunizationExplanationComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Immunization.ImmunizationExplanationComponent res = new Immunization.ImmunizationExplanationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonNotGiven")) {
            array = json.getAsJsonArray("reasonNotGiven");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonNotGiven().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
        Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("detail")) {
            res.setDetail(this.parseReference(json.getAsJsonObject("detail")));
        }
        if (json.has("reported")) {
            res.setReportedElement(this.parseBoolean(json.get("reported").getAsBoolean()));
        }
        if (json.has("_reported")) {
            this.parseElementProperties(json.getAsJsonObject("_reported"), res.getReportedElement());
        }
        return res;
    }

    protected Immunization.ImmunizationVaccinationProtocolComponent parseImmunizationImmunizationVaccinationProtocolComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
        Immunization.ImmunizationVaccinationProtocolComponent res = new Immunization.ImmunizationVaccinationProtocolComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("doseSequence")) {
            res.setDoseSequenceElement(this.parsePositiveInt(json.get("doseSequence").getAsString()));
        }
        if (json.has("_doseSequence")) {
            this.parseElementProperties(json.getAsJsonObject("_doseSequence"), res.getDoseSequenceElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("authority")) {
            res.setAuthority(this.parseReference(json.getAsJsonObject("authority")));
        }
        if (json.has("series")) {
            res.setSeriesElement(this.parseString(json.get("series").getAsString()));
        }
        if (json.has("_series")) {
            this.parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
        }
        if (json.has("seriesDoses")) {
            res.setSeriesDosesElement(this.parsePositiveInt(json.get("seriesDoses").getAsString()));
        }
        if (json.has("_seriesDoses")) {
            this.parseElementProperties(json.getAsJsonObject("_seriesDoses"), res.getSeriesDosesElement());
        }
        if (json.has("targetDisease")) {
            JsonArray array = json.getAsJsonArray("targetDisease");
            for (int i = 0; i < array.size(); ++i) {
                res.getTargetDisease().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("doseStatus")) {
            res.setDoseStatus(this.parseCodeableConcept(json.getAsJsonObject("doseStatus")));
        }
        if (json.has("doseStatusReason")) {
            res.setDoseStatusReason(this.parseCodeableConcept(json.getAsJsonObject("doseStatusReason")));
        }
        return res;
    }

    protected ImmunizationRecommendation parseImmunizationRecommendation(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImmunizationRecommendation res = new ImmunizationRecommendation();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("recommendation")) {
            array = json.getAsJsonArray("recommendation");
            for (i = 0; i < array.size(); ++i) {
                res.getRecommendation().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("vaccineCode")) {
            res.setVaccineCode(this.parseCodeableConcept(json.getAsJsonObject("vaccineCode")));
        }
        if (json.has("doseNumber")) {
            res.setDoseNumberElement(this.parsePositiveInt(json.get("doseNumber").getAsString()));
        }
        if (json.has("_doseNumber")) {
            this.parseElementProperties(json.getAsJsonObject("_doseNumber"), res.getDoseNumberElement());
        }
        if (json.has("forecastStatus")) {
            res.setForecastStatus(this.parseCodeableConcept(json.getAsJsonObject("forecastStatus")));
        }
        if (json.has("dateCriterion")) {
            array = json.getAsJsonArray("dateCriterion");
            for (i = 0; i < array.size(); ++i) {
                res.getDateCriterion().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("protocol")) {
            res.setProtocol(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(json.getAsJsonObject("protocol"), owner));
        }
        if (json.has("supportingImmunization")) {
            array = json.getAsJsonArray("supportingImmunization");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingImmunization().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingPatientInformation")) {
            array = json.getAsJsonArray("supportingPatientInformation");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingPatientInformation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDateTime(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("doseSequence")) {
            res.setDoseSequenceElement(this.parseInteger(json.get("doseSequence").getAsLong()));
        }
        if (json.has("_doseSequence")) {
            this.parseElementProperties(json.getAsJsonObject("_doseSequence"), res.getDoseSequenceElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("authority")) {
            res.setAuthority(this.parseReference(json.getAsJsonObject("authority")));
        }
        if (json.has("series")) {
            res.setSeriesElement(this.parseString(json.get("series").getAsString()));
        }
        if (json.has("_series")) {
            this.parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
        }
        return res;
    }

    protected ImplementationGuide parseImplementationGuide(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImplementationGuide res = new ImplementationGuide();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseImplementationGuideImplementationGuideContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("fhirVersion")) {
            res.setFhirVersionElement(this.parseId(json.get("fhirVersion").getAsString()));
        }
        if (json.has("_fhirVersion")) {
            this.parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
        }
        if (json.has("dependency")) {
            array = json.getAsJsonArray("dependency");
            for (i = 0; i < array.size(); ++i) {
                res.getDependency().add(this.parseImplementationGuideImplementationGuideDependencyComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("package")) {
            array = json.getAsJsonArray("package");
            for (i = 0; i < array.size(); ++i) {
                res.getPackage().add(this.parseImplementationGuideImplementationGuidePackageComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("global")) {
            array = json.getAsJsonArray("global");
            for (i = 0; i < array.size(); ++i) {
                res.getGlobal().add(this.parseImplementationGuideImplementationGuideGlobalComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("binary")) {
            array = json.getAsJsonArray("binary");
            for (i = 0; i < array.size(); ++i) {
                res.getBinary().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_binary")) {
            array = json.getAsJsonArray("_binary");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getBinary().size()) {
                    res.getBinary().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getBinary().get(i));
            }
        }
        if (json.has("page")) {
            res.setPage(this.parseImplementationGuideImplementationGuidePageComponent(json.getAsJsonObject("page"), res));
        }
        return res;
    }

    protected ImplementationGuide.ImplementationGuideContactComponent parseImplementationGuideImplementationGuideContactComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideContactComponent res = new ImplementationGuide.ImplementationGuideContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ImplementationGuide.ImplementationGuideDependencyComponent parseImplementationGuideImplementationGuideDependencyComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDependencyComponent res = new ImplementationGuide.ImplementationGuideDependencyComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ImplementationGuide.GuideDependencyType.NULL, new ImplementationGuide.GuideDependencyTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
        }
        return res;
    }

    protected ImplementationGuide.ImplementationGuidePackageComponent parseImplementationGuideImplementationGuidePackageComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePackageComponent res = new ImplementationGuide.ImplementationGuidePackageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("resource")) {
            JsonArray array = json.getAsJsonArray("resource");
            for (int i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseImplementationGuideImplementationGuidePackageResourceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ImplementationGuide.ImplementationGuidePackageResourceComponent parseImplementationGuideImplementationGuidePackageResourceComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        Type source;
        ImplementationGuide.ImplementationGuidePackageResourceComponent res = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseEnumeration(json.get("purpose").getAsString(), ImplementationGuide.GuideResourcePurpose.NULL, new ImplementationGuide.GuideResourcePurposeEnumFactory()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("acronym")) {
            res.setAcronymElement(this.parseString(json.get("acronym").getAsString()));
        }
        if (json.has("_acronym")) {
            this.parseElementProperties(json.getAsJsonObject("_acronym"), res.getAcronymElement());
        }
        if ((source = this.parseType("source", json)) != null) {
            res.setSource(source);
        }
        if (json.has("exampleFor")) {
            res.setExampleFor(this.parseReference(json.getAsJsonObject("exampleFor")));
        }
        return res;
    }

    protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideImplementationGuideGlobalComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        return res;
    }

    protected ImplementationGuide.ImplementationGuidePageComponent parseImplementationGuideImplementationGuidePageComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImplementationGuide.ImplementationGuidePageComponent res = new ImplementationGuide.ImplementationGuidePageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("source")) {
            res.setSourceElement(this.parseUri(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), ImplementationGuide.GuidePageKind.NULL, new ImplementationGuide.GuidePageKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_type")) {
            array = json.getAsJsonArray("_type");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getType().size()) {
                    res.getType().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getType().get(i));
            }
        }
        if (json.has("package")) {
            array = json.getAsJsonArray("package");
            for (i = 0; i < array.size(); ++i) {
                res.getPackage().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_package")) {
            array = json.getAsJsonArray("_package");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPackage().size()) {
                    res.getPackage().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPackage().get(i));
            }
        }
        if (json.has("format")) {
            res.setFormatElement(this.parseCode(json.get("format").getAsString()));
        }
        if (json.has("_format")) {
            this.parseElementProperties(json.getAsJsonObject("_format"), res.getFormatElement());
        }
        if (json.has("page")) {
            array = json.getAsJsonArray("page");
            for (i = 0; i < array.size(); ++i) {
                res.getPage().add(this.parseImplementationGuideImplementationGuidePageComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected List_ parseList_(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        List_ res = new List_();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), List_.ListStatus.NULL, new List_.ListStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(json.getAsJsonObject("orderedBy")));
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), List_.ListMode.NULL, new List_.ListModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("note")) {
            res.setNoteElement(this.parseString(json.get("note").getAsString()));
        }
        if (json.has("_note")) {
            this.parseElementProperties(json.getAsJsonObject("_note"), res.getNoteElement());
        }
        if (json.has("entry")) {
            array = json.getAsJsonArray("entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseList_ListEntryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(json.getAsJsonObject("emptyReason")));
        }
        return res;
    }

    protected List_.ListEntryComponent parseList_ListEntryComponent(JsonObject json, List_ owner) throws IOException, FHIRFormatError {
        List_.ListEntryComponent res = new List_.ListEntryComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("flag")) {
            res.setFlag(this.parseCodeableConcept(json.getAsJsonObject("flag")));
        }
        if (json.has("deleted")) {
            res.setDeletedElement(this.parseBoolean(json.get("deleted").getAsBoolean()));
        }
        if (json.has("_deleted")) {
            this.parseElementProperties(json.getAsJsonObject("_deleted"), res.getDeletedElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("item")) {
            res.setItem(this.parseReference(json.getAsJsonObject("item")));
        }
        return res;
    }

    protected Location parseLocation(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Location res = new Location();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            res.setAddress(this.parseAddress(json.getAsJsonObject("address")));
        }
        if (json.has("physicalType")) {
            res.setPhysicalType(this.parseCodeableConcept(json.getAsJsonObject("physicalType")));
        }
        if (json.has("position")) {
            res.setPosition(this.parseLocationLocationPositionComponent(json.getAsJsonObject("position"), res));
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("partOf")) {
            res.setPartOf(this.parseReference(json.getAsJsonObject("partOf")));
        }
        return res;
    }

    protected Location.LocationPositionComponent parseLocationLocationPositionComponent(JsonObject json, Location owner) throws IOException, FHIRFormatError {
        Location.LocationPositionComponent res = new Location.LocationPositionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("longitude")) {
            res.setLongitudeElement(this.parseDecimal(json.get("longitude").getAsBigDecimal()));
        }
        if (json.has("_longitude")) {
            this.parseElementProperties(json.getAsJsonObject("_longitude"), res.getLongitudeElement());
        }
        if (json.has("latitude")) {
            res.setLatitudeElement(this.parseDecimal(json.get("latitude").getAsBigDecimal()));
        }
        if (json.has("_latitude")) {
            this.parseElementProperties(json.getAsJsonObject("_latitude"), res.getLatitudeElement());
        }
        if (json.has("altitude")) {
            res.setAltitudeElement(this.parseDecimal(json.get("altitude").getAsBigDecimal()));
        }
        if (json.has("_altitude")) {
            this.parseElementProperties(json.getAsJsonObject("_altitude"), res.getAltitudeElement());
        }
        return res;
    }

    protected Media parseMedia(JsonObject json) throws IOException, FHIRFormatError {
        Media res = new Media();
        this.parseDomainResourceProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Media.DigitalMediaType.NULL, new Media.DigitalMediaTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("subtype")) {
            res.setSubtype(this.parseCodeableConcept(json.getAsJsonObject("subtype")));
        }
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("operator")) {
            res.setOperator(this.parseReference(json.getAsJsonObject("operator")));
        }
        if (json.has("view")) {
            res.setView(this.parseCodeableConcept(json.getAsJsonObject("view")));
        }
        if (json.has("deviceName")) {
            res.setDeviceNameElement(this.parseString(json.get("deviceName").getAsString()));
        }
        if (json.has("_deviceName")) {
            this.parseElementProperties(json.getAsJsonObject("_deviceName"), res.getDeviceNameElement());
        }
        if (json.has("height")) {
            res.setHeightElement(this.parsePositiveInt(json.get("height").getAsString()));
        }
        if (json.has("_height")) {
            this.parseElementProperties(json.getAsJsonObject("_height"), res.getHeightElement());
        }
        if (json.has("width")) {
            res.setWidthElement(this.parsePositiveInt(json.get("width").getAsString()));
        }
        if (json.has("_width")) {
            this.parseElementProperties(json.getAsJsonObject("_width"), res.getWidthElement());
        }
        if (json.has("frames")) {
            res.setFramesElement(this.parsePositiveInt(json.get("frames").getAsString()));
        }
        if (json.has("_frames")) {
            this.parseElementProperties(json.getAsJsonObject("_frames"), res.getFramesElement());
        }
        if (json.has("duration")) {
            res.setDurationElement(this.parseUnsignedInt(json.get("duration").getAsString()));
        }
        if (json.has("_duration")) {
            this.parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
        }
        if (json.has("content")) {
            res.setContent(this.parseAttachment(json.getAsJsonObject("content")));
        }
        return res;
    }

    protected Medication parseMedication(JsonObject json) throws IOException, FHIRFormatError {
        Medication res = new Medication();
        this.parseDomainResourceProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("isBrand")) {
            res.setIsBrandElement(this.parseBoolean(json.get("isBrand").getAsBoolean()));
        }
        if (json.has("_isBrand")) {
            this.parseElementProperties(json.getAsJsonObject("_isBrand"), res.getIsBrandElement());
        }
        if (json.has("manufacturer")) {
            res.setManufacturer(this.parseReference(json.getAsJsonObject("manufacturer")));
        }
        if (json.has("product")) {
            res.setProduct(this.parseMedicationMedicationProductComponent(json.getAsJsonObject("product"), res));
        }
        if (json.has("package")) {
            res.setPackage(this.parseMedicationMedicationPackageComponent(json.getAsJsonObject("package"), res));
        }
        return res;
    }

    protected Medication.MedicationProductComponent parseMedicationMedicationProductComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Medication.MedicationProductComponent res = new Medication.MedicationProductComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("form")) {
            res.setForm(this.parseCodeableConcept(json.getAsJsonObject("form")));
        }
        if (json.has("ingredient")) {
            array = json.getAsJsonArray("ingredient");
            for (i = 0; i < array.size(); ++i) {
                res.getIngredient().add(this.parseMedicationMedicationProductIngredientComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("batch")) {
            array = json.getAsJsonArray("batch");
            for (i = 0; i < array.size(); ++i) {
                res.getBatch().add(this.parseMedicationMedicationProductBatchComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Medication.MedicationProductIngredientComponent parseMedicationMedicationProductIngredientComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        Medication.MedicationProductIngredientComponent res = new Medication.MedicationProductIngredientComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("item")) {
            res.setItem(this.parseReference(json.getAsJsonObject("item")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseRatio(json.getAsJsonObject("amount")));
        }
        return res;
    }

    protected Medication.MedicationProductBatchComponent parseMedicationMedicationProductBatchComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        Medication.MedicationProductBatchComponent res = new Medication.MedicationProductBatchComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("lotNumber")) {
            res.setLotNumberElement(this.parseString(json.get("lotNumber").getAsString()));
        }
        if (json.has("_lotNumber")) {
            this.parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
        }
        if (json.has("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(json.get("expirationDate").getAsString()));
        }
        if (json.has("_expirationDate")) {
            this.parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
        }
        return res;
    }

    protected Medication.MedicationPackageComponent parseMedicationMedicationPackageComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        Medication.MedicationPackageComponent res = new Medication.MedicationPackageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("container")) {
            res.setContainer(this.parseCodeableConcept(json.getAsJsonObject("container")));
        }
        if (json.has("content")) {
            JsonArray array = json.getAsJsonArray("content");
            for (int i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseMedicationMedicationPackageContentComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Medication.MedicationPackageContentComponent parseMedicationMedicationPackageContentComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        Medication.MedicationPackageContentComponent res = new Medication.MedicationPackageContentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("item")) {
            res.setItem(this.parseReference(json.getAsJsonObject("item")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseSimpleQuantity(json.getAsJsonObject("amount")));
        }
        return res;
    }

    protected MedicationAdministration parseMedicationAdministration(JsonObject json) throws IOException, FHIRFormatError {
        Type medication;
        Type effectiveTime;
        int i;
        JsonArray array;
        MedicationAdministration res = new MedicationAdministration();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MedicationAdministration.MedicationAdministrationStatus.NULL, new MedicationAdministration.MedicationAdministrationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("practitioner")) {
            res.setPractitioner(this.parseReference(json.getAsJsonObject("practitioner")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("prescription")) {
            res.setPrescription(this.parseReference(json.getAsJsonObject("prescription")));
        }
        if (json.has("wasNotGiven")) {
            res.setWasNotGivenElement(this.parseBoolean(json.get("wasNotGiven").getAsBoolean()));
        }
        if (json.has("_wasNotGiven")) {
            this.parseElementProperties(json.getAsJsonObject("_wasNotGiven"), res.getWasNotGivenElement());
        }
        if (json.has("reasonNotGiven")) {
            array = json.getAsJsonArray("reasonNotGiven");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonNotGiven().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonGiven")) {
            array = json.getAsJsonArray("reasonGiven");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonGiven().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if ((effectiveTime = this.parseType("effectiveTime", json)) != null) {
            res.setEffectiveTime(effectiveTime);
        }
        if ((medication = this.parseType("medication", json)) != null) {
            res.setMedication(medication);
        }
        if (json.has("device")) {
            JsonArray array2 = json.getAsJsonArray("device");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getDevice().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            res.setNoteElement(this.parseString(json.get("note").getAsString()));
        }
        if (json.has("_note")) {
            this.parseElementProperties(json.getAsJsonObject("_note"), res.getNoteElement());
        }
        if (json.has("dosage")) {
            res.setDosage(this.parseMedicationAdministrationMedicationAdministrationDosageComponent(json.getAsJsonObject("dosage"), res));
        }
        return res;
    }

    protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(JsonObject json, MedicationAdministration owner) throws IOException, FHIRFormatError {
        Type rate;
        Type site;
        MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if ((site = this.parseType("site", json)) != null) {
            res.setSite(site);
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(json.getAsJsonObject("route")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
        return res;
    }

    protected MedicationDispense parseMedicationDispense(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type medication;
        MedicationDispense res = new MedicationDispense();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MedicationDispense.MedicationDispenseStatus.NULL, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("dispenser")) {
            res.setDispenser(this.parseReference(json.getAsJsonObject("dispenser")));
        }
        if (json.has("authorizingPrescription")) {
            JsonArray array = json.getAsJsonArray("authorizingPrescription");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getAuthorizingPrescription().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("daysSupply")) {
            res.setDaysSupply(this.parseSimpleQuantity(json.getAsJsonObject("daysSupply")));
        }
        if ((medication = this.parseType("medication", json)) != null) {
            res.setMedication(medication);
        }
        if (json.has("whenPrepared")) {
            res.setWhenPreparedElement(this.parseDateTime(json.get("whenPrepared").getAsString()));
        }
        if (json.has("_whenPrepared")) {
            this.parseElementProperties(json.getAsJsonObject("_whenPrepared"), res.getWhenPreparedElement());
        }
        if (json.has("whenHandedOver")) {
            res.setWhenHandedOverElement(this.parseDateTime(json.get("whenHandedOver").getAsString()));
        }
        if (json.has("_whenHandedOver")) {
            this.parseElementProperties(json.getAsJsonObject("_whenHandedOver"), res.getWhenHandedOverElement());
        }
        if (json.has("destination")) {
            res.setDestination(this.parseReference(json.getAsJsonObject("destination")));
        }
        if (json.has("receiver")) {
            JsonArray array = json.getAsJsonArray("receiver");
            for (i = 0; i < array.size(); ++i) {
                res.getReceiver().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            res.setNoteElement(this.parseString(json.get("note").getAsString()));
        }
        if (json.has("_note")) {
            this.parseElementProperties(json.getAsJsonObject("_note"), res.getNoteElement());
        }
        if (json.has("dosageInstruction")) {
            JsonArray array = json.getAsJsonArray("dosageInstruction");
            for (i = 0; i < array.size(); ++i) {
                res.getDosageInstruction().add(this.parseMedicationDispenseMedicationDispenseDosageInstructionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("substitution")) {
            res.setSubstitution(this.parseMedicationDispenseMedicationDispenseSubstitutionComponent(json.getAsJsonObject("substitution"), res));
        }
        return res;
    }

    protected MedicationDispense.MedicationDispenseDosageInstructionComponent parseMedicationDispenseMedicationDispenseDosageInstructionComponent(JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
        Type rate;
        Type dose;
        Type site;
        Type asNeeded;
        MedicationDispense.MedicationDispenseDosageInstructionComponent res = new MedicationDispense.MedicationDispenseDosageInstructionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("additionalInstructions")) {
            res.setAdditionalInstructions(this.parseCodeableConcept(json.getAsJsonObject("additionalInstructions")));
        }
        if (json.has("timing")) {
            res.setTiming(this.parseTiming(json.getAsJsonObject("timing")));
        }
        if ((asNeeded = this.parseType("asNeeded", json)) != null) {
            res.setAsNeeded(asNeeded);
        }
        if ((site = this.parseType("site", json)) != null) {
            res.setSite(site);
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(json.getAsJsonObject("route")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if ((dose = this.parseType("dose", json)) != null) {
            res.setDose(dose);
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
        if (json.has("maxDosePerPeriod")) {
            res.setMaxDosePerPeriod(this.parseRatio(json.getAsJsonObject("maxDosePerPeriod")));
        }
        return res;
    }

    protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("responsibleParty")) {
            array = json.getAsJsonArray("responsibleParty");
            for (i = 0; i < array.size(); ++i) {
                res.getResponsibleParty().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected MedicationOrder parseMedicationOrder(JsonObject json) throws IOException, FHIRFormatError {
        Type medication;
        Type reason;
        MedicationOrder res = new MedicationOrder();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dateWritten")) {
            res.setDateWrittenElement(this.parseDateTime(json.get("dateWritten").getAsString()));
        }
        if (json.has("_dateWritten")) {
            this.parseElementProperties(json.getAsJsonObject("_dateWritten"), res.getDateWrittenElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MedicationOrder.MedicationOrderStatus.NULL, new MedicationOrder.MedicationOrderStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("dateEnded")) {
            res.setDateEndedElement(this.parseDateTime(json.get("dateEnded").getAsString()));
        }
        if (json.has("_dateEnded")) {
            this.parseElementProperties(json.getAsJsonObject("_dateEnded"), res.getDateEndedElement());
        }
        if (json.has("reasonEnded")) {
            res.setReasonEnded(this.parseCodeableConcept(json.getAsJsonObject("reasonEnded")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("prescriber")) {
            res.setPrescriber(this.parseReference(json.getAsJsonObject("prescriber")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if (json.has("note")) {
            res.setNoteElement(this.parseString(json.get("note").getAsString()));
        }
        if (json.has("_note")) {
            this.parseElementProperties(json.getAsJsonObject("_note"), res.getNoteElement());
        }
        if ((medication = this.parseType("medication", json)) != null) {
            res.setMedication(medication);
        }
        if (json.has("dosageInstruction")) {
            JsonArray array = json.getAsJsonArray("dosageInstruction");
            for (int i = 0; i < array.size(); ++i) {
                res.getDosageInstruction().add(this.parseMedicationOrderMedicationOrderDosageInstructionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("dispenseRequest")) {
            res.setDispenseRequest(this.parseMedicationOrderMedicationOrderDispenseRequestComponent(json.getAsJsonObject("dispenseRequest"), res));
        }
        if (json.has("substitution")) {
            res.setSubstitution(this.parseMedicationOrderMedicationOrderSubstitutionComponent(json.getAsJsonObject("substitution"), res));
        }
        if (json.has("priorPrescription")) {
            res.setPriorPrescription(this.parseReference(json.getAsJsonObject("priorPrescription")));
        }
        return res;
    }

    protected MedicationOrder.MedicationOrderDosageInstructionComponent parseMedicationOrderMedicationOrderDosageInstructionComponent(JsonObject json, MedicationOrder owner) throws IOException, FHIRFormatError {
        Type rate;
        Type dose;
        Type site;
        Type asNeeded;
        MedicationOrder.MedicationOrderDosageInstructionComponent res = new MedicationOrder.MedicationOrderDosageInstructionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("additionalInstructions")) {
            res.setAdditionalInstructions(this.parseCodeableConcept(json.getAsJsonObject("additionalInstructions")));
        }
        if (json.has("timing")) {
            res.setTiming(this.parseTiming(json.getAsJsonObject("timing")));
        }
        if ((asNeeded = this.parseType("asNeeded", json)) != null) {
            res.setAsNeeded(asNeeded);
        }
        if ((site = this.parseType("site", json)) != null) {
            res.setSite(site);
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(json.getAsJsonObject("route")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if ((dose = this.parseType("dose", json)) != null) {
            res.setDose(dose);
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
        if (json.has("maxDosePerPeriod")) {
            res.setMaxDosePerPeriod(this.parseRatio(json.getAsJsonObject("maxDosePerPeriod")));
        }
        return res;
    }

    protected MedicationOrder.MedicationOrderDispenseRequestComponent parseMedicationOrderMedicationOrderDispenseRequestComponent(JsonObject json, MedicationOrder owner) throws IOException, FHIRFormatError {
        MedicationOrder.MedicationOrderDispenseRequestComponent res = new MedicationOrder.MedicationOrderDispenseRequestComponent();
        this.parseBackboneProperties(json, res);
        Type medication = this.parseType("medication", json);
        if (medication != null) {
            res.setMedication(medication);
        }
        if (json.has("validityPeriod")) {
            res.setValidityPeriod(this.parsePeriod(json.getAsJsonObject("validityPeriod")));
        }
        if (json.has("numberOfRepeatsAllowed")) {
            res.setNumberOfRepeatsAllowedElement(this.parsePositiveInt(json.get("numberOfRepeatsAllowed").getAsString()));
        }
        if (json.has("_numberOfRepeatsAllowed")) {
            this.parseElementProperties(json.getAsJsonObject("_numberOfRepeatsAllowed"), res.getNumberOfRepeatsAllowedElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("expectedSupplyDuration")) {
            res.setExpectedSupplyDuration(this.parseDuration(json.getAsJsonObject("expectedSupplyDuration")));
        }
        return res;
    }

    protected MedicationOrder.MedicationOrderSubstitutionComponent parseMedicationOrderMedicationOrderSubstitutionComponent(JsonObject json, MedicationOrder owner) throws IOException, FHIRFormatError {
        MedicationOrder.MedicationOrderSubstitutionComponent res = new MedicationOrder.MedicationOrderSubstitutionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
        return res;
    }

    protected MedicationStatement parseMedicationStatement(JsonObject json) throws IOException, FHIRFormatError {
        Type medication;
        Type effective;
        Type reasonForUse;
        int i;
        JsonArray array;
        MedicationStatement res = new MedicationStatement();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("informationSource")) {
            res.setInformationSource(this.parseReference(json.getAsJsonObject("informationSource")));
        }
        if (json.has("dateAsserted")) {
            res.setDateAssertedElement(this.parseDateTime(json.get("dateAsserted").getAsString()));
        }
        if (json.has("_dateAsserted")) {
            this.parseElementProperties(json.getAsJsonObject("_dateAsserted"), res.getDateAssertedElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MedicationStatement.MedicationStatementStatus.NULL, new MedicationStatement.MedicationStatementStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("wasNotTaken")) {
            res.setWasNotTakenElement(this.parseBoolean(json.get("wasNotTaken").getAsBoolean()));
        }
        if (json.has("_wasNotTaken")) {
            this.parseElementProperties(json.getAsJsonObject("_wasNotTaken"), res.getWasNotTakenElement());
        }
        if (json.has("reasonNotTaken")) {
            array = json.getAsJsonArray("reasonNotTaken");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonNotTaken().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if ((reasonForUse = this.parseType("reasonForUse", json)) != null) {
            res.setReasonForUse(reasonForUse);
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("note")) {
            res.setNoteElement(this.parseString(json.get("note").getAsString()));
        }
        if (json.has("_note")) {
            this.parseElementProperties(json.getAsJsonObject("_note"), res.getNoteElement());
        }
        if (json.has("supportingInformation")) {
            JsonArray array2 = json.getAsJsonArray("supportingInformation");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getSupportingInformation().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((medication = this.parseType("medication", json)) != null) {
            res.setMedication(medication);
        }
        if (json.has("dosage")) {
            JsonArray array3 = json.getAsJsonArray("dosage");
            for (int i3 = 0; i3 < array3.size(); ++i3) {
                res.getDosage().add(this.parseMedicationStatementMedicationStatementDosageComponent(array3.get(i3).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected MedicationStatement.MedicationStatementDosageComponent parseMedicationStatementMedicationStatementDosageComponent(JsonObject json, MedicationStatement owner) throws IOException, FHIRFormatError {
        Type rate;
        Type quantity;
        Type site;
        Type asNeeded;
        MedicationStatement.MedicationStatementDosageComponent res = new MedicationStatement.MedicationStatementDosageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("timing")) {
            res.setTiming(this.parseTiming(json.getAsJsonObject("timing")));
        }
        if ((asNeeded = this.parseType("asNeeded", json)) != null) {
            res.setAsNeeded(asNeeded);
        }
        if ((site = this.parseType("site", json)) != null) {
            res.setSite(site);
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(json.getAsJsonObject("route")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if ((quantity = this.parseType("quantity", json)) != null) {
            res.setQuantity(quantity);
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
        if (json.has("maxDosePerPeriod")) {
            res.setMaxDosePerPeriod(this.parseRatio(json.getAsJsonObject("maxDosePerPeriod")));
        }
        return res;
    }

    protected MessageHeader parseMessageHeader(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        MessageHeader res = new MessageHeader();
        this.parseDomainResourceProperties(json, res);
        if (json.has("timestamp")) {
            res.setTimestampElement(this.parseInstant(json.get("timestamp").getAsString()));
        }
        if (json.has("_timestamp")) {
            this.parseElementProperties(json.getAsJsonObject("_timestamp"), res.getTimestampElement());
        }
        if (json.has("event")) {
            res.setEvent(this.parseCoding(json.getAsJsonObject("event")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseMessageHeaderMessageHeaderResponseComponent(json.getAsJsonObject("response"), res));
        }
        if (json.has("source")) {
            res.setSource(this.parseMessageHeaderMessageSourceComponent(json.getAsJsonObject("source"), res));
        }
        if (json.has("destination")) {
            array = json.getAsJsonArray("destination");
            for (i = 0; i < array.size(); ++i) {
                res.getDestination().add(this.parseMessageHeaderMessageDestinationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(json.getAsJsonObject("enterer")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("receiver")) {
            res.setReceiver(this.parseReference(json.getAsJsonObject("receiver")));
        }
        if (json.has("responsible")) {
            res.setResponsible(this.parseReference(json.getAsJsonObject("responsible")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
        if (json.has("data")) {
            array = json.getAsJsonArray("data");
            for (i = 0; i < array.size(); ++i) {
                res.getData().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
        MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifierElement(this.parseId(json.get("identifier").getAsString()));
        }
        if (json.has("_identifier")) {
            this.parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("details")) {
            res.setDetails(this.parseReference(json.getAsJsonObject("details")));
        }
        return res;
    }

    protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
        MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("software")) {
            res.setSoftwareElement(this.parseString(json.get("software").getAsString()));
        }
        if (json.has("_software")) {
            this.parseElementProperties(json.getAsJsonObject("_software"), res.getSoftwareElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("contact")) {
            res.setContact(this.parseContactPoint(json.getAsJsonObject("contact")));
        }
        if (json.has("endpoint")) {
            res.setEndpointElement(this.parseUri(json.get("endpoint").getAsString()));
        }
        if (json.has("_endpoint")) {
            this.parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
        }
        return res;
    }

    protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
        MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("endpoint")) {
            res.setEndpointElement(this.parseUri(json.get("endpoint").getAsString()));
        }
        if (json.has("_endpoint")) {
            this.parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
        }
        return res;
    }

    protected NamingSystem parseNamingSystem(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        NamingSystem res = new NamingSystem();
        this.parseDomainResourceProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseNamingSystemNamingSystemContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("responsible")) {
            res.setResponsibleElement(this.parseString(json.get("responsible").getAsString()));
        }
        if (json.has("_responsible")) {
            this.parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("usage")) {
            res.setUsageElement(this.parseString(json.get("usage").getAsString()));
        }
        if (json.has("_usage")) {
            this.parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
        }
        if (json.has("uniqueId")) {
            array = json.getAsJsonArray("uniqueId");
            for (i = 0; i < array.size(); ++i) {
                res.getUniqueId().add(this.parseNamingSystemNamingSystemUniqueIdComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("replacedBy")) {
            res.setReplacedBy(this.parseReference(json.getAsJsonObject("replacedBy")));
        }
        return res;
    }

    protected NamingSystem.NamingSystemContactComponent parseNamingSystemNamingSystemContactComponent(JsonObject json, NamingSystem owner) throws IOException, FHIRFormatError {
        NamingSystem.NamingSystemContactComponent res = new NamingSystem.NamingSystemContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemNamingSystemUniqueIdComponent(JsonObject json, NamingSystem owner) throws IOException, FHIRFormatError {
        NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("preferred")) {
            res.setPreferredElement(this.parseBoolean(json.get("preferred").getAsBoolean()));
        }
        if (json.has("_preferred")) {
            this.parseElementProperties(json.getAsJsonObject("_preferred"), res.getPreferredElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected NutritionOrder parseNutritionOrder(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        NutritionOrder res = new NutritionOrder();
        this.parseDomainResourceProperties(json, res);
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("orderer")) {
            res.setOrderer(this.parseReference(json.getAsJsonObject("orderer")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("dateTime")) {
            res.setDateTimeElement(this.parseDateTime(json.get("dateTime").getAsString()));
        }
        if (json.has("_dateTime")) {
            this.parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), NutritionOrder.NutritionOrderStatus.NULL, new NutritionOrder.NutritionOrderStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("allergyIntolerance")) {
            array = json.getAsJsonArray("allergyIntolerance");
            for (i = 0; i < array.size(); ++i) {
                res.getAllergyIntolerance().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("foodPreferenceModifier")) {
            array = json.getAsJsonArray("foodPreferenceModifier");
            for (i = 0; i < array.size(); ++i) {
                res.getFoodPreferenceModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("excludeFoodModifier")) {
            array = json.getAsJsonArray("excludeFoodModifier");
            for (i = 0; i < array.size(); ++i) {
                res.getExcludeFoodModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("oralDiet")) {
            res.setOralDiet(this.parseNutritionOrderNutritionOrderOralDietComponent(json.getAsJsonObject("oralDiet"), res));
        }
        if (json.has("supplement")) {
            array = json.getAsJsonArray("supplement");
            for (i = 0; i < array.size(); ++i) {
                res.getSupplement().add(this.parseNutritionOrderNutritionOrderSupplementComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("enteralFormula")) {
            res.setEnteralFormula(this.parseNutritionOrderNutritionOrderEnteralFormulaComponent(json.getAsJsonObject("enteralFormula"), res));
        }
        return res;
    }

    protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderNutritionOrderOralDietComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("schedule")) {
            array = json.getAsJsonArray("schedule");
            for (i = 0; i < array.size(); ++i) {
                res.getSchedule().add(this.parseTiming(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("nutrient")) {
            array = json.getAsJsonArray("nutrient");
            for (i = 0; i < array.size(); ++i) {
                res.getNutrient().add(this.parseNutritionOrderNutritionOrderOralDietNutrientComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("texture")) {
            array = json.getAsJsonArray("texture");
            for (i = 0; i < array.size(); ++i) {
                res.getTexture().add(this.parseNutritionOrderNutritionOrderOralDietTextureComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("fluidConsistencyType")) {
            array = json.getAsJsonArray("fluidConsistencyType");
            for (i = 0; i < array.size(); ++i) {
                res.getFluidConsistencyType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("instruction")) {
            res.setInstructionElement(this.parseString(json.get("instruction").getAsString()));
        }
        if (json.has("_instruction")) {
            this.parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
        }
        return res;
    }

    protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderNutritionOrderOralDietNutrientComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("modifier")) {
            res.setModifier(this.parseCodeableConcept(json.getAsJsonObject("modifier")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseSimpleQuantity(json.getAsJsonObject("amount")));
        }
        return res;
    }

    protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderNutritionOrderOralDietTextureComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("modifier")) {
            res.setModifier(this.parseCodeableConcept(json.getAsJsonObject("modifier")));
        }
        if (json.has("foodType")) {
            res.setFoodType(this.parseCodeableConcept(json.getAsJsonObject("foodType")));
        }
        return res;
    }

    protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderNutritionOrderSupplementComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("productName")) {
            res.setProductNameElement(this.parseString(json.get("productName").getAsString()));
        }
        if (json.has("_productName")) {
            this.parseElementProperties(json.getAsJsonObject("_productName"), res.getProductNameElement());
        }
        if (json.has("schedule")) {
            JsonArray array = json.getAsJsonArray("schedule");
            for (int i = 0; i < array.size(); ++i) {
                res.getSchedule().add(this.parseTiming(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("instruction")) {
            res.setInstructionElement(this.parseString(json.get("instruction").getAsString()));
        }
        if (json.has("_instruction")) {
            this.parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
        }
        return res;
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderNutritionOrderEnteralFormulaComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("baseFormulaType")) {
            res.setBaseFormulaType(this.parseCodeableConcept(json.getAsJsonObject("baseFormulaType")));
        }
        if (json.has("baseFormulaProductName")) {
            res.setBaseFormulaProductNameElement(this.parseString(json.get("baseFormulaProductName").getAsString()));
        }
        if (json.has("_baseFormulaProductName")) {
            this.parseElementProperties(json.getAsJsonObject("_baseFormulaProductName"), res.getBaseFormulaProductNameElement());
        }
        if (json.has("additiveType")) {
            res.setAdditiveType(this.parseCodeableConcept(json.getAsJsonObject("additiveType")));
        }
        if (json.has("additiveProductName")) {
            res.setAdditiveProductNameElement(this.parseString(json.get("additiveProductName").getAsString()));
        }
        if (json.has("_additiveProductName")) {
            this.parseElementProperties(json.getAsJsonObject("_additiveProductName"), res.getAdditiveProductNameElement());
        }
        if (json.has("caloricDensity")) {
            res.setCaloricDensity(this.parseSimpleQuantity(json.getAsJsonObject("caloricDensity")));
        }
        if (json.has("routeofAdministration")) {
            res.setRouteofAdministration(this.parseCodeableConcept(json.getAsJsonObject("routeofAdministration")));
        }
        if (json.has("administration")) {
            JsonArray array = json.getAsJsonArray("administration");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdministration().add(this.parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("maxVolumeToDeliver")) {
            res.setMaxVolumeToDeliver(this.parseSimpleQuantity(json.getAsJsonObject("maxVolumeToDeliver")));
        }
        if (json.has("administrationInstruction")) {
            res.setAdministrationInstructionElement(this.parseString(json.get("administrationInstruction").getAsString()));
        }
        if (json.has("_administrationInstruction")) {
            this.parseElementProperties(json.getAsJsonObject("_administrationInstruction"), res.getAdministrationInstructionElement());
        }
        return res;
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        Type rate;
        NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("schedule")) {
            res.setSchedule(this.parseTiming(json.getAsJsonObject("schedule")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
        return res;
    }

    protected Observation parseObservation(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type value;
        Type effective;
        Observation res = new Observation();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Observation.ObservationStatus.NULL, new Observation.ObservationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseInstant(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
        }
        if (json.has("performer")) {
            JsonArray array = json.getAsJsonArray("performer");
            for (int i3 = 0; i3 < array.size(); ++i3) {
                res.getPerformer().add(this.parseReference(array.get(i3).getAsJsonObject()));
            }
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("dataAbsentReason")) {
            res.setDataAbsentReason(this.parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
        }
        if (json.has("interpretation")) {
            res.setInterpretation(this.parseCodeableConcept(json.getAsJsonObject("interpretation")));
        }
        if (json.has("comments")) {
            res.setCommentsElement(this.parseString(json.get("comments").getAsString()));
        }
        if (json.has("_comments")) {
            this.parseElementProperties(json.getAsJsonObject("_comments"), res.getCommentsElement());
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(json.getAsJsonObject("bodySite")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if (json.has("specimen")) {
            res.setSpecimen(this.parseReference(json.getAsJsonObject("specimen")));
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(json.getAsJsonObject("device")));
        }
        if (json.has("referenceRange")) {
            JsonArray array = json.getAsJsonArray("referenceRange");
            for (i = 0; i < array.size(); ++i) {
                res.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("related")) {
            JsonArray array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseObservationObservationRelatedComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("component")) {
            JsonArray array = json.getAsJsonArray("component");
            for (i = 0; i < array.size(); ++i) {
                res.getComponent().add(this.parseObservationObservationComponentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Observation.ObservationReferenceRangeComponent parseObservationObservationReferenceRangeComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
        Observation.ObservationReferenceRangeComponent res = new Observation.ObservationReferenceRangeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("low")) {
            res.setLow(this.parseSimpleQuantity(json.getAsJsonObject("low")));
        }
        if (json.has("high")) {
            res.setHigh(this.parseSimpleQuantity(json.getAsJsonObject("high")));
        }
        if (json.has("meaning")) {
            res.setMeaning(this.parseCodeableConcept(json.getAsJsonObject("meaning")));
        }
        if (json.has("age")) {
            res.setAge(this.parseRange(json.getAsJsonObject("age")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        return res;
    }

    protected Observation.ObservationRelatedComponent parseObservationObservationRelatedComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
        Observation.ObservationRelatedComponent res = new Observation.ObservationRelatedComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Observation.ObservationRelationshipType.NULL, new Observation.ObservationRelationshipTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        return res;
    }

    protected Observation.ObservationComponentComponent parseObservationObservationComponentComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
        Type value;
        Observation.ObservationComponentComponent res = new Observation.ObservationComponentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("dataAbsentReason")) {
            res.setDataAbsentReason(this.parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
        }
        if (json.has("referenceRange")) {
            JsonArray array = json.getAsJsonArray("referenceRange");
            for (int i = 0; i < array.size(); ++i) {
                res.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected OperationDefinition parseOperationDefinition(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        OperationDefinition res = new OperationDefinition();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), OperationDefinition.OperationKind.NULL, new OperationDefinition.OperationKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseOperationDefinitionOperationDefinitionContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("idempotent")) {
            res.setIdempotentElement(this.parseBoolean(json.get("idempotent").getAsBoolean()));
        }
        if (json.has("_idempotent")) {
            this.parseElementProperties(json.getAsJsonObject("_idempotent"), res.getIdempotentElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("notes")) {
            res.setNotesElement(this.parseString(json.get("notes").getAsString()));
        }
        if (json.has("_notes")) {
            this.parseElementProperties(json.getAsJsonObject("_notes"), res.getNotesElement());
        }
        if (json.has("base")) {
            res.setBase(this.parseReference(json.getAsJsonObject("base")));
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseBoolean(json.get("system").getAsBoolean()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_type")) {
            array = json.getAsJsonArray("_type");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getType().size()) {
                    res.getType().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getType().get(i));
            }
        }
        if (json.has("instance")) {
            res.setInstanceElement(this.parseBoolean(json.get("instance").getAsBoolean()));
        }
        if (json.has("_instance")) {
            this.parseElementProperties(json.getAsJsonObject("_instance"), res.getInstanceElement());
        }
        if (json.has("parameter")) {
            array = json.getAsJsonArray("parameter");
            for (i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseOperationDefinitionOperationDefinitionParameterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected OperationDefinition.OperationDefinitionContactComponent parseOperationDefinitionOperationDefinitionContactComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionContactComponent res = new OperationDefinition.OperationDefinitionContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected OperationDefinition.OperationDefinitionParameterComponent parseOperationDefinitionOperationDefinitionParameterComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionParameterComponent res = new OperationDefinition.OperationDefinitionParameterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseCode(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), OperationDefinition.OperationParameterUse.NULL, new OperationDefinition.OperationParameterUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseInteger(json.get("min").getAsLong()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        if (json.has("binding")) {
            res.setBinding(this.parseOperationDefinitionOperationDefinitionParameterBindingComponent(json.getAsJsonObject("binding"), owner));
        }
        if (json.has("part")) {
            JsonArray array = json.getAsJsonArray("part");
            for (int i = 0; i < array.size(); ++i) {
                res.getPart().add(this.parseOperationDefinitionOperationDefinitionParameterComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected OperationDefinition.OperationDefinitionParameterBindingComponent parseOperationDefinitionOperationDefinitionParameterBindingComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
        Type valueSet;
        OperationDefinition.OperationDefinitionParameterBindingComponent res = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("strength")) {
            res.setStrengthElement(this.parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
        }
        if (json.has("_strength")) {
            this.parseElementProperties(json.getAsJsonObject("_strength"), res.getStrengthElement());
        }
        if ((valueSet = this.parseType("valueSet", json)) != null) {
            res.setValueSet(valueSet);
        }
        return res;
    }

    protected OperationOutcome parseOperationOutcome(JsonObject json) throws IOException, FHIRFormatError {
        OperationOutcome res = new OperationOutcome();
        this.parseDomainResourceProperties(json, res);
        if (json.has("issue")) {
            JsonArray array = json.getAsJsonArray("issue");
            for (int i = 0; i < array.size(); ++i) {
                res.getIssue().add(this.parseOperationOutcomeOperationOutcomeIssueComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected OperationOutcome.OperationOutcomeIssueComponent parseOperationOutcomeOperationOutcomeIssueComponent(JsonObject json, OperationOutcome owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        OperationOutcome.OperationOutcomeIssueComponent res = new OperationOutcome.OperationOutcomeIssueComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), OperationOutcome.IssueSeverity.NULL, new OperationOutcome.IssueSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), OperationOutcome.IssueType.NULL, new OperationOutcome.IssueTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("details")) {
            res.setDetails(this.parseCodeableConcept(json.getAsJsonObject("details")));
        }
        if (json.has("diagnostics")) {
            res.setDiagnosticsElement(this.parseString(json.get("diagnostics").getAsString()));
        }
        if (json.has("_diagnostics")) {
            this.parseElementProperties(json.getAsJsonObject("_diagnostics"), res.getDiagnosticsElement());
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_location")) {
            array = json.getAsJsonArray("_location");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLocation().size()) {
                    res.getLocation().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getLocation().get(i));
            }
        }
        return res;
    }

    protected Order parseOrder(JsonObject json) throws IOException, FHIRFormatError {
        Type reason;
        Order res = new Order();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if (json.has("when")) {
            res.setWhen(this.parseOrderOrderWhenComponent(json.getAsJsonObject("when"), res));
        }
        if (json.has("detail")) {
            JsonArray array = json.getAsJsonArray("detail");
            for (int i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Order.OrderWhenComponent parseOrderOrderWhenComponent(JsonObject json, Order owner) throws IOException, FHIRFormatError {
        Order.OrderWhenComponent res = new Order.OrderWhenComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("schedule")) {
            res.setSchedule(this.parseTiming(json.getAsJsonObject("schedule")));
        }
        return res;
    }

    protected OrderResponse parseOrderResponse(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        OrderResponse res = new OrderResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("who")) {
            res.setWho(this.parseReference(json.getAsJsonObject("who")));
        }
        if (json.has("orderStatus")) {
            res.setOrderStatusElement(this.parseEnumeration(json.get("orderStatus").getAsString(), OrderResponse.OrderStatus.NULL, new OrderResponse.OrderStatusEnumFactory()));
        }
        if (json.has("_orderStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_orderStatus"), res.getOrderStatusElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("fulfillment")) {
            array = json.getAsJsonArray("fulfillment");
            for (i = 0; i < array.size(); ++i) {
                res.getFulfillment().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Organization parseOrganization(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Organization res = new Organization();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            array = json.getAsJsonArray("address");
            for (i = 0; i < array.size(); ++i) {
                res.getAddress().add(this.parseAddress(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("partOf")) {
            res.setPartOf(this.parseReference(json.getAsJsonObject("partOf")));
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseOrganizationOrganizationContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Organization.OrganizationContactComponent parseOrganizationOrganizationContactComponent(JsonObject json, Organization owner) throws IOException, FHIRFormatError {
        Organization.OrganizationContactComponent res = new Organization.OrganizationContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("purpose")) {
            res.setPurpose(this.parseCodeableConcept(json.getAsJsonObject("purpose")));
        }
        if (json.has("name")) {
            res.setName(this.parseHumanName(json.getAsJsonObject("name")));
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            res.setAddress(this.parseAddress(json.getAsJsonObject("address")));
        }
        return res;
    }

    protected Patient parsePatient(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type multipleBirth;
        Type deceased;
        int i2;
        JsonArray array;
        Patient res = new Patient();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("name")) {
            array = json.getAsJsonArray("name");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getName().add(this.parseHumanName(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getTelecom().add(this.parseContactPoint(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("birthDate")) {
            res.setBirthDateElement(this.parseDate(json.get("birthDate").getAsString()));
        }
        if (json.has("_birthDate")) {
            this.parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
        }
        if ((deceased = this.parseType("deceased", json)) != null) {
            res.setDeceased(deceased);
        }
        if (json.has("address")) {
            JsonArray array2 = json.getAsJsonArray("address");
            for (int i3 = 0; i3 < array2.size(); ++i3) {
                res.getAddress().add(this.parseAddress(array2.get(i3).getAsJsonObject()));
            }
        }
        if (json.has("maritalStatus")) {
            res.setMaritalStatus(this.parseCodeableConcept(json.getAsJsonObject("maritalStatus")));
        }
        if ((multipleBirth = this.parseType("multipleBirth", json)) != null) {
            res.setMultipleBirth(multipleBirth);
        }
        if (json.has("photo")) {
            JsonArray array3 = json.getAsJsonArray("photo");
            for (i = 0; i < array3.size(); ++i) {
                res.getPhoto().add(this.parseAttachment(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contact")) {
            JsonArray array4 = json.getAsJsonArray("contact");
            for (i = 0; i < array4.size(); ++i) {
                res.getContact().add(this.parsePatientContactComponent(array4.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("animal")) {
            res.setAnimal(this.parsePatientAnimalComponent(json.getAsJsonObject("animal"), res));
        }
        if (json.has("communication")) {
            JsonArray array5 = json.getAsJsonArray("communication");
            for (i = 0; i < array5.size(); ++i) {
                res.getCommunication().add(this.parsePatientPatientCommunicationComponent(array5.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("careProvider")) {
            JsonArray array6 = json.getAsJsonArray("careProvider");
            for (i = 0; i < array6.size(); ++i) {
                res.getCareProvider().add(this.parseReference(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("link")) {
            JsonArray array7 = json.getAsJsonArray("link");
            for (i = 0; i < array7.size(); ++i) {
                res.getLink().add(this.parsePatientPatientLinkComponent(array7.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Patient.ContactComponent parsePatientContactComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Patient.ContactComponent res = new Patient.ContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("relationship")) {
            array = json.getAsJsonArray("relationship");
            for (i = 0; i < array.size(); ++i) {
                res.getRelationship().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setName(this.parseHumanName(json.getAsJsonObject("name")));
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            res.setAddress(this.parseAddress(json.getAsJsonObject("address")));
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected Patient.AnimalComponent parsePatientAnimalComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
        Patient.AnimalComponent res = new Patient.AnimalComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("species")) {
            res.setSpecies(this.parseCodeableConcept(json.getAsJsonObject("species")));
        }
        if (json.has("breed")) {
            res.setBreed(this.parseCodeableConcept(json.getAsJsonObject("breed")));
        }
        if (json.has("genderStatus")) {
            res.setGenderStatus(this.parseCodeableConcept(json.getAsJsonObject("genderStatus")));
        }
        return res;
    }

    protected Patient.PatientCommunicationComponent parsePatientPatientCommunicationComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
        Patient.PatientCommunicationComponent res = new Patient.PatientCommunicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(json.getAsJsonObject("language")));
        }
        if (json.has("preferred")) {
            res.setPreferredElement(this.parseBoolean(json.get("preferred").getAsBoolean()));
        }
        if (json.has("_preferred")) {
            this.parseElementProperties(json.getAsJsonObject("_preferred"), res.getPreferredElement());
        }
        return res;
    }

    protected Patient.PatientLinkComponent parsePatientPatientLinkComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
        Patient.PatientLinkComponent res = new Patient.PatientLinkComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("other")) {
            res.setOther(this.parseReference(json.getAsJsonObject("other")));
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Patient.LinkType.NULL, new Patient.LinkTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        return res;
    }

    protected PaymentNotice parsePaymentNotice(JsonObject json) throws IOException, FHIRFormatError {
        PaymentNotice res = new PaymentNotice();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseReference(json.getAsJsonObject("response")));
        }
        if (json.has("paymentStatus")) {
            res.setPaymentStatus(this.parseCoding(json.getAsJsonObject("paymentStatus")));
        }
        return res;
    }

    protected PaymentReconciliation parsePaymentReconciliation(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        PaymentReconciliation res = new PaymentReconciliation();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(json.getAsJsonObject("requestProvider")));
        }
        if (json.has("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(json.getAsJsonObject("requestOrganization")));
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parsePaymentReconciliationDetailsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("form")) {
            res.setForm(this.parseCoding(json.getAsJsonObject("form")));
        }
        if (json.has("total")) {
            res.setTotal(this.parseMoney(json.getAsJsonObject("total")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parsePaymentReconciliationNotesComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected PaymentReconciliation.DetailsComponent parsePaymentReconciliationDetailsComponent(JsonObject json, PaymentReconciliation owner) throws IOException, FHIRFormatError {
        PaymentReconciliation.DetailsComponent res = new PaymentReconciliation.DetailsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("responce")) {
            res.setResponce(this.parseReference(json.getAsJsonObject("responce")));
        }
        if (json.has("submitter")) {
            res.setSubmitter(this.parseReference(json.getAsJsonObject("submitter")));
        }
        if (json.has("payee")) {
            res.setPayee(this.parseReference(json.getAsJsonObject("payee")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        return res;
    }

    protected PaymentReconciliation.NotesComponent parsePaymentReconciliationNotesComponent(JsonObject json, PaymentReconciliation owner) throws IOException, FHIRFormatError {
        PaymentReconciliation.NotesComponent res = new PaymentReconciliation.NotesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        return res;
    }

    protected Person parsePerson(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Person res = new Person();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            array = json.getAsJsonArray("name");
            for (i = 0; i < array.size(); ++i) {
                res.getName().add(this.parseHumanName(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("birthDate")) {
            res.setBirthDateElement(this.parseDate(json.get("birthDate").getAsString()));
        }
        if (json.has("_birthDate")) {
            this.parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
        }
        if (json.has("address")) {
            array = json.getAsJsonArray("address");
            for (i = 0; i < array.size(); ++i) {
                res.getAddress().add(this.parseAddress(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("photo")) {
            res.setPhoto(this.parseAttachment(json.getAsJsonObject("photo")));
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parsePersonPersonLinkComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Person.PersonLinkComponent parsePersonPersonLinkComponent(JsonObject json, Person owner) throws IOException, FHIRFormatError {
        Person.PersonLinkComponent res = new Person.PersonLinkComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("assurance")) {
            res.setAssuranceElement(this.parseEnumeration(json.get("assurance").getAsString(), Person.IdentityAssuranceLevel.NULL, new Person.IdentityAssuranceLevelEnumFactory()));
        }
        if (json.has("_assurance")) {
            this.parseElementProperties(json.getAsJsonObject("_assurance"), res.getAssuranceElement());
        }
        return res;
    }

    protected Practitioner parsePractitioner(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Practitioner res = new Practitioner();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("name")) {
            res.setName(this.parseHumanName(json.getAsJsonObject("name")));
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            array = json.getAsJsonArray("address");
            for (i = 0; i < array.size(); ++i) {
                res.getAddress().add(this.parseAddress(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("birthDate")) {
            res.setBirthDateElement(this.parseDate(json.get("birthDate").getAsString()));
        }
        if (json.has("_birthDate")) {
            this.parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
        }
        if (json.has("photo")) {
            array = json.getAsJsonArray("photo");
            for (i = 0; i < array.size(); ++i) {
                res.getPhoto().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("practitionerRole")) {
            array = json.getAsJsonArray("practitionerRole");
            for (i = 0; i < array.size(); ++i) {
                res.getPractitionerRole().add(this.parsePractitionerPractitionerPractitionerRoleComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("qualification")) {
            array = json.getAsJsonArray("qualification");
            for (i = 0; i < array.size(); ++i) {
                res.getQualification().add(this.parsePractitionerPractitionerQualificationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("communication")) {
            array = json.getAsJsonArray("communication");
            for (i = 0; i < array.size(); ++i) {
                res.getCommunication().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Practitioner.PractitionerPractitionerRoleComponent parsePractitionerPractitionerPractitionerRoleComponent(JsonObject json, Practitioner owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Practitioner.PractitionerPractitionerRoleComponent res = new Practitioner.PractitionerPractitionerRoleComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("specialty")) {
            array = json.getAsJsonArray("specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("healthcareService")) {
            array = json.getAsJsonArray("healthcareService");
            for (i = 0; i < array.size(); ++i) {
                res.getHealthcareService().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Practitioner.PractitionerQualificationComponent parsePractitionerPractitionerQualificationComponent(JsonObject json, Practitioner owner) throws IOException, FHIRFormatError {
        Practitioner.PractitionerQualificationComponent res = new Practitioner.PractitionerQualificationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("issuer")) {
            res.setIssuer(this.parseReference(json.getAsJsonObject("issuer")));
        }
        return res;
    }

    protected Procedure parseProcedure(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type performed;
        Type reason;
        int i2;
        JsonArray array;
        Procedure res = new Procedure();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Procedure.ProcedureStatus.NULL, new Procedure.ProcedureStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("notPerformed")) {
            res.setNotPerformedElement(this.parseBoolean(json.get("notPerformed").getAsBoolean()));
        }
        if (json.has("_notPerformed")) {
            this.parseElementProperties(json.getAsJsonObject("_notPerformed"), res.getNotPerformedElement());
        }
        if (json.has("reasonNotPerformed")) {
            array = json.getAsJsonArray("reasonNotPerformed");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getReasonNotPerformed().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            array = json.getAsJsonArray("bodySite");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBodySite().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if (json.has("performer")) {
            JsonArray array2 = json.getAsJsonArray("performer");
            for (int i3 = 0; i3 < array2.size(); ++i3) {
                res.getPerformer().add(this.parseProcedureProcedurePerformerComponent(array2.get(i3).getAsJsonObject(), res));
            }
        }
        if ((performed = this.parseType("performed", json)) != null) {
            res.setPerformed(performed);
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if (json.has("report")) {
            JsonArray array3 = json.getAsJsonArray("report");
            for (i = 0; i < array3.size(); ++i) {
                res.getReport().add(this.parseReference(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("complication")) {
            JsonArray array4 = json.getAsJsonArray("complication");
            for (i = 0; i < array4.size(); ++i) {
                res.getComplication().add(this.parseCodeableConcept(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("followUp")) {
            JsonArray array5 = json.getAsJsonArray("followUp");
            for (i = 0; i < array5.size(); ++i) {
                res.getFollowUp().add(this.parseCodeableConcept(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("notes")) {
            JsonArray array6 = json.getAsJsonArray("notes");
            for (i = 0; i < array6.size(); ++i) {
                res.getNotes().add(this.parseAnnotation(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("focalDevice")) {
            JsonArray array7 = json.getAsJsonArray("focalDevice");
            for (i = 0; i < array7.size(); ++i) {
                res.getFocalDevice().add(this.parseProcedureProcedureFocalDeviceComponent(array7.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("used")) {
            JsonArray array8 = json.getAsJsonArray("used");
            for (i = 0; i < array8.size(); ++i) {
                res.getUsed().add(this.parseReference(array8.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Procedure.ProcedurePerformerComponent parseProcedureProcedurePerformerComponent(JsonObject json, Procedure owner) throws IOException, FHIRFormatError {
        Procedure.ProcedurePerformerComponent res = new Procedure.ProcedurePerformerComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        return res;
    }

    protected Procedure.ProcedureFocalDeviceComponent parseProcedureProcedureFocalDeviceComponent(JsonObject json, Procedure owner) throws IOException, FHIRFormatError {
        Procedure.ProcedureFocalDeviceComponent res = new Procedure.ProcedureFocalDeviceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("action")) {
            res.setAction(this.parseCodeableConcept(json.getAsJsonObject("action")));
        }
        if (json.has("manipulated")) {
            res.setManipulated(this.parseReference(json.getAsJsonObject("manipulated")));
        }
        return res;
    }

    protected ProcedureRequest parseProcedureRequest(JsonObject json) throws IOException, FHIRFormatError {
        Type asNeeded;
        Type scheduled;
        Type reason;
        int i;
        JsonArray array;
        ProcedureRequest res = new ProcedureRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("bodySite")) {
            array = json.getAsJsonArray("bodySite");
            for (i = 0; i < array.size(); ++i) {
                res.getBodySite().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if ((scheduled = this.parseType("scheduled", json)) != null) {
            res.setScheduled(scheduled);
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ProcedureRequest.ProcedureRequestStatus.NULL, new ProcedureRequest.ProcedureRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("notes")) {
            JsonArray array2 = json.getAsJsonArray("notes");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getNotes().add(this.parseAnnotation(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((asNeeded = this.parseType("asNeeded", json)) != null) {
            res.setAsNeeded(asNeeded);
        }
        if (json.has("orderedOn")) {
            res.setOrderedOnElement(this.parseDateTime(json.get("orderedOn").getAsString()));
        }
        if (json.has("_orderedOn")) {
            this.parseElementProperties(json.getAsJsonObject("_orderedOn"), res.getOrderedOnElement());
        }
        if (json.has("orderer")) {
            res.setOrderer(this.parseReference(json.getAsJsonObject("orderer")));
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), ProcedureRequest.ProcedureRequestPriority.NULL, new ProcedureRequest.ProcedureRequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        return res;
    }

    protected ProcessRequest parseProcessRequest(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ProcessRequest res = new ProcessRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("action")) {
            res.setActionElement(this.parseEnumeration(json.get("action").getAsString(), ProcessRequest.ActionList.NULL, new ProcessRequest.ActionListEnumFactory()));
        }
        if (json.has("_action")) {
            this.parseElementProperties(json.getAsJsonObject("_action"), res.getActionElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseReference(json.getAsJsonObject("response")));
        }
        if (json.has("nullify")) {
            res.setNullifyElement(this.parseBoolean(json.get("nullify").getAsBoolean()));
        }
        if (json.has("_nullify")) {
            this.parseElementProperties(json.getAsJsonObject("_nullify"), res.getNullifyElement());
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseString(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseProcessRequestItemsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("include")) {
            array = json.getAsJsonArray("include");
            for (i = 0; i < array.size(); ++i) {
                res.getInclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_include")) {
            array = json.getAsJsonArray("_include");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInclude().size()) {
                    res.getInclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInclude().get(i));
            }
        }
        if (json.has("exclude")) {
            array = json.getAsJsonArray("exclude");
            for (i = 0; i < array.size(); ++i) {
                res.getExclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_exclude")) {
            array = json.getAsJsonArray("_exclude");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getExclude().size()) {
                    res.getExclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getExclude().get(i));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected ProcessRequest.ItemsComponent parseProcessRequestItemsComponent(JsonObject json, ProcessRequest owner) throws IOException, FHIRFormatError {
        ProcessRequest.ItemsComponent res = new ProcessRequest.ItemsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parseInteger(json.get("sequenceLinkId").getAsLong()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        return res;
    }

    protected ProcessResponse parseProcessResponse(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ProcessResponse res = new ProcessResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCoding(json.getAsJsonObject("outcome")));
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(json.getAsJsonObject("requestProvider")));
        }
        if (json.has("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(json.getAsJsonObject("requestOrganization")));
        }
        if (json.has("form")) {
            res.setForm(this.parseCoding(json.getAsJsonObject("form")));
        }
        if (json.has("notes")) {
            array = json.getAsJsonArray("notes");
            for (i = 0; i < array.size(); ++i) {
                res.getNotes().add(this.parseProcessResponseProcessResponseNotesComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("error")) {
            array = json.getAsJsonArray("error");
            for (i = 0; i < array.size(); ++i) {
                res.getError().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ProcessResponse.ProcessResponseNotesComponent parseProcessResponseProcessResponseNotesComponent(JsonObject json, ProcessResponse owner) throws IOException, FHIRFormatError {
        ProcessResponse.ProcessResponseNotesComponent res = new ProcessResponse.ProcessResponseNotesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        return res;
    }

    protected Provenance parseProvenance(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Provenance res = new Provenance();
        this.parseDomainResourceProperties(json, res);
        if (json.has("target")) {
            array = json.getAsJsonArray("target");
            for (i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("recorded")) {
            res.setRecordedElement(this.parseInstant(json.get("recorded").getAsString()));
        }
        if (json.has("_recorded")) {
            this.parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("activity")) {
            res.setActivity(this.parseCodeableConcept(json.getAsJsonObject("activity")));
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("policy")) {
            array = json.getAsJsonArray("policy");
            for (i = 0; i < array.size(); ++i) {
                res.getPolicy().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_policy")) {
            array = json.getAsJsonArray("_policy");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPolicy().size()) {
                    res.getPolicy().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
            }
        }
        if (json.has("agent")) {
            array = json.getAsJsonArray("agent");
            for (i = 0; i < array.size(); ++i) {
                res.getAgent().add(this.parseProvenanceProvenanceAgentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("entity")) {
            array = json.getAsJsonArray("entity");
            for (i = 0; i < array.size(); ++i) {
                res.getEntity().add(this.parseProvenanceProvenanceEntityComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("signature")) {
            array = json.getAsJsonArray("signature");
            for (i = 0; i < array.size(); ++i) {
                res.getSignature().add(this.parseSignature(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Provenance.ProvenanceAgentComponent parseProvenanceProvenanceAgentComponent(JsonObject json, Provenance owner) throws IOException, FHIRFormatError {
        Provenance.ProvenanceAgentComponent res = new Provenance.ProvenanceAgentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCoding(json.getAsJsonObject("role")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("userId")) {
            res.setUserId(this.parseIdentifier(json.getAsJsonObject("userId")));
        }
        if (json.has("relatedAgent")) {
            JsonArray array = json.getAsJsonArray("relatedAgent");
            for (int i = 0; i < array.size(); ++i) {
                res.getRelatedAgent().add(this.parseProvenanceProvenanceAgentRelatedAgentComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Provenance.ProvenanceAgentRelatedAgentComponent parseProvenanceProvenanceAgentRelatedAgentComponent(JsonObject json, Provenance owner) throws IOException, FHIRFormatError {
        Provenance.ProvenanceAgentRelatedAgentComponent res = new Provenance.ProvenanceAgentRelatedAgentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("target")) {
            res.setTargetElement(this.parseUri(json.get("target").getAsString()));
        }
        if (json.has("_target")) {
            this.parseElementProperties(json.getAsJsonObject("_target"), res.getTargetElement());
        }
        return res;
    }

    protected Provenance.ProvenanceEntityComponent parseProvenanceProvenanceEntityComponent(JsonObject json, Provenance owner) throws IOException, FHIRFormatError {
        Provenance.ProvenanceEntityComponent res = new Provenance.ProvenanceEntityComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRoleElement(this.parseEnumeration(json.get("role").getAsString(), Provenance.ProvenanceEntityRole.NULL, new Provenance.ProvenanceEntityRoleEnumFactory()));
        }
        if (json.has("_role")) {
            this.parseElementProperties(json.getAsJsonObject("_role"), res.getRoleElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseUri(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("agent")) {
            res.setAgent(this.parseProvenanceProvenanceAgentComponent(json.getAsJsonObject("agent"), owner));
        }
        return res;
    }

    protected Questionnaire parseQuestionnaire(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Questionnaire res = new Questionnaire();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Questionnaire.QuestionnaireStatus.NULL, new Questionnaire.QuestionnaireStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subjectType")) {
            array = json.getAsJsonArray("subjectType");
            for (i = 0; i < array.size(); ++i) {
                res.getSubjectType().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_subjectType")) {
            array = json.getAsJsonArray("_subjectType");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSubjectType().size()) {
                    res.getSubjectType().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSubjectType().get(i));
            }
        }
        if (json.has("group")) {
            res.setGroup(this.parseQuestionnaireGroupComponent(json.getAsJsonObject("group"), res));
        }
        return res;
    }

    protected Questionnaire.GroupComponent parseQuestionnaireGroupComponent(JsonObject json, Questionnaire owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Questionnaire.GroupComponent res = new Questionnaire.GroupComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("linkId")) {
            res.setLinkIdElement(this.parseString(json.get("linkId").getAsString()));
        }
        if (json.has("_linkId")) {
            this.parseElementProperties(json.getAsJsonObject("_linkId"), res.getLinkIdElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("required")) {
            res.setRequiredElement(this.parseBoolean(json.get("required").getAsBoolean()));
        }
        if (json.has("_required")) {
            this.parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
        }
        if (json.has("repeats")) {
            res.setRepeatsElement(this.parseBoolean(json.get("repeats").getAsBoolean()));
        }
        if (json.has("_repeats")) {
            this.parseElementProperties(json.getAsJsonObject("_repeats"), res.getRepeatsElement());
        }
        if (json.has("group")) {
            array = json.getAsJsonArray("group");
            for (i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseQuestionnaireGroupComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("question")) {
            array = json.getAsJsonArray("question");
            for (i = 0; i < array.size(); ++i) {
                res.getQuestion().add(this.parseQuestionnaireQuestionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Questionnaire.QuestionComponent parseQuestionnaireQuestionComponent(JsonObject json, Questionnaire owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Questionnaire.QuestionComponent res = new Questionnaire.QuestionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("linkId")) {
            res.setLinkIdElement(this.parseString(json.get("linkId").getAsString()));
        }
        if (json.has("_linkId")) {
            this.parseElementProperties(json.getAsJsonObject("_linkId"), res.getLinkIdElement());
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Questionnaire.AnswerFormat.NULL, new Questionnaire.AnswerFormatEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("required")) {
            res.setRequiredElement(this.parseBoolean(json.get("required").getAsBoolean()));
        }
        if (json.has("_required")) {
            this.parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
        }
        if (json.has("repeats")) {
            res.setRepeatsElement(this.parseBoolean(json.get("repeats").getAsBoolean()));
        }
        if (json.has("_repeats")) {
            this.parseElementProperties(json.getAsJsonObject("_repeats"), res.getRepeatsElement());
        }
        if (json.has("options")) {
            res.setOptions(this.parseReference(json.getAsJsonObject("options")));
        }
        if (json.has("option")) {
            array = json.getAsJsonArray("option");
            for (i = 0; i < array.size(); ++i) {
                res.getOption().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("group")) {
            array = json.getAsJsonArray("group");
            for (i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseQuestionnaireGroupComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected QuestionnaireResponse parseQuestionnaireResponse(JsonObject json) throws IOException, FHIRFormatError {
        QuestionnaireResponse res = new QuestionnaireResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("questionnaire")) {
            res.setQuestionnaire(this.parseReference(json.getAsJsonObject("questionnaire")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), QuestionnaireResponse.QuestionnaireResponseStatus.NULL, new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("authored")) {
            res.setAuthoredElement(this.parseDateTime(json.get("authored").getAsString()));
        }
        if (json.has("_authored")) {
            this.parseElementProperties(json.getAsJsonObject("_authored"), res.getAuthoredElement());
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("group")) {
            res.setGroup(this.parseQuestionnaireResponseGroupComponent(json.getAsJsonObject("group"), res));
        }
        return res;
    }

    protected QuestionnaireResponse.GroupComponent parseQuestionnaireResponseGroupComponent(JsonObject json, QuestionnaireResponse owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        QuestionnaireResponse.GroupComponent res = new QuestionnaireResponse.GroupComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("linkId")) {
            res.setLinkIdElement(this.parseString(json.get("linkId").getAsString()));
        }
        if (json.has("_linkId")) {
            this.parseElementProperties(json.getAsJsonObject("_linkId"), res.getLinkIdElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("group")) {
            array = json.getAsJsonArray("group");
            for (i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseQuestionnaireResponseGroupComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("question")) {
            array = json.getAsJsonArray("question");
            for (i = 0; i < array.size(); ++i) {
                res.getQuestion().add(this.parseQuestionnaireResponseQuestionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected QuestionnaireResponse.QuestionComponent parseQuestionnaireResponseQuestionComponent(JsonObject json, QuestionnaireResponse owner) throws IOException, FHIRFormatError {
        QuestionnaireResponse.QuestionComponent res = new QuestionnaireResponse.QuestionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("linkId")) {
            res.setLinkIdElement(this.parseString(json.get("linkId").getAsString()));
        }
        if (json.has("_linkId")) {
            this.parseElementProperties(json.getAsJsonObject("_linkId"), res.getLinkIdElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("answer")) {
            JsonArray array = json.getAsJsonArray("answer");
            for (int i = 0; i < array.size(); ++i) {
                res.getAnswer().add(this.parseQuestionnaireResponseQuestionAnswerComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected QuestionnaireResponse.QuestionAnswerComponent parseQuestionnaireResponseQuestionAnswerComponent(JsonObject json, QuestionnaireResponse owner) throws IOException, FHIRFormatError {
        QuestionnaireResponse.QuestionAnswerComponent res = new QuestionnaireResponse.QuestionAnswerComponent();
        this.parseBackboneProperties(json, res);
        Type value = this.parseType("value", json);
        if (value != null) {
            res.setValue(value);
        }
        if (json.has("group")) {
            JsonArray array = json.getAsJsonArray("group");
            for (int i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseQuestionnaireResponseGroupComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ReferralRequest parseReferralRequest(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ReferralRequest res = new ReferralRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ReferralRequest.ReferralStatus.NULL, new ReferralRequest.ReferralStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("specialty")) {
            res.setSpecialty(this.parseCodeableConcept(json.getAsJsonObject("specialty")));
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(json.getAsJsonObject("priority")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("requester")) {
            res.setRequester(this.parseReference(json.getAsJsonObject("requester")));
        }
        if (json.has("recipient")) {
            array = json.getAsJsonArray("recipient");
            for (i = 0; i < array.size(); ++i) {
                res.getRecipient().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("dateSent")) {
            res.setDateSentElement(this.parseDateTime(json.get("dateSent").getAsString()));
        }
        if (json.has("_dateSent")) {
            this.parseElementProperties(json.getAsJsonObject("_dateSent"), res.getDateSentElement());
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("serviceRequested")) {
            array = json.getAsJsonArray("serviceRequested");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceRequested().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInformation")) {
            array = json.getAsJsonArray("supportingInformation");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInformation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("fulfillmentTime")) {
            res.setFulfillmentTime(this.parsePeriod(json.getAsJsonObject("fulfillmentTime")));
        }
        return res;
    }

    protected RelatedPerson parseRelatedPerson(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        RelatedPerson res = new RelatedPerson();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(json.getAsJsonObject("relationship")));
        }
        if (json.has("name")) {
            res.setName(this.parseHumanName(json.getAsJsonObject("name")));
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("birthDate")) {
            res.setBirthDateElement(this.parseDate(json.get("birthDate").getAsString()));
        }
        if (json.has("_birthDate")) {
            this.parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
        }
        if (json.has("address")) {
            array = json.getAsJsonArray("address");
            for (i = 0; i < array.size(); ++i) {
                res.getAddress().add(this.parseAddress(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("photo")) {
            array = json.getAsJsonArray("photo");
            for (i = 0; i < array.size(); ++i) {
                res.getPhoto().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected RiskAssessment parseRiskAssessment(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        RiskAssessment res = new RiskAssessment();
        this.parseDomainResourceProperties(json, res);
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("condition")) {
            res.setCondition(this.parseReference(json.getAsJsonObject("condition")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if (json.has("basis")) {
            array = json.getAsJsonArray("basis");
            for (i = 0; i < array.size(); ++i) {
                res.getBasis().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("prediction")) {
            array = json.getAsJsonArray("prediction");
            for (i = 0; i < array.size(); ++i) {
                res.getPrediction().add(this.parseRiskAssessmentRiskAssessmentPredictionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("mitigation")) {
            res.setMitigationElement(this.parseString(json.get("mitigation").getAsString()));
        }
        if (json.has("_mitigation")) {
            this.parseElementProperties(json.getAsJsonObject("_mitigation"), res.getMitigationElement());
        }
        return res;
    }

    protected RiskAssessment.RiskAssessmentPredictionComponent parseRiskAssessmentRiskAssessmentPredictionComponent(JsonObject json, RiskAssessment owner) throws IOException, FHIRFormatError {
        Type when;
        Type probability;
        RiskAssessment.RiskAssessmentPredictionComponent res = new RiskAssessment.RiskAssessmentPredictionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if ((probability = this.parseType("probability", json)) != null) {
            res.setProbability(probability);
        }
        if (json.has("relativeRisk")) {
            res.setRelativeRiskElement(this.parseDecimal(json.get("relativeRisk").getAsBigDecimal()));
        }
        if (json.has("_relativeRisk")) {
            this.parseElementProperties(json.getAsJsonObject("_relativeRisk"), res.getRelativeRiskElement());
        }
        if ((when = this.parseType("when", json)) != null) {
            res.setWhen(when);
        }
        if (json.has("rationale")) {
            res.setRationaleElement(this.parseString(json.get("rationale").getAsString()));
        }
        if (json.has("_rationale")) {
            this.parseElementProperties(json.getAsJsonObject("_rationale"), res.getRationaleElement());
        }
        return res;
    }

    protected Schedule parseSchedule(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Schedule res = new Schedule();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("planningHorizon")) {
            res.setPlanningHorizon(this.parsePeriod(json.getAsJsonObject("planningHorizon")));
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        return res;
    }

    protected SearchParameter parseSearchParameter(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        SearchParameter res = new SearchParameter();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseSearchParameterSearchParameterContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("base")) {
            res.setBaseElement(this.parseCode(json.get("base").getAsString()));
        }
        if (json.has("_base")) {
            this.parseElementProperties(json.getAsJsonObject("_base"), res.getBaseElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("xpath")) {
            res.setXpathElement(this.parseString(json.get("xpath").getAsString()));
        }
        if (json.has("_xpath")) {
            this.parseElementProperties(json.getAsJsonObject("_xpath"), res.getXpathElement());
        }
        if (json.has("xpathUsage")) {
            res.setXpathUsageElement(this.parseEnumeration(json.get("xpathUsage").getAsString(), SearchParameter.XPathUsageType.NULL, new SearchParameter.XPathUsageTypeEnumFactory()));
        }
        if (json.has("_xpathUsage")) {
            this.parseElementProperties(json.getAsJsonObject("_xpathUsage"), res.getXpathUsageElement());
        }
        if (json.has("target")) {
            array = json.getAsJsonArray("target");
            for (i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_target")) {
            array = json.getAsJsonArray("_target");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getTarget().size()) {
                    res.getTarget().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getTarget().get(i));
            }
        }
        return res;
    }

    protected SearchParameter.SearchParameterContactComponent parseSearchParameterSearchParameterContactComponent(JsonObject json, SearchParameter owner) throws IOException, FHIRFormatError {
        SearchParameter.SearchParameterContactComponent res = new SearchParameter.SearchParameterContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Slot parseSlot(JsonObject json) throws IOException, FHIRFormatError {
        Slot res = new Slot();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("schedule")) {
            res.setSchedule(this.parseReference(json.getAsJsonObject("schedule")));
        }
        if (json.has("freeBusyType")) {
            res.setFreeBusyTypeElement(this.parseEnumeration(json.get("freeBusyType").getAsString(), Slot.SlotStatus.NULL, new Slot.SlotStatusEnumFactory()));
        }
        if (json.has("_freeBusyType")) {
            this.parseElementProperties(json.getAsJsonObject("_freeBusyType"), res.getFreeBusyTypeElement());
        }
        if (json.has("start")) {
            res.setStartElement(this.parseInstant(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("overbooked")) {
            res.setOverbookedElement(this.parseBoolean(json.get("overbooked").getAsBoolean()));
        }
        if (json.has("_overbooked")) {
            this.parseElementProperties(json.getAsJsonObject("_overbooked"), res.getOverbookedElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        return res;
    }

    protected Specimen parseSpecimen(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Specimen res = new Specimen();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Specimen.SpecimenStatus.NULL, new Specimen.SpecimenStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("parent")) {
            array = json.getAsJsonArray("parent");
            for (i = 0; i < array.size(); ++i) {
                res.getParent().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("accessionIdentifier")) {
            res.setAccessionIdentifier(this.parseIdentifier(json.getAsJsonObject("accessionIdentifier")));
        }
        if (json.has("receivedTime")) {
            res.setReceivedTimeElement(this.parseDateTime(json.get("receivedTime").getAsString()));
        }
        if (json.has("_receivedTime")) {
            this.parseElementProperties(json.getAsJsonObject("_receivedTime"), res.getReceivedTimeElement());
        }
        if (json.has("collection")) {
            res.setCollection(this.parseSpecimenSpecimenCollectionComponent(json.getAsJsonObject("collection"), res));
        }
        if (json.has("treatment")) {
            array = json.getAsJsonArray("treatment");
            for (i = 0; i < array.size(); ++i) {
                res.getTreatment().add(this.parseSpecimenSpecimenTreatmentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("container")) {
            array = json.getAsJsonArray("container");
            for (i = 0; i < array.size(); ++i) {
                res.getContainer().add(this.parseSpecimenSpecimenContainerComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Specimen.SpecimenCollectionComponent parseSpecimenSpecimenCollectionComponent(JsonObject json, Specimen owner) throws IOException, FHIRFormatError {
        Type collected;
        int i;
        JsonArray array;
        Specimen.SpecimenCollectionComponent res = new Specimen.SpecimenCollectionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("collector")) {
            res.setCollector(this.parseReference(json.getAsJsonObject("collector")));
        }
        if (json.has("comment")) {
            array = json.getAsJsonArray("comment");
            for (i = 0; i < array.size(); ++i) {
                res.getComment().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_comment")) {
            array = json.getAsJsonArray("_comment");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getComment().size()) {
                    res.getComment().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getComment().get(i));
            }
        }
        if ((collected = this.parseType("collected", json)) != null) {
            res.setCollected(collected);
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(json.getAsJsonObject("bodySite")));
        }
        return res;
    }

    protected Specimen.SpecimenTreatmentComponent parseSpecimenSpecimenTreatmentComponent(JsonObject json, Specimen owner) throws IOException, FHIRFormatError {
        Specimen.SpecimenTreatmentComponent res = new Specimen.SpecimenTreatmentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("procedure")) {
            res.setProcedure(this.parseCodeableConcept(json.getAsJsonObject("procedure")));
        }
        if (json.has("additive")) {
            JsonArray array = json.getAsJsonArray("additive");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdditive().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Specimen.SpecimenContainerComponent parseSpecimenSpecimenContainerComponent(JsonObject json, Specimen owner) throws IOException, FHIRFormatError {
        Type additive;
        Specimen.SpecimenContainerComponent res = new Specimen.SpecimenContainerComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("capacity")) {
            res.setCapacity(this.parseSimpleQuantity(json.getAsJsonObject("capacity")));
        }
        if (json.has("specimenQuantity")) {
            res.setSpecimenQuantity(this.parseSimpleQuantity(json.getAsJsonObject("specimenQuantity")));
        }
        if ((additive = this.parseType("additive", json)) != null) {
            res.setAdditive(additive);
        }
        return res;
    }

    protected StructureDefinition parseStructureDefinition(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        StructureDefinition res = new StructureDefinition();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseStructureDefinitionStructureDefinitionContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("fhirVersion")) {
            res.setFhirVersionElement(this.parseId(json.get("fhirVersion").getAsString()));
        }
        if (json.has("_fhirVersion")) {
            this.parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
        }
        if (json.has("mapping")) {
            array = json.getAsJsonArray("mapping");
            for (i = 0; i < array.size(); ++i) {
                res.getMapping().add(this.parseStructureDefinitionStructureDefinitionMappingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), StructureDefinition.StructureDefinitionKind.NULL, new StructureDefinition.StructureDefinitionKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("constrainedType")) {
            res.setConstrainedTypeElement(this.parseCode(json.get("constrainedType").getAsString()));
        }
        if (json.has("_constrainedType")) {
            this.parseElementProperties(json.getAsJsonObject("_constrainedType"), res.getConstrainedTypeElement());
        }
        if (json.has("abstract")) {
            res.setAbstractElement(this.parseBoolean(json.get("abstract").getAsBoolean()));
        }
        if (json.has("_abstract")) {
            this.parseElementProperties(json.getAsJsonObject("_abstract"), res.getAbstractElement());
        }
        if (json.has("contextType")) {
            res.setContextTypeElement(this.parseEnumeration(json.get("contextType").getAsString(), StructureDefinition.ExtensionContext.NULL, new StructureDefinition.ExtensionContextEnumFactory()));
        }
        if (json.has("_contextType")) {
            this.parseElementProperties(json.getAsJsonObject("_contextType"), res.getContextTypeElement());
        }
        if (json.has("context")) {
            array = json.getAsJsonArray("context");
            for (i = 0; i < array.size(); ++i) {
                res.getContext().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_context")) {
            array = json.getAsJsonArray("_context");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getContext().size()) {
                    res.getContext().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getContext().get(i));
            }
        }
        if (json.has("base")) {
            res.setBaseElement(this.parseUri(json.get("base").getAsString()));
        }
        if (json.has("_base")) {
            this.parseElementProperties(json.getAsJsonObject("_base"), res.getBaseElement());
        }
        if (json.has("snapshot")) {
            res.setSnapshot(this.parseStructureDefinitionStructureDefinitionSnapshotComponent(json.getAsJsonObject("snapshot"), res));
        }
        if (json.has("differential")) {
            res.setDifferential(this.parseStructureDefinitionStructureDefinitionDifferentialComponent(json.getAsJsonObject("differential"), res));
        }
        return res;
    }

    protected StructureDefinition.StructureDefinitionContactComponent parseStructureDefinitionStructureDefinitionContactComponent(JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionContactComponent res = new StructureDefinition.StructureDefinitionContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected StructureDefinition.StructureDefinitionMappingComponent parseStructureDefinitionStructureDefinitionMappingComponent(JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionMappingComponent res = new StructureDefinition.StructureDefinitionMappingComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identity")) {
            res.setIdentityElement(this.parseId(json.get("identity").getAsString()));
        }
        if (json.has("_identity")) {
            this.parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("comments")) {
            res.setCommentsElement(this.parseString(json.get("comments").getAsString()));
        }
        if (json.has("_comments")) {
            this.parseElementProperties(json.getAsJsonObject("_comments"), res.getCommentsElement());
        }
        return res;
    }

    protected StructureDefinition.StructureDefinitionSnapshotComponent parseStructureDefinitionStructureDefinitionSnapshotComponent(JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionSnapshotComponent res = new StructureDefinition.StructureDefinitionSnapshotComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("element")) {
            JsonArray array = json.getAsJsonArray("element");
            for (int i = 0; i < array.size(); ++i) {
                res.getElement().add(this.parseElementDefinition(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected StructureDefinition.StructureDefinitionDifferentialComponent parseStructureDefinitionStructureDefinitionDifferentialComponent(JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionDifferentialComponent res = new StructureDefinition.StructureDefinitionDifferentialComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("element")) {
            JsonArray array = json.getAsJsonArray("element");
            for (int i = 0; i < array.size(); ++i) {
                res.getElement().add(this.parseElementDefinition(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Subscription parseSubscription(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Subscription res = new Subscription();
        this.parseDomainResourceProperties(json, res);
        if (json.has("criteria")) {
            res.setCriteriaElement(this.parseString(json.get("criteria").getAsString()));
        }
        if (json.has("_criteria")) {
            this.parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reason")) {
            res.setReasonElement(this.parseString(json.get("reason").getAsString()));
        }
        if (json.has("_reason")) {
            this.parseElementProperties(json.getAsJsonObject("_reason"), res.getReasonElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Subscription.SubscriptionStatus.NULL, new Subscription.SubscriptionStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("error")) {
            res.setErrorElement(this.parseString(json.get("error").getAsString()));
        }
        if (json.has("_error")) {
            this.parseElementProperties(json.getAsJsonObject("_error"), res.getErrorElement());
        }
        if (json.has("channel")) {
            res.setChannel(this.parseSubscriptionSubscriptionChannelComponent(json.getAsJsonObject("channel"), res));
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("tag")) {
            array = json.getAsJsonArray("tag");
            for (i = 0; i < array.size(); ++i) {
                res.getTag().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Subscription.SubscriptionChannelComponent parseSubscriptionSubscriptionChannelComponent(JsonObject json, Subscription owner) throws IOException, FHIRFormatError {
        Subscription.SubscriptionChannelComponent res = new Subscription.SubscriptionChannelComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Subscription.SubscriptionChannelType.NULL, new Subscription.SubscriptionChannelTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("endpoint")) {
            res.setEndpointElement(this.parseUri(json.get("endpoint").getAsString()));
        }
        if (json.has("_endpoint")) {
            this.parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
        }
        if (json.has("payload")) {
            res.setPayloadElement(this.parseString(json.get("payload").getAsString()));
        }
        if (json.has("_payload")) {
            this.parseElementProperties(json.getAsJsonObject("_payload"), res.getPayloadElement());
        }
        if (json.has("header")) {
            res.setHeaderElement(this.parseString(json.get("header").getAsString()));
        }
        if (json.has("_header")) {
            this.parseElementProperties(json.getAsJsonObject("_header"), res.getHeaderElement());
        }
        return res;
    }

    protected Substance parseSubstance(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Substance res = new Substance();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("instance")) {
            array = json.getAsJsonArray("instance");
            for (i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseSubstanceSubstanceInstanceComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("ingredient")) {
            array = json.getAsJsonArray("ingredient");
            for (i = 0; i < array.size(); ++i) {
                res.getIngredient().add(this.parseSubstanceSubstanceIngredientComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Substance.SubstanceInstanceComponent parseSubstanceSubstanceInstanceComponent(JsonObject json, Substance owner) throws IOException, FHIRFormatError {
        Substance.SubstanceInstanceComponent res = new Substance.SubstanceInstanceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("expiry")) {
            res.setExpiryElement(this.parseDateTime(json.get("expiry").getAsString()));
        }
        if (json.has("_expiry")) {
            this.parseElementProperties(json.getAsJsonObject("_expiry"), res.getExpiryElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        return res;
    }

    protected Substance.SubstanceIngredientComponent parseSubstanceSubstanceIngredientComponent(JsonObject json, Substance owner) throws IOException, FHIRFormatError {
        Substance.SubstanceIngredientComponent res = new Substance.SubstanceIngredientComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("quantity")) {
            res.setQuantity(this.parseRatio(json.getAsJsonObject("quantity")));
        }
        if (json.has("substance")) {
            res.setSubstance(this.parseReference(json.getAsJsonObject("substance")));
        }
        return res;
    }

    protected SupplyDelivery parseSupplyDelivery(JsonObject json) throws IOException, FHIRFormatError {
        SupplyDelivery res = new SupplyDelivery();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), SupplyDelivery.SupplyDeliveryStatus.NULL, new SupplyDelivery.SupplyDeliveryStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("suppliedItem")) {
            res.setSuppliedItem(this.parseReference(json.getAsJsonObject("suppliedItem")));
        }
        if (json.has("supplier")) {
            res.setSupplier(this.parseReference(json.getAsJsonObject("supplier")));
        }
        if (json.has("whenPrepared")) {
            res.setWhenPrepared(this.parsePeriod(json.getAsJsonObject("whenPrepared")));
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
        }
        if (json.has("destination")) {
            res.setDestination(this.parseReference(json.getAsJsonObject("destination")));
        }
        if (json.has("receiver")) {
            JsonArray array = json.getAsJsonArray("receiver");
            for (int i = 0; i < array.size(); ++i) {
                res.getReceiver().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected SupplyRequest parseSupplyRequest(JsonObject json) throws IOException, FHIRFormatError {
        Type reason;
        SupplyRequest res = new SupplyRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), SupplyRequest.SupplyRequestStatus.NULL, new SupplyRequest.SupplyRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("kind")) {
            res.setKind(this.parseCodeableConcept(json.getAsJsonObject("kind")));
        }
        if (json.has("orderedItem")) {
            res.setOrderedItem(this.parseReference(json.getAsJsonObject("orderedItem")));
        }
        if (json.has("supplier")) {
            JsonArray array = json.getAsJsonArray("supplier");
            for (int i = 0; i < array.size(); ++i) {
                res.getSupplier().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if (json.has("when")) {
            res.setWhen(this.parseSupplyRequestSupplyRequestWhenComponent(json.getAsJsonObject("when"), res));
        }
        return res;
    }

    protected SupplyRequest.SupplyRequestWhenComponent parseSupplyRequestSupplyRequestWhenComponent(JsonObject json, SupplyRequest owner) throws IOException, FHIRFormatError {
        SupplyRequest.SupplyRequestWhenComponent res = new SupplyRequest.SupplyRequestWhenComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("schedule")) {
            res.setSchedule(this.parseTiming(json.getAsJsonObject("schedule")));
        }
        return res;
    }

    protected TestScript parseTestScript(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        TestScript res = new TestScript();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseTestScriptTestScriptContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("metadata")) {
            res.setMetadata(this.parseTestScriptTestScriptMetadataComponent(json.getAsJsonObject("metadata"), res));
        }
        if (json.has("multiserver")) {
            res.setMultiserverElement(this.parseBoolean(json.get("multiserver").getAsBoolean()));
        }
        if (json.has("_multiserver")) {
            this.parseElementProperties(json.getAsJsonObject("_multiserver"), res.getMultiserverElement());
        }
        if (json.has("fixture")) {
            array = json.getAsJsonArray("fixture");
            for (i = 0; i < array.size(); ++i) {
                res.getFixture().add(this.parseTestScriptTestScriptFixtureComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i = 0; i < array.size(); ++i) {
                res.getProfile().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("variable")) {
            array = json.getAsJsonArray("variable");
            for (i = 0; i < array.size(); ++i) {
                res.getVariable().add(this.parseTestScriptTestScriptVariableComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("setup")) {
            res.setSetup(this.parseTestScriptTestScriptSetupComponent(json.getAsJsonObject("setup"), res));
        }
        if (json.has("test")) {
            array = json.getAsJsonArray("test");
            for (i = 0; i < array.size(); ++i) {
                res.getTest().add(this.parseTestScriptTestScriptTestComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("teardown")) {
            res.setTeardown(this.parseTestScriptTestScriptTeardownComponent(json.getAsJsonObject("teardown"), res));
        }
        return res;
    }

    protected TestScript.TestScriptContactComponent parseTestScriptTestScriptContactComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptContactComponent res = new TestScript.TestScriptContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected TestScript.TestScriptMetadataComponent parseTestScriptTestScriptMetadataComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        TestScript.TestScriptMetadataComponent res = new TestScript.TestScriptMetadataComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseTestScriptTestScriptMetadataLinkComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("capability")) {
            array = json.getAsJsonArray("capability");
            for (i = 0; i < array.size(); ++i) {
                res.getCapability().add(this.parseTestScriptTestScriptMetadataCapabilityComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.TestScriptMetadataLinkComponent parseTestScriptTestScriptMetadataLinkComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptMetadataLinkComponent res = new TestScript.TestScriptMetadataLinkComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        return res;
    }

    protected TestScript.TestScriptMetadataCapabilityComponent parseTestScriptTestScriptMetadataCapabilityComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        TestScript.TestScriptMetadataCapabilityComponent res = new TestScript.TestScriptMetadataCapabilityComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("required")) {
            res.setRequiredElement(this.parseBoolean(json.get("required").getAsBoolean()));
        }
        if (json.has("_required")) {
            this.parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
        }
        if (json.has("validated")) {
            res.setValidatedElement(this.parseBoolean(json.get("validated").getAsBoolean()));
        }
        if (json.has("_validated")) {
            this.parseElementProperties(json.getAsJsonObject("_validated"), res.getValidatedElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("destination")) {
            res.setDestinationElement(this.parseInteger(json.get("destination").getAsLong()));
        }
        if (json.has("_destination")) {
            this.parseElementProperties(json.getAsJsonObject("_destination"), res.getDestinationElement());
        }
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_link")) {
            array = json.getAsJsonArray("_link");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLink().size()) {
                    res.getLink().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getLink().get(i));
            }
        }
        if (json.has("conformance")) {
            res.setConformance(this.parseReference(json.getAsJsonObject("conformance")));
        }
        return res;
    }

    protected TestScript.TestScriptFixtureComponent parseTestScriptTestScriptFixtureComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptFixtureComponent res = new TestScript.TestScriptFixtureComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("autocreate")) {
            res.setAutocreateElement(this.parseBoolean(json.get("autocreate").getAsBoolean()));
        }
        if (json.has("_autocreate")) {
            this.parseElementProperties(json.getAsJsonObject("_autocreate"), res.getAutocreateElement());
        }
        if (json.has("autodelete")) {
            res.setAutodeleteElement(this.parseBoolean(json.get("autodelete").getAsBoolean()));
        }
        if (json.has("_autodelete")) {
            this.parseElementProperties(json.getAsJsonObject("_autodelete"), res.getAutodeleteElement());
        }
        if (json.has("resource")) {
            res.setResource(this.parseReference(json.getAsJsonObject("resource")));
        }
        return res;
    }

    protected TestScript.TestScriptVariableComponent parseTestScriptTestScriptVariableComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptVariableComponent res = new TestScript.TestScriptVariableComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("headerField")) {
            res.setHeaderFieldElement(this.parseString(json.get("headerField").getAsString()));
        }
        if (json.has("_headerField")) {
            this.parseElementProperties(json.getAsJsonObject("_headerField"), res.getHeaderFieldElement());
        }
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("sourceId")) {
            res.setSourceIdElement(this.parseId(json.get("sourceId").getAsString()));
        }
        if (json.has("_sourceId")) {
            this.parseElementProperties(json.getAsJsonObject("_sourceId"), res.getSourceIdElement());
        }
        return res;
    }

    protected TestScript.TestScriptSetupComponent parseTestScriptTestScriptSetupComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptSetupComponent res = new TestScript.TestScriptSetupComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("metadata")) {
            res.setMetadata(this.parseTestScriptTestScriptMetadataComponent(json.getAsJsonObject("metadata"), owner));
        }
        if (json.has("action")) {
            JsonArray array = json.getAsJsonArray("action");
            for (int i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseTestScriptTestScriptSetupActionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.TestScriptSetupActionComponent parseTestScriptTestScriptSetupActionComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptSetupActionComponent res = new TestScript.TestScriptSetupActionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("operation")) {
            res.setOperation(this.parseTestScriptTestScriptSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
        }
        if (json.has("assert")) {
            res.setAssert(this.parseTestScriptTestScriptSetupActionAssertComponent(json.getAsJsonObject("assert"), owner));
        }
        return res;
    }

    protected TestScript.TestScriptSetupActionOperationComponent parseTestScriptTestScriptSetupActionOperationComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptSetupActionOperationComponent res = new TestScript.TestScriptSetupActionOperationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("resource")) {
            res.setResourceElement(this.parseCode(json.get("resource").getAsString()));
        }
        if (json.has("_resource")) {
            this.parseElementProperties(json.getAsJsonObject("_resource"), res.getResourceElement());
        }
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("accept")) {
            res.setAcceptElement(this.parseEnumeration(json.get("accept").getAsString(), TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
        }
        if (json.has("_accept")) {
            this.parseElementProperties(json.getAsJsonObject("_accept"), res.getAcceptElement());
        }
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseEnumeration(json.get("contentType").getAsString(), TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("destination")) {
            res.setDestinationElement(this.parseInteger(json.get("destination").getAsLong()));
        }
        if (json.has("_destination")) {
            this.parseElementProperties(json.getAsJsonObject("_destination"), res.getDestinationElement());
        }
        if (json.has("encodeRequestUrl")) {
            res.setEncodeRequestUrlElement(this.parseBoolean(json.get("encodeRequestUrl").getAsBoolean()));
        }
        if (json.has("_encodeRequestUrl")) {
            this.parseElementProperties(json.getAsJsonObject("_encodeRequestUrl"), res.getEncodeRequestUrlElement());
        }
        if (json.has("params")) {
            res.setParamsElement(this.parseString(json.get("params").getAsString()));
        }
        if (json.has("_params")) {
            this.parseElementProperties(json.getAsJsonObject("_params"), res.getParamsElement());
        }
        if (json.has("requestHeader")) {
            JsonArray array = json.getAsJsonArray("requestHeader");
            for (int i = 0; i < array.size(); ++i) {
                res.getRequestHeader().add(this.parseTestScriptTestScriptSetupActionOperationRequestHeaderComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("responseId")) {
            res.setResponseIdElement(this.parseId(json.get("responseId").getAsString()));
        }
        if (json.has("_responseId")) {
            this.parseElementProperties(json.getAsJsonObject("_responseId"), res.getResponseIdElement());
        }
        if (json.has("sourceId")) {
            res.setSourceIdElement(this.parseId(json.get("sourceId").getAsString()));
        }
        if (json.has("_sourceId")) {
            this.parseElementProperties(json.getAsJsonObject("_sourceId"), res.getSourceIdElement());
        }
        if (json.has("targetId")) {
            res.setTargetIdElement(this.parseId(json.get("targetId").getAsString()));
        }
        if (json.has("_targetId")) {
            this.parseElementProperties(json.getAsJsonObject("_targetId"), res.getTargetIdElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseString(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        return res;
    }

    protected TestScript.TestScriptSetupActionOperationRequestHeaderComponent parseTestScriptTestScriptSetupActionOperationRequestHeaderComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptSetupActionOperationRequestHeaderComponent res = new TestScript.TestScriptSetupActionOperationRequestHeaderComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("field")) {
            res.setFieldElement(this.parseString(json.get("field").getAsString()));
        }
        if (json.has("_field")) {
            this.parseElementProperties(json.getAsJsonObject("_field"), res.getFieldElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected TestScript.TestScriptSetupActionAssertComponent parseTestScriptTestScriptSetupActionAssertComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptSetupActionAssertComponent res = new TestScript.TestScriptSetupActionAssertComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("direction")) {
            res.setDirectionElement(this.parseEnumeration(json.get("direction").getAsString(), TestScript.AssertionDirectionType.NULL, new TestScript.AssertionDirectionTypeEnumFactory()));
        }
        if (json.has("_direction")) {
            this.parseElementProperties(json.getAsJsonObject("_direction"), res.getDirectionElement());
        }
        if (json.has("compareToSourceId")) {
            res.setCompareToSourceIdElement(this.parseString(json.get("compareToSourceId").getAsString()));
        }
        if (json.has("_compareToSourceId")) {
            this.parseElementProperties(json.getAsJsonObject("_compareToSourceId"), res.getCompareToSourceIdElement());
        }
        if (json.has("compareToSourcePath")) {
            res.setCompareToSourcePathElement(this.parseString(json.get("compareToSourcePath").getAsString()));
        }
        if (json.has("_compareToSourcePath")) {
            this.parseElementProperties(json.getAsJsonObject("_compareToSourcePath"), res.getCompareToSourcePathElement());
        }
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseEnumeration(json.get("contentType").getAsString(), TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("headerField")) {
            res.setHeaderFieldElement(this.parseString(json.get("headerField").getAsString()));
        }
        if (json.has("_headerField")) {
            this.parseElementProperties(json.getAsJsonObject("_headerField"), res.getHeaderFieldElement());
        }
        if (json.has("minimumId")) {
            res.setMinimumIdElement(this.parseString(json.get("minimumId").getAsString()));
        }
        if (json.has("_minimumId")) {
            this.parseElementProperties(json.getAsJsonObject("_minimumId"), res.getMinimumIdElement());
        }
        if (json.has("navigationLinks")) {
            res.setNavigationLinksElement(this.parseBoolean(json.get("navigationLinks").getAsBoolean()));
        }
        if (json.has("_navigationLinks")) {
            this.parseElementProperties(json.getAsJsonObject("_navigationLinks"), res.getNavigationLinksElement());
        }
        if (json.has("operator")) {
            res.setOperatorElement(this.parseEnumeration(json.get("operator").getAsString(), TestScript.AssertionOperatorType.NULL, new TestScript.AssertionOperatorTypeEnumFactory()));
        }
        if (json.has("_operator")) {
            this.parseElementProperties(json.getAsJsonObject("_operator"), res.getOperatorElement());
        }
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("resource")) {
            res.setResourceElement(this.parseCode(json.get("resource").getAsString()));
        }
        if (json.has("_resource")) {
            this.parseElementProperties(json.getAsJsonObject("_resource"), res.getResourceElement());
        }
        if (json.has("response")) {
            res.setResponseElement(this.parseEnumeration(json.get("response").getAsString(), TestScript.AssertionResponseTypes.NULL, new TestScript.AssertionResponseTypesEnumFactory()));
        }
        if (json.has("_response")) {
            this.parseElementProperties(json.getAsJsonObject("_response"), res.getResponseElement());
        }
        if (json.has("responseCode")) {
            res.setResponseCodeElement(this.parseString(json.get("responseCode").getAsString()));
        }
        if (json.has("_responseCode")) {
            this.parseElementProperties(json.getAsJsonObject("_responseCode"), res.getResponseCodeElement());
        }
        if (json.has("sourceId")) {
            res.setSourceIdElement(this.parseId(json.get("sourceId").getAsString()));
        }
        if (json.has("_sourceId")) {
            this.parseElementProperties(json.getAsJsonObject("_sourceId"), res.getSourceIdElement());
        }
        if (json.has("validateProfileId")) {
            res.setValidateProfileIdElement(this.parseId(json.get("validateProfileId").getAsString()));
        }
        if (json.has("_validateProfileId")) {
            this.parseElementProperties(json.getAsJsonObject("_validateProfileId"), res.getValidateProfileIdElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("warningOnly")) {
            res.setWarningOnlyElement(this.parseBoolean(json.get("warningOnly").getAsBoolean()));
        }
        if (json.has("_warningOnly")) {
            this.parseElementProperties(json.getAsJsonObject("_warningOnly"), res.getWarningOnlyElement());
        }
        return res;
    }

    protected TestScript.TestScriptTestComponent parseTestScriptTestScriptTestComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptTestComponent res = new TestScript.TestScriptTestComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("metadata")) {
            res.setMetadata(this.parseTestScriptTestScriptMetadataComponent(json.getAsJsonObject("metadata"), owner));
        }
        if (json.has("action")) {
            JsonArray array = json.getAsJsonArray("action");
            for (int i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseTestScriptTestScriptTestActionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.TestScriptTestActionComponent parseTestScriptTestScriptTestActionComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptTestActionComponent res = new TestScript.TestScriptTestActionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("operation")) {
            res.setOperation(this.parseTestScriptTestScriptSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
        }
        if (json.has("assert")) {
            res.setAssert(this.parseTestScriptTestScriptSetupActionAssertComponent(json.getAsJsonObject("assert"), owner));
        }
        return res;
    }

    protected TestScript.TestScriptTeardownComponent parseTestScriptTestScriptTeardownComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptTeardownComponent res = new TestScript.TestScriptTeardownComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("action")) {
            JsonArray array = json.getAsJsonArray("action");
            for (int i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseTestScriptTestScriptTeardownActionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.TestScriptTeardownActionComponent parseTestScriptTestScriptTeardownActionComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptTeardownActionComponent res = new TestScript.TestScriptTeardownActionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("operation")) {
            res.setOperation(this.parseTestScriptTestScriptSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
        }
        return res;
    }

    protected ValueSet parseValueSet(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ValueSet res = new ValueSet();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseValueSetValueSetContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("lockedDate")) {
            res.setLockedDateElement(this.parseDate(json.get("lockedDate").getAsString()));
        }
        if (json.has("_lockedDate")) {
            this.parseElementProperties(json.getAsJsonObject("_lockedDate"), res.getLockedDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("immutable")) {
            res.setImmutableElement(this.parseBoolean(json.get("immutable").getAsBoolean()));
        }
        if (json.has("_immutable")) {
            this.parseElementProperties(json.getAsJsonObject("_immutable"), res.getImmutableElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("extensible")) {
            res.setExtensibleElement(this.parseBoolean(json.get("extensible").getAsBoolean()));
        }
        if (json.has("_extensible")) {
            this.parseElementProperties(json.getAsJsonObject("_extensible"), res.getExtensibleElement());
        }
        if (json.has("codeSystem")) {
            res.setCodeSystem(this.parseValueSetValueSetCodeSystemComponent(json.getAsJsonObject("codeSystem"), res));
        }
        if (json.has("compose")) {
            res.setCompose(this.parseValueSetValueSetComposeComponent(json.getAsJsonObject("compose"), res));
        }
        if (json.has("expansion")) {
            res.setExpansion(this.parseValueSetValueSetExpansionComponent(json.getAsJsonObject("expansion"), res));
        }
        return res;
    }

    protected ValueSet.ValueSetContactComponent parseValueSetValueSetContactComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        ValueSet.ValueSetContactComponent res = new ValueSet.ValueSetContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ValueSet.ValueSetCodeSystemComponent parseValueSetValueSetCodeSystemComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        ValueSet.ValueSetCodeSystemComponent res = new ValueSet.ValueSetCodeSystemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("caseSensitive")) {
            res.setCaseSensitiveElement(this.parseBoolean(json.get("caseSensitive").getAsBoolean()));
        }
        if (json.has("_caseSensitive")) {
            this.parseElementProperties(json.getAsJsonObject("_caseSensitive"), res.getCaseSensitiveElement());
        }
        if (json.has("concept")) {
            JsonArray array = json.getAsJsonArray("concept");
            for (int i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseValueSetConceptDefinitionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ValueSet.ConceptDefinitionComponent parseValueSetConceptDefinitionComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ValueSet.ConceptDefinitionComponent res = new ValueSet.ConceptDefinitionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("abstract")) {
            res.setAbstractElement(this.parseBoolean(json.get("abstract").getAsBoolean()));
        }
        if (json.has("_abstract")) {
            this.parseElementProperties(json.getAsJsonObject("_abstract"), res.getAbstractElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseString(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
        }
        if (json.has("designation")) {
            array = json.getAsJsonArray("designation");
            for (i = 0; i < array.size(); ++i) {
                res.getDesignation().add(this.parseValueSetConceptDefinitionDesignationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseValueSetConceptDefinitionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ValueSet.ConceptDefinitionDesignationComponent parseValueSetConceptDefinitionDesignationComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        ValueSet.ConceptDefinitionDesignationComponent res = new ValueSet.ConceptDefinitionDesignationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("use")) {
            res.setUse(this.parseCoding(json.getAsJsonObject("use")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ValueSet.ValueSetComposeComponent parseValueSetValueSetComposeComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ValueSet.ValueSetComposeComponent res = new ValueSet.ValueSetComposeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("import")) {
            array = json.getAsJsonArray("import");
            for (i = 0; i < array.size(); ++i) {
                res.getImport().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_import")) {
            array = json.getAsJsonArray("_import");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getImport().size()) {
                    res.getImport().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getImport().get(i));
            }
        }
        if (json.has("include")) {
            array = json.getAsJsonArray("include");
            for (i = 0; i < array.size(); ++i) {
                res.getInclude().add(this.parseValueSetConceptSetComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("exclude")) {
            array = json.getAsJsonArray("exclude");
            for (i = 0; i < array.size(); ++i) {
                res.getExclude().add(this.parseValueSetConceptSetComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ValueSet.ConceptSetComponent parseValueSetConceptSetComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ValueSet.ConceptSetComponent res = new ValueSet.ConceptSetComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseValueSetConceptReferenceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("filter")) {
            array = json.getAsJsonArray("filter");
            for (i = 0; i < array.size(); ++i) {
                res.getFilter().add(this.parseValueSetConceptSetFilterComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ValueSet.ConceptReferenceComponent parseValueSetConceptReferenceComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        ValueSet.ConceptReferenceComponent res = new ValueSet.ConceptReferenceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("designation")) {
            JsonArray array = json.getAsJsonArray("designation");
            for (int i = 0; i < array.size(); ++i) {
                res.getDesignation().add(this.parseValueSetConceptDefinitionDesignationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ValueSet.ConceptSetFilterComponent parseValueSetConceptSetFilterComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        ValueSet.ConceptSetFilterComponent res = new ValueSet.ConceptSetFilterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("property")) {
            res.setPropertyElement(this.parseCode(json.get("property").getAsString()));
        }
        if (json.has("_property")) {
            this.parseElementProperties(json.getAsJsonObject("_property"), res.getPropertyElement());
        }
        if (json.has("op")) {
            res.setOpElement(this.parseEnumeration(json.get("op").getAsString(), ValueSet.FilterOperator.NULL, new ValueSet.FilterOperatorEnumFactory()));
        }
        if (json.has("_op")) {
            this.parseElementProperties(json.getAsJsonObject("_op"), res.getOpElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseCode(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ValueSet.ValueSetExpansionComponent parseValueSetValueSetExpansionComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ValueSet.ValueSetExpansionComponent res = new ValueSet.ValueSetExpansionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifierElement(this.parseUri(json.get("identifier").getAsString()));
        }
        if (json.has("_identifier")) {
            this.parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
        }
        if (json.has("timestamp")) {
            res.setTimestampElement(this.parseDateTime(json.get("timestamp").getAsString()));
        }
        if (json.has("_timestamp")) {
            this.parseElementProperties(json.getAsJsonObject("_timestamp"), res.getTimestampElement());
        }
        if (json.has("total")) {
            res.setTotalElement(this.parseInteger(json.get("total").getAsLong()));
        }
        if (json.has("_total")) {
            this.parseElementProperties(json.getAsJsonObject("_total"), res.getTotalElement());
        }
        if (json.has("offset")) {
            res.setOffsetElement(this.parseInteger(json.get("offset").getAsLong()));
        }
        if (json.has("_offset")) {
            this.parseElementProperties(json.getAsJsonObject("_offset"), res.getOffsetElement());
        }
        if (json.has("parameter")) {
            array = json.getAsJsonArray("parameter");
            for (i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseValueSetValueSetExpansionParameterComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("contains")) {
            array = json.getAsJsonArray("contains");
            for (i = 0; i < array.size(); ++i) {
                res.getContains().add(this.parseValueSetValueSetExpansionContainsComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ValueSet.ValueSetExpansionParameterComponent parseValueSetValueSetExpansionParameterComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        Type value;
        ValueSet.ValueSetExpansionParameterComponent res = new ValueSet.ValueSetExpansionParameterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        return res;
    }

    protected ValueSet.ValueSetExpansionContainsComponent parseValueSetValueSetExpansionContainsComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        ValueSet.ValueSetExpansionContainsComponent res = new ValueSet.ValueSetExpansionContainsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("abstract")) {
            res.setAbstractElement(this.parseBoolean(json.get("abstract").getAsBoolean()));
        }
        if (json.has("_abstract")) {
            this.parseElementProperties(json.getAsJsonObject("_abstract"), res.getAbstractElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("contains")) {
            JsonArray array = json.getAsJsonArray("contains");
            for (int i = 0; i < array.size(); ++i) {
                res.getContains().add(this.parseValueSetValueSetExpansionContainsComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected VisionPrescription parseVisionPrescription(JsonObject json) throws IOException, FHIRFormatError {
        Type reason;
        VisionPrescription res = new VisionPrescription();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dateWritten")) {
            res.setDateWrittenElement(this.parseDateTime(json.get("dateWritten").getAsString()));
        }
        if (json.has("_dateWritten")) {
            this.parseElementProperties(json.getAsJsonObject("_dateWritten"), res.getDateWrittenElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("prescriber")) {
            res.setPrescriber(this.parseReference(json.getAsJsonObject("prescriber")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if (json.has("dispense")) {
            JsonArray array = json.getAsJsonArray("dispense");
            for (int i = 0; i < array.size(); ++i) {
                res.getDispense().add(this.parseVisionPrescriptionVisionPrescriptionDispenseComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected VisionPrescription.VisionPrescriptionDispenseComponent parseVisionPrescriptionVisionPrescriptionDispenseComponent(JsonObject json, VisionPrescription owner) throws IOException, FHIRFormatError {
        VisionPrescription.VisionPrescriptionDispenseComponent res = new VisionPrescription.VisionPrescriptionDispenseComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("product")) {
            res.setProduct(this.parseCoding(json.getAsJsonObject("product")));
        }
        if (json.has("eye")) {
            res.setEyeElement(this.parseEnumeration(json.get("eye").getAsString(), VisionPrescription.VisionEyes.NULL, new VisionPrescription.VisionEyesEnumFactory()));
        }
        if (json.has("_eye")) {
            this.parseElementProperties(json.getAsJsonObject("_eye"), res.getEyeElement());
        }
        if (json.has("sphere")) {
            res.setSphereElement(this.parseDecimal(json.get("sphere").getAsBigDecimal()));
        }
        if (json.has("_sphere")) {
            this.parseElementProperties(json.getAsJsonObject("_sphere"), res.getSphereElement());
        }
        if (json.has("cylinder")) {
            res.setCylinderElement(this.parseDecimal(json.get("cylinder").getAsBigDecimal()));
        }
        if (json.has("_cylinder")) {
            this.parseElementProperties(json.getAsJsonObject("_cylinder"), res.getCylinderElement());
        }
        if (json.has("axis")) {
            res.setAxisElement(this.parseInteger(json.get("axis").getAsLong()));
        }
        if (json.has("_axis")) {
            this.parseElementProperties(json.getAsJsonObject("_axis"), res.getAxisElement());
        }
        if (json.has("prism")) {
            res.setPrismElement(this.parseDecimal(json.get("prism").getAsBigDecimal()));
        }
        if (json.has("_prism")) {
            this.parseElementProperties(json.getAsJsonObject("_prism"), res.getPrismElement());
        }
        if (json.has("base")) {
            res.setBaseElement(this.parseEnumeration(json.get("base").getAsString(), VisionPrescription.VisionBase.NULL, new VisionPrescription.VisionBaseEnumFactory()));
        }
        if (json.has("_base")) {
            this.parseElementProperties(json.getAsJsonObject("_base"), res.getBaseElement());
        }
        if (json.has("add")) {
            res.setAddElement(this.parseDecimal(json.get("add").getAsBigDecimal()));
        }
        if (json.has("_add")) {
            this.parseElementProperties(json.getAsJsonObject("_add"), res.getAddElement());
        }
        if (json.has("power")) {
            res.setPowerElement(this.parseDecimal(json.get("power").getAsBigDecimal()));
        }
        if (json.has("_power")) {
            this.parseElementProperties(json.getAsJsonObject("_power"), res.getPowerElement());
        }
        if (json.has("backCurve")) {
            res.setBackCurveElement(this.parseDecimal(json.get("backCurve").getAsBigDecimal()));
        }
        if (json.has("_backCurve")) {
            this.parseElementProperties(json.getAsJsonObject("_backCurve"), res.getBackCurveElement());
        }
        if (json.has("diameter")) {
            res.setDiameterElement(this.parseDecimal(json.get("diameter").getAsBigDecimal()));
        }
        if (json.has("_diameter")) {
            this.parseElementProperties(json.getAsJsonObject("_diameter"), res.getDiameterElement());
        }
        if (json.has("duration")) {
            res.setDuration(this.parseSimpleQuantity(json.getAsJsonObject("duration")));
        }
        if (json.has("color")) {
            res.setColorElement(this.parseString(json.get("color").getAsString()));
        }
        if (json.has("_color")) {
            this.parseElementProperties(json.getAsJsonObject("_color"), res.getColorElement());
        }
        if (json.has("brand")) {
            res.setBrandElement(this.parseString(json.get("brand").getAsString()));
        }
        if (json.has("_brand")) {
            this.parseElementProperties(json.getAsJsonObject("_brand"), res.getBrandElement());
        }
        if (json.has("notes")) {
            res.setNotesElement(this.parseString(json.get("notes").getAsString()));
        }
        if (json.has("_notes")) {
            this.parseElementProperties(json.getAsJsonObject("_notes"), res.getNotesElement());
        }
        return res;
    }

    @Override
    protected Resource parseResource(JsonObject json) throws IOException, FHIRFormatError {
        if (!json.has("resourceType")) {
            throw new FHIRFormatError("Unable to find resource type - maybe not a FHIR resource?");
        }
        String t = json.get("resourceType").getAsString();
        if (Utilities.noString((String)t)) {
            throw new FHIRFormatError("Unable to find resource type - maybe not a FHIR resource?");
        }
        if (t.equals("Parameters")) {
            return this.parseParameters(json);
        }
        if (t.equals("Account")) {
            return this.parseAccount(json);
        }
        if (t.equals("AllergyIntolerance")) {
            return this.parseAllergyIntolerance(json);
        }
        if (t.equals("Appointment")) {
            return this.parseAppointment(json);
        }
        if (t.equals("AppointmentResponse")) {
            return this.parseAppointmentResponse(json);
        }
        if (t.equals("AuditEvent")) {
            return this.parseAuditEvent(json);
        }
        if (t.equals("Basic")) {
            return this.parseBasic(json);
        }
        if (t.equals("Binary")) {
            return this.parseBinary(json);
        }
        if (t.equals("BodySite")) {
            return this.parseBodySite(json);
        }
        if (t.equals("Bundle")) {
            return this.parseBundle(json);
        }
        if (t.equals("CarePlan")) {
            return this.parseCarePlan(json);
        }
        if (t.equals("Claim")) {
            return this.parseClaim(json);
        }
        if (t.equals("ClaimResponse")) {
            return this.parseClaimResponse(json);
        }
        if (t.equals("ClinicalImpression")) {
            return this.parseClinicalImpression(json);
        }
        if (t.equals("Communication")) {
            return this.parseCommunication(json);
        }
        if (t.equals("CommunicationRequest")) {
            return this.parseCommunicationRequest(json);
        }
        if (t.equals("Composition")) {
            return this.parseComposition(json);
        }
        if (t.equals("ConceptMap")) {
            return this.parseConceptMap(json);
        }
        if (t.equals("Condition")) {
            return this.parseCondition(json);
        }
        if (t.equals("Conformance")) {
            return this.parseConformance(json);
        }
        if (t.equals("Contract")) {
            return this.parseContract(json);
        }
        if (t.equals("Coverage")) {
            return this.parseCoverage(json);
        }
        if (t.equals("DataElement")) {
            return this.parseDataElement(json);
        }
        if (t.equals("DetectedIssue")) {
            return this.parseDetectedIssue(json);
        }
        if (t.equals("Device")) {
            return this.parseDevice(json);
        }
        if (t.equals("DeviceComponent")) {
            return this.parseDeviceComponent(json);
        }
        if (t.equals("DeviceMetric")) {
            return this.parseDeviceMetric(json);
        }
        if (t.equals("DeviceUseRequest")) {
            return this.parseDeviceUseRequest(json);
        }
        if (t.equals("DeviceUseStatement")) {
            return this.parseDeviceUseStatement(json);
        }
        if (t.equals("DiagnosticOrder")) {
            return this.parseDiagnosticOrder(json);
        }
        if (t.equals("DiagnosticReport")) {
            return this.parseDiagnosticReport(json);
        }
        if (t.equals("DocumentManifest")) {
            return this.parseDocumentManifest(json);
        }
        if (t.equals("DocumentReference")) {
            return this.parseDocumentReference(json);
        }
        if (t.equals("EligibilityRequest")) {
            return this.parseEligibilityRequest(json);
        }
        if (t.equals("EligibilityResponse")) {
            return this.parseEligibilityResponse(json);
        }
        if (t.equals("Encounter")) {
            return this.parseEncounter(json);
        }
        if (t.equals("EnrollmentRequest")) {
            return this.parseEnrollmentRequest(json);
        }
        if (t.equals("EnrollmentResponse")) {
            return this.parseEnrollmentResponse(json);
        }
        if (t.equals("EpisodeOfCare")) {
            return this.parseEpisodeOfCare(json);
        }
        if (t.equals("ExplanationOfBenefit")) {
            return this.parseExplanationOfBenefit(json);
        }
        if (t.equals("FamilyMemberHistory")) {
            return this.parseFamilyMemberHistory(json);
        }
        if (t.equals("Flag")) {
            return this.parseFlag(json);
        }
        if (t.equals("Goal")) {
            return this.parseGoal(json);
        }
        if (t.equals("Group")) {
            return this.parseGroup(json);
        }
        if (t.equals("HealthcareService")) {
            return this.parseHealthcareService(json);
        }
        if (t.equals("ImagingObjectSelection")) {
            return this.parseImagingObjectSelection(json);
        }
        if (t.equals("ImagingStudy")) {
            return this.parseImagingStudy(json);
        }
        if (t.equals("Immunization")) {
            return this.parseImmunization(json);
        }
        if (t.equals("ImmunizationRecommendation")) {
            return this.parseImmunizationRecommendation(json);
        }
        if (t.equals("ImplementationGuide")) {
            return this.parseImplementationGuide(json);
        }
        if (t.equals("List")) {
            return this.parseList_(json);
        }
        if (t.equals("Location")) {
            return this.parseLocation(json);
        }
        if (t.equals("Media")) {
            return this.parseMedia(json);
        }
        if (t.equals("Medication")) {
            return this.parseMedication(json);
        }
        if (t.equals("MedicationAdministration")) {
            return this.parseMedicationAdministration(json);
        }
        if (t.equals("MedicationDispense")) {
            return this.parseMedicationDispense(json);
        }
        if (t.equals("MedicationOrder")) {
            return this.parseMedicationOrder(json);
        }
        if (t.equals("MedicationStatement")) {
            return this.parseMedicationStatement(json);
        }
        if (t.equals("MessageHeader")) {
            return this.parseMessageHeader(json);
        }
        if (t.equals("NamingSystem")) {
            return this.parseNamingSystem(json);
        }
        if (t.equals("NutritionOrder")) {
            return this.parseNutritionOrder(json);
        }
        if (t.equals("Observation")) {
            return this.parseObservation(json);
        }
        if (t.equals("OperationDefinition")) {
            return this.parseOperationDefinition(json);
        }
        if (t.equals("OperationOutcome")) {
            return this.parseOperationOutcome(json);
        }
        if (t.equals("Order")) {
            return this.parseOrder(json);
        }
        if (t.equals("OrderResponse")) {
            return this.parseOrderResponse(json);
        }
        if (t.equals("Organization")) {
            return this.parseOrganization(json);
        }
        if (t.equals("Patient")) {
            return this.parsePatient(json);
        }
        if (t.equals("PaymentNotice")) {
            return this.parsePaymentNotice(json);
        }
        if (t.equals("PaymentReconciliation")) {
            return this.parsePaymentReconciliation(json);
        }
        if (t.equals("Person")) {
            return this.parsePerson(json);
        }
        if (t.equals("Practitioner")) {
            return this.parsePractitioner(json);
        }
        if (t.equals("Procedure")) {
            return this.parseProcedure(json);
        }
        if (t.equals("ProcedureRequest")) {
            return this.parseProcedureRequest(json);
        }
        if (t.equals("ProcessRequest")) {
            return this.parseProcessRequest(json);
        }
        if (t.equals("ProcessResponse")) {
            return this.parseProcessResponse(json);
        }
        if (t.equals("Provenance")) {
            return this.parseProvenance(json);
        }
        if (t.equals("Questionnaire")) {
            return this.parseQuestionnaire(json);
        }
        if (t.equals("QuestionnaireResponse")) {
            return this.parseQuestionnaireResponse(json);
        }
        if (t.equals("ReferralRequest")) {
            return this.parseReferralRequest(json);
        }
        if (t.equals("RelatedPerson")) {
            return this.parseRelatedPerson(json);
        }
        if (t.equals("RiskAssessment")) {
            return this.parseRiskAssessment(json);
        }
        if (t.equals("Schedule")) {
            return this.parseSchedule(json);
        }
        if (t.equals("SearchParameter")) {
            return this.parseSearchParameter(json);
        }
        if (t.equals("Slot")) {
            return this.parseSlot(json);
        }
        if (t.equals("Specimen")) {
            return this.parseSpecimen(json);
        }
        if (t.equals("StructureDefinition")) {
            return this.parseStructureDefinition(json);
        }
        if (t.equals("Subscription")) {
            return this.parseSubscription(json);
        }
        if (t.equals("Substance")) {
            return this.parseSubstance(json);
        }
        if (t.equals("SupplyDelivery")) {
            return this.parseSupplyDelivery(json);
        }
        if (t.equals("SupplyRequest")) {
            return this.parseSupplyRequest(json);
        }
        if (t.equals("TestScript")) {
            return this.parseTestScript(json);
        }
        if (t.equals("ValueSet")) {
            return this.parseValueSet(json);
        }
        if (t.equals("VisionPrescription")) {
            return this.parseVisionPrescription(json);
        }
        if (t.equals("Binary")) {
            return this.parseBinary(json);
        }
        throw new FHIRFormatError("Unknown.Unrecognised resource type '" + t + "' (in property 'resourceType')");
    }

    @Override
    protected Type parseType(String prefix, JsonObject json) throws IOException, FHIRFormatError {
        if (json.has(prefix + "Identifier")) {
            return this.parseIdentifier(json.getAsJsonObject(prefix + "Identifier"));
        }
        if (json.has(prefix + "Coding")) {
            return this.parseCoding(json.getAsJsonObject(prefix + "Coding"));
        }
        if (json.has(prefix + "Reference")) {
            return this.parseReference(json.getAsJsonObject(prefix + "Reference"));
        }
        if (json.has(prefix + "Signature")) {
            return this.parseSignature(json.getAsJsonObject(prefix + "Signature"));
        }
        if (json.has(prefix + "SampledData")) {
            return this.parseSampledData(json.getAsJsonObject(prefix + "SampledData"));
        }
        if (json.has(prefix + "Quantity")) {
            return this.parseQuantity(json.getAsJsonObject(prefix + "Quantity"));
        }
        if (json.has(prefix + "Period")) {
            return this.parsePeriod(json.getAsJsonObject(prefix + "Period"));
        }
        if (json.has(prefix + "Attachment")) {
            return this.parseAttachment(json.getAsJsonObject(prefix + "Attachment"));
        }
        if (json.has(prefix + "Ratio")) {
            return this.parseRatio(json.getAsJsonObject(prefix + "Ratio"));
        }
        if (json.has(prefix + "Range")) {
            return this.parseRange(json.getAsJsonObject(prefix + "Range"));
        }
        if (json.has(prefix + "Annotation")) {
            return this.parseAnnotation(json.getAsJsonObject(prefix + "Annotation"));
        }
        if (json.has(prefix + "CodeableConcept")) {
            return this.parseCodeableConcept(json.getAsJsonObject(prefix + "CodeableConcept"));
        }
        if (json.has(prefix + "Money")) {
            return this.parseMoney(json.getAsJsonObject(prefix + "Money"));
        }
        if (json.has(prefix + "SimpleQuantity")) {
            return this.parseSimpleQuantity(json.getAsJsonObject(prefix + "SimpleQuantity"));
        }
        if (json.has(prefix + "Duration")) {
            return this.parseDuration(json.getAsJsonObject(prefix + "Duration"));
        }
        if (json.has(prefix + "Count")) {
            return this.parseCount(json.getAsJsonObject(prefix + "Count"));
        }
        if (json.has(prefix + "Distance")) {
            return this.parseDistance(json.getAsJsonObject(prefix + "Distance"));
        }
        if (json.has(prefix + "Age")) {
            return this.parseAge(json.getAsJsonObject(prefix + "Age"));
        }
        if (json.has(prefix + "HumanName")) {
            return this.parseHumanName(json.getAsJsonObject(prefix + "HumanName"));
        }
        if (json.has(prefix + "ContactPoint")) {
            return this.parseContactPoint(json.getAsJsonObject(prefix + "ContactPoint"));
        }
        if (json.has(prefix + "Meta")) {
            return this.parseMeta(json.getAsJsonObject(prefix + "Meta"));
        }
        if (json.has(prefix + "Address")) {
            return this.parseAddress(json.getAsJsonObject(prefix + "Address"));
        }
        if (json.has(prefix + "Timing")) {
            return this.parseTiming(json.getAsJsonObject(prefix + "Timing"));
        }
        if (json.has(prefix + "ElementDefinition")) {
            return this.parseElementDefinition(json.getAsJsonObject(prefix + "ElementDefinition"));
        }
        if (json.has(prefix + "Date") || json.has("_" + prefix + "Date")) {
            DateType t;
            DateType dateType = t = json.has(prefix + "Date") ? this.parseDate(json.get(prefix + "Date").getAsString()) : new DateType();
            if (json.has("_" + prefix + "Date")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Date"), t);
            }
            return t;
        }
        if (json.has(prefix + "DateTime") || json.has("_" + prefix + "DateTime")) {
            DateTimeType t;
            DateTimeType dateTimeType = t = json.has(prefix + "DateTime") ? this.parseDateTime(json.get(prefix + "DateTime").getAsString()) : new DateTimeType();
            if (json.has("_" + prefix + "DateTime")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "DateTime"), t);
            }
            return t;
        }
        if (json.has(prefix + "Code") || json.has("_" + prefix + "Code")) {
            CodeType t;
            CodeType codeType = t = json.has(prefix + "Code") ? this.parseCode(json.get(prefix + "Code").getAsString()) : new CodeType();
            if (json.has("_" + prefix + "Code")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Code"), t);
            }
            return t;
        }
        if (json.has(prefix + "String") || json.has("_" + prefix + "String")) {
            StringType t;
            StringType stringType = t = json.has(prefix + "String") ? this.parseString(json.get(prefix + "String").getAsString()) : new StringType();
            if (json.has("_" + prefix + "String")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "String"), t);
            }
            return t;
        }
        if (json.has(prefix + "Integer") || json.has("_" + prefix + "Integer")) {
            IntegerType t;
            IntegerType integerType = t = json.has(prefix + "Integer") ? this.parseInteger(json.get(prefix + "Integer").getAsLong()) : new IntegerType();
            if (json.has("_" + prefix + "Integer")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Integer"), t);
            }
            return t;
        }
        if (json.has(prefix + "Oid") || json.has("_" + prefix + "Oid")) {
            OidType t;
            OidType oidType = t = json.has(prefix + "Oid") ? this.parseOid(json.get(prefix + "Oid").getAsString()) : new OidType();
            if (json.has("_" + prefix + "Oid")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Oid"), t);
            }
            return t;
        }
        if (json.has(prefix + "Uri") || json.has("_" + prefix + "Uri")) {
            UriType t;
            UriType uriType = t = json.has(prefix + "Uri") ? this.parseUri(json.get(prefix + "Uri").getAsString()) : new UriType();
            if (json.has("_" + prefix + "Uri")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Uri"), t);
            }
            return t;
        }
        if (json.has(prefix + "Uuid") || json.has("_" + prefix + "Uuid")) {
            UuidType t;
            UuidType uuidType = t = json.has(prefix + "Uuid") ? this.parseUuid(json.get(prefix + "Uuid").getAsString()) : new UuidType();
            if (json.has("_" + prefix + "Uuid")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Uuid"), t);
            }
            return t;
        }
        if (json.has(prefix + "Instant") || json.has("_" + prefix + "Instant")) {
            InstantType t;
            InstantType instantType = t = json.has(prefix + "Instant") ? this.parseInstant(json.get(prefix + "Instant").getAsString()) : new InstantType();
            if (json.has("_" + prefix + "Instant")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Instant"), t);
            }
            return t;
        }
        if (json.has(prefix + "Boolean") || json.has("_" + prefix + "Boolean")) {
            BooleanType t;
            BooleanType booleanType = t = json.has(prefix + "Boolean") ? this.parseBoolean(json.get(prefix + "Boolean").getAsBoolean()) : new BooleanType();
            if (json.has("_" + prefix + "Boolean")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Boolean"), t);
            }
            return t;
        }
        if (json.has(prefix + "Base64Binary") || json.has("_" + prefix + "Base64Binary")) {
            Base64BinaryType t;
            Base64BinaryType base64BinaryType = t = json.has(prefix + "Base64Binary") ? this.parseBase64Binary(json.get(prefix + "Base64Binary").getAsString()) : new Base64BinaryType();
            if (json.has("_" + prefix + "Base64Binary")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Base64Binary"), t);
            }
            return t;
        }
        if (json.has(prefix + "UnsignedInt") || json.has("_" + prefix + "UnsignedInt")) {
            UnsignedIntType t;
            UnsignedIntType unsignedIntType = t = json.has(prefix + "UnsignedInt") ? this.parseUnsignedInt(json.get(prefix + "UnsignedInt").getAsString()) : new UnsignedIntType();
            if (json.has("_" + prefix + "UnsignedInt")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "UnsignedInt"), t);
            }
            return t;
        }
        if (json.has(prefix + "Markdown") || json.has("_" + prefix + "Markdown")) {
            MarkdownType t;
            MarkdownType markdownType = t = json.has(prefix + "Markdown") ? this.parseMarkdown(json.get(prefix + "Markdown").getAsString()) : new MarkdownType();
            if (json.has("_" + prefix + "Markdown")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Markdown"), t);
            }
            return t;
        }
        if (json.has(prefix + "Time") || json.has("_" + prefix + "Time")) {
            TimeType t;
            TimeType timeType = t = json.has(prefix + "Time") ? this.parseTime(json.get(prefix + "Time").getAsString()) : new TimeType();
            if (json.has("_" + prefix + "Time")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Time"), t);
            }
            return t;
        }
        if (json.has(prefix + "Id") || json.has("_" + prefix + "Id")) {
            IdType t;
            IdType idType = t = json.has(prefix + "Id") ? this.parseId(json.get(prefix + "Id").getAsString()) : new IdType();
            if (json.has("_" + prefix + "Id")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Id"), (Element)t);
            }
            return t;
        }
        if (json.has(prefix + "PositiveInt") || json.has("_" + prefix + "PositiveInt")) {
            PositiveIntType t;
            PositiveIntType positiveIntType = t = json.has(prefix + "PositiveInt") ? this.parsePositiveInt(json.get(prefix + "PositiveInt").getAsString()) : new PositiveIntType();
            if (json.has("_" + prefix + "PositiveInt")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "PositiveInt"), t);
            }
            return t;
        }
        if (json.has(prefix + "Decimal") || json.has("_" + prefix + "Decimal")) {
            DecimalType t;
            DecimalType decimalType = t = json.has(prefix + "Decimal") ? this.parseDecimal(json.get(prefix + "Decimal").getAsBigDecimal()) : new DecimalType();
            if (json.has("_" + prefix + "Decimal")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Decimal"), t);
            }
            return t;
        }
        return null;
    }

    @Override
    protected Type parseType(JsonObject json, String type) throws IOException, FHIRFormatError {
        if (type.equals("Identifier")) {
            return this.parseIdentifier(json);
        }
        if (type.equals("Coding")) {
            return this.parseCoding(json);
        }
        if (type.equals("Reference")) {
            return this.parseReference(json);
        }
        if (type.equals("Signature")) {
            return this.parseSignature(json);
        }
        if (type.equals("SampledData")) {
            return this.parseSampledData(json);
        }
        if (type.equals("Quantity")) {
            return this.parseQuantity(json);
        }
        if (type.equals("Period")) {
            return this.parsePeriod(json);
        }
        if (type.equals("Attachment")) {
            return this.parseAttachment(json);
        }
        if (type.equals("Ratio")) {
            return this.parseRatio(json);
        }
        if (type.equals("Range")) {
            return this.parseRange(json);
        }
        if (type.equals("Annotation")) {
            return this.parseAnnotation(json);
        }
        if (type.equals("CodeableConcept")) {
            return this.parseCodeableConcept(json);
        }
        if (type.equals("Money")) {
            return this.parseMoney(json);
        }
        if (type.equals("SimpleQuantity")) {
            return this.parseSimpleQuantity(json);
        }
        if (type.equals("Duration")) {
            return this.parseDuration(json);
        }
        if (type.equals("Count")) {
            return this.parseCount(json);
        }
        if (type.equals("Distance")) {
            return this.parseDistance(json);
        }
        if (type.equals("Age")) {
            return this.parseAge(json);
        }
        if (type.equals("HumanName")) {
            return this.parseHumanName(json);
        }
        if (type.equals("ContactPoint")) {
            return this.parseContactPoint(json);
        }
        if (type.equals("Meta")) {
            return this.parseMeta(json);
        }
        if (type.equals("Address")) {
            return this.parseAddress(json);
        }
        if (type.equals("Timing")) {
            return this.parseTiming(json);
        }
        if (type.equals("ElementDefinition")) {
            return this.parseElementDefinition(json);
        }
        throw new FHIRFormatError("Unknown Type " + type);
    }

    @Override
    protected boolean hasTypeName(JsonObject json, String prefix) {
        if (json.has(prefix + "Identifier")) {
            return true;
        }
        if (json.has(prefix + "Coding")) {
            return true;
        }
        if (json.has(prefix + "Reference")) {
            return true;
        }
        if (json.has(prefix + "Signature")) {
            return true;
        }
        if (json.has(prefix + "SampledData")) {
            return true;
        }
        if (json.has(prefix + "Quantity")) {
            return true;
        }
        if (json.has(prefix + "Period")) {
            return true;
        }
        if (json.has(prefix + "Attachment")) {
            return true;
        }
        if (json.has(prefix + "Ratio")) {
            return true;
        }
        if (json.has(prefix + "Range")) {
            return true;
        }
        if (json.has(prefix + "Annotation")) {
            return true;
        }
        if (json.has(prefix + "CodeableConcept")) {
            return true;
        }
        if (json.has(prefix + "Money")) {
            return true;
        }
        if (json.has(prefix + "SimpleQuantity")) {
            return true;
        }
        if (json.has(prefix + "Duration")) {
            return true;
        }
        if (json.has(prefix + "Count")) {
            return true;
        }
        if (json.has(prefix + "Distance")) {
            return true;
        }
        if (json.has(prefix + "Age")) {
            return true;
        }
        if (json.has(prefix + "HumanName")) {
            return true;
        }
        if (json.has(prefix + "ContactPoint")) {
            return true;
        }
        if (json.has(prefix + "Meta")) {
            return true;
        }
        if (json.has(prefix + "Address")) {
            return true;
        }
        if (json.has(prefix + "Timing")) {
            return true;
        }
        if (json.has(prefix + "ElementDefinition")) {
            return true;
        }
        if (json.has(prefix + "Parameters")) {
            return true;
        }
        if (json.has(prefix + "Account")) {
            return true;
        }
        if (json.has(prefix + "AllergyIntolerance")) {
            return true;
        }
        if (json.has(prefix + "Appointment")) {
            return true;
        }
        if (json.has(prefix + "AppointmentResponse")) {
            return true;
        }
        if (json.has(prefix + "AuditEvent")) {
            return true;
        }
        if (json.has(prefix + "Basic")) {
            return true;
        }
        if (json.has(prefix + "Binary")) {
            return true;
        }
        if (json.has(prefix + "BodySite")) {
            return true;
        }
        if (json.has(prefix + "Bundle")) {
            return true;
        }
        if (json.has(prefix + "CarePlan")) {
            return true;
        }
        if (json.has(prefix + "Claim")) {
            return true;
        }
        if (json.has(prefix + "ClaimResponse")) {
            return true;
        }
        if (json.has(prefix + "ClinicalImpression")) {
            return true;
        }
        if (json.has(prefix + "Communication")) {
            return true;
        }
        if (json.has(prefix + "CommunicationRequest")) {
            return true;
        }
        if (json.has(prefix + "Composition")) {
            return true;
        }
        if (json.has(prefix + "ConceptMap")) {
            return true;
        }
        if (json.has(prefix + "Condition")) {
            return true;
        }
        if (json.has(prefix + "Conformance")) {
            return true;
        }
        if (json.has(prefix + "Contract")) {
            return true;
        }
        if (json.has(prefix + "Coverage")) {
            return true;
        }
        if (json.has(prefix + "DataElement")) {
            return true;
        }
        if (json.has(prefix + "DetectedIssue")) {
            return true;
        }
        if (json.has(prefix + "Device")) {
            return true;
        }
        if (json.has(prefix + "DeviceComponent")) {
            return true;
        }
        if (json.has(prefix + "DeviceMetric")) {
            return true;
        }
        if (json.has(prefix + "DeviceUseRequest")) {
            return true;
        }
        if (json.has(prefix + "DeviceUseStatement")) {
            return true;
        }
        if (json.has(prefix + "DiagnosticOrder")) {
            return true;
        }
        if (json.has(prefix + "DiagnosticReport")) {
            return true;
        }
        if (json.has(prefix + "DocumentManifest")) {
            return true;
        }
        if (json.has(prefix + "DocumentReference")) {
            return true;
        }
        if (json.has(prefix + "EligibilityRequest")) {
            return true;
        }
        if (json.has(prefix + "EligibilityResponse")) {
            return true;
        }
        if (json.has(prefix + "Encounter")) {
            return true;
        }
        if (json.has(prefix + "EnrollmentRequest")) {
            return true;
        }
        if (json.has(prefix + "EnrollmentResponse")) {
            return true;
        }
        if (json.has(prefix + "EpisodeOfCare")) {
            return true;
        }
        if (json.has(prefix + "ExplanationOfBenefit")) {
            return true;
        }
        if (json.has(prefix + "FamilyMemberHistory")) {
            return true;
        }
        if (json.has(prefix + "Flag")) {
            return true;
        }
        if (json.has(prefix + "Goal")) {
            return true;
        }
        if (json.has(prefix + "Group")) {
            return true;
        }
        if (json.has(prefix + "HealthcareService")) {
            return true;
        }
        if (json.has(prefix + "ImagingObjectSelection")) {
            return true;
        }
        if (json.has(prefix + "ImagingStudy")) {
            return true;
        }
        if (json.has(prefix + "Immunization")) {
            return true;
        }
        if (json.has(prefix + "ImmunizationRecommendation")) {
            return true;
        }
        if (json.has(prefix + "ImplementationGuide")) {
            return true;
        }
        if (json.has(prefix + "List")) {
            return true;
        }
        if (json.has(prefix + "Location")) {
            return true;
        }
        if (json.has(prefix + "Media")) {
            return true;
        }
        if (json.has(prefix + "Medication")) {
            return true;
        }
        if (json.has(prefix + "MedicationAdministration")) {
            return true;
        }
        if (json.has(prefix + "MedicationDispense")) {
            return true;
        }
        if (json.has(prefix + "MedicationOrder")) {
            return true;
        }
        if (json.has(prefix + "MedicationStatement")) {
            return true;
        }
        if (json.has(prefix + "MessageHeader")) {
            return true;
        }
        if (json.has(prefix + "NamingSystem")) {
            return true;
        }
        if (json.has(prefix + "NutritionOrder")) {
            return true;
        }
        if (json.has(prefix + "Observation")) {
            return true;
        }
        if (json.has(prefix + "OperationDefinition")) {
            return true;
        }
        if (json.has(prefix + "OperationOutcome")) {
            return true;
        }
        if (json.has(prefix + "Order")) {
            return true;
        }
        if (json.has(prefix + "OrderResponse")) {
            return true;
        }
        if (json.has(prefix + "Organization")) {
            return true;
        }
        if (json.has(prefix + "Patient")) {
            return true;
        }
        if (json.has(prefix + "PaymentNotice")) {
            return true;
        }
        if (json.has(prefix + "PaymentReconciliation")) {
            return true;
        }
        if (json.has(prefix + "Person")) {
            return true;
        }
        if (json.has(prefix + "Practitioner")) {
            return true;
        }
        if (json.has(prefix + "Procedure")) {
            return true;
        }
        if (json.has(prefix + "ProcedureRequest")) {
            return true;
        }
        if (json.has(prefix + "ProcessRequest")) {
            return true;
        }
        if (json.has(prefix + "ProcessResponse")) {
            return true;
        }
        if (json.has(prefix + "Provenance")) {
            return true;
        }
        if (json.has(prefix + "Questionnaire")) {
            return true;
        }
        if (json.has(prefix + "QuestionnaireResponse")) {
            return true;
        }
        if (json.has(prefix + "ReferralRequest")) {
            return true;
        }
        if (json.has(prefix + "RelatedPerson")) {
            return true;
        }
        if (json.has(prefix + "RiskAssessment")) {
            return true;
        }
        if (json.has(prefix + "Schedule")) {
            return true;
        }
        if (json.has(prefix + "SearchParameter")) {
            return true;
        }
        if (json.has(prefix + "Slot")) {
            return true;
        }
        if (json.has(prefix + "Specimen")) {
            return true;
        }
        if (json.has(prefix + "StructureDefinition")) {
            return true;
        }
        if (json.has(prefix + "Subscription")) {
            return true;
        }
        if (json.has(prefix + "Substance")) {
            return true;
        }
        if (json.has(prefix + "SupplyDelivery")) {
            return true;
        }
        if (json.has(prefix + "SupplyRequest")) {
            return true;
        }
        if (json.has(prefix + "TestScript")) {
            return true;
        }
        if (json.has(prefix + "ValueSet")) {
            return true;
        }
        if (json.has(prefix + "VisionPrescription")) {
            return true;
        }
        if (json.has(prefix + "Date") || json.has("_" + prefix + "Date")) {
            return true;
        }
        if (json.has(prefix + "DateTime") || json.has("_" + prefix + "DateTime")) {
            return true;
        }
        if (json.has(prefix + "Code") || json.has("_" + prefix + "Code")) {
            return true;
        }
        if (json.has(prefix + "String") || json.has("_" + prefix + "String")) {
            return true;
        }
        if (json.has(prefix + "Integer") || json.has("_" + prefix + "Integer")) {
            return true;
        }
        if (json.has(prefix + "Oid") || json.has("_" + prefix + "Oid")) {
            return true;
        }
        if (json.has(prefix + "Uri") || json.has("_" + prefix + "Uri")) {
            return true;
        }
        if (json.has(prefix + "Uuid") || json.has("_" + prefix + "Uuid")) {
            return true;
        }
        if (json.has(prefix + "Instant") || json.has("_" + prefix + "Instant")) {
            return true;
        }
        if (json.has(prefix + "Boolean") || json.has("_" + prefix + "Boolean")) {
            return true;
        }
        if (json.has(prefix + "Base64Binary") || json.has("_" + prefix + "Base64Binary")) {
            return true;
        }
        if (json.has(prefix + "UnsignedInt") || json.has("_" + prefix + "UnsignedInt")) {
            return true;
        }
        if (json.has(prefix + "Markdown") || json.has("_" + prefix + "Markdown")) {
            return true;
        }
        if (json.has(prefix + "Time") || json.has("_" + prefix + "Time")) {
            return true;
        }
        if (json.has(prefix + "Id") || json.has("_" + prefix + "Id")) {
            return true;
        }
        if (json.has(prefix + "PositiveInt") || json.has("_" + prefix + "PositiveInt")) {
            return true;
        }
        return json.has(prefix + "Decimal") || json.has("_" + prefix + "Decimal");
    }

    protected void composeElement(Element element) throws IOException {
        if (element.hasId()) {
            this.prop("id", element.getId());
        }
        if (this.makeComments(element)) {
            this.openArray("fhir_comments");
            for (String s : element.getFormatCommentsPre()) {
                this.prop(null, s);
            }
            for (String s : element.getFormatCommentsPost()) {
                this.prop(null, s);
            }
            this.closeArray();
        }
        if (element.hasExtension()) {
            this.openArray("extension");
            for (Extension e : element.getExtension()) {
                this.composeExtension(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeBackbone(BackboneElement element) throws IOException {
        this.composeElement(element);
        if (element.hasModifierExtension()) {
            this.openArray("modifierExtension");
            for (Extension e : element.getModifierExtension()) {
                this.composeExtension(null, e);
            }
            this.closeArray();
        }
    }

    protected <E extends Enum<E>> void composeEnumerationCore(String name, Enumeration<E> value, EnumFactory e, boolean inArray) throws IOException {
        if (value != null && value.getValue() != null) {
            this.prop(name, e.toCode((Enum)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected <E extends Enum<E>> void composeEnumerationExtras(String name, Enumeration<E> value, EnumFactory e, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeDateCore(String name, DateType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, value.asStringValue());
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeDateExtras(String name, DateType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeDateTimeCore(String name, DateTimeType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, value.asStringValue());
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeDateTimeExtras(String name, DateTimeType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeCodeCore(String name, CodeType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString((String)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeCodeExtras(String name, CodeType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    @Override
    protected void composeStringCore(String name, StringType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString((String)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    @Override
    protected void composeStringExtras(String name, StringType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeIntegerCore(String name, IntegerType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, (int)((Integer)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeIntegerExtras(String name, IntegerType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeOidCore(String name, OidType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString((String)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeOidExtras(String name, OidType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeUriCore(String name, UriType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString((String)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeUriExtras(String name, UriType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeUuidCore(String name, UuidType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString((String)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeUuidExtras(String name, UuidType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeInstantCore(String name, InstantType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, value.asStringValue());
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeInstantExtras(String name, InstantType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeBooleanCore(String name, BooleanType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, (Boolean)value.getValue());
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeBooleanExtras(String name, BooleanType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeBase64BinaryCore(String name, Base64BinaryType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, JsonParser.toString((byte[])value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeBase64BinaryExtras(String name, Base64BinaryType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeUnsignedIntCore(String name, UnsignedIntType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, (int)((Integer)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeUnsignedIntExtras(String name, UnsignedIntType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeMarkdownCore(String name, MarkdownType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString((String)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeMarkdownExtras(String name, MarkdownType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeTimeCore(String name, TimeType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, value.asStringValue());
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeTimeExtras(String name, TimeType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeIdCore(String name, IdType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString(value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeIdExtras(String name, IdType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composePositiveIntCore(String name, PositiveIntType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, (int)((Integer)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composePositiveIntExtras(String name, PositiveIntType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeDecimalCore(String name, DecimalType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, (BigDecimal)value.getValue());
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeDecimalExtras(String name, DecimalType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString((String)value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeExtension(String name, Extension element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeExtensionInner(element);
            this.close();
        }
    }

    protected void composeExtensionInner(Extension element) throws IOException {
        this.composeElement(element);
        if (element.hasUrlElement()) {
            this.composeUriCore("url", element.getUrlElement(), false);
            this.composeUriExtras("url", element.getUrlElement(), false);
        }
        if (element.hasValue()) {
            this.composeType("value", element.getValue());
        }
    }

    protected void composeNarrative(String name, Narrative element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeNarrativeInner(element);
            this.close();
        }
    }

    protected void composeNarrativeInner(Narrative element) throws IOException {
        this.composeElement(element);
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new Narrative.NarrativeStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new Narrative.NarrativeStatusEnumFactory(), false);
        }
        if (element.hasDiv()) {
            this.composeXhtml("div", element.getDiv());
        }
    }

    protected void composeIdentifier(String name, Identifier element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeIdentifierInner(element);
            this.close();
        }
    }

    protected void composeIdentifierInner(Identifier element) throws IOException {
        this.composeElement(element);
        if (element.hasUseElement()) {
            this.composeEnumerationCore("use", element.getUseElement(), new Identifier.IdentifierUseEnumFactory(), false);
            this.composeEnumerationExtras("use", element.getUseElement(), new Identifier.IdentifierUseEnumFactory(), false);
        }
        if (element.hasType()) {
            this.composeCodeableConcept("type", element.getType());
        }
        if (element.hasSystemElement()) {
            this.composeUriCore("system", element.getSystemElement(), false);
            this.composeUriExtras("system", element.getSystemElement(), false);
        }
        if (element.hasValueElement()) {
            this.composeStringCore("value", element.getValueElement(), false);
            this.composeStringExtras("value", element.getValueElement(), false);
        }
        if (element.hasPeriod()) {
            this.composePeriod("period", element.getPeriod());
        }
        if (element.hasAssigner()) {
            this.composeReference("assigner", element.getAssigner());
        }
    }

    protected void composeCoding(String name, Coding element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCodingInner(element);
            this.close();
        }
    }

    protected void composeCodingInner(Coding element) throws IOException {
        this.composeElement(element);
        if (element.hasSystemElement()) {
            this.composeUriCore("system", element.getSystemElement(), false);
            this.composeUriExtras("system", element.getSystemElement(), false);
        }
        if (element.hasVersionElement()) {
            this.composeStringCore("version", element.getVersionElement(), false);
            this.composeStringExtras("version", element.getVersionElement(), false);
        }
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
        if (element.hasDisplayElement()) {
            this.composeStringCore("display", element.getDisplayElement(), false);
            this.composeStringExtras("display", element.getDisplayElement(), false);
        }
        if (element.hasUserSelectedElement()) {
            this.composeBooleanCore("userSelected", element.getUserSelectedElement(), false);
            this.composeBooleanExtras("userSelected", element.getUserSelectedElement(), false);
        }
    }

    protected void composeReference(String name, Reference element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeReferenceInner(element);
            this.close();
        }
    }

    protected void composeReferenceInner(Reference element) throws IOException {
        this.composeElement(element);
        if (element.hasReferenceElement()) {
            this.composeStringCore("reference", element.getReferenceElement(), false);
            this.composeStringExtras("reference", element.getReferenceElement(), false);
        }
        if (element.hasDisplayElement()) {
            this.composeStringCore("display", element.getDisplayElement(), false);
            this.composeStringExtras("display", element.getDisplayElement(), false);
        }
    }

    protected void composeSignature(String name, Signature element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeSignatureInner(element);
            this.close();
        }
    }

    protected void composeSignatureInner(Signature element) throws IOException {
        this.composeElement(element);
        if (element.hasType()) {
            this.openArray("type");
            for (Coding e : element.getType()) {
                this.composeCoding(null, e);
            }
            this.closeArray();
        }
        if (element.hasWhenElement()) {
            this.composeInstantCore("when", element.getWhenElement(), false);
            this.composeInstantExtras("when", element.getWhenElement(), false);
        }
        if (element.hasWho()) {
            this.composeType("who", element.getWho());
        }
        if (element.hasContentTypeElement()) {
            this.composeCodeCore("contentType", element.getContentTypeElement(), false);
            this.composeCodeExtras("contentType", element.getContentTypeElement(), false);
        }
        if (element.hasBlobElement()) {
            this.composeBase64BinaryCore("blob", element.getBlobElement(), false);
            this.composeBase64BinaryExtras("blob", element.getBlobElement(), false);
        }
    }

    protected void composeSampledData(String name, SampledData element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeSampledDataInner(element);
            this.close();
        }
    }

    protected void composeSampledDataInner(SampledData element) throws IOException {
        this.composeElement(element);
        if (element.hasOrigin()) {
            this.composeSimpleQuantity("origin", element.getOrigin());
        }
        if (element.hasPeriodElement()) {
            this.composeDecimalCore("period", element.getPeriodElement(), false);
            this.composeDecimalExtras("period", element.getPeriodElement(), false);
        }
        if (element.hasFactorElement()) {
            this.composeDecimalCore("factor", element.getFactorElement(), false);
            this.composeDecimalExtras("factor", element.getFactorElement(), false);
        }
        if (element.hasLowerLimitElement()) {
            this.composeDecimalCore("lowerLimit", element.getLowerLimitElement(), false);
            this.composeDecimalExtras("lowerLimit", element.getLowerLimitElement(), false);
        }
        if (element.hasUpperLimitElement()) {
            this.composeDecimalCore("upperLimit", element.getUpperLimitElement(), false);
            this.composeDecimalExtras("upperLimit", element.getUpperLimitElement(), false);
        }
        if (element.hasDimensionsElement()) {
            this.composePositiveIntCore("dimensions", element.getDimensionsElement(), false);
            this.composePositiveIntExtras("dimensions", element.getDimensionsElement(), false);
        }
        if (element.hasDataElement()) {
            this.composeStringCore("data", element.getDataElement(), false);
            this.composeStringExtras("data", element.getDataElement(), false);
        }
    }

    protected void composeQuantity(String name, Quantity element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeQuantityInner(element);
            this.close();
        }
    }

    protected void composeQuantityInner(Quantity element) throws IOException {
        this.composeElement(element);
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
        if (element.hasComparatorElement()) {
            this.composeEnumerationCore("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
            this.composeEnumerationExtras("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
        }
        if (element.hasUnitElement()) {
            this.composeStringCore("unit", element.getUnitElement(), false);
            this.composeStringExtras("unit", element.getUnitElement(), false);
        }
        if (element.hasSystemElement()) {
            this.composeUriCore("system", element.getSystemElement(), false);
            this.composeUriExtras("system", element.getSystemElement(), false);
        }
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
    }

    protected void composePeriod(String name, Period element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composePeriodInner(element);
            this.close();
        }
    }

    protected void composePeriodInner(Period element) throws IOException {
        this.composeElement(element);
        if (element.hasStartElement()) {
            this.composeDateTimeCore("start", element.getStartElement(), false);
            this.composeDateTimeExtras("start", element.getStartElement(), false);
        }
        if (element.hasEndElement()) {
            this.composeDateTimeCore("end", element.getEndElement(), false);
            this.composeDateTimeExtras("end", element.getEndElement(), false);
        }
    }

    protected void composeAttachment(String name, Attachment element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAttachmentInner(element);
            this.close();
        }
    }

    protected void composeAttachmentInner(Attachment element) throws IOException {
        this.composeElement(element);
        if (element.hasContentTypeElement()) {
            this.composeCodeCore("contentType", element.getContentTypeElement(), false);
            this.composeCodeExtras("contentType", element.getContentTypeElement(), false);
        }
        if (element.hasLanguageElement()) {
            this.composeCodeCore("language", element.getLanguageElement(), false);
            this.composeCodeExtras("language", element.getLanguageElement(), false);
        }
        if (element.hasDataElement()) {
            this.composeBase64BinaryCore("data", element.getDataElement(), false);
            this.composeBase64BinaryExtras("data", element.getDataElement(), false);
        }
        if (element.hasUrlElement()) {
            this.composeUriCore("url", element.getUrlElement(), false);
            this.composeUriExtras("url", element.getUrlElement(), false);
        }
        if (element.hasSizeElement()) {
            this.composeUnsignedIntCore("size", element.getSizeElement(), false);
            this.composeUnsignedIntExtras("size", element.getSizeElement(), false);
        }
        if (element.hasHashElement()) {
            this.composeBase64BinaryCore("hash", element.getHashElement(), false);
            this.composeBase64BinaryExtras("hash", element.getHashElement(), false);
        }
        if (element.hasTitleElement()) {
            this.composeStringCore("title", element.getTitleElement(), false);
            this.composeStringExtras("title", element.getTitleElement(), false);
        }
        if (element.hasCreationElement()) {
            this.composeDateTimeCore("creation", element.getCreationElement(), false);
            this.composeDateTimeExtras("creation", element.getCreationElement(), false);
        }
    }

    protected void composeRatio(String name, Ratio element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeRatioInner(element);
            this.close();
        }
    }

    protected void composeRatioInner(Ratio element) throws IOException {
        this.composeElement(element);
        if (element.hasNumerator()) {
            this.composeQuantity("numerator", element.getNumerator());
        }
        if (element.hasDenominator()) {
            this.composeQuantity("denominator", element.getDenominator());
        }
    }

    protected void composeRange(String name, Range element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeRangeInner(element);
            this.close();
        }
    }

    protected void composeRangeInner(Range element) throws IOException {
        this.composeElement(element);
        if (element.hasLow()) {
            this.composeSimpleQuantity("low", element.getLow());
        }
        if (element.hasHigh()) {
            this.composeSimpleQuantity("high", element.getHigh());
        }
    }

    protected void composeAnnotation(String name, Annotation element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAnnotationInner(element);
            this.close();
        }
    }

    protected void composeAnnotationInner(Annotation element) throws IOException {
        this.composeElement(element);
        if (element.hasAuthor()) {
            this.composeType("author", element.getAuthor());
        }
        if (element.hasTimeElement()) {
            this.composeDateTimeCore("time", element.getTimeElement(), false);
            this.composeDateTimeExtras("time", element.getTimeElement(), false);
        }
        if (element.hasTextElement()) {
            this.composeStringCore("text", element.getTextElement(), false);
            this.composeStringExtras("text", element.getTextElement(), false);
        }
    }

    protected void composeCodeableConcept(String name, CodeableConcept element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCodeableConceptInner(element);
            this.close();
        }
    }

    protected void composeCodeableConceptInner(CodeableConcept element) throws IOException {
        this.composeElement(element);
        if (element.hasCoding()) {
            this.openArray("coding");
            for (Coding e : element.getCoding()) {
                this.composeCoding(null, e);
            }
            this.closeArray();
        }
        if (element.hasTextElement()) {
            this.composeStringCore("text", element.getTextElement(), false);
            this.composeStringExtras("text", element.getTextElement(), false);
        }
    }

    protected void composeMoney(String name, Money element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeMoneyInner(element);
            this.close();
        }
    }

    protected void composeMoneyInner(Money element) throws IOException {
        this.composeElement(element);
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
        if (element.hasComparatorElement()) {
            this.composeEnumerationCore("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
            this.composeEnumerationExtras("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
        }
        if (element.hasUnitElement()) {
            this.composeStringCore("unit", element.getUnitElement(), false);
            this.composeStringExtras("unit", element.getUnitElement(), false);
        }
        if (element.hasSystemElement()) {
            this.composeUriCore("system", element.getSystemElement(), false);
            this.composeUriExtras("system", element.getSystemElement(), false);
        }
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
    }

    protected void composeSimpleQuantity(String name, SimpleQuantity element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeSimpleQuantityInner(element);
            this.close();
        }
    }

    protected void composeSimpleQuantityInner(SimpleQuantity element) throws IOException {
        this.composeElement(element);
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
        if (element.hasComparatorElement()) {
            this.composeEnumerationCore("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
            this.composeEnumerationExtras("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
        }
        if (element.hasUnitElement()) {
            this.composeStringCore("unit", element.getUnitElement(), false);
            this.composeStringExtras("unit", element.getUnitElement(), false);
        }
        if (element.hasSystemElement()) {
            this.composeUriCore("system", element.getSystemElement(), false);
            this.composeUriExtras("system", element.getSystemElement(), false);
        }
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
    }

    protected void composeDuration(String name, Duration element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDurationInner(element);
            this.close();
        }
    }

    protected void composeDurationInner(Duration element) throws IOException {
        this.composeElement(element);
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
        if (element.hasComparatorElement()) {
            this.composeEnumerationCore("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
            this.composeEnumerationExtras("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
        }
        if (element.hasUnitElement()) {
            this.composeStringCore("unit", element.getUnitElement(), false);
            this.composeStringExtras("unit", element.getUnitElement(), false);
        }
        if (element.hasSystemElement()) {
            this.composeUriCore("system", element.getSystemElement(), false);
            this.composeUriExtras("system", element.getSystemElement(), false);
        }
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
    }

    protected void composeCount(String name, Count element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCountInner(element);
            this.close();
        }
    }

    protected void composeCountInner(Count element) throws IOException {
        this.composeElement(element);
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
        if (element.hasComparatorElement()) {
            this.composeEnumerationCore("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
            this.composeEnumerationExtras("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
        }
        if (element.hasUnitElement()) {
            this.composeStringCore("unit", element.getUnitElement(), false);
            this.composeStringExtras("unit", element.getUnitElement(), false);
        }
        if (element.hasSystemElement()) {
            this.composeUriCore("system", element.getSystemElement(), false);
            this.composeUriExtras("system", element.getSystemElement(), false);
        }
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
    }

    protected void composeDistance(String name, Distance element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDistanceInner(element);
            this.close();
        }
    }

    protected void composeDistanceInner(Distance element) throws IOException {
        this.composeElement(element);
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
        if (element.hasComparatorElement()) {
            this.composeEnumerationCore("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
            this.composeEnumerationExtras("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
        }
        if (element.hasUnitElement()) {
            this.composeStringCore("unit", element.getUnitElement(), false);
            this.composeStringExtras("unit", element.getUnitElement(), false);
        }
        if (element.hasSystemElement()) {
            this.composeUriCore("system", element.getSystemElement(), false);
            this.composeUriExtras("system", element.getSystemElement(), false);
        }
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
    }

    protected void composeAge(String name, Age element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAgeInner(element);
            this.close();
        }
    }

    protected void composeAgeInner(Age element) throws IOException {
        this.composeElement(element);
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
        if (element.hasComparatorElement()) {
            this.composeEnumerationCore("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
            this.composeEnumerationExtras("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
        }
        if (element.hasUnitElement()) {
            this.composeStringCore("unit", element.getUnitElement(), false);
            this.composeStringExtras("unit", element.getUnitElement(), false);
        }
        if (element.hasSystemElement()) {
            this.composeUriCore("system", element.getSystemElement(), false);
            this.composeUriExtras("system", element.getSystemElement(), false);
        }
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
    }

    protected void composeHumanName(String name, HumanName element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeHumanNameInner(element);
            this.close();
        }
    }

    protected void composeHumanNameInner(HumanName element) throws IOException {
        this.composeElement(element);
        if (element.hasUseElement()) {
            this.composeEnumerationCore("use", element.getUseElement(), new HumanName.NameUseEnumFactory(), false);
            this.composeEnumerationExtras("use", element.getUseElement(), new HumanName.NameUseEnumFactory(), false);
        }
        if (element.hasTextElement()) {
            this.composeStringCore("text", element.getTextElement(), false);
            this.composeStringExtras("text", element.getTextElement(), false);
        }
        if (element.hasFamily()) {
            this.openArray("family");
            for (StringType e : element.getFamily()) {
                this.composeStringCore(null, e, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getFamily())) {
                this.openArray("_family");
                for (StringType e : element.getFamily()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasGiven()) {
            this.openArray("given");
            for (StringType e : element.getGiven()) {
                this.composeStringCore(null, e, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getGiven())) {
                this.openArray("_given");
                for (StringType e : element.getGiven()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasPrefix()) {
            this.openArray("prefix");
            for (StringType e : element.getPrefix()) {
                this.composeStringCore(null, e, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getPrefix())) {
                this.openArray("_prefix");
                for (StringType e : element.getPrefix()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasSuffix()) {
            this.openArray("suffix");
            for (StringType e : element.getSuffix()) {
                this.composeStringCore(null, e, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getSuffix())) {
                this.openArray("_suffix");
                for (StringType e : element.getSuffix()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasPeriod()) {
            this.composePeriod("period", element.getPeriod());
        }
    }

    protected void composeContactPoint(String name, ContactPoint element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeContactPointInner(element);
            this.close();
        }
    }

    protected void composeContactPointInner(ContactPoint element) throws IOException {
        this.composeElement(element);
        if (element.hasSystemElement()) {
            this.composeEnumerationCore("system", element.getSystemElement(), new ContactPoint.ContactPointSystemEnumFactory(), false);
            this.composeEnumerationExtras("system", element.getSystemElement(), new ContactPoint.ContactPointSystemEnumFactory(), false);
        }
        if (element.hasValueElement()) {
            this.composeStringCore("value", element.getValueElement(), false);
            this.composeStringExtras("value", element.getValueElement(), false);
        }
        if (element.hasUseElement()) {
            this.composeEnumerationCore("use", element.getUseElement(), new ContactPoint.ContactPointUseEnumFactory(), false);
            this.composeEnumerationExtras("use", element.getUseElement(), new ContactPoint.ContactPointUseEnumFactory(), false);
        }
        if (element.hasRankElement()) {
            this.composePositiveIntCore("rank", element.getRankElement(), false);
            this.composePositiveIntExtras("rank", element.getRankElement(), false);
        }
        if (element.hasPeriod()) {
            this.composePeriod("period", element.getPeriod());
        }
    }

    protected void composeMeta(String name, Meta element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeMetaInner(element);
            this.close();
        }
    }

    protected void composeMetaInner(Meta element) throws IOException {
        this.composeElement(element);
        if (element.hasVersionIdElement()) {
            this.composeIdCore("versionId", element.getVersionIdElement(), false);
            this.composeIdExtras("versionId", element.getVersionIdElement(), false);
        }
        if (element.hasLastUpdatedElement()) {
            this.composeInstantCore("lastUpdated", element.getLastUpdatedElement(), false);
            this.composeInstantExtras("lastUpdated", element.getLastUpdatedElement(), false);
        }
        if (element.hasProfile()) {
            this.openArray("profile");
            for (UriType uriType : element.getProfile()) {
                this.composeUriCore(null, uriType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getProfile())) {
                this.openArray("_profile");
                for (UriType uriType : element.getProfile()) {
                    this.composeUriExtras(null, uriType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasSecurity()) {
            this.openArray("security");
            for (Coding coding : element.getSecurity()) {
                this.composeCoding(null, coding);
            }
            this.closeArray();
        }
        if (element.hasTag()) {
            this.openArray("tag");
            for (Coding coding : element.getTag()) {
                this.composeCoding(null, coding);
            }
            this.closeArray();
        }
    }

    protected void composeAddress(String name, Address element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAddressInner(element);
            this.close();
        }
    }

    protected void composeAddressInner(Address element) throws IOException {
        this.composeElement(element);
        if (element.hasUseElement()) {
            this.composeEnumerationCore("use", element.getUseElement(), new Address.AddressUseEnumFactory(), false);
            this.composeEnumerationExtras("use", element.getUseElement(), new Address.AddressUseEnumFactory(), false);
        }
        if (element.hasTypeElement()) {
            this.composeEnumerationCore("type", element.getTypeElement(), new Address.AddressTypeEnumFactory(), false);
            this.composeEnumerationExtras("type", element.getTypeElement(), new Address.AddressTypeEnumFactory(), false);
        }
        if (element.hasTextElement()) {
            this.composeStringCore("text", element.getTextElement(), false);
            this.composeStringExtras("text", element.getTextElement(), false);
        }
        if (element.hasLine()) {
            this.openArray("line");
            for (StringType e : element.getLine()) {
                this.composeStringCore(null, e, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getLine())) {
                this.openArray("_line");
                for (StringType e : element.getLine()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasCityElement()) {
            this.composeStringCore("city", element.getCityElement(), false);
            this.composeStringExtras("city", element.getCityElement(), false);
        }
        if (element.hasDistrictElement()) {
            this.composeStringCore("district", element.getDistrictElement(), false);
            this.composeStringExtras("district", element.getDistrictElement(), false);
        }
        if (element.hasStateElement()) {
            this.composeStringCore("state", element.getStateElement(), false);
            this.composeStringExtras("state", element.getStateElement(), false);
        }
        if (element.hasPostalCodeElement()) {
            this.composeStringCore("postalCode", element.getPostalCodeElement(), false);
            this.composeStringExtras("postalCode", element.getPostalCodeElement(), false);
        }
        if (element.hasCountryElement()) {
            this.composeStringCore("country", element.getCountryElement(), false);
            this.composeStringExtras("country", element.getCountryElement(), false);
        }
        if (element.hasPeriod()) {
            this.composePeriod("period", element.getPeriod());
        }
    }

    protected void composeTiming(String name, Timing element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeTimingInner(element);
            this.close();
        }
    }

    protected void composeTimingInner(Timing element) throws IOException {
        this.composeElement(element);
        if (element.hasEvent()) {
            this.openArray("event");
            for (DateTimeType e : element.getEvent()) {
                this.composeDateTimeCore(null, e, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getEvent())) {
                this.openArray("_event");
                for (DateTimeType e : element.getEvent()) {
                    this.composeDateTimeExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasRepeat()) {
            this.composeTimingTimingRepeatComponent("repeat", element.getRepeat());
        }
        if (element.hasCode()) {
            this.composeCodeableConcept("code", element.getCode());
        }
    }

    protected void composeTimingTimingRepeatComponent(String name, Timing.TimingRepeatComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeTimingTimingRepeatComponentInner(element);
            this.close();
        }
    }

    protected void composeTimingTimingRepeatComponentInner(Timing.TimingRepeatComponent element) throws IOException {
        this.composeElement(element);
        if (element.hasBounds()) {
            this.composeType("bounds", element.getBounds());
        }
        if (element.hasCountElement()) {
            this.composeIntegerCore("count", element.getCountElement(), false);
            this.composeIntegerExtras("count", element.getCountElement(), false);
        }
        if (element.hasDurationElement()) {
            this.composeDecimalCore("duration", element.getDurationElement(), false);
            this.composeDecimalExtras("duration", element.getDurationElement(), false);
        }
        if (element.hasDurationMaxElement()) {
            this.composeDecimalCore("durationMax", element.getDurationMaxElement(), false);
            this.composeDecimalExtras("durationMax", element.getDurationMaxElement(), false);
        }
        if (element.hasDurationUnitsElement()) {
            this.composeEnumerationCore("durationUnits", element.getDurationUnitsElement(), new Timing.UnitsOfTimeEnumFactory(), false);
            this.composeEnumerationExtras("durationUnits", element.getDurationUnitsElement(), new Timing.UnitsOfTimeEnumFactory(), false);
        }
        if (element.hasFrequencyElement()) {
            this.composeIntegerCore("frequency", element.getFrequencyElement(), false);
            this.composeIntegerExtras("frequency", element.getFrequencyElement(), false);
        }
        if (element.hasFrequencyMaxElement()) {
            this.composeIntegerCore("frequencyMax", element.getFrequencyMaxElement(), false);
            this.composeIntegerExtras("frequencyMax", element.getFrequencyMaxElement(), false);
        }
        if (element.hasPeriodElement()) {
            this.composeDecimalCore("period", element.getPeriodElement(), false);
            this.composeDecimalExtras("period", element.getPeriodElement(), false);
        }
        if (element.hasPeriodMaxElement()) {
            this.composeDecimalCore("periodMax", element.getPeriodMaxElement(), false);
            this.composeDecimalExtras("periodMax", element.getPeriodMaxElement(), false);
        }
        if (element.hasPeriodUnitsElement()) {
            this.composeEnumerationCore("periodUnits", element.getPeriodUnitsElement(), new Timing.UnitsOfTimeEnumFactory(), false);
            this.composeEnumerationExtras("periodUnits", element.getPeriodUnitsElement(), new Timing.UnitsOfTimeEnumFactory(), false);
        }
        if (element.hasWhenElement()) {
            this.composeEnumerationCore("when", element.getWhenElement(), new Timing.EventTimingEnumFactory(), false);
            this.composeEnumerationExtras("when", element.getWhenElement(), new Timing.EventTimingEnumFactory(), false);
        }
    }

    protected void composeElementDefinition(String name, ElementDefinition element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeElementDefinitionInner(element);
            this.close();
        }
    }

    protected void composeElementDefinitionInner(ElementDefinition element) throws IOException {
        this.composeElement(element);
        if (element.hasPathElement()) {
            this.composeStringCore("path", element.getPathElement(), false);
            this.composeStringExtras("path", element.getPathElement(), false);
        }
        if (element.hasRepresentation()) {
            this.openArray("representation");
            for (Enumeration<ElementDefinition.PropertyRepresentation> enumeration : element.getRepresentation()) {
                this.composeEnumerationCore(null, enumeration, new ElementDefinition.PropertyRepresentationEnumFactory(), true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getRepresentation())) {
                this.openArray("_representation");
                for (Enumeration enumeration : element.getRepresentation()) {
                    this.composeEnumerationExtras(null, enumeration, new ElementDefinition.PropertyRepresentationEnumFactory(), true);
                }
                this.closeArray();
            }
        }
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasLabelElement()) {
            this.composeStringCore("label", element.getLabelElement(), false);
            this.composeStringExtras("label", element.getLabelElement(), false);
        }
        if (element.hasCode()) {
            this.openArray("code");
            for (Coding coding : element.getCode()) {
                this.composeCoding(null, coding);
            }
            this.closeArray();
        }
        if (element.hasSlicing()) {
            this.composeElementDefinitionElementDefinitionSlicingComponent("slicing", element.getSlicing());
        }
        if (element.hasShortElement()) {
            this.composeStringCore("short", element.getShortElement(), false);
            this.composeStringExtras("short", element.getShortElement(), false);
        }
        if (element.hasDefinitionElement()) {
            this.composeMarkdownCore("definition", element.getDefinitionElement(), false);
            this.composeMarkdownExtras("definition", element.getDefinitionElement(), false);
        }
        if (element.hasCommentsElement()) {
            this.composeMarkdownCore("comments", element.getCommentsElement(), false);
            this.composeMarkdownExtras("comments", element.getCommentsElement(), false);
        }
        if (element.hasRequirementsElement()) {
            this.composeMarkdownCore("requirements", element.getRequirementsElement(), false);
            this.composeMarkdownExtras("requirements", element.getRequirementsElement(), false);
        }
        if (element.hasAlias()) {
            this.openArray("alias");
            for (StringType stringType : element.getAlias()) {
                this.composeStringCore(null, stringType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getAlias())) {
                this.openArray("_alias");
                for (StringType stringType : element.getAlias()) {
                    this.composeStringExtras(null, stringType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasMinElement()) {
            this.composeIntegerCore("min", element.getMinElement(), false);
            this.composeIntegerExtras("min", element.getMinElement(), false);
        }
        if (element.hasMaxElement()) {
            this.composeStringCore("max", element.getMaxElement(), false);
            this.composeStringExtras("max", element.getMaxElement(), false);
        }
        if (element.hasBase()) {
            this.composeElementDefinitionElementDefinitionBaseComponent("base", element.getBase());
        }
        if (element.hasType()) {
            this.openArray("type");
            for (ElementDefinition.TypeRefComponent typeRefComponent : element.getType()) {
                this.composeElementDefinitionTypeRefComponent(null, typeRefComponent);
            }
            this.closeArray();
        }
        if (element.hasNameReferenceElement()) {
            this.composeStringCore("nameReference", element.getNameReferenceElement(), false);
            this.composeStringExtras("nameReference", element.getNameReferenceElement(), false);
        }
        if (element.hasDefaultValue()) {
            this.composeType("defaultValue", element.getDefaultValue());
        }
        if (element.hasMeaningWhenMissingElement()) {
            this.composeMarkdownCore("meaningWhenMissing", element.getMeaningWhenMissingElement(), false);
            this.composeMarkdownExtras("meaningWhenMissing", element.getMeaningWhenMissingElement(), false);
        }
        if (element.hasFixed()) {
            this.composeType("fixed", element.getFixed());
        }
        if (element.hasPattern()) {
            this.composeType("pattern", element.getPattern());
        }
        if (element.hasExample()) {
            this.composeType("example", element.getExample());
        }
        if (element.hasMinValue()) {
            this.composeType("minValue", element.getMinValue());
        }
        if (element.hasMaxValue()) {
            this.composeType("maxValue", element.getMaxValue());
        }
        if (element.hasMaxLengthElement()) {
            this.composeIntegerCore("maxLength", element.getMaxLengthElement(), false);
            this.composeIntegerExtras("maxLength", element.getMaxLengthElement(), false);
        }
        if (element.hasCondition()) {
            this.openArray("condition");
            for (IdType idType : element.getCondition()) {
                this.composeIdCore(null, idType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getCondition())) {
                this.openArray("_condition");
                for (IdType idType : element.getCondition()) {
                    this.composeIdExtras(null, idType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasConstraint()) {
            this.openArray("constraint");
            for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : element.getConstraint()) {
                this.composeElementDefinitionElementDefinitionConstraintComponent(null, elementDefinitionConstraintComponent);
            }
            this.closeArray();
        }
        if (element.hasMustSupportElement()) {
            this.composeBooleanCore("mustSupport", element.getMustSupportElement(), false);
            this.composeBooleanExtras("mustSupport", element.getMustSupportElement(), false);
        }
        if (element.hasIsModifierElement()) {
            this.composeBooleanCore("isModifier", element.getIsModifierElement(), false);
            this.composeBooleanExtras("isModifier", element.getIsModifierElement(), false);
        }
        if (element.hasIsSummaryElement()) {
            this.composeBooleanCore("isSummary", element.getIsSummaryElement(), false);
            this.composeBooleanExtras("isSummary", element.getIsSummaryElement(), false);
        }
        if (element.hasBinding()) {
            this.composeElementDefinitionElementDefinitionBindingComponent("binding", element.getBinding());
        }
        if (element.hasMapping()) {
            this.openArray("mapping");
            for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : element.getMapping()) {
                this.composeElementDefinitionElementDefinitionMappingComponent(null, elementDefinitionMappingComponent);
            }
            this.closeArray();
        }
    }

    protected void composeElementDefinitionElementDefinitionSlicingComponent(String name, ElementDefinition.ElementDefinitionSlicingComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeElementDefinitionElementDefinitionSlicingComponentInner(element);
            this.close();
        }
    }

    protected void composeElementDefinitionElementDefinitionSlicingComponentInner(ElementDefinition.ElementDefinitionSlicingComponent element) throws IOException {
        this.composeElement(element);
        if (element.hasDiscriminator()) {
            this.openArray("discriminator");
            for (StringType e : element.getDiscriminator()) {
                this.composeStringCore(null, e, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getDiscriminator())) {
                this.openArray("_discriminator");
                for (StringType e : element.getDiscriminator()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasOrderedElement()) {
            this.composeBooleanCore("ordered", element.getOrderedElement(), false);
            this.composeBooleanExtras("ordered", element.getOrderedElement(), false);
        }
        if (element.hasRulesElement()) {
            this.composeEnumerationCore("rules", element.getRulesElement(), new ElementDefinition.SlicingRulesEnumFactory(), false);
            this.composeEnumerationExtras("rules", element.getRulesElement(), new ElementDefinition.SlicingRulesEnumFactory(), false);
        }
    }

    protected void composeElementDefinitionElementDefinitionBaseComponent(String name, ElementDefinition.ElementDefinitionBaseComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeElementDefinitionElementDefinitionBaseComponentInner(element);
            this.close();
        }
    }

    protected void composeElementDefinitionElementDefinitionBaseComponentInner(ElementDefinition.ElementDefinitionBaseComponent element) throws IOException {
        this.composeElement(element);
        if (element.hasPathElement()) {
            this.composeStringCore("path", element.getPathElement(), false);
            this.composeStringExtras("path", element.getPathElement(), false);
        }
        if (element.hasMinElement()) {
            this.composeIntegerCore("min", element.getMinElement(), false);
            this.composeIntegerExtras("min", element.getMinElement(), false);
        }
        if (element.hasMaxElement()) {
            this.composeStringCore("max", element.getMaxElement(), false);
            this.composeStringExtras("max", element.getMaxElement(), false);
        }
    }

    protected void composeElementDefinitionTypeRefComponent(String name, ElementDefinition.TypeRefComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeElementDefinitionTypeRefComponentInner(element);
            this.close();
        }
    }

    protected void composeElementDefinitionTypeRefComponentInner(ElementDefinition.TypeRefComponent element) throws IOException {
        this.composeElement(element);
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
        if (element.hasProfile()) {
            this.openArray("profile");
            for (UriType uriType : element.getProfile()) {
                this.composeUriCore(null, uriType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getProfile())) {
                this.openArray("_profile");
                for (UriType uriType : element.getProfile()) {
                    this.composeUriExtras(null, uriType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasAggregation()) {
            this.openArray("aggregation");
            for (Enumeration enumeration : element.getAggregation()) {
                this.composeEnumerationCore(null, enumeration, new ElementDefinition.AggregationModeEnumFactory(), true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getAggregation())) {
                this.openArray("_aggregation");
                for (Enumeration enumeration : element.getAggregation()) {
                    this.composeEnumerationExtras(null, enumeration, new ElementDefinition.AggregationModeEnumFactory(), true);
                }
                this.closeArray();
            }
        }
    }

    protected void composeElementDefinitionElementDefinitionConstraintComponent(String name, ElementDefinition.ElementDefinitionConstraintComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeElementDefinitionElementDefinitionConstraintComponentInner(element);
            this.close();
        }
    }

    protected void composeElementDefinitionElementDefinitionConstraintComponentInner(ElementDefinition.ElementDefinitionConstraintComponent element) throws IOException {
        this.composeElement(element);
        if (element.hasKeyElement()) {
            this.composeIdCore("key", element.getKeyElement(), false);
            this.composeIdExtras("key", element.getKeyElement(), false);
        }
        if (element.hasRequirementsElement()) {
            this.composeStringCore("requirements", element.getRequirementsElement(), false);
            this.composeStringExtras("requirements", element.getRequirementsElement(), false);
        }
        if (element.hasSeverityElement()) {
            this.composeEnumerationCore("severity", element.getSeverityElement(), new ElementDefinition.ConstraintSeverityEnumFactory(), false);
            this.composeEnumerationExtras("severity", element.getSeverityElement(), new ElementDefinition.ConstraintSeverityEnumFactory(), false);
        }
        if (element.hasHumanElement()) {
            this.composeStringCore("human", element.getHumanElement(), false);
            this.composeStringExtras("human", element.getHumanElement(), false);
        }
        if (element.hasXpathElement()) {
            this.composeStringCore("xpath", element.getXpathElement(), false);
            this.composeStringExtras("xpath", element.getXpathElement(), false);
        }
    }

    protected void composeElementDefinitionElementDefinitionBindingComponent(String name, ElementDefinition.ElementDefinitionBindingComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeElementDefinitionElementDefinitionBindingComponentInner(element);
            this.close();
        }
    }

    protected void composeElementDefinitionElementDefinitionBindingComponentInner(ElementDefinition.ElementDefinitionBindingComponent element) throws IOException {
        this.composeElement(element);
        if (element.hasStrengthElement()) {
            this.composeEnumerationCore("strength", element.getStrengthElement(), new Enumerations.BindingStrengthEnumFactory(), false);
            this.composeEnumerationExtras("strength", element.getStrengthElement(), new Enumerations.BindingStrengthEnumFactory(), false);
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasValueSet()) {
            this.composeType("valueSet", element.getValueSet());
        }
    }

    protected void composeElementDefinitionElementDefinitionMappingComponent(String name, ElementDefinition.ElementDefinitionMappingComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeElementDefinitionElementDefinitionMappingComponentInner(element);
            this.close();
        }
    }

    protected void composeElementDefinitionElementDefinitionMappingComponentInner(ElementDefinition.ElementDefinitionMappingComponent element) throws IOException {
        this.composeElement(element);
        if (element.hasIdentityElement()) {
            this.composeIdCore("identity", element.getIdentityElement(), false);
            this.composeIdExtras("identity", element.getIdentityElement(), false);
        }
        if (element.hasLanguageElement()) {
            this.composeCodeCore("language", element.getLanguageElement(), false);
            this.composeCodeExtras("language", element.getLanguageElement(), false);
        }
        if (element.hasMapElement()) {
            this.composeStringCore("map", element.getMapElement(), false);
            this.composeStringExtras("map", element.getMapElement(), false);
        }
    }

    protected void composeDomainResourceElements(DomainResource element) throws IOException {
        this.composeResourceElements(element);
        if (element.hasText()) {
            this.composeNarrative("text", element.getText());
        }
        if (element.hasContained()) {
            this.openArray("contained");
            for (Resource resource : element.getContained()) {
                this.open(null);
                this.composeResource(resource);
                this.close();
            }
            this.closeArray();
        }
        if (element.hasExtension()) {
            this.openArray("extension");
            for (Extension extension : element.getExtension()) {
                this.composeExtension(null, extension);
            }
            this.closeArray();
        }
        if (element.hasModifierExtension()) {
            this.openArray("modifierExtension");
            for (Extension extension : element.getModifierExtension()) {
                this.composeExtension(null, extension);
            }
            this.closeArray();
        }
    }

    protected void composeParameters(String name, Parameters element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeParametersInner(element);
        }
    }

    protected void composeParametersInner(Parameters element) throws IOException {
        this.composeResourceElements(element);
        if (element.hasParameter()) {
            this.openArray("parameter");
            for (Parameters.ParametersParameterComponent e : element.getParameter()) {
                this.composeParametersParametersParameterComponent(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeParametersParametersParameterComponent(String name, Parameters.ParametersParameterComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeParametersParametersParameterComponentInner(element);
            this.close();
        }
    }

    protected void composeParametersParametersParameterComponentInner(Parameters.ParametersParameterComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasValue()) {
            this.composeType("value", element.getValue());
        }
        if (element.hasResource()) {
            this.open("resource");
            this.composeResource(element.getResource());
            this.close();
        }
        if (element.hasPart()) {
            this.openArray("part");
            for (Parameters.ParametersParameterComponent e : element.getPart()) {
                this.composeParametersParametersParameterComponent(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeResourceElements(Resource element) throws IOException {
        if (element.hasIdElement()) {
            this.composeIdCore("id", element.getIdElement(), false);
            this.composeIdExtras("id", element.getIdElement(), false);
        }
        if (element.hasMeta()) {
            this.composeMeta("meta", element.getMeta());
        }
        if (element.hasImplicitRulesElement()) {
            this.composeUriCore("implicitRules", element.getImplicitRulesElement(), false);
            this.composeUriExtras("implicitRules", element.getImplicitRulesElement(), false);
        }
        if (element.hasLanguageElement()) {
            this.composeCodeCore("language", element.getLanguageElement(), false);
            this.composeCodeExtras("language", element.getLanguageElement(), false);
        }
    }

    protected void composeAccount(String name, Account element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeAccountInner(element);
        }
    }

    protected void composeAccountInner(Account element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier e : element.getIdentifier()) {
                this.composeIdentifier(null, e);
            }
            this.closeArray();
        }
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasType()) {
            this.composeCodeableConcept("type", element.getType());
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new Account.AccountStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new Account.AccountStatusEnumFactory(), false);
        }
        if (element.hasActivePeriod()) {
            this.composePeriod("activePeriod", element.getActivePeriod());
        }
        if (element.hasCurrency()) {
            this.composeCoding("currency", element.getCurrency());
        }
        if (element.hasBalance()) {
            this.composeMoney("balance", element.getBalance());
        }
        if (element.hasCoveragePeriod()) {
            this.composePeriod("coveragePeriod", element.getCoveragePeriod());
        }
        if (element.hasSubject()) {
            this.composeReference("subject", element.getSubject());
        }
        if (element.hasOwner()) {
            this.composeReference("owner", element.getOwner());
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
    }

    protected void composeAllergyIntolerance(String name, AllergyIntolerance element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeAllergyIntoleranceInner(element);
        }
    }

    protected void composeAllergyIntoleranceInner(AllergyIntolerance element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasOnsetElement()) {
            this.composeDateTimeCore("onset", element.getOnsetElement(), false);
            this.composeDateTimeExtras("onset", element.getOnsetElement(), false);
        }
        if (element.hasRecordedDateElement()) {
            this.composeDateTimeCore("recordedDate", element.getRecordedDateElement(), false);
            this.composeDateTimeExtras("recordedDate", element.getRecordedDateElement(), false);
        }
        if (element.hasRecorder()) {
            this.composeReference("recorder", element.getRecorder());
        }
        if (element.hasPatient()) {
            this.composeReference("patient", element.getPatient());
        }
        if (element.hasReporter()) {
            this.composeReference("reporter", element.getReporter());
        }
        if (element.hasSubstance()) {
            this.composeCodeableConcept("substance", element.getSubstance());
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new AllergyIntolerance.AllergyIntoleranceStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new AllergyIntolerance.AllergyIntoleranceStatusEnumFactory(), false);
        }
        if (element.hasCriticalityElement()) {
            this.composeEnumerationCore("criticality", element.getCriticalityElement(), new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory(), false);
            this.composeEnumerationExtras("criticality", element.getCriticalityElement(), new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory(), false);
        }
        if (element.hasTypeElement()) {
            this.composeEnumerationCore("type", element.getTypeElement(), new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory(), false);
            this.composeEnumerationExtras("type", element.getTypeElement(), new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory(), false);
        }
        if (element.hasCategoryElement()) {
            this.composeEnumerationCore("category", element.getCategoryElement(), new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory(), false);
            this.composeEnumerationExtras("category", element.getCategoryElement(), new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory(), false);
        }
        if (element.hasLastOccurenceElement()) {
            this.composeDateTimeCore("lastOccurence", element.getLastOccurenceElement(), false);
            this.composeDateTimeExtras("lastOccurence", element.getLastOccurenceElement(), false);
        }
        if (element.hasNote()) {
            this.composeAnnotation("note", element.getNote());
        }
        if (element.hasReaction()) {
            this.openArray("reaction");
            for (AllergyIntolerance.AllergyIntoleranceReactionComponent allergyIntoleranceReactionComponent : element.getReaction()) {
                this.composeAllergyIntoleranceAllergyIntoleranceReactionComponent(null, allergyIntoleranceReactionComponent);
            }
            this.closeArray();
        }
    }

    protected void composeAllergyIntoleranceAllergyIntoleranceReactionComponent(String name, AllergyIntolerance.AllergyIntoleranceReactionComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAllergyIntoleranceAllergyIntoleranceReactionComponentInner(element);
            this.close();
        }
    }

    protected void composeAllergyIntoleranceAllergyIntoleranceReactionComponentInner(AllergyIntolerance.AllergyIntoleranceReactionComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSubstance()) {
            this.composeCodeableConcept("substance", element.getSubstance());
        }
        if (element.hasCertaintyElement()) {
            this.composeEnumerationCore("certainty", element.getCertaintyElement(), new AllergyIntolerance.AllergyIntoleranceCertaintyEnumFactory(), false);
            this.composeEnumerationExtras("certainty", element.getCertaintyElement(), new AllergyIntolerance.AllergyIntoleranceCertaintyEnumFactory(), false);
        }
        if (element.hasManifestation()) {
            this.openArray("manifestation");
            for (CodeableConcept e : element.getManifestation()) {
                this.composeCodeableConcept(null, e);
            }
            this.closeArray();
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasOnsetElement()) {
            this.composeDateTimeCore("onset", element.getOnsetElement(), false);
            this.composeDateTimeExtras("onset", element.getOnsetElement(), false);
        }
        if (element.hasSeverityElement()) {
            this.composeEnumerationCore("severity", element.getSeverityElement(), new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory(), false);
            this.composeEnumerationExtras("severity", element.getSeverityElement(), new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory(), false);
        }
        if (element.hasExposureRoute()) {
            this.composeCodeableConcept("exposureRoute", element.getExposureRoute());
        }
        if (element.hasNote()) {
            this.composeAnnotation("note", element.getNote());
        }
    }

    protected void composeAppointment(String name, Appointment element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeAppointmentInner(element);
        }
    }

    protected void composeAppointmentInner(Appointment element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new Appointment.AppointmentStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new Appointment.AppointmentStatusEnumFactory(), false);
        }
        if (element.hasType()) {
            this.composeCodeableConcept("type", element.getType());
        }
        if (element.hasReason()) {
            this.composeCodeableConcept("reason", element.getReason());
        }
        if (element.hasPriorityElement()) {
            this.composeUnsignedIntCore("priority", element.getPriorityElement(), false);
            this.composeUnsignedIntExtras("priority", element.getPriorityElement(), false);
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasStartElement()) {
            this.composeInstantCore("start", element.getStartElement(), false);
            this.composeInstantExtras("start", element.getStartElement(), false);
        }
        if (element.hasEndElement()) {
            this.composeInstantCore("end", element.getEndElement(), false);
            this.composeInstantExtras("end", element.getEndElement(), false);
        }
        if (element.hasMinutesDurationElement()) {
            this.composePositiveIntCore("minutesDuration", element.getMinutesDurationElement(), false);
            this.composePositiveIntExtras("minutesDuration", element.getMinutesDurationElement(), false);
        }
        if (element.hasSlot()) {
            this.openArray("slot");
            for (Reference reference : element.getSlot()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasCommentElement()) {
            this.composeStringCore("comment", element.getCommentElement(), false);
            this.composeStringExtras("comment", element.getCommentElement(), false);
        }
        if (element.hasParticipant()) {
            this.openArray("participant");
            for (Appointment.AppointmentParticipantComponent appointmentParticipantComponent : element.getParticipant()) {
                this.composeAppointmentAppointmentParticipantComponent(null, appointmentParticipantComponent);
            }
            this.closeArray();
        }
    }

    protected void composeAppointmentAppointmentParticipantComponent(String name, Appointment.AppointmentParticipantComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAppointmentAppointmentParticipantComponentInner(element);
            this.close();
        }
    }

    protected void composeAppointmentAppointmentParticipantComponentInner(Appointment.AppointmentParticipantComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasType()) {
            this.openArray("type");
            for (CodeableConcept e : element.getType()) {
                this.composeCodeableConcept(null, e);
            }
            this.closeArray();
        }
        if (element.hasActor()) {
            this.composeReference("actor", element.getActor());
        }
        if (element.hasRequiredElement()) {
            this.composeEnumerationCore("required", element.getRequiredElement(), new Appointment.ParticipantRequiredEnumFactory(), false);
            this.composeEnumerationExtras("required", element.getRequiredElement(), new Appointment.ParticipantRequiredEnumFactory(), false);
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new Appointment.ParticipationStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new Appointment.ParticipationStatusEnumFactory(), false);
        }
    }

    protected void composeAppointmentResponse(String name, AppointmentResponse element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeAppointmentResponseInner(element);
        }
    }

    protected void composeAppointmentResponseInner(AppointmentResponse element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasAppointment()) {
            this.composeReference("appointment", element.getAppointment());
        }
        if (element.hasStartElement()) {
            this.composeInstantCore("start", element.getStartElement(), false);
            this.composeInstantExtras("start", element.getStartElement(), false);
        }
        if (element.hasEndElement()) {
            this.composeInstantCore("end", element.getEndElement(), false);
            this.composeInstantExtras("end", element.getEndElement(), false);
        }
        if (element.hasParticipantType()) {
            this.openArray("participantType");
            for (CodeableConcept codeableConcept : element.getParticipantType()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasActor()) {
            this.composeReference("actor", element.getActor());
        }
        if (element.hasParticipantStatusElement()) {
            this.composeEnumerationCore("participantStatus", element.getParticipantStatusElement(), new AppointmentResponse.ParticipantStatusEnumFactory(), false);
            this.composeEnumerationExtras("participantStatus", element.getParticipantStatusElement(), new AppointmentResponse.ParticipantStatusEnumFactory(), false);
        }
        if (element.hasCommentElement()) {
            this.composeStringCore("comment", element.getCommentElement(), false);
            this.composeStringExtras("comment", element.getCommentElement(), false);
        }
    }

    protected void composeAuditEvent(String name, AuditEvent element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeAuditEventInner(element);
        }
    }

    protected void composeAuditEventInner(AuditEvent element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasEvent()) {
            this.composeAuditEventAuditEventEventComponent("event", element.getEvent());
        }
        if (element.hasParticipant()) {
            this.openArray("participant");
            for (AuditEvent.AuditEventParticipantComponent auditEventParticipantComponent : element.getParticipant()) {
                this.composeAuditEventAuditEventParticipantComponent(null, auditEventParticipantComponent);
            }
            this.closeArray();
        }
        if (element.hasSource()) {
            this.composeAuditEventAuditEventSourceComponent("source", element.getSource());
        }
        if (element.hasObject()) {
            this.openArray("object");
            for (AuditEvent.AuditEventObjectComponent auditEventObjectComponent : element.getObject()) {
                this.composeAuditEventAuditEventObjectComponent(null, auditEventObjectComponent);
            }
            this.closeArray();
        }
    }

    protected void composeAuditEventAuditEventEventComponent(String name, AuditEvent.AuditEventEventComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAuditEventAuditEventEventComponentInner(element);
            this.close();
        }
    }

    protected void composeAuditEventAuditEventEventComponentInner(AuditEvent.AuditEventEventComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasType()) {
            this.composeCoding("type", element.getType());
        }
        if (element.hasSubtype()) {
            this.openArray("subtype");
            for (Coding e : element.getSubtype()) {
                this.composeCoding(null, e);
            }
            this.closeArray();
        }
        if (element.hasActionElement()) {
            this.composeEnumerationCore("action", element.getActionElement(), new AuditEvent.AuditEventActionEnumFactory(), false);
            this.composeEnumerationExtras("action", element.getActionElement(), new AuditEvent.AuditEventActionEnumFactory(), false);
        }
        if (element.hasDateTimeElement()) {
            this.composeInstantCore("dateTime", element.getDateTimeElement(), false);
            this.composeInstantExtras("dateTime", element.getDateTimeElement(), false);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnumerationCore("outcome", element.getOutcomeElement(), new AuditEvent.AuditEventOutcomeEnumFactory(), false);
            this.composeEnumerationExtras("outcome", element.getOutcomeElement(), new AuditEvent.AuditEventOutcomeEnumFactory(), false);
        }
        if (element.hasOutcomeDescElement()) {
            this.composeStringCore("outcomeDesc", element.getOutcomeDescElement(), false);
            this.composeStringExtras("outcomeDesc", element.getOutcomeDescElement(), false);
        }
        if (element.hasPurposeOfEvent()) {
            this.openArray("purposeOfEvent");
            for (Coding e : element.getPurposeOfEvent()) {
                this.composeCoding(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeAuditEventAuditEventParticipantComponent(String name, AuditEvent.AuditEventParticipantComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAuditEventAuditEventParticipantComponentInner(element);
            this.close();
        }
    }

    protected void composeAuditEventAuditEventParticipantComponentInner(AuditEvent.AuditEventParticipantComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasRole()) {
            this.openArray("role");
            for (CodeableConcept codeableConcept : element.getRole()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasReference()) {
            this.composeReference("reference", element.getReference());
        }
        if (element.hasUserId()) {
            this.composeIdentifier("userId", element.getUserId());
        }
        if (element.hasAltIdElement()) {
            this.composeStringCore("altId", element.getAltIdElement(), false);
            this.composeStringExtras("altId", element.getAltIdElement(), false);
        }
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasRequestorElement()) {
            this.composeBooleanCore("requestor", element.getRequestorElement(), false);
            this.composeBooleanExtras("requestor", element.getRequestorElement(), false);
        }
        if (element.hasLocation()) {
            this.composeReference("location", element.getLocation());
        }
        if (element.hasPolicy()) {
            this.openArray("policy");
            for (UriType uriType : element.getPolicy()) {
                this.composeUriCore(null, uriType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getPolicy())) {
                this.openArray("_policy");
                for (UriType uriType : element.getPolicy()) {
                    this.composeUriExtras(null, uriType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasMedia()) {
            this.composeCoding("media", element.getMedia());
        }
        if (element.hasNetwork()) {
            this.composeAuditEventAuditEventParticipantNetworkComponent("network", element.getNetwork());
        }
        if (element.hasPurposeOfUse()) {
            this.openArray("purposeOfUse");
            for (Coding coding : element.getPurposeOfUse()) {
                this.composeCoding(null, coding);
            }
            this.closeArray();
        }
    }

    protected void composeAuditEventAuditEventParticipantNetworkComponent(String name, AuditEvent.AuditEventParticipantNetworkComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAuditEventAuditEventParticipantNetworkComponentInner(element);
            this.close();
        }
    }

    protected void composeAuditEventAuditEventParticipantNetworkComponentInner(AuditEvent.AuditEventParticipantNetworkComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasAddressElement()) {
            this.composeStringCore("address", element.getAddressElement(), false);
            this.composeStringExtras("address", element.getAddressElement(), false);
        }
        if (element.hasTypeElement()) {
            this.composeEnumerationCore("type", element.getTypeElement(), new AuditEvent.AuditEventParticipantNetworkTypeEnumFactory(), false);
            this.composeEnumerationExtras("type", element.getTypeElement(), new AuditEvent.AuditEventParticipantNetworkTypeEnumFactory(), false);
        }
    }

    protected void composeAuditEventAuditEventSourceComponent(String name, AuditEvent.AuditEventSourceComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAuditEventAuditEventSourceComponentInner(element);
            this.close();
        }
    }

    protected void composeAuditEventAuditEventSourceComponentInner(AuditEvent.AuditEventSourceComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSiteElement()) {
            this.composeStringCore("site", element.getSiteElement(), false);
            this.composeStringExtras("site", element.getSiteElement(), false);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier("identifier", element.getIdentifier());
        }
        if (element.hasType()) {
            this.openArray("type");
            for (Coding e : element.getType()) {
                this.composeCoding(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeAuditEventAuditEventObjectComponent(String name, AuditEvent.AuditEventObjectComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAuditEventAuditEventObjectComponentInner(element);
            this.close();
        }
    }

    protected void composeAuditEventAuditEventObjectComponentInner(AuditEvent.AuditEventObjectComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasIdentifier()) {
            this.composeIdentifier("identifier", element.getIdentifier());
        }
        if (element.hasReference()) {
            this.composeReference("reference", element.getReference());
        }
        if (element.hasType()) {
            this.composeCoding("type", element.getType());
        }
        if (element.hasRole()) {
            this.composeCoding("role", element.getRole());
        }
        if (element.hasLifecycle()) {
            this.composeCoding("lifecycle", element.getLifecycle());
        }
        if (element.hasSecurityLabel()) {
            this.openArray("securityLabel");
            for (Coding coding : element.getSecurityLabel()) {
                this.composeCoding(null, coding);
            }
            this.closeArray();
        }
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasQueryElement()) {
            this.composeBase64BinaryCore("query", element.getQueryElement(), false);
            this.composeBase64BinaryExtras("query", element.getQueryElement(), false);
        }
        if (element.hasDetail()) {
            this.openArray("detail");
            for (AuditEvent.AuditEventObjectDetailComponent auditEventObjectDetailComponent : element.getDetail()) {
                this.composeAuditEventAuditEventObjectDetailComponent(null, auditEventObjectDetailComponent);
            }
            this.closeArray();
        }
    }

    protected void composeAuditEventAuditEventObjectDetailComponent(String name, AuditEvent.AuditEventObjectDetailComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAuditEventAuditEventObjectDetailComponentInner(element);
            this.close();
        }
    }

    protected void composeAuditEventAuditEventObjectDetailComponentInner(AuditEvent.AuditEventObjectDetailComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasTypeElement()) {
            this.composeStringCore("type", element.getTypeElement(), false);
            this.composeStringExtras("type", element.getTypeElement(), false);
        }
        if (element.hasValueElement()) {
            this.composeBase64BinaryCore("value", element.getValueElement(), false);
            this.composeBase64BinaryExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeBasic(String name, Basic element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeBasicInner(element);
        }
    }

    protected void composeBasicInner(Basic element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier e : element.getIdentifier()) {
                this.composeIdentifier(null, e);
            }
            this.closeArray();
        }
        if (element.hasCode()) {
            this.composeCodeableConcept("code", element.getCode());
        }
        if (element.hasSubject()) {
            this.composeReference("subject", element.getSubject());
        }
        if (element.hasAuthor()) {
            this.composeReference("author", element.getAuthor());
        }
        if (element.hasCreatedElement()) {
            this.composeDateCore("created", element.getCreatedElement(), false);
            this.composeDateExtras("created", element.getCreatedElement(), false);
        }
    }

    protected void composeBinary(String name, Binary element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeBinaryInner(element);
        }
    }

    protected void composeBinaryInner(Binary element) throws IOException {
        this.composeResourceElements(element);
        if (element.hasContentTypeElement()) {
            this.composeCodeCore("contentType", element.getContentTypeElement(), false);
            this.composeCodeExtras("contentType", element.getContentTypeElement(), false);
        }
        if (element.hasContentElement()) {
            this.composeBase64BinaryCore("content", element.getContentElement(), false);
            this.composeBase64BinaryExtras("content", element.getContentElement(), false);
        }
    }

    protected void composeBodySite(String name, BodySite element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeBodySiteInner(element);
        }
    }

    protected void composeBodySiteInner(BodySite element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasPatient()) {
            this.composeReference("patient", element.getPatient());
        }
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasCode()) {
            this.composeCodeableConcept("code", element.getCode());
        }
        if (element.hasModifier()) {
            this.openArray("modifier");
            for (CodeableConcept codeableConcept : element.getModifier()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasImage()) {
            this.openArray("image");
            for (Attachment attachment : element.getImage()) {
                this.composeAttachment(null, attachment);
            }
            this.closeArray();
        }
    }

    protected void composeBundle(String name, Bundle element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeBundleInner(element);
        }
    }

    protected void composeBundleInner(Bundle element) throws IOException {
        this.composeResourceElements(element);
        if (element.hasTypeElement()) {
            this.composeEnumerationCore("type", element.getTypeElement(), new Bundle.BundleTypeEnumFactory(), false);
            this.composeEnumerationExtras("type", element.getTypeElement(), new Bundle.BundleTypeEnumFactory(), false);
        }
        if (element.hasTotalElement()) {
            this.composeUnsignedIntCore("total", element.getTotalElement(), false);
            this.composeUnsignedIntExtras("total", element.getTotalElement(), false);
        }
        if (element.hasLink()) {
            this.openArray("link");
            for (Bundle.BundleLinkComponent bundleLinkComponent : element.getLink()) {
                this.composeBundleBundleLinkComponent(null, bundleLinkComponent);
            }
            this.closeArray();
        }
        if (element.hasEntry()) {
            this.openArray("entry");
            for (Bundle.BundleEntryComponent bundleEntryComponent : element.getEntry()) {
                this.composeBundleBundleEntryComponent(null, bundleEntryComponent);
            }
            this.closeArray();
        }
        if (element.hasSignature()) {
            this.composeSignature("signature", element.getSignature());
        }
    }

    protected void composeBundleBundleLinkComponent(String name, Bundle.BundleLinkComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeBundleBundleLinkComponentInner(element);
            this.close();
        }
    }

    protected void composeBundleBundleLinkComponentInner(Bundle.BundleLinkComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasRelationElement()) {
            this.composeStringCore("relation", element.getRelationElement(), false);
            this.composeStringExtras("relation", element.getRelationElement(), false);
        }
        if (element.hasUrlElement()) {
            this.composeUriCore("url", element.getUrlElement(), false);
            this.composeUriExtras("url", element.getUrlElement(), false);
        }
    }

    protected void composeBundleBundleEntryComponent(String name, Bundle.BundleEntryComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeBundleBundleEntryComponentInner(element);
            this.close();
        }
    }

    protected void composeBundleBundleEntryComponentInner(Bundle.BundleEntryComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasLink()) {
            this.openArray("link");
            for (Bundle.BundleLinkComponent e : element.getLink()) {
                this.composeBundleBundleLinkComponent(null, e);
            }
            this.closeArray();
        }
        if (element.hasFullUrlElement()) {
            this.composeUriCore("fullUrl", element.getFullUrlElement(), false);
            this.composeUriExtras("fullUrl", element.getFullUrlElement(), false);
        }
        if (element.hasResource()) {
            this.open("resource");
            this.composeResource(element.getResource());
            this.close();
        }
        if (element.hasSearch()) {
            this.composeBundleBundleEntrySearchComponent("search", element.getSearch());
        }
        if (element.hasRequest()) {
            this.composeBundleBundleEntryRequestComponent("request", element.getRequest());
        }
        if (element.hasResponse()) {
            this.composeBundleBundleEntryResponseComponent("response", element.getResponse());
        }
    }

    protected void composeBundleBundleEntrySearchComponent(String name, Bundle.BundleEntrySearchComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeBundleBundleEntrySearchComponentInner(element);
            this.close();
        }
    }

    protected void composeBundleBundleEntrySearchComponentInner(Bundle.BundleEntrySearchComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasModeElement()) {
            this.composeEnumerationCore("mode", element.getModeElement(), new Bundle.SearchEntryModeEnumFactory(), false);
            this.composeEnumerationExtras("mode", element.getModeElement(), new Bundle.SearchEntryModeEnumFactory(), false);
        }
        if (element.hasScoreElement()) {
            this.composeDecimalCore("score", element.getScoreElement(), false);
            this.composeDecimalExtras("score", element.getScoreElement(), false);
        }
    }

    protected void composeBundleBundleEntryRequestComponent(String name, Bundle.BundleEntryRequestComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeBundleBundleEntryRequestComponentInner(element);
            this.close();
        }
    }

    protected void composeBundleBundleEntryRequestComponentInner(Bundle.BundleEntryRequestComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasMethodElement()) {
            this.composeEnumerationCore("method", element.getMethodElement(), new Bundle.HTTPVerbEnumFactory(), false);
            this.composeEnumerationExtras("method", element.getMethodElement(), new Bundle.HTTPVerbEnumFactory(), false);
        }
        if (element.hasUrlElement()) {
            this.composeUriCore("url", element.getUrlElement(), false);
            this.composeUriExtras("url", element.getUrlElement(), false);
        }
        if (element.hasIfNoneMatchElement()) {
            this.composeStringCore("ifNoneMatch", element.getIfNoneMatchElement(), false);
            this.composeStringExtras("ifNoneMatch", element.getIfNoneMatchElement(), false);
        }
        if (element.hasIfModifiedSinceElement()) {
            this.composeInstantCore("ifModifiedSince", element.getIfModifiedSinceElement(), false);
            this.composeInstantExtras("ifModifiedSince", element.getIfModifiedSinceElement(), false);
        }
        if (element.hasIfMatchElement()) {
            this.composeStringCore("ifMatch", element.getIfMatchElement(), false);
            this.composeStringExtras("ifMatch", element.getIfMatchElement(), false);
        }
        if (element.hasIfNoneExistElement()) {
            this.composeStringCore("ifNoneExist", element.getIfNoneExistElement(), false);
            this.composeStringExtras("ifNoneExist", element.getIfNoneExistElement(), false);
        }
    }

    protected void composeBundleBundleEntryResponseComponent(String name, Bundle.BundleEntryResponseComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeBundleBundleEntryResponseComponentInner(element);
            this.close();
        }
    }

    protected void composeBundleBundleEntryResponseComponentInner(Bundle.BundleEntryResponseComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasStatusElement()) {
            this.composeStringCore("status", element.getStatusElement(), false);
            this.composeStringExtras("status", element.getStatusElement(), false);
        }
        if (element.hasLocationElement()) {
            this.composeUriCore("location", element.getLocationElement(), false);
            this.composeUriExtras("location", element.getLocationElement(), false);
        }
        if (element.hasEtagElement()) {
            this.composeStringCore("etag", element.getEtagElement(), false);
            this.composeStringExtras("etag", element.getEtagElement(), false);
        }
        if (element.hasLastModifiedElement()) {
            this.composeInstantCore("lastModified", element.getLastModifiedElement(), false);
            this.composeInstantExtras("lastModified", element.getLastModifiedElement(), false);
        }
    }

    protected void composeCarePlan(String name, CarePlan element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeCarePlanInner(element);
        }
    }

    protected void composeCarePlanInner(CarePlan element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasSubject()) {
            this.composeReference("subject", element.getSubject());
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new CarePlan.CarePlanStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new CarePlan.CarePlanStatusEnumFactory(), false);
        }
        if (element.hasContext()) {
            this.composeReference("context", element.getContext());
        }
        if (element.hasPeriod()) {
            this.composePeriod("period", element.getPeriod());
        }
        if (element.hasAuthor()) {
            this.openArray("author");
            for (Reference reference : element.getAuthor()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasModifiedElement()) {
            this.composeDateTimeCore("modified", element.getModifiedElement(), false);
            this.composeDateTimeExtras("modified", element.getModifiedElement(), false);
        }
        if (element.hasCategory()) {
            this.openArray("category");
            for (CodeableConcept codeableConcept : element.getCategory()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasAddresses()) {
            this.openArray("addresses");
            for (Reference reference : element.getAddresses()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasSupport()) {
            this.openArray("support");
            for (Reference reference : element.getSupport()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasRelatedPlan()) {
            this.openArray("relatedPlan");
            for (CarePlan.CarePlanRelatedPlanComponent carePlanRelatedPlanComponent : element.getRelatedPlan()) {
                this.composeCarePlanCarePlanRelatedPlanComponent(null, carePlanRelatedPlanComponent);
            }
            this.closeArray();
        }
        if (element.hasParticipant()) {
            this.openArray("participant");
            for (CarePlan.CarePlanParticipantComponent carePlanParticipantComponent : element.getParticipant()) {
                this.composeCarePlanCarePlanParticipantComponent(null, carePlanParticipantComponent);
            }
            this.closeArray();
        }
        if (element.hasGoal()) {
            this.openArray("goal");
            for (Reference reference : element.getGoal()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasActivity()) {
            this.openArray("activity");
            for (CarePlan.CarePlanActivityComponent carePlanActivityComponent : element.getActivity()) {
                this.composeCarePlanCarePlanActivityComponent(null, carePlanActivityComponent);
            }
            this.closeArray();
        }
        if (element.hasNote()) {
            this.composeAnnotation("note", element.getNote());
        }
    }

    protected void composeCarePlanCarePlanRelatedPlanComponent(String name, CarePlan.CarePlanRelatedPlanComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCarePlanCarePlanRelatedPlanComponentInner(element);
            this.close();
        }
    }

    protected void composeCarePlanCarePlanRelatedPlanComponentInner(CarePlan.CarePlanRelatedPlanComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCodeElement()) {
            this.composeEnumerationCore("code", element.getCodeElement(), new CarePlan.CarePlanRelationshipEnumFactory(), false);
            this.composeEnumerationExtras("code", element.getCodeElement(), new CarePlan.CarePlanRelationshipEnumFactory(), false);
        }
        if (element.hasPlan()) {
            this.composeReference("plan", element.getPlan());
        }
    }

    protected void composeCarePlanCarePlanParticipantComponent(String name, CarePlan.CarePlanParticipantComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCarePlanCarePlanParticipantComponentInner(element);
            this.close();
        }
    }

    protected void composeCarePlanCarePlanParticipantComponentInner(CarePlan.CarePlanParticipantComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasRole()) {
            this.composeCodeableConcept("role", element.getRole());
        }
        if (element.hasMember()) {
            this.composeReference("member", element.getMember());
        }
    }

    protected void composeCarePlanCarePlanActivityComponent(String name, CarePlan.CarePlanActivityComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCarePlanCarePlanActivityComponentInner(element);
            this.close();
        }
    }

    protected void composeCarePlanCarePlanActivityComponentInner(CarePlan.CarePlanActivityComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasActionResulting()) {
            this.openArray("actionResulting");
            for (Reference reference : element.getActionResulting()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasProgress()) {
            this.openArray("progress");
            for (Annotation annotation : element.getProgress()) {
                this.composeAnnotation(null, annotation);
            }
            this.closeArray();
        }
        if (element.hasReference()) {
            this.composeReference("reference", element.getReference());
        }
        if (element.hasDetail()) {
            this.composeCarePlanCarePlanActivityDetailComponent("detail", element.getDetail());
        }
    }

    protected void composeCarePlanCarePlanActivityDetailComponent(String name, CarePlan.CarePlanActivityDetailComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCarePlanCarePlanActivityDetailComponentInner(element);
            this.close();
        }
    }

    protected void composeCarePlanCarePlanActivityDetailComponentInner(CarePlan.CarePlanActivityDetailComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCategory()) {
            this.composeCodeableConcept("category", element.getCategory());
        }
        if (element.hasCode()) {
            this.composeCodeableConcept("code", element.getCode());
        }
        if (element.hasReasonCode()) {
            this.openArray("reasonCode");
            for (CodeableConcept codeableConcept : element.getReasonCode()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasReasonReference()) {
            this.openArray("reasonReference");
            for (Reference reference : element.getReasonReference()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasGoal()) {
            this.openArray("goal");
            for (Reference reference : element.getGoal()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new CarePlan.CarePlanActivityStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new CarePlan.CarePlanActivityStatusEnumFactory(), false);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept("statusReason", element.getStatusReason());
        }
        if (element.hasProhibitedElement()) {
            this.composeBooleanCore("prohibited", element.getProhibitedElement(), false);
            this.composeBooleanExtras("prohibited", element.getProhibitedElement(), false);
        }
        if (element.hasScheduled()) {
            this.composeType("scheduled", element.getScheduled());
        }
        if (element.hasLocation()) {
            this.composeReference("location", element.getLocation());
        }
        if (element.hasPerformer()) {
            this.openArray("performer");
            for (Reference reference : element.getPerformer()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasProduct()) {
            this.composeType("product", element.getProduct());
        }
        if (element.hasDailyAmount()) {
            this.composeSimpleQuantity("dailyAmount", element.getDailyAmount());
        }
        if (element.hasQuantity()) {
            this.composeSimpleQuantity("quantity", element.getQuantity());
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
    }

    protected void composeClaim(String name, Claim element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeClaimInner(element);
        }
    }

    protected void composeClaimInner(Claim element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasTypeElement()) {
            this.composeEnumerationCore("type", element.getTypeElement(), new Claim.ClaimTypeEnumFactory(), false);
            this.composeEnumerationExtras("type", element.getTypeElement(), new Claim.ClaimTypeEnumFactory(), false);
        }
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasRuleset()) {
            this.composeCoding("ruleset", element.getRuleset());
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding("originalRuleset", element.getOriginalRuleset());
        }
        if (element.hasCreatedElement()) {
            this.composeDateTimeCore("created", element.getCreatedElement(), false);
            this.composeDateTimeExtras("created", element.getCreatedElement(), false);
        }
        if (element.hasTarget()) {
            this.composeReference("target", element.getTarget());
        }
        if (element.hasProvider()) {
            this.composeReference("provider", element.getProvider());
        }
        if (element.hasOrganization()) {
            this.composeReference("organization", element.getOrganization());
        }
        if (element.hasUseElement()) {
            this.composeEnumerationCore("use", element.getUseElement(), new Claim.UseEnumFactory(), false);
            this.composeEnumerationExtras("use", element.getUseElement(), new Claim.UseEnumFactory(), false);
        }
        if (element.hasPriority()) {
            this.composeCoding("priority", element.getPriority());
        }
        if (element.hasFundsReserve()) {
            this.composeCoding("fundsReserve", element.getFundsReserve());
        }
        if (element.hasEnterer()) {
            this.composeReference("enterer", element.getEnterer());
        }
        if (element.hasFacility()) {
            this.composeReference("facility", element.getFacility());
        }
        if (element.hasPrescription()) {
            this.composeReference("prescription", element.getPrescription());
        }
        if (element.hasOriginalPrescription()) {
            this.composeReference("originalPrescription", element.getOriginalPrescription());
        }
        if (element.hasPayee()) {
            this.composeClaimPayeeComponent("payee", element.getPayee());
        }
        if (element.hasReferral()) {
            this.composeReference("referral", element.getReferral());
        }
        if (element.hasDiagnosis()) {
            this.openArray("diagnosis");
            for (Claim.DiagnosisComponent diagnosisComponent : element.getDiagnosis()) {
                this.composeClaimDiagnosisComponent(null, diagnosisComponent);
            }
            this.closeArray();
        }
        if (element.hasCondition()) {
            this.openArray("condition");
            for (Coding coding : element.getCondition()) {
                this.composeCoding(null, coding);
            }
            this.closeArray();
        }
        if (element.hasPatient()) {
            this.composeReference("patient", element.getPatient());
        }
        if (element.hasCoverage()) {
            this.openArray("coverage");
            for (Claim.CoverageComponent coverageComponent : element.getCoverage()) {
                this.composeClaimCoverageComponent(null, coverageComponent);
            }
            this.closeArray();
        }
        if (element.hasException()) {
            this.openArray("exception");
            for (Coding coding : element.getException()) {
                this.composeCoding(null, coding);
            }
            this.closeArray();
        }
        if (element.hasSchoolElement()) {
            this.composeStringCore("school", element.getSchoolElement(), false);
            this.composeStringExtras("school", element.getSchoolElement(), false);
        }
        if (element.hasAccidentElement()) {
            this.composeDateCore("accident", element.getAccidentElement(), false);
            this.composeDateExtras("accident", element.getAccidentElement(), false);
        }
        if (element.hasAccidentType()) {
            this.composeCoding("accidentType", element.getAccidentType());
        }
        if (element.hasInterventionException()) {
            this.openArray("interventionException");
            for (Coding coding : element.getInterventionException()) {
                this.composeCoding(null, coding);
            }
            this.closeArray();
        }
        if (element.hasItem()) {
            this.openArray("item");
            for (Claim.ItemsComponent itemsComponent : element.getItem()) {
                this.composeClaimItemsComponent(null, itemsComponent);
            }
            this.closeArray();
        }
        if (element.hasAdditionalMaterials()) {
            this.openArray("additionalMaterials");
            for (Coding coding : element.getAdditionalMaterials()) {
                this.composeCoding(null, coding);
            }
            this.closeArray();
        }
        if (element.hasMissingTeeth()) {
            this.openArray("missingTeeth");
            for (Claim.MissingTeethComponent missingTeethComponent : element.getMissingTeeth()) {
                this.composeClaimMissingTeethComponent(null, missingTeethComponent);
            }
            this.closeArray();
        }
    }

    protected void composeClaimPayeeComponent(String name, Claim.PayeeComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimPayeeComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimPayeeComponentInner(Claim.PayeeComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasType()) {
            this.composeCoding("type", element.getType());
        }
        if (element.hasProvider()) {
            this.composeReference("provider", element.getProvider());
        }
        if (element.hasOrganization()) {
            this.composeReference("organization", element.getOrganization());
        }
        if (element.hasPerson()) {
            this.composeReference("person", element.getPerson());
        }
    }

    protected void composeClaimDiagnosisComponent(String name, Claim.DiagnosisComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimDiagnosisComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimDiagnosisComponentInner(Claim.DiagnosisComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSequenceElement()) {
            this.composePositiveIntCore("sequence", element.getSequenceElement(), false);
            this.composePositiveIntExtras("sequence", element.getSequenceElement(), false);
        }
        if (element.hasDiagnosis()) {
            this.composeCoding("diagnosis", element.getDiagnosis());
        }
    }

    protected void composeClaimCoverageComponent(String name, Claim.CoverageComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimCoverageComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimCoverageComponentInner(Claim.CoverageComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSequenceElement()) {
            this.composePositiveIntCore("sequence", element.getSequenceElement(), false);
            this.composePositiveIntExtras("sequence", element.getSequenceElement(), false);
        }
        if (element.hasFocalElement()) {
            this.composeBooleanCore("focal", element.getFocalElement(), false);
            this.composeBooleanExtras("focal", element.getFocalElement(), false);
        }
        if (element.hasCoverage()) {
            this.composeReference("coverage", element.getCoverage());
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeStringCore("businessArrangement", element.getBusinessArrangementElement(), false);
            this.composeStringExtras("businessArrangement", element.getBusinessArrangementElement(), false);
        }
        if (element.hasRelationship()) {
            this.composeCoding("relationship", element.getRelationship());
        }
        if (element.hasPreAuthRef()) {
            this.openArray("preAuthRef");
            for (StringType e : element.getPreAuthRef()) {
                this.composeStringCore(null, e, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getPreAuthRef())) {
                this.openArray("_preAuthRef");
                for (StringType e : element.getPreAuthRef()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasClaimResponse()) {
            this.composeReference("claimResponse", element.getClaimResponse());
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding("originalRuleset", element.getOriginalRuleset());
        }
    }

    protected void composeClaimItemsComponent(String name, Claim.ItemsComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimItemsComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimItemsComponentInner(Claim.ItemsComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSequenceElement()) {
            this.composePositiveIntCore("sequence", element.getSequenceElement(), false);
            this.composePositiveIntExtras("sequence", element.getSequenceElement(), false);
        }
        if (element.hasType()) {
            this.composeCoding("type", element.getType());
        }
        if (element.hasProvider()) {
            this.composeReference("provider", element.getProvider());
        }
        if (element.hasDiagnosisLinkId()) {
            this.openArray("diagnosisLinkId");
            for (PositiveIntType positiveIntType : element.getDiagnosisLinkId()) {
                this.composePositiveIntCore(null, positiveIntType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getDiagnosisLinkId())) {
                this.openArray("_diagnosisLinkId");
                for (PositiveIntType positiveIntType : element.getDiagnosisLinkId()) {
                    this.composePositiveIntExtras(null, positiveIntType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasService()) {
            this.composeCoding("service", element.getService());
        }
        if (element.hasServiceDateElement()) {
            this.composeDateCore("serviceDate", element.getServiceDateElement(), false);
            this.composeDateExtras("serviceDate", element.getServiceDateElement(), false);
        }
        if (element.hasQuantity()) {
            this.composeSimpleQuantity("quantity", element.getQuantity());
        }
        if (element.hasUnitPrice()) {
            this.composeMoney("unitPrice", element.getUnitPrice());
        }
        if (element.hasFactorElement()) {
            this.composeDecimalCore("factor", element.getFactorElement(), false);
            this.composeDecimalExtras("factor", element.getFactorElement(), false);
        }
        if (element.hasPointsElement()) {
            this.composeDecimalCore("points", element.getPointsElement(), false);
            this.composeDecimalExtras("points", element.getPointsElement(), false);
        }
        if (element.hasNet()) {
            this.composeMoney("net", element.getNet());
        }
        if (element.hasUdi()) {
            this.composeCoding("udi", element.getUdi());
        }
        if (element.hasBodySite()) {
            this.composeCoding("bodySite", element.getBodySite());
        }
        if (element.hasSubSite()) {
            this.openArray("subSite");
            for (Coding coding : element.getSubSite()) {
                this.composeCoding(null, coding);
            }
            this.closeArray();
        }
        if (element.hasModifier()) {
            this.openArray("modifier");
            for (Coding coding : element.getModifier()) {
                this.composeCoding(null, coding);
            }
            this.closeArray();
        }
        if (element.hasDetail()) {
            this.openArray("detail");
            for (Claim.DetailComponent detailComponent : element.getDetail()) {
                this.composeClaimDetailComponent(null, detailComponent);
            }
            this.closeArray();
        }
        if (element.hasProsthesis()) {
            this.composeClaimProsthesisComponent("prosthesis", element.getProsthesis());
        }
    }

    protected void composeClaimDetailComponent(String name, Claim.DetailComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimDetailComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimDetailComponentInner(Claim.DetailComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSequenceElement()) {
            this.composePositiveIntCore("sequence", element.getSequenceElement(), false);
            this.composePositiveIntExtras("sequence", element.getSequenceElement(), false);
        }
        if (element.hasType()) {
            this.composeCoding("type", element.getType());
        }
        if (element.hasService()) {
            this.composeCoding("service", element.getService());
        }
        if (element.hasQuantity()) {
            this.composeSimpleQuantity("quantity", element.getQuantity());
        }
        if (element.hasUnitPrice()) {
            this.composeMoney("unitPrice", element.getUnitPrice());
        }
        if (element.hasFactorElement()) {
            this.composeDecimalCore("factor", element.getFactorElement(), false);
            this.composeDecimalExtras("factor", element.getFactorElement(), false);
        }
        if (element.hasPointsElement()) {
            this.composeDecimalCore("points", element.getPointsElement(), false);
            this.composeDecimalExtras("points", element.getPointsElement(), false);
        }
        if (element.hasNet()) {
            this.composeMoney("net", element.getNet());
        }
        if (element.hasUdi()) {
            this.composeCoding("udi", element.getUdi());
        }
        if (element.hasSubDetail()) {
            this.openArray("subDetail");
            for (Claim.SubDetailComponent e : element.getSubDetail()) {
                this.composeClaimSubDetailComponent(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeClaimSubDetailComponent(String name, Claim.SubDetailComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimSubDetailComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimSubDetailComponentInner(Claim.SubDetailComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSequenceElement()) {
            this.composePositiveIntCore("sequence", element.getSequenceElement(), false);
            this.composePositiveIntExtras("sequence", element.getSequenceElement(), false);
        }
        if (element.hasType()) {
            this.composeCoding("type", element.getType());
        }
        if (element.hasService()) {
            this.composeCoding("service", element.getService());
        }
        if (element.hasQuantity()) {
            this.composeSimpleQuantity("quantity", element.getQuantity());
        }
        if (element.hasUnitPrice()) {
            this.composeMoney("unitPrice", element.getUnitPrice());
        }
        if (element.hasFactorElement()) {
            this.composeDecimalCore("factor", element.getFactorElement(), false);
            this.composeDecimalExtras("factor", element.getFactorElement(), false);
        }
        if (element.hasPointsElement()) {
            this.composeDecimalCore("points", element.getPointsElement(), false);
            this.composeDecimalExtras("points", element.getPointsElement(), false);
        }
        if (element.hasNet()) {
            this.composeMoney("net", element.getNet());
        }
        if (element.hasUdi()) {
            this.composeCoding("udi", element.getUdi());
        }
    }

    protected void composeClaimProsthesisComponent(String name, Claim.ProsthesisComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimProsthesisComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimProsthesisComponentInner(Claim.ProsthesisComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasInitialElement()) {
            this.composeBooleanCore("initial", element.getInitialElement(), false);
            this.composeBooleanExtras("initial", element.getInitialElement(), false);
        }
        if (element.hasPriorDateElement()) {
            this.composeDateCore("priorDate", element.getPriorDateElement(), false);
            this.composeDateExtras("priorDate", element.getPriorDateElement(), false);
        }
        if (element.hasPriorMaterial()) {
            this.composeCoding("priorMaterial", element.getPriorMaterial());
        }
    }

    protected void composeClaimMissingTeethComponent(String name, Claim.MissingTeethComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimMissingTeethComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimMissingTeethComponentInner(Claim.MissingTeethComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasTooth()) {
            this.composeCoding("tooth", element.getTooth());
        }
        if (element.hasReason()) {
            this.composeCoding("reason", element.getReason());
        }
        if (element.hasExtractionDateElement()) {
            this.composeDateCore("extractionDate", element.getExtractionDateElement(), false);
            this.composeDateExtras("extractionDate", element.getExtractionDateElement(), false);
        }
    }

    protected void composeClaimResponse(String name, ClaimResponse element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeClaimResponseInner(element);
        }
    }

    protected void composeClaimResponseInner(ClaimResponse element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasRequest()) {
            this.composeReference("request", element.getRequest());
        }
        if (element.hasRuleset()) {
            this.composeCoding("ruleset", element.getRuleset());
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding("originalRuleset", element.getOriginalRuleset());
        }
        if (element.hasCreatedElement()) {
            this.composeDateTimeCore("created", element.getCreatedElement(), false);
            this.composeDateTimeExtras("created", element.getCreatedElement(), false);
        }
        if (element.hasOrganization()) {
            this.composeReference("organization", element.getOrganization());
        }
        if (element.hasRequestProvider()) {
            this.composeReference("requestProvider", element.getRequestProvider());
        }
        if (element.hasRequestOrganization()) {
            this.composeReference("requestOrganization", element.getRequestOrganization());
        }
        if (element.hasOutcomeElement()) {
            this.composeEnumerationCore("outcome", element.getOutcomeElement(), new Enumerations.RemittanceOutcomeEnumFactory(), false);
            this.composeEnumerationExtras("outcome", element.getOutcomeElement(), new Enumerations.RemittanceOutcomeEnumFactory(), false);
        }
        if (element.hasDispositionElement()) {
            this.composeStringCore("disposition", element.getDispositionElement(), false);
            this.composeStringExtras("disposition", element.getDispositionElement(), false);
        }
        if (element.hasPayeeType()) {
            this.composeCoding("payeeType", element.getPayeeType());
        }
        if (element.hasItem()) {
            this.openArray("item");
            for (ClaimResponse.ItemsComponent itemsComponent : element.getItem()) {
                this.composeClaimResponseItemsComponent(null, itemsComponent);
            }
            this.closeArray();
        }
        if (element.hasAddItem()) {
            this.openArray("addItem");
            for (ClaimResponse.AddedItemComponent addedItemComponent : element.getAddItem()) {
                this.composeClaimResponseAddedItemComponent(null, addedItemComponent);
            }
            this.closeArray();
        }
        if (element.hasError()) {
            this.openArray("error");
            for (ClaimResponse.ErrorsComponent errorsComponent : element.getError()) {
                this.composeClaimResponseErrorsComponent(null, errorsComponent);
            }
            this.closeArray();
        }
        if (element.hasTotalCost()) {
            this.composeMoney("totalCost", element.getTotalCost());
        }
        if (element.hasUnallocDeductable()) {
            this.composeMoney("unallocDeductable", element.getUnallocDeductable());
        }
        if (element.hasTotalBenefit()) {
            this.composeMoney("totalBenefit", element.getTotalBenefit());
        }
        if (element.hasPaymentAdjustment()) {
            this.composeMoney("paymentAdjustment", element.getPaymentAdjustment());
        }
        if (element.hasPaymentAdjustmentReason()) {
            this.composeCoding("paymentAdjustmentReason", element.getPaymentAdjustmentReason());
        }
        if (element.hasPaymentDateElement()) {
            this.composeDateCore("paymentDate", element.getPaymentDateElement(), false);
            this.composeDateExtras("paymentDate", element.getPaymentDateElement(), false);
        }
        if (element.hasPaymentAmount()) {
            this.composeMoney("paymentAmount", element.getPaymentAmount());
        }
        if (element.hasPaymentRef()) {
            this.composeIdentifier("paymentRef", element.getPaymentRef());
        }
        if (element.hasReserved()) {
            this.composeCoding("reserved", element.getReserved());
        }
        if (element.hasForm()) {
            this.composeCoding("form", element.getForm());
        }
        if (element.hasNote()) {
            this.openArray("note");
            for (ClaimResponse.NotesComponent notesComponent : element.getNote()) {
                this.composeClaimResponseNotesComponent(null, notesComponent);
            }
            this.closeArray();
        }
        if (element.hasCoverage()) {
            this.openArray("coverage");
            for (ClaimResponse.CoverageComponent coverageComponent : element.getCoverage()) {
                this.composeClaimResponseCoverageComponent(null, coverageComponent);
            }
            this.closeArray();
        }
    }

    protected void composeClaimResponseItemsComponent(String name, ClaimResponse.ItemsComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimResponseItemsComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimResponseItemsComponentInner(ClaimResponse.ItemsComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSequenceLinkIdElement()) {
            this.composePositiveIntCore("sequenceLinkId", element.getSequenceLinkIdElement(), false);
            this.composePositiveIntExtras("sequenceLinkId", element.getSequenceLinkIdElement(), false);
        }
        if (element.hasNoteNumber()) {
            this.openArray("noteNumber");
            for (PositiveIntType positiveIntType : element.getNoteNumber()) {
                this.composePositiveIntCore(null, positiveIntType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getNoteNumber())) {
                this.openArray("_noteNumber");
                for (PositiveIntType positiveIntType : element.getNoteNumber()) {
                    this.composePositiveIntExtras(null, positiveIntType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasAdjudication()) {
            this.openArray("adjudication");
            for (ClaimResponse.ItemAdjudicationComponent itemAdjudicationComponent : element.getAdjudication()) {
                this.composeClaimResponseItemAdjudicationComponent(null, itemAdjudicationComponent);
            }
            this.closeArray();
        }
        if (element.hasDetail()) {
            this.openArray("detail");
            for (ClaimResponse.ItemDetailComponent itemDetailComponent : element.getDetail()) {
                this.composeClaimResponseItemDetailComponent(null, itemDetailComponent);
            }
            this.closeArray();
        }
    }

    protected void composeClaimResponseItemAdjudicationComponent(String name, ClaimResponse.ItemAdjudicationComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimResponseItemAdjudicationComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimResponseItemAdjudicationComponentInner(ClaimResponse.ItemAdjudicationComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCode()) {
            this.composeCoding("code", element.getCode());
        }
        if (element.hasAmount()) {
            this.composeMoney("amount", element.getAmount());
        }
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeClaimResponseItemDetailComponent(String name, ClaimResponse.ItemDetailComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimResponseItemDetailComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimResponseItemDetailComponentInner(ClaimResponse.ItemDetailComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSequenceLinkIdElement()) {
            this.composePositiveIntCore("sequenceLinkId", element.getSequenceLinkIdElement(), false);
            this.composePositiveIntExtras("sequenceLinkId", element.getSequenceLinkIdElement(), false);
        }
        if (element.hasAdjudication()) {
            this.openArray("adjudication");
            for (ClaimResponse.DetailAdjudicationComponent detailAdjudicationComponent : element.getAdjudication()) {
                this.composeClaimResponseDetailAdjudicationComponent(null, detailAdjudicationComponent);
            }
            this.closeArray();
        }
        if (element.hasSubDetail()) {
            this.openArray("subDetail");
            for (ClaimResponse.SubDetailComponent subDetailComponent : element.getSubDetail()) {
                this.composeClaimResponseSubDetailComponent(null, subDetailComponent);
            }
            this.closeArray();
        }
    }

    protected void composeClaimResponseDetailAdjudicationComponent(String name, ClaimResponse.DetailAdjudicationComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimResponseDetailAdjudicationComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimResponseDetailAdjudicationComponentInner(ClaimResponse.DetailAdjudicationComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCode()) {
            this.composeCoding("code", element.getCode());
        }
        if (element.hasAmount()) {
            this.composeMoney("amount", element.getAmount());
        }
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeClaimResponseSubDetailComponent(String name, ClaimResponse.SubDetailComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimResponseSubDetailComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimResponseSubDetailComponentInner(ClaimResponse.SubDetailComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSequenceLinkIdElement()) {
            this.composePositiveIntCore("sequenceLinkId", element.getSequenceLinkIdElement(), false);
            this.composePositiveIntExtras("sequenceLinkId", element.getSequenceLinkIdElement(), false);
        }
        if (element.hasAdjudication()) {
            this.openArray("adjudication");
            for (ClaimResponse.SubdetailAdjudicationComponent e : element.getAdjudication()) {
                this.composeClaimResponseSubdetailAdjudicationComponent(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeClaimResponseSubdetailAdjudicationComponent(String name, ClaimResponse.SubdetailAdjudicationComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimResponseSubdetailAdjudicationComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimResponseSubdetailAdjudicationComponentInner(ClaimResponse.SubdetailAdjudicationComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCode()) {
            this.composeCoding("code", element.getCode());
        }
        if (element.hasAmount()) {
            this.composeMoney("amount", element.getAmount());
        }
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeClaimResponseAddedItemComponent(String name, ClaimResponse.AddedItemComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimResponseAddedItemComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimResponseAddedItemComponentInner(ClaimResponse.AddedItemComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSequenceLinkId()) {
            this.openArray("sequenceLinkId");
            for (PositiveIntType positiveIntType : element.getSequenceLinkId()) {
                this.composePositiveIntCore(null, positiveIntType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getSequenceLinkId())) {
                this.openArray("_sequenceLinkId");
                for (PositiveIntType positiveIntType : element.getSequenceLinkId()) {
                    this.composePositiveIntExtras(null, positiveIntType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasService()) {
            this.composeCoding("service", element.getService());
        }
        if (element.hasFee()) {
            this.composeMoney("fee", element.getFee());
        }
        if (element.hasNoteNumberLinkId()) {
            this.openArray("noteNumberLinkId");
            for (PositiveIntType positiveIntType : element.getNoteNumberLinkId()) {
                this.composePositiveIntCore(null, positiveIntType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getNoteNumberLinkId())) {
                this.openArray("_noteNumberLinkId");
                for (PositiveIntType positiveIntType : element.getNoteNumberLinkId()) {
                    this.composePositiveIntExtras(null, positiveIntType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasAdjudication()) {
            this.openArray("adjudication");
            for (ClaimResponse.AddedItemAdjudicationComponent addedItemAdjudicationComponent : element.getAdjudication()) {
                this.composeClaimResponseAddedItemAdjudicationComponent(null, addedItemAdjudicationComponent);
            }
            this.closeArray();
        }
        if (element.hasDetail()) {
            this.openArray("detail");
            for (ClaimResponse.AddedItemsDetailComponent addedItemsDetailComponent : element.getDetail()) {
                this.composeClaimResponseAddedItemsDetailComponent(null, addedItemsDetailComponent);
            }
            this.closeArray();
        }
    }

    protected void composeClaimResponseAddedItemAdjudicationComponent(String name, ClaimResponse.AddedItemAdjudicationComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimResponseAddedItemAdjudicationComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimResponseAddedItemAdjudicationComponentInner(ClaimResponse.AddedItemAdjudicationComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCode()) {
            this.composeCoding("code", element.getCode());
        }
        if (element.hasAmount()) {
            this.composeMoney("amount", element.getAmount());
        }
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeClaimResponseAddedItemsDetailComponent(String name, ClaimResponse.AddedItemsDetailComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimResponseAddedItemsDetailComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimResponseAddedItemsDetailComponentInner(ClaimResponse.AddedItemsDetailComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasService()) {
            this.composeCoding("service", element.getService());
        }
        if (element.hasFee()) {
            this.composeMoney("fee", element.getFee());
        }
        if (element.hasAdjudication()) {
            this.openArray("adjudication");
            for (ClaimResponse.AddedItemDetailAdjudicationComponent e : element.getAdjudication()) {
                this.composeClaimResponseAddedItemDetailAdjudicationComponent(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeClaimResponseAddedItemDetailAdjudicationComponent(String name, ClaimResponse.AddedItemDetailAdjudicationComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimResponseAddedItemDetailAdjudicationComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimResponseAddedItemDetailAdjudicationComponentInner(ClaimResponse.AddedItemDetailAdjudicationComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCode()) {
            this.composeCoding("code", element.getCode());
        }
        if (element.hasAmount()) {
            this.composeMoney("amount", element.getAmount());
        }
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
    }

    protected void composeClaimResponseErrorsComponent(String name, ClaimResponse.ErrorsComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimResponseErrorsComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimResponseErrorsComponentInner(ClaimResponse.ErrorsComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSequenceLinkIdElement()) {
            this.composePositiveIntCore("sequenceLinkId", element.getSequenceLinkIdElement(), false);
            this.composePositiveIntExtras("sequenceLinkId", element.getSequenceLinkIdElement(), false);
        }
        if (element.hasDetailSequenceLinkIdElement()) {
            this.composePositiveIntCore("detailSequenceLinkId", element.getDetailSequenceLinkIdElement(), false);
            this.composePositiveIntExtras("detailSequenceLinkId", element.getDetailSequenceLinkIdElement(), false);
        }
        if (element.hasSubdetailSequenceLinkIdElement()) {
            this.composePositiveIntCore("subdetailSequenceLinkId", element.getSubdetailSequenceLinkIdElement(), false);
            this.composePositiveIntExtras("subdetailSequenceLinkId", element.getSubdetailSequenceLinkIdElement(), false);
        }
        if (element.hasCode()) {
            this.composeCoding("code", element.getCode());
        }
    }

    protected void composeClaimResponseNotesComponent(String name, ClaimResponse.NotesComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimResponseNotesComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimResponseNotesComponentInner(ClaimResponse.NotesComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasNumberElement()) {
            this.composePositiveIntCore("number", element.getNumberElement(), false);
            this.composePositiveIntExtras("number", element.getNumberElement(), false);
        }
        if (element.hasType()) {
            this.composeCoding("type", element.getType());
        }
        if (element.hasTextElement()) {
            this.composeStringCore("text", element.getTextElement(), false);
            this.composeStringExtras("text", element.getTextElement(), false);
        }
    }

    protected void composeClaimResponseCoverageComponent(String name, ClaimResponse.CoverageComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClaimResponseCoverageComponentInner(element);
            this.close();
        }
    }

    protected void composeClaimResponseCoverageComponentInner(ClaimResponse.CoverageComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSequenceElement()) {
            this.composePositiveIntCore("sequence", element.getSequenceElement(), false);
            this.composePositiveIntExtras("sequence", element.getSequenceElement(), false);
        }
        if (element.hasFocalElement()) {
            this.composeBooleanCore("focal", element.getFocalElement(), false);
            this.composeBooleanExtras("focal", element.getFocalElement(), false);
        }
        if (element.hasCoverage()) {
            this.composeReference("coverage", element.getCoverage());
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeStringCore("businessArrangement", element.getBusinessArrangementElement(), false);
            this.composeStringExtras("businessArrangement", element.getBusinessArrangementElement(), false);
        }
        if (element.hasRelationship()) {
            this.composeCoding("relationship", element.getRelationship());
        }
        if (element.hasPreAuthRef()) {
            this.openArray("preAuthRef");
            for (StringType e : element.getPreAuthRef()) {
                this.composeStringCore(null, e, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getPreAuthRef())) {
                this.openArray("_preAuthRef");
                for (StringType e : element.getPreAuthRef()) {
                    this.composeStringExtras(null, e, true);
                }
                this.closeArray();
            }
        }
        if (element.hasClaimResponse()) {
            this.composeReference("claimResponse", element.getClaimResponse());
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding("originalRuleset", element.getOriginalRuleset());
        }
    }

    protected void composeClinicalImpression(String name, ClinicalImpression element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeClinicalImpressionInner(element);
        }
    }

    protected void composeClinicalImpressionInner(ClinicalImpression element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasPatient()) {
            this.composeReference("patient", element.getPatient());
        }
        if (element.hasAssessor()) {
            this.composeReference("assessor", element.getAssessor());
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new ClinicalImpression.ClinicalImpressionStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new ClinicalImpression.ClinicalImpressionStatusEnumFactory(), false);
        }
        if (element.hasDateElement()) {
            this.composeDateTimeCore("date", element.getDateElement(), false);
            this.composeDateTimeExtras("date", element.getDateElement(), false);
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasPrevious()) {
            this.composeReference("previous", element.getPrevious());
        }
        if (element.hasProblem()) {
            this.openArray("problem");
            for (Reference reference : element.getProblem()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasTrigger()) {
            this.composeType("trigger", element.getTrigger());
        }
        if (element.hasInvestigations()) {
            this.openArray("investigations");
            for (ClinicalImpression.ClinicalImpressionInvestigationsComponent clinicalImpressionInvestigationsComponent : element.getInvestigations()) {
                this.composeClinicalImpressionClinicalImpressionInvestigationsComponent(null, clinicalImpressionInvestigationsComponent);
            }
            this.closeArray();
        }
        if (element.hasProtocolElement()) {
            this.composeUriCore("protocol", element.getProtocolElement(), false);
            this.composeUriExtras("protocol", element.getProtocolElement(), false);
        }
        if (element.hasSummaryElement()) {
            this.composeStringCore("summary", element.getSummaryElement(), false);
            this.composeStringExtras("summary", element.getSummaryElement(), false);
        }
        if (element.hasFinding()) {
            this.openArray("finding");
            for (ClinicalImpression.ClinicalImpressionFindingComponent clinicalImpressionFindingComponent : element.getFinding()) {
                this.composeClinicalImpressionClinicalImpressionFindingComponent(null, clinicalImpressionFindingComponent);
            }
            this.closeArray();
        }
        if (element.hasResolved()) {
            this.openArray("resolved");
            for (CodeableConcept codeableConcept : element.getResolved()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasRuledOut()) {
            this.openArray("ruledOut");
            for (ClinicalImpression.ClinicalImpressionRuledOutComponent clinicalImpressionRuledOutComponent : element.getRuledOut()) {
                this.composeClinicalImpressionClinicalImpressionRuledOutComponent(null, clinicalImpressionRuledOutComponent);
            }
            this.closeArray();
        }
        if (element.hasPrognosisElement()) {
            this.composeStringCore("prognosis", element.getPrognosisElement(), false);
            this.composeStringExtras("prognosis", element.getPrognosisElement(), false);
        }
        if (element.hasPlan()) {
            this.openArray("plan");
            for (Reference reference : element.getPlan()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasAction()) {
            this.openArray("action");
            for (Reference reference : element.getAction()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
    }

    protected void composeClinicalImpressionClinicalImpressionInvestigationsComponent(String name, ClinicalImpression.ClinicalImpressionInvestigationsComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClinicalImpressionClinicalImpressionInvestigationsComponentInner(element);
            this.close();
        }
    }

    protected void composeClinicalImpressionClinicalImpressionInvestigationsComponentInner(ClinicalImpression.ClinicalImpressionInvestigationsComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCode()) {
            this.composeCodeableConcept("code", element.getCode());
        }
        if (element.hasItem()) {
            this.openArray("item");
            for (Reference e : element.getItem()) {
                this.composeReference(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeClinicalImpressionClinicalImpressionFindingComponent(String name, ClinicalImpression.ClinicalImpressionFindingComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClinicalImpressionClinicalImpressionFindingComponentInner(element);
            this.close();
        }
    }

    protected void composeClinicalImpressionClinicalImpressionFindingComponentInner(ClinicalImpression.ClinicalImpressionFindingComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasItem()) {
            this.composeCodeableConcept("item", element.getItem());
        }
        if (element.hasCauseElement()) {
            this.composeStringCore("cause", element.getCauseElement(), false);
            this.composeStringExtras("cause", element.getCauseElement(), false);
        }
    }

    protected void composeClinicalImpressionClinicalImpressionRuledOutComponent(String name, ClinicalImpression.ClinicalImpressionRuledOutComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeClinicalImpressionClinicalImpressionRuledOutComponentInner(element);
            this.close();
        }
    }

    protected void composeClinicalImpressionClinicalImpressionRuledOutComponentInner(ClinicalImpression.ClinicalImpressionRuledOutComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasItem()) {
            this.composeCodeableConcept("item", element.getItem());
        }
        if (element.hasReasonElement()) {
            this.composeStringCore("reason", element.getReasonElement(), false);
            this.composeStringExtras("reason", element.getReasonElement(), false);
        }
    }

    protected void composeCommunication(String name, Communication element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeCommunicationInner(element);
        }
    }

    protected void composeCommunicationInner(Communication element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept("category", element.getCategory());
        }
        if (element.hasSender()) {
            this.composeReference("sender", element.getSender());
        }
        if (element.hasRecipient()) {
            this.openArray("recipient");
            for (Reference reference : element.getRecipient()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasPayload()) {
            this.openArray("payload");
            for (Communication.CommunicationPayloadComponent communicationPayloadComponent : element.getPayload()) {
                this.composeCommunicationCommunicationPayloadComponent(null, communicationPayloadComponent);
            }
            this.closeArray();
        }
        if (element.hasMedium()) {
            this.openArray("medium");
            for (CodeableConcept codeableConcept : element.getMedium()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new Communication.CommunicationStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new Communication.CommunicationStatusEnumFactory(), false);
        }
        if (element.hasEncounter()) {
            this.composeReference("encounter", element.getEncounter());
        }
        if (element.hasSentElement()) {
            this.composeDateTimeCore("sent", element.getSentElement(), false);
            this.composeDateTimeExtras("sent", element.getSentElement(), false);
        }
        if (element.hasReceivedElement()) {
            this.composeDateTimeCore("received", element.getReceivedElement(), false);
            this.composeDateTimeExtras("received", element.getReceivedElement(), false);
        }
        if (element.hasReason()) {
            this.openArray("reason");
            for (CodeableConcept codeableConcept : element.getReason()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasSubject()) {
            this.composeReference("subject", element.getSubject());
        }
        if (element.hasRequestDetail()) {
            this.composeReference("requestDetail", element.getRequestDetail());
        }
    }

    protected void composeCommunicationCommunicationPayloadComponent(String name, Communication.CommunicationPayloadComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCommunicationCommunicationPayloadComponentInner(element);
            this.close();
        }
    }

    protected void composeCommunicationCommunicationPayloadComponentInner(Communication.CommunicationPayloadComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasContent()) {
            this.composeType("content", element.getContent());
        }
    }

    protected void composeCommunicationRequest(String name, CommunicationRequest element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeCommunicationRequestInner(element);
        }
    }

    protected void composeCommunicationRequestInner(CommunicationRequest element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept("category", element.getCategory());
        }
        if (element.hasSender()) {
            this.composeReference("sender", element.getSender());
        }
        if (element.hasRecipient()) {
            this.openArray("recipient");
            for (Reference reference : element.getRecipient()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasPayload()) {
            this.openArray("payload");
            for (CommunicationRequest.CommunicationRequestPayloadComponent communicationRequestPayloadComponent : element.getPayload()) {
                this.composeCommunicationRequestCommunicationRequestPayloadComponent(null, communicationRequestPayloadComponent);
            }
            this.closeArray();
        }
        if (element.hasMedium()) {
            this.openArray("medium");
            for (CodeableConcept codeableConcept : element.getMedium()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasRequester()) {
            this.composeReference("requester", element.getRequester());
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new CommunicationRequest.CommunicationRequestStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new CommunicationRequest.CommunicationRequestStatusEnumFactory(), false);
        }
        if (element.hasEncounter()) {
            this.composeReference("encounter", element.getEncounter());
        }
        if (element.hasScheduled()) {
            this.composeType("scheduled", element.getScheduled());
        }
        if (element.hasReason()) {
            this.openArray("reason");
            for (CodeableConcept codeableConcept : element.getReason()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasRequestedOnElement()) {
            this.composeDateTimeCore("requestedOn", element.getRequestedOnElement(), false);
            this.composeDateTimeExtras("requestedOn", element.getRequestedOnElement(), false);
        }
        if (element.hasSubject()) {
            this.composeReference("subject", element.getSubject());
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept("priority", element.getPriority());
        }
    }

    protected void composeCommunicationRequestCommunicationRequestPayloadComponent(String name, CommunicationRequest.CommunicationRequestPayloadComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCommunicationRequestCommunicationRequestPayloadComponentInner(element);
            this.close();
        }
    }

    protected void composeCommunicationRequestCommunicationRequestPayloadComponentInner(CommunicationRequest.CommunicationRequestPayloadComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasContent()) {
            this.composeType("content", element.getContent());
        }
    }

    protected void composeComposition(String name, Composition element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeCompositionInner(element);
        }
    }

    protected void composeCompositionInner(Composition element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.composeIdentifier("identifier", element.getIdentifier());
        }
        if (element.hasDateElement()) {
            this.composeDateTimeCore("date", element.getDateElement(), false);
            this.composeDateTimeExtras("date", element.getDateElement(), false);
        }
        if (element.hasType()) {
            this.composeCodeableConcept("type", element.getType());
        }
        if (element.hasClass_()) {
            this.composeCodeableConcept("class", element.getClass_());
        }
        if (element.hasTitleElement()) {
            this.composeStringCore("title", element.getTitleElement(), false);
            this.composeStringExtras("title", element.getTitleElement(), false);
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new Composition.CompositionStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new Composition.CompositionStatusEnumFactory(), false);
        }
        if (element.hasConfidentialityElement()) {
            this.composeCodeCore("confidentiality", element.getConfidentialityElement(), false);
            this.composeCodeExtras("confidentiality", element.getConfidentialityElement(), false);
        }
        if (element.hasSubject()) {
            this.composeReference("subject", element.getSubject());
        }
        if (element.hasAuthor()) {
            this.openArray("author");
            for (Reference reference : element.getAuthor()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasAttester()) {
            this.openArray("attester");
            for (Composition.CompositionAttesterComponent compositionAttesterComponent : element.getAttester()) {
                this.composeCompositionCompositionAttesterComponent(null, compositionAttesterComponent);
            }
            this.closeArray();
        }
        if (element.hasCustodian()) {
            this.composeReference("custodian", element.getCustodian());
        }
        if (element.hasEvent()) {
            this.openArray("event");
            for (Composition.CompositionEventComponent compositionEventComponent : element.getEvent()) {
                this.composeCompositionCompositionEventComponent(null, compositionEventComponent);
            }
            this.closeArray();
        }
        if (element.hasEncounter()) {
            this.composeReference("encounter", element.getEncounter());
        }
        if (element.hasSection()) {
            this.openArray("section");
            for (Composition.SectionComponent sectionComponent : element.getSection()) {
                this.composeCompositionSectionComponent(null, sectionComponent);
            }
            this.closeArray();
        }
    }

    protected void composeCompositionCompositionAttesterComponent(String name, Composition.CompositionAttesterComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCompositionCompositionAttesterComponentInner(element);
            this.close();
        }
    }

    protected void composeCompositionCompositionAttesterComponentInner(Composition.CompositionAttesterComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasMode()) {
            this.openArray("mode");
            for (Enumeration<Composition.CompositionAttestationMode> e : element.getMode()) {
                this.composeEnumerationCore(null, e, new Composition.CompositionAttestationModeEnumFactory(), true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getMode())) {
                this.openArray("_mode");
                for (Enumeration<Composition.CompositionAttestationMode> e : element.getMode()) {
                    this.composeEnumerationExtras(null, e, new Composition.CompositionAttestationModeEnumFactory(), true);
                }
                this.closeArray();
            }
        }
        if (element.hasTimeElement()) {
            this.composeDateTimeCore("time", element.getTimeElement(), false);
            this.composeDateTimeExtras("time", element.getTimeElement(), false);
        }
        if (element.hasParty()) {
            this.composeReference("party", element.getParty());
        }
    }

    protected void composeCompositionCompositionEventComponent(String name, Composition.CompositionEventComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCompositionCompositionEventComponentInner(element);
            this.close();
        }
    }

    protected void composeCompositionCompositionEventComponentInner(Composition.CompositionEventComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCode()) {
            this.openArray("code");
            for (CodeableConcept codeableConcept : element.getCode()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasPeriod()) {
            this.composePeriod("period", element.getPeriod());
        }
        if (element.hasDetail()) {
            this.openArray("detail");
            for (Reference reference : element.getDetail()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
    }

    protected void composeCompositionSectionComponent(String name, Composition.SectionComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCompositionSectionComponentInner(element);
            this.close();
        }
    }

    protected void composeCompositionSectionComponentInner(Composition.SectionComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasTitleElement()) {
            this.composeStringCore("title", element.getTitleElement(), false);
            this.composeStringExtras("title", element.getTitleElement(), false);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept("code", element.getCode());
        }
        if (element.hasText()) {
            this.composeNarrative("text", element.getText());
        }
        if (element.hasModeElement()) {
            this.composeCodeCore("mode", element.getModeElement(), false);
            this.composeCodeExtras("mode", element.getModeElement(), false);
        }
        if (element.hasOrderedBy()) {
            this.composeCodeableConcept("orderedBy", element.getOrderedBy());
        }
        if (element.hasEntry()) {
            this.openArray("entry");
            for (Reference reference : element.getEntry()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasEmptyReason()) {
            this.composeCodeableConcept("emptyReason", element.getEmptyReason());
        }
        if (element.hasSection()) {
            this.openArray("section");
            for (Composition.SectionComponent sectionComponent : element.getSection()) {
                this.composeCompositionSectionComponent(null, sectionComponent);
            }
            this.closeArray();
        }
    }

    protected void composeConceptMap(String name, ConceptMap element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeConceptMapInner(element);
        }
    }

    protected void composeConceptMapInner(ConceptMap element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasUrlElement()) {
            this.composeUriCore("url", element.getUrlElement(), false);
            this.composeUriExtras("url", element.getUrlElement(), false);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier("identifier", element.getIdentifier());
        }
        if (element.hasVersionElement()) {
            this.composeStringCore("version", element.getVersionElement(), false);
            this.composeStringExtras("version", element.getVersionElement(), false);
        }
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new Enumerations.ConformanceResourceStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new Enumerations.ConformanceResourceStatusEnumFactory(), false);
        }
        if (element.hasExperimentalElement()) {
            this.composeBooleanCore("experimental", element.getExperimentalElement(), false);
            this.composeBooleanExtras("experimental", element.getExperimentalElement(), false);
        }
        if (element.hasPublisherElement()) {
            this.composeStringCore("publisher", element.getPublisherElement(), false);
            this.composeStringExtras("publisher", element.getPublisherElement(), false);
        }
        if (element.hasContact()) {
            this.openArray("contact");
            for (ConceptMap.ConceptMapContactComponent conceptMapContactComponent : element.getContact()) {
                this.composeConceptMapConceptMapContactComponent(null, conceptMapContactComponent);
            }
            this.closeArray();
        }
        if (element.hasDateElement()) {
            this.composeDateTimeCore("date", element.getDateElement(), false);
            this.composeDateTimeExtras("date", element.getDateElement(), false);
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasUseContext()) {
            this.openArray("useContext");
            for (CodeableConcept codeableConcept : element.getUseContext()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasRequirementsElement()) {
            this.composeStringCore("requirements", element.getRequirementsElement(), false);
            this.composeStringExtras("requirements", element.getRequirementsElement(), false);
        }
        if (element.hasCopyrightElement()) {
            this.composeStringCore("copyright", element.getCopyrightElement(), false);
            this.composeStringExtras("copyright", element.getCopyrightElement(), false);
        }
        if (element.hasSource()) {
            this.composeType("source", element.getSource());
        }
        if (element.hasTarget()) {
            this.composeType("target", element.getTarget());
        }
        if (element.hasElement()) {
            this.openArray("element");
            for (ConceptMap.SourceElementComponent sourceElementComponent : element.getElement()) {
                this.composeConceptMapSourceElementComponent(null, sourceElementComponent);
            }
            this.closeArray();
        }
    }

    protected void composeConceptMapConceptMapContactComponent(String name, ConceptMap.ConceptMapContactComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConceptMapConceptMapContactComponentInner(element);
            this.close();
        }
    }

    protected void composeConceptMapConceptMapContactComponentInner(ConceptMap.ConceptMapContactComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasTelecom()) {
            this.openArray("telecom");
            for (ContactPoint e : element.getTelecom()) {
                this.composeContactPoint(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeConceptMapSourceElementComponent(String name, ConceptMap.SourceElementComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConceptMapSourceElementComponentInner(element);
            this.close();
        }
    }

    protected void composeConceptMapSourceElementComponentInner(ConceptMap.SourceElementComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCodeSystemElement()) {
            this.composeUriCore("codeSystem", element.getCodeSystemElement(), false);
            this.composeUriExtras("codeSystem", element.getCodeSystemElement(), false);
        }
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
        if (element.hasTarget()) {
            this.openArray("target");
            for (ConceptMap.TargetElementComponent e : element.getTarget()) {
                this.composeConceptMapTargetElementComponent(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeConceptMapTargetElementComponent(String name, ConceptMap.TargetElementComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConceptMapTargetElementComponentInner(element);
            this.close();
        }
    }

    protected void composeConceptMapTargetElementComponentInner(ConceptMap.TargetElementComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCodeSystemElement()) {
            this.composeUriCore("codeSystem", element.getCodeSystemElement(), false);
            this.composeUriExtras("codeSystem", element.getCodeSystemElement(), false);
        }
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
        if (element.hasEquivalenceElement()) {
            this.composeEnumerationCore("equivalence", element.getEquivalenceElement(), new Enumerations.ConceptMapEquivalenceEnumFactory(), false);
            this.composeEnumerationExtras("equivalence", element.getEquivalenceElement(), new Enumerations.ConceptMapEquivalenceEnumFactory(), false);
        }
        if (element.hasCommentsElement()) {
            this.composeStringCore("comments", element.getCommentsElement(), false);
            this.composeStringExtras("comments", element.getCommentsElement(), false);
        }
        if (element.hasDependsOn()) {
            this.openArray("dependsOn");
            for (ConceptMap.OtherElementComponent e : element.getDependsOn()) {
                this.composeConceptMapOtherElementComponent(null, e);
            }
            this.closeArray();
        }
        if (element.hasProduct()) {
            this.openArray("product");
            for (ConceptMap.OtherElementComponent e : element.getProduct()) {
                this.composeConceptMapOtherElementComponent(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeConceptMapOtherElementComponent(String name, ConceptMap.OtherElementComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConceptMapOtherElementComponentInner(element);
            this.close();
        }
    }

    protected void composeConceptMapOtherElementComponentInner(ConceptMap.OtherElementComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasElementElement()) {
            this.composeUriCore("element", element.getElementElement(), false);
            this.composeUriExtras("element", element.getElementElement(), false);
        }
        if (element.hasCodeSystemElement()) {
            this.composeUriCore("codeSystem", element.getCodeSystemElement(), false);
            this.composeUriExtras("codeSystem", element.getCodeSystemElement(), false);
        }
        if (element.hasCodeElement()) {
            this.composeStringCore("code", element.getCodeElement(), false);
            this.composeStringExtras("code", element.getCodeElement(), false);
        }
    }

    protected void composeCondition(String name, Condition element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeConditionInner(element);
        }
    }

    protected void composeConditionInner(Condition element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasPatient()) {
            this.composeReference("patient", element.getPatient());
        }
        if (element.hasEncounter()) {
            this.composeReference("encounter", element.getEncounter());
        }
        if (element.hasAsserter()) {
            this.composeReference("asserter", element.getAsserter());
        }
        if (element.hasDateRecordedElement()) {
            this.composeDateCore("dateRecorded", element.getDateRecordedElement(), false);
            this.composeDateExtras("dateRecorded", element.getDateRecordedElement(), false);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept("code", element.getCode());
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept("category", element.getCategory());
        }
        if (element.hasClinicalStatusElement()) {
            this.composeCodeCore("clinicalStatus", element.getClinicalStatusElement(), false);
            this.composeCodeExtras("clinicalStatus", element.getClinicalStatusElement(), false);
        }
        if (element.hasVerificationStatusElement()) {
            this.composeEnumerationCore("verificationStatus", element.getVerificationStatusElement(), new Condition.ConditionVerificationStatusEnumFactory(), false);
            this.composeEnumerationExtras("verificationStatus", element.getVerificationStatusElement(), new Condition.ConditionVerificationStatusEnumFactory(), false);
        }
        if (element.hasSeverity()) {
            this.composeCodeableConcept("severity", element.getSeverity());
        }
        if (element.hasOnset()) {
            this.composeType("onset", element.getOnset());
        }
        if (element.hasAbatement()) {
            this.composeType("abatement", element.getAbatement());
        }
        if (element.hasStage()) {
            this.composeConditionConditionStageComponent("stage", element.getStage());
        }
        if (element.hasEvidence()) {
            this.openArray("evidence");
            for (Condition.ConditionEvidenceComponent conditionEvidenceComponent : element.getEvidence()) {
                this.composeConditionConditionEvidenceComponent(null, conditionEvidenceComponent);
            }
            this.closeArray();
        }
        if (element.hasBodySite()) {
            this.openArray("bodySite");
            for (CodeableConcept codeableConcept : element.getBodySite()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasNotesElement()) {
            this.composeStringCore("notes", element.getNotesElement(), false);
            this.composeStringExtras("notes", element.getNotesElement(), false);
        }
    }

    protected void composeConditionConditionStageComponent(String name, Condition.ConditionStageComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConditionConditionStageComponentInner(element);
            this.close();
        }
    }

    protected void composeConditionConditionStageComponentInner(Condition.ConditionStageComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSummary()) {
            this.composeCodeableConcept("summary", element.getSummary());
        }
        if (element.hasAssessment()) {
            this.openArray("assessment");
            for (Reference e : element.getAssessment()) {
                this.composeReference(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeConditionConditionEvidenceComponent(String name, Condition.ConditionEvidenceComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConditionConditionEvidenceComponentInner(element);
            this.close();
        }
    }

    protected void composeConditionConditionEvidenceComponentInner(Condition.ConditionEvidenceComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCode()) {
            this.composeCodeableConcept("code", element.getCode());
        }
        if (element.hasDetail()) {
            this.openArray("detail");
            for (Reference e : element.getDetail()) {
                this.composeReference(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeConformance(String name, Conformance element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeConformanceInner(element);
        }
    }

    protected void composeConformanceInner(Conformance element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasUrlElement()) {
            this.composeUriCore("url", element.getUrlElement(), false);
            this.composeUriExtras("url", element.getUrlElement(), false);
        }
        if (element.hasVersionElement()) {
            this.composeStringCore("version", element.getVersionElement(), false);
            this.composeStringExtras("version", element.getVersionElement(), false);
        }
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new Enumerations.ConformanceResourceStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new Enumerations.ConformanceResourceStatusEnumFactory(), false);
        }
        if (element.hasExperimentalElement()) {
            this.composeBooleanCore("experimental", element.getExperimentalElement(), false);
            this.composeBooleanExtras("experimental", element.getExperimentalElement(), false);
        }
        if (element.hasPublisherElement()) {
            this.composeStringCore("publisher", element.getPublisherElement(), false);
            this.composeStringExtras("publisher", element.getPublisherElement(), false);
        }
        if (element.hasContact()) {
            this.openArray("contact");
            for (Conformance.ConformanceContactComponent conformanceContactComponent : element.getContact()) {
                this.composeConformanceConformanceContactComponent(null, conformanceContactComponent);
            }
            this.closeArray();
        }
        if (element.hasDateElement()) {
            this.composeDateTimeCore("date", element.getDateElement(), false);
            this.composeDateTimeExtras("date", element.getDateElement(), false);
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasRequirementsElement()) {
            this.composeStringCore("requirements", element.getRequirementsElement(), false);
            this.composeStringExtras("requirements", element.getRequirementsElement(), false);
        }
        if (element.hasCopyrightElement()) {
            this.composeStringCore("copyright", element.getCopyrightElement(), false);
            this.composeStringExtras("copyright", element.getCopyrightElement(), false);
        }
        if (element.hasKindElement()) {
            this.composeEnumerationCore("kind", element.getKindElement(), new Conformance.ConformanceStatementKindEnumFactory(), false);
            this.composeEnumerationExtras("kind", element.getKindElement(), new Conformance.ConformanceStatementKindEnumFactory(), false);
        }
        if (element.hasSoftware()) {
            this.composeConformanceConformanceSoftwareComponent("software", element.getSoftware());
        }
        if (element.hasImplementation()) {
            this.composeConformanceConformanceImplementationComponent("implementation", element.getImplementation());
        }
        if (element.hasFhirVersionElement()) {
            this.composeIdCore("fhirVersion", element.getFhirVersionElement(), false);
            this.composeIdExtras("fhirVersion", element.getFhirVersionElement(), false);
        }
        if (element.hasAcceptUnknownElement()) {
            this.composeEnumerationCore("acceptUnknown", element.getAcceptUnknownElement(), new Conformance.UnknownContentCodeEnumFactory(), false);
            this.composeEnumerationExtras("acceptUnknown", element.getAcceptUnknownElement(), new Conformance.UnknownContentCodeEnumFactory(), false);
        }
        if (element.hasFormat()) {
            this.openArray("format");
            for (CodeType codeType : element.getFormat()) {
                this.composeCodeCore(null, codeType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getFormat())) {
                this.openArray("_format");
                for (CodeType codeType : element.getFormat()) {
                    this.composeCodeExtras(null, codeType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasProfile()) {
            this.openArray("profile");
            for (Reference reference : element.getProfile()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasRest()) {
            this.openArray("rest");
            for (Conformance.ConformanceRestComponent conformanceRestComponent : element.getRest()) {
                this.composeConformanceConformanceRestComponent(null, conformanceRestComponent);
            }
            this.closeArray();
        }
        if (element.hasMessaging()) {
            this.openArray("messaging");
            for (Conformance.ConformanceMessagingComponent conformanceMessagingComponent : element.getMessaging()) {
                this.composeConformanceConformanceMessagingComponent(null, conformanceMessagingComponent);
            }
            this.closeArray();
        }
        if (element.hasDocument()) {
            this.openArray("document");
            for (Conformance.ConformanceDocumentComponent conformanceDocumentComponent : element.getDocument()) {
                this.composeConformanceConformanceDocumentComponent(null, conformanceDocumentComponent);
            }
            this.closeArray();
        }
    }

    protected void composeConformanceConformanceContactComponent(String name, Conformance.ConformanceContactComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceConformanceContactComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceConformanceContactComponentInner(Conformance.ConformanceContactComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasTelecom()) {
            this.openArray("telecom");
            for (ContactPoint e : element.getTelecom()) {
                this.composeContactPoint(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeConformanceConformanceSoftwareComponent(String name, Conformance.ConformanceSoftwareComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceConformanceSoftwareComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceConformanceSoftwareComponentInner(Conformance.ConformanceSoftwareComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasVersionElement()) {
            this.composeStringCore("version", element.getVersionElement(), false);
            this.composeStringExtras("version", element.getVersionElement(), false);
        }
        if (element.hasReleaseDateElement()) {
            this.composeDateTimeCore("releaseDate", element.getReleaseDateElement(), false);
            this.composeDateTimeExtras("releaseDate", element.getReleaseDateElement(), false);
        }
    }

    protected void composeConformanceConformanceImplementationComponent(String name, Conformance.ConformanceImplementationComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceConformanceImplementationComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceConformanceImplementationComponentInner(Conformance.ConformanceImplementationComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasUrlElement()) {
            this.composeUriCore("url", element.getUrlElement(), false);
            this.composeUriExtras("url", element.getUrlElement(), false);
        }
    }

    protected void composeConformanceConformanceRestComponent(String name, Conformance.ConformanceRestComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceConformanceRestComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceConformanceRestComponentInner(Conformance.ConformanceRestComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasModeElement()) {
            this.composeEnumerationCore("mode", element.getModeElement(), new Conformance.RestfulConformanceModeEnumFactory(), false);
            this.composeEnumerationExtras("mode", element.getModeElement(), new Conformance.RestfulConformanceModeEnumFactory(), false);
        }
        if (element.hasDocumentationElement()) {
            this.composeStringCore("documentation", element.getDocumentationElement(), false);
            this.composeStringExtras("documentation", element.getDocumentationElement(), false);
        }
        if (element.hasSecurity()) {
            this.composeConformanceConformanceRestSecurityComponent("security", element.getSecurity());
        }
        if (element.hasResource()) {
            this.openArray("resource");
            for (Conformance.ConformanceRestResourceComponent conformanceRestResourceComponent : element.getResource()) {
                this.composeConformanceConformanceRestResourceComponent(null, conformanceRestResourceComponent);
            }
            this.closeArray();
        }
        if (element.hasInteraction()) {
            this.openArray("interaction");
            for (Conformance.SystemInteractionComponent systemInteractionComponent : element.getInteraction()) {
                this.composeConformanceSystemInteractionComponent(null, systemInteractionComponent);
            }
            this.closeArray();
        }
        if (element.hasTransactionModeElement()) {
            this.composeEnumerationCore("transactionMode", element.getTransactionModeElement(), new Conformance.TransactionModeEnumFactory(), false);
            this.composeEnumerationExtras("transactionMode", element.getTransactionModeElement(), new Conformance.TransactionModeEnumFactory(), false);
        }
        if (element.hasSearchParam()) {
            this.openArray("searchParam");
            for (Conformance.ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent : element.getSearchParam()) {
                this.composeConformanceConformanceRestResourceSearchParamComponent(null, conformanceRestResourceSearchParamComponent);
            }
            this.closeArray();
        }
        if (element.hasOperation()) {
            this.openArray("operation");
            for (Conformance.ConformanceRestOperationComponent conformanceRestOperationComponent : element.getOperation()) {
                this.composeConformanceConformanceRestOperationComponent(null, conformanceRestOperationComponent);
            }
            this.closeArray();
        }
        if (element.hasCompartment()) {
            this.openArray("compartment");
            for (UriType uriType : element.getCompartment()) {
                this.composeUriCore(null, uriType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getCompartment())) {
                this.openArray("_compartment");
                for (UriType uriType : element.getCompartment()) {
                    this.composeUriExtras(null, uriType, true);
                }
                this.closeArray();
            }
        }
    }

    protected void composeConformanceConformanceRestSecurityComponent(String name, Conformance.ConformanceRestSecurityComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceConformanceRestSecurityComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceConformanceRestSecurityComponentInner(Conformance.ConformanceRestSecurityComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCorsElement()) {
            this.composeBooleanCore("cors", element.getCorsElement(), false);
            this.composeBooleanExtras("cors", element.getCorsElement(), false);
        }
        if (element.hasService()) {
            this.openArray("service");
            for (CodeableConcept codeableConcept : element.getService()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasCertificate()) {
            this.openArray("certificate");
            for (Conformance.ConformanceRestSecurityCertificateComponent conformanceRestSecurityCertificateComponent : element.getCertificate()) {
                this.composeConformanceConformanceRestSecurityCertificateComponent(null, conformanceRestSecurityCertificateComponent);
            }
            this.closeArray();
        }
    }

    protected void composeConformanceConformanceRestSecurityCertificateComponent(String name, Conformance.ConformanceRestSecurityCertificateComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceConformanceRestSecurityCertificateComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceConformanceRestSecurityCertificateComponentInner(Conformance.ConformanceRestSecurityCertificateComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasTypeElement()) {
            this.composeCodeCore("type", element.getTypeElement(), false);
            this.composeCodeExtras("type", element.getTypeElement(), false);
        }
        if (element.hasBlobElement()) {
            this.composeBase64BinaryCore("blob", element.getBlobElement(), false);
            this.composeBase64BinaryExtras("blob", element.getBlobElement(), false);
        }
    }

    protected void composeConformanceConformanceRestResourceComponent(String name, Conformance.ConformanceRestResourceComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceConformanceRestResourceComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceConformanceRestResourceComponentInner(Conformance.ConformanceRestResourceComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasTypeElement()) {
            this.composeCodeCore("type", element.getTypeElement(), false);
            this.composeCodeExtras("type", element.getTypeElement(), false);
        }
        if (element.hasProfile()) {
            this.composeReference("profile", element.getProfile());
        }
        if (element.hasInteraction()) {
            this.openArray("interaction");
            for (Conformance.ResourceInteractionComponent resourceInteractionComponent : element.getInteraction()) {
                this.composeConformanceResourceInteractionComponent(null, resourceInteractionComponent);
            }
            this.closeArray();
        }
        if (element.hasVersioningElement()) {
            this.composeEnumerationCore("versioning", element.getVersioningElement(), new Conformance.ResourceVersionPolicyEnumFactory(), false);
            this.composeEnumerationExtras("versioning", element.getVersioningElement(), new Conformance.ResourceVersionPolicyEnumFactory(), false);
        }
        if (element.hasReadHistoryElement()) {
            this.composeBooleanCore("readHistory", element.getReadHistoryElement(), false);
            this.composeBooleanExtras("readHistory", element.getReadHistoryElement(), false);
        }
        if (element.hasUpdateCreateElement()) {
            this.composeBooleanCore("updateCreate", element.getUpdateCreateElement(), false);
            this.composeBooleanExtras("updateCreate", element.getUpdateCreateElement(), false);
        }
        if (element.hasConditionalCreateElement()) {
            this.composeBooleanCore("conditionalCreate", element.getConditionalCreateElement(), false);
            this.composeBooleanExtras("conditionalCreate", element.getConditionalCreateElement(), false);
        }
        if (element.hasConditionalUpdateElement()) {
            this.composeBooleanCore("conditionalUpdate", element.getConditionalUpdateElement(), false);
            this.composeBooleanExtras("conditionalUpdate", element.getConditionalUpdateElement(), false);
        }
        if (element.hasConditionalDeleteElement()) {
            this.composeEnumerationCore("conditionalDelete", element.getConditionalDeleteElement(), new Conformance.ConditionalDeleteStatusEnumFactory(), false);
            this.composeEnumerationExtras("conditionalDelete", element.getConditionalDeleteElement(), new Conformance.ConditionalDeleteStatusEnumFactory(), false);
        }
        if (element.hasSearchInclude()) {
            this.openArray("searchInclude");
            for (StringType stringType : element.getSearchInclude()) {
                this.composeStringCore(null, stringType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getSearchInclude())) {
                this.openArray("_searchInclude");
                for (StringType stringType : element.getSearchInclude()) {
                    this.composeStringExtras(null, stringType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasSearchRevInclude()) {
            this.openArray("searchRevInclude");
            for (StringType stringType : element.getSearchRevInclude()) {
                this.composeStringCore(null, stringType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getSearchRevInclude())) {
                this.openArray("_searchRevInclude");
                for (StringType stringType : element.getSearchRevInclude()) {
                    this.composeStringExtras(null, stringType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasSearchParam()) {
            this.openArray("searchParam");
            for (Conformance.ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent : element.getSearchParam()) {
                this.composeConformanceConformanceRestResourceSearchParamComponent(null, conformanceRestResourceSearchParamComponent);
            }
            this.closeArray();
        }
    }

    protected void composeConformanceResourceInteractionComponent(String name, Conformance.ResourceInteractionComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceResourceInteractionComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceResourceInteractionComponentInner(Conformance.ResourceInteractionComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCodeElement()) {
            this.composeEnumerationCore("code", element.getCodeElement(), new Conformance.TypeRestfulInteractionEnumFactory(), false);
            this.composeEnumerationExtras("code", element.getCodeElement(), new Conformance.TypeRestfulInteractionEnumFactory(), false);
        }
        if (element.hasDocumentationElement()) {
            this.composeStringCore("documentation", element.getDocumentationElement(), false);
            this.composeStringExtras("documentation", element.getDocumentationElement(), false);
        }
    }

    protected void composeConformanceConformanceRestResourceSearchParamComponent(String name, Conformance.ConformanceRestResourceSearchParamComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceConformanceRestResourceSearchParamComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceConformanceRestResourceSearchParamComponentInner(Conformance.ConformanceRestResourceSearchParamComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasDefinitionElement()) {
            this.composeUriCore("definition", element.getDefinitionElement(), false);
            this.composeUriExtras("definition", element.getDefinitionElement(), false);
        }
        if (element.hasTypeElement()) {
            this.composeEnumerationCore("type", element.getTypeElement(), new Enumerations.SearchParamTypeEnumFactory(), false);
            this.composeEnumerationExtras("type", element.getTypeElement(), new Enumerations.SearchParamTypeEnumFactory(), false);
        }
        if (element.hasDocumentationElement()) {
            this.composeStringCore("documentation", element.getDocumentationElement(), false);
            this.composeStringExtras("documentation", element.getDocumentationElement(), false);
        }
        if (element.hasTarget()) {
            this.openArray("target");
            for (CodeType codeType : element.getTarget()) {
                this.composeCodeCore(null, codeType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getTarget())) {
                this.openArray("_target");
                for (CodeType codeType : element.getTarget()) {
                    this.composeCodeExtras(null, codeType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasModifier()) {
            this.openArray("modifier");
            for (Enumeration enumeration : element.getModifier()) {
                this.composeEnumerationCore(null, enumeration, new Conformance.SearchModifierCodeEnumFactory(), true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getModifier())) {
                this.openArray("_modifier");
                for (Enumeration enumeration : element.getModifier()) {
                    this.composeEnumerationExtras(null, enumeration, new Conformance.SearchModifierCodeEnumFactory(), true);
                }
                this.closeArray();
            }
        }
        if (element.hasChain()) {
            this.openArray("chain");
            for (StringType stringType : element.getChain()) {
                this.composeStringCore(null, stringType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getChain())) {
                this.openArray("_chain");
                for (StringType stringType : element.getChain()) {
                    this.composeStringExtras(null, stringType, true);
                }
                this.closeArray();
            }
        }
    }

    protected void composeConformanceSystemInteractionComponent(String name, Conformance.SystemInteractionComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceSystemInteractionComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceSystemInteractionComponentInner(Conformance.SystemInteractionComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCodeElement()) {
            this.composeEnumerationCore("code", element.getCodeElement(), new Conformance.SystemRestfulInteractionEnumFactory(), false);
            this.composeEnumerationExtras("code", element.getCodeElement(), new Conformance.SystemRestfulInteractionEnumFactory(), false);
        }
        if (element.hasDocumentationElement()) {
            this.composeStringCore("documentation", element.getDocumentationElement(), false);
            this.composeStringExtras("documentation", element.getDocumentationElement(), false);
        }
    }

    protected void composeConformanceConformanceRestOperationComponent(String name, Conformance.ConformanceRestOperationComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceConformanceRestOperationComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceConformanceRestOperationComponentInner(Conformance.ConformanceRestOperationComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasDefinition()) {
            this.composeReference("definition", element.getDefinition());
        }
    }

    protected void composeConformanceConformanceMessagingComponent(String name, Conformance.ConformanceMessagingComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceConformanceMessagingComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceConformanceMessagingComponentInner(Conformance.ConformanceMessagingComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasEndpoint()) {
            this.openArray("endpoint");
            for (Conformance.ConformanceMessagingEndpointComponent conformanceMessagingEndpointComponent : element.getEndpoint()) {
                this.composeConformanceConformanceMessagingEndpointComponent(null, conformanceMessagingEndpointComponent);
            }
            this.closeArray();
        }
        if (element.hasReliableCacheElement()) {
            this.composeUnsignedIntCore("reliableCache", element.getReliableCacheElement(), false);
            this.composeUnsignedIntExtras("reliableCache", element.getReliableCacheElement(), false);
        }
        if (element.hasDocumentationElement()) {
            this.composeStringCore("documentation", element.getDocumentationElement(), false);
            this.composeStringExtras("documentation", element.getDocumentationElement(), false);
        }
        if (element.hasEvent()) {
            this.openArray("event");
            for (Conformance.ConformanceMessagingEventComponent conformanceMessagingEventComponent : element.getEvent()) {
                this.composeConformanceConformanceMessagingEventComponent(null, conformanceMessagingEventComponent);
            }
            this.closeArray();
        }
    }

    protected void composeConformanceConformanceMessagingEndpointComponent(String name, Conformance.ConformanceMessagingEndpointComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceConformanceMessagingEndpointComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceConformanceMessagingEndpointComponentInner(Conformance.ConformanceMessagingEndpointComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasProtocol()) {
            this.composeCoding("protocol", element.getProtocol());
        }
        if (element.hasAddressElement()) {
            this.composeUriCore("address", element.getAddressElement(), false);
            this.composeUriExtras("address", element.getAddressElement(), false);
        }
    }

    protected void composeConformanceConformanceMessagingEventComponent(String name, Conformance.ConformanceMessagingEventComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceConformanceMessagingEventComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceConformanceMessagingEventComponentInner(Conformance.ConformanceMessagingEventComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCode()) {
            this.composeCoding("code", element.getCode());
        }
        if (element.hasCategoryElement()) {
            this.composeEnumerationCore("category", element.getCategoryElement(), new Conformance.MessageSignificanceCategoryEnumFactory(), false);
            this.composeEnumerationExtras("category", element.getCategoryElement(), new Conformance.MessageSignificanceCategoryEnumFactory(), false);
        }
        if (element.hasModeElement()) {
            this.composeEnumerationCore("mode", element.getModeElement(), new Conformance.ConformanceEventModeEnumFactory(), false);
            this.composeEnumerationExtras("mode", element.getModeElement(), new Conformance.ConformanceEventModeEnumFactory(), false);
        }
        if (element.hasFocusElement()) {
            this.composeCodeCore("focus", element.getFocusElement(), false);
            this.composeCodeExtras("focus", element.getFocusElement(), false);
        }
        if (element.hasRequest()) {
            this.composeReference("request", element.getRequest());
        }
        if (element.hasResponse()) {
            this.composeReference("response", element.getResponse());
        }
        if (element.hasDocumentationElement()) {
            this.composeStringCore("documentation", element.getDocumentationElement(), false);
            this.composeStringExtras("documentation", element.getDocumentationElement(), false);
        }
    }

    protected void composeConformanceConformanceDocumentComponent(String name, Conformance.ConformanceDocumentComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeConformanceConformanceDocumentComponentInner(element);
            this.close();
        }
    }

    protected void composeConformanceConformanceDocumentComponentInner(Conformance.ConformanceDocumentComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasModeElement()) {
            this.composeEnumerationCore("mode", element.getModeElement(), new Conformance.DocumentModeEnumFactory(), false);
            this.composeEnumerationExtras("mode", element.getModeElement(), new Conformance.DocumentModeEnumFactory(), false);
        }
        if (element.hasDocumentationElement()) {
            this.composeStringCore("documentation", element.getDocumentationElement(), false);
            this.composeStringExtras("documentation", element.getDocumentationElement(), false);
        }
        if (element.hasProfile()) {
            this.composeReference("profile", element.getProfile());
        }
    }

    protected void composeContract(String name, Contract element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeContractInner(element);
        }
    }

    protected void composeContractInner(Contract element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.composeIdentifier("identifier", element.getIdentifier());
        }
        if (element.hasIssuedElement()) {
            this.composeDateTimeCore("issued", element.getIssuedElement(), false);
            this.composeDateTimeExtras("issued", element.getIssuedElement(), false);
        }
        if (element.hasApplies()) {
            this.composePeriod("applies", element.getApplies());
        }
        if (element.hasSubject()) {
            this.openArray("subject");
            for (Reference reference : element.getSubject()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasAuthority()) {
            this.openArray("authority");
            for (Reference reference : element.getAuthority()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasDomain()) {
            this.openArray("domain");
            for (Reference reference : element.getDomain()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasType()) {
            this.composeCodeableConcept("type", element.getType());
        }
        if (element.hasSubType()) {
            this.openArray("subType");
            for (CodeableConcept codeableConcept : element.getSubType()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasAction()) {
            this.openArray("action");
            for (CodeableConcept codeableConcept : element.getAction()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasActionReason()) {
            this.openArray("actionReason");
            for (CodeableConcept codeableConcept : element.getActionReason()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasActor()) {
            this.openArray("actor");
            for (Contract.ActorComponent actorComponent : element.getActor()) {
                this.composeContractActorComponent(null, actorComponent);
            }
            this.closeArray();
        }
        if (element.hasValuedItem()) {
            this.openArray("valuedItem");
            for (Contract.ValuedItemComponent valuedItemComponent : element.getValuedItem()) {
                this.composeContractValuedItemComponent(null, valuedItemComponent);
            }
            this.closeArray();
        }
        if (element.hasSigner()) {
            this.openArray("signer");
            for (Contract.SignatoryComponent signatoryComponent : element.getSigner()) {
                this.composeContractSignatoryComponent(null, signatoryComponent);
            }
            this.closeArray();
        }
        if (element.hasTerm()) {
            this.openArray("term");
            for (Contract.TermComponent termComponent : element.getTerm()) {
                this.composeContractTermComponent(null, termComponent);
            }
            this.closeArray();
        }
        if (element.hasBinding()) {
            this.composeType("binding", element.getBinding());
        }
        if (element.hasFriendly()) {
            this.openArray("friendly");
            for (Contract.FriendlyLanguageComponent friendlyLanguageComponent : element.getFriendly()) {
                this.composeContractFriendlyLanguageComponent(null, friendlyLanguageComponent);
            }
            this.closeArray();
        }
        if (element.hasLegal()) {
            this.openArray("legal");
            for (Contract.LegalLanguageComponent legalLanguageComponent : element.getLegal()) {
                this.composeContractLegalLanguageComponent(null, legalLanguageComponent);
            }
            this.closeArray();
        }
        if (element.hasRule()) {
            this.openArray("rule");
            for (Contract.ComputableLanguageComponent computableLanguageComponent : element.getRule()) {
                this.composeContractComputableLanguageComponent(null, computableLanguageComponent);
            }
            this.closeArray();
        }
    }

    protected void composeContractActorComponent(String name, Contract.ActorComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeContractActorComponentInner(element);
            this.close();
        }
    }

    protected void composeContractActorComponentInner(Contract.ActorComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasEntity()) {
            this.composeReference("entity", element.getEntity());
        }
        if (element.hasRole()) {
            this.openArray("role");
            for (CodeableConcept e : element.getRole()) {
                this.composeCodeableConcept(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeContractValuedItemComponent(String name, Contract.ValuedItemComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeContractValuedItemComponentInner(element);
            this.close();
        }
    }

    protected void composeContractValuedItemComponentInner(Contract.ValuedItemComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasEntity()) {
            this.composeType("entity", element.getEntity());
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier("identifier", element.getIdentifier());
        }
        if (element.hasEffectiveTimeElement()) {
            this.composeDateTimeCore("effectiveTime", element.getEffectiveTimeElement(), false);
            this.composeDateTimeExtras("effectiveTime", element.getEffectiveTimeElement(), false);
        }
        if (element.hasQuantity()) {
            this.composeSimpleQuantity("quantity", element.getQuantity());
        }
        if (element.hasUnitPrice()) {
            this.composeMoney("unitPrice", element.getUnitPrice());
        }
        if (element.hasFactorElement()) {
            this.composeDecimalCore("factor", element.getFactorElement(), false);
            this.composeDecimalExtras("factor", element.getFactorElement(), false);
        }
        if (element.hasPointsElement()) {
            this.composeDecimalCore("points", element.getPointsElement(), false);
            this.composeDecimalExtras("points", element.getPointsElement(), false);
        }
        if (element.hasNet()) {
            this.composeMoney("net", element.getNet());
        }
    }

    protected void composeContractSignatoryComponent(String name, Contract.SignatoryComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeContractSignatoryComponentInner(element);
            this.close();
        }
    }

    protected void composeContractSignatoryComponentInner(Contract.SignatoryComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasType()) {
            this.composeCoding("type", element.getType());
        }
        if (element.hasParty()) {
            this.composeReference("party", element.getParty());
        }
        if (element.hasSignatureElement()) {
            this.composeStringCore("signature", element.getSignatureElement(), false);
            this.composeStringExtras("signature", element.getSignatureElement(), false);
        }
    }

    protected void composeContractTermComponent(String name, Contract.TermComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeContractTermComponentInner(element);
            this.close();
        }
    }

    protected void composeContractTermComponentInner(Contract.TermComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasIdentifier()) {
            this.composeIdentifier("identifier", element.getIdentifier());
        }
        if (element.hasIssuedElement()) {
            this.composeDateTimeCore("issued", element.getIssuedElement(), false);
            this.composeDateTimeExtras("issued", element.getIssuedElement(), false);
        }
        if (element.hasApplies()) {
            this.composePeriod("applies", element.getApplies());
        }
        if (element.hasType()) {
            this.composeCodeableConcept("type", element.getType());
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept("subType", element.getSubType());
        }
        if (element.hasSubject()) {
            this.composeReference("subject", element.getSubject());
        }
        if (element.hasAction()) {
            this.openArray("action");
            for (CodeableConcept codeableConcept : element.getAction()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasActionReason()) {
            this.openArray("actionReason");
            for (CodeableConcept codeableConcept : element.getActionReason()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasActor()) {
            this.openArray("actor");
            for (Contract.TermActorComponent termActorComponent : element.getActor()) {
                this.composeContractTermActorComponent(null, termActorComponent);
            }
            this.closeArray();
        }
        if (element.hasTextElement()) {
            this.composeStringCore("text", element.getTextElement(), false);
            this.composeStringExtras("text", element.getTextElement(), false);
        }
        if (element.hasValuedItem()) {
            this.openArray("valuedItem");
            for (Contract.TermValuedItemComponent termValuedItemComponent : element.getValuedItem()) {
                this.composeContractTermValuedItemComponent(null, termValuedItemComponent);
            }
            this.closeArray();
        }
        if (element.hasGroup()) {
            this.openArray("group");
            for (Contract.TermComponent termComponent : element.getGroup()) {
                this.composeContractTermComponent(null, termComponent);
            }
            this.closeArray();
        }
    }

    protected void composeContractTermActorComponent(String name, Contract.TermActorComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeContractTermActorComponentInner(element);
            this.close();
        }
    }

    protected void composeContractTermActorComponentInner(Contract.TermActorComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasEntity()) {
            this.composeReference("entity", element.getEntity());
        }
        if (element.hasRole()) {
            this.openArray("role");
            for (CodeableConcept e : element.getRole()) {
                this.composeCodeableConcept(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeContractTermValuedItemComponent(String name, Contract.TermValuedItemComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeContractTermValuedItemComponentInner(element);
            this.close();
        }
    }

    protected void composeContractTermValuedItemComponentInner(Contract.TermValuedItemComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasEntity()) {
            this.composeType("entity", element.getEntity());
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier("identifier", element.getIdentifier());
        }
        if (element.hasEffectiveTimeElement()) {
            this.composeDateTimeCore("effectiveTime", element.getEffectiveTimeElement(), false);
            this.composeDateTimeExtras("effectiveTime", element.getEffectiveTimeElement(), false);
        }
        if (element.hasQuantity()) {
            this.composeSimpleQuantity("quantity", element.getQuantity());
        }
        if (element.hasUnitPrice()) {
            this.composeMoney("unitPrice", element.getUnitPrice());
        }
        if (element.hasFactorElement()) {
            this.composeDecimalCore("factor", element.getFactorElement(), false);
            this.composeDecimalExtras("factor", element.getFactorElement(), false);
        }
        if (element.hasPointsElement()) {
            this.composeDecimalCore("points", element.getPointsElement(), false);
            this.composeDecimalExtras("points", element.getPointsElement(), false);
        }
        if (element.hasNet()) {
            this.composeMoney("net", element.getNet());
        }
    }

    protected void composeContractFriendlyLanguageComponent(String name, Contract.FriendlyLanguageComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeContractFriendlyLanguageComponentInner(element);
            this.close();
        }
    }

    protected void composeContractFriendlyLanguageComponentInner(Contract.FriendlyLanguageComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasContent()) {
            this.composeType("content", element.getContent());
        }
    }

    protected void composeContractLegalLanguageComponent(String name, Contract.LegalLanguageComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeContractLegalLanguageComponentInner(element);
            this.close();
        }
    }

    protected void composeContractLegalLanguageComponentInner(Contract.LegalLanguageComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasContent()) {
            this.composeType("content", element.getContent());
        }
    }

    protected void composeContractComputableLanguageComponent(String name, Contract.ComputableLanguageComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeContractComputableLanguageComponentInner(element);
            this.close();
        }
    }

    protected void composeContractComputableLanguageComponentInner(Contract.ComputableLanguageComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasContent()) {
            this.composeType("content", element.getContent());
        }
    }

    protected void composeCoverage(String name, Coverage element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeCoverageInner(element);
        }
    }

    protected void composeCoverageInner(Coverage element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIssuer()) {
            this.composeReference("issuer", element.getIssuer());
        }
        if (element.hasBin()) {
            this.composeIdentifier("bin", element.getBin());
        }
        if (element.hasPeriod()) {
            this.composePeriod("period", element.getPeriod());
        }
        if (element.hasType()) {
            this.composeCoding("type", element.getType());
        }
        if (element.hasSubscriberId()) {
            this.composeIdentifier("subscriberId", element.getSubscriberId());
        }
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasGroupElement()) {
            this.composeStringCore("group", element.getGroupElement(), false);
            this.composeStringExtras("group", element.getGroupElement(), false);
        }
        if (element.hasPlanElement()) {
            this.composeStringCore("plan", element.getPlanElement(), false);
            this.composeStringExtras("plan", element.getPlanElement(), false);
        }
        if (element.hasSubPlanElement()) {
            this.composeStringCore("subPlan", element.getSubPlanElement(), false);
            this.composeStringExtras("subPlan", element.getSubPlanElement(), false);
        }
        if (element.hasDependentElement()) {
            this.composePositiveIntCore("dependent", element.getDependentElement(), false);
            this.composePositiveIntExtras("dependent", element.getDependentElement(), false);
        }
        if (element.hasSequenceElement()) {
            this.composePositiveIntCore("sequence", element.getSequenceElement(), false);
            this.composePositiveIntExtras("sequence", element.getSequenceElement(), false);
        }
        if (element.hasSubscriber()) {
            this.composeReference("subscriber", element.getSubscriber());
        }
        if (element.hasNetwork()) {
            this.composeIdentifier("network", element.getNetwork());
        }
        if (element.hasContract()) {
            this.openArray("contract");
            for (Reference reference : element.getContract()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
    }

    protected void composeDataElement(String name, DataElement element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeDataElementInner(element);
        }
    }

    protected void composeDataElementInner(DataElement element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasUrlElement()) {
            this.composeUriCore("url", element.getUrlElement(), false);
            this.composeUriExtras("url", element.getUrlElement(), false);
        }
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasVersionElement()) {
            this.composeStringCore("version", element.getVersionElement(), false);
            this.composeStringExtras("version", element.getVersionElement(), false);
        }
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new Enumerations.ConformanceResourceStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new Enumerations.ConformanceResourceStatusEnumFactory(), false);
        }
        if (element.hasExperimentalElement()) {
            this.composeBooleanCore("experimental", element.getExperimentalElement(), false);
            this.composeBooleanExtras("experimental", element.getExperimentalElement(), false);
        }
        if (element.hasPublisherElement()) {
            this.composeStringCore("publisher", element.getPublisherElement(), false);
            this.composeStringExtras("publisher", element.getPublisherElement(), false);
        }
        if (element.hasContact()) {
            this.openArray("contact");
            for (DataElement.DataElementContactComponent dataElementContactComponent : element.getContact()) {
                this.composeDataElementDataElementContactComponent(null, dataElementContactComponent);
            }
            this.closeArray();
        }
        if (element.hasDateElement()) {
            this.composeDateTimeCore("date", element.getDateElement(), false);
            this.composeDateTimeExtras("date", element.getDateElement(), false);
        }
        if (element.hasUseContext()) {
            this.openArray("useContext");
            for (CodeableConcept codeableConcept : element.getUseContext()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasCopyrightElement()) {
            this.composeStringCore("copyright", element.getCopyrightElement(), false);
            this.composeStringExtras("copyright", element.getCopyrightElement(), false);
        }
        if (element.hasStringencyElement()) {
            this.composeEnumerationCore("stringency", element.getStringencyElement(), new DataElement.DataElementStringencyEnumFactory(), false);
            this.composeEnumerationExtras("stringency", element.getStringencyElement(), new DataElement.DataElementStringencyEnumFactory(), false);
        }
        if (element.hasMapping()) {
            this.openArray("mapping");
            for (DataElement.DataElementMappingComponent dataElementMappingComponent : element.getMapping()) {
                this.composeDataElementDataElementMappingComponent(null, dataElementMappingComponent);
            }
            this.closeArray();
        }
        if (element.hasElement()) {
            this.openArray("element");
            for (ElementDefinition elementDefinition : element.getElement()) {
                this.composeElementDefinition(null, elementDefinition);
            }
            this.closeArray();
        }
    }

    protected void composeDataElementDataElementContactComponent(String name, DataElement.DataElementContactComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDataElementDataElementContactComponentInner(element);
            this.close();
        }
    }

    protected void composeDataElementDataElementContactComponentInner(DataElement.DataElementContactComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasTelecom()) {
            this.openArray("telecom");
            for (ContactPoint e : element.getTelecom()) {
                this.composeContactPoint(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeDataElementDataElementMappingComponent(String name, DataElement.DataElementMappingComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDataElementDataElementMappingComponentInner(element);
            this.close();
        }
    }

    protected void composeDataElementDataElementMappingComponentInner(DataElement.DataElementMappingComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasIdentityElement()) {
            this.composeIdCore("identity", element.getIdentityElement(), false);
            this.composeIdExtras("identity", element.getIdentityElement(), false);
        }
        if (element.hasUriElement()) {
            this.composeUriCore("uri", element.getUriElement(), false);
            this.composeUriExtras("uri", element.getUriElement(), false);
        }
        if (element.hasNameElement()) {
            this.composeStringCore("name", element.getNameElement(), false);
            this.composeStringExtras("name", element.getNameElement(), false);
        }
        if (element.hasCommentsElement()) {
            this.composeStringCore("comments", element.getCommentsElement(), false);
            this.composeStringExtras("comments", element.getCommentsElement(), false);
        }
    }

    protected void composeDetectedIssue(String name, DetectedIssue element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeDetectedIssueInner(element);
        }
    }

    protected void composeDetectedIssueInner(DetectedIssue element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasPatient()) {
            this.composeReference("patient", element.getPatient());
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept("category", element.getCategory());
        }
        if (element.hasSeverityElement()) {
            this.composeEnumerationCore("severity", element.getSeverityElement(), new DetectedIssue.DetectedIssueSeverityEnumFactory(), false);
            this.composeEnumerationExtras("severity", element.getSeverityElement(), new DetectedIssue.DetectedIssueSeverityEnumFactory(), false);
        }
        if (element.hasImplicated()) {
            this.openArray("implicated");
            for (Reference reference : element.getImplicated()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasDetailElement()) {
            this.composeStringCore("detail", element.getDetailElement(), false);
            this.composeStringExtras("detail", element.getDetailElement(), false);
        }
        if (element.hasDateElement()) {
            this.composeDateTimeCore("date", element.getDateElement(), false);
            this.composeDateTimeExtras("date", element.getDateElement(), false);
        }
        if (element.hasAuthor()) {
            this.composeReference("author", element.getAuthor());
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier("identifier", element.getIdentifier());
        }
        if (element.hasReferenceElement()) {
            this.composeUriCore("reference", element.getReferenceElement(), false);
            this.composeUriExtras("reference", element.getReferenceElement(), false);
        }
        if (element.hasMitigation()) {
            this.openArray("mitigation");
            for (DetectedIssue.DetectedIssueMitigationComponent detectedIssueMitigationComponent : element.getMitigation()) {
                this.composeDetectedIssueDetectedIssueMitigationComponent(null, detectedIssueMitigationComponent);
            }
            this.closeArray();
        }
    }

    protected void composeDetectedIssueDetectedIssueMitigationComponent(String name, DetectedIssue.DetectedIssueMitigationComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDetectedIssueDetectedIssueMitigationComponentInner(element);
            this.close();
        }
    }

    protected void composeDetectedIssueDetectedIssueMitigationComponentInner(DetectedIssue.DetectedIssueMitigationComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasAction()) {
            this.composeCodeableConcept("action", element.getAction());
        }
        if (element.hasDateElement()) {
            this.composeDateTimeCore("date", element.getDateElement(), false);
            this.composeDateTimeExtras("date", element.getDateElement(), false);
        }
        if (element.hasAuthor()) {
            this.composeReference("author", element.getAuthor());
        }
    }

    protected void composeDevice(String name, Device element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeDeviceInner(element);
        }
    }

    protected void composeDeviceInner(Device element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasType()) {
            this.composeCodeableConcept("type", element.getType());
        }
        if (element.hasNote()) {
            this.openArray("note");
            for (Annotation annotation : element.getNote()) {
                this.composeAnnotation(null, annotation);
            }
            this.closeArray();
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new Device.DeviceStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new Device.DeviceStatusEnumFactory(), false);
        }
        if (element.hasManufacturerElement()) {
            this.composeStringCore("manufacturer", element.getManufacturerElement(), false);
            this.composeStringExtras("manufacturer", element.getManufacturerElement(), false);
        }
        if (element.hasModelElement()) {
            this.composeStringCore("model", element.getModelElement(), false);
            this.composeStringExtras("model", element.getModelElement(), false);
        }
        if (element.hasVersionElement()) {
            this.composeStringCore("version", element.getVersionElement(), false);
            this.composeStringExtras("version", element.getVersionElement(), false);
        }
        if (element.hasManufactureDateElement()) {
            this.composeDateTimeCore("manufactureDate", element.getManufactureDateElement(), false);
            this.composeDateTimeExtras("manufactureDate", element.getManufactureDateElement(), false);
        }
        if (element.hasExpiryElement()) {
            this.composeDateTimeCore("expiry", element.getExpiryElement(), false);
            this.composeDateTimeExtras("expiry", element.getExpiryElement(), false);
        }
        if (element.hasUdiElement()) {
            this.composeStringCore("udi", element.getUdiElement(), false);
            this.composeStringExtras("udi", element.getUdiElement(), false);
        }
        if (element.hasLotNumberElement()) {
            this.composeStringCore("lotNumber", element.getLotNumberElement(), false);
            this.composeStringExtras("lotNumber", element.getLotNumberElement(), false);
        }
        if (element.hasOwner()) {
            this.composeReference("owner", element.getOwner());
        }
        if (element.hasLocation()) {
            this.composeReference("location", element.getLocation());
        }
        if (element.hasPatient()) {
            this.composeReference("patient", element.getPatient());
        }
        if (element.hasContact()) {
            this.openArray("contact");
            for (ContactPoint contactPoint : element.getContact()) {
                this.composeContactPoint(null, contactPoint);
            }
            this.closeArray();
        }
        if (element.hasUrlElement()) {
            this.composeUriCore("url", element.getUrlElement(), false);
            this.composeUriExtras("url", element.getUrlElement(), false);
        }
    }

    protected void composeDeviceComponent(String name, DeviceComponent element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeDeviceComponentInner(element);
        }
    }

    protected void composeDeviceComponentInner(DeviceComponent element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasType()) {
            this.composeCodeableConcept("type", element.getType());
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier("identifier", element.getIdentifier());
        }
        if (element.hasLastSystemChangeElement()) {
            this.composeInstantCore("lastSystemChange", element.getLastSystemChangeElement(), false);
            this.composeInstantExtras("lastSystemChange", element.getLastSystemChangeElement(), false);
        }
        if (element.hasSource()) {
            this.composeReference("source", element.getSource());
        }
        if (element.hasParent()) {
            this.composeReference("parent", element.getParent());
        }
        if (element.hasOperationalStatus()) {
            this.openArray("operationalStatus");
            for (CodeableConcept codeableConcept : element.getOperationalStatus()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasParameterGroup()) {
            this.composeCodeableConcept("parameterGroup", element.getParameterGroup());
        }
        if (element.hasMeasurementPrincipleElement()) {
            this.composeEnumerationCore("measurementPrinciple", element.getMeasurementPrincipleElement(), new DeviceComponent.MeasmntPrincipleEnumFactory(), false);
            this.composeEnumerationExtras("measurementPrinciple", element.getMeasurementPrincipleElement(), new DeviceComponent.MeasmntPrincipleEnumFactory(), false);
        }
        if (element.hasProductionSpecification()) {
            this.openArray("productionSpecification");
            for (DeviceComponent.DeviceComponentProductionSpecificationComponent deviceComponentProductionSpecificationComponent : element.getProductionSpecification()) {
                this.composeDeviceComponentDeviceComponentProductionSpecificationComponent(null, deviceComponentProductionSpecificationComponent);
            }
            this.closeArray();
        }
        if (element.hasLanguageCode()) {
            this.composeCodeableConcept("languageCode", element.getLanguageCode());
        }
    }

    protected void composeDeviceComponentDeviceComponentProductionSpecificationComponent(String name, DeviceComponent.DeviceComponentProductionSpecificationComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDeviceComponentDeviceComponentProductionSpecificationComponentInner(element);
            this.close();
        }
    }

    protected void composeDeviceComponentDeviceComponentProductionSpecificationComponentInner(DeviceComponent.DeviceComponentProductionSpecificationComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasSpecType()) {
            this.composeCodeableConcept("specType", element.getSpecType());
        }
        if (element.hasComponentId()) {
            this.composeIdentifier("componentId", element.getComponentId());
        }
        if (element.hasProductionSpecElement()) {
            this.composeStringCore("productionSpec", element.getProductionSpecElement(), false);
            this.composeStringExtras("productionSpec", element.getProductionSpecElement(), false);
        }
    }

    protected void composeDeviceMetric(String name, DeviceMetric element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeDeviceMetricInner(element);
        }
    }

    protected void composeDeviceMetricInner(DeviceMetric element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasType()) {
            this.composeCodeableConcept("type", element.getType());
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier("identifier", element.getIdentifier());
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept("unit", element.getUnit());
        }
        if (element.hasSource()) {
            this.composeReference("source", element.getSource());
        }
        if (element.hasParent()) {
            this.composeReference("parent", element.getParent());
        }
        if (element.hasOperationalStatusElement()) {
            this.composeEnumerationCore("operationalStatus", element.getOperationalStatusElement(), new DeviceMetric.DeviceMetricOperationalStatusEnumFactory(), false);
            this.composeEnumerationExtras("operationalStatus", element.getOperationalStatusElement(), new DeviceMetric.DeviceMetricOperationalStatusEnumFactory(), false);
        }
        if (element.hasColorElement()) {
            this.composeEnumerationCore("color", element.getColorElement(), new DeviceMetric.DeviceMetricColorEnumFactory(), false);
            this.composeEnumerationExtras("color", element.getColorElement(), new DeviceMetric.DeviceMetricColorEnumFactory(), false);
        }
        if (element.hasCategoryElement()) {
            this.composeEnumerationCore("category", element.getCategoryElement(), new DeviceMetric.DeviceMetricCategoryEnumFactory(), false);
            this.composeEnumerationExtras("category", element.getCategoryElement(), new DeviceMetric.DeviceMetricCategoryEnumFactory(), false);
        }
        if (element.hasMeasurementPeriod()) {
            this.composeTiming("measurementPeriod", element.getMeasurementPeriod());
        }
        if (element.hasCalibration()) {
            this.openArray("calibration");
            for (DeviceMetric.DeviceMetricCalibrationComponent e : element.getCalibration()) {
                this.composeDeviceMetricDeviceMetricCalibrationComponent(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeDeviceMetricDeviceMetricCalibrationComponent(String name, DeviceMetric.DeviceMetricCalibrationComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDeviceMetricDeviceMetricCalibrationComponentInner(element);
            this.close();
        }
    }

    protected void composeDeviceMetricDeviceMetricCalibrationComponentInner(DeviceMetric.DeviceMetricCalibrationComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasTypeElement()) {
            this.composeEnumerationCore("type", element.getTypeElement(), new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory(), false);
            this.composeEnumerationExtras("type", element.getTypeElement(), new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory(), false);
        }
        if (element.hasStateElement()) {
            this.composeEnumerationCore("state", element.getStateElement(), new DeviceMetric.DeviceMetricCalibrationStateEnumFactory(), false);
            this.composeEnumerationExtras("state", element.getStateElement(), new DeviceMetric.DeviceMetricCalibrationStateEnumFactory(), false);
        }
        if (element.hasTimeElement()) {
            this.composeInstantCore("time", element.getTimeElement(), false);
            this.composeInstantExtras("time", element.getTimeElement(), false);
        }
    }

    protected void composeDeviceUseRequest(String name, DeviceUseRequest element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeDeviceUseRequestInner(element);
        }
    }

    protected void composeDeviceUseRequestInner(DeviceUseRequest element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasBodySite()) {
            this.composeType("bodySite", element.getBodySite());
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new DeviceUseRequest.DeviceUseRequestStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new DeviceUseRequest.DeviceUseRequestStatusEnumFactory(), false);
        }
        if (element.hasDevice()) {
            this.composeReference("device", element.getDevice());
        }
        if (element.hasEncounter()) {
            this.composeReference("encounter", element.getEncounter());
        }
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasIndication()) {
            this.openArray("indication");
            for (CodeableConcept codeableConcept : element.getIndication()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasNotes()) {
            this.openArray("notes");
            for (StringType stringType : element.getNotes()) {
                this.composeStringCore(null, stringType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getNotes())) {
                this.openArray("_notes");
                for (StringType stringType : element.getNotes()) {
                    this.composeStringExtras(null, stringType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasPrnReason()) {
            this.openArray("prnReason");
            for (CodeableConcept codeableConcept : element.getPrnReason()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasOrderedOnElement()) {
            this.composeDateTimeCore("orderedOn", element.getOrderedOnElement(), false);
            this.composeDateTimeExtras("orderedOn", element.getOrderedOnElement(), false);
        }
        if (element.hasRecordedOnElement()) {
            this.composeDateTimeCore("recordedOn", element.getRecordedOnElement(), false);
            this.composeDateTimeExtras("recordedOn", element.getRecordedOnElement(), false);
        }
        if (element.hasSubject()) {
            this.composeReference("subject", element.getSubject());
        }
        if (element.hasTiming()) {
            this.composeType("timing", element.getTiming());
        }
        if (element.hasPriorityElement()) {
            this.composeEnumerationCore("priority", element.getPriorityElement(), new DeviceUseRequest.DeviceUseRequestPriorityEnumFactory(), false);
            this.composeEnumerationExtras("priority", element.getPriorityElement(), new DeviceUseRequest.DeviceUseRequestPriorityEnumFactory(), false);
        }
    }

    protected void composeDeviceUseStatement(String name, DeviceUseStatement element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeDeviceUseStatementInner(element);
        }
    }

    protected void composeDeviceUseStatementInner(DeviceUseStatement element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasBodySite()) {
            this.composeType("bodySite", element.getBodySite());
        }
        if (element.hasWhenUsed()) {
            this.composePeriod("whenUsed", element.getWhenUsed());
        }
        if (element.hasDevice()) {
            this.composeReference("device", element.getDevice());
        }
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasIndication()) {
            this.openArray("indication");
            for (CodeableConcept codeableConcept : element.getIndication()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasNotes()) {
            this.openArray("notes");
            for (StringType stringType : element.getNotes()) {
                this.composeStringCore(null, stringType, true);
            }
            this.closeArray();
            if (this.anyHasExtras(element.getNotes())) {
                this.openArray("_notes");
                for (StringType stringType : element.getNotes()) {
                    this.composeStringExtras(null, stringType, true);
                }
                this.closeArray();
            }
        }
        if (element.hasRecordedOnElement()) {
            this.composeDateTimeCore("recordedOn", element.getRecordedOnElement(), false);
            this.composeDateTimeExtras("recordedOn", element.getRecordedOnElement(), false);
        }
        if (element.hasSubject()) {
            this.composeReference("subject", element.getSubject());
        }
        if (element.hasTiming()) {
            this.composeType("timing", element.getTiming());
        }
    }

    protected void composeDiagnosticOrder(String name, DiagnosticOrder element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeDiagnosticOrderInner(element);
        }
    }

    protected void composeDiagnosticOrderInner(DiagnosticOrder element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasSubject()) {
            this.composeReference("subject", element.getSubject());
        }
        if (element.hasOrderer()) {
            this.composeReference("orderer", element.getOrderer());
        }
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasEncounter()) {
            this.composeReference("encounter", element.getEncounter());
        }
        if (element.hasReason()) {
            this.openArray("reason");
            for (CodeableConcept codeableConcept : element.getReason()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasSupportingInformation()) {
            this.openArray("supportingInformation");
            for (Reference reference : element.getSupportingInformation()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasSpecimen()) {
            this.openArray("specimen");
            for (Reference reference : element.getSpecimen()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory(), false);
        }
        if (element.hasPriorityElement()) {
            this.composeEnumerationCore("priority", element.getPriorityElement(), new DiagnosticOrder.DiagnosticOrderPriorityEnumFactory(), false);
            this.composeEnumerationExtras("priority", element.getPriorityElement(), new DiagnosticOrder.DiagnosticOrderPriorityEnumFactory(), false);
        }
        if (element.hasEvent()) {
            this.openArray("event");
            for (DiagnosticOrder.DiagnosticOrderEventComponent diagnosticOrderEventComponent : element.getEvent()) {
                this.composeDiagnosticOrderDiagnosticOrderEventComponent(null, diagnosticOrderEventComponent);
            }
            this.closeArray();
        }
        if (element.hasItem()) {
            this.openArray("item");
            for (DiagnosticOrder.DiagnosticOrderItemComponent diagnosticOrderItemComponent : element.getItem()) {
                this.composeDiagnosticOrderDiagnosticOrderItemComponent(null, diagnosticOrderItemComponent);
            }
            this.closeArray();
        }
        if (element.hasNote()) {
            this.openArray("note");
            for (Annotation annotation : element.getNote()) {
                this.composeAnnotation(null, annotation);
            }
            this.closeArray();
        }
    }

    protected void composeDiagnosticOrderDiagnosticOrderEventComponent(String name, DiagnosticOrder.DiagnosticOrderEventComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDiagnosticOrderDiagnosticOrderEventComponentInner(element);
            this.close();
        }
    }

    protected void composeDiagnosticOrderDiagnosticOrderEventComponentInner(DiagnosticOrder.DiagnosticOrderEventComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory(), false);
        }
        if (element.hasDescription()) {
            this.composeCodeableConcept("description", element.getDescription());
        }
        if (element.hasDateTimeElement()) {
            this.composeDateTimeCore("dateTime", element.getDateTimeElement(), false);
            this.composeDateTimeExtras("dateTime", element.getDateTimeElement(), false);
        }
        if (element.hasActor()) {
            this.composeReference("actor", element.getActor());
        }
    }

    protected void composeDiagnosticOrderDiagnosticOrderItemComponent(String name, DiagnosticOrder.DiagnosticOrderItemComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDiagnosticOrderDiagnosticOrderItemComponentInner(element);
            this.close();
        }
    }

    protected void composeDiagnosticOrderDiagnosticOrderItemComponentInner(DiagnosticOrder.DiagnosticOrderItemComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCode()) {
            this.composeCodeableConcept("code", element.getCode());
        }
        if (element.hasSpecimen()) {
            this.openArray("specimen");
            for (Reference reference : element.getSpecimen()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept("bodySite", element.getBodySite());
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory(), false);
        }
        if (element.hasEvent()) {
            this.openArray("event");
            for (DiagnosticOrder.DiagnosticOrderEventComponent diagnosticOrderEventComponent : element.getEvent()) {
                this.composeDiagnosticOrderDiagnosticOrderEventComponent(null, diagnosticOrderEventComponent);
            }
            this.closeArray();
        }
    }

    protected void composeDiagnosticReport(String name, DiagnosticReport element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeDiagnosticReportInner(element);
        }
    }

    protected void composeDiagnosticReportInner(DiagnosticReport element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new DiagnosticReport.DiagnosticReportStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new DiagnosticReport.DiagnosticReportStatusEnumFactory(), false);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept("category", element.getCategory());
        }
        if (element.hasCode()) {
            this.composeCodeableConcept("code", element.getCode());
        }
        if (element.hasSubject()) {
            this.composeReference("subject", element.getSubject());
        }
        if (element.hasEncounter()) {
            this.composeReference("encounter", element.getEncounter());
        }
        if (element.hasEffective()) {
            this.composeType("effective", element.getEffective());
        }
        if (element.hasIssuedElement()) {
            this.composeInstantCore("issued", element.getIssuedElement(), false);
            this.composeInstantExtras("issued", element.getIssuedElement(), false);
        }
        if (element.hasPerformer()) {
            this.composeReference("performer", element.getPerformer());
        }
        if (element.hasRequest()) {
            this.openArray("request");
            for (Reference reference : element.getRequest()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasSpecimen()) {
            this.openArray("specimen");
            for (Reference reference : element.getSpecimen()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasResult()) {
            this.openArray("result");
            for (Reference reference : element.getResult()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasImagingStudy()) {
            this.openArray("imagingStudy");
            for (Reference reference : element.getImagingStudy()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasImage()) {
            this.openArray("image");
            for (DiagnosticReport.DiagnosticReportImageComponent diagnosticReportImageComponent : element.getImage()) {
                this.composeDiagnosticReportDiagnosticReportImageComponent(null, diagnosticReportImageComponent);
            }
            this.closeArray();
        }
        if (element.hasConclusionElement()) {
            this.composeStringCore("conclusion", element.getConclusionElement(), false);
            this.composeStringExtras("conclusion", element.getConclusionElement(), false);
        }
        if (element.hasCodedDiagnosis()) {
            this.openArray("codedDiagnosis");
            for (CodeableConcept codeableConcept : element.getCodedDiagnosis()) {
                this.composeCodeableConcept(null, codeableConcept);
            }
            this.closeArray();
        }
        if (element.hasPresentedForm()) {
            this.openArray("presentedForm");
            for (Attachment attachment : element.getPresentedForm()) {
                this.composeAttachment(null, attachment);
            }
            this.closeArray();
        }
    }

    protected void composeDiagnosticReportDiagnosticReportImageComponent(String name, DiagnosticReport.DiagnosticReportImageComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDiagnosticReportDiagnosticReportImageComponentInner(element);
            this.close();
        }
    }

    protected void composeDiagnosticReportDiagnosticReportImageComponentInner(DiagnosticReport.DiagnosticReportImageComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasCommentElement()) {
            this.composeStringCore("comment", element.getCommentElement(), false);
            this.composeStringExtras("comment", element.getCommentElement(), false);
        }
        if (element.hasLink()) {
            this.composeReference("link", element.getLink());
        }
    }

    protected void composeDocumentManifest(String name, DocumentManifest element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeDocumentManifestInner(element);
        }
    }

    protected void composeDocumentManifestInner(DocumentManifest element) throws IOException {
        this.composeDomainResourceElements(element);
        if (element.hasMasterIdentifier()) {
            this.composeIdentifier("masterIdentifier", element.getMasterIdentifier());
        }
        if (element.hasIdentifier()) {
            this.openArray("identifier");
            for (Identifier identifier : element.getIdentifier()) {
                this.composeIdentifier(null, identifier);
            }
            this.closeArray();
        }
        if (element.hasSubject()) {
            this.composeReference("subject", element.getSubject());
        }
        if (element.hasRecipient()) {
            this.openArray("recipient");
            for (Reference reference : element.getRecipient()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasType()) {
            this.composeCodeableConcept("type", element.getType());
        }
        if (element.hasAuthor()) {
            this.openArray("author");
            for (Reference reference : element.getAuthor()) {
                this.composeReference(null, reference);
            }
            this.closeArray();
        }
        if (element.hasCreatedElement()) {
            this.composeDateTimeCore("created", element.getCreatedElement(), false);
            this.composeDateTimeExtras("created", element.getCreatedElement(), false);
        }
        if (element.hasSourceElement()) {
            this.composeUriCore("source", element.getSourceElement(), false);
            this.composeUriExtras("source", element.getSourceElement(), false);
        }
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new Enumerations.DocumentReferenceStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new Enumerations.DocumentReferenceStatusEnumFactory(), false);
        }
        if (element.hasDescriptionElement()) {
            this.composeStringCore("description", element.getDescriptionElement(), false);
            this.composeStringExtras("description", element.getDescriptionElement(), false);
        }
        if (element.hasContent()) {
            this.openArray("content");
            for (DocumentManifest.DocumentManifestContentComponent documentManifestContentComponent : element.getContent()) {
                this.composeDocumentManifestDocumentManifestContentComponent(null, documentManifestContentComponent);
            }
            this.closeArray();
        }
        if (element.hasRelated()) {
            this.openArray("related");
            for (DocumentManifest.DocumentManifestRelatedComponent documentManifestRelatedComponent : element.getRelated()) {
                this.composeDocumentManifestDocumentManifestRelatedComponent(null, documentManifestRelatedComponent);
            }
            this.closeArray();
        }
    }

    protected void composeDocumentManifestDocumentManifestContentComponent(String name, DocumentManifest.DocumentManifestContentComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDocumentManifestDocumentManifestContentComponentInner(element);
            this.close();
        }
    }

    protected void composeDocumentManifestDocumentManifestContentComponentInner(DocumentManifest.DocumentManifestContentComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasP()) {
            this.composeType("p", element.getP());
        }
    }

    protected void composeDocumentManifestDocumentManifestRelatedComponent(String name, DocumentManifest.DocumentManifestRelatedComponent element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeDocumentManifestDocumentManifestRelatedComponentInner(element);
            this.close();
        }
    }

    protected void composeDocumentManifestDocumentManifestRelatedComponentInner(DocumentManifest.DocumentManifestRelatedComponent element) throws IOException {
        this.composeBackbone(element);
        if (element.hasIdentifier()) {
            this.composeIdentifier("identifier", element.getIdentifier());
        }
        if (element.hasRef()) {
            this.composeReference("ref", element.getRef());
        }
    }

    protected void composeDocumentReference(String name, DocumentReference element) throws IOException {
        if (element != null) {
            this.prop("resourceType", name);
            this.composeDocumentRefere