/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Medication;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Quantity;
import org.hl7.fhir.dstu2.model.Range;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.Substance;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.dstu2.model.UnsignedIntType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Group", profile="http://hl7.org/fhir/Profile/Group")
public class Group
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique id", formalDefinition="A unique business identifier for this group.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="person | animal | practitioner | device | medication | substance", formalDefinition="Identifies the broad classification of the kind of resources the group includes.")
    protected Enumeration<GroupType> type;
    @Child(name="actual", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Descriptive or actual", formalDefinition="If true, indicates that the resource refers to a specific group of real individuals.  If false, the group defines a set of intended individuals.")
    protected BooleanType actual;
    @Child(name="code", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of Group members", formalDefinition="Provides a specific type of resource the group includes; e.g. \"cow\", \"syringe\", etc.")
    protected CodeableConcept code;
    @Child(name="name", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Label for Group", formalDefinition="A label assigned to the group for human identification and communication.")
    protected StringType name;
    @Child(name="quantity", type={UnsignedIntType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of members", formalDefinition="A count of the number of resource instances that are part of the group.")
    protected UnsignedIntType quantity;
    @Child(name="characteristic", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Trait of group members", formalDefinition="Identifies the traits shared by members of the group.")
    protected List<GroupCharacteristicComponent> characteristic;
    @Child(name="member", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who or what is in group", formalDefinition="Identifies the resource instances that are members of the group.")
    protected List<GroupMemberComponent> member;
    private static final long serialVersionUID = 1401345819L;
    @SearchParamDefinition(name="actual", path="Group.actual", description="Descriptive or actual", type="token")
    public static final String SP_ACTUAL = "actual";
    @SearchParamDefinition(name="identifier", path="Group.identifier", description="Unique id", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="characteristic-value", path="null", description="A composite of both characteristic and value", type="composite")
    public static final String SP_CHARACTERISTICVALUE = "characteristic-value";
    @SearchParamDefinition(name="code", path="Group.code", description="The kind of resources contained", type="token")
    public static final String SP_CODE = "code";
    @SearchParamDefinition(name="member", path="Group.member.entity", description="Reference to the group member", type="reference")
    public static final String SP_MEMBER = "member";
    @SearchParamDefinition(name="exclude", path="Group.characteristic.exclude", description="Group includes or excludes", type="token")
    public static final String SP_EXCLUDE = "exclude";
    @SearchParamDefinition(name="type", path="Group.type", description="The type of resources the group contains", type="token")
    public static final String SP_TYPE = "type";
    @SearchParamDefinition(name="value", path="Group.characteristic.value[x]", description="Value held by characteristic", type="token")
    public static final String SP_VALUE = "value";
    @SearchParamDefinition(name="characteristic", path="Group.characteristic.code", description="Kind of characteristic", type="token")
    public static final String SP_CHARACTERISTIC = "characteristic";

    public Group() {
    }

    public Group(Enumeration<GroupType> type, BooleanType actual) {
        this.type = type;
        this.actual = actual;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Group addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Enumeration<GroupType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Group.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<GroupType>(new GroupTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Group setTypeElement(Enumeration<GroupType> value) {
        this.type = value;
        return this;
    }

    public GroupType getType() {
        return this.type == null ? null : (GroupType)((Object)this.type.getValue());
    }

    public Group setType(GroupType value) {
        if (this.type == null) {
            this.type = new Enumeration<GroupType>(new GroupTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public BooleanType getActualElement() {
        if (this.actual == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Group.actual");
            }
            if (Configuration.doAutoCreate()) {
                this.actual = new BooleanType();
            }
        }
        return this.actual;
    }

    public boolean hasActualElement() {
        return this.actual != null && !this.actual.isEmpty();
    }

    public boolean hasActual() {
        return this.actual != null && !this.actual.isEmpty();
    }

    public Group setActualElement(BooleanType value) {
        this.actual = value;
        return this;
    }

    public boolean getActual() {
        return this.actual == null || this.actual.isEmpty() ? false : (Boolean)this.actual.getValue();
    }

    public Group setActual(boolean value) {
        if (this.actual == null) {
            this.actual = new BooleanType();
        }
        this.actual.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Group.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Group setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Group.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Group setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Group setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public UnsignedIntType getQuantityElement() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Group.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new UnsignedIntType();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantityElement() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public Group setQuantityElement(UnsignedIntType value) {
        this.quantity = value;
        return this;
    }

    public int getQuantity() {
        return this.quantity == null || this.quantity.isEmpty() ? 0 : (Integer)this.quantity.getValue();
    }

    public Group setQuantity(int value) {
        if (this.quantity == null) {
            this.quantity = new UnsignedIntType();
        }
        this.quantity.setValue((Object)value);
        return this;
    }

    public List<GroupCharacteristicComponent> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<GroupCharacteristicComponent>();
        }
        return this.characteristic;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (GroupCharacteristicComponent item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public GroupCharacteristicComponent addCharacteristic() {
        GroupCharacteristicComponent t = new GroupCharacteristicComponent();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<GroupCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return t;
    }

    public Group addCharacteristic(GroupCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<GroupCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return this;
    }

    public List<GroupMemberComponent> getMember() {
        if (this.member == null) {
            this.member = new ArrayList<GroupMemberComponent>();
        }
        return this.member;
    }

    public boolean hasMember() {
        if (this.member == null) {
            return false;
        }
        for (GroupMemberComponent item : this.member) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public GroupMemberComponent addMember() {
        GroupMemberComponent t = new GroupMemberComponent();
        if (this.member == null) {
            this.member = new ArrayList<GroupMemberComponent>();
        }
        this.member.add(t);
        return t;
    }

    public Group addMember(GroupMemberComponent t) {
        if (t == null) {
            return this;
        }
        if (this.member == null) {
            this.member = new ArrayList<GroupMemberComponent>();
        }
        this.member.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "A unique business identifier for this group.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_TYPE, SP_CODE, "Identifies the broad classification of the kind of resources the group includes.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_ACTUAL, "boolean", "If true, indicates that the resource refers to a specific group of real individuals.  If false, the group defines a set of intended individuals.", 0, Integer.MAX_VALUE, this.actual));
        childrenList.add(new Property(SP_CODE, "CodeableConcept", "Provides a specific type of resource the group includes; e.g. \"cow\", \"syringe\", etc.", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property("name", "string", "A label assigned to the group for human identification and communication.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property("quantity", "unsignedInt", "A count of the number of resource instances that are part of the group.", 0, Integer.MAX_VALUE, this.quantity));
        childrenList.add(new Property(SP_CHARACTERISTIC, "", "Identifies the traits shared by members of the group.", 0, Integer.MAX_VALUE, this.characteristic));
        childrenList.add(new Property(SP_MEMBER, "", "Identifies the resource instances that are members of the group.", 0, Integer.MAX_VALUE, this.member));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_TYPE)) {
            this.type = new GroupTypeEnumFactory().fromType(value);
        } else if (name.equals(SP_ACTUAL)) {
            this.actual = this.castToBoolean(value);
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("name")) {
            this.name = this.castToString(value);
        } else if (name.equals("quantity")) {
            this.quantity = this.castToUnsignedInt(value);
        } else if (name.equals(SP_CHARACTERISTIC)) {
            this.getCharacteristic().add((GroupCharacteristicComponent)value);
        } else if (name.equals(SP_MEMBER)) {
            this.getMember().add((GroupMemberComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Group.type");
        }
        if (name.equals(SP_ACTUAL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Group.actual");
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type Group.name");
        }
        if (name.equals("quantity")) {
            throw new FHIRException("Cannot call addChild on a primitive type Group.quantity");
        }
        if (name.equals(SP_CHARACTERISTIC)) {
            return this.addCharacteristic();
        }
        if (name.equals(SP_MEMBER)) {
            return this.addMember();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Group";
    }

    @Override
    public Group copy() {
        Group dst = new Group();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.actual = this.actual == null ? null : this.actual.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.name = this.name == null ? null : this.name.copy();
        UnsignedIntType unsignedIntType = dst.quantity = this.quantity == null ? null : this.quantity.copy();
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<GroupCharacteristicComponent>();
            for (GroupCharacteristicComponent groupCharacteristicComponent : this.characteristic) {
                dst.characteristic.add(groupCharacteristicComponent.copy());
            }
        }
        if (this.member != null) {
            dst.member = new ArrayList<GroupMemberComponent>();
            for (GroupMemberComponent groupMemberComponent : this.member) {
                dst.member.add(groupMemberComponent.copy());
            }
        }
        return dst;
    }

    protected Group typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Group)) {
            return false;
        }
        Group o = (Group)other;
        return Group.compareDeep(this.identifier, o.identifier, true) && Group.compareDeep(this.type, o.type, true) && Group.compareDeep(this.actual, o.actual, true) && Group.compareDeep(this.code, o.code, true) && Group.compareDeep(this.name, o.name, true) && Group.compareDeep(this.quantity, o.quantity, true) && Group.compareDeep(this.characteristic, o.characteristic, true) && Group.compareDeep(this.member, o.member, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Group)) {
            return false;
        }
        Group o = (Group)other;
        return Group.compareValues(this.type, o.type, true) && Group.compareValues(this.actual, o.actual, true) && Group.compareValues(this.name, o.name, true) && Group.compareValues(this.quantity, o.quantity, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.type != null && !this.type.isEmpty() || this.actual != null && !this.actual.isEmpty() || this.code != null && !this.code.isEmpty() || this.name != null && !this.name.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.characteristic != null && !this.characteristic.isEmpty() || this.member != null && !this.member.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Group;
    }

    @Block
    public static class GroupMemberComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="entity", type={Patient.class, Practitioner.class, Device.class, Medication.class, Substance.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to the group member", formalDefinition="A reference to the entity that is a member of the group. Must be consistent with Group.type.")
        protected Reference entity;
        protected Resource entityTarget;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Period member belonged to the group", formalDefinition="The period that the member was in the group, if known.")
        protected Period period;
        @Child(name="inactive", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If member is no longer in group", formalDefinition="A flag to indicate that the member is no longer in the group, but previously may have been a member.")
        protected BooleanType inactive;
        private static final long serialVersionUID = -333869055L;

        public GroupMemberComponent() {
        }

        public GroupMemberComponent(Reference entity) {
            this.entity = entity;
        }

        public Reference getEntity() {
            if (this.entity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupMemberComponent.entity");
                }
                if (Configuration.doAutoCreate()) {
                    this.entity = new Reference();
                }
            }
            return this.entity;
        }

        public boolean hasEntity() {
            return this.entity != null && !this.entity.isEmpty();
        }

        public GroupMemberComponent setEntity(Reference value) {
            this.entity = value;
            return this;
        }

        public Resource getEntityTarget() {
            return this.entityTarget;
        }

        public GroupMemberComponent setEntityTarget(Resource value) {
            this.entityTarget = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupMemberComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public GroupMemberComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public BooleanType getInactiveElement() {
            if (this.inactive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupMemberComponent.inactive");
                }
                if (Configuration.doAutoCreate()) {
                    this.inactive = new BooleanType();
                }
            }
            return this.inactive;
        }

        public boolean hasInactiveElement() {
            return this.inactive != null && !this.inactive.isEmpty();
        }

        public boolean hasInactive() {
            return this.inactive != null && !this.inactive.isEmpty();
        }

        public GroupMemberComponent setInactiveElement(BooleanType value) {
            this.inactive = value;
            return this;
        }

        public boolean getInactive() {
            return this.inactive == null || this.inactive.isEmpty() ? false : (Boolean)this.inactive.getValue();
        }

        public GroupMemberComponent setInactive(boolean value) {
            if (this.inactive == null) {
                this.inactive = new BooleanType();
            }
            this.inactive.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("entity", "Reference(Patient|Practitioner|Device|Medication|Substance)", "A reference to the entity that is a member of the group. Must be consistent with Group.type.", 0, Integer.MAX_VALUE, this.entity));
            childrenList.add(new Property("period", "Period", "The period that the member was in the group, if known.", 0, Integer.MAX_VALUE, this.period));
            childrenList.add(new Property("inactive", "boolean", "A flag to indicate that the member is no longer in the group, but previously may have been a member.", 0, Integer.MAX_VALUE, this.inactive));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("entity")) {
                this.entity = this.castToReference(value);
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else if (name.equals("inactive")) {
                this.inactive = this.castToBoolean(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("entity")) {
                this.entity = new Reference();
                return this.entity;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("inactive")) {
                throw new FHIRException("Cannot call addChild on a primitive type Group.inactive");
            }
            return super.addChild(name);
        }

        @Override
        public GroupMemberComponent copy() {
            GroupMemberComponent dst = new GroupMemberComponent();
            this.copyValues(dst);
            dst.entity = this.entity == null ? null : this.entity.copy();
            dst.period = this.period == null ? null : this.period.copy();
            dst.inactive = this.inactive == null ? null : this.inactive.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof GroupMemberComponent)) {
                return false;
            }
            GroupMemberComponent o = (GroupMemberComponent)other;
            return GroupMemberComponent.compareDeep(this.entity, o.entity, true) && GroupMemberComponent.compareDeep(this.period, o.period, true) && GroupMemberComponent.compareDeep(this.inactive, o.inactive, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof GroupMemberComponent)) {
                return false;
            }
            GroupMemberComponent o = (GroupMemberComponent)other;
            return GroupMemberComponent.compareValues(this.inactive, o.inactive, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.entity != null && !this.entity.isEmpty() || this.period != null && !this.period.isEmpty() || this.inactive != null && !this.inactive.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Group.member";
        }
    }

    @Block
    public static class GroupCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of characteristic", formalDefinition="A code that identifies the kind of trait being asserted.")
        protected CodeableConcept code;
        @Child(name="value", type={CodeableConcept.class, BooleanType.class, Quantity.class, Range.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value held by characteristic", formalDefinition="The value of the trait that holds (or does not hold - see 'exclude') for members of the group.")
        protected Type value;
        @Child(name="exclude", type={BooleanType.class}, order=3, min=1, max=1, modifier=true, summary=false)
        @Description(shortDefinition="Group includes or excludes", formalDefinition="If true, indicates the characteristic is one that is NOT held by members of the group.")
        protected BooleanType exclude;
        @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Period over which characteristic is tested", formalDefinition="The period over which the characteristic is tested; e.g. the patient had an operation during the month of June.")
        protected Period period;
        private static final long serialVersionUID = -1000688967L;

        public GroupCharacteristicComponent() {
        }

        public GroupCharacteristicComponent(CodeableConcept code, Type value, BooleanType exclude) {
            this.code = code;
            this.value = value;
            this.exclude = exclude;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupCharacteristicComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public GroupCharacteristicComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this.value instanceof CodeableConcept;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this.value instanceof BooleanType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this.value instanceof Range;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public GroupCharacteristicComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        public BooleanType getExcludeElement() {
            if (this.exclude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupCharacteristicComponent.exclude");
                }
                if (Configuration.doAutoCreate()) {
                    this.exclude = new BooleanType();
                }
            }
            return this.exclude;
        }

        public boolean hasExcludeElement() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public boolean hasExclude() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public GroupCharacteristicComponent setExcludeElement(BooleanType value) {
            this.exclude = value;
            return this;
        }

        public boolean getExclude() {
            return this.exclude == null || this.exclude.isEmpty() ? false : (Boolean)this.exclude.getValue();
        }

        public GroupCharacteristicComponent setExclude(boolean value) {
            if (this.exclude == null) {
                this.exclude = new BooleanType();
            }
            this.exclude.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupCharacteristicComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public GroupCharacteristicComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Group.SP_CODE, "CodeableConcept", "A code that identifies the kind of trait being asserted.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("value[x]", "CodeableConcept|boolean|Quantity|Range", "The value of the trait that holds (or does not hold - see 'exclude') for members of the group.", 0, Integer.MAX_VALUE, this.value));
            childrenList.add(new Property(Group.SP_EXCLUDE, "boolean", "If true, indicates the characteristic is one that is NOT held by members of the group.", 0, Integer.MAX_VALUE, this.exclude));
            childrenList.add(new Property("period", "Period", "The period over which the characteristic is tested; e.g. the patient had an operation during the month of June.", 0, Integer.MAX_VALUE, this.period));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Group.SP_CODE)) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else if (name.equals(Group.SP_EXCLUDE)) {
                this.exclude = this.castToBoolean(value);
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Group.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals(Group.SP_EXCLUDE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Group.exclude");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public GroupCharacteristicComponent copy() {
            GroupCharacteristicComponent dst = new GroupCharacteristicComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.exclude = this.exclude == null ? null : this.exclude.copy();
            dst.period = this.period == null ? null : this.period.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof GroupCharacteristicComponent)) {
                return false;
            }
            GroupCharacteristicComponent o = (GroupCharacteristicComponent)other;
            return GroupCharacteristicComponent.compareDeep(this.code, o.code, true) && GroupCharacteristicComponent.compareDeep(this.value, o.value, true) && GroupCharacteristicComponent.compareDeep(this.exclude, o.exclude, true) && GroupCharacteristicComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof GroupCharacteristicComponent)) {
                return false;
            }
            GroupCharacteristicComponent o = (GroupCharacteristicComponent)other;
            return GroupCharacteristicComponent.compareValues(this.exclude, o.exclude, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.value != null && !this.value.isEmpty() || this.exclude != null && !this.exclude.isEmpty() || this.period != null && !this.period.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Group.characteristic";
        }
    }

    public static class GroupTypeEnumFactory
    implements EnumFactory<GroupType> {
        @Override
        public GroupType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("person".equals(codeString)) {
                return GroupType.PERSON;
            }
            if ("animal".equals(codeString)) {
                return GroupType.ANIMAL;
            }
            if ("practitioner".equals(codeString)) {
                return GroupType.PRACTITIONER;
            }
            if ("device".equals(codeString)) {
                return GroupType.DEVICE;
            }
            if ("medication".equals(codeString)) {
                return GroupType.MEDICATION;
            }
            if ("substance".equals(codeString)) {
                return GroupType.SUBSTANCE;
            }
            throw new IllegalArgumentException("Unknown GroupType code '" + codeString + "'");
        }

        public Enumeration<GroupType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("person".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.PERSON);
            }
            if ("animal".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.ANIMAL);
            }
            if ("practitioner".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.PRACTITIONER);
            }
            if ("device".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.DEVICE);
            }
            if ("medication".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.MEDICATION);
            }
            if ("substance".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.SUBSTANCE);
            }
            throw new FHIRException("Unknown GroupType code '" + codeString + "'");
        }

        @Override
        public String toCode(GroupType code) {
            if (code == GroupType.PERSON) {
                return "person";
            }
            if (code == GroupType.ANIMAL) {
                return "animal";
            }
            if (code == GroupType.PRACTITIONER) {
                return "practitioner";
            }
            if (code == GroupType.DEVICE) {
                return "device";
            }
            if (code == GroupType.MEDICATION) {
                return "medication";
            }
            if (code == GroupType.SUBSTANCE) {
                return "substance";
            }
            return "?";
        }
    }

    public static enum GroupType {
        PERSON,
        ANIMAL,
        PRACTITIONER,
        DEVICE,
        MEDICATION,
        SUBSTANCE,
        NULL;


        public static GroupType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("person".equals(codeString)) {
                return PERSON;
            }
            if ("animal".equals(codeString)) {
                return ANIMAL;
            }
            if ("practitioner".equals(codeString)) {
                return PRACTITIONER;
            }
            if ("device".equals(codeString)) {
                return DEVICE;
            }
            if ("medication".equals(codeString)) {
                return MEDICATION;
            }
            if ("substance".equals(codeString)) {
                return SUBSTANCE;
            }
            throw new FHIRException("Unknown GroupType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PERSON: {
                    return "person";
                }
                case ANIMAL: {
                    return "animal";
                }
                case PRACTITIONER: {
                    return "practitioner";
                }
                case DEVICE: {
                    return "device";
                }
                case MEDICATION: {
                    return "medication";
                }
                case SUBSTANCE: {
                    return "substance";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PERSON: {
                    return "http://hl7.org/fhir/group-type";
                }
                case ANIMAL: {
                    return "http://hl7.org/fhir/group-type";
                }
                case PRACTITIONER: {
                    return "http://hl7.org/fhir/group-type";
                }
                case DEVICE: {
                    return "http://hl7.org/fhir/group-type";
                }
                case MEDICATION: {
                    return "http://hl7.org/fhir/group-type";
                }
                case SUBSTANCE: {
                    return "http://hl7.org/fhir/group-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PERSON: {
                    return "Group contains \"person\" Patient resources";
                }
                case ANIMAL: {
                    return "Group contains \"animal\" Patient resources";
                }
                case PRACTITIONER: {
                    return "Group contains healthcare practitioner resources";
                }
                case DEVICE: {
                    return "Group contains Device resources";
                }
                case MEDICATION: {
                    return "Group contains Medication resources";
                }
                case SUBSTANCE: {
                    return "Group contains Substance resources";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PERSON: {
                    return "Person";
                }
                case ANIMAL: {
                    return "Animal";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case DEVICE: {
                    return "Device";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case SUBSTANCE: {
                    return "Substance";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

