/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Attachment;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DeviceMetric;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Group;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.InstantType;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Quantity;
import org.hl7.fhir.dstu2.model.QuestionnaireResponse;
import org.hl7.fhir.dstu2.model.Range;
import org.hl7.fhir.dstu2.model.Ratio;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.SampledData;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.Specimen;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.TimeType;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Observation", profile="http://hl7.org/fhir/Profile/Observation")
public class Observation
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Unique Id for this particular observation", formalDefinition="A unique identifier for the simple observation instance.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="registered | preliminary | final | amended +", formalDefinition="The status of the result value.")
    protected Enumeration<ObservationStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Classification of  type of observation", formalDefinition="A code that classifies the general type of observation being made.  This is used  for searching, sorting and display purposes.")
    protected CodeableConcept category;
    @Child(name="code", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of observation (code / type)", formalDefinition="Describes what was observed. Sometimes this is called the observation \"name\".")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what this is about", formalDefinition="The patient, or group of patients, location, or device whose characteristics (direct or indirect) are described by the observation and into whose record the observation is placed.  Comments: Indirect characteristics may be those of a specimen, fetus, donor,  other observer (for example a relative or EMT), or any observation made about the subject.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="encounter", type={Encounter.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Healthcare event during which this observation is made", formalDefinition="The healthcare event  (e.g. a patient and healthcare provider interaction) during which this observation is made.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="effective", type={DateTimeType.class, Period.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Clinically relevant time/time-period for observation", formalDefinition="The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.")
    protected Type effective;
    @Child(name="issued", type={InstantType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date/Time this was made available", formalDefinition="The date and time this observation was made available to providers, typically after the results have been reviewed and verified.")
    protected InstantType issued;
    @Child(name="performer", type={Practitioner.class, Organization.class, Patient.class, RelatedPerson.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who is responsible for the observation", formalDefinition="Who was responsible for asserting the observed value as \"true\".")
    protected List<Reference> performer;
    protected List<Resource> performerTarget;
    @Child(name="value", type={Quantity.class, CodeableConcept.class, StringType.class, Range.class, Ratio.class, SampledData.class, Attachment.class, TimeType.class, DateTimeType.class, Period.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Actual result", formalDefinition="The information determined as a result of making the observation, if the information has a simple value.")
    protected Type value;
    @Child(name="dataAbsentReason", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why the result is missing", formalDefinition="Provides a reason why the expected value in the element Observation.value[x] is missing.")
    protected CodeableConcept dataAbsentReason;
    @Child(name="interpretation", type={CodeableConcept.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="High, low, normal, etc.", formalDefinition="The assessment made based on the result of the observation.  Intended as a simple compact code often placed adjacent to the result value in reports and flow sheets to signal the meaning/normalcy status of the result. Otherwise known as abnormal flag.")
    protected CodeableConcept interpretation;
    @Child(name="comments", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Comments about result", formalDefinition="May include statements about significant, unexpected or unreliable values, or information about the source of the value where this may be relevant to the interpretation of the result.")
    protected StringType comments;
    @Child(name="bodySite", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Observed body part", formalDefinition="Indicates the site on the subject's body where the observation was made (i.e. the target site).")
    protected CodeableConcept bodySite;
    @Child(name="method", type={CodeableConcept.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How it was done", formalDefinition="Indicates the mechanism used to perform the observation.")
    protected CodeableConcept method;
    @Child(name="specimen", type={Specimen.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Specimen used for this observation", formalDefinition="The specimen that was used when this observation was made.")
    protected Reference specimen;
    protected Specimen specimenTarget;
    @Child(name="device", type={Device.class, DeviceMetric.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="(Measurement) Device", formalDefinition="The device used to generate the observation data.")
    protected Reference device;
    protected Resource deviceTarget;
    @Child(name="referenceRange", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Provides guide for interpretation", formalDefinition="Guidance on how to interpret the value by comparison to a normal or recommended range.")
    protected List<ObservationReferenceRangeComponent> referenceRange;
    @Child(name="related", type={}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Resource related to this observation", formalDefinition="A  reference to another resource (usually another Observation but could  also be a QuestionnaireAnswer) whose relationship is defined by the relationship type code.")
    protected List<ObservationRelatedComponent> related;
    @Child(name="component", type={}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Component results", formalDefinition="Some observations have multiple component observations.  These component observations are expressed as separate code value pairs that share the same attributes.  Examples include systolic and diastolic component observations for blood pressure measurement and multiple component observations for genetics observations.")
    protected List<ObservationComponentComponent> component;
    private static final long serialVersionUID = -931593572L;
    @SearchParamDefinition(name="date", path="Observation.effective[x]", description="Obtained date/time. If the obtained element is a period, a date that falls in the period", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="code", path="Observation.code", description="The code of the observation type", type="token")
    public static final String SP_CODE = "code";
    @SearchParamDefinition(name="subject", path="Observation.subject", description="The subject that the observation is about", type="reference")
    public static final String SP_SUBJECT = "subject";
    @SearchParamDefinition(name="component-data-absent-reason", path="Observation.component.dataAbsentReason", description="The reason why the expected value in the element Observation.component.value[x] is missing.", type="token")
    public static final String SP_COMPONENTDATAABSENTREASON = "component-data-absent-reason";
    @SearchParamDefinition(name="value-concept", path="Observation.valueCodeableConcept", description="The value of the observation, if the value is a CodeableConcept", type="token")
    public static final String SP_VALUECONCEPT = "value-concept";
    @SearchParamDefinition(name="value-date", path="Observation.valueDateTime | Observation.valuePeriod", description="The value of the observation, if the value is a date or period of time", type="date")
    public static final String SP_VALUEDATE = "value-date";
    @SearchParamDefinition(name="related", path="null", description="Related Observations - search on related-type and related-target together", type="composite")
    public static final String SP_RELATED = "related";
    @SearchParamDefinition(name="patient", path="Observation.subject", description="The subject that the observation is about (if patient)", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="specimen", path="Observation.specimen", description="Specimen used for this observation", type="reference")
    public static final String SP_SPECIMEN = "specimen";
    @SearchParamDefinition(name="component-code", path="Observation.component.code", description="The component code of the observation type", type="token")
    public static final String SP_COMPONENTCODE = "component-code";
    @SearchParamDefinition(name="value-string", path="Observation.valueString", description="The value of the observation, if the value is a string, and also searches in CodeableConcept.text", type="string")
    public static final String SP_VALUESTRING = "value-string";
    @SearchParamDefinition(name="identifier", path="Observation.identifier", description="The unique id for a particular observation", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="component-code-value-[x]", path="null", description="Both component code and one of the component value parameters", type="composite")
    public static final String SP_COMPONENTCODEVALUEX = "component-code-value-[x]";
    @SearchParamDefinition(name="code-value-[x]", path="null", description="Both code and one of the value parameters", type="composite")
    public static final String SP_CODEVALUEX = "code-value-[x]";
    @SearchParamDefinition(name="performer", path="Observation.performer", description="Who performed the observation", type="reference")
    public static final String SP_PERFORMER = "performer";
    @SearchParamDefinition(name="value-quantity", path="Observation.valueQuantity", description="The value of the observation, if the value is a Quantity, or a SampledData (just search on the bounds of the values in sampled data)", type="quantity")
    public static final String SP_VALUEQUANTITY = "value-quantity";
    @SearchParamDefinition(name="component-value-quantity", path="Observation.component.valueQuantity", description="The value of the component observation, if the value is a Quantity, or a SampledData (just search on the bounds of the values in sampled data)", type="quantity")
    public static final String SP_COMPONENTVALUEQUANTITY = "component-value-quantity";
    @SearchParamDefinition(name="data-absent-reason", path="Observation.dataAbsentReason", description="The reason why the expected value in the element Observation.value[x] is missing.", type="token")
    public static final String SP_DATAABSENTREASON = "data-absent-reason";
    @SearchParamDefinition(name="encounter", path="Observation.encounter", description="Healthcare event related to the observation", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    @SearchParamDefinition(name="related-type", path="Observation.related.type", description="has-member | derived-from | sequel-to | replaces | qualified-by | interfered-by", type="token")
    public static final String SP_RELATEDTYPE = "related-type";
    @SearchParamDefinition(name="related-target", path="Observation.related.target", description="Resource that is related to this one", type="reference")
    public static final String SP_RELATEDTARGET = "related-target";
    @SearchParamDefinition(name="component-value-string", path="Observation.component.valueString", description="The value of the component observation, if the value is a string, and also searches in CodeableConcept.text", type="string")
    public static final String SP_COMPONENTVALUESTRING = "component-value-string";
    @SearchParamDefinition(name="component-value-concept", path="Observation.component.valueCodeableConcept", description="The value of the component observation, if the value is a CodeableConcept", type="token")
    public static final String SP_COMPONENTVALUECONCEPT = "component-value-concept";
    @SearchParamDefinition(name="category", path="Observation.category", description="The classification of the type of observation", type="token")
    public static final String SP_CATEGORY = "category";
    @SearchParamDefinition(name="device", path="Observation.device", description="The Device that generated the observation data.", type="reference")
    public static final String SP_DEVICE = "device";
    @SearchParamDefinition(name="status", path="Observation.status", description="The status of the observation", type="token")
    public static final String SP_STATUS = "status";

    public Observation() {
    }

    public Observation(Enumeration<ObservationStatus> status, CodeableConcept code) {
        this.status = status;
        this.code = code;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Observation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Enumeration<ObservationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ObservationStatus>(new ObservationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Observation setStatusElement(Enumeration<ObservationStatus> value) {
        this.status = value;
        return this;
    }

    public ObservationStatus getStatus() {
        return this.status == null ? null : (ObservationStatus)((Object)this.status.getValue());
    }

    public Observation setStatus(ObservationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ObservationStatus>(new ObservationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public Observation setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Observation setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Observation setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Observation setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Observation setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public Observation setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Type getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this.effective instanceof Period;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public Observation setEffective(Type value) {
        this.effective = value;
        return this;
    }

    public InstantType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new InstantType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public Observation setIssuedElement(InstantType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public Observation setIssued(Date value) {
        if (value == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new InstantType();
            }
            this.issued.setValue(value);
        }
        return this;
    }

    public List<Reference> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (Reference item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPerformer() {
        Reference t = new Reference();
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return t;
    }

    public Observation addPerformer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return this;
    }

    public List<Resource> getPerformerTarget() {
        if (this.performerTarget == null) {
            this.performerTarget = new ArrayList<Resource>();
        }
        return this.performerTarget;
    }

    public Type getValue() {
        return this.value;
    }

    public Quantity getValueQuantity() throws FHIRException {
        if (!(this.value instanceof Quantity)) {
            throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Quantity)this.value;
    }

    public boolean hasValueQuantity() {
        return this.value instanceof Quantity;
    }

    public CodeableConcept getValueCodeableConcept() throws FHIRException {
        if (!(this.value instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.value;
    }

    public boolean hasValueCodeableConcept() {
        return this.value instanceof CodeableConcept;
    }

    public StringType getValueStringType() throws FHIRException {
        if (!(this.value instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (StringType)this.value;
    }

    public boolean hasValueStringType() {
        return this.value instanceof StringType;
    }

    public Range getValueRange() throws FHIRException {
        if (!(this.value instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Range)this.value;
    }

    public boolean hasValueRange() {
        return this.value instanceof Range;
    }

    public Ratio getValueRatio() throws FHIRException {
        if (!(this.value instanceof Ratio)) {
            throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Ratio)this.value;
    }

    public boolean hasValueRatio() {
        return this.value instanceof Ratio;
    }

    public SampledData getValueSampledData() throws FHIRException {
        if (!(this.value instanceof SampledData)) {
            throw new FHIRException("Type mismatch: the type SampledData was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (SampledData)this.value;
    }

    public boolean hasValueSampledData() {
        return this.value instanceof SampledData;
    }

    public Attachment getValueAttachment() throws FHIRException {
        if (!(this.value instanceof Attachment)) {
            throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Attachment)this.value;
    }

    public boolean hasValueAttachment() {
        return this.value instanceof Attachment;
    }

    public TimeType getValueTimeType() throws FHIRException {
        if (!(this.value instanceof TimeType)) {
            throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (TimeType)this.value;
    }

    public boolean hasValueTimeType() {
        return this.value instanceof TimeType;
    }

    public DateTimeType getValueDateTimeType() throws FHIRException {
        if (!(this.value instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.value;
    }

    public boolean hasValueDateTimeType() {
        return this.value instanceof DateTimeType;
    }

    public Period getValuePeriod() throws FHIRException {
        if (!(this.value instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Period)this.value;
    }

    public boolean hasValuePeriod() {
        return this.value instanceof Period;
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public Observation setValue(Type value) {
        this.value = value;
        return this;
    }

    public CodeableConcept getDataAbsentReason() {
        if (this.dataAbsentReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.dataAbsentReason");
            }
            if (Configuration.doAutoCreate()) {
                this.dataAbsentReason = new CodeableConcept();
            }
        }
        return this.dataAbsentReason;
    }

    public boolean hasDataAbsentReason() {
        return this.dataAbsentReason != null && !this.dataAbsentReason.isEmpty();
    }

    public Observation setDataAbsentReason(CodeableConcept value) {
        this.dataAbsentReason = value;
        return this;
    }

    public CodeableConcept getInterpretation() {
        if (this.interpretation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.interpretation");
            }
            if (Configuration.doAutoCreate()) {
                this.interpretation = new CodeableConcept();
            }
        }
        return this.interpretation;
    }

    public boolean hasInterpretation() {
        return this.interpretation != null && !this.interpretation.isEmpty();
    }

    public Observation setInterpretation(CodeableConcept value) {
        this.interpretation = value;
        return this;
    }

    public StringType getCommentsElement() {
        if (this.comments == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.comments");
            }
            if (Configuration.doAutoCreate()) {
                this.comments = new StringType();
            }
        }
        return this.comments;
    }

    public boolean hasCommentsElement() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public Observation setCommentsElement(StringType value) {
        this.comments = value;
        return this;
    }

    public String getComments() {
        return this.comments == null ? null : (String)this.comments.getValue();
    }

    public Observation setComments(String value) {
        if (Utilities.noString((String)value)) {
            this.comments = null;
        } else {
            if (this.comments == null) {
                this.comments = new StringType();
            }
            this.comments.setValue(value);
        }
        return this;
    }

    public CodeableConcept getBodySite() {
        if (this.bodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.bodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.bodySite = new CodeableConcept();
            }
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public Observation setBodySite(CodeableConcept value) {
        this.bodySite = value;
        return this;
    }

    public CodeableConcept getMethod() {
        if (this.method == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.method");
            }
            if (Configuration.doAutoCreate()) {
                this.method = new CodeableConcept();
            }
        }
        return this.method;
    }

    public boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    public Observation setMethod(CodeableConcept value) {
        this.method = value;
        return this;
    }

    public Reference getSpecimen() {
        if (this.specimen == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.specimen");
            }
            if (Configuration.doAutoCreate()) {
                this.specimen = new Reference();
            }
        }
        return this.specimen;
    }

    public boolean hasSpecimen() {
        return this.specimen != null && !this.specimen.isEmpty();
    }

    public Observation setSpecimen(Reference value) {
        this.specimen = value;
        return this;
    }

    public Specimen getSpecimenTarget() {
        if (this.specimenTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.specimen");
            }
            if (Configuration.doAutoCreate()) {
                this.specimenTarget = new Specimen();
            }
        }
        return this.specimenTarget;
    }

    public Observation setSpecimenTarget(Specimen value) {
        this.specimenTarget = value;
        return this;
    }

    public Reference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new Reference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public Observation setDevice(Reference value) {
        this.device = value;
        return this;
    }

    public Resource getDeviceTarget() {
        return this.deviceTarget;
    }

    public Observation setDeviceTarget(Resource value) {
        this.deviceTarget = value;
        return this;
    }

    public List<ObservationReferenceRangeComponent> getReferenceRange() {
        if (this.referenceRange == null) {
            this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
        }
        return this.referenceRange;
    }

    public boolean hasReferenceRange() {
        if (this.referenceRange == null) {
            return false;
        }
        for (ObservationReferenceRangeComponent item : this.referenceRange) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ObservationReferenceRangeComponent addReferenceRange() {
        ObservationReferenceRangeComponent t = new ObservationReferenceRangeComponent();
        if (this.referenceRange == null) {
            this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
        }
        this.referenceRange.add(t);
        return t;
    }

    public Observation addReferenceRange(ObservationReferenceRangeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.referenceRange == null) {
            this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
        }
        this.referenceRange.add(t);
        return this;
    }

    public List<ObservationRelatedComponent> getRelated() {
        if (this.related == null) {
            this.related = new ArrayList<ObservationRelatedComponent>();
        }
        return this.related;
    }

    public boolean hasRelated() {
        if (this.related == null) {
            return false;
        }
        for (ObservationRelatedComponent item : this.related) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ObservationRelatedComponent addRelated() {
        ObservationRelatedComponent t = new ObservationRelatedComponent();
        if (this.related == null) {
            this.related = new ArrayList<ObservationRelatedComponent>();
        }
        this.related.add(t);
        return t;
    }

    public Observation addRelated(ObservationRelatedComponent t) {
        if (t == null) {
            return this;
        }
        if (this.related == null) {
            this.related = new ArrayList<ObservationRelatedComponent>();
        }
        this.related.add(t);
        return this;
    }

    public List<ObservationComponentComponent> getComponent() {
        if (this.component == null) {
            this.component = new ArrayList<ObservationComponentComponent>();
        }
        return this.component;
    }

    public boolean hasComponent() {
        if (this.component == null) {
            return false;
        }
        for (ObservationComponentComponent item : this.component) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ObservationComponentComponent addComponent() {
        ObservationComponentComponent t = new ObservationComponentComponent();
        if (this.component == null) {
            this.component = new ArrayList<ObservationComponentComponent>();
        }
        this.component.add(t);
        return t;
    }

    public Observation addComponent(ObservationComponentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.component == null) {
            this.component = new ArrayList<ObservationComponentComponent>();
        }
        this.component.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier for the simple observation instance.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "The status of the result value.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the general type of observation being made.  This is used  for searching, sorting and display purposes.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property(SP_CODE, "CodeableConcept", "Describes what was observed. Sometimes this is called the observation \"name\".", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location)", "The patient, or group of patients, location, or device whose characteristics (direct or indirect) are described by the observation and into whose record the observation is placed.  Comments: Indirect characteristics may be those of a specimen, fetus, donor,  other observer (for example a relative or EMT), or any observation made about the subject.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The healthcare event  (e.g. a patient and healthcare provider interaction) during which this observation is made.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property("effective[x]", "dateTime|Period", "The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.", 0, Integer.MAX_VALUE, this.effective));
        childrenList.add(new Property("issued", "instant", "The date and time this observation was made available to providers, typically after the results have been reviewed and verified.", 0, Integer.MAX_VALUE, this.issued));
        childrenList.add(new Property(SP_PERFORMER, "Reference(Practitioner|Organization|Patient|RelatedPerson)", "Who was responsible for asserting the observed value as \"true\".", 0, Integer.MAX_VALUE, this.performer));
        childrenList.add(new Property("value[x]", "Quantity|CodeableConcept|string|Range|Ratio|SampledData|Attachment|time|dateTime|Period", "The information determined as a result of making the observation, if the information has a simple value.", 0, Integer.MAX_VALUE, this.value));
        childrenList.add(new Property("dataAbsentReason", "CodeableConcept", "Provides a reason why the expected value in the element Observation.value[x] is missing.", 0, Integer.MAX_VALUE, this.dataAbsentReason));
        childrenList.add(new Property("interpretation", "CodeableConcept", "The assessment made based on the result of the observation.  Intended as a simple compact code often placed adjacent to the result value in reports and flow sheets to signal the meaning/normalcy status of the result. Otherwise known as abnormal flag.", 0, Integer.MAX_VALUE, this.interpretation));
        childrenList.add(new Property("comments", "string", "May include statements about significant, unexpected or unreliable values, or information about the source of the value where this may be relevant to the interpretation of the result.", 0, Integer.MAX_VALUE, this.comments));
        childrenList.add(new Property("bodySite", "CodeableConcept", "Indicates the site on the subject's body where the observation was made (i.e. the target site).", 0, Integer.MAX_VALUE, this.bodySite));
        childrenList.add(new Property("method", "CodeableConcept", "Indicates the mechanism used to perform the observation.", 0, Integer.MAX_VALUE, this.method));
        childrenList.add(new Property(SP_SPECIMEN, "Reference(Specimen)", "The specimen that was used when this observation was made.", 0, Integer.MAX_VALUE, this.specimen));
        childrenList.add(new Property(SP_DEVICE, "Reference(Device|DeviceMetric)", "The device used to generate the observation data.", 0, Integer.MAX_VALUE, this.device));
        childrenList.add(new Property("referenceRange", "", "Guidance on how to interpret the value by comparison to a normal or recommended range.", 0, Integer.MAX_VALUE, this.referenceRange));
        childrenList.add(new Property(SP_RELATED, "", "A  reference to another resource (usually another Observation but could  also be a QuestionnaireAnswer) whose relationship is defined by the relationship type code.", 0, Integer.MAX_VALUE, this.related));
        childrenList.add(new Property("component", "", "Some observations have multiple component observations.  These component observations are expressed as separate code value pairs that share the same attributes.  Examples include systolic and diastolic component observations for blood pressure measurement and multiple component observations for genetics observations.", 0, Integer.MAX_VALUE, this.component));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = new ObservationStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("effective[x]")) {
            this.effective = (Type)value;
        } else if (name.equals("issued")) {
            this.issued = this.castToInstant(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add(this.castToReference(value));
        } else if (name.equals("value[x]")) {
            this.value = (Type)value;
        } else if (name.equals("dataAbsentReason")) {
            this.dataAbsentReason = this.castToCodeableConcept(value);
        } else if (name.equals("interpretation")) {
            this.interpretation = this.castToCodeableConcept(value);
        } else if (name.equals("comments")) {
            this.comments = this.castToString(value);
        } else if (name.equals("bodySite")) {
            this.bodySite = this.castToCodeableConcept(value);
        } else if (name.equals("method")) {
            this.method = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SPECIMEN)) {
            this.specimen = this.castToReference(value);
        } else if (name.equals(SP_DEVICE)) {
            this.device = this.castToReference(value);
        } else if (name.equals("referenceRange")) {
            this.getReferenceRange().add((ObservationReferenceRangeComponent)value);
        } else if (name.equals(SP_RELATED)) {
            this.getRelated().add((ObservationRelatedComponent)value);
        } else if (name.equals("component")) {
            this.getComponent().add((ObservationComponentComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Observation.status");
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals("issued")) {
            throw new FHIRException("Cannot call addChild on a primitive type Observation.issued");
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals("valueQuantity")) {
            this.value = new Quantity();
            return this.value;
        }
        if (name.equals("valueCodeableConcept")) {
            this.value = new CodeableConcept();
            return this.value;
        }
        if (name.equals("valueString")) {
            this.value = new StringType();
            return this.value;
        }
        if (name.equals("valueRange")) {
            this.value = new Range();
            return this.value;
        }
        if (name.equals("valueRatio")) {
            this.value = new Ratio();
            return this.value;
        }
        if (name.equals("valueSampledData")) {
            this.value = new SampledData();
            return this.value;
        }
        if (name.equals("valueAttachment")) {
            this.value = new Attachment();
            return this.value;
        }
        if (name.equals("valueTime")) {
            this.value = new TimeType();
            return this.value;
        }
        if (name.equals("valueDateTime")) {
            this.value = new DateTimeType();
            return this.value;
        }
        if (name.equals("valuePeriod")) {
            this.value = new Period();
            return this.value;
        }
        if (name.equals("dataAbsentReason")) {
            this.dataAbsentReason = new CodeableConcept();
            return this.dataAbsentReason;
        }
        if (name.equals("interpretation")) {
            this.interpretation = new CodeableConcept();
            return this.interpretation;
        }
        if (name.equals("comments")) {
            throw new FHIRException("Cannot call addChild on a primitive type Observation.comments");
        }
        if (name.equals("bodySite")) {
            this.bodySite = new CodeableConcept();
            return this.bodySite;
        }
        if (name.equals("method")) {
            this.method = new CodeableConcept();
            return this.method;
        }
        if (name.equals(SP_SPECIMEN)) {
            this.specimen = new Reference();
            return this.specimen;
        }
        if (name.equals(SP_DEVICE)) {
            this.device = new Reference();
            return this.device;
        }
        if (name.equals("referenceRange")) {
            return this.addReferenceRange();
        }
        if (name.equals(SP_RELATED)) {
            return this.addRelated();
        }
        if (name.equals("component")) {
            return this.addComponent();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Observation";
    }

    @Override
    public Observation copy() {
        Observation dst = new Observation();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.effective = this.effective == null ? null : this.effective.copy();
        InstantType instantType = dst.issued = this.issued == null ? null : this.issued.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<Reference>();
            for (Reference reference : this.performer) {
                dst.performer.add(reference.copy());
            }
        }
        dst.value = this.value == null ? null : this.value.copy();
        dst.dataAbsentReason = this.dataAbsentReason == null ? null : this.dataAbsentReason.copy();
        dst.interpretation = this.interpretation == null ? null : this.interpretation.copy();
        dst.comments = this.comments == null ? null : this.comments.copy();
        dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        dst.method = this.method == null ? null : this.method.copy();
        dst.specimen = this.specimen == null ? null : this.specimen.copy();
        Reference reference = dst.device = this.device == null ? null : this.device.copy();
        if (this.referenceRange != null) {
            dst.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
            for (ObservationReferenceRangeComponent observationReferenceRangeComponent : this.referenceRange) {
                dst.referenceRange.add(observationReferenceRangeComponent.copy());
            }
        }
        if (this.related != null) {
            dst.related = new ArrayList<ObservationRelatedComponent>();
            for (ObservationRelatedComponent observationRelatedComponent : this.related) {
                dst.related.add(observationRelatedComponent.copy());
            }
        }
        if (this.component != null) {
            dst.component = new ArrayList<ObservationComponentComponent>();
            for (ObservationComponentComponent observationComponentComponent : this.component) {
                dst.component.add(observationComponentComponent.copy());
            }
        }
        return dst;
    }

    protected Observation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Observation)) {
            return false;
        }
        Observation o = (Observation)other;
        return Observation.compareDeep(this.identifier, o.identifier, true) && Observation.compareDeep(this.status, o.status, true) && Observation.compareDeep(this.category, o.category, true) && Observation.compareDeep(this.code, o.code, true) && Observation.compareDeep(this.subject, o.subject, true) && Observation.compareDeep(this.encounter, o.encounter, true) && Observation.compareDeep(this.effective, o.effective, true) && Observation.compareDeep(this.issued, o.issued, true) && Observation.compareDeep(this.performer, o.performer, true) && Observation.compareDeep(this.value, o.value, true) && Observation.compareDeep(this.dataAbsentReason, o.dataAbsentReason, true) && Observation.compareDeep(this.interpretation, o.interpretation, true) && Observation.compareDeep(this.comments, o.comments, true) && Observation.compareDeep(this.bodySite, o.bodySite, true) && Observation.compareDeep(this.method, o.method, true) && Observation.compareDeep(this.specimen, o.specimen, true) && Observation.compareDeep(this.device, o.device, true) && Observation.compareDeep(this.referenceRange, o.referenceRange, true) && Observation.compareDeep(this.related, o.related, true) && Observation.compareDeep(this.component, o.component, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Observation)) {
            return false;
        }
        Observation o = (Observation)other;
        return Observation.compareValues(this.status, o.status, true) && Observation.compareValues(this.issued, o.issued, true) && Observation.compareValues(this.comments, o.comments, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.category != null && !this.category.isEmpty() || this.code != null && !this.code.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.effective != null && !this.effective.isEmpty() || this.issued != null && !this.issued.isEmpty() || this.performer != null && !this.performer.isEmpty() || this.value != null && !this.value.isEmpty() || this.dataAbsentReason != null && !this.dataAbsentReason.isEmpty() || this.interpretation != null && !this.interpretation.isEmpty() || this.comments != null && !this.comments.isEmpty() || this.bodySite != null && !this.bodySite.isEmpty() || this.method != null && !this.method.isEmpty() || this.specimen != null && !this.specimen.isEmpty() || this.device != null && !this.device.isEmpty() || this.referenceRange != null && !this.referenceRange.isEmpty() || this.related != null && !this.related.isEmpty() || this.component != null && !this.component.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Observation;
    }

    @Block
    public static class ObservationComponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of component observation (code / type)", formalDefinition="Describes what was observed. Sometimes this is called the observation \"code\".")
        protected CodeableConcept code;
        @Child(name="value", type={Quantity.class, CodeableConcept.class, StringType.class, Range.class, Ratio.class, SampledData.class, Attachment.class, TimeType.class, DateTimeType.class, Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Actual component result", formalDefinition="The information determined as a result of making the observation, if the information has a simple value.")
        protected Type value;
        @Child(name="dataAbsentReason", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Why the component result is missing", formalDefinition="Provides a reason why the expected value in the element Observation.value[x] is missing.")
        protected CodeableConcept dataAbsentReason;
        @Child(name="referenceRange", type={ObservationReferenceRangeComponent.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Provides guide for interpretation of component result", formalDefinition="Guidance on how to interpret the value by comparison to a normal or recommended range.")
        protected List<ObservationReferenceRangeComponent> referenceRange;
        private static final long serialVersionUID = 946602904L;

        public ObservationComponentComponent() {
        }

        public ObservationComponentComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationComponentComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ObservationComponentComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this.value instanceof Quantity;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this.value instanceof CodeableConcept;
        }

        public StringType getValueStringType() throws FHIRException {
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this.value instanceof StringType;
        }

        public Range getValueRange() throws FHIRException {
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this.value instanceof Range;
        }

        public Ratio getValueRatio() throws FHIRException {
            if (!(this.value instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Ratio)this.value;
        }

        public boolean hasValueRatio() {
            return this.value instanceof Ratio;
        }

        public SampledData getValueSampledData() throws FHIRException {
            if (!(this.value instanceof SampledData)) {
                throw new FHIRException("Type mismatch: the type SampledData was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (SampledData)this.value;
        }

        public boolean hasValueSampledData() {
            return this.value instanceof SampledData;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this.value instanceof Attachment;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this.value instanceof TimeType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this.value instanceof DateTimeType;
        }

        public Period getValuePeriod() throws FHIRException {
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this.value instanceof Period;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ObservationComponentComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        public CodeableConcept getDataAbsentReason() {
            if (this.dataAbsentReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationComponentComponent.dataAbsentReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.dataAbsentReason = new CodeableConcept();
                }
            }
            return this.dataAbsentReason;
        }

        public boolean hasDataAbsentReason() {
            return this.dataAbsentReason != null && !this.dataAbsentReason.isEmpty();
        }

        public ObservationComponentComponent setDataAbsentReason(CodeableConcept value) {
            this.dataAbsentReason = value;
            return this;
        }

        public List<ObservationReferenceRangeComponent> getReferenceRange() {
            if (this.referenceRange == null) {
                this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
            }
            return this.referenceRange;
        }

        public boolean hasReferenceRange() {
            if (this.referenceRange == null) {
                return false;
            }
            for (ObservationReferenceRangeComponent item : this.referenceRange) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ObservationReferenceRangeComponent addReferenceRange() {
            ObservationReferenceRangeComponent t = new ObservationReferenceRangeComponent();
            if (this.referenceRange == null) {
                this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
            }
            this.referenceRange.add(t);
            return t;
        }

        public ObservationComponentComponent addReferenceRange(ObservationReferenceRangeComponent t) {
            if (t == null) {
                return this;
            }
            if (this.referenceRange == null) {
                this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
            }
            this.referenceRange.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Observation.SP_CODE, "CodeableConcept", "Describes what was observed. Sometimes this is called the observation \"code\".", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("value[x]", "Quantity|CodeableConcept|string|Range|Ratio|SampledData|Attachment|time|dateTime|Period", "The information determined as a result of making the observation, if the information has a simple value.", 0, Integer.MAX_VALUE, this.value));
            childrenList.add(new Property("dataAbsentReason", "CodeableConcept", "Provides a reason why the expected value in the element Observation.value[x] is missing.", 0, Integer.MAX_VALUE, this.dataAbsentReason));
            childrenList.add(new Property("referenceRange", "@Observation.referenceRange", "Guidance on how to interpret the value by comparison to a normal or recommended range.", 0, Integer.MAX_VALUE, this.referenceRange));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Observation.SP_CODE)) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else if (name.equals("dataAbsentReason")) {
                this.dataAbsentReason = this.castToCodeableConcept(value);
            } else if (name.equals("referenceRange")) {
                this.getReferenceRange().add((ObservationReferenceRangeComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Observation.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("dataAbsentReason")) {
                this.dataAbsentReason = new CodeableConcept();
                return this.dataAbsentReason;
            }
            if (name.equals("referenceRange")) {
                return this.addReferenceRange();
            }
            return super.addChild(name);
        }

        @Override
        public ObservationComponentComponent copy() {
            ObservationComponentComponent dst = new ObservationComponentComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
            CodeableConcept codeableConcept = dst.dataAbsentReason = this.dataAbsentReason == null ? null : this.dataAbsentReason.copy();
            if (this.referenceRange != null) {
                dst.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
                for (ObservationReferenceRangeComponent i : this.referenceRange) {
                    dst.referenceRange.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ObservationComponentComponent)) {
                return false;
            }
            ObservationComponentComponent o = (ObservationComponentComponent)other;
            return ObservationComponentComponent.compareDeep(this.code, o.code, true) && ObservationComponentComponent.compareDeep(this.value, o.value, true) && ObservationComponentComponent.compareDeep(this.dataAbsentReason, o.dataAbsentReason, true) && ObservationComponentComponent.compareDeep(this.referenceRange, o.referenceRange, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ObservationComponentComponent)) {
                return false;
            }
            ObservationComponentComponent o = (ObservationComponentComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.value != null && !this.value.isEmpty() || this.dataAbsentReason != null && !this.dataAbsentReason.isEmpty() || this.referenceRange != null && !this.referenceRange.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Observation.component";
        }
    }

    @Block
    public static class ObservationRelatedComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="has-member | derived-from | sequel-to | replaces | qualified-by | interfered-by", formalDefinition="A code specifying the kind of relationship that exists with the target resource.")
        protected Enumeration<ObservationRelationshipType> type;
        @Child(name="target", type={Observation.class, QuestionnaireResponse.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource that is related to this one", formalDefinition="A reference to the observation or [[[QuestionnaireResponse]]] resource that is related to this observation.")
        protected Reference target;
        protected Resource targetTarget;
        private static final long serialVersionUID = 1541802577L;

        public ObservationRelatedComponent() {
        }

        public ObservationRelatedComponent(Reference target) {
            this.target = target;
        }

        public Enumeration<ObservationRelationshipType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationRelatedComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ObservationRelationshipType>(new ObservationRelationshipTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ObservationRelatedComponent setTypeElement(Enumeration<ObservationRelationshipType> value) {
            this.type = value;
            return this;
        }

        public ObservationRelationshipType getType() {
            return this.type == null ? null : (ObservationRelationshipType)((Object)this.type.getValue());
        }

        public ObservationRelatedComponent setType(ObservationRelationshipType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<ObservationRelationshipType>(new ObservationRelationshipTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public Reference getTarget() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationRelatedComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new Reference();
                }
            }
            return this.target;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public ObservationRelatedComponent setTarget(Reference value) {
            this.target = value;
            return this;
        }

        public Resource getTargetTarget() {
            return this.targetTarget;
        }

        public ObservationRelatedComponent setTargetTarget(Resource value) {
            this.targetTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", Observation.SP_CODE, "A code specifying the kind of relationship that exists with the target resource.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("target", "Reference(Observation|QuestionnaireResponse)", "A reference to the observation or [[[QuestionnaireResponse]]] resource that is related to this observation.", 0, Integer.MAX_VALUE, this.target));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = new ObservationRelationshipTypeEnumFactory().fromType(value);
            } else if (name.equals("target")) {
                this.target = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type Observation.type");
            }
            if (name.equals("target")) {
                this.target = new Reference();
                return this.target;
            }
            return super.addChild(name);
        }

        @Override
        public ObservationRelatedComponent copy() {
            ObservationRelatedComponent dst = new ObservationRelatedComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.target = this.target == null ? null : this.target.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ObservationRelatedComponent)) {
                return false;
            }
            ObservationRelatedComponent o = (ObservationRelatedComponent)other;
            return ObservationRelatedComponent.compareDeep(this.type, o.type, true) && ObservationRelatedComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ObservationRelatedComponent)) {
                return false;
            }
            ObservationRelatedComponent o = (ObservationRelatedComponent)other;
            return ObservationRelatedComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.target != null && !this.target.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Observation.related";
        }
    }

    @Block
    public static class ObservationReferenceRangeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="low", type={SimpleQuantity.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Low Range, if relevant", formalDefinition="The value of the low bound of the reference range.  The low bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9).   If the low bound is omitted,  it is assumed to be meaningless (e.g. reference range is <=2.3).")
        protected SimpleQuantity low;
        @Child(name="high", type={SimpleQuantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="High Range, if relevant", formalDefinition="The value of the high bound of the reference range.  The high bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9).   If the high bound is omitted,  it is assumed to be meaningless (e.g. reference range is >= 2.3).")
        protected SimpleQuantity high;
        @Child(name="meaning", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates the meaning/use of this range of this range", formalDefinition="Code for the meaning of the reference range.")
        protected CodeableConcept meaning;
        @Child(name="age", type={Range.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable age range, if relevant", formalDefinition="The age at which this reference range is applicable. This is a neonatal age (e.g. number of weeks at term) if the meaning says so.")
        protected Range age;
        @Child(name="text", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text based reference range in an observation", formalDefinition="Text based reference range in an observation which may be used when a quantitative range is not appropriate for an observation.  An example would be a reference value of \"Negative\" or a list or table of 'normals'.")
        protected StringType text;
        private static final long serialVersionUID = -238694788L;

        public SimpleQuantity getLow() {
            if (this.low == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.low");
                }
                if (Configuration.doAutoCreate()) {
                    this.low = new SimpleQuantity();
                }
            }
            return this.low;
        }

        public boolean hasLow() {
            return this.low != null && !this.low.isEmpty();
        }

        public ObservationReferenceRangeComponent setLow(SimpleQuantity value) {
            this.low = value;
            return this;
        }

        public SimpleQuantity getHigh() {
            if (this.high == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.high");
                }
                if (Configuration.doAutoCreate()) {
                    this.high = new SimpleQuantity();
                }
            }
            return this.high;
        }

        public boolean hasHigh() {
            return this.high != null && !this.high.isEmpty();
        }

        public ObservationReferenceRangeComponent setHigh(SimpleQuantity value) {
            this.high = value;
            return this;
        }

        public CodeableConcept getMeaning() {
            if (this.meaning == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.meaning");
                }
                if (Configuration.doAutoCreate()) {
                    this.meaning = new CodeableConcept();
                }
            }
            return this.meaning;
        }

        public boolean hasMeaning() {
            return this.meaning != null && !this.meaning.isEmpty();
        }

        public ObservationReferenceRangeComponent setMeaning(CodeableConcept value) {
            this.meaning = value;
            return this;
        }

        public Range getAge() {
            if (this.age == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.age");
                }
                if (Configuration.doAutoCreate()) {
                    this.age = new Range();
                }
            }
            return this.age;
        }

        public boolean hasAge() {
            return this.age != null && !this.age.isEmpty();
        }

        public ObservationReferenceRangeComponent setAge(Range value) {
            this.age = value;
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public ObservationReferenceRangeComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public ObservationReferenceRangeComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("low", "SimpleQuantity", "The value of the low bound of the reference range.  The low bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9).   If the low bound is omitted,  it is assumed to be meaningless (e.g. reference range is <=2.3).", 0, Integer.MAX_VALUE, this.low));
            childrenList.add(new Property("high", "SimpleQuantity", "The value of the high bound of the reference range.  The high bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9).   If the high bound is omitted,  it is assumed to be meaningless (e.g. reference range is >= 2.3).", 0, Integer.MAX_VALUE, this.high));
            childrenList.add(new Property("meaning", "CodeableConcept", "Code for the meaning of the reference range.", 0, Integer.MAX_VALUE, this.meaning));
            childrenList.add(new Property("age", "Range", "The age at which this reference range is applicable. This is a neonatal age (e.g. number of weeks at term) if the meaning says so.", 0, Integer.MAX_VALUE, this.age));
            childrenList.add(new Property("text", "string", "Text based reference range in an observation which may be used when a quantitative range is not appropriate for an observation.  An example would be a reference value of \"Negative\" or a list or table of 'normals'.", 0, Integer.MAX_VALUE, this.text));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("low")) {
                this.low = this.castToSimpleQuantity(value);
            } else if (name.equals("high")) {
                this.high = this.castToSimpleQuantity(value);
            } else if (name.equals("meaning")) {
                this.meaning = this.castToCodeableConcept(value);
            } else if (name.equals("age")) {
                this.age = this.castToRange(value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("low")) {
                this.low = new SimpleQuantity();
                return this.low;
            }
            if (name.equals("high")) {
                this.high = new SimpleQuantity();
                return this.high;
            }
            if (name.equals("meaning")) {
                this.meaning = new CodeableConcept();
                return this.meaning;
            }
            if (name.equals("age")) {
                this.age = new Range();
                return this.age;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Observation.text");
            }
            return super.addChild(name);
        }

        @Override
        public ObservationReferenceRangeComponent copy() {
            ObservationReferenceRangeComponent dst = new ObservationReferenceRangeComponent();
            this.copyValues(dst);
            dst.low = this.low == null ? null : this.low.copy();
            dst.high = this.high == null ? null : this.high.copy();
            dst.meaning = this.meaning == null ? null : this.meaning.copy();
            dst.age = this.age == null ? null : this.age.copy();
            dst.text = this.text == null ? null : this.text.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ObservationReferenceRangeComponent)) {
                return false;
            }
            ObservationReferenceRangeComponent o = (ObservationReferenceRangeComponent)other;
            return ObservationReferenceRangeComponent.compareDeep(this.low, o.low, true) && ObservationReferenceRangeComponent.compareDeep(this.high, o.high, true) && ObservationReferenceRangeComponent.compareDeep(this.meaning, o.meaning, true) && ObservationReferenceRangeComponent.compareDeep(this.age, o.age, true) && ObservationReferenceRangeComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ObservationReferenceRangeComponent)) {
                return false;
            }
            ObservationReferenceRangeComponent o = (ObservationReferenceRangeComponent)other;
            return ObservationReferenceRangeComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.low != null && !this.low.isEmpty() || this.high != null && !this.high.isEmpty() || this.meaning != null && !this.meaning.isEmpty() || this.age != null && !this.age.isEmpty() || this.text != null && !this.text.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Observation.referenceRange";
        }
    }

    public static class ObservationRelationshipTypeEnumFactory
    implements EnumFactory<ObservationRelationshipType> {
        @Override
        public ObservationRelationshipType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("has-member".equals(codeString)) {
                return ObservationRelationshipType.HASMEMBER;
            }
            if ("derived-from".equals(codeString)) {
                return ObservationRelationshipType.DERIVEDFROM;
            }
            if ("sequel-to".equals(codeString)) {
                return ObservationRelationshipType.SEQUELTO;
            }
            if ("replaces".equals(codeString)) {
                return ObservationRelationshipType.REPLACES;
            }
            if ("qualified-by".equals(codeString)) {
                return ObservationRelationshipType.QUALIFIEDBY;
            }
            if ("interfered-by".equals(codeString)) {
                return ObservationRelationshipType.INTERFEREDBY;
            }
            throw new IllegalArgumentException("Unknown ObservationRelationshipType code '" + codeString + "'");
        }

        public Enumeration<ObservationRelationshipType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("has-member".equals(codeString)) {
                return new Enumeration<ObservationRelationshipType>(this, ObservationRelationshipType.HASMEMBER);
            }
            if ("derived-from".equals(codeString)) {
                return new Enumeration<ObservationRelationshipType>(this, ObservationRelationshipType.DERIVEDFROM);
            }
            if ("sequel-to".equals(codeString)) {
                return new Enumeration<ObservationRelationshipType>(this, ObservationRelationshipType.SEQUELTO);
            }
            if ("replaces".equals(codeString)) {
                return new Enumeration<ObservationRelationshipType>(this, ObservationRelationshipType.REPLACES);
            }
            if ("qualified-by".equals(codeString)) {
                return new Enumeration<ObservationRelationshipType>(this, ObservationRelationshipType.QUALIFIEDBY);
            }
            if ("interfered-by".equals(codeString)) {
                return new Enumeration<ObservationRelationshipType>(this, ObservationRelationshipType.INTERFEREDBY);
            }
            throw new FHIRException("Unknown ObservationRelationshipType code '" + codeString + "'");
        }

        @Override
        public String toCode(ObservationRelationshipType code) {
            if (code == ObservationRelationshipType.HASMEMBER) {
                return "has-member";
            }
            if (code == ObservationRelationshipType.DERIVEDFROM) {
                return "derived-from";
            }
            if (code == ObservationRelationshipType.SEQUELTO) {
                return "sequel-to";
            }
            if (code == ObservationRelationshipType.REPLACES) {
                return "replaces";
            }
            if (code == ObservationRelationshipType.QUALIFIEDBY) {
                return "qualified-by";
            }
            if (code == ObservationRelationshipType.INTERFEREDBY) {
                return "interfered-by";
            }
            return "?";
        }
    }

    public static enum ObservationRelationshipType {
        HASMEMBER,
        DERIVEDFROM,
        SEQUELTO,
        REPLACES,
        QUALIFIEDBY,
        INTERFEREDBY,
        NULL;


        public static ObservationRelationshipType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("has-member".equals(codeString)) {
                return HASMEMBER;
            }
            if ("derived-from".equals(codeString)) {
                return DERIVEDFROM;
            }
            if ("sequel-to".equals(codeString)) {
                return SEQUELTO;
            }
            if ("replaces".equals(codeString)) {
                return REPLACES;
            }
            if ("qualified-by".equals(codeString)) {
                return QUALIFIEDBY;
            }
            if ("interfered-by".equals(codeString)) {
                return INTERFEREDBY;
            }
            throw new FHIRException("Unknown ObservationRelationshipType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case HASMEMBER: {
                    return "has-member";
                }
                case DERIVEDFROM: {
                    return "derived-from";
                }
                case SEQUELTO: {
                    return "sequel-to";
                }
                case REPLACES: {
                    return "replaces";
                }
                case QUALIFIEDBY: {
                    return "qualified-by";
                }
                case INTERFEREDBY: {
                    return "interfered-by";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case HASMEMBER: {
                    return "http://hl7.org/fhir/observation-relationshiptypes";
                }
                case DERIVEDFROM: {
                    return "http://hl7.org/fhir/observation-relationshiptypes";
                }
                case SEQUELTO: {
                    return "http://hl7.org/fhir/observation-relationshiptypes";
                }
                case REPLACES: {
                    return "http://hl7.org/fhir/observation-relationshiptypes";
                }
                case QUALIFIEDBY: {
                    return "http://hl7.org/fhir/observation-relationshiptypes";
                }
                case INTERFEREDBY: {
                    return "http://hl7.org/fhir/observation-relationshiptypes";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case HASMEMBER: {
                    return "This observation is a group observation (e.g. a battery, a panel of tests, a set of vital sign measurements) that includes the target as a member of the group.";
                }
                case DERIVEDFROM: {
                    return "The target resource (Observation or QuestionnaireResponse) is part of the information from which this observation value is derived. (e.g. calculated anion gap, Apgar score)  NOTE:  \"derived-from\" is only logical choice when referencing QuestionnaireResponse.";
                }
                case SEQUELTO: {
                    return "This observation follows the target observation (e.g. timed tests such as Glucose Tolerance Test).";
                }
                case REPLACES: {
                    return "This observation replaces a previous observation (i.e. a revised value). The target observation is now obsolete.";
                }
                case QUALIFIEDBY: {
                    return "The value of the target observation qualifies (refines) the semantics of the source observation (e.g. a lipemia measure target from a plasma measure).";
                }
                case INTERFEREDBY: {
                    return "The value of the target observation interferes (degrades quality, or prevents valid observation) with the semantics of the source observation (e.g. a hemolysis measure target from a plasma potassium measure which has no value).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case HASMEMBER: {
                    return "Has Member";
                }
                case DERIVEDFROM: {
                    return "Derived From";
                }
                case SEQUELTO: {
                    return "Sequel To";
                }
                case REPLACES: {
                    return "Replaces";
                }
                case QUALIFIEDBY: {
                    return "Qualified By";
                }
                case INTERFEREDBY: {
                    return "Interfered By";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ObservationStatusEnumFactory
    implements EnumFactory<ObservationStatus> {
        @Override
        public ObservationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return ObservationStatus.REGISTERED;
            }
            if ("preliminary".equals(codeString)) {
                return ObservationStatus.PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return ObservationStatus.FINAL;
            }
            if ("amended".equals(codeString)) {
                return ObservationStatus.AMENDED;
            }
            if ("cancelled".equals(codeString)) {
                return ObservationStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ObservationStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return ObservationStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown ObservationStatus code '" + codeString + "'");
        }

        public Enumeration<ObservationStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.REGISTERED);
            }
            if ("preliminary".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.PRELIMINARY);
            }
            if ("final".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.FINAL);
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.AMENDED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.CANCELLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<ObservationStatus>(this, ObservationStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown ObservationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ObservationStatus code) {
            if (code == ObservationStatus.REGISTERED) {
                return "registered";
            }
            if (code == ObservationStatus.PRELIMINARY) {
                return "preliminary";
            }
            if (code == ObservationStatus.FINAL) {
                return "final";
            }
            if (code == ObservationStatus.AMENDED) {
                return "amended";
            }
            if (code == ObservationStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ObservationStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ObservationStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }
    }

    public static enum ObservationStatus {
        REGISTERED,
        PRELIMINARY,
        FINAL,
        AMENDED,
        CANCELLED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static ObservationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return REGISTERED;
            }
            if ("preliminary".equals(codeString)) {
                return PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return FINAL;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            throw new FHIRException("Unknown ObservationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REGISTERED: {
                    return "registered";
                }
                case PRELIMINARY: {
                    return "preliminary";
                }
                case FINAL: {
                    return "final";
                }
                case AMENDED: {
                    return "amended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REGISTERED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case PRELIMINARY: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case FINAL: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case AMENDED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REGISTERED: {
                    return "The existence of the observation is registered, but there is no result yet available.";
                }
                case PRELIMINARY: {
                    return "This is an initial or interim observation: data may be incomplete or unverified.";
                }
                case FINAL: {
                    return "The observation is complete and verified by an authorized person.";
                }
                case AMENDED: {
                    return "The observation has been modified subsequent to being Final, and is complete and verified by an authorized person.";
                }
                case CANCELLED: {
                    return "The observation is unavailable because the measurement was not started or not completed (also sometimes called \"aborted\").";
                }
                case ENTEREDINERROR: {
                    return "The observation has been withdrawn following previous final release.";
                }
                case UNKNOWN: {
                    return "The observation status is unknown.  Note that \"unknown\" is a value of last resort and every attempt should be made to provide a meaningful value other than \"unknown\".";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REGISTERED: {
                    return "Registered";
                }
                case PRELIMINARY: {
                    return "Preliminary";
                }
                case FINAL: {
                    return "Final";
                }
                case AMENDED: {
                    return "Amended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown Status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

