/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Attachment;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.CommunicationRequest;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Group;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Communication", profile="http://hl7.org/fhir/Profile/Communication")
public class Communication
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Identifiers associated with this Communication that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Message category", formalDefinition="The type of message conveyed such as alert, notification, reminder, instruction, etc.")
    protected CodeableConcept category;
    @Child(name="sender", type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Message sender", formalDefinition="The entity (e.g. person, organization, clinical information system, or device) which was the source of the communication.")
    protected Reference sender;
    protected Resource senderTarget;
    @Child(name="recipient", type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, Group.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Message recipient", formalDefinition="The entity (e.g. person, organization, clinical information system, or device) which was the target of the communication. If receipts need to be tracked by individual, a separate resource instance will need to be created for each recipient. \u00a0Multiple recipient communications are intended where either a receipt(s) is not tracked (e.g. a mass mail-out) or is captured in aggregate (all emails confirmed received by a particular time).")
    protected List<Reference> recipient;
    protected List<Resource> recipientTarget;
    @Child(name="payload", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Message payload", formalDefinition="Text, attachment(s), or resource(s) that was communicated to the recipient.")
    protected List<CommunicationPayloadComponent> payload;
    @Child(name="medium", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A channel of communication", formalDefinition="A channel that was used for this communication (e.g. email, fax).")
    protected List<CodeableConcept> medium;
    @Child(name="status", type={CodeType.class}, order=6, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | completed | suspended | rejected | failed", formalDefinition="The status of the transmission.")
    protected Enumeration<CommunicationStatus> status;
    @Child(name="encounter", type={Encounter.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter leading to message", formalDefinition="The encounter within which the communication was sent.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="sent", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When sent", formalDefinition="The time when this communication was sent.")
    protected DateTimeType sent;
    @Child(name="received", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When received", formalDefinition="The time when this communication arrived at the destination.")
    protected DateTimeType received;
    @Child(name="reason", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Indication for message", formalDefinition="The reason or justification for the communication.")
    protected List<CodeableConcept> reason;
    @Child(name="subject", type={Patient.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Focus of message", formalDefinition="The patient who was the focus of this communication.")
    protected Reference subject;
    protected Patient subjectTarget;
    @Child(name="requestDetail", type={CommunicationRequest.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="CommunicationRequest producing this message", formalDefinition="The communication request that was responsible for producing this communication.")
    protected Reference requestDetail;
    protected CommunicationRequest requestDetailTarget;
    private static final long serialVersionUID = -1654449146L;
    @SearchParamDefinition(name="identifier", path="Communication.identifier", description="Unique identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="request", path="Communication.requestDetail", description="CommunicationRequest producing this message", type="reference")
    public static final String SP_REQUEST = "request";
    @SearchParamDefinition(name="sender", path="Communication.sender", description="Message sender", type="reference")
    public static final String SP_SENDER = "sender";
    @SearchParamDefinition(name="subject", path="Communication.subject", description="Focus of message", type="reference")
    public static final String SP_SUBJECT = "subject";
    @SearchParamDefinition(name="patient", path="Communication.subject", description="Focus of message", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="recipient", path="Communication.recipient", description="Message recipient", type="reference")
    public static final String SP_RECIPIENT = "recipient";
    @SearchParamDefinition(name="received", path="Communication.received", description="When received", type="date")
    public static final String SP_RECEIVED = "received";
    @SearchParamDefinition(name="medium", path="Communication.medium", description="A channel of communication", type="token")
    public static final String SP_MEDIUM = "medium";
    @SearchParamDefinition(name="encounter", path="Communication.encounter", description="Encounter leading to message", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    @SearchParamDefinition(name="category", path="Communication.category", description="Message category", type="token")
    public static final String SP_CATEGORY = "category";
    @SearchParamDefinition(name="sent", path="Communication.sent", description="When sent", type="date")
    public static final String SP_SENT = "sent";
    @SearchParamDefinition(name="status", path="Communication.status", description="in-progress | completed | suspended | rejected | failed", type="token")
    public static final String SP_STATUS = "status";

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Communication addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public Communication setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public Reference getSender() {
        if (this.sender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.sender");
            }
            if (Configuration.doAutoCreate()) {
                this.sender = new Reference();
            }
        }
        return this.sender;
    }

    public boolean hasSender() {
        return this.sender != null && !this.sender.isEmpty();
    }

    public Communication setSender(Reference value) {
        this.sender = value;
        return this;
    }

    public Resource getSenderTarget() {
        return this.senderTarget;
    }

    public Communication setSenderTarget(Resource value) {
        this.senderTarget = value;
        return this;
    }

    public List<Reference> getRecipient() {
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        return this.recipient;
    }

    public boolean hasRecipient() {
        if (this.recipient == null) {
            return false;
        }
        for (Reference item : this.recipient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRecipient() {
        Reference t = new Reference();
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return t;
    }

    public Communication addRecipient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return this;
    }

    public List<Resource> getRecipientTarget() {
        if (this.recipientTarget == null) {
            this.recipientTarget = new ArrayList<Resource>();
        }
        return this.recipientTarget;
    }

    public List<CommunicationPayloadComponent> getPayload() {
        if (this.payload == null) {
            this.payload = new ArrayList<CommunicationPayloadComponent>();
        }
        return this.payload;
    }

    public boolean hasPayload() {
        if (this.payload == null) {
            return false;
        }
        for (CommunicationPayloadComponent item : this.payload) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CommunicationPayloadComponent addPayload() {
        CommunicationPayloadComponent t = new CommunicationPayloadComponent();
        if (this.payload == null) {
            this.payload = new ArrayList<CommunicationPayloadComponent>();
        }
        this.payload.add(t);
        return t;
    }

    public Communication addPayload(CommunicationPayloadComponent t) {
        if (t == null) {
            return this;
        }
        if (this.payload == null) {
            this.payload = new ArrayList<CommunicationPayloadComponent>();
        }
        this.payload.add(t);
        return this;
    }

    public List<CodeableConcept> getMedium() {
        if (this.medium == null) {
            this.medium = new ArrayList<CodeableConcept>();
        }
        return this.medium;
    }

    public boolean hasMedium() {
        if (this.medium == null) {
            return false;
        }
        for (CodeableConcept item : this.medium) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addMedium() {
        CodeableConcept t = new CodeableConcept();
        if (this.medium == null) {
            this.medium = new ArrayList<CodeableConcept>();
        }
        this.medium.add(t);
        return t;
    }

    public Communication addMedium(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.medium == null) {
            this.medium = new ArrayList<CodeableConcept>();
        }
        this.medium.add(t);
        return this;
    }

    public Enumeration<CommunicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<CommunicationStatus>(new CommunicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Communication setStatusElement(Enumeration<CommunicationStatus> value) {
        this.status = value;
        return this;
    }

    public CommunicationStatus getStatus() {
        return this.status == null ? null : (CommunicationStatus)((Object)this.status.getValue());
    }

    public Communication setStatus(CommunicationStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<CommunicationStatus>(new CommunicationStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Communication setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public Communication setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public DateTimeType getSentElement() {
        if (this.sent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.sent");
            }
            if (Configuration.doAutoCreate()) {
                this.sent = new DateTimeType();
            }
        }
        return this.sent;
    }

    public boolean hasSentElement() {
        return this.sent != null && !this.sent.isEmpty();
    }

    public boolean hasSent() {
        return this.sent != null && !this.sent.isEmpty();
    }

    public Communication setSentElement(DateTimeType value) {
        this.sent = value;
        return this;
    }

    public Date getSent() {
        return this.sent == null ? null : (Date)this.sent.getValue();
    }

    public Communication setSent(Date value) {
        if (value == null) {
            this.sent = null;
        } else {
            if (this.sent == null) {
                this.sent = new DateTimeType();
            }
            this.sent.setValue(value);
        }
        return this;
    }

    public DateTimeType getReceivedElement() {
        if (this.received == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.received");
            }
            if (Configuration.doAutoCreate()) {
                this.received = new DateTimeType();
            }
        }
        return this.received;
    }

    public boolean hasReceivedElement() {
        return this.received != null && !this.received.isEmpty();
    }

    public boolean hasReceived() {
        return this.received != null && !this.received.isEmpty();
    }

    public Communication setReceivedElement(DateTimeType value) {
        this.received = value;
        return this;
    }

    public Date getReceived() {
        return this.received == null ? null : (Date)this.received.getValue();
    }

    public Communication setReceived(Date value) {
        if (value == null) {
            this.received = null;
        } else {
            if (this.received == null) {
                this.received = new DateTimeType();
            }
            this.received.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        return this.reason;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableConcept item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return t;
    }

    public Communication addReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Communication setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Patient getSubjectTarget() {
        if (this.subjectTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subjectTarget = new Patient();
            }
        }
        return this.subjectTarget;
    }

    public Communication setSubjectTarget(Patient value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getRequestDetail() {
        if (this.requestDetail == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.requestDetail");
            }
            if (Configuration.doAutoCreate()) {
                this.requestDetail = new Reference();
            }
        }
        return this.requestDetail;
    }

    public boolean hasRequestDetail() {
        return this.requestDetail != null && !this.requestDetail.isEmpty();
    }

    public Communication setRequestDetail(Reference value) {
        this.requestDetail = value;
        return this;
    }

    public CommunicationRequest getRequestDetailTarget() {
        if (this.requestDetailTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.requestDetail");
            }
            if (Configuration.doAutoCreate()) {
                this.requestDetailTarget = new CommunicationRequest();
            }
        }
        return this.requestDetailTarget;
    }

    public Communication setRequestDetailTarget(CommunicationRequest value) {
        this.requestDetailTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Communication that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_CATEGORY, "CodeableConcept", "The type of message conveyed such as alert, notification, reminder, instruction, etc.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property(SP_SENDER, "Reference(Device|Organization|Patient|Practitioner|RelatedPerson)", "The entity (e.g. person, organization, clinical information system, or device) which was the source of the communication.", 0, Integer.MAX_VALUE, this.sender));
        childrenList.add(new Property(SP_RECIPIENT, "Reference(Device|Organization|Patient|Practitioner|RelatedPerson|Group)", "The entity (e.g. person, organization, clinical information system, or device) which was the target of the communication. If receipts need to be tracked by individual, a separate resource instance will need to be created for each recipient. \u00a0Multiple recipient communications are intended where either a receipt(s) is not tracked (e.g. a mass mail-out) or is captured in aggregate (all emails confirmed received by a particular time).", 0, Integer.MAX_VALUE, this.recipient));
        childrenList.add(new Property("payload", "", "Text, attachment(s), or resource(s) that was communicated to the recipient.", 0, Integer.MAX_VALUE, this.payload));
        childrenList.add(new Property(SP_MEDIUM, "CodeableConcept", "A channel that was used for this communication (e.g. email, fax).", 0, Integer.MAX_VALUE, this.medium));
        childrenList.add(new Property(SP_STATUS, "code", "The status of the transmission.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter within which the communication was sent.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property(SP_SENT, "dateTime", "The time when this communication was sent.", 0, Integer.MAX_VALUE, this.sent));
        childrenList.add(new Property(SP_RECEIVED, "dateTime", "The time when this communication arrived at the destination.", 0, Integer.MAX_VALUE, this.received));
        childrenList.add(new Property("reason", "CodeableConcept", "The reason or justification for the communication.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient)", "The patient who was the focus of this communication.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property("requestDetail", "Reference(CommunicationRequest)", "The communication request that was responsible for producing this communication.", 0, Integer.MAX_VALUE, this.requestDetail));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_CATEGORY)) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SENDER)) {
            this.sender = this.castToReference(value);
        } else if (name.equals(SP_RECIPIENT)) {
            this.getRecipient().add(this.castToReference(value));
        } else if (name.equals("payload")) {
            this.getPayload().add((CommunicationPayloadComponent)value);
        } else if (name.equals(SP_MEDIUM)) {
            this.getMedium().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = new CommunicationStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals(SP_SENT)) {
            this.sent = this.castToDateTime(value);
        } else if (name.equals(SP_RECEIVED)) {
            this.received = this.castToDateTime(value);
        } else if (name.equals("reason")) {
            this.getReason().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("requestDetail")) {
            this.requestDetail = this.castToReference(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals(SP_SENDER)) {
            this.sender = new Reference();
            return this.sender;
        }
        if (name.equals(SP_RECIPIENT)) {
            return this.addRecipient();
        }
        if (name.equals("payload")) {
            return this.addPayload();
        }
        if (name.equals(SP_MEDIUM)) {
            return this.addMedium();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Communication.status");
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_SENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type Communication.sent");
        }
        if (name.equals(SP_RECEIVED)) {
            throw new FHIRException("Cannot call addChild on a primitive type Communication.received");
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("requestDetail")) {
            this.requestDetail = new Reference();
            return this.requestDetail;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Communication";
    }

    @Override
    public Communication copy() {
        Communication dst = new Communication();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.category = this.category == null ? null : this.category.copy();
        Reference reference = dst.sender = this.sender == null ? null : this.sender.copy();
        if (this.recipient != null) {
            dst.recipient = new ArrayList<Reference>();
            for (Reference reference2 : this.recipient) {
                dst.recipient.add(reference2.copy());
            }
        }
        if (this.payload != null) {
            dst.payload = new ArrayList<CommunicationPayloadComponent>();
            for (CommunicationPayloadComponent communicationPayloadComponent : this.payload) {
                dst.payload.add(communicationPayloadComponent.copy());
            }
        }
        if (this.medium != null) {
            dst.medium = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.medium) {
                dst.medium.add(codeableConcept.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.sent = this.sent == null ? null : this.sent.copy();
        DateTimeType dateTimeType = dst.received = this.received == null ? null : this.received.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reason) {
                dst.reason.add(codeableConcept.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.requestDetail = this.requestDetail == null ? null : this.requestDetail.copy();
        return dst;
    }

    protected Communication typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Communication)) {
            return false;
        }
        Communication o = (Communication)other;
        return Communication.compareDeep(this.identifier, o.identifier, true) && Communication.compareDeep(this.category, o.category, true) && Communication.compareDeep(this.sender, o.sender, true) && Communication.compareDeep(this.recipient, o.recipient, true) && Communication.compareDeep(this.payload, o.payload, true) && Communication.compareDeep(this.medium, o.medium, true) && Communication.compareDeep(this.status, o.status, true) && Communication.compareDeep(this.encounter, o.encounter, true) && Communication.compareDeep(this.sent, o.sent, true) && Communication.compareDeep(this.received, o.received, true) && Communication.compareDeep(this.reason, o.reason, true) && Communication.compareDeep(this.subject, o.subject, true) && Communication.compareDeep(this.requestDetail, o.requestDetail, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Communication)) {
            return false;
        }
        Communication o = (Communication)other;
        return Communication.compareValues(this.status, o.status, true) && Communication.compareValues(this.sent, o.sent, true) && Communication.compareValues(this.received, o.received, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.category != null && !this.category.isEmpty() || this.sender != null && !this.sender.isEmpty() || this.recipient != null && !this.recipient.isEmpty() || this.payload != null && !this.payload.isEmpty() || this.medium != null && !this.medium.isEmpty() || this.status != null && !this.status.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.sent != null && !this.sent.isEmpty() || this.received != null && !this.received.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.requestDetail != null && !this.requestDetail.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Communication;
    }

    @Block
    public static class CommunicationPayloadComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="content", type={StringType.class, Attachment.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Message part content", formalDefinition="A communicated content (or for multi-part communications, one portion of the communication).")
        protected Type content;
        private static final long serialVersionUID = -1763459053L;

        public CommunicationPayloadComponent() {
        }

        public CommunicationPayloadComponent(Type content) {
            this.content = content;
        }

        public Type getContent() {
            return this.content;
        }

        public StringType getContentStringType() throws FHIRException {
            if (!(this.content instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (StringType)this.content;
        }

        public boolean hasContentStringType() {
            return this.content instanceof StringType;
        }

        public Attachment getContentAttachment() throws FHIRException {
            if (!(this.content instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Attachment)this.content;
        }

        public boolean hasContentAttachment() {
            return this.content instanceof Attachment;
        }

        public Reference getContentReference() throws FHIRException {
            if (!(this.content instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Reference)this.content;
        }

        public boolean hasContentReference() {
            return this.content instanceof Reference;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public CommunicationPayloadComponent setContent(Type value) {
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("content[x]", "string|Attachment|Reference(Any)", "A communicated content (or for multi-part communications, one portion of the communication).", 0, Integer.MAX_VALUE, this.content));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("content[x]")) {
                this.content = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentString")) {
                this.content = new StringType();
                return this.content;
            }
            if (name.equals("contentAttachment")) {
                this.content = new Attachment();
                return this.content;
            }
            if (name.equals("contentReference")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public CommunicationPayloadComponent copy() {
            CommunicationPayloadComponent dst = new CommunicationPayloadComponent();
            this.copyValues(dst);
            dst.content = this.content == null ? null : this.content.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CommunicationPayloadComponent)) {
                return false;
            }
            CommunicationPayloadComponent o = (CommunicationPayloadComponent)other;
            return CommunicationPayloadComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CommunicationPayloadComponent)) {
                return false;
            }
            CommunicationPayloadComponent o = (CommunicationPayloadComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.content == null || this.content.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Communication.payload";
        }
    }

    public static class CommunicationStatusEnumFactory
    implements EnumFactory<CommunicationStatus> {
        @Override
        public CommunicationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return CommunicationStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return CommunicationStatus.COMPLETED;
            }
            if ("suspended".equals(codeString)) {
                return CommunicationStatus.SUSPENDED;
            }
            if ("rejected".equals(codeString)) {
                return CommunicationStatus.REJECTED;
            }
            if ("failed".equals(codeString)) {
                return CommunicationStatus.FAILED;
            }
            throw new IllegalArgumentException("Unknown CommunicationStatus code '" + codeString + "'");
        }

        public Enumeration<CommunicationStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<CommunicationStatus>(this, CommunicationStatus.INPROGRESS);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<CommunicationStatus>(this, CommunicationStatus.COMPLETED);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<CommunicationStatus>(this, CommunicationStatus.SUSPENDED);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<CommunicationStatus>(this, CommunicationStatus.REJECTED);
            }
            if ("failed".equals(codeString)) {
                return new Enumeration<CommunicationStatus>(this, CommunicationStatus.FAILED);
            }
            throw new FHIRException("Unknown CommunicationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CommunicationStatus code) {
            if (code == CommunicationStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == CommunicationStatus.COMPLETED) {
                return "completed";
            }
            if (code == CommunicationStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == CommunicationStatus.REJECTED) {
                return "rejected";
            }
            if (code == CommunicationStatus.FAILED) {
                return "failed";
            }
            return "?";
        }
    }

    public static enum CommunicationStatus {
        INPROGRESS,
        COMPLETED,
        SUSPENDED,
        REJECTED,
        FAILED,
        NULL;


        public static CommunicationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("failed".equals(codeString)) {
                return FAILED;
            }
            throw new FHIRException("Unknown CommunicationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case REJECTED: {
                    return "rejected";
                }
                case FAILED: {
                    return "failed";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/communication-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/communication-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/communication-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/communication-status";
                }
                case FAILED: {
                    return "http://hl7.org/fhir/communication-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "The communication transmission is ongoing.";
                }
                case COMPLETED: {
                    return "The message transmission is complete, i.e., delivered to the recipient's destination.";
                }
                case SUSPENDED: {
                    return "The communication transmission has been held by originating system/user request.";
                }
                case REJECTED: {
                    return "The receiving system has declined to accept the message.";
                }
                case FAILED: {
                    return "There was a failure in transmitting the message out.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case FAILED: {
                    return "Failed";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

