/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.Extension;
import org.hl7.fhir.dstu2.model.IdType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseElement;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.utilities.Utilities;

public abstract class Element
extends Base
implements IBaseHasExtensions,
IBaseElement {
    @Child(name="id", type={IdType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="xml:id (or equivalent in JSON)", formalDefinition="unique id for the element within a resource (for internal references).")
    protected IdType id;
    @Child(name="extension", type={Extension.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional Content defined by implementations", formalDefinition="May be used to represent additional information that is not part of the basic definition of the element. In order to make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.")
    protected List<Extension> extension;
    private static final long serialVersionUID = -158027598L;

    public IdType getIdElement() {
        if (this.id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Element.id");
            }
            if (Configuration.doAutoCreate()) {
                this.id = new IdType();
            }
        }
        return this.id;
    }

    public boolean hasIdElement() {
        return this.id != null && !this.id.isEmpty();
    }

    public boolean hasId() {
        return this.id != null && !this.id.isEmpty();
    }

    public Element setIdElement(IdType value) {
        this.id = value;
        return this;
    }

    public String getId() {
        return this.id == null ? null : this.id.getValue();
    }

    public Element setId(String value) {
        if (Utilities.noString((String)value)) {
            this.id = null;
        } else {
            if (this.id == null) {
                this.id = new IdType();
            }
            this.id.setValue(value);
        }
        return this;
    }

    public List<Extension> getExtension() {
        if (this.extension == null) {
            this.extension = new ArrayList<Extension>();
        }
        return this.extension;
    }

    public boolean hasExtension() {
        if (this.extension == null) {
            return false;
        }
        for (Extension item : this.extension) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Extension addExtension() {
        Extension t = new Extension();
        if (this.extension == null) {
            this.extension = new ArrayList<Extension>();
        }
        this.extension.add(t);
        return t;
    }

    public Element addExtension(Extension t) {
        if (t == null) {
            return this;
        }
        if (this.extension == null) {
            this.extension = new ArrayList<Extension>();
        }
        this.extension.add(t);
        return this;
    }

    public List<Extension> getExtensionsByUrl(String theUrl) {
        Validate.notBlank((CharSequence)theUrl, (String)"theUrl must not be blank or null", (Object[])new Object[0]);
        ArrayList<Extension> retVal = new ArrayList<Extension>();
        for (Extension next : this.getExtension()) {
            if (!theUrl.equals(next.getUrl())) continue;
            retVal.add(next);
        }
        return Collections.unmodifiableList(retVal);
    }

    public Extension getExtensionByUrl(String theUrl) {
        Validate.notBlank((CharSequence)theUrl, (String)"theUrl must not be blank or null", (Object[])new Object[0]);
        ArrayList<Extension> retVal = new ArrayList<Extension>();
        for (Extension next : this.getExtension()) {
            if (!theUrl.equals(next.getUrl())) continue;
            retVal.add(next);
        }
        if (retVal.size() == 0) {
            return null;
        }
        Validate.isTrue((retVal.size() == 1 ? 1 : 0) != 0, (String)("Url " + theUrl + " must have only one match"), (Object[])new Object[0]);
        return (Extension)retVal.get(0);
    }

    public void addExtension(String url, Type value) {
        Extension ex = new Extension();
        ex.setUrl(url);
        ex.setValue(value);
        this.getExtension().add(ex);
    }

    public boolean hasExtension(String theUrl) {
        return !this.getExtensionsByUrl(theUrl).isEmpty();
    }

    public String getExtensionString(String theUrl) throws FHIRException {
        List<Extension> ext = this.getExtensionsByUrl(theUrl);
        if (ext.isEmpty()) {
            return null;
        }
        if (ext.size() > 1) {
            throw new FHIRException("Multiple matching extensions found");
        }
        if (!ext.get(0).getValue().isPrimitive()) {
            throw new FHIRException("Extension could not be converted to a string");
        }
        return ext.get(0).getValue().primitiveValue();
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        childrenList.add(new Property("id", "id", "unique id for the element within a resource (for internal references).", 0, Integer.MAX_VALUE, this.id));
        childrenList.add(new Property("extension", "Extension", "May be used to represent additional information that is not part of the basic definition of the element. In order to make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.", 0, Integer.MAX_VALUE, this.extension));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("id")) {
            this.id = this.castToId(value);
        } else if (name.equals("extension")) {
            this.getExtension().add(this.castToExtension(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("id")) {
            throw new FHIRException("Cannot call addChild on a primitive type Element.id");
        }
        if (name.equals("extension")) {
            return this.addExtension();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Element";
    }

    public abstract Element copy();

    public void copyValues(Element dst) {
        IdType idType = dst.id = this.id == null ? null : this.id.copy();
        if (this.extension != null) {
            dst.extension = new ArrayList<Extension>();
            for (Extension i : this.extension) {
                dst.extension.add(i.copy());
            }
        }
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Element)) {
            return false;
        }
        Element o = (Element)other;
        return Element.compareDeep(this.id, o.id, true) && Element.compareDeep(this.extension, o.extension, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Element)) {
            return false;
        }
        Element o = (Element)other;
        return Element.compareValues(this.id, o.id, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.id != null && !this.id.isEmpty() || this.extension != null && !this.extension.isEmpty());
    }
}

