/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.utilities.DateTimeUtil;

public abstract class BaseDateTimeType
extends PrimitiveType<Date> {
    private static final long serialVersionUID = 1L;
    private static final List<FastDateFormat> ourFormatters;
    private static final Pattern ourYearDashMonthDashDayPattern;
    private static final Pattern ourYearDashMonthPattern;
    private static final FastDateFormat ourYearFormat;
    private static final FastDateFormat ourYearMonthDayFormat;
    private static final FastDateFormat ourYearMonthDayNoDashesFormat;
    private static final Pattern ourYearMonthDayPattern;
    private static final FastDateFormat ourYearMonthDayTimeFormat;
    private static final FastDateFormat ourYearMonthDayTimeMilliFormat;
    private static final FastDateFormat ourYearMonthDayTimeMilliUTCZFormat;
    private static final FastDateFormat ourYearMonthDayTimeMilliZoneFormat;
    private static final FastDateFormat ourYearMonthDayTimeUTCZFormat;
    private static final FastDateFormat ourYearMonthDayTimeZoneFormat;
    private static final FastDateFormat ourYearMonthFormat;
    private static final FastDateFormat ourYearMonthNoDashesFormat;
    private static final Pattern ourYearMonthPattern;
    private static final Pattern ourYearPattern;
    private static final FastDateFormat ourYearMonthDayTimeMinsFormat;
    private static final FastDateFormat ourYearMonthDayTimeMinsUTCZFormat;
    private static final FastDateFormat ourYearMonthDayTimeMinsZoneFormat;
    private static final FastDateFormat ourHumanDateTimeFormat;
    private static final FastDateFormat ourHumanDateFormat;
    private static final Map<String, TimeZone> timezoneCache;
    private TemporalPrecisionEnum myPrecision = TemporalPrecisionEnum.SECOND;
    private TimeZone myTimeZone;
    private boolean myTimeZoneZulu = false;

    public BaseDateTimeType() {
    }

    public BaseDateTimeType(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.setValue(theDate, thePrecision);
        this.validatePrecisionAndThrowIllegalArgumentException();
    }

    public BaseDateTimeType(String theString) {
        this.setValueAsString(theString);
        this.validatePrecisionAndThrowIllegalArgumentException();
    }

    public BaseDateTimeType(Date theDate, TemporalPrecisionEnum thePrecision, TimeZone theTimeZone) {
        this(theDate, thePrecision);
        this.setTimeZone(theTimeZone);
        this.validatePrecisionAndThrowIllegalArgumentException();
    }

    private void clearTimeZone() {
        this.myTimeZone = null;
        this.myTimeZoneZulu = false;
    }

    private void validatePrecisionAndThrowIllegalArgumentException() {
        if (!this.isPrecisionAllowed(this.getPrecision())) {
            throw new IllegalArgumentException("Invalid date/time string (datatype " + this.getClass().getSimpleName() + " does not support " + this.getPrecision() + " precision): " + this.getValueAsString());
        }
    }

    public String getValueAsString(TemporalPrecisionEnum thePrecision) {
        return this.encode((Date)this.getValue(), thePrecision);
    }

    @Override
    protected String encode(Date theValue) {
        return this.encode(theValue, this.myPrecision);
    }

    @Nullable
    private String encode(Date theValue, TemporalPrecisionEnum thePrecision) {
        if (theValue == null) {
            return null;
        }
        switch (thePrecision) {
            case DAY: {
                return ourYearMonthDayFormat.format(theValue);
            }
            case MONTH: {
                return ourYearMonthFormat.format(theValue);
            }
            case YEAR: {
                return ourYearFormat.format(theValue);
            }
            case MINUTE: {
                if (this.myTimeZoneZulu) {
                    GregorianCalendar cal = new GregorianCalendar(this.getTimeZone("GMT"));
                    cal.setTime(theValue);
                    return ourYearMonthDayTimeMinsFormat.format((Calendar)cal) + "Z";
                }
                if (this.myTimeZone != null) {
                    GregorianCalendar cal = new GregorianCalendar(this.myTimeZone);
                    cal.setTime(theValue);
                    return ourYearMonthDayTimeMinsZoneFormat.format((Calendar)cal);
                }
                return ourYearMonthDayTimeMinsFormat.format(theValue);
            }
            case SECOND: {
                if (this.myTimeZoneZulu) {
                    GregorianCalendar cal = new GregorianCalendar(this.getTimeZone("GMT"));
                    cal.setTime(theValue);
                    return ourYearMonthDayTimeFormat.format((Calendar)cal) + "Z";
                }
                if (this.myTimeZone != null) {
                    GregorianCalendar cal = new GregorianCalendar(this.myTimeZone);
                    cal.setTime(theValue);
                    return ourYearMonthDayTimeZoneFormat.format((Calendar)cal);
                }
                return ourYearMonthDayTimeFormat.format(theValue);
            }
            case MILLI: {
                if (this.myTimeZoneZulu) {
                    GregorianCalendar cal = new GregorianCalendar(this.getTimeZone("GMT"));
                    cal.setTime(theValue);
                    return ourYearMonthDayTimeMilliFormat.format((Calendar)cal) + "Z";
                }
                if (this.myTimeZone != null) {
                    GregorianCalendar cal = new GregorianCalendar(this.myTimeZone);
                    cal.setTime(theValue);
                    return ourYearMonthDayTimeMilliZoneFormat.format((Calendar)cal);
                }
                return ourYearMonthDayTimeMilliFormat.format(theValue);
            }
        }
        throw new IllegalStateException("Invalid precision (this is a bug, shouldn't happen https://xkcd.com/2200/): " + thePrecision);
    }

    protected abstract TemporalPrecisionEnum getDefaultPrecisionForDatatype();

    public TemporalPrecisionEnum getPrecision() {
        if (this.myPrecision == null) {
            return this.getDefaultPrecisionForDatatype();
        }
        return this.myPrecision;
    }

    public TimeZone getTimeZone() {
        return this.myTimeZone;
    }

    private boolean hasOffset(String theValue) {
        boolean inTime = false;
        block4: for (int i = 0; i < theValue.length(); ++i) {
            switch (theValue.charAt(i)) {
                case 'T': {
                    inTime = true;
                    continue block4;
                }
                case '+': 
                case '-': {
                    if (!inTime) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    abstract boolean isPrecisionAllowed(TemporalPrecisionEnum var1);

    public boolean isTimeZoneZulu() {
        return this.myTimeZoneZulu;
    }

    public boolean isToday() {
        Validate.notNull((Object)((Date)this.getValue()), (String)(this.getClass().getSimpleName() + " contains null value"), (Object[])new Object[0]);
        return DateUtils.isSameDay((Date)new Date(), (Date)((Date)this.getValue()));
    }

    @Override
    protected Date parse(String theValue) throws IllegalArgumentException {
        try {
            if (theValue.length() == 4 && ourYearPattern.matcher(theValue).matches()) {
                this.setPrecision(TemporalPrecisionEnum.YEAR);
                this.clearTimeZone();
                return ourYearFormat.parse(theValue);
            }
            if (theValue.length() == 6 && ourYearMonthPattern.matcher(theValue).matches()) {
                this.setPrecision(TemporalPrecisionEnum.MONTH);
                this.clearTimeZone();
                return ourYearMonthNoDashesFormat.parse(theValue);
            }
            if (theValue.length() == 7 && ourYearDashMonthPattern.matcher(theValue).matches()) {
                this.setPrecision(TemporalPrecisionEnum.MONTH);
                this.clearTimeZone();
                return ourYearMonthFormat.parse(theValue);
            }
            if (theValue.length() == 8 && ourYearMonthDayPattern.matcher(theValue).matches()) {
                this.setPrecision(TemporalPrecisionEnum.DAY);
                this.clearTimeZone();
                return ourYearMonthDayNoDashesFormat.parse(theValue);
            }
            if (theValue.length() == 10 && ourYearDashMonthDashDayPattern.matcher(theValue).matches()) {
                this.setPrecision(TemporalPrecisionEnum.DAY);
                this.clearTimeZone();
                return ourYearMonthDayFormat.parse(theValue);
            }
            if (theValue.length() >= 16) {
                Date retVal;
                boolean hasMillis;
                int firstColonIndex = theValue.indexOf(58);
                if (firstColonIndex == -1) {
                    throw new IllegalArgumentException("Invalid date/time string: " + theValue);
                }
                boolean hasSeconds = theValue.length() > firstColonIndex + 3 ? theValue.charAt(firstColonIndex + 3) == ':' : false;
                int dotIndex = theValue.length() >= 18 ? theValue.indexOf(46, 18) : -1;
                boolean bl = hasMillis = dotIndex > -1;
                if (hasMillis) {
                    try {
                        retVal = this.hasOffset(theValue) ? ourYearMonthDayTimeMilliZoneFormat.parse(theValue) : (theValue.endsWith("Z") ? ourYearMonthDayTimeMilliUTCZFormat.parse(theValue) : ourYearMonthDayTimeMilliFormat.parse(theValue));
                    }
                    catch (ParseException p2) {
                        throw new IllegalArgumentException("Invalid data/time string (" + p2.getMessage() + "): " + theValue);
                    }
                    this.setTimeZone(theValue, hasMillis);
                    this.setPrecision(TemporalPrecisionEnum.MILLI);
                } else if (hasSeconds) {
                    try {
                        retVal = this.hasOffset(theValue) ? ourYearMonthDayTimeZoneFormat.parse(theValue) : (theValue.endsWith("Z") ? ourYearMonthDayTimeUTCZFormat.parse(theValue) : ourYearMonthDayTimeFormat.parse(theValue));
                    }
                    catch (ParseException p2) {
                        throw new IllegalArgumentException("Invalid data/time string (" + p2.getMessage() + "): " + theValue);
                    }
                    this.setTimeZone(theValue, hasMillis);
                    this.setPrecision(TemporalPrecisionEnum.SECOND);
                } else {
                    try {
                        retVal = this.hasOffset(theValue) ? ourYearMonthDayTimeMinsZoneFormat.parse(theValue) : (theValue.endsWith("Z") ? ourYearMonthDayTimeMinsUTCZFormat.parse(theValue) : ourYearMonthDayTimeMinsFormat.parse(theValue));
                    }
                    catch (ParseException p2) {
                        throw new IllegalArgumentException("Invalid data/time string (" + p2.getMessage() + "): " + theValue, p2);
                    }
                    this.setTimeZone(theValue, hasMillis);
                    this.setPrecision(TemporalPrecisionEnum.MINUTE);
                }
                return retVal;
            }
            throw new IllegalArgumentException("Invalid date/time string (invalid length): " + theValue);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid date string (" + e.getMessage() + "): " + theValue);
        }
    }

    public void setPrecision(TemporalPrecisionEnum thePrecision) throws IllegalArgumentException {
        if (thePrecision == null) {
            throw new NullPointerException("Precision may not be null");
        }
        this.myPrecision = thePrecision;
        this.updateStringValue();
    }

    private void setTimeZone(String theValueString, boolean hasMillis) {
        this.clearTimeZone();
        int timeZoneStart = 19;
        if (hasMillis) {
            timeZoneStart += 4;
        }
        if (theValueString.endsWith("Z")) {
            this.setTimeZoneZulu(true);
        } else if (theValueString.indexOf("GMT", timeZoneStart) != -1) {
            this.setTimeZone(this.getTimeZone(theValueString.substring(timeZoneStart)));
        } else if (theValueString.indexOf(43, timeZoneStart) != -1 || theValueString.indexOf(45, timeZoneStart) != -1) {
            this.setTimeZone(this.getTimeZone("GMT" + theValueString.substring(timeZoneStart)));
        }
    }

    public void setTimeZone(TimeZone theTimeZone) {
        this.myTimeZone = theTimeZone;
        this.updateStringValue();
    }

    public void setTimeZoneZulu(boolean theTimeZoneZulu) {
        this.myTimeZoneZulu = theTimeZoneZulu;
        this.updateStringValue();
    }

    public BaseDateTimeType setValue(Date theValue) {
        if (!this.myTimeZoneZulu && this.myTimeZone == null) {
            this.myTimeZone = TimeZone.getDefault();
        }
        this.myPrecision = this.getDefaultPrecisionForDatatype();
        BaseDateTimeType retVal = (BaseDateTimeType)super.setValue(theValue);
        return retVal;
    }

    public void setValue(Date theValue, TemporalPrecisionEnum thePrecision) throws IllegalArgumentException {
        if (!this.myTimeZoneZulu && this.myTimeZone == null) {
            this.myTimeZone = TimeZone.getDefault();
        }
        this.myPrecision = thePrecision;
        super.setValue(theValue);
    }

    @Override
    public void setValueAsString(String theString) throws IllegalArgumentException {
        this.clearTimeZone();
        super.setValueAsString(theString);
    }

    static List<FastDateFormat> getFormatters() {
        return ourFormatters;
    }

    public boolean before(DateTimeType theDateTimeType) {
        return ((Date)this.getValue()).before((Date)theDateTimeType.getValue());
    }

    public boolean after(DateTimeType theDateTimeType) {
        return ((Date)this.getValue()).after((Date)theDateTimeType.getValue());
    }

    public String toHumanDisplay() {
        return DateTimeUtil.toHumanDisplay((TimeZone)this.getTimeZone(), (TemporalPrecisionEnum)this.getPrecision(), (Date)((Date)this.getValue()), (String)this.getValueAsString());
    }

    public String toHumanDisplayLocalTimezone() {
        return DateTimeUtil.toHumanDisplayLocalTimezone((TemporalPrecisionEnum)this.getPrecision(), (Date)((Date)this.getValue()), (String)this.getValueAsString());
    }

    public Calendar toCalendar() {
        Calendar retVal = Calendar.getInstance();
        retVal.setTime((Date)this.getValue());
        retVal.setTimeZone(this.getTimeZone());
        return retVal;
    }

    public void setOffsetMinutes(int theZoneOffsetMinutes) {
        int offsetAbs = Math.abs(theZoneOffsetMinutes);
        int mins = offsetAbs % 60;
        int hours = offsetAbs / 60;
        if (theZoneOffsetMinutes < 0) {
            this.setTimeZone(this.getTimeZone("GMT-" + hours + ":" + mins));
        } else {
            this.setTimeZone(this.getTimeZone("GMT+" + hours + ":" + mins));
        }
    }

    public long getTime() {
        return ((Date)this.getValue()).getTime();
    }

    public void add(int theField, int theValue) {
        switch (theField) {
            case 1: {
                this.setValue(DateUtils.addYears((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            case 2: {
                this.setValue(DateUtils.addMonths((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            case 5: {
                this.setValue(DateUtils.addDays((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            case 10: {
                this.setValue(DateUtils.addHours((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            case 12: {
                this.setValue(DateUtils.addMinutes((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            case 13: {
                this.setValue(DateUtils.addSeconds((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            case 14: {
                this.setValue(DateUtils.addMilliseconds((Date)((Date)this.getValue()), (int)theValue), this.getPrecision());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown field constant: " + theField);
            }
        }
    }

    protected void setValueAsV3String(String theV3String) {
        if (StringUtils.isBlank((CharSequence)theV3String)) {
            this.setValue(null);
        } else {
            StringBuilder b = new StringBuilder();
            String timeZone = null;
            for (int i = 0; i < theV3String.length(); ++i) {
                char nextChar = theV3String.charAt(i);
                if (nextChar == '+' || nextChar == '-' || nextChar == 'Z') {
                    timeZone = theV3String.substring(i);
                    break;
                }
                if (i == 4 || i == 6) {
                    b.append('-');
                } else if (i == 8) {
                    b.append('T');
                } else if (i == 10 || i == 12) {
                    b.append(':');
                }
                b.append(nextChar);
            }
            if (b.length() == 16) {
                b.append(":00");
            }
            if (timeZone != null && b.length() > 10) {
                if (timeZone.length() == 5) {
                    b.append(timeZone.substring(0, 3));
                    b.append(':');
                    b.append(timeZone.substring(3));
                } else {
                    b.append(timeZone);
                }
            }
            this.setValueAsString(b.toString());
        }
    }

    private TimeZone getTimeZone(String offset) {
        return timezoneCache.computeIfAbsent(offset, TimeZone::getTimeZone);
    }

    static {
        ourYearDashMonthDashDayPattern = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
        ourYearDashMonthPattern = Pattern.compile("[0-9]{4}-[0-9]{2}");
        ourYearFormat = FastDateFormat.getInstance((String)"yyyy");
        ourYearMonthDayFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd");
        ourYearMonthDayNoDashesFormat = FastDateFormat.getInstance((String)"yyyyMMdd");
        ourYearMonthDayPattern = Pattern.compile("[0-9]{4}[0-9]{2}[0-9]{2}");
        ourYearMonthDayTimeFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss");
        ourYearMonthDayTimeMilliFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
        ourYearMonthDayTimeMilliUTCZFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (TimeZone)TimeZone.getTimeZone("UTC"));
        ourYearMonthDayTimeMilliZoneFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
        ourYearMonthDayTimeUTCZFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (TimeZone)TimeZone.getTimeZone("UTC"));
        ourYearMonthDayTimeZoneFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssZZ");
        ourYearMonthFormat = FastDateFormat.getInstance((String)"yyyy-MM");
        ourYearMonthNoDashesFormat = FastDateFormat.getInstance((String)"yyyyMM");
        ourYearMonthPattern = Pattern.compile("[0-9]{4}[0-9]{2}");
        ourYearPattern = Pattern.compile("[0-9]{4}");
        ourYearMonthDayTimeMinsFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm");
        ourYearMonthDayTimeMinsUTCZFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm'Z'", (TimeZone)TimeZone.getTimeZone("UTC"));
        ourYearMonthDayTimeMinsZoneFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mmZZ");
        ourHumanDateTimeFormat = FastDateFormat.getDateTimeInstance((int)2, (int)2);
        ourHumanDateFormat = FastDateFormat.getDateInstance((int)2);
        timezoneCache = new ConcurrentHashMap<String, TimeZone>();
        ArrayList<FastDateFormat> formatters = new ArrayList<FastDateFormat>();
        formatters.add(ourYearFormat);
        formatters.add(ourYearMonthDayFormat);
        formatters.add(ourYearMonthDayNoDashesFormat);
        formatters.add(ourYearMonthDayTimeFormat);
        formatters.add(ourYearMonthDayTimeUTCZFormat);
        formatters.add(ourYearMonthDayTimeZoneFormat);
        formatters.add(ourYearMonthDayTimeMilliFormat);
        formatters.add(ourYearMonthDayTimeMilliUTCZFormat);
        formatters.add(ourYearMonthDayTimeMilliZoneFormat);
        formatters.add(ourYearMonthDayTimeMinsFormat);
        formatters.add(ourYearMonthDayTimeMinsUTCZFormat);
        formatters.add(ourYearMonthDayTimeMinsZoneFormat);
        formatters.add(ourYearMonthFormat);
        formatters.add(ourYearMonthNoDashesFormat);
        ourFormatters = Collections.unmodifiableList(formatters);
    }
}

