/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2.model.Attachment;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="BodySite", profile="http://hl7.org/fhir/Profile/BodySite")
public class BodySite
extends DomainResource {
    @Child(name="patient", type={Patient.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient", formalDefinition="The person to which the body site belongs.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Bodysite identifier", formalDefinition="Identifier for this instance of the anatomical location.")
    protected List<Identifier> identifier;
    @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Named anatomical location", formalDefinition="Named anatomical location - ideally coded where possible.")
    protected CodeableConcept code;
    @Child(name="modifier", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Modification to location code", formalDefinition="Modifier to refine the anatomical location.  These include modifiers for laterality, relative location, directionality, number, and plane.")
    protected List<CodeableConcept> modifier;
    @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The Description of anatomical location", formalDefinition="Description of anatomical location.")
    protected StringType description;
    @Child(name="image", type={Attachment.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Attached images", formalDefinition="Image or images used to identify a location.")
    protected List<Attachment> image;
    private static final long serialVersionUID = 1568109920L;
    @SearchParamDefinition(name="identifier", path="BodySite.identifier", description="Identifier for this instance of the anatomical location", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="code", path="BodySite.code", description="Named anatomical location", type="token")
    public static final String SP_CODE = "code";
    @SearchParamDefinition(name="patient", path="BodySite.patient", description="Patient to whom bodysite belongs", type="reference")
    public static final String SP_PATIENT = "patient";

    public BodySite() {
    }

    public BodySite(Reference patient) {
        this.patient = patient;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodySite.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public BodySite setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodySite.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public BodySite setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public BodySite addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodySite.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public BodySite setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public List<CodeableConcept> getModifier() {
        if (this.modifier == null) {
            this.modifier = new ArrayList<CodeableConcept>();
        }
        return this.modifier;
    }

    public boolean hasModifier() {
        if (this.modifier == null) {
            return false;
        }
        for (CodeableConcept item : this.modifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addModifier() {
        CodeableConcept t = new CodeableConcept();
        if (this.modifier == null) {
            this.modifier = new ArrayList<CodeableConcept>();
        }
        this.modifier.add(t);
        return t;
    }

    public BodySite addModifier(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.modifier == null) {
            this.modifier = new ArrayList<CodeableConcept>();
        }
        this.modifier.add(t);
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodySite.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public BodySite setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public BodySite setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Attachment> getImage() {
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        return this.image;
    }

    public boolean hasImage() {
        if (this.image == null) {
            return false;
        }
        for (Attachment item : this.image) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addImage() {
        Attachment t = new Attachment();
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        this.image.add(t);
        return t;
    }

    public BodySite addImage(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        this.image.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The person to which the body site belongs.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for this instance of the anatomical location.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_CODE, "CodeableConcept", "Named anatomical location - ideally coded where possible.", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property("modifier", "CodeableConcept", "Modifier to refine the anatomical location.  These include modifiers for laterality, relative location, directionality, number, and plane.", 0, Integer.MAX_VALUE, this.modifier));
        childrenList.add(new Property("description", "string", "Description of anatomical location.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("image", "Attachment", "Image or images used to identify a location.", 0, Integer.MAX_VALUE, this.image));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("modifier")) {
            this.getModifier().add(this.castToCodeableConcept(value));
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("image")) {
            this.getImage().add(this.castToAttachment(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("modifier")) {
            return this.addModifier();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property BodySite.description");
        }
        if (name.equals("image")) {
            return this.addImage();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "BodySite";
    }

    @Override
    public BodySite copy() {
        BodySite dst = new BodySite();
        this.copyValues(dst);
        Reference reference = dst.patient = this.patient == null ? null : this.patient.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
        if (this.modifier != null) {
            dst.modifier = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.modifier) {
                dst.modifier.add(codeableConcept2.copy());
            }
        }
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.image != null) {
            dst.image = new ArrayList<Attachment>();
            for (Attachment attachment : this.image) {
                dst.image.add(attachment.copy());
            }
        }
        return dst;
    }

    protected BodySite typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof BodySite)) {
            return false;
        }
        BodySite o = (BodySite)other;
        return BodySite.compareDeep(this.patient, o.patient, true) && BodySite.compareDeep(this.identifier, o.identifier, true) && BodySite.compareDeep(this.code, o.code, true) && BodySite.compareDeep(this.modifier, o.modifier, true) && BodySite.compareDeep(this.description, o.description, true) && BodySite.compareDeep(this.image, o.image, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof BodySite)) {
            return false;
        }
        BodySite o = (BodySite)other;
        return BodySite.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.code != null && !this.code.isEmpty() || this.modifier != null && !this.modifier.isEmpty() || this.description != null && !this.description.isEmpty() || this.image != null && !this.image.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.BodySite;
    }
}

