/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.ClaimResponse;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.Coverage;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DateType;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.MedicationOrder;
import org.hl7.fhir.dstu2.model.Money;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.PositiveIntType;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ReferralRequest;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.VisionPrescription;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Claim", profile="http://hl7.org/fhir/Profile/Claim")
public class Claim
extends DomainResource {
    @Child(name="type", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="institutional | oral | pharmacy | professional | vision", formalDefinition="The category of claim this is.")
    protected Enumeration<ClaimType> type;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Claim number", formalDefinition="The business identifier for the instance: invoice number, claim number, pre-determination or pre-authorization number.")
    protected List<Identifier> identifier;
    @Child(name="ruleset", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Current specification followed", formalDefinition="The version of the specification on which this instance relies.")
    protected Coding ruleset;
    @Child(name="originalRuleset", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Original specification followed", formalDefinition="The version of the specification from which the original instance was created.")
    protected Coding originalRuleset;
    @Child(name="created", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the enclosed suite of services were performed or completed.")
    protected DateTimeType created;
    @Child(name="target", type={Organization.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer", formalDefinition="Insurer Identifier, typical BIN number (6 digit).")
    protected Reference target;
    protected Organization targetTarget;
    @Child(name="provider", type={Practitioner.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible provider", formalDefinition="The provider which is responsible for the bill, claim pre-determination, pre-authorization.")
    protected Reference provider;
    protected Practitioner providerTarget;
    @Child(name="organization", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the bill, claim pre-determination, pre-authorization.")
    protected Reference organization;
    protected Organization organizationTarget;
    @Child(name="use", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="complete | proposed | exploratory | other", formalDefinition="Complete (Bill or Claim), Proposed (Pre-Authorization), Exploratory (Pre-determination).")
    protected Enumeration<Use> use;
    @Child(name="priority", type={Coding.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Desired processing priority", formalDefinition="Immediate (stat), best effort (normal), deferred (deferred).")
    protected Coding priority;
    @Child(name="fundsReserve", type={Coding.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Funds requested to be reserved", formalDefinition="In the case of a Pre-Determination/Pre-Authorization the provider may request that funds in the amount of the expected Benefit be reserved ('Patient' or 'Provider') to pay for the Benefits determined on the subsequent claim(s). 'None' explicitly indicates no funds reserving is requested.")
    protected Coding fundsReserve;
    @Child(name="enterer", type={Practitioner.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Author", formalDefinition="Person who created the invoice/claim/pre-determination or pre-authorization.")
    protected Reference enterer;
    protected Practitioner entererTarget;
    @Child(name="facility", type={Location.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Servicing Facility", formalDefinition="Facility where the services were provided.")
    protected Reference facility;
    protected Location facilityTarget;
    @Child(name="prescription", type={MedicationOrder.class, VisionPrescription.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Prescription", formalDefinition="Prescription to support the dispensing of Pharmacy or Vision products.")
    protected Reference prescription;
    protected Resource prescriptionTarget;
    @Child(name="originalPrescription", type={MedicationOrder.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Original Prescription", formalDefinition="Original prescription to support the dispensing of pharmacy services, medications or products.")
    protected Reference originalPrescription;
    protected MedicationOrder originalPrescriptionTarget;
    @Child(name="payee", type={}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Payee", formalDefinition="The party to be reimbursed for the services.")
    protected PayeeComponent payee;
    @Child(name="referral", type={ReferralRequest.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Treatment Referral", formalDefinition="The referral resource which lists the date, practitioner, reason and other supporting information.")
    protected Reference referral;
    protected ReferralRequest referralTarget;
    @Child(name="diagnosis", type={}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Diagnosis", formalDefinition="Ordered list of patient diagnosis for which care is sought.")
    protected List<DiagnosisComponent> diagnosis;
    @Child(name="condition", type={Coding.class}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="List of presenting Conditions", formalDefinition="List of patient conditions for which care is sought.")
    protected List<Coding> condition;
    @Child(name="patient", type={Patient.class}, order=19, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The subject of the Products and Services", formalDefinition="Patient Resource.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="coverage", type={}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Insurance or medical plan", formalDefinition="Financial instrument by which payment information for health care.")
    protected List<CoverageComponent> coverage;
    @Child(name="exception", type={Coding.class}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Eligibility exceptions", formalDefinition="Factors which may influence the applicability of coverage.")
    protected List<Coding> exception;
    @Child(name="school", type={StringType.class}, order=22, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of School", formalDefinition="Name of school for over-aged dependents.")
    protected StringType school;
    @Child(name="accident", type={DateType.class}, order=23, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Accident Date", formalDefinition="Date of an accident which these services are addressing.")
    protected DateType accident;
    @Child(name="accidentType", type={Coding.class}, order=24, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Accident Type", formalDefinition="Type of accident: work, auto, etc.")
    protected Coding accidentType;
    @Child(name="interventionException", type={Coding.class}, order=25, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intervention and exception code (Pharma)", formalDefinition="A list of intervention and exception codes which may influence the adjudication of the claim.")
    protected List<Coding> interventionException;
    @Child(name="item", type={}, order=26, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Goods and Services", formalDefinition="First tier of goods and services.")
    protected List<ItemsComponent> item;
    @Child(name="additionalMaterials", type={Coding.class}, order=27, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional materials, documents, etc.", formalDefinition="Code to indicate that Xrays, images, emails, documents, models or attachments are being sent in support of this submission.")
    protected List<Coding> additionalMaterials;
    @Child(name="missingTeeth", type={}, order=28, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Only if type = oral", formalDefinition="A list of teeth which would be expected but are not found due to having been previously  extracted or for other reasons.")
    protected List<MissingTeethComponent> missingTeeth;
    private static final long serialVersionUID = 4272227L;
    @SearchParamDefinition(name="identifier", path="Claim.identifier", description="The primary identifier of the financial resource", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="provider", path="Claim.provider", description="Provider responsible for the claim", type="reference")
    public static final String SP_PROVIDER = "provider";
    @SearchParamDefinition(name="use", path="Claim.use", description="The kind of financial resource", type="token")
    public static final String SP_USE = "use";
    @SearchParamDefinition(name="patient", path="Claim.patient", description="Patient", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="priority", path="Claim.priority", description="Processing priority requested", type="token")
    public static final String SP_PRIORITY = "priority";

    public Claim() {
    }

    public Claim(Enumeration<ClaimType> type, Reference patient) {
        this.type = type;
        this.patient = patient;
    }

    public Enumeration<ClaimType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<ClaimType>(new ClaimTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Claim setTypeElement(Enumeration<ClaimType> value) {
        this.type = value;
        return this;
    }

    public ClaimType getType() {
        return this.type == null ? null : (ClaimType)((Object)this.type.getValue());
    }

    public Claim setType(ClaimType value) {
        if (this.type == null) {
            this.type = new Enumeration<ClaimType>(new ClaimTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Claim addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Coding getRuleset() {
        if (this.ruleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.ruleset");
            }
            if (Configuration.doAutoCreate()) {
                this.ruleset = new Coding();
            }
        }
        return this.ruleset;
    }

    public boolean hasRuleset() {
        return this.ruleset != null && !this.ruleset.isEmpty();
    }

    public Claim setRuleset(Coding value) {
        this.ruleset = value;
        return this;
    }

    public Coding getOriginalRuleset() {
        if (this.originalRuleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.originalRuleset");
            }
            if (Configuration.doAutoCreate()) {
                this.originalRuleset = new Coding();
            }
        }
        return this.originalRuleset;
    }

    public boolean hasOriginalRuleset() {
        return this.originalRuleset != null && !this.originalRuleset.isEmpty();
    }

    public Claim setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public Claim setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public Claim setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getTarget() {
        if (this.target == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.target");
            }
            if (Configuration.doAutoCreate()) {
                this.target = new Reference();
            }
        }
        return this.target;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public Claim setTarget(Reference value) {
        this.target = value;
        return this;
    }

    public Organization getTargetTarget() {
        if (this.targetTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.target");
            }
            if (Configuration.doAutoCreate()) {
                this.targetTarget = new Organization();
            }
        }
        return this.targetTarget;
    }

    public Claim setTargetTarget(Organization value) {
        this.targetTarget = value;
        return this;
    }

    public Reference getProvider() {
        if (this.provider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.provider = new Reference();
            }
        }
        return this.provider;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public Claim setProvider(Reference value) {
        this.provider = value;
        return this;
    }

    public Practitioner getProviderTarget() {
        if (this.providerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.providerTarget = new Practitioner();
            }
        }
        return this.providerTarget;
    }

    public Claim setProviderTarget(Practitioner value) {
        this.providerTarget = value;
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public Claim setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Organization getOrganizationTarget() {
        if (this.organizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organizationTarget = new Organization();
            }
        }
        return this.organizationTarget;
    }

    public Claim setOrganizationTarget(Organization value) {
        this.organizationTarget = value;
        return this;
    }

    public Enumeration<Use> getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new Enumeration<Use>(new UseEnumFactory());
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public Claim setUseElement(Enumeration<Use> value) {
        this.use = value;
        return this;
    }

    public Use getUse() {
        return this.use == null ? null : (Use)((Object)this.use.getValue());
    }

    public Claim setUse(Use value) {
        if (value == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration<Use>(new UseEnumFactory());
            }
            this.use.setValue((Object)value);
        }
        return this;
    }

    public Coding getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Coding();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Claim setPriority(Coding value) {
        this.priority = value;
        return this;
    }

    public Coding getFundsReserve() {
        if (this.fundsReserve == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.fundsReserve");
            }
            if (Configuration.doAutoCreate()) {
                this.fundsReserve = new Coding();
            }
        }
        return this.fundsReserve;
    }

    public boolean hasFundsReserve() {
        return this.fundsReserve != null && !this.fundsReserve.isEmpty();
    }

    public Claim setFundsReserve(Coding value) {
        this.fundsReserve = value;
        return this;
    }

    public Reference getEnterer() {
        if (this.enterer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.enterer = new Reference();
            }
        }
        return this.enterer;
    }

    public boolean hasEnterer() {
        return this.enterer != null && !this.enterer.isEmpty();
    }

    public Claim setEnterer(Reference value) {
        this.enterer = value;
        return this;
    }

    public Practitioner getEntererTarget() {
        if (this.entererTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.entererTarget = new Practitioner();
            }
        }
        return this.entererTarget;
    }

    public Claim setEntererTarget(Practitioner value) {
        this.entererTarget = value;
        return this;
    }

    public Reference getFacility() {
        if (this.facility == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.facility");
            }
            if (Configuration.doAutoCreate()) {
                this.facility = new Reference();
            }
        }
        return this.facility;
    }

    public boolean hasFacility() {
        return this.facility != null && !this.facility.isEmpty();
    }

    public Claim setFacility(Reference value) {
        this.facility = value;
        return this;
    }

    public Location getFacilityTarget() {
        if (this.facilityTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.facility");
            }
            if (Configuration.doAutoCreate()) {
                this.facilityTarget = new Location();
            }
        }
        return this.facilityTarget;
    }

    public Claim setFacilityTarget(Location value) {
        this.facilityTarget = value;
        return this;
    }

    public Reference getPrescription() {
        if (this.prescription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.prescription");
            }
            if (Configuration.doAutoCreate()) {
                this.prescription = new Reference();
            }
        }
        return this.prescription;
    }

    public boolean hasPrescription() {
        return this.prescription != null && !this.prescription.isEmpty();
    }

    public Claim setPrescription(Reference value) {
        this.prescription = value;
        return this;
    }

    public Resource getPrescriptionTarget() {
        return this.prescriptionTarget;
    }

    public Claim setPrescriptionTarget(Resource value) {
        this.prescriptionTarget = value;
        return this;
    }

    public Reference getOriginalPrescription() {
        if (this.originalPrescription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.originalPrescription");
            }
            if (Configuration.doAutoCreate()) {
                this.originalPrescription = new Reference();
            }
        }
        return this.originalPrescription;
    }

    public boolean hasOriginalPrescription() {
        return this.originalPrescription != null && !this.originalPrescription.isEmpty();
    }

    public Claim setOriginalPrescription(Reference value) {
        this.originalPrescription = value;
        return this;
    }

    public MedicationOrder getOriginalPrescriptionTarget() {
        if (this.originalPrescriptionTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.originalPrescription");
            }
            if (Configuration.doAutoCreate()) {
                this.originalPrescriptionTarget = new MedicationOrder();
            }
        }
        return this.originalPrescriptionTarget;
    }

    public Claim setOriginalPrescriptionTarget(MedicationOrder value) {
        this.originalPrescriptionTarget = value;
        return this;
    }

    public PayeeComponent getPayee() {
        if (this.payee == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.payee");
            }
            if (Configuration.doAutoCreate()) {
                this.payee = new PayeeComponent();
            }
        }
        return this.payee;
    }

    public boolean hasPayee() {
        return this.payee != null && !this.payee.isEmpty();
    }

    public Claim setPayee(PayeeComponent value) {
        this.payee = value;
        return this;
    }

    public Reference getReferral() {
        if (this.referral == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.referral");
            }
            if (Configuration.doAutoCreate()) {
                this.referral = new Reference();
            }
        }
        return this.referral;
    }

    public boolean hasReferral() {
        return this.referral != null && !this.referral.isEmpty();
    }

    public Claim setReferral(Reference value) {
        this.referral = value;
        return this;
    }

    public ReferralRequest getReferralTarget() {
        if (this.referralTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.referral");
            }
            if (Configuration.doAutoCreate()) {
                this.referralTarget = new ReferralRequest();
            }
        }
        return this.referralTarget;
    }

    public Claim setReferralTarget(ReferralRequest value) {
        this.referralTarget = value;
        return this;
    }

    public List<DiagnosisComponent> getDiagnosis() {
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        return this.diagnosis;
    }

    public boolean hasDiagnosis() {
        if (this.diagnosis == null) {
            return false;
        }
        for (DiagnosisComponent item : this.diagnosis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosisComponent addDiagnosis() {
        DiagnosisComponent t = new DiagnosisComponent();
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return t;
    }

    public Claim addDiagnosis(DiagnosisComponent t) {
        if (t == null) {
            return this;
        }
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return this;
    }

    public List<Coding> getCondition() {
        if (this.condition == null) {
            this.condition = new ArrayList<Coding>();
        }
        return this.condition;
    }

    public boolean hasCondition() {
        if (this.condition == null) {
            return false;
        }
        for (Coding item : this.condition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addCondition() {
        Coding t = new Coding();
        if (this.condition == null) {
            this.condition = new ArrayList<Coding>();
        }
        this.condition.add(t);
        return t;
    }

    public Claim addCondition(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.condition == null) {
            this.condition = new ArrayList<Coding>();
        }
        this.condition.add(t);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Claim setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public Claim setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public List<CoverageComponent> getCoverage() {
        if (this.coverage == null) {
            this.coverage = new ArrayList<CoverageComponent>();
        }
        return this.coverage;
    }

    public boolean hasCoverage() {
        if (this.coverage == null) {
            return false;
        }
        for (CoverageComponent item : this.coverage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CoverageComponent addCoverage() {
        CoverageComponent t = new CoverageComponent();
        if (this.coverage == null) {
            this.coverage = new ArrayList<CoverageComponent>();
        }
        this.coverage.add(t);
        return t;
    }

    public Claim addCoverage(CoverageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.coverage == null) {
            this.coverage = new ArrayList<CoverageComponent>();
        }
        this.coverage.add(t);
        return this;
    }

    public List<Coding> getException() {
        if (this.exception == null) {
            this.exception = new ArrayList<Coding>();
        }
        return this.exception;
    }

    public boolean hasException() {
        if (this.exception == null) {
            return false;
        }
        for (Coding item : this.exception) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addException() {
        Coding t = new Coding();
        if (this.exception == null) {
            this.exception = new ArrayList<Coding>();
        }
        this.exception.add(t);
        return t;
    }

    public Claim addException(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.exception == null) {
            this.exception = new ArrayList<Coding>();
        }
        this.exception.add(t);
        return this;
    }

    public StringType getSchoolElement() {
        if (this.school == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.school");
            }
            if (Configuration.doAutoCreate()) {
                this.school = new StringType();
            }
        }
        return this.school;
    }

    public boolean hasSchoolElement() {
        return this.school != null && !this.school.isEmpty();
    }

    public boolean hasSchool() {
        return this.school != null && !this.school.isEmpty();
    }

    public Claim setSchoolElement(StringType value) {
        this.school = value;
        return this;
    }

    public String getSchool() {
        return this.school == null ? null : (String)this.school.getValue();
    }

    public Claim setSchool(String value) {
        if (Utilities.noString((String)value)) {
            this.school = null;
        } else {
            if (this.school == null) {
                this.school = new StringType();
            }
            this.school.setValue(value);
        }
        return this;
    }

    public DateType getAccidentElement() {
        if (this.accident == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.accident");
            }
            if (Configuration.doAutoCreate()) {
                this.accident = new DateType();
            }
        }
        return this.accident;
    }

    public boolean hasAccidentElement() {
        return this.accident != null && !this.accident.isEmpty();
    }

    public boolean hasAccident() {
        return this.accident != null && !this.accident.isEmpty();
    }

    public Claim setAccidentElement(DateType value) {
        this.accident = value;
        return this;
    }

    public Date getAccident() {
        return this.accident == null ? null : (Date)this.accident.getValue();
    }

    public Claim setAccident(Date value) {
        if (value == null) {
            this.accident = null;
        } else {
            if (this.accident == null) {
                this.accident = new DateType();
            }
            this.accident.setValue(value);
        }
        return this;
    }

    public Coding getAccidentType() {
        if (this.accidentType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.accidentType");
            }
            if (Configuration.doAutoCreate()) {
                this.accidentType = new Coding();
            }
        }
        return this.accidentType;
    }

    public boolean hasAccidentType() {
        return this.accidentType != null && !this.accidentType.isEmpty();
    }

    public Claim setAccidentType(Coding value) {
        this.accidentType = value;
        return this;
    }

    public List<Coding> getInterventionException() {
        if (this.interventionException == null) {
            this.interventionException = new ArrayList<Coding>();
        }
        return this.interventionException;
    }

    public boolean hasInterventionException() {
        if (this.interventionException == null) {
            return false;
        }
        for (Coding item : this.interventionException) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addInterventionException() {
        Coding t = new Coding();
        if (this.interventionException == null) {
            this.interventionException = new ArrayList<Coding>();
        }
        this.interventionException.add(t);
        return t;
    }

    public Claim addInterventionException(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.interventionException == null) {
            this.interventionException = new ArrayList<Coding>();
        }
        this.interventionException.add(t);
        return this;
    }

    public List<ItemsComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ItemsComponent>();
        }
        return this.item;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (ItemsComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ItemsComponent addItem() {
        ItemsComponent t = new ItemsComponent();
        if (this.item == null) {
            this.item = new ArrayList<ItemsComponent>();
        }
        this.item.add(t);
        return t;
    }

    public Claim addItem(ItemsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<ItemsComponent>();
        }
        this.item.add(t);
        return this;
    }

    public List<Coding> getAdditionalMaterials() {
        if (this.additionalMaterials == null) {
            this.additionalMaterials = new ArrayList<Coding>();
        }
        return this.additionalMaterials;
    }

    public boolean hasAdditionalMaterials() {
        if (this.additionalMaterials == null) {
            return false;
        }
        for (Coding item : this.additionalMaterials) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addAdditionalMaterials() {
        Coding t = new Coding();
        if (this.additionalMaterials == null) {
            this.additionalMaterials = new ArrayList<Coding>();
        }
        this.additionalMaterials.add(t);
        return t;
    }

    public Claim addAdditionalMaterials(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.additionalMaterials == null) {
            this.additionalMaterials = new ArrayList<Coding>();
        }
        this.additionalMaterials.add(t);
        return this;
    }

    public List<MissingTeethComponent> getMissingTeeth() {
        if (this.missingTeeth == null) {
            this.missingTeeth = new ArrayList<MissingTeethComponent>();
        }
        return this.missingTeeth;
    }

    public boolean hasMissingTeeth() {
        if (this.missingTeeth == null) {
            return false;
        }
        for (MissingTeethComponent item : this.missingTeeth) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MissingTeethComponent addMissingTeeth() {
        MissingTeethComponent t = new MissingTeethComponent();
        if (this.missingTeeth == null) {
            this.missingTeeth = new ArrayList<MissingTeethComponent>();
        }
        this.missingTeeth.add(t);
        return t;
    }

    public Claim addMissingTeeth(MissingTeethComponent t) {
        if (t == null) {
            return this;
        }
        if (this.missingTeeth == null) {
            this.missingTeeth = new ArrayList<MissingTeethComponent>();
        }
        this.missingTeeth.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("type", "code", "The category of claim this is.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The business identifier for the instance: invoice number, claim number, pre-determination or pre-authorization number.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("ruleset", "Coding", "The version of the specification on which this instance relies.", 0, Integer.MAX_VALUE, this.ruleset));
        childrenList.add(new Property("originalRuleset", "Coding", "The version of the specification from which the original instance was created.", 0, Integer.MAX_VALUE, this.originalRuleset));
        childrenList.add(new Property("created", "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property("target", "Reference(Organization)", "Insurer Identifier, typical BIN number (6 digit).", 0, Integer.MAX_VALUE, this.target));
        childrenList.add(new Property(SP_PROVIDER, "Reference(Practitioner)", "The provider which is responsible for the bill, claim pre-determination, pre-authorization.", 0, Integer.MAX_VALUE, this.provider));
        childrenList.add(new Property("organization", "Reference(Organization)", "The organization which is responsible for the bill, claim pre-determination, pre-authorization.", 0, Integer.MAX_VALUE, this.organization));
        childrenList.add(new Property(SP_USE, "code", "Complete (Bill or Claim), Proposed (Pre-Authorization), Exploratory (Pre-determination).", 0, Integer.MAX_VALUE, this.use));
        childrenList.add(new Property(SP_PRIORITY, "Coding", "Immediate (stat), best effort (normal), deferred (deferred).", 0, Integer.MAX_VALUE, this.priority));
        childrenList.add(new Property("fundsReserve", "Coding", "In the case of a Pre-Determination/Pre-Authorization the provider may request that funds in the amount of the expected Benefit be reserved ('Patient' or 'Provider') to pay for the Benefits determined on the subsequent claim(s). 'None' explicitly indicates no funds reserving is requested.", 0, Integer.MAX_VALUE, this.fundsReserve));
        childrenList.add(new Property("enterer", "Reference(Practitioner)", "Person who created the invoice/claim/pre-determination or pre-authorization.", 0, Integer.MAX_VALUE, this.enterer));
        childrenList.add(new Property("facility", "Reference(Location)", "Facility where the services were provided.", 0, Integer.MAX_VALUE, this.facility));
        childrenList.add(new Property("prescription", "Reference(MedicationOrder|VisionPrescription)", "Prescription to support the dispensing of Pharmacy or Vision products.", 0, Integer.MAX_VALUE, this.prescription));
        childrenList.add(new Property("originalPrescription", "Reference(MedicationOrder)", "Original prescription to support the dispensing of pharmacy services, medications or products.", 0, Integer.MAX_VALUE, this.originalPrescription));
        childrenList.add(new Property("payee", "", "The party to be reimbursed for the services.", 0, Integer.MAX_VALUE, this.payee));
        childrenList.add(new Property("referral", "Reference(ReferralRequest)", "The referral resource which lists the date, practitioner, reason and other supporting information.", 0, Integer.MAX_VALUE, this.referral));
        childrenList.add(new Property("diagnosis", "", "Ordered list of patient diagnosis for which care is sought.", 0, Integer.MAX_VALUE, this.diagnosis));
        childrenList.add(new Property("condition", "Coding", "List of patient conditions for which care is sought.", 0, Integer.MAX_VALUE, this.condition));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "Patient Resource.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("coverage", "", "Financial instrument by which payment information for health care.", 0, Integer.MAX_VALUE, this.coverage));
        childrenList.add(new Property("exception", "Coding", "Factors which may influence the applicability of coverage.", 0, Integer.MAX_VALUE, this.exception));
        childrenList.add(new Property("school", "string", "Name of school for over-aged dependents.", 0, Integer.MAX_VALUE, this.school));
        childrenList.add(new Property("accident", "date", "Date of an accident which these services are addressing.", 0, Integer.MAX_VALUE, this.accident));
        childrenList.add(new Property("accidentType", "Coding", "Type of accident: work, auto, etc.", 0, Integer.MAX_VALUE, this.accidentType));
        childrenList.add(new Property("interventionException", "Coding", "A list of intervention and exception codes which may influence the adjudication of the claim.", 0, Integer.MAX_VALUE, this.interventionException));
        childrenList.add(new Property("item", "", "First tier of goods and services.", 0, Integer.MAX_VALUE, this.item));
        childrenList.add(new Property("additionalMaterials", "Coding", "Code to indicate that Xrays, images, emails, documents, models or attachments are being sent in support of this submission.", 0, Integer.MAX_VALUE, this.additionalMaterials));
        childrenList.add(new Property("missingTeeth", "", "A list of teeth which would be expected but are not found due to having been previously  extracted or for other reasons.", 0, Integer.MAX_VALUE, this.missingTeeth));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            this.type = new ClaimTypeEnumFactory().fromType(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("ruleset")) {
            this.ruleset = this.castToCoding(value);
        } else if (name.equals("originalRuleset")) {
            this.originalRuleset = this.castToCoding(value);
        } else if (name.equals("created")) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("target")) {
            this.target = this.castToReference(value);
        } else if (name.equals(SP_PROVIDER)) {
            this.provider = this.castToReference(value);
        } else if (name.equals("organization")) {
            this.organization = this.castToReference(value);
        } else if (name.equals(SP_USE)) {
            this.use = new UseEnumFactory().fromType(value);
        } else if (name.equals(SP_PRIORITY)) {
            this.priority = this.castToCoding(value);
        } else if (name.equals("fundsReserve")) {
            this.fundsReserve = this.castToCoding(value);
        } else if (name.equals("enterer")) {
            this.enterer = this.castToReference(value);
        } else if (name.equals("facility")) {
            this.facility = this.castToReference(value);
        } else if (name.equals("prescription")) {
            this.prescription = this.castToReference(value);
        } else if (name.equals("originalPrescription")) {
            this.originalPrescription = this.castToReference(value);
        } else if (name.equals("payee")) {
            this.payee = (PayeeComponent)value;
        } else if (name.equals("referral")) {
            this.referral = this.castToReference(value);
        } else if (name.equals("diagnosis")) {
            this.getDiagnosis().add((DiagnosisComponent)value);
        } else if (name.equals("condition")) {
            this.getCondition().add(this.castToCoding(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("coverage")) {
            this.getCoverage().add((CoverageComponent)value);
        } else if (name.equals("exception")) {
            this.getException().add(this.castToCoding(value));
        } else if (name.equals("school")) {
            this.school = this.castToString(value);
        } else if (name.equals("accident")) {
            this.accident = this.castToDate(value);
        } else if (name.equals("accidentType")) {
            this.accidentType = this.castToCoding(value);
        } else if (name.equals("interventionException")) {
            this.getInterventionException().add(this.castToCoding(value));
        } else if (name.equals("item")) {
            this.getItem().add((ItemsComponent)value);
        } else if (name.equals("additionalMaterials")) {
            this.getAdditionalMaterials().add(this.castToCoding(value));
        } else if (name.equals("missingTeeth")) {
            this.getMissingTeeth().add((MissingTeethComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a singleton property Claim.type");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("ruleset")) {
            this.ruleset = new Coding();
            return this.ruleset;
        }
        if (name.equals("originalRuleset")) {
            this.originalRuleset = new Coding();
            return this.originalRuleset;
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a singleton property Claim.created");
        }
        if (name.equals("target")) {
            this.target = new Reference();
            return this.target;
        }
        if (name.equals(SP_PROVIDER)) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals("organization")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals(SP_USE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Claim.use");
        }
        if (name.equals(SP_PRIORITY)) {
            this.priority = new Coding();
            return this.priority;
        }
        if (name.equals("fundsReserve")) {
            this.fundsReserve = new Coding();
            return this.fundsReserve;
        }
        if (name.equals("enterer")) {
            this.enterer = new Reference();
            return this.enterer;
        }
        if (name.equals("facility")) {
            this.facility = new Reference();
            return this.facility;
        }
        if (name.equals("prescription")) {
            this.prescription = new Reference();
            return this.prescription;
        }
        if (name.equals("originalPrescription")) {
            this.originalPrescription = new Reference();
            return this.originalPrescription;
        }
        if (name.equals("payee")) {
            this.payee = new PayeeComponent();
            return this.payee;
        }
        if (name.equals("referral")) {
            this.referral = new Reference();
            return this.referral;
        }
        if (name.equals("diagnosis")) {
            return this.addDiagnosis();
        }
        if (name.equals("condition")) {
            return this.addCondition();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("coverage")) {
            return this.addCoverage();
        }
        if (name.equals("exception")) {
            return this.addException();
        }
        if (name.equals("school")) {
            throw new FHIRException("Cannot call addChild on a singleton property Claim.school");
        }
        if (name.equals("accident")) {
            throw new FHIRException("Cannot call addChild on a singleton property Claim.accident");
        }
        if (name.equals("accidentType")) {
            this.accidentType = new Coding();
            return this.accidentType;
        }
        if (name.equals("interventionException")) {
            return this.addInterventionException();
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        if (name.equals("additionalMaterials")) {
            return this.addAdditionalMaterials();
        }
        if (name.equals("missingTeeth")) {
            return this.addMissingTeeth();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Claim";
    }

    @Override
    public Claim copy() {
        Claim dst = new Claim();
        this.copyValues(dst);
        Enumeration<ClaimType> enumeration = dst.type = this.type == null ? null : this.type.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.ruleset = this.ruleset == null ? null : this.ruleset.copy();
        dst.originalRuleset = this.originalRuleset == null ? null : this.originalRuleset.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.target = this.target == null ? null : this.target.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.use = this.use == null ? null : this.use.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.fundsReserve = this.fundsReserve == null ? null : this.fundsReserve.copy();
        dst.enterer = this.enterer == null ? null : this.enterer.copy();
        dst.facility = this.facility == null ? null : this.facility.copy();
        dst.prescription = this.prescription == null ? null : this.prescription.copy();
        dst.originalPrescription = this.originalPrescription == null ? null : this.originalPrescription.copy();
        dst.payee = this.payee == null ? null : this.payee.copy();
        Reference reference = dst.referral = this.referral == null ? null : this.referral.copy();
        if (this.diagnosis != null) {
            dst.diagnosis = new ArrayList<DiagnosisComponent>();
            for (DiagnosisComponent diagnosisComponent : this.diagnosis) {
                dst.diagnosis.add(diagnosisComponent.copy());
            }
        }
        if (this.condition != null) {
            dst.condition = new ArrayList<Coding>();
            for (Coding coding : this.condition) {
                dst.condition.add(coding.copy());
            }
        }
        Reference reference2 = dst.patient = this.patient == null ? null : this.patient.copy();
        if (this.coverage != null) {
            dst.coverage = new ArrayList<CoverageComponent>();
            for (CoverageComponent coverageComponent : this.coverage) {
                dst.coverage.add(coverageComponent.copy());
            }
        }
        if (this.exception != null) {
            dst.exception = new ArrayList<Coding>();
            for (Coding coding : this.exception) {
                dst.exception.add(coding.copy());
            }
        }
        dst.school = this.school == null ? null : this.school.copy();
        dst.accident = this.accident == null ? null : this.accident.copy();
        Coding coding = dst.accidentType = this.accidentType == null ? null : this.accidentType.copy();
        if (this.interventionException != null) {
            dst.interventionException = new ArrayList<Coding>();
            for (Coding coding2 : this.interventionException) {
                dst.interventionException.add(coding2.copy());
            }
        }
        if (this.item != null) {
            dst.item = new ArrayList<ItemsComponent>();
            for (ItemsComponent itemsComponent : this.item) {
                dst.item.add(itemsComponent.copy());
            }
        }
        if (this.additionalMaterials != null) {
            dst.additionalMaterials = new ArrayList<Coding>();
            for (Coding coding3 : this.additionalMaterials) {
                dst.additionalMaterials.add(coding3.copy());
            }
        }
        if (this.missingTeeth != null) {
            dst.missingTeeth = new ArrayList<MissingTeethComponent>();
            for (MissingTeethComponent missingTeethComponent : this.missingTeeth) {
                dst.missingTeeth.add(missingTeethComponent.copy());
            }
        }
        return dst;
    }

    protected Claim typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Claim)) {
            return false;
        }
        Claim o = (Claim)other;
        return Claim.compareDeep(this.type, o.type, true) && Claim.compareDeep(this.identifier, o.identifier, true) && Claim.compareDeep(this.ruleset, o.ruleset, true) && Claim.compareDeep(this.originalRuleset, o.originalRuleset, true) && Claim.compareDeep(this.created, o.created, true) && Claim.compareDeep(this.target, o.target, true) && Claim.compareDeep(this.provider, o.provider, true) && Claim.compareDeep(this.organization, o.organization, true) && Claim.compareDeep(this.use, o.use, true) && Claim.compareDeep(this.priority, o.priority, true) && Claim.compareDeep(this.fundsReserve, o.fundsReserve, true) && Claim.compareDeep(this.enterer, o.enterer, true) && Claim.compareDeep(this.facility, o.facility, true) && Claim.compareDeep(this.prescription, o.prescription, true) && Claim.compareDeep(this.originalPrescription, o.originalPrescription, true) && Claim.compareDeep(this.payee, o.payee, true) && Claim.compareDeep(this.referral, o.referral, true) && Claim.compareDeep(this.diagnosis, o.diagnosis, true) && Claim.compareDeep(this.condition, o.condition, true) && Claim.compareDeep(this.patient, o.patient, true) && Claim.compareDeep(this.coverage, o.coverage, true) && Claim.compareDeep(this.exception, o.exception, true) && Claim.compareDeep(this.school, o.school, true) && Claim.compareDeep(this.accident, o.accident, true) && Claim.compareDeep(this.accidentType, o.accidentType, true) && Claim.compareDeep(this.interventionException, o.interventionException, true) && Claim.compareDeep(this.item, o.item, true) && Claim.compareDeep(this.additionalMaterials, o.additionalMaterials, true) && Claim.compareDeep(this.missingTeeth, o.missingTeeth, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Claim)) {
            return false;
        }
        Claim o = (Claim)other;
        return Claim.compareValues(this.type, o.type, true) && Claim.compareValues(this.created, o.created, true) && Claim.compareValues(this.use, o.use, true) && Claim.compareValues(this.school, o.school, true) && Claim.compareValues(this.accident, o.accident, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.ruleset != null && !this.ruleset.isEmpty() || this.originalRuleset != null && !this.originalRuleset.isEmpty() || this.created != null && !this.created.isEmpty() || this.target != null && !this.target.isEmpty() || this.provider != null && !this.provider.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.use != null && !this.use.isEmpty() || this.priority != null && !this.priority.isEmpty() || this.fundsReserve != null && !this.fundsReserve.isEmpty() || this.enterer != null && !this.enterer.isEmpty() || this.facility != null && !this.facility.isEmpty() || this.prescription != null && !this.prescription.isEmpty() || this.originalPrescription != null && !this.originalPrescription.isEmpty() || this.payee != null && !this.payee.isEmpty() || this.referral != null && !this.referral.isEmpty() || this.diagnosis != null && !this.diagnosis.isEmpty() || this.condition != null && !this.condition.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.coverage != null && !this.coverage.isEmpty() || this.exception != null && !this.exception.isEmpty() || this.school != null && !this.school.isEmpty() || this.accident != null && !this.accident.isEmpty() || this.accidentType != null && !this.accidentType.isEmpty() || this.interventionException != null && !this.interventionException.isEmpty() || this.item != null && !this.item.isEmpty() || this.additionalMaterials != null && !this.additionalMaterials.isEmpty() || this.missingTeeth != null && !this.missingTeeth.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Claim;
    }

    @Block
    public static class MissingTeethComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="tooth", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Tooth Code", formalDefinition="The code identifying which tooth is missing.")
        protected Coding tooth;
        @Child(name="reason", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reason for missing", formalDefinition="Missing reason may be: E-extraction, O-other.")
        protected Coding reason;
        @Child(name="extractionDate", type={DateType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date of Extraction", formalDefinition="The date of the extraction either known from records or patient reported estimate.")
        protected DateType extractionDate;
        private static final long serialVersionUID = 352913313L;

        public MissingTeethComponent() {
        }

        public MissingTeethComponent(Coding tooth) {
            this.tooth = tooth;
        }

        public Coding getTooth() {
            if (this.tooth == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MissingTeethComponent.tooth");
                }
                if (Configuration.doAutoCreate()) {
                    this.tooth = new Coding();
                }
            }
            return this.tooth;
        }

        public boolean hasTooth() {
            return this.tooth != null && !this.tooth.isEmpty();
        }

        public MissingTeethComponent setTooth(Coding value) {
            this.tooth = value;
            return this;
        }

        public Coding getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MissingTeethComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new Coding();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public MissingTeethComponent setReason(Coding value) {
            this.reason = value;
            return this;
        }

        public DateType getExtractionDateElement() {
            if (this.extractionDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MissingTeethComponent.extractionDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.extractionDate = new DateType();
                }
            }
            return this.extractionDate;
        }

        public boolean hasExtractionDateElement() {
            return this.extractionDate != null && !this.extractionDate.isEmpty();
        }

        public boolean hasExtractionDate() {
            return this.extractionDate != null && !this.extractionDate.isEmpty();
        }

        public MissingTeethComponent setExtractionDateElement(DateType value) {
            this.extractionDate = value;
            return this;
        }

        public Date getExtractionDate() {
            return this.extractionDate == null ? null : (Date)this.extractionDate.getValue();
        }

        public MissingTeethComponent setExtractionDate(Date value) {
            if (value == null) {
                this.extractionDate = null;
            } else {
                if (this.extractionDate == null) {
                    this.extractionDate = new DateType();
                }
                this.extractionDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("tooth", "Coding", "The code identifying which tooth is missing.", 0, Integer.MAX_VALUE, this.tooth));
            childrenList.add(new Property("reason", "Coding", "Missing reason may be: E-extraction, O-other.", 0, Integer.MAX_VALUE, this.reason));
            childrenList.add(new Property("extractionDate", "date", "The date of the extraction either known from records or patient reported estimate.", 0, Integer.MAX_VALUE, this.extractionDate));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("tooth")) {
                this.tooth = this.castToCoding(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCoding(value);
            } else if (name.equals("extractionDate")) {
                this.extractionDate = this.castToDate(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("tooth")) {
                this.tooth = new Coding();
                return this.tooth;
            }
            if (name.equals("reason")) {
                this.reason = new Coding();
                return this.reason;
            }
            if (name.equals("extractionDate")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.extractionDate");
            }
            return super.addChild(name);
        }

        @Override
        public MissingTeethComponent copy() {
            MissingTeethComponent dst = new MissingTeethComponent();
            this.copyValues(dst);
            dst.tooth = this.tooth == null ? null : this.tooth.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.extractionDate = this.extractionDate == null ? null : this.extractionDate.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MissingTeethComponent)) {
                return false;
            }
            MissingTeethComponent o = (MissingTeethComponent)other;
            return MissingTeethComponent.compareDeep(this.tooth, o.tooth, true) && MissingTeethComponent.compareDeep(this.reason, o.reason, true) && MissingTeethComponent.compareDeep(this.extractionDate, o.extractionDate, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MissingTeethComponent)) {
                return false;
            }
            MissingTeethComponent o = (MissingTeethComponent)other;
            return MissingTeethComponent.compareValues(this.extractionDate, o.extractionDate, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.tooth != null && !this.tooth.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.extractionDate != null && !this.extractionDate.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Claim.missingTeeth";
        }
    }

    @Block
    public static class ProsthesisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="initial", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Is this the initial service", formalDefinition="Indicates whether this is the initial placement of a fixed prosthesis.")
        protected BooleanType initial;
        @Child(name="priorDate", type={DateType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Initial service Date", formalDefinition="Date of the initial placement.")
        protected DateType priorDate;
        @Child(name="priorMaterial", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Prosthetic Material", formalDefinition="Material of the prior denture or bridge prosthesis. (Oral).")
        protected Coding priorMaterial;
        private static final long serialVersionUID = 1739349641L;

        public BooleanType getInitialElement() {
            if (this.initial == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProsthesisComponent.initial");
                }
                if (Configuration.doAutoCreate()) {
                    this.initial = new BooleanType();
                }
            }
            return this.initial;
        }

        public boolean hasInitialElement() {
            return this.initial != null && !this.initial.isEmpty();
        }

        public boolean hasInitial() {
            return this.initial != null && !this.initial.isEmpty();
        }

        public ProsthesisComponent setInitialElement(BooleanType value) {
            this.initial = value;
            return this;
        }

        public boolean getInitial() {
            return this.initial == null || this.initial.isEmpty() ? false : (Boolean)this.initial.getValue();
        }

        public ProsthesisComponent setInitial(boolean value) {
            if (this.initial == null) {
                this.initial = new BooleanType();
            }
            this.initial.setValue((Object)value);
            return this;
        }

        public DateType getPriorDateElement() {
            if (this.priorDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProsthesisComponent.priorDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.priorDate = new DateType();
                }
            }
            return this.priorDate;
        }

        public boolean hasPriorDateElement() {
            return this.priorDate != null && !this.priorDate.isEmpty();
        }

        public boolean hasPriorDate() {
            return this.priorDate != null && !this.priorDate.isEmpty();
        }

        public ProsthesisComponent setPriorDateElement(DateType value) {
            this.priorDate = value;
            return this;
        }

        public Date getPriorDate() {
            return this.priorDate == null ? null : (Date)this.priorDate.getValue();
        }

        public ProsthesisComponent setPriorDate(Date value) {
            if (value == null) {
                this.priorDate = null;
            } else {
                if (this.priorDate == null) {
                    this.priorDate = new DateType();
                }
                this.priorDate.setValue(value);
            }
            return this;
        }

        public Coding getPriorMaterial() {
            if (this.priorMaterial == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProsthesisComponent.priorMaterial");
                }
                if (Configuration.doAutoCreate()) {
                    this.priorMaterial = new Coding();
                }
            }
            return this.priorMaterial;
        }

        public boolean hasPriorMaterial() {
            return this.priorMaterial != null && !this.priorMaterial.isEmpty();
        }

        public ProsthesisComponent setPriorMaterial(Coding value) {
            this.priorMaterial = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("initial", "boolean", "Indicates whether this is the initial placement of a fixed prosthesis.", 0, Integer.MAX_VALUE, this.initial));
            childrenList.add(new Property("priorDate", "date", "Date of the initial placement.", 0, Integer.MAX_VALUE, this.priorDate));
            childrenList.add(new Property("priorMaterial", "Coding", "Material of the prior denture or bridge prosthesis. (Oral).", 0, Integer.MAX_VALUE, this.priorMaterial));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("initial")) {
                this.initial = this.castToBoolean(value);
            } else if (name.equals("priorDate")) {
                this.priorDate = this.castToDate(value);
            } else if (name.equals("priorMaterial")) {
                this.priorMaterial = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("initial")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.initial");
            }
            if (name.equals("priorDate")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.priorDate");
            }
            if (name.equals("priorMaterial")) {
                this.priorMaterial = new Coding();
                return this.priorMaterial;
            }
            return super.addChild(name);
        }

        @Override
        public ProsthesisComponent copy() {
            ProsthesisComponent dst = new ProsthesisComponent();
            this.copyValues(dst);
            dst.initial = this.initial == null ? null : this.initial.copy();
            dst.priorDate = this.priorDate == null ? null : this.priorDate.copy();
            dst.priorMaterial = this.priorMaterial == null ? null : this.priorMaterial.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProsthesisComponent)) {
                return false;
            }
            ProsthesisComponent o = (ProsthesisComponent)other;
            return ProsthesisComponent.compareDeep(this.initial, o.initial, true) && ProsthesisComponent.compareDeep(this.priorDate, o.priorDate, true) && ProsthesisComponent.compareDeep(this.priorMaterial, o.priorMaterial, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProsthesisComponent)) {
                return false;
            }
            ProsthesisComponent o = (ProsthesisComponent)other;
            return ProsthesisComponent.compareValues(this.initial, o.initial, true) && ProsthesisComponent.compareValues(this.priorDate, o.priorDate, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.initial != null && !this.initial.isEmpty() || this.priorDate != null && !this.priorDate.isEmpty() || this.priorMaterial != null && !this.priorMaterial.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Claim.item.prosthesis";
        }
    }

    @Block
    public static class SubDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequence;
        @Child(name="type", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of product or service", formalDefinition="The type of product or service.")
        protected Coding type;
        @Child(name="service", type={Coding.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Additional item codes", formalDefinition="The fee for an additional  service or product or charge.")
        protected Coding service;
        @Child(name="quantity", type={SimpleQuantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected SimpleQuantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="The fee for an additional  service or product or charge.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="points", type={DecimalType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Difficulty scaling factor", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.")
        protected DecimalType points;
        @Child(name="net", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Net additional item cost", formalDefinition="The quantity times the unit price for an additional  service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="udi", type={Coding.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Unique Device Identifier", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        protected Coding udi;
        private static final long serialVersionUID = 623567568L;

        public SubDetailComponent() {
        }

        public SubDetailComponent(PositiveIntType sequence, Coding type, Coding service) {
            this.sequence = sequence;
            this.type = type;
            this.service = service;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public SubDetailComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public SubDetailComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubDetailComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Coding getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new Coding();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public SubDetailComponent setService(Coding value) {
            this.service = value;
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SubDetailComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public SubDetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public SubDetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public SubDetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public DecimalType getPointsElement() {
            if (this.points == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.points");
                }
                if (Configuration.doAutoCreate()) {
                    this.points = new DecimalType();
                }
            }
            return this.points;
        }

        public boolean hasPointsElement() {
            return this.points != null && !this.points.isEmpty();
        }

        public boolean hasPoints() {
            return this.points != null && !this.points.isEmpty();
        }

        public SubDetailComponent setPointsElement(DecimalType value) {
            this.points = value;
            return this;
        }

        public BigDecimal getPoints() {
            return this.points == null ? null : (BigDecimal)this.points.getValue();
        }

        public SubDetailComponent setPoints(BigDecimal value) {
            if (value == null) {
                this.points = null;
            } else {
                if (this.points == null) {
                    this.points = new DecimalType();
                }
                this.points.setValue(value);
            }
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public SubDetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public Coding getUdi() {
            if (this.udi == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.udi");
                }
                if (Configuration.doAutoCreate()) {
                    this.udi = new Coding();
                }
            }
            return this.udi;
        }

        public boolean hasUdi() {
            return this.udi != null && !this.udi.isEmpty();
        }

        public SubDetailComponent setUdi(Coding value) {
            this.udi = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequence", "positiveInt", "A service line number.", 0, Integer.MAX_VALUE, this.sequence));
            childrenList.add(new Property("type", "Coding", "The type of product or service.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("service", "Coding", "The fee for an additional  service or product or charge.", 0, Integer.MAX_VALUE, this.service));
            childrenList.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("unitPrice", "Money", "The fee for an additional  service or product or charge.", 0, Integer.MAX_VALUE, this.unitPrice));
            childrenList.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, Integer.MAX_VALUE, this.factor));
            childrenList.add(new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.", 0, Integer.MAX_VALUE, this.points));
            childrenList.add(new Property("net", "Money", "The quantity times the unit price for an additional  service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, Integer.MAX_VALUE, this.net));
            childrenList.add(new Property("udi", "Coding", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("service")) {
                this.service = this.castToCoding(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("points")) {
                this.points = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.udi = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.sequence");
            }
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("service")) {
                this.service = new Coding();
                return this.service;
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.factor");
            }
            if (name.equals("points")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.points");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                this.udi = new Coding();
                return this.udi;
            }
            return super.addChild(name);
        }

        @Override
        public SubDetailComponent copy() {
            SubDetailComponent dst = new SubDetailComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.service = this.service == null ? null : this.service.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.points = this.points == null ? null : this.points.copy();
            dst.net = this.net == null ? null : this.net.copy();
            dst.udi = this.udi == null ? null : this.udi.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other;
            return SubDetailComponent.compareDeep(this.sequence, o.sequence, true) && SubDetailComponent.compareDeep(this.type, o.type, true) && SubDetailComponent.compareDeep(this.service, o.service, true) && SubDetailComponent.compareDeep(this.quantity, o.quantity, true) && SubDetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && SubDetailComponent.compareDeep(this.factor, o.factor, true) && SubDetailComponent.compareDeep(this.points, o.points, true) && SubDetailComponent.compareDeep(this.net, o.net, true) && SubDetailComponent.compareDeep(this.udi, o.udi, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other;
            return SubDetailComponent.compareValues(this.sequence, o.sequence, true) && SubDetailComponent.compareValues(this.factor, o.factor, true) && SubDetailComponent.compareValues(this.points, o.points, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.type != null && !this.type.isEmpty() || this.service != null && !this.service.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.unitPrice != null && !this.unitPrice.isEmpty() || this.factor != null && !this.factor.isEmpty() || this.points != null && !this.points.isEmpty() || this.net != null && !this.net.isEmpty() || this.udi != null && !this.udi.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Claim.item.detail.subDetail";
        }
    }

    @Block
    public static class DetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequence;
        @Child(name="type", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Group or type of product or service", formalDefinition="The type of product or service.")
        protected Coding type;
        @Child(name="service", type={Coding.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Additional item codes", formalDefinition="If a grouping item then 'GROUP' otherwise it is a node therefore a code to indicate the Professional Service or Product supplied.")
        protected Coding service;
        @Child(name="quantity", type={SimpleQuantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected SimpleQuantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="points", type={DecimalType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Difficulty scaling factor", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.")
        protected DecimalType points;
        @Child(name="net", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Total additional item cost", formalDefinition="The quantity times the unit price for an additional  service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="udi", type={Coding.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Unique Device Identifier", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        protected Coding udi;
        @Child(name="subDetail", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Additional items", formalDefinition="Third tier of goods and services.")
        protected List<SubDetailComponent> subDetail;
        private static final long serialVersionUID = 5768017L;

        public DetailComponent() {
        }

        public DetailComponent(PositiveIntType sequence, Coding type, Coding service) {
            this.sequence = sequence;
            this.type = type;
            this.service = service;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public DetailComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public DetailComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DetailComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Coding getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new Coding();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public DetailComponent setService(Coding value) {
            this.service = value;
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public DetailComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public DetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public DetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public DetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public DecimalType getPointsElement() {
            if (this.points == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.points");
                }
                if (Configuration.doAutoCreate()) {
                    this.points = new DecimalType();
                }
            }
            return this.points;
        }

        public boolean hasPointsElement() {
            return this.points != null && !this.points.isEmpty();
        }

        public boolean hasPoints() {
            return this.points != null && !this.points.isEmpty();
        }

        public DetailComponent setPointsElement(DecimalType value) {
            this.points = value;
            return this;
        }

        public BigDecimal getPoints() {
            return this.points == null ? null : (BigDecimal)this.points.getValue();
        }

        public DetailComponent setPoints(BigDecimal value) {
            if (value == null) {
                this.points = null;
            } else {
                if (this.points == null) {
                    this.points = new DecimalType();
                }
                this.points.setValue(value);
            }
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public DetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public Coding getUdi() {
            if (this.udi == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.udi");
                }
                if (Configuration.doAutoCreate()) {
                    this.udi = new Coding();
                }
            }
            return this.udi;
        }

        public boolean hasUdi() {
            return this.udi != null && !this.udi.isEmpty();
        }

        public DetailComponent setUdi(Coding value) {
            this.udi = value;
            return this;
        }

        public List<SubDetailComponent> getSubDetail() {
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            return this.subDetail;
        }

        public boolean hasSubDetail() {
            if (this.subDetail == null) {
                return false;
            }
            for (SubDetailComponent item : this.subDetail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubDetailComponent addSubDetail() {
            SubDetailComponent t = new SubDetailComponent();
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return t;
        }

        public DetailComponent addSubDetail(SubDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequence", "positiveInt", "A service line number.", 0, Integer.MAX_VALUE, this.sequence));
            childrenList.add(new Property("type", "Coding", "The type of product or service.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("service", "Coding", "If a grouping item then 'GROUP' otherwise it is a node therefore a code to indicate the Professional Service or Product supplied.", 0, Integer.MAX_VALUE, this.service));
            childrenList.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, Integer.MAX_VALUE, this.unitPrice));
            childrenList.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, Integer.MAX_VALUE, this.factor));
            childrenList.add(new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.", 0, Integer.MAX_VALUE, this.points));
            childrenList.add(new Property("net", "Money", "The quantity times the unit price for an additional  service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, Integer.MAX_VALUE, this.net));
            childrenList.add(new Property("udi", "Coding", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
            childrenList.add(new Property("subDetail", "", "Third tier of goods and services.", 0, Integer.MAX_VALUE, this.subDetail));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("service")) {
                this.service = this.castToCoding(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("points")) {
                this.points = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.udi = this.castToCoding(value);
            } else if (name.equals("subDetail")) {
                this.getSubDetail().add((SubDetailComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.sequence");
            }
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("service")) {
                this.service = new Coding();
                return this.service;
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.factor");
            }
            if (name.equals("points")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.points");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                this.udi = new Coding();
                return this.udi;
            }
            if (name.equals("subDetail")) {
                return this.addSubDetail();
            }
            return super.addChild(name);
        }

        @Override
        public DetailComponent copy() {
            DetailComponent dst = new DetailComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.service = this.service == null ? null : this.service.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.points = this.points == null ? null : this.points.copy();
            dst.net = this.net == null ? null : this.net.copy();
            Coding coding = dst.udi = this.udi == null ? null : this.udi.copy();
            if (this.subDetail != null) {
                dst.subDetail = new ArrayList<SubDetailComponent>();
                for (SubDetailComponent i : this.subDetail) {
                    dst.subDetail.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DetailComponent)) {
                return false;
            }
            DetailComponent o = (DetailComponent)other;
            return DetailComponent.compareDeep(this.sequence, o.sequence, true) && DetailComponent.compareDeep(this.type, o.type, true) && DetailComponent.compareDeep(this.service, o.service, true) && DetailComponent.compareDeep(this.quantity, o.quantity, true) && DetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && DetailComponent.compareDeep(this.factor, o.factor, true) && DetailComponent.compareDeep(this.points, o.points, true) && DetailComponent.compareDeep(this.net, o.net, true) && DetailComponent.compareDeep(this.udi, o.udi, true) && DetailComponent.compareDeep(this.subDetail, o.subDetail, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DetailComponent)) {
                return false;
            }
            DetailComponent o = (DetailComponent)other;
            return DetailComponent.compareValues(this.sequence, o.sequence, true) && DetailComponent.compareValues(this.factor, o.factor, true) && DetailComponent.compareValues(this.points, o.points, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.type != null && !this.type.isEmpty() || this.service != null && !this.service.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.unitPrice != null && !this.unitPrice.isEmpty() || this.factor != null && !this.factor.isEmpty() || this.points != null && !this.points.isEmpty() || this.net != null && !this.net.isEmpty() || this.udi != null && !this.udi.isEmpty() || this.subDetail != null && !this.subDetail.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Claim.item.detail";
        }
    }

    @Block
    public static class ItemsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequence;
        @Child(name="type", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Group or type of product or service", formalDefinition="The type of product or service.")
        protected Coding type;
        @Child(name="provider", type={Practitioner.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
        protected Reference provider;
        protected Practitioner providerTarget;
        @Child(name="diagnosisLinkId", type={PositiveIntType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Diagnosis Link", formalDefinition="Diagnosis applicable for this service or product line.")
        protected List<PositiveIntType> diagnosisLinkId;
        @Child(name="service", type={Coding.class}, order=5, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Item Code", formalDefinition="If a grouping item then 'GROUP' otherwise it is a node therefore a code to indicate the Professional Service or Product supplied.")
        protected Coding service;
        @Child(name="serviceDate", type={DateType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date of Service", formalDefinition="The date when the enclosed suite of services were performed or completed.")
        protected DateType serviceDate;
        @Child(name="quantity", type={SimpleQuantity.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected SimpleQuantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="points", type={DecimalType.class}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Difficulty scaling factor", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.")
        protected DecimalType points;
        @Child(name="net", type={Money.class}, order=11, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Total item cost", formalDefinition="The quantity times the unit price for an additional  service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="udi", type={Coding.class}, order=12, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Unique Device Identifier", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        protected Coding udi;
        @Child(name="bodySite", type={Coding.class}, order=13, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service Location", formalDefinition="Physical service site on the patient (limb, tooth, etc.).")
        protected Coding bodySite;
        @Child(name="subSite", type={Coding.class}, order=14, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Service Sub-location", formalDefinition="A region or surface of the site, e.g. limb region or tooth surface(s).")
        protected List<Coding> subSite;
        @Child(name="modifier", type={Coding.class}, order=15, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.")
        protected List<Coding> modifier;
        @Child(name="detail", type={}, order=16, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Additional items", formalDefinition="Second tier of goods and services.")
        protected List<DetailComponent> detail;
        @Child(name="prosthesis", type={}, order=17, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Prosthetic details", formalDefinition="The materials and placement date of prior fixed prosthesis.")
        protected ProsthesisComponent prosthesis;
        private static final long serialVersionUID = 1295830456L;

        public ItemsComponent() {
        }

        public ItemsComponent(PositiveIntType sequence, Coding type, Coding service) {
            this.sequence = sequence;
            this.type = type;
            this.service = service;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public ItemsComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public ItemsComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ItemsComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Reference getProvider() {
            if (this.provider == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.provider");
                }
                if (Configuration.doAutoCreate()) {
                    this.provider = new Reference();
                }
            }
            return this.provider;
        }

        public boolean hasProvider() {
            return this.provider != null && !this.provider.isEmpty();
        }

        public ItemsComponent setProvider(Reference value) {
            this.provider = value;
            return this;
        }

        public Practitioner getProviderTarget() {
            if (this.providerTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.provider");
                }
                if (Configuration.doAutoCreate()) {
                    this.providerTarget = new Practitioner();
                }
            }
            return this.providerTarget;
        }

        public ItemsComponent setProviderTarget(Practitioner value) {
            this.providerTarget = value;
            return this;
        }

        public List<PositiveIntType> getDiagnosisLinkId() {
            if (this.diagnosisLinkId == null) {
                this.diagnosisLinkId = new ArrayList<PositiveIntType>();
            }
            return this.diagnosisLinkId;
        }

        public boolean hasDiagnosisLinkId() {
            if (this.diagnosisLinkId == null) {
                return false;
            }
            for (PositiveIntType item : this.diagnosisLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addDiagnosisLinkIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.diagnosisLinkId == null) {
                this.diagnosisLinkId = new ArrayList<PositiveIntType>();
            }
            this.diagnosisLinkId.add(t);
            return t;
        }

        public ItemsComponent addDiagnosisLinkId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.diagnosisLinkId == null) {
                this.diagnosisLinkId = new ArrayList<PositiveIntType>();
            }
            this.diagnosisLinkId.add(t);
            return this;
        }

        public boolean hasDiagnosisLinkId(int value) {
            if (this.diagnosisLinkId == null) {
                return false;
            }
            for (PositiveIntType v : this.diagnosisLinkId) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Coding getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new Coding();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public ItemsComponent setService(Coding value) {
            this.service = value;
            return this;
        }

        public DateType getServiceDateElement() {
            if (this.serviceDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.serviceDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.serviceDate = new DateType();
                }
            }
            return this.serviceDate;
        }

        public boolean hasServiceDateElement() {
            return this.serviceDate != null && !this.serviceDate.isEmpty();
        }

        public boolean hasServiceDate() {
            return this.serviceDate != null && !this.serviceDate.isEmpty();
        }

        public ItemsComponent setServiceDateElement(DateType value) {
            this.serviceDate = value;
            return this;
        }

        public Date getServiceDate() {
            return this.serviceDate == null ? null : (Date)this.serviceDate.getValue();
        }

        public ItemsComponent setServiceDate(Date value) {
            if (value == null) {
                this.serviceDate = null;
            } else {
                if (this.serviceDate == null) {
                    this.serviceDate = new DateType();
                }
                this.serviceDate.setValue(value);
            }
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public ItemsComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public ItemsComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public ItemsComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public ItemsComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public DecimalType getPointsElement() {
            if (this.points == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.points");
                }
                if (Configuration.doAutoCreate()) {
                    this.points = new DecimalType();
                }
            }
            return this.points;
        }

        public boolean hasPointsElement() {
            return this.points != null && !this.points.isEmpty();
        }

        public boolean hasPoints() {
            return this.points != null && !this.points.isEmpty();
        }

        public ItemsComponent setPointsElement(DecimalType value) {
            this.points = value;
            return this;
        }

        public BigDecimal getPoints() {
            return this.points == null ? null : (BigDecimal)this.points.getValue();
        }

        public ItemsComponent setPoints(BigDecimal value) {
            if (value == null) {
                this.points = null;
            } else {
                if (this.points == null) {
                    this.points = new DecimalType();
                }
                this.points.setValue(value);
            }
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public ItemsComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public Coding getUdi() {
            if (this.udi == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.udi");
                }
                if (Configuration.doAutoCreate()) {
                    this.udi = new Coding();
                }
            }
            return this.udi;
        }

        public boolean hasUdi() {
            return this.udi != null && !this.udi.isEmpty();
        }

        public ItemsComponent setUdi(Coding value) {
            this.udi = value;
            return this;
        }

        public Coding getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new Coding();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public ItemsComponent setBodySite(Coding value) {
            this.bodySite = value;
            return this;
        }

        public List<Coding> getSubSite() {
            if (this.subSite == null) {
                this.subSite = new ArrayList<Coding>();
            }
            return this.subSite;
        }

        public boolean hasSubSite() {
            if (this.subSite == null) {
                return false;
            }
            for (Coding item : this.subSite) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addSubSite() {
            Coding t = new Coding();
            if (this.subSite == null) {
                this.subSite = new ArrayList<Coding>();
            }
            this.subSite.add(t);
            return t;
        }

        public ItemsComponent addSubSite(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.subSite == null) {
                this.subSite = new ArrayList<Coding>();
            }
            this.subSite.add(t);
            return this;
        }

        public List<Coding> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<Coding>();
            }
            return this.modifier;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (Coding item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addModifier() {
            Coding t = new Coding();
            if (this.modifier == null) {
                this.modifier = new ArrayList<Coding>();
            }
            this.modifier.add(t);
            return t;
        }

        public ItemsComponent addModifier(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<Coding>();
            }
            this.modifier.add(t);
            return this;
        }

        public List<DetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            return this.detail;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (DetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DetailComponent addDetail() {
            DetailComponent t = new DetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public ItemsComponent addDetail(DetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        public ProsthesisComponent getProsthesis() {
            if (this.prosthesis == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.prosthesis");
                }
                if (Configuration.doAutoCreate()) {
                    this.prosthesis = new ProsthesisComponent();
                }
            }
            return this.prosthesis;
        }

        public boolean hasProsthesis() {
            return this.prosthesis != null && !this.prosthesis.isEmpty();
        }

        public ItemsComponent setProsthesis(ProsthesisComponent value) {
            this.prosthesis = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequence", "positiveInt", "A service line number.", 0, Integer.MAX_VALUE, this.sequence));
            childrenList.add(new Property("type", "Coding", "The type of product or service.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property(Claim.SP_PROVIDER, "Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.provider));
            childrenList.add(new Property("diagnosisLinkId", "positiveInt", "Diagnosis applicable for this service or product line.", 0, Integer.MAX_VALUE, this.diagnosisLinkId));
            childrenList.add(new Property("service", "Coding", "If a grouping item then 'GROUP' otherwise it is a node therefore a code to indicate the Professional Service or Product supplied.", 0, Integer.MAX_VALUE, this.service));
            childrenList.add(new Property("serviceDate", "date", "The date when the enclosed suite of services were performed or completed.", 0, Integer.MAX_VALUE, this.serviceDate));
            childrenList.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, Integer.MAX_VALUE, this.unitPrice));
            childrenList.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, Integer.MAX_VALUE, this.factor));
            childrenList.add(new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the good or service delivered. The concept of Points allows for assignment of point values for services and/or goods, such that a monetary amount can be assigned to each point.", 0, Integer.MAX_VALUE, this.points));
            childrenList.add(new Property("net", "Money", "The quantity times the unit price for an additional  service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, Integer.MAX_VALUE, this.net));
            childrenList.add(new Property("udi", "Coding", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
            childrenList.add(new Property("bodySite", "Coding", "Physical service site on the patient (limb, tooth, etc.).", 0, Integer.MAX_VALUE, this.bodySite));
            childrenList.add(new Property("subSite", "Coding", "A region or surface of the site, e.g. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite));
            childrenList.add(new Property("modifier", "Coding", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.", 0, Integer.MAX_VALUE, this.modifier));
            childrenList.add(new Property("detail", "", "Second tier of goods and services.", 0, Integer.MAX_VALUE, this.detail));
            childrenList.add(new Property("prosthesis", "", "The materials and placement date of prior fixed prosthesis.", 0, Integer.MAX_VALUE, this.prosthesis));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals(Claim.SP_PROVIDER)) {
                this.provider = this.castToReference(value);
            } else if (name.equals("diagnosisLinkId")) {
                this.getDiagnosisLinkId().add(this.castToPositiveInt(value));
            } else if (name.equals("service")) {
                this.service = this.castToCoding(value);
            } else if (name.equals("serviceDate")) {
                this.serviceDate = this.castToDate(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("points")) {
                this.points = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.udi = this.castToCoding(value);
            } else if (name.equals("bodySite")) {
                this.bodySite = this.castToCoding(value);
            } else if (name.equals("subSite")) {
                this.getSubSite().add(this.castToCoding(value));
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCoding(value));
            } else if (name.equals("detail")) {
                this.getDetail().add((DetailComponent)value);
            } else if (name.equals("prosthesis")) {
                this.prosthesis = (ProsthesisComponent)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.sequence");
            }
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals(Claim.SP_PROVIDER)) {
                this.provider = new Reference();
                return this.provider;
            }
            if (name.equals("diagnosisLinkId")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.diagnosisLinkId");
            }
            if (name.equals("service")) {
                this.service = new Coding();
                return this.service;
            }
            if (name.equals("serviceDate")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.serviceDate");
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.factor");
            }
            if (name.equals("points")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.points");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                this.udi = new Coding();
                return this.udi;
            }
            if (name.equals("bodySite")) {
                this.bodySite = new Coding();
                return this.bodySite;
            }
            if (name.equals("subSite")) {
                return this.addSubSite();
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            if (name.equals("prosthesis")) {
                this.prosthesis = new ProsthesisComponent();
                return this.prosthesis;
            }
            return super.addChild(name);
        }

        @Override
        public ItemsComponent copy() {
            ItemsComponent dst = new ItemsComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.type = this.type == null ? null : this.type.copy();
            Reference reference = dst.provider = this.provider == null ? null : this.provider.copy();
            if (this.diagnosisLinkId != null) {
                dst.diagnosisLinkId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.diagnosisLinkId) {
                    dst.diagnosisLinkId.add(positiveIntType.copy());
                }
            }
            dst.service = this.service == null ? null : this.service.copy();
            dst.serviceDate = this.serviceDate == null ? null : this.serviceDate.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.points = this.points == null ? null : this.points.copy();
            dst.net = this.net == null ? null : this.net.copy();
            dst.udi = this.udi == null ? null : this.udi.copy();
            Coding coding = dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            if (this.subSite != null) {
                dst.subSite = new ArrayList<Coding>();
                for (Coding coding2 : this.subSite) {
                    dst.subSite.add(coding2.copy());
                }
            }
            if (this.modifier != null) {
                dst.modifier = new ArrayList<Coding>();
                for (Coding coding3 : this.modifier) {
                    dst.modifier.add(coding3.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<DetailComponent>();
                for (DetailComponent detailComponent : this.detail) {
                    dst.detail.add(detailComponent.copy());
                }
            }
            dst.prosthesis = this.prosthesis == null ? null : this.prosthesis.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ItemsComponent)) {
                return false;
            }
            ItemsComponent o = (ItemsComponent)other;
            return ItemsComponent.compareDeep(this.sequence, o.sequence, true) && ItemsComponent.compareDeep(this.type, o.type, true) && ItemsComponent.compareDeep(this.provider, o.provider, true) && ItemsComponent.compareDeep(this.diagnosisLinkId, o.diagnosisLinkId, true) && ItemsComponent.compareDeep(this.service, o.service, true) && ItemsComponent.compareDeep(this.serviceDate, o.serviceDate, true) && ItemsComponent.compareDeep(this.quantity, o.quantity, true) && ItemsComponent.compareDeep(this.unitPrice, o.unitPrice, true) && ItemsComponent.compareDeep(this.factor, o.factor, true) && ItemsComponent.compareDeep(this.points, o.points, true) && ItemsComponent.compareDeep(this.net, o.net, true) && ItemsComponent.compareDeep(this.udi, o.udi, true) && ItemsComponent.compareDeep(this.bodySite, o.bodySite, true) && ItemsComponent.compareDeep(this.subSite, o.subSite, true) && ItemsComponent.compareDeep(this.modifier, o.modifier, true) && ItemsComponent.compareDeep(this.detail, o.detail, true) && ItemsComponent.compareDeep(this.prosthesis, o.prosthesis, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ItemsComponent)) {
                return false;
            }
            ItemsComponent o = (ItemsComponent)other;
            return ItemsComponent.compareValues(this.sequence, o.sequence, true) && ItemsComponent.compareValues(this.diagnosisLinkId, o.diagnosisLinkId, true) && ItemsComponent.compareValues(this.serviceDate, o.serviceDate, true) && ItemsComponent.compareValues(this.factor, o.factor, true) && ItemsComponent.compareValues(this.points, o.points, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.type != null && !this.type.isEmpty() || this.provider != null && !this.provider.isEmpty() || this.diagnosisLinkId != null && !this.diagnosisLinkId.isEmpty() || this.service != null && !this.service.isEmpty() || this.serviceDate != null && !this.serviceDate.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.unitPrice != null && !this.unitPrice.isEmpty() || this.factor != null && !this.factor.isEmpty() || this.points != null && !this.points.isEmpty() || this.net != null && !this.net.isEmpty() || this.udi != null && !this.udi.isEmpty() || this.bodySite != null && !this.bodySite.isEmpty() || this.subSite != null && !this.subSite.isEmpty() || this.modifier != null && !this.modifier.isEmpty() || this.detail != null && !this.detail.isEmpty() || this.prosthesis != null && !this.prosthesis.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Claim.item";
        }
    }

    @Block
    public static class CoverageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service instance identifier", formalDefinition="A service line item.")
        protected PositiveIntType sequence;
        @Child(name="focal", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The focal Coverage", formalDefinition="The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim is to be adjudicated.")
        protected BooleanType focal;
        @Child(name="coverage", type={Coverage.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Insurance information", formalDefinition="Reference to the program or plan identification, underwriter or payor.")
        protected Reference coverage;
        protected Coverage coverageTarget;
        @Child(name="businessArrangement", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Business agreement", formalDefinition="The contract number of a business agreement which describes the terms and conditions.")
        protected StringType businessArrangement;
        @Child(name="relationship", type={Coding.class}, order=5, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Patient relationship to subscriber", formalDefinition="The relationship of the patient to the subscriber.")
        protected Coding relationship;
        @Child(name="preAuthRef", type={StringType.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Pre-Authorization/Determination Reference", formalDefinition="A list of references from the Insurer to which these services pertain.")
        protected List<StringType> preAuthRef;
        @Child(name="claimResponse", type={ClaimResponse.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication results", formalDefinition="The Coverages adjudication details.")
        protected Reference claimResponse;
        protected ClaimResponse claimResponseTarget;
        @Child(name="originalRuleset", type={Coding.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Original version", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
        protected Coding originalRuleset;
        private static final long serialVersionUID = 621250924L;

        public CoverageComponent() {
        }

        public CoverageComponent(PositiveIntType sequence, BooleanType focal, Reference coverage, Coding relationship) {
            this.sequence = sequence;
            this.focal = focal;
            this.coverage = coverage;
            this.relationship = relationship;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public CoverageComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public CoverageComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public BooleanType getFocalElement() {
            if (this.focal == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.focal");
                }
                if (Configuration.doAutoCreate()) {
                    this.focal = new BooleanType();
                }
            }
            return this.focal;
        }

        public boolean hasFocalElement() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public boolean hasFocal() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public CoverageComponent setFocalElement(BooleanType value) {
            this.focal = value;
            return this;
        }

        public boolean getFocal() {
            return this.focal == null || this.focal.isEmpty() ? false : (Boolean)this.focal.getValue();
        }

        public CoverageComponent setFocal(boolean value) {
            if (this.focal == null) {
                this.focal = new BooleanType();
            }
            this.focal.setValue((Object)value);
            return this;
        }

        public Reference getCoverage() {
            if (this.coverage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverage = new Reference();
                }
            }
            return this.coverage;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public CoverageComponent setCoverage(Reference value) {
            this.coverage = value;
            return this;
        }

        public Coverage getCoverageTarget() {
            if (this.coverageTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverageTarget = new Coverage();
                }
            }
            return this.coverageTarget;
        }

        public CoverageComponent setCoverageTarget(Coverage value) {
            this.coverageTarget = value;
            return this;
        }

        public StringType getBusinessArrangementElement() {
            if (this.businessArrangement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.businessArrangement");
                }
                if (Configuration.doAutoCreate()) {
                    this.businessArrangement = new StringType();
                }
            }
            return this.businessArrangement;
        }

        public boolean hasBusinessArrangementElement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public boolean hasBusinessArrangement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public CoverageComponent setBusinessArrangementElement(StringType value) {
            this.businessArrangement = value;
            return this;
        }

        public String getBusinessArrangement() {
            return this.businessArrangement == null ? null : (String)this.businessArrangement.getValue();
        }

        public CoverageComponent setBusinessArrangement(String value) {
            if (Utilities.noString((String)value)) {
                this.businessArrangement = null;
            } else {
                if (this.businessArrangement == null) {
                    this.businessArrangement = new StringType();
                }
                this.businessArrangement.setValue(value);
            }
            return this;
        }

        public Coding getRelationship() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new Coding();
                }
            }
            return this.relationship;
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public CoverageComponent setRelationship(Coding value) {
            this.relationship = value;
            return this;
        }

        public List<StringType> getPreAuthRef() {
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            return this.preAuthRef;
        }

        public boolean hasPreAuthRef() {
            if (this.preAuthRef == null) {
                return false;
            }
            for (StringType item : this.preAuthRef) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addPreAuthRefElement() {
            StringType t = new StringType();
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            this.preAuthRef.add(t);
            return t;
        }

        public CoverageComponent addPreAuthRef(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            this.preAuthRef.add(t);
            return this;
        }

        public boolean hasPreAuthRef(String value) {
            if (this.preAuthRef == null) {
                return false;
            }
            for (StringType v : this.preAuthRef) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Reference getClaimResponse() {
            if (this.claimResponse == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.claimResponse");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimResponse = new Reference();
                }
            }
            return this.claimResponse;
        }

        public boolean hasClaimResponse() {
            return this.claimResponse != null && !this.claimResponse.isEmpty();
        }

        public CoverageComponent setClaimResponse(Reference value) {
            this.claimResponse = value;
            return this;
        }

        public ClaimResponse getClaimResponseTarget() {
            if (this.claimResponseTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.claimResponse");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimResponseTarget = new ClaimResponse();
                }
            }
            return this.claimResponseTarget;
        }

        public CoverageComponent setClaimResponseTarget(ClaimResponse value) {
            this.claimResponseTarget = value;
            return this;
        }

        public Coding getOriginalRuleset() {
            if (this.originalRuleset == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.originalRuleset");
                }
                if (Configuration.doAutoCreate()) {
                    this.originalRuleset = new Coding();
                }
            }
            return this.originalRuleset;
        }

        public boolean hasOriginalRuleset() {
            return this.originalRuleset != null && !this.originalRuleset.isEmpty();
        }

        public CoverageComponent setOriginalRuleset(Coding value) {
            this.originalRuleset = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequence", "positiveInt", "A service line item.", 0, Integer.MAX_VALUE, this.sequence));
            childrenList.add(new Property("focal", "boolean", "The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim is to be adjudicated.", 0, Integer.MAX_VALUE, this.focal));
            childrenList.add(new Property("coverage", "Reference(Coverage)", "Reference to the program or plan identification, underwriter or payor.", 0, Integer.MAX_VALUE, this.coverage));
            childrenList.add(new Property("businessArrangement", "string", "The contract number of a business agreement which describes the terms and conditions.", 0, Integer.MAX_VALUE, this.businessArrangement));
            childrenList.add(new Property("relationship", "Coding", "The relationship of the patient to the subscriber.", 0, Integer.MAX_VALUE, this.relationship));
            childrenList.add(new Property("preAuthRef", "string", "A list of references from the Insurer to which these services pertain.", 0, Integer.MAX_VALUE, this.preAuthRef));
            childrenList.add(new Property("claimResponse", "Reference(ClaimResponse)", "The Coverages adjudication details.", 0, Integer.MAX_VALUE, this.claimResponse));
            childrenList.add(new Property("originalRuleset", "Coding", "The style (standard) and version of the original material which was converted into this resource.", 0, Integer.MAX_VALUE, this.originalRuleset));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("focal")) {
                this.focal = this.castToBoolean(value);
            } else if (name.equals("coverage")) {
                this.coverage = this.castToReference(value);
            } else if (name.equals("businessArrangement")) {
                this.businessArrangement = this.castToString(value);
            } else if (name.equals("relationship")) {
                this.relationship = this.castToCoding(value);
            } else if (name.equals("preAuthRef")) {
                this.getPreAuthRef().add(this.castToString(value));
            } else if (name.equals("claimResponse")) {
                this.claimResponse = this.castToReference(value);
            } else if (name.equals("originalRuleset")) {
                this.originalRuleset = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.sequence");
            }
            if (name.equals("focal")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.focal");
            }
            if (name.equals("coverage")) {
                this.coverage = new Reference();
                return this.coverage;
            }
            if (name.equals("businessArrangement")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.businessArrangement");
            }
            if (name.equals("relationship")) {
                this.relationship = new Coding();
                return this.relationship;
            }
            if (name.equals("preAuthRef")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.preAuthRef");
            }
            if (name.equals("claimResponse")) {
                this.claimResponse = new Reference();
                return this.claimResponse;
            }
            if (name.equals("originalRuleset")) {
                this.originalRuleset = new Coding();
                return this.originalRuleset;
            }
            return super.addChild(name);
        }

        @Override
        public CoverageComponent copy() {
            CoverageComponent dst = new CoverageComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.focal = this.focal == null ? null : this.focal.copy();
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
            dst.businessArrangement = this.businessArrangement == null ? null : this.businessArrangement.copy();
            Coding coding = dst.relationship = this.relationship == null ? null : this.relationship.copy();
            if (this.preAuthRef != null) {
                dst.preAuthRef = new ArrayList<StringType>();
                for (StringType i : this.preAuthRef) {
                    dst.preAuthRef.add(i.copy());
                }
            }
            dst.claimResponse = this.claimResponse == null ? null : this.claimResponse.copy();
            dst.originalRuleset = this.originalRuleset == null ? null : this.originalRuleset.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CoverageComponent)) {
                return false;
            }
            CoverageComponent o = (CoverageComponent)other;
            return CoverageComponent.compareDeep(this.sequence, o.sequence, true) && CoverageComponent.compareDeep(this.focal, o.focal, true) && CoverageComponent.compareDeep(this.coverage, o.coverage, true) && CoverageComponent.compareDeep(this.businessArrangement, o.businessArrangement, true) && CoverageComponent.compareDeep(this.relationship, o.relationship, true) && CoverageComponent.compareDeep(this.preAuthRef, o.preAuthRef, true) && CoverageComponent.compareDeep(this.claimResponse, o.claimResponse, true) && CoverageComponent.compareDeep(this.originalRuleset, o.originalRuleset, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CoverageComponent)) {
                return false;
            }
            CoverageComponent o = (CoverageComponent)other;
            return CoverageComponent.compareValues(this.sequence, o.sequence, true) && CoverageComponent.compareValues(this.focal, o.focal, true) && CoverageComponent.compareValues(this.businessArrangement, o.businessArrangement, true) && CoverageComponent.compareValues(this.preAuthRef, o.preAuthRef, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.focal != null && !this.focal.isEmpty() || this.coverage != null && !this.coverage.isEmpty() || this.businessArrangement != null && !this.businessArrangement.isEmpty() || this.relationship != null && !this.relationship.isEmpty() || this.preAuthRef != null && !this.preAuthRef.isEmpty() || this.claimResponse != null && !this.claimResponse.isEmpty() || this.originalRuleset != null && !this.originalRuleset.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Claim.coverage";
        }
    }

    @Block
    public static class DiagnosisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Sequence of diagnosis", formalDefinition="Sequence of diagnosis which serves to order and provide a link.")
        protected PositiveIntType sequence;
        @Child(name="diagnosis", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Patient's list of diagnosis", formalDefinition="The diagnosis.")
        protected Coding diagnosis;
        private static final long serialVersionUID = -795010186L;

        public DiagnosisComponent() {
        }

        public DiagnosisComponent(PositiveIntType sequence, Coding diagnosis) {
            this.sequence = sequence;
            this.diagnosis = diagnosis;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public DiagnosisComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public DiagnosisComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Coding getDiagnosis() {
            if (this.diagnosis == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.diagnosis");
                }
                if (Configuration.doAutoCreate()) {
                    this.diagnosis = new Coding();
                }
            }
            return this.diagnosis;
        }

        public boolean hasDiagnosis() {
            return this.diagnosis != null && !this.diagnosis.isEmpty();
        }

        public DiagnosisComponent setDiagnosis(Coding value) {
            this.diagnosis = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequence", "positiveInt", "Sequence of diagnosis which serves to order and provide a link.", 0, Integer.MAX_VALUE, this.sequence));
            childrenList.add(new Property("diagnosis", "Coding", "The diagnosis.", 0, Integer.MAX_VALUE, this.diagnosis));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("diagnosis")) {
                this.diagnosis = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.sequence");
            }
            if (name.equals("diagnosis")) {
                this.diagnosis = new Coding();
                return this.diagnosis;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosisComponent copy() {
            DiagnosisComponent dst = new DiagnosisComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.diagnosis = this.diagnosis == null ? null : this.diagnosis.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other;
            return DiagnosisComponent.compareDeep(this.sequence, o.sequence, true) && DiagnosisComponent.compareDeep(this.diagnosis, o.diagnosis, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other;
            return DiagnosisComponent.compareValues(this.sequence, o.sequence, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.diagnosis != null && !this.diagnosis.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Claim.diagnosis";
        }
    }

    @Block
    public static class PayeeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Party to be paid any benefits payable", formalDefinition="Party to be reimbursed: Subscriber, provider, other.")
        protected Coding type;
        @Child(name="provider", type={Practitioner.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Provider who is the payee", formalDefinition="The provider who is to be reimbursed for the claim (the party to whom any benefit is assigned).")
        protected Reference provider;
        protected Practitioner providerTarget;
        @Child(name="organization", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Organization who is the payee", formalDefinition="The organization who is to be reimbursed for the claim (the party to whom any benefit is assigned).")
        protected Reference organization;
        protected Organization organizationTarget;
        @Child(name="person", type={Patient.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Other person who is the payee", formalDefinition="The person other than the subscriber who is to be reimbursed for the claim (the party to whom any benefit is assigned).")
        protected Reference person;
        protected Patient personTarget;
        private static final long serialVersionUID = -503108488L;

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PayeeComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Reference getProvider() {
            if (this.provider == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.provider");
                }
                if (Configuration.doAutoCreate()) {
                    this.provider = new Reference();
                }
            }
            return this.provider;
        }

        public boolean hasProvider() {
            return this.provider != null && !this.provider.isEmpty();
        }

        public PayeeComponent setProvider(Reference value) {
            this.provider = value;
            return this;
        }

        public Practitioner getProviderTarget() {
            if (this.providerTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.provider");
                }
                if (Configuration.doAutoCreate()) {
                    this.providerTarget = new Practitioner();
                }
            }
            return this.providerTarget;
        }

        public PayeeComponent setProviderTarget(Practitioner value) {
            this.providerTarget = value;
            return this;
        }

        public Reference getOrganization() {
            if (this.organization == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.organization");
                }
                if (Configuration.doAutoCreate()) {
                    this.organization = new Reference();
                }
            }
            return this.organization;
        }

        public boolean hasOrganization() {
            return this.organization != null && !this.organization.isEmpty();
        }

        public PayeeComponent setOrganization(Reference value) {
            this.organization = value;
            return this;
        }

        public Organization getOrganizationTarget() {
            if (this.organizationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.organization");
                }
                if (Configuration.doAutoCreate()) {
                    this.organizationTarget = new Organization();
                }
            }
            return this.organizationTarget;
        }

        public PayeeComponent setOrganizationTarget(Organization value) {
            this.organizationTarget = value;
            return this;
        }

        public Reference getPerson() {
            if (this.person == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.person");
                }
                if (Configuration.doAutoCreate()) {
                    this.person = new Reference();
                }
            }
            return this.person;
        }

        public boolean hasPerson() {
            return this.person != null && !this.person.isEmpty();
        }

        public PayeeComponent setPerson(Reference value) {
            this.person = value;
            return this;
        }

        public Patient getPersonTarget() {
            if (this.personTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.person");
                }
                if (Configuration.doAutoCreate()) {
                    this.personTarget = new Patient();
                }
            }
            return this.personTarget;
        }

        public PayeeComponent setPersonTarget(Patient value) {
            this.personTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "Coding", "Party to be reimbursed: Subscriber, provider, other.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property(Claim.SP_PROVIDER, "Reference(Practitioner)", "The provider who is to be reimbursed for the claim (the party to whom any benefit is assigned).", 0, Integer.MAX_VALUE, this.provider));
            childrenList.add(new Property("organization", "Reference(Organization)", "The organization who is to be reimbursed for the claim (the party to whom any benefit is assigned).", 0, Integer.MAX_VALUE, this.organization));
            childrenList.add(new Property("person", "Reference(Patient)", "The person other than the subscriber who is to be reimbursed for the claim (the party to whom any benefit is assigned).", 0, Integer.MAX_VALUE, this.person));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals(Claim.SP_PROVIDER)) {
                this.provider = this.castToReference(value);
            } else if (name.equals("organization")) {
                this.organization = this.castToReference(value);
            } else if (name.equals("person")) {
                this.person = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals(Claim.SP_PROVIDER)) {
                this.provider = new Reference();
                return this.provider;
            }
            if (name.equals("organization")) {
                this.organization = new Reference();
                return this.organization;
            }
            if (name.equals("person")) {
                this.person = new Reference();
                return this.person;
            }
            return super.addChild(name);
        }

        @Override
        public PayeeComponent copy() {
            PayeeComponent dst = new PayeeComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.provider = this.provider == null ? null : this.provider.copy();
            dst.organization = this.organization == null ? null : this.organization.copy();
            dst.person = this.person == null ? null : this.person.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof PayeeComponent)) {
                return false;
            }
            PayeeComponent o = (PayeeComponent)other;
            return PayeeComponent.compareDeep(this.type, o.type, true) && PayeeComponent.compareDeep(this.provider, o.provider, true) && PayeeComponent.compareDeep(this.organization, o.organization, true) && PayeeComponent.compareDeep(this.person, o.person, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof PayeeComponent)) {
                return false;
            }
            PayeeComponent o = (PayeeComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.provider != null && !this.provider.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.person != null && !this.person.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Claim.payee";
        }
    }

    public static class UseEnumFactory
    implements EnumFactory<Use> {
        @Override
        public Use fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return Use.COMPLETE;
            }
            if ("proposed".equals(codeString)) {
                return Use.PROPOSED;
            }
            if ("exploratory".equals(codeString)) {
                return Use.EXPLORATORY;
            }
            if ("other".equals(codeString)) {
                return Use.OTHER;
            }
            throw new IllegalArgumentException("Unknown Use code '" + codeString + "'");
        }

        public Enumeration<Use> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return new Enumeration<Use>(this, Use.COMPLETE);
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<Use>(this, Use.PROPOSED);
            }
            if ("exploratory".equals(codeString)) {
                return new Enumeration<Use>(this, Use.EXPLORATORY);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<Use>(this, Use.OTHER);
            }
            throw new FHIRException("Unknown Use code '" + codeString + "'");
        }

        @Override
        public String toCode(Use code) {
            if (code == Use.NULL) {
                return null;
            }
            if (code == Use.COMPLETE) {
                return "complete";
            }
            if (code == Use.PROPOSED) {
                return "proposed";
            }
            if (code == Use.EXPLORATORY) {
                return "exploratory";
            }
            if (code == Use.OTHER) {
                return "other";
            }
            return "?";
        }
    }

    public static enum Use {
        COMPLETE,
        PROPOSED,
        EXPLORATORY,
        OTHER,
        NULL;


        public static Use fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return COMPLETE;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("exploratory".equals(codeString)) {
                return EXPLORATORY;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            throw new FHIRException("Unknown Use code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case COMPLETE: {
                    return "complete";
                }
                case PROPOSED: {
                    return "proposed";
                }
                case EXPLORATORY: {
                    return "exploratory";
                }
                case OTHER: {
                    return "other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case COMPLETE: {
                    return "http://hl7.org/fhir/claim-use-link";
                }
                case PROPOSED: {
                    return "http://hl7.org/fhir/claim-use-link";
                }
                case EXPLORATORY: {
                    return "http://hl7.org/fhir/claim-use-link";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/claim-use-link";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case COMPLETE: {
                    return "The treatment is complete and this represents a Claim for the services.";
                }
                case PROPOSED: {
                    return "The treatment is proposed and this represents a Pre-authorization for the services.";
                }
                case EXPLORATORY: {
                    return "The treatment is proposed and this represents a Pre-determination for the services.";
                }
                case OTHER: {
                    return "A locally defined or otherwise resolved status.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case COMPLETE: {
                    return "Complete";
                }
                case PROPOSED: {
                    return "Proposed";
                }
                case EXPLORATORY: {
                    return "Exploratory";
                }
                case OTHER: {
                    return "Other";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ClaimTypeEnumFactory
    implements EnumFactory<ClaimType> {
        @Override
        public ClaimType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("institutional".equals(codeString)) {
                return ClaimType.INSTITUTIONAL;
            }
            if ("oral".equals(codeString)) {
                return ClaimType.ORAL;
            }
            if ("pharmacy".equals(codeString)) {
                return ClaimType.PHARMACY;
            }
            if ("professional".equals(codeString)) {
                return ClaimType.PROFESSIONAL;
            }
            if ("vision".equals(codeString)) {
                return ClaimType.VISION;
            }
            throw new IllegalArgumentException("Unknown ClaimType code '" + codeString + "'");
        }

        public Enumeration<ClaimType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("institutional".equals(codeString)) {
                return new Enumeration<ClaimType>(this, ClaimType.INSTITUTIONAL);
            }
            if ("oral".equals(codeString)) {
                return new Enumeration<ClaimType>(this, ClaimType.ORAL);
            }
            if ("pharmacy".equals(codeString)) {
                return new Enumeration<ClaimType>(this, ClaimType.PHARMACY);
            }
            if ("professional".equals(codeString)) {
                return new Enumeration<ClaimType>(this, ClaimType.PROFESSIONAL);
            }
            if ("vision".equals(codeString)) {
                return new Enumeration<ClaimType>(this, ClaimType.VISION);
            }
            throw new FHIRException("Unknown ClaimType code '" + codeString + "'");
        }

        @Override
        public String toCode(ClaimType code) {
            if (code == ClaimType.NULL) {
                return null;
            }
            if (code == ClaimType.INSTITUTIONAL) {
                return "institutional";
            }
            if (code == ClaimType.ORAL) {
                return "oral";
            }
            if (code == ClaimType.PHARMACY) {
                return "pharmacy";
            }
            if (code == ClaimType.PROFESSIONAL) {
                return "professional";
            }
            if (code == ClaimType.VISION) {
                return "vision";
            }
            return "?";
        }
    }

    public static enum ClaimType {
        INSTITUTIONAL,
        ORAL,
        PHARMACY,
        PROFESSIONAL,
        VISION,
        NULL;


        public static ClaimType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("institutional".equals(codeString)) {
                return INSTITUTIONAL;
            }
            if ("oral".equals(codeString)) {
                return ORAL;
            }
            if ("pharmacy".equals(codeString)) {
                return PHARMACY;
            }
            if ("professional".equals(codeString)) {
                return PROFESSIONAL;
            }
            if ("vision".equals(codeString)) {
                return VISION;
            }
            throw new FHIRException("Unknown ClaimType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INSTITUTIONAL: {
                    return "institutional";
                }
                case ORAL: {
                    return "oral";
                }
                case PHARMACY: {
                    return "pharmacy";
                }
                case PROFESSIONAL: {
                    return "professional";
                }
                case VISION: {
                    return "vision";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INSTITUTIONAL: {
                    return "http://hl7.org/fhir/claim-type-link";
                }
                case ORAL: {
                    return "http://hl7.org/fhir/claim-type-link";
                }
                case PHARMACY: {
                    return "http://hl7.org/fhir/claim-type-link";
                }
                case PROFESSIONAL: {
                    return "http://hl7.org/fhir/claim-type-link";
                }
                case VISION: {
                    return "http://hl7.org/fhir/claim-type-link";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INSTITUTIONAL: {
                    return "A claim for Institution based, typically in-patient, goods and services.";
                }
                case ORAL: {
                    return "A claim for Oral Health (Dentist, Denturist, Hygienist) goods and services.";
                }
                case PHARMACY: {
                    return "A claim for Pharmacy based goods and services.";
                }
                case PROFESSIONAL: {
                    return "A claim for Professional, typically out-patient, goods and services.";
                }
                case VISION: {
                    return "A claim for Vision (Ophthamologist, Optometrist and Optician) goods and services.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INSTITUTIONAL: {
                    return "Institutional";
                }
                case ORAL: {
                    return "Oral Health";
                }
                case PHARMACY: {
                    return "Pharmacy";
                }
                case PROFESSIONAL: {
                    return "Professional";
                }
                case VISION: {
                    return "Vision";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

