/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.IdType;
import org.hl7.fhir.dstu2.model.InstantType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Meta")
public class Meta
extends Type
implements IBaseMetaType {
    @Child(name="versionId", type={IdType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Version specific identifier", formalDefinition="The version specific identifier, as it appears in the version portion of the URL. This values changes when the resource is created, updated, or deleted.")
    protected IdType versionId;
    @Child(name="lastUpdated", type={InstantType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the resource version last changed", formalDefinition="When the resource last changed - e.g. when the version changed.")
    protected InstantType lastUpdated;
    @Child(name="profile", type={UriType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Profiles this resource claims to conform to", formalDefinition="A list of profiles [[[StructureDefinition]]]s that this resource claims to conform to. The URL is a reference to [[[StructureDefinition.url]]].")
    protected List<UriType> profile;
    @Child(name="security", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Security Labels applied to this resource", formalDefinition="Security labels applied to this resource. These tags connect specific resources to the overall security policy and infrastructure.")
    protected List<Coding> security;
    @Child(name="tag", type={Coding.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Tags applied to this resource", formalDefinition="Tags applied to this resource. Tags are intended to be used to identify and relate resources to process and workflow, and applications are not required to consider the tags when interpreting the meaning of a resource.")
    protected List<Coding> tag;
    private static final long serialVersionUID = 867134915L;

    public IdType getVersionIdElement() {
        if (this.versionId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Meta.versionId");
            }
            if (Configuration.doAutoCreate()) {
                this.versionId = new IdType();
            }
        }
        return this.versionId;
    }

    public boolean hasVersionIdElement() {
        return this.versionId != null && !this.versionId.isEmpty();
    }

    public boolean hasVersionId() {
        return this.versionId != null && !this.versionId.isEmpty();
    }

    public Meta setVersionIdElement(IdType value) {
        this.versionId = value;
        return this;
    }

    public String getVersionId() {
        return this.versionId == null ? null : this.versionId.getValue();
    }

    public Meta setVersionId(String value) {
        if (Utilities.noString((String)value)) {
            this.versionId = null;
        } else {
            if (this.versionId == null) {
                this.versionId = new IdType();
            }
            this.versionId.setValue(value);
        }
        return this;
    }

    public InstantType getLastUpdatedElement() {
        if (this.lastUpdated == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Meta.lastUpdated");
            }
            if (Configuration.doAutoCreate()) {
                this.lastUpdated = new InstantType();
            }
        }
        return this.lastUpdated;
    }

    public boolean hasLastUpdatedElement() {
        return this.lastUpdated != null && !this.lastUpdated.isEmpty();
    }

    public boolean hasLastUpdated() {
        return this.lastUpdated != null && !this.lastUpdated.isEmpty();
    }

    public Meta setLastUpdatedElement(InstantType value) {
        this.lastUpdated = value;
        return this;
    }

    public Date getLastUpdated() {
        return this.lastUpdated == null ? null : (Date)this.lastUpdated.getValue();
    }

    public Meta setLastUpdated(Date value) {
        if (value == null) {
            this.lastUpdated = null;
        } else {
            if (this.lastUpdated == null) {
                this.lastUpdated = new InstantType();
            }
            this.lastUpdated.setValue(value);
        }
        return this;
    }

    public List<UriType> getProfile() {
        if (this.profile == null) {
            this.profile = new ArrayList<UriType>();
        }
        return this.profile;
    }

    public boolean hasProfile() {
        if (this.profile == null) {
            return false;
        }
        for (UriType item : this.profile) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addProfileElement() {
        UriType t = new UriType();
        if (this.profile == null) {
            this.profile = new ArrayList<UriType>();
        }
        this.profile.add(t);
        return t;
    }

    public Meta addProfile(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.profile == null) {
            this.profile = new ArrayList<UriType>();
        }
        this.profile.add(t);
        return this;
    }

    public boolean hasProfile(String value) {
        if (this.profile == null) {
            return false;
        }
        for (UriType v : this.profile) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Coding> getSecurity() {
        if (this.security == null) {
            this.security = new ArrayList<Coding>();
        }
        return this.security;
    }

    public Coding getSecurity(String theSystem, String theCode) {
        for (Coding next : this.getSecurity()) {
            if (!ObjectUtil.equals((Object)next.getSystem(), (Object)theSystem) || !ObjectUtil.equals((Object)next.getCode(), (Object)theCode)) continue;
            return next;
        }
        return null;
    }

    public boolean hasSecurity() {
        if (this.security == null) {
            return false;
        }
        for (Coding item : this.security) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addSecurity() {
        Coding t = new Coding();
        if (this.security == null) {
            this.security = new ArrayList<Coding>();
        }
        this.security.add(t);
        return t;
    }

    public Meta addSecurity(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.security == null) {
            this.security = new ArrayList<Coding>();
        }
        this.security.add(t);
        return this;
    }

    public List<Coding> getTag() {
        if (this.tag == null) {
            this.tag = new ArrayList<Coding>();
        }
        return this.tag;
    }

    public Coding getTag(String theSystem, String theCode) {
        for (Coding next : this.getTag()) {
            if (!ObjectUtil.equals((Object)next.getSystem(), (Object)theSystem) || !ObjectUtil.equals((Object)next.getCode(), (Object)theCode)) continue;
            return next;
        }
        return null;
    }

    public boolean hasTag() {
        if (this.tag == null) {
            return false;
        }
        for (Coding item : this.tag) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addTag() {
        Coding t = new Coding();
        if (this.tag == null) {
            this.tag = new ArrayList<Coding>();
        }
        this.tag.add(t);
        return t;
    }

    public Meta addTag(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.tag == null) {
            this.tag = new ArrayList<Coding>();
        }
        this.tag.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("versionId", "id", "The version specific identifier, as it appears in the version portion of the URL. This values changes when the resource is created, updated, or deleted.", 0, Integer.MAX_VALUE, this.versionId));
        childrenList.add(new Property("lastUpdated", "instant", "When the resource last changed - e.g. when the version changed.", 0, Integer.MAX_VALUE, this.lastUpdated));
        childrenList.add(new Property("profile", "uri", "A list of profiles [[[StructureDefinition]]]s that this resource claims to conform to. The URL is a reference to [[[StructureDefinition.url]]].", 0, Integer.MAX_VALUE, this.profile));
        childrenList.add(new Property("security", "Coding", "Security labels applied to this resource. These tags connect specific resources to the overall security policy and infrastructure.", 0, Integer.MAX_VALUE, this.security));
        childrenList.add(new Property("tag", "Coding", "Tags applied to this resource. Tags are intended to be used to identify and relate resources to process and workflow, and applications are not required to consider the tags when interpreting the meaning of a resource.", 0, Integer.MAX_VALUE, this.tag));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("versionId")) {
            this.versionId = this.castToId(value);
        } else if (name.equals("lastUpdated")) {
            this.lastUpdated = this.castToInstant(value);
        } else if (name.equals("profile")) {
            this.getProfile().add(this.castToUri(value));
        } else if (name.equals("security")) {
            this.getSecurity().add(this.castToCoding(value));
        } else if (name.equals("tag")) {
            this.getTag().add(this.castToCoding(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("versionId")) {
            throw new FHIRException("Cannot call addChild on a singleton property Meta.versionId");
        }
        if (name.equals("lastUpdated")) {
            throw new FHIRException("Cannot call addChild on a singleton property Meta.lastUpdated");
        }
        if (name.equals("profile")) {
            throw new FHIRException("Cannot call addChild on a singleton property Meta.profile");
        }
        if (name.equals("security")) {
            return this.addSecurity();
        }
        if (name.equals("tag")) {
            return this.addTag();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Meta";
    }

    @Override
    public Meta copy() {
        Meta dst = new Meta();
        this.copyValues(dst);
        dst.versionId = this.versionId == null ? null : this.versionId.copy();
        InstantType instantType = dst.lastUpdated = this.lastUpdated == null ? null : this.lastUpdated.copy();
        if (this.profile != null) {
            dst.profile = new ArrayList<UriType>();
            for (UriType uriType : this.profile) {
                dst.profile.add(uriType.copy());
            }
        }
        if (this.security != null) {
            dst.security = new ArrayList<Coding>();
            for (Coding coding : this.security) {
                dst.security.add(coding.copy());
            }
        }
        if (this.tag != null) {
            dst.tag = new ArrayList<Coding>();
            for (Coding coding : this.tag) {
                dst.tag.add(coding.copy());
            }
        }
        return dst;
    }

    @Override
    protected Meta typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Meta)) {
            return false;
        }
        Meta o = (Meta)other;
        return Meta.compareDeep(this.versionId, o.versionId, true) && Meta.compareDeep(this.lastUpdated, o.lastUpdated, true) && Meta.compareDeep(this.profile, o.profile, true) && Meta.compareDeep(this.security, o.security, true) && Meta.compareDeep(this.tag, o.tag, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Meta)) {
            return false;
        }
        Meta o = (Meta)other;
        return Meta.compareValues(this.versionId, o.versionId, true) && Meta.compareValues(this.lastUpdated, o.lastUpdated, true) && Meta.compareValues(this.profile, o.profile, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.versionId != null && !this.versionId.isEmpty() || this.lastUpdated != null && !this.lastUpdated.isEmpty() || this.profile != null && !this.profile.isEmpty() || this.security != null && !this.security.isEmpty() || this.tag != null && !this.tag.isEmpty());
    }
}

