/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;

@DatatypeDef(name="Range")
public class Range
extends Type
implements ICompositeType {
    @Child(name="low", type={SimpleQuantity.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Low limit", formalDefinition="The low limit. The boundary is inclusive.")
    protected SimpleQuantity low;
    @Child(name="high", type={SimpleQuantity.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="High limit", formalDefinition="The high limit. The boundary is inclusive.")
    protected SimpleQuantity high;
    private static final long serialVersionUID = 1699187994L;

    public SimpleQuantity getLow() {
        if (this.low == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Range.low");
            }
            if (Configuration.doAutoCreate()) {
                this.low = new SimpleQuantity();
            }
        }
        return this.low;
    }

    public boolean hasLow() {
        return this.low != null && !this.low.isEmpty();
    }

    public Range setLow(SimpleQuantity value) {
        this.low = value;
        return this;
    }

    public SimpleQuantity getHigh() {
        if (this.high == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Range.high");
            }
            if (Configuration.doAutoCreate()) {
                this.high = new SimpleQuantity();
            }
        }
        return this.high;
    }

    public boolean hasHigh() {
        return this.high != null && !this.high.isEmpty();
    }

    public Range setHigh(SimpleQuantity value) {
        this.high = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("low", "SimpleQuantity", "The low limit. The boundary is inclusive.", 0, Integer.MAX_VALUE, this.low));
        childrenList.add(new Property("high", "SimpleQuantity", "The high limit. The boundary is inclusive.", 0, Integer.MAX_VALUE, this.high));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("low")) {
            this.low = this.castToSimpleQuantity(value);
        } else if (name.equals("high")) {
            this.high = this.castToSimpleQuantity(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("low")) {
            this.low = new SimpleQuantity();
            return this.low;
        }
        if (name.equals("high")) {
            this.high = new SimpleQuantity();
            return this.high;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Range";
    }

    @Override
    public Range copy() {
        Range dst = new Range();
        this.copyValues(dst);
        dst.low = this.low == null ? null : this.low.copy();
        dst.high = this.high == null ? null : this.high.copy();
        return dst;
    }

    @Override
    protected Range typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Range)) {
            return false;
        }
        Range o = (Range)other;
        return Range.compareDeep(this.low, o.low, true) && Range.compareDeep(this.high, o.high, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Range)) {
            return false;
        }
        Range o = (Range)other;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.low != null && !this.low.isEmpty() || this.high != null && !this.high.isEmpty());
    }
}

