/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.exceptions.FHIRException;

@ResourceDef(name="PaymentNotice", profile="http://hl7.org/fhir/Profile/PaymentNotice")
public class PaymentNotice
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="ruleset", type={Coding.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Resource version", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    protected Coding ruleset;
    @Child(name="originalRuleset", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Original version", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    protected Coding originalRuleset;
    @Child(name="created", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when this resource was created.")
    protected DateTimeType created;
    @Child(name="target", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer or Regulatory body", formalDefinition="The Insurer who is target  of the request.")
    protected Reference target;
    protected Organization targetTarget;
    @Child(name="provider", type={Practitioner.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference provider;
    protected Practitioner providerTarget;
    @Child(name="organization", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    protected Reference organization;
    protected Organization organizationTarget;
    @Child(name="request", type={}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Request reference", formalDefinition="Reference of resource to reverse.")
    protected Reference request;
    protected Resource requestTarget;
    @Child(name="response", type={}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Response reference", formalDefinition="Reference of response to resource to reverse.")
    protected Reference response;
    protected Resource responseTarget;
    @Child(name="paymentStatus", type={Coding.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Status of the payment", formalDefinition="The payment status, typically paid: payment sent, cleared: payment received.")
    protected Coding paymentStatus;
    private static final long serialVersionUID = -394826458L;
    @SearchParamDefinition(name="identifier", path="PaymentNotice.identifier", description="The business identifier of the Eligibility", type="token")
    public static final String SP_IDENTIFIER = "identifier";

    public PaymentNotice() {
    }

    public PaymentNotice(Coding paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PaymentNotice addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Coding getRuleset() {
        if (this.ruleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.ruleset");
            }
            if (Configuration.doAutoCreate()) {
                this.ruleset = new Coding();
            }
        }
        return this.ruleset;
    }

    public boolean hasRuleset() {
        return this.ruleset != null && !this.ruleset.isEmpty();
    }

    public PaymentNotice setRuleset(Coding value) {
        this.ruleset = value;
        return this;
    }

    public Coding getOriginalRuleset() {
        if (this.originalRuleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.originalRuleset");
            }
            if (Configuration.doAutoCreate()) {
                this.originalRuleset = new Coding();
            }
        }
        return this.originalRuleset;
    }

    public boolean hasOriginalRuleset() {
        return this.originalRuleset != null && !this.originalRuleset.isEmpty();
    }

    public PaymentNotice setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public PaymentNotice setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public PaymentNotice setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getTarget() {
        if (this.target == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.target");
            }
            if (Configuration.doAutoCreate()) {
                this.target = new Reference();
            }
        }
        return this.target;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public PaymentNotice setTarget(Reference value) {
        this.target = value;
        return this;
    }

    public Organization getTargetTarget() {
        if (this.targetTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.target");
            }
            if (Configuration.doAutoCreate()) {
                this.targetTarget = new Organization();
            }
        }
        return this.targetTarget;
    }

    public PaymentNotice setTargetTarget(Organization value) {
        this.targetTarget = value;
        return this;
    }

    public Reference getProvider() {
        if (this.provider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.provider = new Reference();
            }
        }
        return this.provider;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public PaymentNotice setProvider(Reference value) {
        this.provider = value;
        return this;
    }

    public Practitioner getProviderTarget() {
        if (this.providerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.providerTarget = new Practitioner();
            }
        }
        return this.providerTarget;
    }

    public PaymentNotice setProviderTarget(Practitioner value) {
        this.providerTarget = value;
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public PaymentNotice setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Organization getOrganizationTarget() {
        if (this.organizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organizationTarget = new Organization();
            }
        }
        return this.organizationTarget;
    }

    public PaymentNotice setOrganizationTarget(Organization value) {
        this.organizationTarget = value;
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public PaymentNotice setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Resource getRequestTarget() {
        return this.requestTarget;
    }

    public PaymentNotice setRequestTarget(Resource value) {
        this.requestTarget = value;
        return this;
    }

    public Reference getResponse() {
        if (this.response == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.response");
            }
            if (Configuration.doAutoCreate()) {
                this.response = new Reference();
            }
        }
        return this.response;
    }

    public boolean hasResponse() {
        return this.response != null && !this.response.isEmpty();
    }

    public PaymentNotice setResponse(Reference value) {
        this.response = value;
        return this;
    }

    public Resource getResponseTarget() {
        return this.responseTarget;
    }

    public PaymentNotice setResponseTarget(Resource value) {
        this.responseTarget = value;
        return this;
    }

    public Coding getPaymentStatus() {
        if (this.paymentStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentNotice.paymentStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentStatus = new Coding();
            }
        }
        return this.paymentStatus;
    }

    public boolean hasPaymentStatus() {
        return this.paymentStatus != null && !this.paymentStatus.isEmpty();
    }

    public PaymentNotice setPaymentStatus(Coding value) {
        this.paymentStatus = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("ruleset", "Coding", "The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.", 0, Integer.MAX_VALUE, this.ruleset));
        childrenList.add(new Property("originalRuleset", "Coding", "The style (standard) and version of the original material which was converted into this resource.", 0, Integer.MAX_VALUE, this.originalRuleset));
        childrenList.add(new Property("created", "dateTime", "The date when this resource was created.", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property("target", "Reference(Organization)", "The Insurer who is target  of the request.", 0, Integer.MAX_VALUE, this.target));
        childrenList.add(new Property("provider", "Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.provider));
        childrenList.add(new Property("organization", "Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.organization));
        childrenList.add(new Property("request", "Reference(Any)", "Reference of resource to reverse.", 0, Integer.MAX_VALUE, this.request));
        childrenList.add(new Property("response", "Reference(Any)", "Reference of response to resource to reverse.", 0, Integer.MAX_VALUE, this.response));
        childrenList.add(new Property("paymentStatus", "Coding", "The payment status, typically paid: payment sent, cleared: payment received.", 0, Integer.MAX_VALUE, this.paymentStatus));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("ruleset")) {
            this.ruleset = this.castToCoding(value);
        } else if (name.equals("originalRuleset")) {
            this.originalRuleset = this.castToCoding(value);
        } else if (name.equals("created")) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("target")) {
            this.target = this.castToReference(value);
        } else if (name.equals("provider")) {
            this.provider = this.castToReference(value);
        } else if (name.equals("organization")) {
            this.organization = this.castToReference(value);
        } else if (name.equals("request")) {
            this.request = this.castToReference(value);
        } else if (name.equals("response")) {
            this.response = this.castToReference(value);
        } else if (name.equals("paymentStatus")) {
            this.paymentStatus = this.castToCoding(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("ruleset")) {
            this.ruleset = new Coding();
            return this.ruleset;
        }
        if (name.equals("originalRuleset")) {
            this.originalRuleset = new Coding();
            return this.originalRuleset;
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a singleton property PaymentNotice.created");
        }
        if (name.equals("target")) {
            this.target = new Reference();
            return this.target;
        }
        if (name.equals("provider")) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals("organization")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("request")) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals("response")) {
            this.response = new Reference();
            return this.response;
        }
        if (name.equals("paymentStatus")) {
            this.paymentStatus = new Coding();
            return this.paymentStatus;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PaymentNotice";
    }

    @Override
    public PaymentNotice copy() {
        PaymentNotice dst = new PaymentNotice();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.ruleset = this.ruleset == null ? null : this.ruleset.copy();
        dst.originalRuleset = this.originalRuleset == null ? null : this.originalRuleset.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.target = this.target == null ? null : this.target.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.response = this.response == null ? null : this.response.copy();
        dst.paymentStatus = this.paymentStatus == null ? null : this.paymentStatus.copy();
        return dst;
    }

    protected PaymentNotice typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof PaymentNotice)) {
            return false;
        }
        PaymentNotice o = (PaymentNotice)other;
        return PaymentNotice.compareDeep(this.identifier, o.identifier, true) && PaymentNotice.compareDeep(this.ruleset, o.ruleset, true) && PaymentNotice.compareDeep(this.originalRuleset, o.originalRuleset, true) && PaymentNotice.compareDeep(this.created, o.created, true) && PaymentNotice.compareDeep(this.target, o.target, true) && PaymentNotice.compareDeep(this.provider, o.provider, true) && PaymentNotice.compareDeep(this.organization, o.organization, true) && PaymentNotice.compareDeep(this.request, o.request, true) && PaymentNotice.compareDeep(this.response, o.response, true) && PaymentNotice.compareDeep(this.paymentStatus, o.paymentStatus, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof PaymentNotice)) {
            return false;
        }
        PaymentNotice o = (PaymentNotice)other;
        return PaymentNotice.compareValues(this.created, o.created, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.ruleset != null && !this.ruleset.isEmpty() || this.originalRuleset != null && !this.originalRuleset.isEmpty() || this.created != null && !this.created.isEmpty() || this.target != null && !this.target.isEmpty() || this.provider != null && !this.provider.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.request != null && !this.request.isEmpty() || this.response != null && !this.response.isEmpty() || this.paymentStatus != null && !this.paymentStatus.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PaymentNotice;
    }
}

