/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.utils.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpHost;
import org.hl7.fhir.dstu2.model.Bundle;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.Conformance;
import org.hl7.fhir.dstu2.model.OperationOutcome;
import org.hl7.fhir.dstu2.model.Parameters;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.utils.client.ClientUtils;
import org.hl7.fhir.dstu2.utils.client.EFhirClientException;
import org.hl7.fhir.dstu2.utils.client.ResourceAddress;
import org.hl7.fhir.dstu2.utils.client.ResourceFormat;
import org.hl7.fhir.dstu2.utils.client.ResourceRequest;
import org.hl7.fhir.utilities.FHIRBaseToolingClient;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;

public class FHIRToolingClient
extends FHIRBaseToolingClient {
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssK";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String hostKey = "http.proxyHost";
    public static final String portKey = "http.proxyPort";
    private String base;
    private ResourceAddress resourceAddress;
    private ResourceFormat preferredResourceFormat = ResourceFormat.RESOURCE_XML;
    private HttpHost proxy;
    private int maxResultSetSize = -1;
    private Conformance conf;
    private ClientUtils utils = this.getClientUtils();
    private int useCount;

    protected ClientUtils getClientUtils() {
        return new ClientUtils();
    }

    public FHIRToolingClient(String baseServiceUrl, String userAgent) throws URISyntaxException {
        this.utils.setUserAgent(userAgent);
        this.initialize(baseServiceUrl);
    }

    public void initialize(String baseServiceUrl) throws URISyntaxException {
        this.base = baseServiceUrl;
        this.resourceAddress = new ResourceAddress(baseServiceUrl);
        this.maxResultSetSize = -1;
        this.checkConformance();
    }

    private void checkConformance() {
        try {
            this.conf = this.getConformanceStatementQuick();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getPreferredResourceFormat() {
        return this.preferredResourceFormat.getHeader();
    }

    public void setPreferredResourceFormat(ResourceFormat resourceFormat) {
        this.preferredResourceFormat = resourceFormat;
    }

    public int getMaximumRecordCount() {
        return this.maxResultSetSize;
    }

    public void setMaximumRecordCount(int maxResultSetSize) {
        this.maxResultSetSize = maxResultSetSize;
    }

    public Conformance getConformanceStatement() throws EFhirClientException {
        if (this.conf != null) {
            return this.conf;
        }
        return this.getConformanceStatement(false);
    }

    public Conformance getConformanceStatement(boolean useOptionsVerb) {
        Conformance conformance = null;
        try {
            conformance = useOptionsVerb ? (Conformance)this.utils.issueOptionsRequest(this.resourceAddress.getBaseServiceUri(), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutNormal).getReference() : (Conformance)this.utils.issueGetResourceRequest(this.resourceAddress.resolveMetadataUri(false), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutNormal).getReference();
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to fetch the server's conformance statement", e);
        }
        return conformance;
    }

    public Conformance getConformanceStatementQuick() throws EFhirClientException {
        if (this.conf != null) {
            return this.conf;
        }
        return this.getConformanceStatementQuick(false);
    }

    public Conformance getConformanceStatementQuick(boolean useOptionsVerb) {
        Conformance conformance = null;
        try {
            conformance = useOptionsVerb ? (Conformance)this.utils.issueOptionsRequest(this.resourceAddress.getBaseServiceUri(), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutNormal).getReference() : (Conformance)this.utils.issueGetResourceRequest(this.resourceAddress.resolveMetadataUri(true), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutNormal).getReference();
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to fetch the server's conformance statement", e);
        }
        return conformance;
    }

    public <T extends Resource> T read(Class<T> resourceClass, String id) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.utils.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resourceClass, id), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutNormal);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addSuccessStatus(200);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to read this resource", e);
        }
        return result.getPayload();
    }

    public <T extends Resource> T vread(Class<T> resourceClass, String id, String version) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.utils.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndIdAndVersion(resourceClass, id, version), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutNormal);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addErrorStatus(405);
            result.addSuccessStatus(200);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to read this version of the resource", e);
        }
        return result.getPayload();
    }

    public <T extends Resource> T getCanonical(Class<T> resourceClass, String canonicalURL) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.utils.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndCanonical(resourceClass, canonicalURL), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutNormal);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addErrorStatus(405);
            result.addSuccessStatus(200);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to read this version of the resource", e);
        }
        Bundle bnd = (Bundle)result.getPayload();
        if (bnd.getEntry().size() == 0) {
            throw new EFhirClientException("No matching resource found for canonical URL '" + canonicalURL + "'");
        }
        if (bnd.getEntry().size() > 1) {
            throw new EFhirClientException("Multiple matching resources found for canonical URL '" + canonicalURL + "'");
        }
        return (T)bnd.getEntry().get(0).getResource();
    }

    public Resource update(Resource resource) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.utils.issuePutRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resource.getClass(), resource.getId()), this.utils.getResourceAsByteArray(resource, false, this.isJson(this.getPreferredResourceFormat())), this.withVer(this.getPreferredResourceFormat(), "1.0"), null, this.timeoutOperation);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addErrorStatus(405);
            result.addErrorStatus(422);
            result.addSuccessStatus(200);
            result.addSuccessStatus(201);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            throw new EFhirClientException("An error has occurred while trying to update this resource", e);
        }
        try {
            OperationOutcome operationOutcome = (OperationOutcome)result.getPayload();
            ResourceAddress.ResourceVersionedIdentifier resVersionedIdentifier = ResourceAddress.parseCreateLocation(result.getLocation());
            return this.vread(resource.getClass(), resVersionedIdentifier.getId(), resVersionedIdentifier.getVersionId());
        }
        catch (ClassCastException classCastException) {
            return result.getPayload();
        }
    }

    public <T extends Resource> T update(Class<T> resourceClass, T resource, String id) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.utils.issuePutRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resourceClass, id), this.utils.getResourceAsByteArray(resource, false, this.isJson(this.getPreferredResourceFormat())), this.withVer(this.getPreferredResourceFormat(), "1.0"), null, this.timeoutOperation);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addErrorStatus(405);
            result.addErrorStatus(422);
            result.addSuccessStatus(200);
            result.addSuccessStatus(201);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            throw new EFhirClientException("An error has occurred while trying to update this resource", e);
        }
        try {
            OperationOutcome operationOutcome = (OperationOutcome)result.getPayload();
            ResourceAddress.ResourceVersionedIdentifier resVersionedIdentifier = ResourceAddress.parseCreateLocation(result.getLocation());
            return this.vread(resourceClass, resVersionedIdentifier.getId(), resVersionedIdentifier.getVersionId());
        }
        catch (ClassCastException classCastException) {
            return result.getPayload();
        }
    }

    public <T extends Resource> Parameters operateType(Class<T> resourceClass, String name, Parameters params) {
        this.recordUse();
        boolean complex = false;
        for (Parameters.ParametersParameterComponent p : params.getParameter()) {
            complex = complex || !(p.getValue() instanceof PrimitiveType);
        }
        Object searchResults = null;
        Object ps = "";
        if (!complex) {
            for (Parameters.ParametersParameterComponent p : params.getParameter()) {
                if (!(p.getValue() instanceof PrimitiveType)) continue;
                ps = (String)ps + p.getName() + "=" + Utilities.encodeUri((String)((PrimitiveType)p.getValue()).asStringValue()) + "&";
            }
        }
        ResourceRequest result = complex ? this.utils.issuePostRequest(this.resourceAddress.resolveOperationURLFromClass(resourceClass, name, (String)ps), this.utils.getResourceAsByteArray(params, false, this.isJson(this.getPreferredResourceFormat())), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutLong) : this.utils.issueGetResourceRequest(this.resourceAddress.resolveOperationURLFromClass(resourceClass, name, (String)ps), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutLong);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addSuccessStatus(200);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        if (result.getPayload() instanceof Parameters) {
            return (Parameters)result.getPayload();
        }
        Parameters p_out = new Parameters();
        p_out.addParameter().setName("return").setResource((Resource)result.getPayload());
        return p_out;
    }

    public Bundle transaction(Bundle batch) {
        this.recordUse();
        Bundle transactionResult = null;
        try {
            transactionResult = this.utils.postBatchRequest(this.resourceAddress.getBaseServiceUri(), this.utils.getFeedAsByteArray(batch, false, this.isJson(this.getPreferredResourceFormat())), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutNormal + batch.getEntry().size());
        }
        catch (Exception e) {
            this.handleException("An error occurred trying to process this transaction request", e);
        }
        return transactionResult;
    }

    public <T extends Resource> OperationOutcome validate(Class<T> resourceClass, T resource, String id) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.utils.issuePostRequest(this.resourceAddress.resolveValidateUri(resourceClass, id), this.utils.getResourceAsByteArray(resource, false, this.isJson(this.getPreferredResourceFormat())), this.withVer(this.getPreferredResourceFormat(), "1.0"), 3);
            result.addErrorStatus(400);
            result.addErrorStatus(422);
            result.addSuccessStatus(200);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to validate this resource", e);
        }
        return (OperationOutcome)result.getPayload();
    }

    protected void handleException(String message, Exception e) throws EFhirClientException {
        if (e instanceof EFhirClientException) {
            throw (EFhirClientException)e;
        }
        throw new EFhirClientException(message, e);
    }

    protected boolean isJson(String format) {
        boolean isJson = false;
        if (format.toLowerCase().contains("json")) {
            isJson = true;
        }
        return isJson;
    }

    public Bundle fetchFeed(String url) {
        this.recordUse();
        Bundle feed = null;
        try {
            feed = this.utils.issueGetFeedRequest(new URI(url), this.getPreferredResourceFormat());
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to retrieve history since last update", e);
        }
        return feed;
    }

    public Parameters lookupCode(Map<String, String> params) {
        this.recordUse();
        ResourceRequest result = this.utils.issueGetResourceRequest(this.resourceAddress.resolveOperationUri(ValueSet.class, "lookup", params), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutNormal);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (Parameters)result.getPayload();
    }

    public Parameters lookupCode(Parameters p) {
        this.recordUse();
        ResourceRequest result = this.utils.issuePostRequest(this.resourceAddress.resolveOperationUri(ValueSet.class, "lookup"), this.utils.getResourceAsByteArray(p, false, this.isJson(this.getPreferredResourceFormat())), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutNormal);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (Parameters)result.getPayload();
    }

    public Parameters translate(Parameters p) {
        this.recordUse();
        ResourceRequest result = this.utils.issuePostRequest(this.resourceAddress.resolveOperationUri(ConceptMap.class, "translate"), this.utils.getResourceAsByteArray(p, false, this.isJson(this.getPreferredResourceFormat())), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutNormal);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (Parameters)result.getPayload();
    }

    public ValueSet expandValueset(ValueSet source, Parameters expParams) {
        this.recordUse();
        Parameters p = expParams == null ? new Parameters() : expParams.copy();
        p.addParameter().setName("valueSet").setResource(source);
        ResourceRequest result = this.utils.issuePostRequest(this.resourceAddress.resolveOperationUri(ValueSet.class, "expand"), this.utils.getResourceAsByteArray(p, false, this.isJson(this.getPreferredResourceFormat())), this.withVer(this.getPreferredResourceFormat(), "1.0"), null, 4);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (ValueSet)result.getPayload();
    }

    public String getAddress() {
        return this.base;
    }

    public ConceptMap initializeClosure(String name) {
        this.recordUse();
        Parameters params = new Parameters();
        params.addParameter().setName("name").setValue(new StringType(name));
        ResourceRequest result = this.utils.issuePostRequest(this.resourceAddress.resolveOperationUri(null, "closure", new HashMap<String, String>()), this.utils.getResourceAsByteArray(params, false, this.isJson(this.getPreferredResourceFormat())), this.withVer(this.getPreferredResourceFormat(), "1.0"), null, this.timeoutNormal);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (ConceptMap)result.getPayload();
    }

    public ConceptMap updateClosure(String name, Coding coding) {
        this.recordUse();
        Parameters params = new Parameters();
        params.addParameter().setName("name").setValue(new StringType(name));
        params.addParameter().setName("concept").setValue(coding);
        ResourceRequest result = this.utils.issuePostRequest(this.resourceAddress.resolveOperationUri(null, "closure", new HashMap<String, String>()), this.utils.getResourceAsByteArray(params, false, this.isJson(this.getPreferredResourceFormat())), this.withVer(this.getPreferredResourceFormat(), "1.0"), null, this.timeoutOperation);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (ConceptMap)result.getPayload();
    }

    public int getTimeout() {
        return this.utils.getTimeout();
    }

    public void setTimeout(int timeout) {
        this.utils.setTimeout(timeout);
    }

    public Parameters getTerminologyCapabilities() {
        return (Parameters)this.utils.issueGetResourceRequest(this.resourceAddress.resolveMetadataTxCaps(), this.withVer(this.getPreferredResourceFormat(), "1.0"), this.timeoutNormal).getReference();
    }

    public ToolingClientLogger getLogger() {
        return this.utils.getLogger();
    }

    public void setLogger(ToolingClientLogger logger) {
        this.utils.setLogger(logger);
    }

    public int getRetryCount() {
        return this.utils.getRetryCount();
    }

    public void setRetryCount(int retryCount) {
        this.utils.setRetryCount(retryCount);
    }

    public String getUserAgent() {
        return this.utils.getUserAgent();
    }

    public void setUserAgent(String userAgent) {
        this.utils.setUserAgent(userAgent);
    }

    public String getServerVersion() {
        return this.conf == null ? null : this.conf.getSoftware().getVersion();
    }

    public void setContentLanguage(String lang) {
        this.utils.setContentLanguage(lang);
    }

    public void setAcceptLanguage(String lang) {
        this.utils.setAcceptLanguage(lang);
    }

    public int getUseCount() {
        return this.useCount;
    }

    private void recordUse() {
        ++this.useCount;
    }

    public Bundle search(String type, String criteria) {
        this.recordUse();
        return this.fetchFeed(Utilities.pathURL((String[])new String[]{this.base, type + criteria}));
    }
}

