/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum GuideResourcePurpose {
    EXAMPLE,
    TERMINOLOGY,
    PROFILE,
    EXTENSION,
    DICTIONARY,
    LOGICAL,
    NULL;


    public static GuideResourcePurpose fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("example".equals(codeString)) {
            return EXAMPLE;
        }
        if ("terminology".equals(codeString)) {
            return TERMINOLOGY;
        }
        if ("profile".equals(codeString)) {
            return PROFILE;
        }
        if ("extension".equals(codeString)) {
            return EXTENSION;
        }
        if ("dictionary".equals(codeString)) {
            return DICTIONARY;
        }
        if ("logical".equals(codeString)) {
            return LOGICAL;
        }
        throw new FHIRException("Unknown GuideResourcePurpose code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EXAMPLE: {
                return "example";
            }
            case TERMINOLOGY: {
                return "terminology";
            }
            case PROFILE: {
                return "profile";
            }
            case EXTENSION: {
                return "extension";
            }
            case DICTIONARY: {
                return "dictionary";
            }
            case LOGICAL: {
                return "logical";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/guide-resource-purpose";
    }

    public String getDefinition() {
        switch (this) {
            case EXAMPLE: {
                return "The resource is intended as an example.";
            }
            case TERMINOLOGY: {
                return "The resource defines a value set or concept map used in the implementation guide.";
            }
            case PROFILE: {
                return "The resource defines a profile (StructureDefinition) that is used in the implementation guide.";
            }
            case EXTENSION: {
                return "The resource defines an extension (StructureDefinition) that is used in the implementation guide.";
            }
            case DICTIONARY: {
                return "The resource contains a dictionary that is part of the implementation guide.";
            }
            case LOGICAL: {
                return "The resource defines a logical model (in a StructureDefinition) that is used in the implementation guide.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EXAMPLE: {
                return "Example";
            }
            case TERMINOLOGY: {
                return "Terminology";
            }
            case PROFILE: {
                return "Profile";
            }
            case EXTENSION: {
                return "Extension";
            }
            case DICTIONARY: {
                return "Dictionary";
            }
            case LOGICAL: {
                return "Logical Model";
            }
        }
        return "?";
    }
}

