/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationDispenseStatus {
    INPROGRESS,
    ONHOLD,
    COMPLETED,
    ENTEREDINERROR,
    STOPPED,
    NULL;


    public static MedicationDispenseStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("on-hold".equals(codeString)) {
            return ONHOLD;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("stopped".equals(codeString)) {
            return STOPPED;
        }
        throw new FHIRException("Unknown MedicationDispenseStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INPROGRESS: {
                return "in-progress";
            }
            case ONHOLD: {
                return "on-hold";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case STOPPED: {
                return "stopped";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/medication-dispense-status";
    }

    public String getDefinition() {
        switch (this) {
            case INPROGRESS: {
                return "The dispense has started but has not yet completed.";
            }
            case ONHOLD: {
                return "Actions implied by the administration have been temporarily halted, but are expected to continue later. May also be called \"suspended\"";
            }
            case COMPLETED: {
                return "All actions that are implied by the dispense have occurred.";
            }
            case ENTEREDINERROR: {
                return "The dispense was entered in error and therefore nullified.";
            }
            case STOPPED: {
                return "Actions implied by the dispense have been permanently halted, before all of them occurred.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INPROGRESS: {
                return "In Progress";
            }
            case ONHOLD: {
                return "On Hold";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in-Error";
            }
            case STOPPED: {
                return "Stopped";
            }
        }
        return "?";
    }
}

