/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ActivityDefinitionCategory {
    DIET,
    DRUG,
    ENCOUNTER,
    OBSERVATION,
    PROCEDURE,
    SUPPLY,
    OTHER,
    NULL;


    public static ActivityDefinitionCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("diet".equals(codeString)) {
            return DIET;
        }
        if ("drug".equals(codeString)) {
            return DRUG;
        }
        if ("encounter".equals(codeString)) {
            return ENCOUNTER;
        }
        if ("observation".equals(codeString)) {
            return OBSERVATION;
        }
        if ("procedure".equals(codeString)) {
            return PROCEDURE;
        }
        if ("supply".equals(codeString)) {
            return SUPPLY;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        throw new FHIRException("Unknown ActivityDefinitionCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DIET: {
                return "diet";
            }
            case DRUG: {
                return "drug";
            }
            case ENCOUNTER: {
                return "encounter";
            }
            case OBSERVATION: {
                return "observation";
            }
            case PROCEDURE: {
                return "procedure";
            }
            case SUPPLY: {
                return "supply";
            }
            case OTHER: {
                return "other";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/activity-definition-category";
    }

    public String getDefinition() {
        switch (this) {
            case DIET: {
                return "To consume food of a specified nature";
            }
            case DRUG: {
                return "To consume/receive a drug, vaccine or other product";
            }
            case ENCOUNTER: {
                return "To meet or communicate with the patient (in-patient, out-patient, phone call, etc.)";
            }
            case OBSERVATION: {
                return "To capture information about a patient (vitals, labs, diagnostic images, etc.)";
            }
            case PROCEDURE: {
                return "To modify the patient in some way (surgery, physiotherapy, education, counseling, etc.)";
            }
            case SUPPLY: {
                return "To provide something to the patient (medication, medical supply, etc.)";
            }
            case OTHER: {
                return "Some other form of action";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DIET: {
                return "Diet";
            }
            case DRUG: {
                return "Drug";
            }
            case ENCOUNTER: {
                return "Encounter";
            }
            case OBSERVATION: {
                return "Observation";
            }
            case PROCEDURE: {
                return "Procedure";
            }
            case SUPPLY: {
                return "Supply";
            }
            case OTHER: {
                return "Other";
            }
        }
        return "?";
    }
}

