/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MeasureDataUsage {
    SUPPLEMENTALDATA,
    RISKADJUSTMENTFACTOR,
    NULL;


    public static MeasureDataUsage fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("supplemental-data".equals(codeString)) {
            return SUPPLEMENTALDATA;
        }
        if ("risk-adjustment-factor".equals(codeString)) {
            return RISKADJUSTMENTFACTOR;
        }
        throw new FHIRException("Unknown MeasureDataUsage code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SUPPLEMENTALDATA: {
                return "supplemental-data";
            }
            case RISKADJUSTMENTFACTOR: {
                return "risk-adjustment-factor";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/measure-data-usage";
    }

    public String getDefinition() {
        switch (this) {
            case SUPPLEMENTALDATA: {
                return "The data is intended to be provided as additional information alongside the measure results";
            }
            case RISKADJUSTMENTFACTOR: {
                return "The data is intended to be used to calculate and apply a risk adjustment model for the measure";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SUPPLEMENTALDATA: {
                return "Supplemental Data";
            }
            case RISKADJUSTMENTFACTOR: {
                return "Risk Adjustment Factor";
            }
        }
        return "?";
    }
}

