/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum QicoreAppropriatenessScore {
    EXTREMELYINAPPROPRIATE,
    INAPPROPRIATE,
    PROBABLYINAPPROPRIATE,
    UNCERTAININAPPROPRIATE,
    UNCERTAIN,
    UNCERTAINAPPROPRIATE,
    PROBABLYAPPROPRIATE,
    APPROPRIATE,
    EXTREMELYAPPROPRIATE,
    NULL;


    public static QicoreAppropriatenessScore fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("extremely-inappropriate".equals(codeString)) {
            return EXTREMELYINAPPROPRIATE;
        }
        if ("inappropriate".equals(codeString)) {
            return INAPPROPRIATE;
        }
        if ("probably-inappropriate".equals(codeString)) {
            return PROBABLYINAPPROPRIATE;
        }
        if ("uncertain-inappropriate".equals(codeString)) {
            return UNCERTAININAPPROPRIATE;
        }
        if ("uncertain".equals(codeString)) {
            return UNCERTAIN;
        }
        if ("uncertain-appropriate".equals(codeString)) {
            return UNCERTAINAPPROPRIATE;
        }
        if ("probably-appropriate".equals(codeString)) {
            return PROBABLYAPPROPRIATE;
        }
        if ("appropriate".equals(codeString)) {
            return APPROPRIATE;
        }
        if ("extremely-appropriate".equals(codeString)) {
            return EXTREMELYAPPROPRIATE;
        }
        throw new FHIRException("Unknown QicoreAppropriatenessScore code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EXTREMELYINAPPROPRIATE: {
                return "extremely-inappropriate";
            }
            case INAPPROPRIATE: {
                return "inappropriate";
            }
            case PROBABLYINAPPROPRIATE: {
                return "probably-inappropriate";
            }
            case UNCERTAININAPPROPRIATE: {
                return "uncertain-inappropriate";
            }
            case UNCERTAIN: {
                return "uncertain";
            }
            case UNCERTAINAPPROPRIATE: {
                return "uncertain-appropriate";
            }
            case PROBABLYAPPROPRIATE: {
                return "probably-appropriate";
            }
            case APPROPRIATE: {
                return "appropriate";
            }
            case EXTREMELYAPPROPRIATE: {
                return "extremely-appropriate";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/appropriateness-score";
    }

    public String getDefinition() {
        switch (this) {
            case EXTREMELYINAPPROPRIATE: {
                return "The procedure is extremely inappropriate";
            }
            case INAPPROPRIATE: {
                return "The procedure is inappropriate";
            }
            case PROBABLYINAPPROPRIATE: {
                return "The procedure is probably inappropriate";
            }
            case UNCERTAININAPPROPRIATE: {
                return "The appropriateness of the procedure is uncertain, leaning towards inappropriate";
            }
            case UNCERTAIN: {
                return "The appropriateness of the procedure is uncertain";
            }
            case UNCERTAINAPPROPRIATE: {
                return "The appropriateness of the procedure is uncertain, leaning towards appropriate";
            }
            case PROBABLYAPPROPRIATE: {
                return "The procedure is probably appropriate";
            }
            case APPROPRIATE: {
                return "The procedure is appropriate";
            }
            case EXTREMELYAPPROPRIATE: {
                return "The procedure is extremely appropriate";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EXTREMELYINAPPROPRIATE: {
                return "Extremely Inappropriate";
            }
            case INAPPROPRIATE: {
                return "Inappropriate";
            }
            case PROBABLYINAPPROPRIATE: {
                return "Probably Inappropriate";
            }
            case UNCERTAININAPPROPRIATE: {
                return "Uncertain Inappropriate";
            }
            case UNCERTAIN: {
                return "Uncertain";
            }
            case UNCERTAINAPPROPRIATE: {
                return "Uncertain Appropriate";
            }
            case PROBABLYAPPROPRIATE: {
                return "Probably Appropriate";
            }
            case APPROPRIATE: {
                return "Appropriate";
            }
            case EXTREMELYAPPROPRIATE: {
                return "Extremely Appropriate";
            }
        }
        return "?";
    }
}

