/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum QicoreDiagnosticorderPrecondition {
    _1,
    _2,
    _3,
    NULL;


    public static QicoreDiagnosticorderPrecondition fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1".equals(codeString)) {
            return _1;
        }
        if ("2".equals(codeString)) {
            return _2;
        }
        if ("3".equals(codeString)) {
            return _3;
        }
        throw new FHIRException("Unknown QicoreDiagnosticorderPrecondition code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1: {
                return "1";
            }
            case _2: {
                return "2";
            }
            case _3: {
                return "3";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/qicore-diagnosticorder-precondition";
    }

    public String getDefinition() {
        switch (this) {
            case _1: {
                return "The diagnostic test was or should be performed after the patient has engaged in physical activity";
            }
            case _2: {
                return "The diagnostic test was or should be performed while the patient is at rest";
            }
            case _3: {
                return "The diagnostic test was or should be performed after the patient operation";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1: {
                return "After activity";
            }
            case _2: {
                return "At rest";
            }
            case _3: {
                return "Post-op";
            }
        }
        return "?";
    }
}

