/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.Contract;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.PositiveIntType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Coverage", profile="http://hl7.org/fhir/Profile/Coverage")
public class Coverage
extends DomainResource {
    @Child(name="issuer", type={Identifier.class, Organization.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier for the plan issuer", formalDefinition="The program or plan underwriter or payor.")
    protected Type issuer;
    @Child(name="bin", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="BIN Number", formalDefinition="Business Identification Number (BIN number) used to identify the routing  of eClaims.")
    protected StringType bin;
    @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Coverage start and end dates", formalDefinition="Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.")
    protected Period period;
    @Child(name="type", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of coverage", formalDefinition="The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health.")
    protected Coding type;
    @Child(name="planholder", type={Identifier.class, Patient.class, Organization.class}, order=4, min=1, max=1, modifier=true, summary=false)
    @Description(shortDefinition="Plan holder", formalDefinition="The party who 'owns' the insurance contractual relationship to the policy or to whom the benefit of the policy is due.")
    protected Type planholder;
    @Child(name="beneficiary", type={Identifier.class, Patient.class}, order=5, min=1, max=1, modifier=true, summary=false)
    @Description(shortDefinition="Plan Beneficiary", formalDefinition="The party who benefits from the insurance coverage.")
    protected Type beneficiary;
    @Child(name="relationship", type={Coding.class}, order=6, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Patient relationship to planholder", formalDefinition="The relationship of the patient to the planholdersubscriber).")
    protected Coding relationship;
    @Child(name="identifier", type={Identifier.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The primary coverage ID", formalDefinition="The main (and possibly only) identifier for the coverage - often referred to as a Member Id, Subscriber Id, Certificate number or Personal Health Number or Case ID.")
    protected List<Identifier> identifier;
    @Child(name="group", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier for the group", formalDefinition="Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage or employer group. May also be referred to as a Policy or Group ID.")
    protected StringType group;
    @Child(name="plan", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier for the plan", formalDefinition="Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage or employer group. May also be referred to as a Policy or Group ID.")
    protected StringType plan;
    @Child(name="subPlan", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier for the subsection of the plan", formalDefinition="Identifies a sub-style or sub-collective of coverage issues by the underwriter, for example may be used to identify a specific employer group within a class of employers. May be referred to as a Section or Division ID.")
    protected StringType subPlan;
    @Child(name="dependent", type={PositiveIntType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dependent number", formalDefinition="A unique identifier for a dependent under the coverage.")
    protected PositiveIntType dependent;
    @Child(name="sequence", type={PositiveIntType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The plan instance or sequence counter", formalDefinition="An optional counter for a particular instance of the identified coverage which increments upon each renewal.")
    protected PositiveIntType sequence;
    @Child(name="exception", type={Coding.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Eligibility exceptions", formalDefinition="Factors which may influence the applicability of coverage.")
    protected List<Coding> exception;
    @Child(name="school", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of School", formalDefinition="Name of school for over-aged dependants.")
    protected StringType school;
    @Child(name="network", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer network", formalDefinition="The identifier for a community of providers.")
    protected StringType network;
    @Child(name="contract", type={Contract.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract details", formalDefinition="The policy(s) which constitute this insurance coverage.")
    protected List<Reference> contract;
    protected List<Contract> contractTarget;
    private static final long serialVersionUID = -1269320450L;
    @SearchParamDefinition(name="dependent", path="Coverage.dependent", description="Dependent number", type="token")
    public static final String SP_DEPENDENT = "dependent";
    public static final TokenClientParam DEPENDENT = new TokenClientParam("dependent");
    @SearchParamDefinition(name="beneficiaryreference", path="Coverage.beneficiary.as(Reference)", description="Covered party", type="reference")
    public static final String SP_BENEFICIARYREFERENCE = "beneficiaryreference";
    public static final ReferenceClientParam BENEFICIARYREFERENCE = new ReferenceClientParam("beneficiaryreference");
    public static final Include INCLUDE_BENEFICIARYREFERENCE = new Include("Coverage:beneficiaryreference").toLocked();
    @SearchParamDefinition(name="planholderidentifier", path="Coverage.planholder.as(Identifier)", description="Reference to the planholder", type="token")
    public static final String SP_PLANHOLDERIDENTIFIER = "planholderidentifier";
    public static final TokenClientParam PLANHOLDERIDENTIFIER = new TokenClientParam("planholderidentifier");
    @SearchParamDefinition(name="type", path="Coverage.type", description="The kind of coverage (health plan, auto, Workers Compensation)", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="issueridentifier", path="Coverage.issuer.as(Identifier)", description="The identity of the insurer", type="token")
    public static final String SP_ISSUERIDENTIFIER = "issueridentifier";
    public static final TokenClientParam ISSUERIDENTIFIER = new TokenClientParam("issueridentifier");
    @SearchParamDefinition(name="subplan", path="Coverage.subPlan", description="Sub-plan identifier", type="token")
    public static final String SP_SUBPLAN = "subplan";
    public static final TokenClientParam SUBPLAN = new TokenClientParam("subplan");
    @SearchParamDefinition(name="issuerreference", path="Coverage.issuer.as(Reference)", description="The identity of the insurer", type="reference")
    public static final String SP_ISSUERREFERENCE = "issuerreference";
    public static final ReferenceClientParam ISSUERREFERENCE = new ReferenceClientParam("issuerreference");
    public static final Include INCLUDE_ISSUERREFERENCE = new Include("Coverage:issuerreference").toLocked();
    @SearchParamDefinition(name="plan", path="Coverage.plan", description="A plan or policy identifier", type="token")
    public static final String SP_PLAN = "plan";
    public static final TokenClientParam PLAN = new TokenClientParam("plan");
    @SearchParamDefinition(name="sequence", path="Coverage.sequence", description="Sequence number", type="token")
    public static final String SP_SEQUENCE = "sequence";
    public static final TokenClientParam SEQUENCE = new TokenClientParam("sequence");
    @SearchParamDefinition(name="beneficiaryidentifier", path="Coverage.beneficiary.as(Identifier)", description="Covered party", type="token")
    public static final String SP_BENEFICIARYIDENTIFIER = "beneficiaryidentifier";
    public static final TokenClientParam BENEFICIARYIDENTIFIER = new TokenClientParam("beneficiaryidentifier");
    @SearchParamDefinition(name="group", path="Coverage.group", description="Group identifier", type="token")
    public static final String SP_GROUP = "group";
    public static final TokenClientParam GROUP = new TokenClientParam("group");
    @SearchParamDefinition(name="planholderreference", path="Coverage.planholder.as(Reference)", description="Reference to the planholder", type="reference")
    public static final String SP_PLANHOLDERREFERENCE = "planholderreference";
    public static final ReferenceClientParam PLANHOLDERREFERENCE = new ReferenceClientParam("planholderreference");
    public static final Include INCLUDE_PLANHOLDERREFERENCE = new Include("Coverage:planholderreference").toLocked();
    @SearchParamDefinition(name="identifier", path="Coverage.identifier", description="The primary identifier of the insured and the coverage", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public Coverage() {
    }

    public Coverage(Type issuer, Type planholder, Type beneficiary, Coding relationship) {
        this.issuer = issuer;
        this.planholder = planholder;
        this.beneficiary = beneficiary;
        this.relationship = relationship;
    }

    public Type getIssuer() {
        return this.issuer;
    }

    public Identifier getIssuerIdentifier() throws FHIRException {
        if (!(this.issuer instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.issuer.getClass().getName() + " was encountered");
        }
        return (Identifier)this.issuer;
    }

    public boolean hasIssuerIdentifier() {
        return this.issuer instanceof Identifier;
    }

    public Reference getIssuerReference() throws FHIRException {
        if (!(this.issuer instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.issuer.getClass().getName() + " was encountered");
        }
        return (Reference)this.issuer;
    }

    public boolean hasIssuerReference() {
        return this.issuer instanceof Reference;
    }

    public boolean hasIssuer() {
        return this.issuer != null && !this.issuer.isEmpty();
    }

    public Coverage setIssuer(Type value) {
        this.issuer = value;
        return this;
    }

    public StringType getBinElement() {
        if (this.bin == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.bin");
            }
            if (Configuration.doAutoCreate()) {
                this.bin = new StringType();
            }
        }
        return this.bin;
    }

    public boolean hasBinElement() {
        return this.bin != null && !this.bin.isEmpty();
    }

    public boolean hasBin() {
        return this.bin != null && !this.bin.isEmpty();
    }

    public Coverage setBinElement(StringType value) {
        this.bin = value;
        return this;
    }

    public String getBin() {
        return this.bin == null ? null : (String)this.bin.getValue();
    }

    public Coverage setBin(String value) {
        if (Utilities.noString((String)value)) {
            this.bin = null;
        } else {
            if (this.bin == null) {
                this.bin = new StringType();
            }
            this.bin.setValue(value);
        }
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Coverage setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Coding getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Coding();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Coverage setType(Coding value) {
        this.type = value;
        return this;
    }

    public Type getPlanholder() {
        return this.planholder;
    }

    public Identifier getPlanholderIdentifier() throws FHIRException {
        if (!(this.planholder instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.planholder.getClass().getName() + " was encountered");
        }
        return (Identifier)this.planholder;
    }

    public boolean hasPlanholderIdentifier() {
        return this.planholder instanceof Identifier;
    }

    public Reference getPlanholderReference() throws FHIRException {
        if (!(this.planholder instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.planholder.getClass().getName() + " was encountered");
        }
        return (Reference)this.planholder;
    }

    public boolean hasPlanholderReference() {
        return this.planholder instanceof Reference;
    }

    public boolean hasPlanholder() {
        return this.planholder != null && !this.planholder.isEmpty();
    }

    public Coverage setPlanholder(Type value) {
        this.planholder = value;
        return this;
    }

    public Type getBeneficiary() {
        return this.beneficiary;
    }

    public Identifier getBeneficiaryIdentifier() throws FHIRException {
        if (!(this.beneficiary instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.beneficiary.getClass().getName() + " was encountered");
        }
        return (Identifier)this.beneficiary;
    }

    public boolean hasBeneficiaryIdentifier() {
        return this.beneficiary instanceof Identifier;
    }

    public Reference getBeneficiaryReference() throws FHIRException {
        if (!(this.beneficiary instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.beneficiary.getClass().getName() + " was encountered");
        }
        return (Reference)this.beneficiary;
    }

    public boolean hasBeneficiaryReference() {
        return this.beneficiary instanceof Reference;
    }

    public boolean hasBeneficiary() {
        return this.beneficiary != null && !this.beneficiary.isEmpty();
    }

    public Coverage setBeneficiary(Type value) {
        this.beneficiary = value;
        return this;
    }

    public Coding getRelationship() {
        if (this.relationship == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.relationship");
            }
            if (Configuration.doAutoCreate()) {
                this.relationship = new Coding();
            }
        }
        return this.relationship;
    }

    public boolean hasRelationship() {
        return this.relationship != null && !this.relationship.isEmpty();
    }

    public Coverage setRelationship(Coding value) {
        this.relationship = value;
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Coverage addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public StringType getGroupElement() {
        if (this.group == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.group");
            }
            if (Configuration.doAutoCreate()) {
                this.group = new StringType();
            }
        }
        return this.group;
    }

    public boolean hasGroupElement() {
        return this.group != null && !this.group.isEmpty();
    }

    public boolean hasGroup() {
        return this.group != null && !this.group.isEmpty();
    }

    public Coverage setGroupElement(StringType value) {
        this.group = value;
        return this;
    }

    public String getGroup() {
        return this.group == null ? null : (String)this.group.getValue();
    }

    public Coverage setGroup(String value) {
        if (Utilities.noString((String)value)) {
            this.group = null;
        } else {
            if (this.group == null) {
                this.group = new StringType();
            }
            this.group.setValue(value);
        }
        return this;
    }

    public StringType getPlanElement() {
        if (this.plan == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.plan");
            }
            if (Configuration.doAutoCreate()) {
                this.plan = new StringType();
            }
        }
        return this.plan;
    }

    public boolean hasPlanElement() {
        return this.plan != null && !this.plan.isEmpty();
    }

    public boolean hasPlan() {
        return this.plan != null && !this.plan.isEmpty();
    }

    public Coverage setPlanElement(StringType value) {
        this.plan = value;
        return this;
    }

    public String getPlan() {
        return this.plan == null ? null : (String)this.plan.getValue();
    }

    public Coverage setPlan(String value) {
        if (Utilities.noString((String)value)) {
            this.plan = null;
        } else {
            if (this.plan == null) {
                this.plan = new StringType();
            }
            this.plan.setValue(value);
        }
        return this;
    }

    public StringType getSubPlanElement() {
        if (this.subPlan == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.subPlan");
            }
            if (Configuration.doAutoCreate()) {
                this.subPlan = new StringType();
            }
        }
        return this.subPlan;
    }

    public boolean hasSubPlanElement() {
        return this.subPlan != null && !this.subPlan.isEmpty();
    }

    public boolean hasSubPlan() {
        return this.subPlan != null && !this.subPlan.isEmpty();
    }

    public Coverage setSubPlanElement(StringType value) {
        this.subPlan = value;
        return this;
    }

    public String getSubPlan() {
        return this.subPlan == null ? null : (String)this.subPlan.getValue();
    }

    public Coverage setSubPlan(String value) {
        if (Utilities.noString((String)value)) {
            this.subPlan = null;
        } else {
            if (this.subPlan == null) {
                this.subPlan = new StringType();
            }
            this.subPlan.setValue(value);
        }
        return this;
    }

    public PositiveIntType getDependentElement() {
        if (this.dependent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.dependent");
            }
            if (Configuration.doAutoCreate()) {
                this.dependent = new PositiveIntType();
            }
        }
        return this.dependent;
    }

    public boolean hasDependentElement() {
        return this.dependent != null && !this.dependent.isEmpty();
    }

    public boolean hasDependent() {
        return this.dependent != null && !this.dependent.isEmpty();
    }

    public Coverage setDependentElement(PositiveIntType value) {
        this.dependent = value;
        return this;
    }

    public int getDependent() {
        return this.dependent == null || this.dependent.isEmpty() ? 0 : (Integer)this.dependent.getValue();
    }

    public Coverage setDependent(int value) {
        if (this.dependent == null) {
            this.dependent = new PositiveIntType();
        }
        this.dependent.setValue((Object)value);
        return this;
    }

    public PositiveIntType getSequenceElement() {
        if (this.sequence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.sequence");
            }
            if (Configuration.doAutoCreate()) {
                this.sequence = new PositiveIntType();
            }
        }
        return this.sequence;
    }

    public boolean hasSequenceElement() {
        return this.sequence != null && !this.sequence.isEmpty();
    }

    public boolean hasSequence() {
        return this.sequence != null && !this.sequence.isEmpty();
    }

    public Coverage setSequenceElement(PositiveIntType value) {
        this.sequence = value;
        return this;
    }

    public int getSequence() {
        return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
    }

    public Coverage setSequence(int value) {
        if (this.sequence == null) {
            this.sequence = new PositiveIntType();
        }
        this.sequence.setValue((Object)value);
        return this;
    }

    public List<Coding> getException() {
        if (this.exception == null) {
            this.exception = new ArrayList<Coding>();
        }
        return this.exception;
    }

    public boolean hasException() {
        if (this.exception == null) {
            return false;
        }
        for (Coding item : this.exception) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addException() {
        Coding t = new Coding();
        if (this.exception == null) {
            this.exception = new ArrayList<Coding>();
        }
        this.exception.add(t);
        return t;
    }

    public Coverage addException(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.exception == null) {
            this.exception = new ArrayList<Coding>();
        }
        this.exception.add(t);
        return this;
    }

    public StringType getSchoolElement() {
        if (this.school == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.school");
            }
            if (Configuration.doAutoCreate()) {
                this.school = new StringType();
            }
        }
        return this.school;
    }

    public boolean hasSchoolElement() {
        return this.school != null && !this.school.isEmpty();
    }

    public boolean hasSchool() {
        return this.school != null && !this.school.isEmpty();
    }

    public Coverage setSchoolElement(StringType value) {
        this.school = value;
        return this;
    }

    public String getSchool() {
        return this.school == null ? null : (String)this.school.getValue();
    }

    public Coverage setSchool(String value) {
        if (Utilities.noString((String)value)) {
            this.school = null;
        } else {
            if (this.school == null) {
                this.school = new StringType();
            }
            this.school.setValue(value);
        }
        return this;
    }

    public StringType getNetworkElement() {
        if (this.network == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coverage.network");
            }
            if (Configuration.doAutoCreate()) {
                this.network = new StringType();
            }
        }
        return this.network;
    }

    public boolean hasNetworkElement() {
        return this.network != null && !this.network.isEmpty();
    }

    public boolean hasNetwork() {
        return this.network != null && !this.network.isEmpty();
    }

    public Coverage setNetworkElement(StringType value) {
        this.network = value;
        return this;
    }

    public String getNetwork() {
        return this.network == null ? null : (String)this.network.getValue();
    }

    public Coverage setNetwork(String value) {
        if (Utilities.noString((String)value)) {
            this.network = null;
        } else {
            if (this.network == null) {
                this.network = new StringType();
            }
            this.network.setValue(value);
        }
        return this;
    }

    public List<Reference> getContract() {
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        return this.contract;
    }

    public boolean hasContract() {
        if (this.contract == null) {
            return false;
        }
        for (Reference item : this.contract) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addContract() {
        Reference t = new Reference();
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        this.contract.add(t);
        return t;
    }

    public Coverage addContract(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        this.contract.add(t);
        return this;
    }

    public List<Contract> getContractTarget() {
        if (this.contractTarget == null) {
            this.contractTarget = new ArrayList<Contract>();
        }
        return this.contractTarget;
    }

    public Contract addContractTarget() {
        Contract r = new Contract();
        if (this.contractTarget == null) {
            this.contractTarget = new ArrayList<Contract>();
        }
        this.contractTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("issuer[x]", "Identifier|Reference(Organization)", "The program or plan underwriter or payor.", 0, Integer.MAX_VALUE, this.issuer));
        childrenList.add(new Property("bin", "string", "Business Identification Number (BIN number) used to identify the routing  of eClaims.", 0, Integer.MAX_VALUE, this.bin));
        childrenList.add(new Property("period", "Period", "Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.", 0, Integer.MAX_VALUE, this.period));
        childrenList.add(new Property(SP_TYPE, "Coding", "The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("planholder[x]", "Identifier|Reference(Patient|Organization)", "The party who 'owns' the insurance contractual relationship to the policy or to whom the benefit of the policy is due.", 0, Integer.MAX_VALUE, this.planholder));
        childrenList.add(new Property("beneficiary[x]", "Identifier|Reference(Patient)", "The party who benefits from the insurance coverage.", 0, Integer.MAX_VALUE, this.beneficiary));
        childrenList.add(new Property("relationship", "Coding", "The relationship of the patient to the planholdersubscriber).", 0, Integer.MAX_VALUE, this.relationship));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The main (and possibly only) identifier for the coverage - often referred to as a Member Id, Subscriber Id, Certificate number or Personal Health Number or Case ID.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_GROUP, "string", "Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage or employer group. May also be referred to as a Policy or Group ID.", 0, Integer.MAX_VALUE, this.group));
        childrenList.add(new Property(SP_PLAN, "string", "Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage or employer group. May also be referred to as a Policy or Group ID.", 0, Integer.MAX_VALUE, this.plan));
        childrenList.add(new Property("subPlan", "string", "Identifies a sub-style or sub-collective of coverage issues by the underwriter, for example may be used to identify a specific employer group within a class of employers. May be referred to as a Section or Division ID.", 0, Integer.MAX_VALUE, this.subPlan));
        childrenList.add(new Property(SP_DEPENDENT, "positiveInt", "A unique identifier for a dependent under the coverage.", 0, Integer.MAX_VALUE, this.dependent));
        childrenList.add(new Property(SP_SEQUENCE, "positiveInt", "An optional counter for a particular instance of the identified coverage which increments upon each renewal.", 0, Integer.MAX_VALUE, this.sequence));
        childrenList.add(new Property("exception", "Coding", "Factors which may influence the applicability of coverage.", 0, Integer.MAX_VALUE, this.exception));
        childrenList.add(new Property("school", "string", "Name of school for over-aged dependants.", 0, Integer.MAX_VALUE, this.school));
        childrenList.add(new Property("network", "string", "The identifier for a community of providers.", 0, Integer.MAX_VALUE, this.network));
        childrenList.add(new Property("contract", "Reference(Contract)", "The policy(s) which constitute this insurance coverage.", 0, Integer.MAX_VALUE, this.contract));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1179159879: {
                Base[] baseArray;
                if (this.issuer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.issuer;
                }
                return baseArray;
            }
            case 97543: {
                Base[] baseArray;
                if (this.bin == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.bin;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.period;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.type;
                }
                return baseArray;
            }
            case 1007064597: {
                Base[] baseArray;
                if (this.planholder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.planholder;
                }
                return baseArray;
            }
            case -565102875: {
                Base[] baseArray;
                if (this.beneficiary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.beneficiary;
                }
                return baseArray;
            }
            case -261851592: {
                Base[] baseArray;
                if (this.relationship == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.relationship;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 98629247: {
                Base[] baseArray;
                if (this.group == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.group;
                }
                return baseArray;
            }
            case 3443497: {
                Base[] baseArray;
                if (this.plan == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.plan;
                }
                return baseArray;
            }
            case -1868653175: {
                Base[] baseArray;
                if (this.subPlan == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.subPlan;
                }
                return baseArray;
            }
            case -1109226753: {
                Base[] baseArray;
                if (this.dependent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.dependent;
                }
                return baseArray;
            }
            case 1349547969: {
                Base[] baseArray;
                if (this.sequence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.sequence;
                }
                return baseArray;
            }
            case 1481625679: {
                return this.exception == null ? new Base[]{} : this.exception.toArray(new Base[this.exception.size()]);
            }
            case -907977868: {
                Base[] baseArray;
                if (this.school == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.school;
                }
                return baseArray;
            }
            case 1843485230: {
                Base[] baseArray;
                if (this.network == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.network;
                }
                return baseArray;
            }
            case -566947566: {
                return this.contract == null ? new Base[]{} : this.contract.toArray(new Base[this.contract.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1179159879: {
                this.issuer = (Type)value;
                break;
            }
            case 97543: {
                this.bin = this.castToString(value);
                break;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                break;
            }
            case 3575610: {
                this.type = this.castToCoding(value);
                break;
            }
            case 1007064597: {
                this.planholder = (Type)value;
                break;
            }
            case -565102875: {
                this.beneficiary = (Type)value;
                break;
            }
            case -261851592: {
                this.relationship = this.castToCoding(value);
                break;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 98629247: {
                this.group = this.castToString(value);
                break;
            }
            case 3443497: {
                this.plan = this.castToString(value);
                break;
            }
            case -1868653175: {
                this.subPlan = this.castToString(value);
                break;
            }
            case -1109226753: {
                this.dependent = this.castToPositiveInt(value);
                break;
            }
            case 1349547969: {
                this.sequence = this.castToPositiveInt(value);
                break;
            }
            case 1481625679: {
                this.getException().add(this.castToCoding(value));
                break;
            }
            case -907977868: {
                this.school = this.castToString(value);
                break;
            }
            case 1843485230: {
                this.network = this.castToString(value);
                break;
            }
            case -566947566: {
                this.getContract().add(this.castToReference(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("issuer[x]")) {
            this.issuer = (Type)value;
        } else if (name.equals("bin")) {
            this.bin = this.castToString(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCoding(value);
        } else if (name.equals("planholder[x]")) {
            this.planholder = (Type)value;
        } else if (name.equals("beneficiary[x]")) {
            this.beneficiary = (Type)value;
        } else if (name.equals("relationship")) {
            this.relationship = this.castToCoding(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_GROUP)) {
            this.group = this.castToString(value);
        } else if (name.equals(SP_PLAN)) {
            this.plan = this.castToString(value);
        } else if (name.equals("subPlan")) {
            this.subPlan = this.castToString(value);
        } else if (name.equals(SP_DEPENDENT)) {
            this.dependent = this.castToPositiveInt(value);
        } else if (name.equals(SP_SEQUENCE)) {
            this.sequence = this.castToPositiveInt(value);
        } else if (name.equals("exception")) {
            this.getException().add(this.castToCoding(value));
        } else if (name.equals("school")) {
            this.school = this.castToString(value);
        } else if (name.equals("network")) {
            this.network = this.castToString(value);
        } else if (name.equals("contract")) {
            this.getContract().add(this.castToReference(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 185649959: {
                return this.getIssuer();
            }
            case 97543: {
                throw new FHIRException("Cannot make property bin as it is not a complex type");
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 3575610: {
                return this.getType();
            }
            case 1114937931: {
                return this.getPlanholder();
            }
            case 1292142459: {
                return this.getBeneficiary();
            }
            case -261851592: {
                return this.getRelationship();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 98629247: {
                throw new FHIRException("Cannot make property group as it is not a complex type");
            }
            case 3443497: {
                throw new FHIRException("Cannot make property plan as it is not a complex type");
            }
            case -1868653175: {
                throw new FHIRException("Cannot make property subPlan as it is not a complex type");
            }
            case -1109226753: {
                throw new FHIRException("Cannot make property dependent as it is not a complex type");
            }
            case 1349547969: {
                throw new FHIRException("Cannot make property sequence as it is not a complex type");
            }
            case 1481625679: {
                return this.addException();
            }
            case -907977868: {
                throw new FHIRException("Cannot make property school as it is not a complex type");
            }
            case 1843485230: {
                throw new FHIRException("Cannot make property network as it is not a complex type");
            }
            case -566947566: {
                return this.addContract();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("issuerIdentifier")) {
            this.issuer = new Identifier();
            return this.issuer;
        }
        if (name.equals("issuerReference")) {
            this.issuer = new Reference();
            return this.issuer;
        }
        if (name.equals("bin")) {
            throw new FHIRException("Cannot call addChild on a primitive type Coverage.bin");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_TYPE)) {
            this.type = new Coding();
            return this.type;
        }
        if (name.equals("planholderIdentifier")) {
            this.planholder = new Identifier();
            return this.planholder;
        }
        if (name.equals("planholderReference")) {
            this.planholder = new Reference();
            return this.planholder;
        }
        if (name.equals("beneficiaryIdentifier")) {
            this.beneficiary = new Identifier();
            return this.beneficiary;
        }
        if (name.equals("beneficiaryReference")) {
            this.beneficiary = new Reference();
            return this.beneficiary;
        }
        if (name.equals("relationship")) {
            this.relationship = new Coding();
            return this.relationship;
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_GROUP)) {
            throw new FHIRException("Cannot call addChild on a primitive type Coverage.group");
        }
        if (name.equals(SP_PLAN)) {
            throw new FHIRException("Cannot call addChild on a primitive type Coverage.plan");
        }
        if (name.equals("subPlan")) {
            throw new FHIRException("Cannot call addChild on a primitive type Coverage.subPlan");
        }
        if (name.equals(SP_DEPENDENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type Coverage.dependent");
        }
        if (name.equals(SP_SEQUENCE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Coverage.sequence");
        }
        if (name.equals("exception")) {
            return this.addException();
        }
        if (name.equals("school")) {
            throw new FHIRException("Cannot call addChild on a primitive type Coverage.school");
        }
        if (name.equals("network")) {
            throw new FHIRException("Cannot call addChild on a primitive type Coverage.network");
        }
        if (name.equals("contract")) {
            return this.addContract();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Coverage";
    }

    @Override
    public Coverage copy() {
        Coverage dst = new Coverage();
        this.copyValues(dst);
        dst.issuer = this.issuer == null ? null : this.issuer.copy();
        dst.bin = this.bin == null ? null : this.bin.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.planholder = this.planholder == null ? null : this.planholder.copy();
        dst.beneficiary = this.beneficiary == null ? null : this.beneficiary.copy();
        Coding coding = dst.relationship = this.relationship == null ? null : this.relationship.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.group = this.group == null ? null : this.group.copy();
        dst.plan = this.plan == null ? null : this.plan.copy();
        dst.subPlan = this.subPlan == null ? null : this.subPlan.copy();
        dst.dependent = this.dependent == null ? null : this.dependent.copy();
        PositiveIntType positiveIntType = dst.sequence = this.sequence == null ? null : this.sequence.copy();
        if (this.exception != null) {
            dst.exception = new ArrayList<Coding>();
            for (Coding coding2 : this.exception) {
                dst.exception.add(coding2.copy());
            }
        }
        dst.school = this.school == null ? null : this.school.copy();
        StringType stringType = dst.network = this.network == null ? null : this.network.copy();
        if (this.contract != null) {
            dst.contract = new ArrayList<Reference>();
            for (Reference reference : this.contract) {
                dst.contract.add(reference.copy());
            }
        }
        return dst;
    }

    protected Coverage typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Coverage)) {
            return false;
        }
        Coverage o = (Coverage)other;
        return Coverage.compareDeep(this.issuer, o.issuer, true) && Coverage.compareDeep(this.bin, o.bin, true) && Coverage.compareDeep(this.period, o.period, true) && Coverage.compareDeep(this.type, o.type, true) && Coverage.compareDeep(this.planholder, o.planholder, true) && Coverage.compareDeep(this.beneficiary, o.beneficiary, true) && Coverage.compareDeep(this.relationship, o.relationship, true) && Coverage.compareDeep(this.identifier, o.identifier, true) && Coverage.compareDeep(this.group, o.group, true) && Coverage.compareDeep(this.plan, o.plan, true) && Coverage.compareDeep(this.subPlan, o.subPlan, true) && Coverage.compareDeep(this.dependent, o.dependent, true) && Coverage.compareDeep(this.sequence, o.sequence, true) && Coverage.compareDeep(this.exception, o.exception, true) && Coverage.compareDeep(this.school, o.school, true) && Coverage.compareDeep(this.network, o.network, true) && Coverage.compareDeep(this.contract, o.contract, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Coverage)) {
            return false;
        }
        Coverage o = (Coverage)other;
        return Coverage.compareValues(this.bin, o.bin, true) && Coverage.compareValues(this.group, o.group, true) && Coverage.compareValues(this.plan, o.plan, true) && Coverage.compareValues(this.subPlan, o.subPlan, true) && Coverage.compareValues(this.dependent, o.dependent, true) && Coverage.compareValues(this.sequence, o.sequence, true) && Coverage.compareValues(this.school, o.school, true) && Coverage.compareValues(this.network, o.network, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.issuer != null && !this.issuer.isEmpty() || this.bin != null && !this.bin.isEmpty() || this.period != null && !this.period.isEmpty() || this.type != null && !this.type.isEmpty() || this.planholder != null && !this.planholder.isEmpty() || this.beneficiary != null && !this.beneficiary.isEmpty() || this.relationship != null && !this.relationship.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.group != null && !this.group.isEmpty() || this.plan != null && !this.plan.isEmpty() || this.subPlan != null && !this.subPlan.isEmpty() || this.dependent != null && !this.dependent.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.exception != null && !this.exception.isEmpty() || this.school != null && !this.school.isEmpty() || this.network != null && !this.network.isEmpty() || this.contract != null && !this.contract.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Coverage;
    }
}

