/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.Duration;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;

@DatatypeDef(name="Timing")
public class Timing
extends Type
implements ICompositeType {
    @Child(name="event", type={DateTimeType.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="When the event occurs", formalDefinition="Identifies specific times when the event occurs.")
    protected List<DateTimeType> event;
    @Child(name="repeat", type={}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the event is to occur", formalDefinition="A set of rules that describe when the event should occur.")
    protected TimingRepeatComponent repeat;
    @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="QD | QOD | Q4H | Q6H | BID | TID | QID | AM | PM +", formalDefinition="A code for the timing pattern. Some codes such as BID are ubiquitous, but many institutions define their own additional codes. If a code is provided, the code is understood to be a complete statement of whatever is specified in the structured timing data, and either the code or the data may be used to interpret the Timing.")
    protected CodeableConcept code;
    private static final long serialVersionUID = 791565112L;

    public List<DateTimeType> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<DateTimeType>();
        }
        return this.event;
    }

    public boolean hasEvent() {
        if (this.event == null) {
            return false;
        }
        for (DateTimeType item : this.event) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DateTimeType addEventElement() {
        DateTimeType t = new DateTimeType();
        if (this.event == null) {
            this.event = new ArrayList<DateTimeType>();
        }
        this.event.add(t);
        return t;
    }

    public Timing addEvent(Date value) {
        DateTimeType t = new DateTimeType();
        t.setValue(value);
        if (this.event == null) {
            this.event = new ArrayList<DateTimeType>();
        }
        this.event.add(t);
        return this;
    }

    public boolean hasEvent(Date value) {
        if (this.event == null) {
            return false;
        }
        for (DateTimeType v : this.event) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public TimingRepeatComponent getRepeat() {
        if (this.repeat == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Timing.repeat");
            }
            if (Configuration.doAutoCreate()) {
                this.repeat = new TimingRepeatComponent();
            }
        }
        return this.repeat;
    }

    public boolean hasRepeat() {
        return this.repeat != null && !this.repeat.isEmpty();
    }

    public Timing setRepeat(TimingRepeatComponent value) {
        this.repeat = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Timing.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Timing setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("event", "dateTime", "Identifies specific times when the event occurs.", 0, Integer.MAX_VALUE, this.event));
        childrenList.add(new Property("repeat", "", "A set of rules that describe when the event should occur.", 0, Integer.MAX_VALUE, this.repeat));
        childrenList.add(new Property("code", "CodeableConcept", "A code for the timing pattern. Some codes such as BID are ubiquitous, but many institutions define their own additional codes. If a code is provided, the code is understood to be a complete statement of whatever is specified in the structured timing data, and either the code or the data may be used to interpret the Timing.", 0, Integer.MAX_VALUE, this.code));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 96891546: {
                return this.event == null ? new Base[]{} : this.event.toArray(new Base[this.event.size()]);
            }
            case -934531685: {
                Base[] baseArray;
                if (this.repeat == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.repeat;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 96891546: {
                this.getEvent().add(this.castToDateTime(value));
                break;
            }
            case -934531685: {
                this.repeat = (TimingRepeatComponent)value;
                break;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("event")) {
            this.getEvent().add(this.castToDateTime(value));
        } else if (name.equals("repeat")) {
            this.repeat = (TimingRepeatComponent)value;
        } else if (name.equals("code")) {
            this.code = this.castToCodeableConcept(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 96891546: {
                throw new FHIRException("Cannot make property event as it is not a complex type");
            }
            case -934531685: {
                return this.getRepeat();
            }
            case 3059181: {
                return this.getCode();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("event")) {
            throw new FHIRException("Cannot call addChild on a primitive type Timing.event");
        }
        if (name.equals("repeat")) {
            this.repeat = new TimingRepeatComponent();
            return this.repeat;
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Timing";
    }

    @Override
    public Timing copy() {
        Timing dst = new Timing();
        this.copyValues(dst);
        if (this.event != null) {
            dst.event = new ArrayList<DateTimeType>();
            for (DateTimeType i : this.event) {
                dst.event.add(i.copy());
            }
        }
        dst.repeat = this.repeat == null ? null : this.repeat.copy();
        dst.code = this.code == null ? null : this.code.copy();
        return dst;
    }

    @Override
    protected Timing typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Timing)) {
            return false;
        }
        Timing o = (Timing)other;
        return Timing.compareDeep(this.event, o.event, true) && Timing.compareDeep(this.repeat, o.repeat, true) && Timing.compareDeep(this.code, o.code, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Timing)) {
            return false;
        }
        Timing o = (Timing)other;
        return Timing.compareValues(this.event, o.event, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.event != null && !this.event.isEmpty() || this.repeat != null && !this.repeat.isEmpty() || this.code != null && !this.code.isEmpty());
    }

    @Block
    public static class TimingRepeatComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="bounds", type={Duration.class, Range.class, Period.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Length/Range of lengths, or (Start and/or end) limits", formalDefinition="Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule.")
        protected Type bounds;
        @Child(name="count", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number of times to repeat", formalDefinition="A total count of the desired number of repetitions.")
        protected IntegerType count;
        @Child(name="countMax", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Maximum number of times to repeat", formalDefinition="A maximum value for the count of the desired repetitions (e.g. do something 6-8 times).")
        protected IntegerType countMax;
        @Child(name="duration", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How long when it happens", formalDefinition="How long this thing happens for when it happens.")
        protected DecimalType duration;
        @Child(name="durationMax", type={DecimalType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How long when it happens (Max)", formalDefinition="The upper limit of how long this thing happens for when it happens.")
        protected DecimalType durationMax;
        @Child(name="durationUnit", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="s | min | h | d | wk | mo | a - unit of time (UCUM)", formalDefinition="The units of time for the duration, in UCUM units.")
        protected Enumeration<UnitsOfTime> durationUnit;
        @Child(name="frequency", type={IntegerType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Event occurs frequency times per period", formalDefinition="The number of times to repeat the action within the specified period / period range (i.e. both period and periodMax provided).")
        protected IntegerType frequency;
        @Child(name="frequencyMax", type={IntegerType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Event occurs up to frequencyMax times per period", formalDefinition="If present, indicates that the frequency is a range - so repeat between [frequency] and [frequencyMax] times within the period or period range.")
        protected IntegerType frequencyMax;
        @Child(name="period", type={DecimalType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Event occurs frequency times per period", formalDefinition="Indicates the duration of time over which repetitions are to occur; e.g. to express \"3 times per day\", 3 would be the frequency and \"1 day\" would be the period.")
        protected DecimalType period;
        @Child(name="periodMax", type={DecimalType.class}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Upper limit of period (3-4 hours)", formalDefinition="If present, indicates that the period is a range from [period] to [periodMax], allowing expressing concepts such as \"do this once every 3-5 days.")
        protected DecimalType periodMax;
        @Child(name="periodUnit", type={CodeType.class}, order=11, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="s | min | h | d | wk | mo | a - unit of time (UCUM)", formalDefinition="The units of time for the period in UCUM units.")
        protected Enumeration<UnitsOfTime> periodUnit;
        @Child(name="when", type={CodeType.class}, order=12, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Regular life events the event is tied to", formalDefinition="A real world event that the occurrence of the event should be tied to.")
        protected Enumeration<EventTiming> when;
        @Child(name="offset", type={UnsignedIntType.class}, order=13, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Minutes from event (before or after)", formalDefinition="The number of minutes from the event. If the event code does not indicate whether the minutes is before or after the event, then the offset is assumed to be after the event.")
        protected UnsignedIntType offset;
        private static final long serialVersionUID = -1317919984L;

        public Type getBounds() {
            return this.bounds;
        }

        public Duration getBoundsDuration() throws FHIRException {
            if (!(this.bounds instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.bounds.getClass().getName() + " was encountered");
            }
            return (Duration)this.bounds;
        }

        public boolean hasBoundsDuration() {
            return this.bounds instanceof Duration;
        }

        public Range getBoundsRange() throws FHIRException {
            if (!(this.bounds instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.bounds.getClass().getName() + " was encountered");
            }
            return (Range)this.bounds;
        }

        public boolean hasBoundsRange() {
            return this.bounds instanceof Range;
        }

        public Period getBoundsPeriod() throws FHIRException {
            if (!(this.bounds instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.bounds.getClass().getName() + " was encountered");
            }
            return (Period)this.bounds;
        }

        public boolean hasBoundsPeriod() {
            return this.bounds instanceof Period;
        }

        public boolean hasBounds() {
            return this.bounds != null && !this.bounds.isEmpty();
        }

        public TimingRepeatComponent setBounds(Type value) {
            this.bounds = value;
            return this;
        }

        public IntegerType getCountElement() {
            if (this.count == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.count");
                }
                if (Configuration.doAutoCreate()) {
                    this.count = new IntegerType();
                }
            }
            return this.count;
        }

        public boolean hasCountElement() {
            return this.count != null && !this.count.isEmpty();
        }

        public boolean hasCount() {
            return this.count != null && !this.count.isEmpty();
        }

        public TimingRepeatComponent setCountElement(IntegerType value) {
            this.count = value;
            return this;
        }

        public int getCount() {
            return this.count == null || this.count.isEmpty() ? 0 : (Integer)this.count.getValue();
        }

        public TimingRepeatComponent setCount(int value) {
            if (this.count == null) {
                this.count = new IntegerType();
            }
            this.count.setValue((Object)value);
            return this;
        }

        public IntegerType getCountMaxElement() {
            if (this.countMax == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.countMax");
                }
                if (Configuration.doAutoCreate()) {
                    this.countMax = new IntegerType();
                }
            }
            return this.countMax;
        }

        public boolean hasCountMaxElement() {
            return this.countMax != null && !this.countMax.isEmpty();
        }

        public boolean hasCountMax() {
            return this.countMax != null && !this.countMax.isEmpty();
        }

        public TimingRepeatComponent setCountMaxElement(IntegerType value) {
            this.countMax = value;
            return this;
        }

        public int getCountMax() {
            return this.countMax == null || this.countMax.isEmpty() ? 0 : (Integer)this.countMax.getValue();
        }

        public TimingRepeatComponent setCountMax(int value) {
            if (this.countMax == null) {
                this.countMax = new IntegerType();
            }
            this.countMax.setValue((Object)value);
            return this;
        }

        public DecimalType getDurationElement() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new DecimalType();
                }
            }
            return this.duration;
        }

        public boolean hasDurationElement() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public TimingRepeatComponent setDurationElement(DecimalType value) {
            this.duration = value;
            return this;
        }

        public BigDecimal getDuration() {
            return this.duration == null ? null : (BigDecimal)this.duration.getValue();
        }

        public TimingRepeatComponent setDuration(BigDecimal value) {
            if (value == null) {
                this.duration = null;
            } else {
                if (this.duration == null) {
                    this.duration = new DecimalType();
                }
                this.duration.setValue(value);
            }
            return this;
        }

        public TimingRepeatComponent setDuration(long value) {
            this.duration = new DecimalType();
            this.duration.setValue(value);
            return this;
        }

        public TimingRepeatComponent setDuration(double value) {
            this.duration = new DecimalType();
            this.duration.setValue(value);
            return this;
        }

        public DecimalType getDurationMaxElement() {
            if (this.durationMax == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.durationMax");
                }
                if (Configuration.doAutoCreate()) {
                    this.durationMax = new DecimalType();
                }
            }
            return this.durationMax;
        }

        public boolean hasDurationMaxElement() {
            return this.durationMax != null && !this.durationMax.isEmpty();
        }

        public boolean hasDurationMax() {
            return this.durationMax != null && !this.durationMax.isEmpty();
        }

        public TimingRepeatComponent setDurationMaxElement(DecimalType value) {
            this.durationMax = value;
            return this;
        }

        public BigDecimal getDurationMax() {
            return this.durationMax == null ? null : (BigDecimal)this.durationMax.getValue();
        }

        public TimingRepeatComponent setDurationMax(BigDecimal value) {
            if (value == null) {
                this.durationMax = null;
            } else {
                if (this.durationMax == null) {
                    this.durationMax = new DecimalType();
                }
                this.durationMax.setValue(value);
            }
            return this;
        }

        public TimingRepeatComponent setDurationMax(long value) {
            this.durationMax = new DecimalType();
            this.durationMax.setValue(value);
            return this;
        }

        public TimingRepeatComponent setDurationMax(double value) {
            this.durationMax = new DecimalType();
            this.durationMax.setValue(value);
            return this;
        }

        public Enumeration<UnitsOfTime> getDurationUnitElement() {
            if (this.durationUnit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.durationUnit");
                }
                if (Configuration.doAutoCreate()) {
                    this.durationUnit = new Enumeration<UnitsOfTime>(new UnitsOfTimeEnumFactory());
                }
            }
            return this.durationUnit;
        }

        public boolean hasDurationUnitElement() {
            return this.durationUnit != null && !this.durationUnit.isEmpty();
        }

        public boolean hasDurationUnit() {
            return this.durationUnit != null && !this.durationUnit.isEmpty();
        }

        public TimingRepeatComponent setDurationUnitElement(Enumeration<UnitsOfTime> value) {
            this.durationUnit = value;
            return this;
        }

        public UnitsOfTime getDurationUnit() {
            return this.durationUnit == null ? null : (UnitsOfTime)((Object)this.durationUnit.getValue());
        }

        public TimingRepeatComponent setDurationUnit(UnitsOfTime value) {
            if (value == null) {
                this.durationUnit = null;
            } else {
                if (this.durationUnit == null) {
                    this.durationUnit = new Enumeration<UnitsOfTime>(new UnitsOfTimeEnumFactory());
                }
                this.durationUnit.setValue((Object)value);
            }
            return this;
        }

        public IntegerType getFrequencyElement() {
            if (this.frequency == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.frequency");
                }
                if (Configuration.doAutoCreate()) {
                    this.frequency = new IntegerType();
                }
            }
            return this.frequency;
        }

        public boolean hasFrequencyElement() {
            return this.frequency != null && !this.frequency.isEmpty();
        }

        public boolean hasFrequency() {
            return this.frequency != null && !this.frequency.isEmpty();
        }

        public TimingRepeatComponent setFrequencyElement(IntegerType value) {
            this.frequency = value;
            return this;
        }

        public int getFrequency() {
            return this.frequency == null || this.frequency.isEmpty() ? 0 : (Integer)this.frequency.getValue();
        }

        public TimingRepeatComponent setFrequency(int value) {
            if (this.frequency == null) {
                this.frequency = new IntegerType();
            }
            this.frequency.setValue((Object)value);
            return this;
        }

        public IntegerType getFrequencyMaxElement() {
            if (this.frequencyMax == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.frequencyMax");
                }
                if (Configuration.doAutoCreate()) {
                    this.frequencyMax = new IntegerType();
                }
            }
            return this.frequencyMax;
        }

        public boolean hasFrequencyMaxElement() {
            return this.frequencyMax != null && !this.frequencyMax.isEmpty();
        }

        public boolean hasFrequencyMax() {
            return this.frequencyMax != null && !this.frequencyMax.isEmpty();
        }

        public TimingRepeatComponent setFrequencyMaxElement(IntegerType value) {
            this.frequencyMax = value;
            return this;
        }

        public int getFrequencyMax() {
            return this.frequencyMax == null || this.frequencyMax.isEmpty() ? 0 : (Integer)this.frequencyMax.getValue();
        }

        public TimingRepeatComponent setFrequencyMax(int value) {
            if (this.frequencyMax == null) {
                this.frequencyMax = new IntegerType();
            }
            this.frequencyMax.setValue((Object)value);
            return this;
        }

        public DecimalType getPeriodElement() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new DecimalType();
                }
            }
            return this.period;
        }

        public boolean hasPeriodElement() {
            return this.period != null && !this.period.isEmpty();
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public TimingRepeatComponent setPeriodElement(DecimalType value) {
            this.period = value;
            return this;
        }

        public BigDecimal getPeriod() {
            return this.period == null ? null : (BigDecimal)this.period.getValue();
        }

        public TimingRepeatComponent setPeriod(BigDecimal value) {
            if (value == null) {
                this.period = null;
            } else {
                if (this.period == null) {
                    this.period = new DecimalType();
                }
                this.period.setValue(value);
            }
            return this;
        }

        public TimingRepeatComponent setPeriod(long value) {
            this.period = new DecimalType();
            this.period.setValue(value);
            return this;
        }

        public TimingRepeatComponent setPeriod(double value) {
            this.period = new DecimalType();
            this.period.setValue(value);
            return this;
        }

        public DecimalType getPeriodMaxElement() {
            if (this.periodMax == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.periodMax");
                }
                if (Configuration.doAutoCreate()) {
                    this.periodMax = new DecimalType();
                }
            }
            return this.periodMax;
        }

        public boolean hasPeriodMaxElement() {
            return this.periodMax != null && !this.periodMax.isEmpty();
        }

        public boolean hasPeriodMax() {
            return this.periodMax != null && !this.periodMax.isEmpty();
        }

        public TimingRepeatComponent setPeriodMaxElement(DecimalType value) {
            this.periodMax = value;
            return this;
        }

        public BigDecimal getPeriodMax() {
            return this.periodMax == null ? null : (BigDecimal)this.periodMax.getValue();
        }

        public TimingRepeatComponent setPeriodMax(BigDecimal value) {
            if (value == null) {
                this.periodMax = null;
            } else {
                if (this.periodMax == null) {
                    this.periodMax = new DecimalType();
                }
                this.periodMax.setValue(value);
            }
            return this;
        }

        public TimingRepeatComponent setPeriodMax(long value) {
            this.periodMax = new DecimalType();
            this.periodMax.setValue(value);
            return this;
        }

        public TimingRepeatComponent setPeriodMax(double value) {
            this.periodMax = new DecimalType();
            this.periodMax.setValue(value);
            return this;
        }

        public Enumeration<UnitsOfTime> getPeriodUnitElement() {
            if (this.periodUnit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.periodUnit");
                }
                if (Configuration.doAutoCreate()) {
                    this.periodUnit = new Enumeration<UnitsOfTime>(new UnitsOfTimeEnumFactory());
                }
            }
            return this.periodUnit;
        }

        public boolean hasPeriodUnitElement() {
            return this.periodUnit != null && !this.periodUnit.isEmpty();
        }

        public boolean hasPeriodUnit() {
            return this.periodUnit != null && !this.periodUnit.isEmpty();
        }

        public TimingRepeatComponent setPeriodUnitElement(Enumeration<UnitsOfTime> value) {
            this.periodUnit = value;
            return this;
        }

        public UnitsOfTime getPeriodUnit() {
            return this.periodUnit == null ? null : (UnitsOfTime)((Object)this.periodUnit.getValue());
        }

        public TimingRepeatComponent setPeriodUnit(UnitsOfTime value) {
            if (value == null) {
                this.periodUnit = null;
            } else {
                if (this.periodUnit == null) {
                    this.periodUnit = new Enumeration<UnitsOfTime>(new UnitsOfTimeEnumFactory());
                }
                this.periodUnit.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<EventTiming> getWhenElement() {
            if (this.when == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.when");
                }
                if (Configuration.doAutoCreate()) {
                    this.when = new Enumeration<EventTiming>(new EventTimingEnumFactory());
                }
            }
            return this.when;
        }

        public boolean hasWhenElement() {
            return this.when != null && !this.when.isEmpty();
        }

        public boolean hasWhen() {
            return this.when != null && !this.when.isEmpty();
        }

        public TimingRepeatComponent setWhenElement(Enumeration<EventTiming> value) {
            this.when = value;
            return this;
        }

        public EventTiming getWhen() {
            return this.when == null ? null : (EventTiming)((Object)this.when.getValue());
        }

        public TimingRepeatComponent setWhen(EventTiming value) {
            if (value == null) {
                this.when = null;
            } else {
                if (this.when == null) {
                    this.when = new Enumeration<EventTiming>(new EventTimingEnumFactory());
                }
                this.when.setValue((Object)value);
            }
            return this;
        }

        public UnsignedIntType getOffsetElement() {
            if (this.offset == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TimingRepeatComponent.offset");
                }
                if (Configuration.doAutoCreate()) {
                    this.offset = new UnsignedIntType();
                }
            }
            return this.offset;
        }

        public boolean hasOffsetElement() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public boolean hasOffset() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public TimingRepeatComponent setOffsetElement(UnsignedIntType value) {
            this.offset = value;
            return this;
        }

        public int getOffset() {
            return this.offset == null || this.offset.isEmpty() ? 0 : (Integer)this.offset.getValue();
        }

        public TimingRepeatComponent setOffset(int value) {
            if (this.offset == null) {
                this.offset = new UnsignedIntType();
            }
            this.offset.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("bounds[x]", "Duration|Range|Period", "Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule.", 0, Integer.MAX_VALUE, this.bounds));
            childrenList.add(new Property("count", "integer", "A total count of the desired number of repetitions.", 0, Integer.MAX_VALUE, this.count));
            childrenList.add(new Property("countMax", "integer", "A maximum value for the count of the desired repetitions (e.g. do something 6-8 times).", 0, Integer.MAX_VALUE, this.countMax));
            childrenList.add(new Property("duration", "decimal", "How long this thing happens for when it happens.", 0, Integer.MAX_VALUE, this.duration));
            childrenList.add(new Property("durationMax", "decimal", "The upper limit of how long this thing happens for when it happens.", 0, Integer.MAX_VALUE, this.durationMax));
            childrenList.add(new Property("durationUnit", "code", "The units of time for the duration, in UCUM units.", 0, Integer.MAX_VALUE, this.durationUnit));
            childrenList.add(new Property("frequency", "integer", "The number of times to repeat the action within the specified period / period range (i.e. both period and periodMax provided).", 0, Integer.MAX_VALUE, this.frequency));
            childrenList.add(new Property("frequencyMax", "integer", "If present, indicates that the frequency is a range - so repeat between [frequency] and [frequencyMax] times within the period or period range.", 0, Integer.MAX_VALUE, this.frequencyMax));
            childrenList.add(new Property("period", "decimal", "Indicates the duration of time over which repetitions are to occur; e.g. to express \"3 times per day\", 3 would be the frequency and \"1 day\" would be the period.", 0, Integer.MAX_VALUE, this.period));
            childrenList.add(new Property("periodMax", "decimal", "If present, indicates that the period is a range from [period] to [periodMax], allowing expressing concepts such as \"do this once every 3-5 days.", 0, Integer.MAX_VALUE, this.periodMax));
            childrenList.add(new Property("periodUnit", "code", "The units of time for the period in UCUM units.", 0, Integer.MAX_VALUE, this.periodUnit));
            childrenList.add(new Property("when", "code", "A real world event that the occurrence of the event should be tied to.", 0, Integer.MAX_VALUE, this.when));
            childrenList.add(new Property("offset", "unsignedInt", "The number of minutes from the event. If the event code does not indicate whether the minutes is before or after the event, then the offset is assumed to be after the event.", 0, Integer.MAX_VALUE, this.offset));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1383205195: {
                    Base[] baseArray;
                    if (this.bounds == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.bounds;
                    }
                    return baseArray;
                }
                case 94851343: {
                    Base[] baseArray;
                    if (this.count == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.count;
                    }
                    return baseArray;
                }
                case -372044331: {
                    Base[] baseArray;
                    if (this.countMax == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.countMax;
                    }
                    return baseArray;
                }
                case -1992012396: {
                    Base[] baseArray;
                    if (this.duration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.duration;
                    }
                    return baseArray;
                }
                case -478083280: {
                    Base[] baseArray;
                    if (this.durationMax == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.durationMax;
                    }
                    return baseArray;
                }
                case -1935429320: {
                    Base[] baseArray;
                    if (this.durationUnit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.durationUnit;
                    }
                    return baseArray;
                }
                case -70023844: {
                    Base[] baseArray;
                    if (this.frequency == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.frequency;
                    }
                    return baseArray;
                }
                case 1273846376: {
                    Base[] baseArray;
                    if (this.frequencyMax == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.frequencyMax;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.period;
                    }
                    return baseArray;
                }
                case 566580195: {
                    Base[] baseArray;
                    if (this.periodMax == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.periodMax;
                    }
                    return baseArray;
                }
                case 384367333: {
                    Base[] baseArray;
                    if (this.periodUnit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.periodUnit;
                    }
                    return baseArray;
                }
                case 3648314: {
                    Base[] baseArray;
                    if (this.when == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.when;
                    }
                    return baseArray;
                }
                case -1019779949: {
                    Base[] baseArray;
                    if (this.offset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray14 = new Base[1];
                        baseArray = baseArray14;
                        baseArray14[0] = this.offset;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1383205195: {
                    this.bounds = (Type)value;
                    break;
                }
                case 94851343: {
                    this.count = this.castToInteger(value);
                    break;
                }
                case -372044331: {
                    this.countMax = this.castToInteger(value);
                    break;
                }
                case -1992012396: {
                    this.duration = this.castToDecimal(value);
                    break;
                }
                case -478083280: {
                    this.durationMax = this.castToDecimal(value);
                    break;
                }
                case -1935429320: {
                    this.durationUnit = new UnitsOfTimeEnumFactory().fromType(value);
                    break;
                }
                case -70023844: {
                    this.frequency = this.castToInteger(value);
                    break;
                }
                case 1273846376: {
                    this.frequencyMax = this.castToInteger(value);
                    break;
                }
                case -991726143: {
                    this.period = this.castToDecimal(value);
                    break;
                }
                case 566580195: {
                    this.periodMax = this.castToDecimal(value);
                    break;
                }
                case 384367333: {
                    this.periodUnit = new UnitsOfTimeEnumFactory().fromType(value);
                    break;
                }
                case 3648314: {
                    this.when = new EventTimingEnumFactory().fromType(value);
                    break;
                }
                case -1019779949: {
                    this.offset = this.castToUnsignedInt(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("bounds[x]")) {
                this.bounds = (Type)value;
            } else if (name.equals("count")) {
                this.count = this.castToInteger(value);
            } else if (name.equals("countMax")) {
                this.countMax = this.castToInteger(value);
            } else if (name.equals("duration")) {
                this.duration = this.castToDecimal(value);
            } else if (name.equals("durationMax")) {
                this.durationMax = this.castToDecimal(value);
            } else if (name.equals("durationUnit")) {
                this.durationUnit = new UnitsOfTimeEnumFactory().fromType(value);
            } else if (name.equals("frequency")) {
                this.frequency = this.castToInteger(value);
            } else if (name.equals("frequencyMax")) {
                this.frequencyMax = this.castToInteger(value);
            } else if (name.equals("period")) {
                this.period = this.castToDecimal(value);
            } else if (name.equals("periodMax")) {
                this.periodMax = this.castToDecimal(value);
            } else if (name.equals("periodUnit")) {
                this.periodUnit = new UnitsOfTimeEnumFactory().fromType(value);
            } else if (name.equals("when")) {
                this.when = new EventTimingEnumFactory().fromType(value);
            } else if (name.equals("offset")) {
                this.offset = this.castToUnsignedInt(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1149635157: {
                    return this.getBounds();
                }
                case 94851343: {
                    throw new FHIRException("Cannot make property count as it is not a complex type");
                }
                case -372044331: {
                    throw new FHIRException("Cannot make property countMax as it is not a complex type");
                }
                case -1992012396: {
                    throw new FHIRException("Cannot make property duration as it is not a complex type");
                }
                case -478083280: {
                    throw new FHIRException("Cannot make property durationMax as it is not a complex type");
                }
                case -1935429320: {
                    throw new FHIRException("Cannot make property durationUnit as it is not a complex type");
                }
                case -70023844: {
                    throw new FHIRException("Cannot make property frequency as it is not a complex type");
                }
                case 1273846376: {
                    throw new FHIRException("Cannot make property frequencyMax as it is not a complex type");
                }
                case -991726143: {
                    throw new FHIRException("Cannot make property period as it is not a complex type");
                }
                case 566580195: {
                    throw new FHIRException("Cannot make property periodMax as it is not a complex type");
                }
                case 384367333: {
                    throw new FHIRException("Cannot make property periodUnit as it is not a complex type");
                }
                case 3648314: {
                    throw new FHIRException("Cannot make property when as it is not a complex type");
                }
                case -1019779949: {
                    throw new FHIRException("Cannot make property offset as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("boundsDuration")) {
                this.bounds = new Duration();
                return this.bounds;
            }
            if (name.equals("boundsRange")) {
                this.bounds = new Range();
                return this.bounds;
            }
            if (name.equals("boundsPeriod")) {
                this.bounds = new Period();
                return this.bounds;
            }
            if (name.equals("count")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.count");
            }
            if (name.equals("countMax")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.countMax");
            }
            if (name.equals("duration")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.duration");
            }
            if (name.equals("durationMax")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.durationMax");
            }
            if (name.equals("durationUnit")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.durationUnit");
            }
            if (name.equals("frequency")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.frequency");
            }
            if (name.equals("frequencyMax")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.frequencyMax");
            }
            if (name.equals("period")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.period");
            }
            if (name.equals("periodMax")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.periodMax");
            }
            if (name.equals("periodUnit")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.periodUnit");
            }
            if (name.equals("when")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.when");
            }
            if (name.equals("offset")) {
                throw new FHIRException("Cannot call addChild on a primitive type Timing.offset");
            }
            return super.addChild(name);
        }

        @Override
        public TimingRepeatComponent copy() {
            TimingRepeatComponent dst = new TimingRepeatComponent();
            this.copyValues(dst);
            dst.bounds = this.bounds == null ? null : this.bounds.copy();
            dst.count = this.count == null ? null : this.count.copy();
            dst.countMax = this.countMax == null ? null : this.countMax.copy();
            dst.duration = this.duration == null ? null : this.duration.copy();
            dst.durationMax = this.durationMax == null ? null : this.durationMax.copy();
            dst.durationUnit = this.durationUnit == null ? null : this.durationUnit.copy();
            dst.frequency = this.frequency == null ? null : this.frequency.copy();
            dst.frequencyMax = this.frequencyMax == null ? null : this.frequencyMax.copy();
            dst.period = this.period == null ? null : this.period.copy();
            dst.periodMax = this.periodMax == null ? null : this.periodMax.copy();
            dst.periodUnit = this.periodUnit == null ? null : this.periodUnit.copy();
            dst.when = this.when == null ? null : this.when.copy();
            dst.offset = this.offset == null ? null : this.offset.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TimingRepeatComponent)) {
                return false;
            }
            TimingRepeatComponent o = (TimingRepeatComponent)other;
            return TimingRepeatComponent.compareDeep(this.bounds, o.bounds, true) && TimingRepeatComponent.compareDeep(this.count, o.count, true) && TimingRepeatComponent.compareDeep(this.countMax, o.countMax, true) && TimingRepeatComponent.compareDeep(this.duration, o.duration, true) && TimingRepeatComponent.compareDeep(this.durationMax, o.durationMax, true) && TimingRepeatComponent.compareDeep(this.durationUnit, o.durationUnit, true) && TimingRepeatComponent.compareDeep(this.frequency, o.frequency, true) && TimingRepeatComponent.compareDeep(this.frequencyMax, o.frequencyMax, true) && TimingRepeatComponent.compareDeep(this.period, o.period, true) && TimingRepeatComponent.compareDeep(this.periodMax, o.periodMax, true) && TimingRepeatComponent.compareDeep(this.periodUnit, o.periodUnit, true) && TimingRepeatComponent.compareDeep(this.when, o.when, true) && TimingRepeatComponent.compareDeep(this.offset, o.offset, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TimingRepeatComponent)) {
                return false;
            }
            TimingRepeatComponent o = (TimingRepeatComponent)other;
            return TimingRepeatComponent.compareValues(this.count, o.count, true) && TimingRepeatComponent.compareValues(this.countMax, o.countMax, true) && TimingRepeatComponent.compareValues(this.duration, o.duration, true) && TimingRepeatComponent.compareValues(this.durationMax, o.durationMax, true) && TimingRepeatComponent.compareValues(this.durationUnit, o.durationUnit, true) && TimingRepeatComponent.compareValues(this.frequency, o.frequency, true) && TimingRepeatComponent.compareValues(this.frequencyMax, o.frequencyMax, true) && TimingRepeatComponent.compareValues(this.period, o.period, true) && TimingRepeatComponent.compareValues(this.periodMax, o.periodMax, true) && TimingRepeatComponent.compareValues(this.periodUnit, o.periodUnit, true) && TimingRepeatComponent.compareValues(this.when, o.when, true) && TimingRepeatComponent.compareValues(this.offset, o.offset, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.bounds != null && !this.bounds.isEmpty() || this.count != null && !this.count.isEmpty() || this.countMax != null && !this.countMax.isEmpty() || this.duration != null && !this.duration.isEmpty() || this.durationMax != null && !this.durationMax.isEmpty() || this.durationUnit != null && !this.durationUnit.isEmpty() || this.frequency != null && !this.frequency.isEmpty() || this.frequencyMax != null && !this.frequencyMax.isEmpty() || this.period != null && !this.period.isEmpty() || this.periodMax != null && !this.periodMax.isEmpty() || this.periodUnit != null && !this.periodUnit.isEmpty() || this.when != null && !this.when.isEmpty() || this.offset != null && !this.offset.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Timing.repeat";
        }
    }

    public static class EventTimingEnumFactory
    implements EnumFactory<EventTiming> {
        @Override
        public EventTiming fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("HS".equals(codeString)) {
                return EventTiming.HS;
            }
            if ("WAKE".equals(codeString)) {
                return EventTiming.WAKE;
            }
            if ("C".equals(codeString)) {
                return EventTiming.C;
            }
            if ("CM".equals(codeString)) {
                return EventTiming.CM;
            }
            if ("CD".equals(codeString)) {
                return EventTiming.CD;
            }
            if ("CV".equals(codeString)) {
                return EventTiming.CV;
            }
            if ("AC".equals(codeString)) {
                return EventTiming.AC;
            }
            if ("ACM".equals(codeString)) {
                return EventTiming.ACM;
            }
            if ("ACD".equals(codeString)) {
                return EventTiming.ACD;
            }
            if ("ACV".equals(codeString)) {
                return EventTiming.ACV;
            }
            if ("PC".equals(codeString)) {
                return EventTiming.PC;
            }
            if ("PCM".equals(codeString)) {
                return EventTiming.PCM;
            }
            if ("PCD".equals(codeString)) {
                return EventTiming.PCD;
            }
            if ("PCV".equals(codeString)) {
                return EventTiming.PCV;
            }
            throw new IllegalArgumentException("Unknown EventTiming code '" + codeString + "'");
        }

        public Enumeration<EventTiming> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("HS".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.HS);
            }
            if ("WAKE".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.WAKE);
            }
            if ("C".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.C);
            }
            if ("CM".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.CM);
            }
            if ("CD".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.CD);
            }
            if ("CV".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.CV);
            }
            if ("AC".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.AC);
            }
            if ("ACM".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.ACM);
            }
            if ("ACD".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.ACD);
            }
            if ("ACV".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.ACV);
            }
            if ("PC".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.PC);
            }
            if ("PCM".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.PCM);
            }
            if ("PCD".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.PCD);
            }
            if ("PCV".equals(codeString)) {
                return new Enumeration<EventTiming>(this, EventTiming.PCV);
            }
            throw new FHIRException("Unknown EventTiming code '" + codeString + "'");
        }

        @Override
        public String toCode(EventTiming code) {
            if (code == EventTiming.HS) {
                return "HS";
            }
            if (code == EventTiming.WAKE) {
                return "WAKE";
            }
            if (code == EventTiming.C) {
                return "C";
            }
            if (code == EventTiming.CM) {
                return "CM";
            }
            if (code == EventTiming.CD) {
                return "CD";
            }
            if (code == EventTiming.CV) {
                return "CV";
            }
            if (code == EventTiming.AC) {
                return "AC";
            }
            if (code == EventTiming.ACM) {
                return "ACM";
            }
            if (code == EventTiming.ACD) {
                return "ACD";
            }
            if (code == EventTiming.ACV) {
                return "ACV";
            }
            if (code == EventTiming.PC) {
                return "PC";
            }
            if (code == EventTiming.PCM) {
                return "PCM";
            }
            if (code == EventTiming.PCD) {
                return "PCD";
            }
            if (code == EventTiming.PCV) {
                return "PCV";
            }
            return "?";
        }

        @Override
        public String toSystem(EventTiming code) {
            return code.getSystem();
        }
    }

    public static enum EventTiming {
        HS,
        WAKE,
        C,
        CM,
        CD,
        CV,
        AC,
        ACM,
        ACD,
        ACV,
        PC,
        PCM,
        PCD,
        PCV,
        NULL;


        public static EventTiming fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("HS".equals(codeString)) {
                return HS;
            }
            if ("WAKE".equals(codeString)) {
                return WAKE;
            }
            if ("C".equals(codeString)) {
                return C;
            }
            if ("CM".equals(codeString)) {
                return CM;
            }
            if ("CD".equals(codeString)) {
                return CD;
            }
            if ("CV".equals(codeString)) {
                return CV;
            }
            if ("AC".equals(codeString)) {
                return AC;
            }
            if ("ACM".equals(codeString)) {
                return ACM;
            }
            if ("ACD".equals(codeString)) {
                return ACD;
            }
            if ("ACV".equals(codeString)) {
                return ACV;
            }
            if ("PC".equals(codeString)) {
                return PC;
            }
            if ("PCM".equals(codeString)) {
                return PCM;
            }
            if ("PCD".equals(codeString)) {
                return PCD;
            }
            if ("PCV".equals(codeString)) {
                return PCV;
            }
            throw new FHIRException("Unknown EventTiming code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case HS: {
                    return "HS";
                }
                case WAKE: {
                    return "WAKE";
                }
                case C: {
                    return "C";
                }
                case CM: {
                    return "CM";
                }
                case CD: {
                    return "CD";
                }
                case CV: {
                    return "CV";
                }
                case AC: {
                    return "AC";
                }
                case ACM: {
                    return "ACM";
                }
                case ACD: {
                    return "ACD";
                }
                case ACV: {
                    return "ACV";
                }
                case PC: {
                    return "PC";
                }
                case PCM: {
                    return "PCM";
                }
                case PCD: {
                    return "PCD";
                }
                case PCV: {
                    return "PCV";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case HS: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case WAKE: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case C: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case CM: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case CD: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case CV: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case AC: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case ACM: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case ACD: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case ACV: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case PC: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case PCM: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case PCD: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
                case PCV: {
                    return "http://hl7.org/fhir/v3/TimingEvent";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case HS: {
                    return "";
                }
                case WAKE: {
                    return "";
                }
                case C: {
                    return "";
                }
                case CM: {
                    return "";
                }
                case CD: {
                    return "";
                }
                case CV: {
                    return "";
                }
                case AC: {
                    return "";
                }
                case ACM: {
                    return "";
                }
                case ACD: {
                    return "";
                }
                case ACV: {
                    return "";
                }
                case PC: {
                    return "";
                }
                case PCM: {
                    return "";
                }
                case PCD: {
                    return "";
                }
                case PCV: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case HS: {
                    return "HS";
                }
                case WAKE: {
                    return "WAKE";
                }
                case C: {
                    return "C";
                }
                case CM: {
                    return "CM";
                }
                case CD: {
                    return "CD";
                }
                case CV: {
                    return "CV";
                }
                case AC: {
                    return "AC";
                }
                case ACM: {
                    return "ACM";
                }
                case ACD: {
                    return "ACD";
                }
                case ACV: {
                    return "ACV";
                }
                case PC: {
                    return "PC";
                }
                case PCM: {
                    return "PCM";
                }
                case PCD: {
                    return "PCD";
                }
                case PCV: {
                    return "PCV";
                }
            }
            return "?";
        }
    }

    public static class UnitsOfTimeEnumFactory
    implements EnumFactory<UnitsOfTime> {
        @Override
        public UnitsOfTime fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("s".equals(codeString)) {
                return UnitsOfTime.S;
            }
            if ("min".equals(codeString)) {
                return UnitsOfTime.MIN;
            }
            if ("h".equals(codeString)) {
                return UnitsOfTime.H;
            }
            if ("d".equals(codeString)) {
                return UnitsOfTime.D;
            }
            if ("wk".equals(codeString)) {
                return UnitsOfTime.WK;
            }
            if ("mo".equals(codeString)) {
                return UnitsOfTime.MO;
            }
            if ("a".equals(codeString)) {
                return UnitsOfTime.A;
            }
            throw new IllegalArgumentException("Unknown UnitsOfTime code '" + codeString + "'");
        }

        public Enumeration<UnitsOfTime> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("s".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.S);
            }
            if ("min".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.MIN);
            }
            if ("h".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.H);
            }
            if ("d".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.D);
            }
            if ("wk".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.WK);
            }
            if ("mo".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.MO);
            }
            if ("a".equals(codeString)) {
                return new Enumeration<UnitsOfTime>(this, UnitsOfTime.A);
            }
            throw new FHIRException("Unknown UnitsOfTime code '" + codeString + "'");
        }

        @Override
        public String toCode(UnitsOfTime code) {
            if (code == UnitsOfTime.S) {
                return "s";
            }
            if (code == UnitsOfTime.MIN) {
                return "min";
            }
            if (code == UnitsOfTime.H) {
                return "h";
            }
            if (code == UnitsOfTime.D) {
                return "d";
            }
            if (code == UnitsOfTime.WK) {
                return "wk";
            }
            if (code == UnitsOfTime.MO) {
                return "mo";
            }
            if (code == UnitsOfTime.A) {
                return "a";
            }
            return "?";
        }

        @Override
        public String toSystem(UnitsOfTime code) {
            return code.getSystem();
        }
    }

    public static enum UnitsOfTime {
        S,
        MIN,
        H,
        D,
        WK,
        MO,
        A,
        NULL;


        public static UnitsOfTime fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("s".equals(codeString)) {
                return S;
            }
            if ("min".equals(codeString)) {
                return MIN;
            }
            if ("h".equals(codeString)) {
                return H;
            }
            if ("d".equals(codeString)) {
                return D;
            }
            if ("wk".equals(codeString)) {
                return WK;
            }
            if ("mo".equals(codeString)) {
                return MO;
            }
            if ("a".equals(codeString)) {
                return A;
            }
            throw new FHIRException("Unknown UnitsOfTime code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case S: {
                    return "s";
                }
                case MIN: {
                    return "min";
                }
                case H: {
                    return "h";
                }
                case D: {
                    return "d";
                }
                case WK: {
                    return "wk";
                }
                case MO: {
                    return "mo";
                }
                case A: {
                    return "a";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case S: {
                    return "http://unitsofmeasure.org";
                }
                case MIN: {
                    return "http://unitsofmeasure.org";
                }
                case H: {
                    return "http://unitsofmeasure.org";
                }
                case D: {
                    return "http://unitsofmeasure.org";
                }
                case WK: {
                    return "http://unitsofmeasure.org";
                }
                case MO: {
                    return "http://unitsofmeasure.org";
                }
                case A: {
                    return "http://unitsofmeasure.org";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case S: {
                    return "";
                }
                case MIN: {
                    return "";
                }
                case H: {
                    return "";
                }
                case D: {
                    return "";
                }
                case WK: {
                    return "";
                }
                case MO: {
                    return "";
                }
                case A: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case S: {
                    return "s";
                }
                case MIN: {
                    return "min";
                }
                case H: {
                    return "h";
                }
                case D: {
                    return "d";
                }
                case WK: {
                    return "wk";
                }
                case MO: {
                    return "mo";
                }
                case A: {
                    return "a";
                }
            }
            return "?";
        }
    }
}

