/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.EncounterState;

public class EncounterStateEnumFactory
implements EnumFactory<EncounterState> {
    @Override
    public EncounterState fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("planned".equals(codeString)) {
            return EncounterState.PLANNED;
        }
        if ("arrived".equals(codeString)) {
            return EncounterState.ARRIVED;
        }
        if ("in-progress".equals(codeString)) {
            return EncounterState.INPROGRESS;
        }
        if ("onleave".equals(codeString)) {
            return EncounterState.ONLEAVE;
        }
        if ("finished".equals(codeString)) {
            return EncounterState.FINISHED;
        }
        if ("cancelled".equals(codeString)) {
            return EncounterState.CANCELLED;
        }
        throw new IllegalArgumentException("Unknown EncounterState code '" + codeString + "'");
    }

    @Override
    public String toCode(EncounterState code) {
        if (code == EncounterState.PLANNED) {
            return "planned";
        }
        if (code == EncounterState.ARRIVED) {
            return "arrived";
        }
        if (code == EncounterState.INPROGRESS) {
            return "in-progress";
        }
        if (code == EncounterState.ONLEAVE) {
            return "onleave";
        }
        if (code == EncounterState.FINISHED) {
            return "finished";
        }
        if (code == EncounterState.CANCELLED) {
            return "cancelled";
        }
        return "?";
    }

    @Override
    public String toSystem(EncounterState code) {
        return code.getSystem();
    }
}

