/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ModuleMetadataFocusType {
    PATIENTGENDER,
    PATIENTAGEGROUP,
    CLINICALFOCUS,
    TARGETUSER,
    WORKFLOWSETTING,
    WORKFLOWTASK,
    CLINICALVENUE,
    JURISDICTION,
    NULL;


    public static ModuleMetadataFocusType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("patient-gender".equals(codeString)) {
            return PATIENTGENDER;
        }
        if ("patient-age-group".equals(codeString)) {
            return PATIENTAGEGROUP;
        }
        if ("clinical-focus".equals(codeString)) {
            return CLINICALFOCUS;
        }
        if ("target-user".equals(codeString)) {
            return TARGETUSER;
        }
        if ("workflow-setting".equals(codeString)) {
            return WORKFLOWSETTING;
        }
        if ("workflow-task".equals(codeString)) {
            return WORKFLOWTASK;
        }
        if ("clinical-venue".equals(codeString)) {
            return CLINICALVENUE;
        }
        if ("jurisdiction".equals(codeString)) {
            return JURISDICTION;
        }
        throw new FHIRException("Unknown ModuleMetadataFocusType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PATIENTGENDER: {
                return "patient-gender";
            }
            case PATIENTAGEGROUP: {
                return "patient-age-group";
            }
            case CLINICALFOCUS: {
                return "clinical-focus";
            }
            case TARGETUSER: {
                return "target-user";
            }
            case WORKFLOWSETTING: {
                return "workflow-setting";
            }
            case WORKFLOWTASK: {
                return "workflow-task";
            }
            case CLINICALVENUE: {
                return "clinical-venue";
            }
            case JURISDICTION: {
                return "jurisdiction";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/module-metadata-focus-type";
    }

    public String getDefinition() {
        switch (this) {
            case PATIENTGENDER: {
                return "The gender of the patient. For this item type, use HL7 administrative gender codes (OID: 2.16.840.1.113883.1.11.1)";
            }
            case PATIENTAGEGROUP: {
                return "A patient demographic category for which this artifact is applicable. Allows specification of age groups using coded values originating from the MeSH Code system (OID: 2.16.840.1.113883.6.177). More specifically, only codes from the AgeGroupObservationValue value set are valid for this field  [2.16.840.1.113883.11.75]";
            }
            case CLINICALFOCUS: {
                return "The clinical concept(s) addressed by the artifact.  For example, disease, diagnostic test interpretation, medication ordering. Please refer to the implementation guide on which code system and codes to use";
            }
            case TARGETUSER: {
                return "The user types to which an artifact is targeted.  For example, PCP, Patient, Cardiologist, Behavioral Professional, Oral Health Professional, Prescriber, etc... taken from the NUCC Health Care provider taxonomyCode system (OID: 2.16.840.1.113883.6.101)";
            }
            case WORKFLOWSETTING: {
                return "The settings in which the artifact is intended for use.  For example, admission, pre-op, etc";
            }
            case WORKFLOWTASK: {
                return "The context for the clinical task(s) represented by this artifact. Can be any task context represented by the HL7 ActTaskCode value set (OID: 2.16.840.1.113883.1.11.19846). General categories include: order entry, patient documentation and patient information review";
            }
            case CLINICALVENUE: {
                return "The venue in which an artifact could be used.  For example, Outpatient, Inpatient, Home, Nursing home. The code value may originate from either the HL7 ActEncounter (OID: 2.16.840.1.113883.1.11.13955) or NUCC non-individual provider codes OID: 2.16.840.1.113883.1.11.19465";
            }
            case JURISDICTION: {
                return "The jurisdiction in which the artifact is intended to be used";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PATIENTGENDER: {
                return "Patient Gender";
            }
            case PATIENTAGEGROUP: {
                return "Patient Age Group";
            }
            case CLINICALFOCUS: {
                return "Clinical Focus";
            }
            case TARGETUSER: {
                return "Target User";
            }
            case WORKFLOWSETTING: {
                return "Workflow Setting";
            }
            case WORKFLOWTASK: {
                return "Workflow Task";
            }
            case CLINICALVENUE: {
                return "Clinical Venue";
            }
            case JURISDICTION: {
                return "Jurisdiction";
            }
        }
        return "?";
    }
}

