/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum QuantityComparator {
    LESS_THAN,
    LESS_OR_EQUAL,
    GREATER_OR_EQUAL,
    GREATER_THAN,
    NULL;


    public static QuantityComparator fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("<".equals(codeString)) {
            return LESS_THAN;
        }
        if ("<=".equals(codeString)) {
            return LESS_OR_EQUAL;
        }
        if (">=".equals(codeString)) {
            return GREATER_OR_EQUAL;
        }
        if (">".equals(codeString)) {
            return GREATER_THAN;
        }
        throw new FHIRException("Unknown QuantityComparator code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case LESS_THAN: {
                return "<";
            }
            case LESS_OR_EQUAL: {
                return "<=";
            }
            case GREATER_OR_EQUAL: {
                return ">=";
            }
            case GREATER_THAN: {
                return ">";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/quantity-comparator";
    }

    public String getDefinition() {
        switch (this) {
            case LESS_THAN: {
                return "The actual value is less than the given value.";
            }
            case LESS_OR_EQUAL: {
                return "The actual value is less than or equal to the given value.";
            }
            case GREATER_OR_EQUAL: {
                return "The actual value is greater than or equal to the given value.";
            }
            case GREATER_THAN: {
                return "The actual value is greater than the given value.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case LESS_THAN: {
                return "Less than";
            }
            case LESS_OR_EQUAL: {
                return "Less or Equal to";
            }
            case GREATER_OR_EQUAL: {
                return "Greater or Equal to";
            }
            case GREATER_THAN: {
                return "Greater than";
            }
        }
        return "?";
    }
}

