/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.ActionDefinition;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Library;
import org.hl7.fhir.dstu2016may.model.ModuleMetadata;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.TriggerDefinition;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DecisionSupportRule", profile="http://hl7.org/fhir/Profile/DecisionSupportRule")
public class DecisionSupportRule
extends DomainResource {
    @Child(name="moduleMetadata", type={ModuleMetadata.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Module information for the rule", formalDefinition="The metadata for the decision support rule, including publishing, life-cycle, version, documentation, and supporting evidence.")
    protected ModuleMetadata moduleMetadata;
    @Child(name="library", type={Library.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Logic used within the rule", formalDefinition="A reference to a Library containing the formal logic used by the rule.")
    protected List<Reference> library;
    protected List<Library> libraryTarget;
    @Child(name="trigger", type={TriggerDefinition.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="\"when\" the rule should be invoked", formalDefinition="The trigger element defines when the rule should be invoked. This information is used by consumers of the rule to determine how to integrate the rule into a specific workflow.")
    protected List<TriggerDefinition> trigger;
    @Child(name="condition", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="\"if\" some condition is true", formalDefinition="The condition element describes he \"if\" portion of the rule that determines whether or not the rule \"fires\". The condition must be the name of an expression in a referenced library.")
    protected StringType condition;
    @Child(name="action", type={ActionDefinition.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="\"then\" perform these actions", formalDefinition="The action element defines the \"when\" portion of the rule that determines what actions should be performed if the condition evaluates to true.")
    protected List<ActionDefinition> action;
    private static final long serialVersionUID = -810482843L;
    @SearchParamDefinition(name="topic", path="DecisionSupportRule.moduleMetadata.topic", description="Topics associated with the module", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="title", path="DecisionSupportRule.moduleMetadata.title", description="Text search against the title", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="status", path="DecisionSupportRule.moduleMetadata.status", description="Status of the module", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="description", path="DecisionSupportRule.moduleMetadata.description", description="Text search against the description", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="DecisionSupportRule.moduleMetadata.identifier", description="Logical identifier for the module (e.g. CMS-143)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="DecisionSupportRule.moduleMetadata.version", description="Version of the module (e.g. 1.0.0)", type="string")
    public static final String SP_VERSION = "version";
    public static final StringClientParam VERSION = new StringClientParam("version");

    public ModuleMetadata getModuleMetadata() {
        if (this.moduleMetadata == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DecisionSupportRule.moduleMetadata");
            }
            if (Configuration.doAutoCreate()) {
                this.moduleMetadata = new ModuleMetadata();
            }
        }
        return this.moduleMetadata;
    }

    public boolean hasModuleMetadata() {
        return this.moduleMetadata != null && !this.moduleMetadata.isEmpty();
    }

    public DecisionSupportRule setModuleMetadata(ModuleMetadata value) {
        this.moduleMetadata = value;
        return this;
    }

    public List<Reference> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        return this.library;
    }

    public boolean hasLibrary() {
        if (this.library == null) {
            return false;
        }
        for (Reference item : this.library) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addLibrary() {
        Reference t = new Reference();
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        this.library.add(t);
        return t;
    }

    public DecisionSupportRule addLibrary(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        this.library.add(t);
        return this;
    }

    public List<Library> getLibraryTarget() {
        if (this.libraryTarget == null) {
            this.libraryTarget = new ArrayList<Library>();
        }
        return this.libraryTarget;
    }

    public Library addLibraryTarget() {
        Library r = new Library();
        if (this.libraryTarget == null) {
            this.libraryTarget = new ArrayList<Library>();
        }
        this.libraryTarget.add(r);
        return r;
    }

    public List<TriggerDefinition> getTrigger() {
        if (this.trigger == null) {
            this.trigger = new ArrayList<TriggerDefinition>();
        }
        return this.trigger;
    }

    public boolean hasTrigger() {
        if (this.trigger == null) {
            return false;
        }
        for (TriggerDefinition item : this.trigger) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TriggerDefinition addTrigger() {
        TriggerDefinition t = new TriggerDefinition();
        if (this.trigger == null) {
            this.trigger = new ArrayList<TriggerDefinition>();
        }
        this.trigger.add(t);
        return t;
    }

    public DecisionSupportRule addTrigger(TriggerDefinition t) {
        if (t == null) {
            return this;
        }
        if (this.trigger == null) {
            this.trigger = new ArrayList<TriggerDefinition>();
        }
        this.trigger.add(t);
        return this;
    }

    public StringType getConditionElement() {
        if (this.condition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DecisionSupportRule.condition");
            }
            if (Configuration.doAutoCreate()) {
                this.condition = new StringType();
            }
        }
        return this.condition;
    }

    public boolean hasConditionElement() {
        return this.condition != null && !this.condition.isEmpty();
    }

    public boolean hasCondition() {
        return this.condition != null && !this.condition.isEmpty();
    }

    public DecisionSupportRule setConditionElement(StringType value) {
        this.condition = value;
        return this;
    }

    public String getCondition() {
        return this.condition == null ? null : (String)this.condition.getValue();
    }

    public DecisionSupportRule setCondition(String value) {
        if (Utilities.noString((String)value)) {
            this.condition = null;
        } else {
            if (this.condition == null) {
                this.condition = new StringType();
            }
            this.condition.setValue(value);
        }
        return this;
    }

    public List<ActionDefinition> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<ActionDefinition>();
        }
        return this.action;
    }

    public boolean hasAction() {
        if (this.action == null) {
            return false;
        }
        for (ActionDefinition item : this.action) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ActionDefinition addAction() {
        ActionDefinition t = new ActionDefinition();
        if (this.action == null) {
            this.action = new ArrayList<ActionDefinition>();
        }
        this.action.add(t);
        return t;
    }

    public DecisionSupportRule addAction(ActionDefinition t) {
        if (t == null) {
            return this;
        }
        if (this.action == null) {
            this.action = new ArrayList<ActionDefinition>();
        }
        this.action.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("moduleMetadata", "ModuleMetadata", "The metadata for the decision support rule, including publishing, life-cycle, version, documentation, and supporting evidence.", 0, Integer.MAX_VALUE, this.moduleMetadata));
        childrenList.add(new Property("library", "Reference(Library)", "A reference to a Library containing the formal logic used by the rule.", 0, Integer.MAX_VALUE, this.library));
        childrenList.add(new Property("trigger", "TriggerDefinition", "The trigger element defines when the rule should be invoked. This information is used by consumers of the rule to determine how to integrate the rule into a specific workflow.", 0, Integer.MAX_VALUE, this.trigger));
        childrenList.add(new Property("condition", "string", "The condition element describes he \"if\" portion of the rule that determines whether or not the rule \"fires\". The condition must be the name of an expression in a referenced library.", 0, Integer.MAX_VALUE, this.condition));
        childrenList.add(new Property("action", "ActionDefinition", "The action element defines the \"when\" portion of the rule that determines what actions should be performed if the condition evaluates to true.", 0, Integer.MAX_VALUE, this.action));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 455891387: {
                Base[] baseArray;
                if (this.moduleMetadata == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.moduleMetadata;
                }
                return baseArray;
            }
            case 166208699: {
                return this.library == null ? new Base[]{} : this.library.toArray(new Base[this.library.size()]);
            }
            case -1059891784: {
                return this.trigger == null ? new Base[]{} : this.trigger.toArray(new Base[this.trigger.size()]);
            }
            case -861311717: {
                Base[] baseArray;
                if (this.condition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.condition;
                }
                return baseArray;
            }
            case -1422950858: {
                return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 455891387: {
                this.moduleMetadata = this.castToModuleMetadata(value);
                break;
            }
            case 166208699: {
                this.getLibrary().add(this.castToReference(value));
                break;
            }
            case -1059891784: {
                this.getTrigger().add(this.castToTriggerDefinition(value));
                break;
            }
            case -861311717: {
                this.condition = this.castToString(value);
                break;
            }
            case -1422950858: {
                this.getAction().add(this.castToActionDefinition(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("moduleMetadata")) {
            this.moduleMetadata = this.castToModuleMetadata(value);
        } else if (name.equals("library")) {
            this.getLibrary().add(this.castToReference(value));
        } else if (name.equals("trigger")) {
            this.getTrigger().add(this.castToTriggerDefinition(value));
        } else if (name.equals("condition")) {
            this.condition = this.castToString(value);
        } else if (name.equals("action")) {
            this.getAction().add(this.castToActionDefinition(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 455891387: {
                return this.getModuleMetadata();
            }
            case 166208699: {
                return this.addLibrary();
            }
            case -1059891784: {
                return this.addTrigger();
            }
            case -861311717: {
                throw new FHIRException("Cannot make property condition as it is not a complex type");
            }
            case -1422950858: {
                return this.addAction();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("moduleMetadata")) {
            this.moduleMetadata = new ModuleMetadata();
            return this.moduleMetadata;
        }
        if (name.equals("library")) {
            return this.addLibrary();
        }
        if (name.equals("trigger")) {
            return this.addTrigger();
        }
        if (name.equals("condition")) {
            throw new FHIRException("Cannot call addChild on a primitive type DecisionSupportRule.condition");
        }
        if (name.equals("action")) {
            return this.addAction();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DecisionSupportRule";
    }

    @Override
    public DecisionSupportRule copy() {
        DecisionSupportRule dst = new DecisionSupportRule();
        this.copyValues(dst);
        ModuleMetadata moduleMetadata = dst.moduleMetadata = this.moduleMetadata == null ? null : this.moduleMetadata.copy();
        if (this.library != null) {
            dst.library = new ArrayList<Reference>();
            for (Reference reference : this.library) {
                dst.library.add(reference.copy());
            }
        }
        if (this.trigger != null) {
            dst.trigger = new ArrayList<TriggerDefinition>();
            for (TriggerDefinition triggerDefinition : this.trigger) {
                dst.trigger.add(triggerDefinition.copy());
            }
        }
        StringType stringType = dst.condition = this.condition == null ? null : this.condition.copy();
        if (this.action != null) {
            dst.action = new ArrayList<ActionDefinition>();
            for (ActionDefinition actionDefinition : this.action) {
                dst.action.add(actionDefinition.copy());
            }
        }
        return dst;
    }

    protected DecisionSupportRule typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DecisionSupportRule)) {
            return false;
        }
        DecisionSupportRule o = (DecisionSupportRule)other;
        return DecisionSupportRule.compareDeep(this.moduleMetadata, o.moduleMetadata, true) && DecisionSupportRule.compareDeep(this.library, o.library, true) && DecisionSupportRule.compareDeep(this.trigger, o.trigger, true) && DecisionSupportRule.compareDeep(this.condition, o.condition, true) && DecisionSupportRule.compareDeep(this.action, o.action, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DecisionSupportRule)) {
            return false;
        }
        DecisionSupportRule o = (DecisionSupportRule)other;
        return DecisionSupportRule.compareValues(this.condition, o.condition, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.moduleMetadata != null && !this.moduleMetadata.isEmpty() || this.library != null && !this.library.isEmpty() || this.trigger != null && !this.trigger.isEmpty() || this.condition != null && !this.condition.isEmpty() || this.action != null && !this.action.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DecisionSupportRule;
    }
}

