/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Address;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Base64BinaryType;
import org.hl7.fhir.dstu2016may.model.BaseExtension;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.HumanName;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.InstantType;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.MarkdownType;
import org.hl7.fhir.dstu2016may.model.Meta;
import org.hl7.fhir.dstu2016may.model.OidType;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.PositiveIntType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Ratio;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.SampledData;
import org.hl7.fhir.dstu2016may.model.Signature;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.TimeType;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;

@DatatypeDef(name="Extension")
public class Extension
extends BaseExtension
implements IBaseExtension<Extension, Type>,
IBaseHasExtensions {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="identifies the meaning of the extension", formalDefinition="Source of the definition for the extension code - a logical name or a URL.")
    protected UriType url;
    @Child(name="value", type={}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Value of extension", formalDefinition="Value of extension - may be a resource or one of a constrained set of the data types (see Extensibility in the spec for list).")
    protected Type value;
    private static final long serialVersionUID = 1240831878L;

    public Extension() {
    }

    public Extension(UriType url) {
        this.url = url;
    }

    public Extension(String theUrl) {
        this.setUrl(theUrl);
    }

    public Extension(String theUrl, IBaseDatatype theValue) {
        this.setUrl(theUrl);
        this.setValue(theValue);
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Extension.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public Extension setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public Extension setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    public Type getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    @Override
    public Extension setValue(Type value) {
        this.value = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("url", "uri", "Source of the definition for the extension code - a logical name or a URL.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property("value[x]", "*", "Value of extension - may be a resource or one of a constrained set of the data types (see Extensibility in the spec for list).", 0, Integer.MAX_VALUE, this.value));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.value;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case 111972721: {
                this.value = (Type)value;
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("url")) {
            this.url = this.castToUri(value);
        } else if (name.equals("value[x]")) {
            this.value = (Type)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case -1410166417: {
                return this.getValue();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("url")) {
            throw new FHIRException("Cannot call addChild on a primitive type Extension.url");
        }
        if (name.equals("valueBoolean")) {
            this.value = new BooleanType();
            return this.value;
        }
        if (name.equals("valueInteger")) {
            this.value = new IntegerType();
            return this.value;
        }
        if (name.equals("valueDecimal")) {
            this.value = new DecimalType();
            return this.value;
        }
        if (name.equals("valueBase64Binary")) {
            this.value = new Base64BinaryType();
            return this.value;
        }
        if (name.equals("valueInstant")) {
            this.value = new InstantType();
            return this.value;
        }
        if (name.equals("valueString")) {
            this.value = new StringType();
            return this.value;
        }
        if (name.equals("valueUri")) {
            this.value = new UriType();
            return this.value;
        }
        if (name.equals("valueDate")) {
            this.value = new DateType();
            return this.value;
        }
        if (name.equals("valueDateTime")) {
            this.value = new DateTimeType();
            return this.value;
        }
        if (name.equals("valueTime")) {
            this.value = new TimeType();
            return this.value;
        }
        if (name.equals("valueCode")) {
            this.value = new CodeType();
            return this.value;
        }
        if (name.equals("valueOid")) {
            this.value = new OidType();
            return this.value;
        }
        if (name.equals("valueId")) {
            this.value = new IdType();
            return this.value;
        }
        if (name.equals("valueUnsignedInt")) {
            this.value = new UnsignedIntType();
            return this.value;
        }
        if (name.equals("valuePositiveInt")) {
            this.value = new PositiveIntType();
            return this.value;
        }
        if (name.equals("valueMarkdown")) {
            this.value = new MarkdownType();
            return this.value;
        }
        if (name.equals("valueAnnotation")) {
            this.value = new Annotation();
            return this.value;
        }
        if (name.equals("valueAttachment")) {
            this.value = new Attachment();
            return this.value;
        }
        if (name.equals("valueIdentifier")) {
            this.value = new Identifier();
            return this.value;
        }
        if (name.equals("valueCodeableConcept")) {
            this.value = new CodeableConcept();
            return this.value;
        }
        if (name.equals("valueCoding")) {
            this.value = new Coding();
            return this.value;
        }
        if (name.equals("valueQuantity")) {
            this.value = new Quantity();
            return this.value;
        }
        if (name.equals("valueRange")) {
            this.value = new Range();
            return this.value;
        }
        if (name.equals("valuePeriod")) {
            this.value = new Period();
            return this.value;
        }
        if (name.equals("valueRatio")) {
            this.value = new Ratio();
            return this.value;
        }
        if (name.equals("valueSampledData")) {
            this.value = new SampledData();
            return this.value;
        }
        if (name.equals("valueSignature")) {
            this.value = new Signature();
            return this.value;
        }
        if (name.equals("valueHumanName")) {
            this.value = new HumanName();
            return this.value;
        }
        if (name.equals("valueAddress")) {
            this.value = new Address();
            return this.value;
        }
        if (name.equals("valueContactPoint")) {
            this.value = new ContactPoint();
            return this.value;
        }
        if (name.equals("valueTiming")) {
            this.value = new Timing();
            return this.value;
        }
        if (name.equals("valueReference")) {
            this.value = new Reference();
            return this.value;
        }
        if (name.equals("valueMeta")) {
            this.value = new Meta();
            return this.value;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Extension";
    }

    @Override
    public Extension copy() {
        Extension dst = new Extension();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.value = this.value == null ? null : this.value.copy();
        return dst;
    }

    @Override
    protected Extension typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Extension)) {
            return false;
        }
        Extension o = (Extension)other;
        return Extension.compareDeep(this.url, o.url, true) && Extension.compareDeep(this.value, o.value, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Extension)) {
            return false;
        }
        Extension o = (Extension)other;
        return Extension.compareValues(this.url, o.url, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.value != null && !this.value.isEmpty());
    }
}

