/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Encounter;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.InstantType;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Questionnaire;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.TimeType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="QuestionnaireResponse", profile="http://hl7.org/fhir/Profile/QuestionnaireResponse")
public class QuestionnaireResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique id for this set of answers", formalDefinition="A business identifier assigned to a particular completed (or partially completed) questionnaire.")
    protected Identifier identifier;
    @Child(name="questionnaire", type={Questionnaire.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Form being answered", formalDefinition="Indicates the Questionnaire resource that defines the form for which answers are being provided.")
    protected Reference questionnaire;
    protected Questionnaire questionnaireTarget;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | completed | amended", formalDefinition="The lifecycle status of the questionnaire response as a whole.")
    protected Enumeration<QuestionnaireResponseStatus> status;
    @Child(name="subject", type={}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The subject of the questions", formalDefinition="The subject of the questionnaire response.  This could be a patient, organization, practitioner, device, etc.  This is who/what the answers apply to, but is not necessarily the source of information.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="author", type={Device.class, Practitioner.class, Patient.class, RelatedPerson.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Person who received and recorded the answers", formalDefinition="Person who received the answers to the questions in the QuestionnaireResponse and recorded them in the system.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="authored", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date this version was authored", formalDefinition="The date and/or time that this version of the questionnaire response was authored.")
    protected DateTimeType authored;
    @Child(name="source", type={Patient.class, Practitioner.class, RelatedPerson.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The person who answered the questions", formalDefinition="The person who answered the questions about the subject.")
    protected Reference source;
    protected Resource sourceTarget;
    @Child(name="encounter", type={Encounter.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Primary encounter during which the answers were collected", formalDefinition="Encounter during which this set of questionnaire response were collected. When there were multiple encounters, this is the one considered most relevant to the context of the answers.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="item", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Groups and questions", formalDefinition="Corresponds to a group or question item from the original questionnaire.")
    protected List<QuestionnaireResponseItemComponent> item;
    private static final long serialVersionUID = 850624885L;
    @SearchParamDefinition(name="author", path="QuestionnaireResponse.author", description="The author of the questionnaire", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("QuestionnaireResponse:author").toLocked();
    @SearchParamDefinition(name="questionnaire", path="QuestionnaireResponse.questionnaire", description="The questionnaire the answers are provided for", type="reference")
    public static final String SP_QUESTIONNAIRE = "questionnaire";
    public static final ReferenceClientParam QUESTIONNAIRE = new ReferenceClientParam("questionnaire");
    public static final Include INCLUDE_QUESTIONNAIRE = new Include("QuestionnaireResponse:questionnaire").toLocked();
    @SearchParamDefinition(name="patient", path="QuestionnaireResponse.subject", description="The patient that is the subject of the questionnaire", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("QuestionnaireResponse:patient").toLocked();
    @SearchParamDefinition(name="authored", path="QuestionnaireResponse.authored", description="When the questionnaire was authored", type="date")
    public static final String SP_AUTHORED = "authored";
    public static final DateClientParam AUTHORED = new DateClientParam("authored");
    @SearchParamDefinition(name="source", path="QuestionnaireResponse.source", description="The person who answered the questions", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("QuestionnaireResponse:source").toLocked();
    @SearchParamDefinition(name="status", path="QuestionnaireResponse.status", description="The status of the questionnaire response", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="QuestionnaireResponse.subject", description="The subject of the questionnaire", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("QuestionnaireResponse:subject").toLocked();
    @SearchParamDefinition(name="encounter", path="QuestionnaireResponse.encounter", description="Encounter during which questionnaire was authored", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("QuestionnaireResponse:encounter").toLocked();

    public QuestionnaireResponse() {
    }

    public QuestionnaireResponse(Enumeration<QuestionnaireResponseStatus> status) {
        this.status = status;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public QuestionnaireResponse setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Reference getQuestionnaire() {
        if (this.questionnaire == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.questionnaire");
            }
            if (Configuration.doAutoCreate()) {
                this.questionnaire = new Reference();
            }
        }
        return this.questionnaire;
    }

    public boolean hasQuestionnaire() {
        return this.questionnaire != null && !this.questionnaire.isEmpty();
    }

    public QuestionnaireResponse setQuestionnaire(Reference value) {
        this.questionnaire = value;
        return this;
    }

    public Questionnaire getQuestionnaireTarget() {
        if (this.questionnaireTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.questionnaire");
            }
            if (Configuration.doAutoCreate()) {
                this.questionnaireTarget = new Questionnaire();
            }
        }
        return this.questionnaireTarget;
    }

    public QuestionnaireResponse setQuestionnaireTarget(Questionnaire value) {
        this.questionnaireTarget = value;
        return this;
    }

    public Enumeration<QuestionnaireResponseStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<QuestionnaireResponseStatus>(new QuestionnaireResponseStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public QuestionnaireResponse setStatusElement(Enumeration<QuestionnaireResponseStatus> value) {
        this.status = value;
        return this;
    }

    public QuestionnaireResponseStatus getStatus() {
        return this.status == null ? null : (QuestionnaireResponseStatus)((Object)this.status.getValue());
    }

    public QuestionnaireResponse setStatus(QuestionnaireResponseStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<QuestionnaireResponseStatus>(new QuestionnaireResponseStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public QuestionnaireResponse setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public QuestionnaireResponse setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public QuestionnaireResponse setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public QuestionnaireResponse setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public DateTimeType getAuthoredElement() {
        if (this.authored == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.authored");
            }
            if (Configuration.doAutoCreate()) {
                this.authored = new DateTimeType();
            }
        }
        return this.authored;
    }

    public boolean hasAuthoredElement() {
        return this.authored != null && !this.authored.isEmpty();
    }

    public boolean hasAuthored() {
        return this.authored != null && !this.authored.isEmpty();
    }

    public QuestionnaireResponse setAuthoredElement(DateTimeType value) {
        this.authored = value;
        return this;
    }

    public Date getAuthored() {
        return this.authored == null ? null : (Date)this.authored.getValue();
    }

    public QuestionnaireResponse setAuthored(Date value) {
        if (value == null) {
            this.authored = null;
        } else {
            if (this.authored == null) {
                this.authored = new DateTimeType();
            }
            this.authored.setValue(value);
        }
        return this;
    }

    public Reference getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new Reference();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public QuestionnaireResponse setSource(Reference value) {
        this.source = value;
        return this;
    }

    public Resource getSourceTarget() {
        return this.sourceTarget;
    }

    public QuestionnaireResponse setSourceTarget(Resource value) {
        this.sourceTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public QuestionnaireResponse setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public QuestionnaireResponse setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public List<QuestionnaireResponseItemComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireResponseItemComponent>();
        }
        return this.item;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (QuestionnaireResponseItemComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public QuestionnaireResponseItemComponent addItem() {
        QuestionnaireResponseItemComponent t = new QuestionnaireResponseItemComponent();
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireResponseItemComponent>();
        }
        this.item.add(t);
        return t;
    }

    public QuestionnaireResponse addItem(QuestionnaireResponseItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireResponseItemComponent>();
        }
        this.item.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("identifier", "Identifier", "A business identifier assigned to a particular completed (or partially completed) questionnaire.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_QUESTIONNAIRE, "Reference(Questionnaire)", "Indicates the Questionnaire resource that defines the form for which answers are being provided.", 0, Integer.MAX_VALUE, this.questionnaire));
        childrenList.add(new Property(SP_STATUS, "code", "The lifecycle status of the questionnaire response as a whole.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Any)", "The subject of the questionnaire response.  This could be a patient, organization, practitioner, device, etc.  This is who/what the answers apply to, but is not necessarily the source of information.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_AUTHOR, "Reference(Device|Practitioner|Patient|RelatedPerson)", "Person who received the answers to the questions in the QuestionnaireResponse and recorded them in the system.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property(SP_AUTHORED, "dateTime", "The date and/or time that this version of the questionnaire response was authored.", 0, Integer.MAX_VALUE, this.authored));
        childrenList.add(new Property(SP_SOURCE, "Reference(Patient|Practitioner|RelatedPerson)", "The person who answered the questions about the subject.", 0, Integer.MAX_VALUE, this.source));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "Encounter during which this set of questionnaire response were collected. When there were multiple encounters, this is the one considered most relevant to the context of the answers.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property("item", "", "Corresponds to a group or question item from the original questionnaire.", 0, Integer.MAX_VALUE, this.item));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -1017049693: {
                Base[] baseArray;
                if (this.questionnaire == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.questionnaire;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.author;
                }
                return baseArray;
            }
            case 1433073514: {
                Base[] baseArray;
                if (this.authored == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.authored;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.source;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.encounter;
                }
                return baseArray;
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                break;
            }
            case -1017049693: {
                this.questionnaire = this.castToReference(value);
                break;
            }
            case -892481550: {
                this.status = new QuestionnaireResponseStatusEnumFactory().fromType(value);
                break;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                break;
            }
            case -1406328437: {
                this.author = this.castToReference(value);
                break;
            }
            case 1433073514: {
                this.authored = this.castToDateTime(value);
                break;
            }
            case -896505829: {
                this.source = this.castToReference(value);
                break;
            }
            case 1524132147: {
                this.encounter = this.castToReference(value);
                break;
            }
            case 3242771: {
                this.getItem().add((QuestionnaireResponseItemComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_QUESTIONNAIRE)) {
            this.questionnaire = this.castToReference(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new QuestionnaireResponseStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals(SP_AUTHORED)) {
            this.authored = this.castToDateTime(value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("item")) {
            this.getItem().add((QuestionnaireResponseItemComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -1017049693: {
                return this.getQuestionnaire();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case 1433073514: {
                throw new FHIRException("Cannot make property authored as it is not a complex type");
            }
            case -896505829: {
                return this.getSource();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 3242771: {
                return this.addItem();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_QUESTIONNAIRE)) {
            this.questionnaire = new Reference();
            return this.questionnaire;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type QuestionnaireResponse.status");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals(SP_AUTHORED)) {
            throw new FHIRException("Cannot call addChild on a primitive type QuestionnaireResponse.authored");
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "QuestionnaireResponse";
    }

    @Override
    public QuestionnaireResponse copy() {
        QuestionnaireResponse dst = new QuestionnaireResponse();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.questionnaire = this.questionnaire == null ? null : this.questionnaire.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.author = this.author == null ? null : this.author.copy();
        dst.authored = this.authored == null ? null : this.authored.copy();
        dst.source = this.source == null ? null : this.source.copy();
        Reference reference = dst.encounter = this.encounter == null ? null : this.encounter.copy();
        if (this.item != null) {
            dst.item = new ArrayList<QuestionnaireResponseItemComponent>();
            for (QuestionnaireResponseItemComponent i : this.item) {
                dst.item.add(i.copy());
            }
        }
        return dst;
    }

    protected QuestionnaireResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof QuestionnaireResponse)) {
            return false;
        }
        QuestionnaireResponse o = (QuestionnaireResponse)other;
        return QuestionnaireResponse.compareDeep(this.identifier, o.identifier, true) && QuestionnaireResponse.compareDeep(this.questionnaire, o.questionnaire, true) && QuestionnaireResponse.compareDeep(this.status, o.status, true) && QuestionnaireResponse.compareDeep(this.subject, o.subject, true) && QuestionnaireResponse.compareDeep(this.author, o.author, true) && QuestionnaireResponse.compareDeep(this.authored, o.authored, true) && QuestionnaireResponse.compareDeep(this.source, o.source, true) && QuestionnaireResponse.compareDeep(this.encounter, o.encounter, true) && QuestionnaireResponse.compareDeep(this.item, o.item, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof QuestionnaireResponse)) {
            return false;
        }
        QuestionnaireResponse o = (QuestionnaireResponse)other;
        return QuestionnaireResponse.compareValues(this.status, o.status, true) && QuestionnaireResponse.compareValues(this.authored, o.authored, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.questionnaire != null && !this.questionnaire.isEmpty() || this.status != null && !this.status.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.author != null && !this.author.isEmpty() || this.authored != null && !this.authored.isEmpty() || this.source != null && !this.source.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.item != null && !this.item.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.QuestionnaireResponse;
    }

    @Block
    public static class QuestionnaireResponseItemAnswerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={BooleanType.class, DecimalType.class, IntegerType.class, DateType.class, DateTimeType.class, InstantType.class, TimeType.class, StringType.class, UriType.class, Attachment.class, Coding.class, Quantity.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Single-valued answer to the question", formalDefinition="The answer (or one of the answers) provided by the respondent to the question.")
        protected Type value;
        @Child(name="item", type={QuestionnaireResponseItemComponent.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested groups and questions", formalDefinition="Nested groups and/or questions found within this particular answer.")
        protected List<QuestionnaireResponseItemComponent> item;
        private static final long serialVersionUID = 2052422636L;

        public Type getValue() {
            return this.value;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this.value instanceof BooleanType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this.value instanceof DecimalType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this.value instanceof IntegerType;
        }

        public DateType getValueDateType() throws FHIRException {
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this.value instanceof DateType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this.value instanceof DateTimeType;
        }

        public InstantType getValueInstantType() throws FHIRException {
            if (!(this.value instanceof InstantType)) {
                throw new FHIRException("Type mismatch: the type InstantType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (InstantType)this.value;
        }

        public boolean hasValueInstantType() {
            return this.value instanceof InstantType;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this.value instanceof TimeType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this.value instanceof StringType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this.value instanceof UriType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this.value instanceof Attachment;
        }

        public Coding getValueCoding() throws FHIRException {
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this.value instanceof Coding;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this.value instanceof Quantity;
        }

        public Reference getValueReference() throws FHIRException {
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this.value instanceof Reference;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public QuestionnaireResponseItemAnswerComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        public List<QuestionnaireResponseItemComponent> getItem() {
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireResponseItemComponent>();
            }
            return this.item;
        }

        public boolean hasItem() {
            if (this.item == null) {
                return false;
            }
            for (QuestionnaireResponseItemComponent item : this.item) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionnaireResponseItemComponent addItem() {
            QuestionnaireResponseItemComponent t = new QuestionnaireResponseItemComponent();
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireResponseItemComponent>();
            }
            this.item.add(t);
            return t;
        }

        public QuestionnaireResponseItemAnswerComponent addItem(QuestionnaireResponseItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireResponseItemComponent>();
            }
            this.item.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("value[x]", "boolean|decimal|integer|date|dateTime|instant|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "The answer (or one of the answers) provided by the respondent to the question.", 0, Integer.MAX_VALUE, this.value));
            childrenList.add(new Property("item", "@QuestionnaireResponse.item", "Nested groups and/or questions found within this particular answer.", 0, Integer.MAX_VALUE, this.item));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
                case 3242771: {
                    return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = (Type)value;
                    break;
                }
                case 3242771: {
                    this.getItem().add((QuestionnaireResponseItemComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else if (name.equals("item")) {
                this.getItem().add((QuestionnaireResponseItemComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1410166417: {
                    return this.getValue();
                }
                case 3242771: {
                    return this.addItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("item")) {
                return this.addItem();
            }
            return super.addChild(name);
        }

        @Override
        public QuestionnaireResponseItemAnswerComponent copy() {
            QuestionnaireResponseItemAnswerComponent dst = new QuestionnaireResponseItemAnswerComponent();
            this.copyValues(dst);
            Type type = dst.value = this.value == null ? null : this.value.copy();
            if (this.item != null) {
                dst.item = new ArrayList<QuestionnaireResponseItemComponent>();
                for (QuestionnaireResponseItemComponent i : this.item) {
                    dst.item.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof QuestionnaireResponseItemAnswerComponent)) {
                return false;
            }
            QuestionnaireResponseItemAnswerComponent o = (QuestionnaireResponseItemAnswerComponent)other;
            return QuestionnaireResponseItemAnswerComponent.compareDeep(this.value, o.value, true) && QuestionnaireResponseItemAnswerComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof QuestionnaireResponseItemAnswerComponent)) {
                return false;
            }
            QuestionnaireResponseItemAnswerComponent o = (QuestionnaireResponseItemAnswerComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.value != null && !this.value.isEmpty() || this.item != null && !this.item.isEmpty());
        }

        @Override
        public String fhirType() {
            return "QuestionnaireResponse.item.answer";
        }
    }

    @Block
    public static class QuestionnaireResponseItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="linkId", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Corresponding item within Questionnaire", formalDefinition="Identifies the item from the Questionnaire that corresponds to this item in the QuestionnaireResponse resource.")
        protected StringType linkId;
        @Child(name="text", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name for group or question text", formalDefinition="Text that is displayed above the contents of the group or as the text of the question being answered.")
        protected StringType text;
        @Child(name="subject", type={}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The subject this group's answers are about", formalDefinition="More specific subject this section's answers are about, details the subject given in QuestionnaireResponse.")
        protected Reference subject;
        protected Resource subjectTarget;
        @Child(name="answer", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The response(s) to the question", formalDefinition="The respondent's answer(s) to the question.")
        protected List<QuestionnaireResponseItemAnswerComponent> answer;
        @Child(name="item", type={QuestionnaireResponseItemComponent.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested questionnaire response items", formalDefinition="Questions or sub-groups nested beneath a question or group.")
        protected List<QuestionnaireResponseItemComponent> item;
        private static final long serialVersionUID = 1059526517L;

        public StringType getLinkIdElement() {
            if (this.linkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireResponseItemComponent.linkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkId = new StringType();
                }
            }
            return this.linkId;
        }

        public boolean hasLinkIdElement() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public boolean hasLinkId() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public QuestionnaireResponseItemComponent setLinkIdElement(StringType value) {
            this.linkId = value;
            return this;
        }

        public String getLinkId() {
            return this.linkId == null ? null : (String)this.linkId.getValue();
        }

        public QuestionnaireResponseItemComponent setLinkId(String value) {
            if (Utilities.noString((String)value)) {
                this.linkId = null;
            } else {
                if (this.linkId == null) {
                    this.linkId = new StringType();
                }
                this.linkId.setValue(value);
            }
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireResponseItemComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public QuestionnaireResponseItemComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public QuestionnaireResponseItemComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public Reference getSubject() {
            if (this.subject == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireResponseItemComponent.subject");
                }
                if (Configuration.doAutoCreate()) {
                    this.subject = new Reference();
                }
            }
            return this.subject;
        }

        public boolean hasSubject() {
            return this.subject != null && !this.subject.isEmpty();
        }

        public QuestionnaireResponseItemComponent setSubject(Reference value) {
            this.subject = value;
            return this;
        }

        public Resource getSubjectTarget() {
            return this.subjectTarget;
        }

        public QuestionnaireResponseItemComponent setSubjectTarget(Resource value) {
            this.subjectTarget = value;
            return this;
        }

        public List<QuestionnaireResponseItemAnswerComponent> getAnswer() {
            if (this.answer == null) {
                this.answer = new ArrayList<QuestionnaireResponseItemAnswerComponent>();
            }
            return this.answer;
        }

        public boolean hasAnswer() {
            if (this.answer == null) {
                return false;
            }
            for (QuestionnaireResponseItemAnswerComponent item : this.answer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionnaireResponseItemAnswerComponent addAnswer() {
            QuestionnaireResponseItemAnswerComponent t = new QuestionnaireResponseItemAnswerComponent();
            if (this.answer == null) {
                this.answer = new ArrayList<QuestionnaireResponseItemAnswerComponent>();
            }
            this.answer.add(t);
            return t;
        }

        public QuestionnaireResponseItemComponent addAnswer(QuestionnaireResponseItemAnswerComponent t) {
            if (t == null) {
                return this;
            }
            if (this.answer == null) {
                this.answer = new ArrayList<QuestionnaireResponseItemAnswerComponent>();
            }
            this.answer.add(t);
            return this;
        }

        public List<QuestionnaireResponseItemComponent> getItem() {
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireResponseItemComponent>();
            }
            return this.item;
        }

        public boolean hasItem() {
            if (this.item == null) {
                return false;
            }
            for (QuestionnaireResponseItemComponent item : this.item) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionnaireResponseItemComponent addItem() {
            QuestionnaireResponseItemComponent t = new QuestionnaireResponseItemComponent();
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireResponseItemComponent>();
            }
            this.item.add(t);
            return t;
        }

        public QuestionnaireResponseItemComponent addItem(QuestionnaireResponseItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireResponseItemComponent>();
            }
            this.item.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("linkId", "string", "Identifies the item from the Questionnaire that corresponds to this item in the QuestionnaireResponse resource.", 0, Integer.MAX_VALUE, this.linkId));
            childrenList.add(new Property("text", "string", "Text that is displayed above the contents of the group or as the text of the question being answered.", 0, Integer.MAX_VALUE, this.text));
            childrenList.add(new Property(QuestionnaireResponse.SP_SUBJECT, "Reference(Any)", "More specific subject this section's answers are about, details the subject given in QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.subject));
            childrenList.add(new Property("answer", "", "The respondent's answer(s) to the question.", 0, Integer.MAX_VALUE, this.answer));
            childrenList.add(new Property("item", "@QuestionnaireResponse.item", "Questions or sub-groups nested beneath a question or group.", 0, Integer.MAX_VALUE, this.item));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    Base[] baseArray;
                    if (this.linkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.linkId;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.text;
                    }
                    return baseArray;
                }
                case -1867885268: {
                    Base[] baseArray;
                    if (this.subject == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.subject;
                    }
                    return baseArray;
                }
                case -1412808770: {
                    return this.answer == null ? new Base[]{} : this.answer.toArray(new Base[this.answer.size()]);
                }
                case 3242771: {
                    return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    this.linkId = this.castToString(value);
                    break;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    break;
                }
                case -1867885268: {
                    this.subject = this.castToReference(value);
                    break;
                }
                case -1412808770: {
                    this.getAnswer().add((QuestionnaireResponseItemAnswerComponent)value);
                    break;
                }
                case 3242771: {
                    this.getItem().add((QuestionnaireResponseItemComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("linkId")) {
                this.linkId = this.castToString(value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals(QuestionnaireResponse.SP_SUBJECT)) {
                this.subject = this.castToReference(value);
            } else if (name.equals("answer")) {
                this.getAnswer().add((QuestionnaireResponseItemAnswerComponent)value);
            } else if (name.equals("item")) {
                this.getItem().add((QuestionnaireResponseItemComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    throw new FHIRException("Cannot make property linkId as it is not a complex type");
                }
                case 3556653: {
                    throw new FHIRException("Cannot make property text as it is not a complex type");
                }
                case -1867885268: {
                    return this.getSubject();
                }
                case -1412808770: {
                    return this.addAnswer();
                }
                case 3242771: {
                    return this.addItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type QuestionnaireResponse.linkId");
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type QuestionnaireResponse.text");
            }
            if (name.equals(QuestionnaireResponse.SP_SUBJECT)) {
                this.subject = new Reference();
                return this.subject;
            }
            if (name.equals("answer")) {
                return this.addAnswer();
            }
            if (name.equals("item")) {
                return this.addItem();
            }
            return super.addChild(name);
        }

        @Override
        public QuestionnaireResponseItemComponent copy() {
            QuestionnaireResponseItemComponent dst = new QuestionnaireResponseItemComponent();
            this.copyValues(dst);
            dst.linkId = this.linkId == null ? null : this.linkId.copy();
            dst.text = this.text == null ? null : this.text.copy();
            Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
            if (this.answer != null) {
                dst.answer = new ArrayList<QuestionnaireResponseItemAnswerComponent>();
                for (QuestionnaireResponseItemAnswerComponent questionnaireResponseItemAnswerComponent : this.answer) {
                    dst.answer.add(questionnaireResponseItemAnswerComponent.copy());
                }
            }
            if (this.item != null) {
                dst.item = new ArrayList<QuestionnaireResponseItemComponent>();
                for (QuestionnaireResponseItemComponent questionnaireResponseItemComponent : this.item) {
                    dst.item.add(questionnaireResponseItemComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof QuestionnaireResponseItemComponent)) {
                return false;
            }
            QuestionnaireResponseItemComponent o = (QuestionnaireResponseItemComponent)other;
            return QuestionnaireResponseItemComponent.compareDeep(this.linkId, o.linkId, true) && QuestionnaireResponseItemComponent.compareDeep(this.text, o.text, true) && QuestionnaireResponseItemComponent.compareDeep(this.subject, o.subject, true) && QuestionnaireResponseItemComponent.compareDeep(this.answer, o.answer, true) && QuestionnaireResponseItemComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof QuestionnaireResponseItemComponent)) {
                return false;
            }
            QuestionnaireResponseItemComponent o = (QuestionnaireResponseItemComponent)other;
            return QuestionnaireResponseItemComponent.compareValues(this.linkId, o.linkId, true) && QuestionnaireResponseItemComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.linkId != null && !this.linkId.isEmpty() || this.text != null && !this.text.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.answer != null && !this.answer.isEmpty() || this.item != null && !this.item.isEmpty());
        }

        @Override
        public String fhirType() {
            return "QuestionnaireResponse.item";
        }
    }

    public static class QuestionnaireResponseStatusEnumFactory
    implements EnumFactory<QuestionnaireResponseStatus> {
        @Override
        public QuestionnaireResponseStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return QuestionnaireResponseStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return QuestionnaireResponseStatus.COMPLETED;
            }
            if ("amended".equals(codeString)) {
                return QuestionnaireResponseStatus.AMENDED;
            }
            throw new IllegalArgumentException("Unknown QuestionnaireResponseStatus code '" + codeString + "'");
        }

        public Enumeration<QuestionnaireResponseStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<QuestionnaireResponseStatus>(this, QuestionnaireResponseStatus.INPROGRESS);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<QuestionnaireResponseStatus>(this, QuestionnaireResponseStatus.COMPLETED);
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<QuestionnaireResponseStatus>(this, QuestionnaireResponseStatus.AMENDED);
            }
            throw new FHIRException("Unknown QuestionnaireResponseStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(QuestionnaireResponseStatus code) {
            if (code == QuestionnaireResponseStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == QuestionnaireResponseStatus.COMPLETED) {
                return "completed";
            }
            if (code == QuestionnaireResponseStatus.AMENDED) {
                return "amended";
            }
            return "?";
        }

        @Override
        public String toSystem(QuestionnaireResponseStatus code) {
            return code.getSystem();
        }
    }

    public static enum QuestionnaireResponseStatus {
        INPROGRESS,
        COMPLETED,
        AMENDED,
        NULL;


        public static QuestionnaireResponseStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            throw new FHIRException("Unknown QuestionnaireResponseStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case AMENDED: {
                    return "amended";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/questionnaire-answers-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/questionnaire-answers-status";
                }
                case AMENDED: {
                    return "http://hl7.org/fhir/questionnaire-answers-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "This QuestionnaireResponse has been partially filled out with answers, but changes or additions are still expected to be made to it.";
                }
                case COMPLETED: {
                    return "This QuestionnaireResponse has been filled out with answers, and the current content is regarded as definitive.";
                }
                case AMENDED: {
                    return "This QuestionnaireResponse has been filled out with answers, then marked as complete, yet changes or additions have been made to it afterwards.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case AMENDED: {
                    return "Amended";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

