/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CardinalityBehavior {
    SINGLE,
    MULTIPLE,
    NULL;


    public static CardinalityBehavior fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("single".equals(codeString)) {
            return SINGLE;
        }
        if ("multiple".equals(codeString)) {
            return MULTIPLE;
        }
        throw new FHIRException("Unknown CardinalityBehavior code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SINGLE: {
                return "single";
            }
            case MULTIPLE: {
                return "multiple";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/cardinality-behavior";
    }

    public String getDefinition() {
        switch (this) {
            case SINGLE: {
                return "The item may only be selected one time";
            }
            case MULTIPLE: {
                return "The item may be selected multiple times";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SINGLE: {
                return "Single";
            }
            case MULTIPLE: {
                return "Multiple";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

