/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcObservationWeightPrecond {
    _84123,
    _84124,
    _84127,
    _84128,
    _84129,
    _84130,
    _84131,
    _84132,
    _84133,
    _84134,
    _84135,
    _84136,
    _84137,
    NULL;


    public static HspcObservationWeightPrecond fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("84123".equals(codeString)) {
            return _84123;
        }
        if ("84124".equals(codeString)) {
            return _84124;
        }
        if ("84127".equals(codeString)) {
            return _84127;
        }
        if ("84128".equals(codeString)) {
            return _84128;
        }
        if ("84129".equals(codeString)) {
            return _84129;
        }
        if ("84130".equals(codeString)) {
            return _84130;
        }
        if ("84131".equals(codeString)) {
            return _84131;
        }
        if ("84132".equals(codeString)) {
            return _84132;
        }
        if ("84133".equals(codeString)) {
            return _84133;
        }
        if ("84134".equals(codeString)) {
            return _84134;
        }
        if ("84135".equals(codeString)) {
            return _84135;
        }
        if ("84136".equals(codeString)) {
            return _84136;
        }
        if ("84137".equals(codeString)) {
            return _84137;
        }
        throw new FHIRException("Unknown HspcObservationWeightPrecond code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _84123: {
                return "84123";
            }
            case _84124: {
                return "84124";
            }
            case _84127: {
                return "84127";
            }
            case _84128: {
                return "84128";
            }
            case _84129: {
                return "84129";
            }
            case _84130: {
                return "84130";
            }
            case _84131: {
                return "84131";
            }
            case _84132: {
                return "84132";
            }
            case _84133: {
                return "84133";
            }
            case _84134: {
                return "84134";
            }
            case _84135: {
                return "84135";
            }
            case _84136: {
                return "84136";
            }
            case _84137: {
                return "84137";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/observation-hspc-weightPrecond";
    }

    public String getDefinition() {
        switch (this) {
            case _84123: {
                return "Body weight measured while clothed";
            }
            case _84124: {
                return "Body weight measured while unclothed";
            }
            case _84127: {
                return "Infant weight while wearing a diaper";
            }
            case _84128: {
                return "Infant weight without a diaper";
            }
            case _84129: {
                return "Body weight that includes a cast";
            }
            case _84130: {
                return "Body weight minus the weight of a cast";
            }
            case _84131: {
                return "Body weight including a prosthetic limb";
            }
            case _84132: {
                return "Body weight minus the weight of a prosthetic limb";
            }
            case _84133: {
                return "Body weight including a brace";
            }
            case _84134: {
                return "Body weight minus the weight of a brace";
            }
            case _84135: {
                return "Body weight including a gown or drape";
            }
            case _84136: {
                return "Body weight the includes some other weight";
            }
            case _84137: {
                return "Body weight after subtracting some other included weight";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _84123: {
                return "Weight with street clothes";
            }
            case _84124: {
                return "Weight without street clothes";
            }
            case _84127: {
                return "Weight with diapers";
            }
            case _84128: {
                return "Weight without diapers";
            }
            case _84129: {
                return "Weight with cast";
            }
            case _84130: {
                return "Weight without cast";
            }
            case _84131: {
                return "Weight with limb prosthesis";
            }
            case _84132: {
                return "Weight without limb prosthesis";
            }
            case _84133: {
                return "Weight with brace";
            }
            case _84134: {
                return "Weight without brace";
            }
            case _84135: {
                return "Weight with gown or drape";
            }
            case _84136: {
                return "Weight with added-on weight";
            }
            case _84137: {
                return "Weight without added-on weight";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

