/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MissingToothReason {
    E,
    C,
    U,
    O,
    NULL;


    public static MissingToothReason fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("E".equals(codeString)) {
            return E;
        }
        if ("C".equals(codeString)) {
            return C;
        }
        if ("U".equals(codeString)) {
            return U;
        }
        if ("O".equals(codeString)) {
            return O;
        }
        throw new FHIRException("Unknown MissingToothReason code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case E: {
                return "E";
            }
            case C: {
                return "C";
            }
            case U: {
                return "U";
            }
            case O: {
                return "O";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/missingtoothreason";
    }

    public String getDefinition() {
        switch (this) {
            case E: {
                return "Extraction";
            }
            case C: {
                return "Congenital";
            }
            case U: {
                return "Unknown";
            }
            case O: {
                return "Other";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case E: {
                return "E";
            }
            case C: {
                return "C";
            }
            case U: {
                return "U";
            }
            case O: {
                return "O";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

