/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.metamodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.JsonCreator;
import org.hl7.fhir.dstu2016may.formats.JsonCreatorCanonical;
import org.hl7.fhir.dstu2016may.formats.JsonCreatorGson;
import org.hl7.fhir.dstu2016may.metamodel.Element;
import org.hl7.fhir.dstu2016may.metamodel.ParserBase;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.utilities.Utilities;

public class JsonLDParser
extends ParserBase {
    private JsonCreator json;
    private String base;

    public JsonLDParser(IWorkerContext context) {
        super(context);
    }

    @Override
    public Element parse(InputStream stream) throws Exception {
        throw new NotImplementedException("not done yet");
    }

    protected void prop(String name, String value) throws IOException {
        if (name != null) {
            this.json.name(name);
        }
        this.json.value(value);
    }

    protected void open(String name) throws IOException {
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginObject();
    }

    protected void close() throws IOException {
        this.json.endObject();
    }

    protected void openArray(String name) throws IOException {
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginArray();
    }

    protected void closeArray() throws IOException {
        this.json.endArray();
    }

    @Override
    public void compose(Element e, OutputStream stream, IParser.OutputStyle style, String base) throws Exception {
        this.base = base;
        OutputStreamWriter osw = new OutputStreamWriter(stream, "UTF-8");
        this.json = style == IParser.OutputStyle.CANONICAL ? new JsonCreatorCanonical(osw) : new JsonCreatorGson(osw);
        this.json.setIndent(style == IParser.OutputStyle.PRETTY ? "  " : "");
        this.json.beginObject();
        this.prop("@context", "http://hl7.org/fhir/jsonld/" + e.getType());
        this.prop("resourceType", e.getType());
        HashSet<String> done = new HashSet<String>();
        for (Element child : e.getChildren()) {
            this.compose(e.getName(), e, done, child);
        }
        this.json.endObject();
        this.json.finish();
        osw.flush();
    }

    private void compose(String path, Element e, Set<String> done, Element child) throws IOException {
        if (!child.getProperty().isList()) {
            this.compose(path, child);
        } else if (!done.contains(child.getName())) {
            done.add(child.getName());
            List<Element> list = e.getChildrenByName(child.getName());
            this.composeList(path, list);
        }
    }

    private void composeList(String path, List<Element> list) throws IOException {
        String en = list.get(0).getProperty().getDefinition().getBase().getPath();
        if (en == null) {
            en = list.get(0).getProperty().getDefinition().getPath();
        }
        boolean doType = false;
        if (en.endsWith("[x]")) {
            en = en.substring(0, en.length() - 3);
            doType = true;
        }
        if (doType) {
            en = en + Utilities.capitalize((String)list.get(0).getType());
        }
        this.openArray(en);
        for (Element item : list) {
            this.open(null);
            if ((item.isPrimitive() || ParserBase.isPrimitive(item.getType())) && item.hasValue()) {
                this.primitiveValue(item);
            }
            HashSet<String> done = new HashSet<String>();
            for (Element child : item.getChildren()) {
                this.compose(path + "." + item.getName(), item, done, child);
            }
            this.close();
        }
        this.closeArray();
    }

    private void primitiveValue(Element item) throws IOException {
        this.json.name("value");
        String type = item.getType();
        if (Utilities.existsInList((String)type, (String[])new String[]{"boolean"})) {
            this.json.value(item.getValue().equals("true") ? new Boolean(true) : new Boolean(false));
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"integer", "unsignedInt", "positiveInt"})) {
            this.json.value(new Integer(item.getValue()));
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"decimal"})) {
            this.json.value(new BigDecimal(item.getValue()));
        } else {
            this.json.value(item.getValue());
        }
    }

    private void compose(String path, Element element) throws IOException {
        String en = element.getProperty().getDefinition().getBase().getPath();
        if (en == null) {
            en = element.getProperty().getDefinition().getPath();
        }
        boolean doType = false;
        if (en.endsWith("[x]")) {
            en = en.substring(0, en.length() - 3);
            doType = true;
        }
        if (doType) {
            en = en + Utilities.capitalize((String)element.getType());
        }
        if (element.hasChildren() || element.hasComments() || element.hasValue()) {
            this.open(en);
            if ((element.isPrimitive() || ParserBase.isPrimitive(element.getType())) && element.hasValue()) {
                this.primitiveValue(element);
            }
            if (element.getProperty().isResource()) {
                this.prop("resourceType", element.getType());
                element = element.getChildren().get(0);
            }
            HashSet<String> done = new HashSet<String>();
            for (Element child : element.getChildren()) {
                this.compose(path + "." + element.getName(), element, done, child);
            }
            if ("Coding".equals(element.getType())) {
                this.decorateCoding(element);
            }
            if ("CodeableConcept".equals(element.getType())) {
                this.decorateCodeableConcept(element);
            }
            if ("Reference".equals(element.getType())) {
                this.decorateReference(element);
            }
            this.close();
        }
    }

    private void decorateReference(Element element) throws IOException {
        String ref = element.getChildValue("reference");
        if (ref != null && (ref.startsWith("http://") || ref.startsWith("https://"))) {
            this.json.name("reference");
            this.json.value(ref);
        } else if (this.base != null && ref != null && ref.contains("/")) {
            this.json.name("reference");
            this.json.value(this.base + "/" + ref);
        }
    }

    protected void decorateCoding(Element coding) throws IOException {
        String system = coding.getChildValue("system");
        String code = coding.getChildValue("code");
        if (system == null) {
            return;
        }
        if ("http://snomed.info/sct".equals(system)) {
            this.json.name("concept");
            this.json.value("http://snomed.info/sct#" + code);
        } else if ("http://loinc.org".equals(system)) {
            this.json.name("concept");
            this.json.value("http://loinc.org/rdf#" + code);
        }
    }

    private void decorateCodeableConcept(Element element) throws IOException {
        for (Element c : element.getChildren("coding")) {
            this.decorateCoding(c);
        }
    }
}

