/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="OperationDefinition", profile="http://hl7.org/fhir/Profile/OperationDefinition")
public class OperationDefinition
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Logical URL to reference this operation definition", formalDefinition="An absolute URL that is used to identify this operation definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this operation definition is (or will be) published.")
    protected UriType url;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Logical id for this version of the operation definition", formalDefinition="The identifier that is used to identify this version of the profile when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Informal name for this operation", formalDefinition="A free text natural language name identifying the operation.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=false)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of the profile.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="kind", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="operation | query", formalDefinition="Whether this is an operation or a named query.")
    protected Enumeration<OperationKind> kind;
    @Child(name="experimental", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="This profile was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date for this version of the operation definition", formalDefinition="The date this version of the operation definition was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the Operation Definition changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="The name of the individual or organization that published the operation definition.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<OperationDefinitionContactComponent> contact;
    @Child(name="description", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the operation", formalDefinition="A free text natural language description of the profile and its use.")
    protected StringType description;
    @Child(name="useContext", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of operation definitions.")
    protected List<CodeableConcept> useContext;
    @Child(name="requirements", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this resource has been created", formalDefinition="Explains why this operation definition is needed and why it's been constrained as it has.")
    protected StringType requirements;
    @Child(name="idempotent", type={BooleanType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Whether content is unchanged by the operation", formalDefinition="Operations that are idempotent (see [HTTP specification definition of idempotent](http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html)) may be invoked by performing an HTTP GET operation instead of a POST.")
    protected BooleanType idempotent;
    @Child(name="code", type={CodeType.class}, order=13, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name used to invoke the operation", formalDefinition="The name used to invoke the operation.")
    protected CodeType code;
    @Child(name="comment", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information about use", formalDefinition="Additional information about how to use this operation or named query.")
    protected StringType comment;
    @Child(name="base", type={OperationDefinition.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Marks this as a profile of the base", formalDefinition="Indicates that this operation definition is a constraining profile on the base.")
    protected Reference base;
    protected OperationDefinition baseTarget;
    @Child(name="system", type={BooleanType.class}, order=16, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Invoke at the system level?", formalDefinition="Indicates whether this operation or named query can be invoked at the system level (e.g. without needing to choose a resource type for the context).")
    protected BooleanType system;
    @Child(name="type", type={CodeType.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Invoke at resource level for these type", formalDefinition="Indicates whether this operation or named query can be invoked at the resource type level for any given resource type level (e.g. without needing to choose a resource type for the context).")
    protected List<CodeType> type;
    @Child(name="instance", type={BooleanType.class}, order=18, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Invoke on an instance?", formalDefinition="Indicates whether this operation can be invoked on a particular instance of one of the given types.")
    protected BooleanType instance;
    @Child(name="parameter", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Parameters for the operation/query", formalDefinition="The parameters for the operation/query.")
    protected List<OperationDefinitionParameterComponent> parameter;
    private static final long serialVersionUID = 1780846105L;
    @SearchParamDefinition(name="status", path="OperationDefinition.status", description="draft | active | retired", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="paramprofile", path="OperationDefinition.parameter.profile", description="Profile on the type", type="reference")
    public static final String SP_PARAMPROFILE = "paramprofile";
    public static final ReferenceClientParam PARAMPROFILE = new ReferenceClientParam("paramprofile");
    public static final Include INCLUDE_PARAMPROFILE = new Include("OperationDefinition:paramprofile").toLocked();
    @SearchParamDefinition(name="code", path="OperationDefinition.code", description="Name used to invoke the operation", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="OperationDefinition.date", description="Date for this version of the operation definition", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="type", path="OperationDefinition.type", description="Invoke at resource level for these type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="url", path="OperationDefinition.url", description="Logical URL to reference this operation definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="kind", path="OperationDefinition.kind", description="operation | query", type="token")
    public static final String SP_KIND = "kind";
    public static final TokenClientParam KIND = new TokenClientParam("kind");
    @SearchParamDefinition(name="version", path="OperationDefinition.version", description="Logical id for this version of the operation definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="publisher", path="OperationDefinition.publisher", description="Name of the publisher (Organization or individual)", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="system", path="OperationDefinition.system", description="Invoke at the system level?", type="token")
    public static final String SP_SYSTEM = "system";
    public static final TokenClientParam SYSTEM = new TokenClientParam("system");
    @SearchParamDefinition(name="name", path="OperationDefinition.name", description="Informal name for this operation", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="OperationDefinition.useContext", description="A use context assigned to the operation definition", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="base", path="OperationDefinition.base", description="Marks this as a profile of the base", type="reference")
    public static final String SP_BASE = "base";
    public static final ReferenceClientParam BASE = new ReferenceClientParam("base");
    public static final Include INCLUDE_BASE = new Include("OperationDefinition:base").toLocked();
    @SearchParamDefinition(name="instance", path="OperationDefinition.instance", description="Invoke on an instance?", type="token")
    public static final String SP_INSTANCE = "instance";
    public static final TokenClientParam INSTANCE = new TokenClientParam("instance");

    public OperationDefinition() {
    }

    public OperationDefinition(StringType name, Enumeration<Enumerations.ConformanceResourceStatus> status, Enumeration<OperationKind> kind, CodeType code, BooleanType system, BooleanType instance) {
        this.name = name;
        this.status = status;
        this.kind = kind;
        this.code = code;
        this.system = system;
        this.instance = instance;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public OperationDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public OperationDefinition setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public OperationDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public OperationDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public OperationDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public OperationDefinition setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public OperationDefinition setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public OperationDefinition setStatus(Enumerations.ConformanceResourceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<OperationKind> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<OperationKind>(new OperationKindEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public OperationDefinition setKindElement(Enumeration<OperationKind> value) {
        this.kind = value;
        return this;
    }

    public OperationKind getKind() {
        return this.kind == null ? null : (OperationKind)((Object)this.kind.getValue());
    }

    public OperationDefinition setKind(OperationKind value) {
        if (this.kind == null) {
            this.kind = new Enumeration<OperationKind>(new OperationKindEnumFactory());
        }
        this.kind.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public OperationDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public OperationDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public OperationDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public OperationDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public OperationDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public OperationDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<OperationDefinitionContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<OperationDefinitionContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (OperationDefinitionContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OperationDefinitionContactComponent addContact() {
        OperationDefinitionContactComponent t = new OperationDefinitionContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<OperationDefinitionContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public OperationDefinition addContact(OperationDefinitionContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<OperationDefinitionContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public OperationDefinition setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public OperationDefinition setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (CodeableConcept item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUseContext() {
        CodeableConcept t = new CodeableConcept();
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return t;
    }

    public OperationDefinition addUseContext(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return this;
    }

    public StringType getRequirementsElement() {
        if (this.requirements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.requirements");
            }
            if (Configuration.doAutoCreate()) {
                this.requirements = new StringType();
            }
        }
        return this.requirements;
    }

    public boolean hasRequirementsElement() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public OperationDefinition setRequirementsElement(StringType value) {
        this.requirements = value;
        return this;
    }

    public String getRequirements() {
        return this.requirements == null ? null : (String)this.requirements.getValue();
    }

    public OperationDefinition setRequirements(String value) {
        if (Utilities.noString((String)value)) {
            this.requirements = null;
        } else {
            if (this.requirements == null) {
                this.requirements = new StringType();
            }
            this.requirements.setValue(value);
        }
        return this;
    }

    public BooleanType getIdempotentElement() {
        if (this.idempotent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.idempotent");
            }
            if (Configuration.doAutoCreate()) {
                this.idempotent = new BooleanType();
            }
        }
        return this.idempotent;
    }

    public boolean hasIdempotentElement() {
        return this.idempotent != null && !this.idempotent.isEmpty();
    }

    public boolean hasIdempotent() {
        return this.idempotent != null && !this.idempotent.isEmpty();
    }

    public OperationDefinition setIdempotentElement(BooleanType value) {
        this.idempotent = value;
        return this;
    }

    public boolean getIdempotent() {
        return this.idempotent == null || this.idempotent.isEmpty() ? false : (Boolean)this.idempotent.getValue();
    }

    public OperationDefinition setIdempotent(boolean value) {
        if (this.idempotent == null) {
            this.idempotent = new BooleanType();
        }
        this.idempotent.setValue((Object)value);
        return this;
    }

    public CodeType getCodeElement() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeType();
            }
        }
        return this.code;
    }

    public boolean hasCodeElement() {
        return this.code != null && !this.code.isEmpty();
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public OperationDefinition setCodeElement(CodeType value) {
        this.code = value;
        return this;
    }

    public String getCode() {
        return this.code == null ? null : (String)this.code.getValue();
    }

    public OperationDefinition setCode(String value) {
        if (this.code == null) {
            this.code = new CodeType();
        }
        this.code.setValue(value);
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public OperationDefinition setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public OperationDefinition setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public Reference getBase() {
        if (this.base == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.base");
            }
            if (Configuration.doAutoCreate()) {
                this.base = new Reference();
            }
        }
        return this.base;
    }

    public boolean hasBase() {
        return this.base != null && !this.base.isEmpty();
    }

    public OperationDefinition setBase(Reference value) {
        this.base = value;
        return this;
    }

    public OperationDefinition getBaseTarget() {
        if (this.baseTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.base");
            }
            if (Configuration.doAutoCreate()) {
                this.baseTarget = new OperationDefinition();
            }
        }
        return this.baseTarget;
    }

    public OperationDefinition setBaseTarget(OperationDefinition value) {
        this.baseTarget = value;
        return this;
    }

    public BooleanType getSystemElement() {
        if (this.system == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.system");
            }
            if (Configuration.doAutoCreate()) {
                this.system = new BooleanType();
            }
        }
        return this.system;
    }

    public boolean hasSystemElement() {
        return this.system != null && !this.system.isEmpty();
    }

    public boolean hasSystem() {
        return this.system != null && !this.system.isEmpty();
    }

    public OperationDefinition setSystemElement(BooleanType value) {
        this.system = value;
        return this;
    }

    public boolean getSystem() {
        return this.system == null || this.system.isEmpty() ? false : (Boolean)this.system.getValue();
    }

    public OperationDefinition setSystem(boolean value) {
        if (this.system == null) {
            this.system = new BooleanType();
        }
        this.system.setValue((Object)value);
        return this;
    }

    public List<CodeType> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeType>();
        }
        return this.type;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeType item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addTypeElement() {
        CodeType t = new CodeType();
        if (this.type == null) {
            this.type = new ArrayList<CodeType>();
        }
        this.type.add(t);
        return t;
    }

    public OperationDefinition addType(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.type == null) {
            this.type = new ArrayList<CodeType>();
        }
        this.type.add(t);
        return this;
    }

    public boolean hasType(String value) {
        if (this.type == null) {
            return false;
        }
        for (CodeType v : this.type) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public BooleanType getInstanceElement() {
        if (this.instance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.instance");
            }
            if (Configuration.doAutoCreate()) {
                this.instance = new BooleanType();
            }
        }
        return this.instance;
    }

    public boolean hasInstanceElement() {
        return this.instance != null && !this.instance.isEmpty();
    }

    public boolean hasInstance() {
        return this.instance != null && !this.instance.isEmpty();
    }

    public OperationDefinition setInstanceElement(BooleanType value) {
        this.instance = value;
        return this;
    }

    public boolean getInstance() {
        return this.instance == null || this.instance.isEmpty() ? false : (Boolean)this.instance.getValue();
    }

    public OperationDefinition setInstance(boolean value) {
        if (this.instance == null) {
            this.instance = new BooleanType();
        }
        this.instance.setValue((Object)value);
        return this;
    }

    public List<OperationDefinitionParameterComponent> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<OperationDefinitionParameterComponent>();
        }
        return this.parameter;
    }

    public boolean hasParameter() {
        if (this.parameter == null) {
            return false;
        }
        for (OperationDefinitionParameterComponent item : this.parameter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OperationDefinitionParameterComponent addParameter() {
        OperationDefinitionParameterComponent t = new OperationDefinitionParameterComponent();
        if (this.parameter == null) {
            this.parameter = new ArrayList<OperationDefinitionParameterComponent>();
        }
        this.parameter.add(t);
        return t;
    }

    public OperationDefinition addParameter(OperationDefinitionParameterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList<OperationDefinitionParameterComponent>();
        }
        this.parameter.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this operation definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this operation definition is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the profile when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_NAME, "string", "A free text natural language name identifying the operation.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "The status of the profile.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_KIND, SP_CODE, "Whether this is an operation or a named query.", 0, Integer.MAX_VALUE, this.kind));
        childrenList.add(new Property("experimental", "boolean", "This profile was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date this version of the operation definition was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the Operation Definition changes.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the operation definition.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property("description", "string", "A free text natural language description of the profile and its use.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("useContext", "CodeableConcept", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of operation definitions.", 0, Integer.MAX_VALUE, this.useContext));
        childrenList.add(new Property("requirements", "string", "Explains why this operation definition is needed and why it's been constrained as it has.", 0, Integer.MAX_VALUE, this.requirements));
        childrenList.add(new Property("idempotent", "boolean", "Operations that are idempotent (see [HTTP specification definition of idempotent](http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html)) may be invoked by performing an HTTP GET operation instead of a POST.", 0, Integer.MAX_VALUE, this.idempotent));
        childrenList.add(new Property(SP_CODE, SP_CODE, "The name used to invoke the operation.", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property("comment", "string", "Additional information about how to use this operation or named query.", 0, Integer.MAX_VALUE, this.comment));
        childrenList.add(new Property(SP_BASE, "Reference(OperationDefinition)", "Indicates that this operation definition is a constraining profile on the base.", 0, Integer.MAX_VALUE, this.base));
        childrenList.add(new Property(SP_SYSTEM, "boolean", "Indicates whether this operation or named query can be invoked at the system level (e.g. without needing to choose a resource type for the context).", 0, Integer.MAX_VALUE, this.system));
        childrenList.add(new Property(SP_TYPE, SP_CODE, "Indicates whether this operation or named query can be invoked at the resource type level for any given resource type level (e.g. without needing to choose a resource type for the context).", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_INSTANCE, "boolean", "Indicates whether this operation can be invoked on a particular instance of one of the given types.", 0, Integer.MAX_VALUE, this.instance));
        childrenList.add(new Property("parameter", "", "The parameters for the operation/query.", 0, Integer.MAX_VALUE, this.parameter));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.kind;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -1619874672: {
                Base[] baseArray;
                if (this.requirements == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.requirements;
                }
                return baseArray;
            }
            case 1680468793: {
                Base[] baseArray;
                if (this.idempotent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.idempotent;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.code;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.comment;
                }
                return baseArray;
            }
            case 3016401: {
                Base[] baseArray;
                if (this.base == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.base;
                }
                return baseArray;
            }
            case -887328209: {
                Base[] baseArray;
                if (this.system == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.system;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case 555127957: {
                Base[] baseArray;
                if (this.instance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.instance;
                }
                return baseArray;
            }
            case 1954460585: {
                return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case 351608024: {
                this.version = this.castToString(value);
                break;
            }
            case 3373707: {
                this.name = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
                break;
            }
            case 3292052: {
                this.kind = new OperationKindEnumFactory().fromType(value);
                break;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                break;
            }
            case 951526432: {
                this.getContact().add((OperationDefinitionContactComponent)value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -669707736: {
                this.getUseContext().add(this.castToCodeableConcept(value));
                break;
            }
            case -1619874672: {
                this.requirements = this.castToString(value);
                break;
            }
            case 1680468793: {
                this.idempotent = this.castToBoolean(value);
                break;
            }
            case 3059181: {
                this.code = this.castToCode(value);
                break;
            }
            case 950398559: {
                this.comment = this.castToString(value);
                break;
            }
            case 3016401: {
                this.base = this.castToReference(value);
                break;
            }
            case -887328209: {
                this.system = this.castToBoolean(value);
                break;
            }
            case 3575610: {
                this.getType().add(this.castToCode(value));
                break;
            }
            case 555127957: {
                this.instance = this.castToBoolean(value);
                break;
            }
            case 1954460585: {
                this.getParameter().add((OperationDefinitionParameterComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_KIND)) {
            this.kind = new OperationKindEnumFactory().fromType(value);
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((OperationDefinitionContactComponent)value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToCodeableConcept(value));
        } else if (name.equals("requirements")) {
            this.requirements = this.castToString(value);
        } else if (name.equals("idempotent")) {
            this.idempotent = this.castToBoolean(value);
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCode(value);
        } else if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else if (name.equals(SP_BASE)) {
            this.base = this.castToReference(value);
        } else if (name.equals(SP_SYSTEM)) {
            this.system = this.castToBoolean(value);
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(this.castToCode(value));
        } else if (name.equals(SP_INSTANCE)) {
            this.instance = this.castToBoolean(value);
        } else if (name.equals("parameter")) {
            this.getParameter().add((OperationDefinitionParameterComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case 351608024: {
                throw new FHIRException("Cannot make property version as it is not a complex type");
            }
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 3292052: {
                throw new FHIRException("Cannot make property kind as it is not a complex type");
            }
            case -404562712: {
                throw new FHIRException("Cannot make property experimental as it is not a complex type");
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case 1447404028: {
                throw new FHIRException("Cannot make property publisher as it is not a complex type");
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -1619874672: {
                throw new FHIRException("Cannot make property requirements as it is not a complex type");
            }
            case 1680468793: {
                throw new FHIRException("Cannot make property idempotent as it is not a complex type");
            }
            case 3059181: {
                throw new FHIRException("Cannot make property code as it is not a complex type");
            }
            case 950398559: {
                throw new FHIRException("Cannot make property comment as it is not a complex type");
            }
            case 3016401: {
                return this.getBase();
            }
            case -887328209: {
                throw new FHIRException("Cannot make property system as it is not a complex type");
            }
            case 3575610: {
                throw new FHIRException("Cannot make property type as it is not a complex type");
            }
            case 555127957: {
                throw new FHIRException("Cannot make property instance as it is not a complex type");
            }
            case 1954460585: {
                return this.addParameter();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.status");
        }
        if (name.equals(SP_KIND)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.kind");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("requirements")) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.requirements");
        }
        if (name.equals("idempotent")) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.idempotent");
        }
        if (name.equals(SP_CODE)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.code");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.comment");
        }
        if (name.equals(SP_BASE)) {
            this.base = new Reference();
            return this.base;
        }
        if (name.equals(SP_SYSTEM)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.system");
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.type");
        }
        if (name.equals(SP_INSTANCE)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.instance");
        }
        if (name.equals("parameter")) {
            return this.addParameter();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "OperationDefinition";
    }

    @Override
    public OperationDefinition copy() {
        OperationDefinition dst = new OperationDefinition();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.kind = this.kind == null ? null : this.kind.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<OperationDefinitionContactComponent>();
            for (OperationDefinitionContactComponent operationDefinitionContactComponent : this.contact) {
                dst.contact.add(operationDefinitionContactComponent.copy());
            }
        }
        StringType stringType2 = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.useContext) {
                dst.useContext.add(codeableConcept.copy());
            }
        }
        dst.requirements = this.requirements == null ? null : this.requirements.copy();
        dst.idempotent = this.idempotent == null ? null : this.idempotent.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        dst.base = this.base == null ? null : this.base.copy();
        BooleanType booleanType = dst.system = this.system == null ? null : this.system.copy();
        if (this.type != null) {
            dst.type = new ArrayList<CodeType>();
            for (CodeType codeType : this.type) {
                dst.type.add(codeType.copy());
            }
        }
        BooleanType booleanType2 = dst.instance = this.instance == null ? null : this.instance.copy();
        if (this.parameter != null) {
            dst.parameter = new ArrayList<OperationDefinitionParameterComponent>();
            for (OperationDefinitionParameterComponent operationDefinitionParameterComponent : this.parameter) {
                dst.parameter.add(operationDefinitionParameterComponent.copy());
            }
        }
        return dst;
    }

    protected OperationDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof OperationDefinition)) {
            return false;
        }
        OperationDefinition o = (OperationDefinition)other;
        return OperationDefinition.compareDeep(this.url, o.url, true) && OperationDefinition.compareDeep(this.version, o.version, true) && OperationDefinition.compareDeep(this.name, o.name, true) && OperationDefinition.compareDeep(this.status, o.status, true) && OperationDefinition.compareDeep(this.kind, o.kind, true) && OperationDefinition.compareDeep(this.experimental, o.experimental, true) && OperationDefinition.compareDeep(this.date, o.date, true) && OperationDefinition.compareDeep(this.publisher, o.publisher, true) && OperationDefinition.compareDeep(this.contact, o.contact, true) && OperationDefinition.compareDeep(this.description, o.description, true) && OperationDefinition.compareDeep(this.useContext, o.useContext, true) && OperationDefinition.compareDeep(this.requirements, o.requirements, true) && OperationDefinition.compareDeep(this.idempotent, o.idempotent, true) && OperationDefinition.compareDeep(this.code, o.code, true) && OperationDefinition.compareDeep(this.comment, o.comment, true) && OperationDefinition.compareDeep(this.base, o.base, true) && OperationDefinition.compareDeep(this.system, o.system, true) && OperationDefinition.compareDeep(this.type, o.type, true) && OperationDefinition.compareDeep(this.instance, o.instance, true) && OperationDefinition.compareDeep(this.parameter, o.parameter, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof OperationDefinition)) {
            return false;
        }
        OperationDefinition o = (OperationDefinition)other;
        return OperationDefinition.compareValues(this.url, o.url, true) && OperationDefinition.compareValues(this.version, o.version, true) && OperationDefinition.compareValues(this.name, o.name, true) && OperationDefinition.compareValues(this.status, o.status, true) && OperationDefinition.compareValues(this.kind, o.kind, true) && OperationDefinition.compareValues(this.experimental, o.experimental, true) && OperationDefinition.compareValues(this.date, o.date, true) && OperationDefinition.compareValues(this.publisher, o.publisher, true) && OperationDefinition.compareValues(this.description, o.description, true) && OperationDefinition.compareValues(this.requirements, o.requirements, true) && OperationDefinition.compareValues(this.idempotent, o.idempotent, true) && OperationDefinition.compareValues(this.code, o.code, true) && OperationDefinition.compareValues(this.comment, o.comment, true) && OperationDefinition.compareValues(this.system, o.system, true) && OperationDefinition.compareValues(this.type, o.type, true) && OperationDefinition.compareValues(this.instance, o.instance, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.version != null && !this.version.isEmpty() || this.name != null && !this.name.isEmpty() || this.status != null && !this.status.isEmpty() || this.kind != null && !this.kind.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.date != null && !this.date.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.description != null && !this.description.isEmpty() || this.useContext != null && !this.useContext.isEmpty() || this.requirements != null && !this.requirements.isEmpty() || this.idempotent != null && !this.idempotent.isEmpty() || this.code != null && !this.code.isEmpty() || this.comment != null && !this.comment.isEmpty() || this.base != null && !this.base.isEmpty() || this.system != null && !this.system.isEmpty() || this.type != null && !this.type.isEmpty() || this.instance != null && !this.instance.isEmpty() || this.parameter != null && !this.parameter.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.OperationDefinition;
    }

    @Block
    public static class OperationDefinitionParameterBindingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="strength", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="required | extensible | preferred | example", formalDefinition="Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances.")
        protected Enumeration<Enumerations.BindingStrength> strength;
        @Child(name="valueSet", type={UriType.class, ValueSet.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Source of value set", formalDefinition="Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used.")
        protected Type valueSet;
        private static final long serialVersionUID = 857140521L;

        public OperationDefinitionParameterBindingComponent() {
        }

        public OperationDefinitionParameterBindingComponent(Enumeration<Enumerations.BindingStrength> strength, Type valueSet) {
            this.strength = strength;
            this.valueSet = valueSet;
        }

        public Enumeration<Enumerations.BindingStrength> getStrengthElement() {
            if (this.strength == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterBindingComponent.strength");
                }
                if (Configuration.doAutoCreate()) {
                    this.strength = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
                }
            }
            return this.strength;
        }

        public boolean hasStrengthElement() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public OperationDefinitionParameterBindingComponent setStrengthElement(Enumeration<Enumerations.BindingStrength> value) {
            this.strength = value;
            return this;
        }

        public Enumerations.BindingStrength getStrength() {
            return this.strength == null ? null : (Enumerations.BindingStrength)((Object)this.strength.getValue());
        }

        public OperationDefinitionParameterBindingComponent setStrength(Enumerations.BindingStrength value) {
            if (this.strength == null) {
                this.strength = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
            }
            this.strength.setValue((Object)value);
            return this;
        }

        public Type getValueSet() {
            return this.valueSet;
        }

        public UriType getValueSetUriType() throws FHIRException {
            if (!(this.valueSet instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.valueSet.getClass().getName() + " was encountered");
            }
            return (UriType)this.valueSet;
        }

        public boolean hasValueSetUriType() {
            return this.valueSet instanceof UriType;
        }

        public Reference getValueSetReference() throws FHIRException {
            if (!(this.valueSet instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.valueSet.getClass().getName() + " was encountered");
            }
            return (Reference)this.valueSet;
        }

        public boolean hasValueSetReference() {
            return this.valueSet instanceof Reference;
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public OperationDefinitionParameterBindingComponent setValueSet(Type value) {
            this.valueSet = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("strength", OperationDefinition.SP_CODE, "Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances.", 0, Integer.MAX_VALUE, this.strength));
            childrenList.add(new Property("valueSet[x]", "uri|Reference(ValueSet)", "Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used.", 0, Integer.MAX_VALUE, this.valueSet));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    Base[] baseArray;
                    if (this.strength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.strength;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.valueSet;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    this.strength = new Enumerations.BindingStrengthEnumFactory().fromType(value);
                    break;
                }
                case -1410174671: {
                    this.valueSet = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("strength")) {
                this.strength = new Enumerations.BindingStrengthEnumFactory().fromType(value);
            } else if (name.equals("valueSet[x]")) {
                this.valueSet = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    throw new FHIRException("Cannot make property strength as it is not a complex type");
                }
                case -1438410321: {
                    return this.getValueSet();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("strength")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.strength");
            }
            if (name.equals("valueSetUri")) {
                this.valueSet = new UriType();
                return this.valueSet;
            }
            if (name.equals("valueSetReference")) {
                this.valueSet = new Reference();
                return this.valueSet;
            }
            return super.addChild(name);
        }

        @Override
        public OperationDefinitionParameterBindingComponent copy() {
            OperationDefinitionParameterBindingComponent dst = new OperationDefinitionParameterBindingComponent();
            this.copyValues(dst);
            dst.strength = this.strength == null ? null : this.strength.copy();
            dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof OperationDefinitionParameterBindingComponent)) {
                return false;
            }
            OperationDefinitionParameterBindingComponent o = (OperationDefinitionParameterBindingComponent)other;
            return OperationDefinitionParameterBindingComponent.compareDeep(this.strength, o.strength, true) && OperationDefinitionParameterBindingComponent.compareDeep(this.valueSet, o.valueSet, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof OperationDefinitionParameterBindingComponent)) {
                return false;
            }
            OperationDefinitionParameterBindingComponent o = (OperationDefinitionParameterBindingComponent)other;
            return OperationDefinitionParameterBindingComponent.compareValues(this.strength, o.strength, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.strength != null && !this.strength.isEmpty() || this.valueSet != null && !this.valueSet.isEmpty());
        }

        @Override
        public String fhirType() {
            return "OperationDefinition.parameter.binding";
        }
    }

    @Block
    public static class OperationDefinitionParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name in Parameters.parameter.name or in URL", formalDefinition="The name of used to identify the parameter.")
        protected CodeType name;
        @Child(name="use", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="in | out", formalDefinition="Whether this is an input or an output parameter.")
        protected Enumeration<OperationParameterUse> use;
        @Child(name="min", type={IntegerType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Minimum Cardinality", formalDefinition="The minimum number of times this parameter SHALL appear in the request or response.")
        protected IntegerType min;
        @Child(name="max", type={StringType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Maximum Cardinality (a number or *)", formalDefinition="The maximum number of times this element is permitted to appear in the request or response.")
        protected StringType max;
        @Child(name="documentation", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of meaning/use", formalDefinition="Describes the meaning or use of this parameter.")
        protected StringType documentation;
        @Child(name="type", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What type this parameter has", formalDefinition="The type for this parameter.")
        protected CodeType type;
        @Child(name="searchType", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="number | date | string | token | reference | composite | quantity | uri", formalDefinition="How the parameter is understood as a search parameter. This is only used if the parameter type is 'string'.")
        protected Enumeration<Enumerations.SearchParamType> searchType;
        @Child(name="profile", type={StructureDefinition.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Profile on the type", formalDefinition="A profile the specifies the rules that this parameter must conform to.")
        protected Reference profile;
        protected StructureDefinition profileTarget;
        @Child(name="binding", type={}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="ValueSet details if this is coded", formalDefinition="Binds to a value set if this parameter is coded (code, Coding, CodeableConcept).")
        protected OperationDefinitionParameterBindingComponent binding;
        @Child(name="part", type={OperationDefinitionParameterComponent.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Parts of a Tuple Parameter", formalDefinition="The parts of a Tuple Parameter.")
        protected List<OperationDefinitionParameterComponent> part;
        private static final long serialVersionUID = -885506257L;

        public OperationDefinitionParameterComponent() {
        }

        public OperationDefinitionParameterComponent(CodeType name, Enumeration<OperationParameterUse> use, IntegerType min, StringType max) {
            this.name = name;
            this.use = use;
            this.min = min;
            this.max = max;
        }

        public CodeType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new CodeType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public OperationDefinitionParameterComponent setNameElement(CodeType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public OperationDefinitionParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new CodeType();
            }
            this.name.setValue(value);
            return this;
        }

        public Enumeration<OperationParameterUse> getUseElement() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new Enumeration<OperationParameterUse>(new OperationParameterUseEnumFactory());
                }
            }
            return this.use;
        }

        public boolean hasUseElement() {
            return this.use != null && !this.use.isEmpty();
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public OperationDefinitionParameterComponent setUseElement(Enumeration<OperationParameterUse> value) {
            this.use = value;
            return this;
        }

        public OperationParameterUse getUse() {
            return this.use == null ? null : (OperationParameterUse)((Object)this.use.getValue());
        }

        public OperationDefinitionParameterComponent setUse(OperationParameterUse value) {
            if (this.use == null) {
                this.use = new Enumeration<OperationParameterUse>(new OperationParameterUseEnumFactory());
            }
            this.use.setValue((Object)value);
            return this;
        }

        public IntegerType getMinElement() {
            if (this.min == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.min");
                }
                if (Configuration.doAutoCreate()) {
                    this.min = new IntegerType();
                }
            }
            return this.min;
        }

        public boolean hasMinElement() {
            return this.min != null && !this.min.isEmpty();
        }

        public boolean hasMin() {
            return this.min != null && !this.min.isEmpty();
        }

        public OperationDefinitionParameterComponent setMinElement(IntegerType value) {
            this.min = value;
            return this;
        }

        public int getMin() {
            return this.min == null || this.min.isEmpty() ? 0 : (Integer)this.min.getValue();
        }

        public OperationDefinitionParameterComponent setMin(int value) {
            if (this.min == null) {
                this.min = new IntegerType();
            }
            this.min.setValue((Object)value);
            return this;
        }

        public StringType getMaxElement() {
            if (this.max == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.max");
                }
                if (Configuration.doAutoCreate()) {
                    this.max = new StringType();
                }
            }
            return this.max;
        }

        public boolean hasMaxElement() {
            return this.max != null && !this.max.isEmpty();
        }

        public boolean hasMax() {
            return this.max != null && !this.max.isEmpty();
        }

        public OperationDefinitionParameterComponent setMaxElement(StringType value) {
            this.max = value;
            return this;
        }

        public String getMax() {
            return this.max == null ? null : (String)this.max.getValue();
        }

        public OperationDefinitionParameterComponent setMax(String value) {
            if (this.max == null) {
                this.max = new StringType();
            }
            this.max.setValue(value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public OperationDefinitionParameterComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public OperationDefinitionParameterComponent setDocumentation(String value) {
            if (Utilities.noString((String)value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public OperationDefinitionParameterComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public OperationDefinitionParameterComponent setType(String value) {
            if (Utilities.noString((String)value)) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new CodeType();
                }
                this.type.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.SearchParamType> getSearchTypeElement() {
            if (this.searchType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.searchType");
                }
                if (Configuration.doAutoCreate()) {
                    this.searchType = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
                }
            }
            return this.searchType;
        }

        public boolean hasSearchTypeElement() {
            return this.searchType != null && !this.searchType.isEmpty();
        }

        public boolean hasSearchType() {
            return this.searchType != null && !this.searchType.isEmpty();
        }

        public OperationDefinitionParameterComponent setSearchTypeElement(Enumeration<Enumerations.SearchParamType> value) {
            this.searchType = value;
            return this;
        }

        public Enumerations.SearchParamType getSearchType() {
            return this.searchType == null ? null : (Enumerations.SearchParamType)((Object)this.searchType.getValue());
        }

        public OperationDefinitionParameterComponent setSearchType(Enumerations.SearchParamType value) {
            if (value == null) {
                this.searchType = null;
            } else {
                if (this.searchType == null) {
                    this.searchType = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
                }
                this.searchType.setValue((Object)value);
            }
            return this;
        }

        public Reference getProfile() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new Reference();
                }
            }
            return this.profile;
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public OperationDefinitionParameterComponent setProfile(Reference value) {
            this.profile = value;
            return this;
        }

        public StructureDefinition getProfileTarget() {
            if (this.profileTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profileTarget = new StructureDefinition();
                }
            }
            return this.profileTarget;
        }

        public OperationDefinitionParameterComponent setProfileTarget(StructureDefinition value) {
            this.profileTarget = value;
            return this;
        }

        public OperationDefinitionParameterBindingComponent getBinding() {
            if (this.binding == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.binding");
                }
                if (Configuration.doAutoCreate()) {
                    this.binding = new OperationDefinitionParameterBindingComponent();
                }
            }
            return this.binding;
        }

        public boolean hasBinding() {
            return this.binding != null && !this.binding.isEmpty();
        }

        public OperationDefinitionParameterComponent setBinding(OperationDefinitionParameterBindingComponent value) {
            this.binding = value;
            return this;
        }

        public List<OperationDefinitionParameterComponent> getPart() {
            if (this.part == null) {
                this.part = new ArrayList<OperationDefinitionParameterComponent>();
            }
            return this.part;
        }

        public boolean hasPart() {
            if (this.part == null) {
                return false;
            }
            for (OperationDefinitionParameterComponent item : this.part) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OperationDefinitionParameterComponent addPart() {
            OperationDefinitionParameterComponent t = new OperationDefinitionParameterComponent();
            if (this.part == null) {
                this.part = new ArrayList<OperationDefinitionParameterComponent>();
            }
            this.part.add(t);
            return t;
        }

        public OperationDefinitionParameterComponent addPart(OperationDefinitionParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.part == null) {
                this.part = new ArrayList<OperationDefinitionParameterComponent>();
            }
            this.part.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(OperationDefinition.SP_NAME, OperationDefinition.SP_CODE, "The name of used to identify the parameter.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("use", OperationDefinition.SP_CODE, "Whether this is an input or an output parameter.", 0, Integer.MAX_VALUE, this.use));
            childrenList.add(new Property("min", "integer", "The minimum number of times this parameter SHALL appear in the request or response.", 0, Integer.MAX_VALUE, this.min));
            childrenList.add(new Property("max", "string", "The maximum number of times this element is permitted to appear in the request or response.", 0, Integer.MAX_VALUE, this.max));
            childrenList.add(new Property("documentation", "string", "Describes the meaning or use of this parameter.", 0, Integer.MAX_VALUE, this.documentation));
            childrenList.add(new Property(OperationDefinition.SP_TYPE, OperationDefinition.SP_CODE, "The type for this parameter.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("searchType", OperationDefinition.SP_CODE, "How the parameter is understood as a search parameter. This is only used if the parameter type is 'string'.", 0, Integer.MAX_VALUE, this.searchType));
            childrenList.add(new Property("profile", "Reference(StructureDefinition)", "A profile the specifies the rules that this parameter must conform to.", 0, Integer.MAX_VALUE, this.profile));
            childrenList.add(new Property("binding", "", "Binds to a value set if this parameter is coded (code, Coding, CodeableConcept).", 0, Integer.MAX_VALUE, this.binding));
            childrenList.add(new Property("part", "@OperationDefinition.parameter", "The parts of a Tuple Parameter.", 0, Integer.MAX_VALUE, this.part));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.use;
                    }
                    return baseArray;
                }
                case 108114: {
                    Base[] baseArray;
                    if (this.min == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.min;
                    }
                    return baseArray;
                }
                case 107876: {
                    Base[] baseArray;
                    if (this.max == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.max;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.documentation;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.type;
                    }
                    return baseArray;
                }
                case -710454014: {
                    Base[] baseArray;
                    if (this.searchType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.searchType;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.profile;
                    }
                    return baseArray;
                }
                case -108220795: {
                    Base[] baseArray;
                    if (this.binding == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.binding;
                    }
                    return baseArray;
                }
                case 3433459: {
                    return this.part == null ? new Base[]{} : this.part.toArray(new Base[this.part.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToCode(value);
                    break;
                }
                case 116103: {
                    this.use = new OperationParameterUseEnumFactory().fromType(value);
                    break;
                }
                case 108114: {
                    this.min = this.castToInteger(value);
                    break;
                }
                case 107876: {
                    this.max = this.castToString(value);
                    break;
                }
                case 1587405498: {
                    this.documentation = this.castToString(value);
                    break;
                }
                case 3575610: {
                    this.type = this.castToCode(value);
                    break;
                }
                case -710454014: {
                    this.searchType = new Enumerations.SearchParamTypeEnumFactory().fromType(value);
                    break;
                }
                case -309425751: {
                    this.profile = this.castToReference(value);
                    break;
                }
                case -108220795: {
                    this.binding = (OperationDefinitionParameterBindingComponent)value;
                    break;
                }
                case 3433459: {
                    this.getPart().add((OperationDefinitionParameterComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(OperationDefinition.SP_NAME)) {
                this.name = this.castToCode(value);
            } else if (name.equals("use")) {
                this.use = new OperationParameterUseEnumFactory().fromType(value);
            } else if (name.equals("min")) {
                this.min = this.castToInteger(value);
            } else if (name.equals("max")) {
                this.max = this.castToString(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else if (name.equals(OperationDefinition.SP_TYPE)) {
                this.type = this.castToCode(value);
            } else if (name.equals("searchType")) {
                this.searchType = new Enumerations.SearchParamTypeEnumFactory().fromType(value);
            } else if (name.equals("profile")) {
                this.profile = this.castToReference(value);
            } else if (name.equals("binding")) {
                this.binding = (OperationDefinitionParameterBindingComponent)value;
            } else if (name.equals("part")) {
                this.getPart().add((OperationDefinitionParameterComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case 116103: {
                    throw new FHIRException("Cannot make property use as it is not a complex type");
                }
                case 108114: {
                    throw new FHIRException("Cannot make property min as it is not a complex type");
                }
                case 107876: {
                    throw new FHIRException("Cannot make property max as it is not a complex type");
                }
                case 1587405498: {
                    throw new FHIRException("Cannot make property documentation as it is not a complex type");
                }
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case -710454014: {
                    throw new FHIRException("Cannot make property searchType as it is not a complex type");
                }
                case -309425751: {
                    return this.getProfile();
                }
                case -108220795: {
                    return this.getBinding();
                }
                case 3433459: {
                    return this.addPart();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(OperationDefinition.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.name");
            }
            if (name.equals("use")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.use");
            }
            if (name.equals("min")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.min");
            }
            if (name.equals("max")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.max");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.documentation");
            }
            if (name.equals(OperationDefinition.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.type");
            }
            if (name.equals("searchType")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.searchType");
            }
            if (name.equals("profile")) {
                this.profile = new Reference();
                return this.profile;
            }
            if (name.equals("binding")) {
                this.binding = new OperationDefinitionParameterBindingComponent();
                return this.binding;
            }
            if (name.equals("part")) {
                return this.addPart();
            }
            return super.addChild(name);
        }

        @Override
        public OperationDefinitionParameterComponent copy() {
            OperationDefinitionParameterComponent dst = new OperationDefinitionParameterComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.use = this.use == null ? null : this.use.copy();
            dst.min = this.min == null ? null : this.min.copy();
            dst.max = this.max == null ? null : this.max.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.searchType = this.searchType == null ? null : this.searchType.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
            OperationDefinitionParameterBindingComponent operationDefinitionParameterBindingComponent = dst.binding = this.binding == null ? null : this.binding.copy();
            if (this.part != null) {
                dst.part = new ArrayList<OperationDefinitionParameterComponent>();
                for (OperationDefinitionParameterComponent i : this.part) {
                    dst.part.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof OperationDefinitionParameterComponent)) {
                return false;
            }
            OperationDefinitionParameterComponent o = (OperationDefinitionParameterComponent)other;
            return OperationDefinitionParameterComponent.compareDeep(this.name, o.name, true) && OperationDefinitionParameterComponent.compareDeep(this.use, o.use, true) && OperationDefinitionParameterComponent.compareDeep(this.min, o.min, true) && OperationDefinitionParameterComponent.compareDeep(this.max, o.max, true) && OperationDefinitionParameterComponent.compareDeep(this.documentation, o.documentation, true) && OperationDefinitionParameterComponent.compareDeep(this.type, o.type, true) && OperationDefinitionParameterComponent.compareDeep(this.searchType, o.searchType, true) && OperationDefinitionParameterComponent.compareDeep(this.profile, o.profile, true) && OperationDefinitionParameterComponent.compareDeep(this.binding, o.binding, true) && OperationDefinitionParameterComponent.compareDeep(this.part, o.part, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof OperationDefinitionParameterComponent)) {
                return false;
            }
            OperationDefinitionParameterComponent o = (OperationDefinitionParameterComponent)other;
            return OperationDefinitionParameterComponent.compareValues(this.name, o.name, true) && OperationDefinitionParameterComponent.compareValues(this.use, o.use, true) && OperationDefinitionParameterComponent.compareValues(this.min, o.min, true) && OperationDefinitionParameterComponent.compareValues(this.max, o.max, true) && OperationDefinitionParameterComponent.compareValues(this.documentation, o.documentation, true) && OperationDefinitionParameterComponent.compareValues(this.type, o.type, true) && OperationDefinitionParameterComponent.compareValues(this.searchType, o.searchType, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.use != null && !this.use.isEmpty() || this.min != null && !this.min.isEmpty() || this.max != null && !this.max.isEmpty() || this.documentation != null && !this.documentation.isEmpty() || this.type != null && !this.type.isEmpty() || this.searchType != null && !this.searchType.isEmpty() || this.profile != null && !this.profile.isEmpty() || this.binding != null && !this.binding.isEmpty() || this.part != null && !this.part.isEmpty());
        }

        @Override
        public String fhirType() {
            return "OperationDefinition.parameter";
        }
    }

    @Block
    public static class OperationDefinitionContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the operation definition.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public OperationDefinitionContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public OperationDefinitionContactComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public OperationDefinitionContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(OperationDefinition.SP_NAME, "string", "The name of an individual to contact regarding the operation definition.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(OperationDefinition.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1429363305: {
                    return this.addTelecom();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(OperationDefinition.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public OperationDefinitionContactComponent copy() {
            OperationDefinitionContactComponent dst = new OperationDefinitionContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof OperationDefinitionContactComponent)) {
                return false;
            }
            OperationDefinitionContactComponent o = (OperationDefinitionContactComponent)other;
            return OperationDefinitionContactComponent.compareDeep(this.name, o.name, true) && OperationDefinitionContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof OperationDefinitionContactComponent)) {
                return false;
            }
            OperationDefinitionContactComponent o = (OperationDefinitionContactComponent)other;
            return OperationDefinitionContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "OperationDefinition.contact";
        }
    }

    public static class OperationParameterUseEnumFactory
    implements EnumFactory<OperationParameterUse> {
        @Override
        public OperationParameterUse fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in".equals(codeString)) {
                return OperationParameterUse.IN;
            }
            if ("out".equals(codeString)) {
                return OperationParameterUse.OUT;
            }
            throw new IllegalArgumentException("Unknown OperationParameterUse code '" + codeString + "'");
        }

        public Enumeration<OperationParameterUse> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in".equals(codeString)) {
                return new Enumeration<OperationParameterUse>(this, OperationParameterUse.IN);
            }
            if ("out".equals(codeString)) {
                return new Enumeration<OperationParameterUse>(this, OperationParameterUse.OUT);
            }
            throw new FHIRException("Unknown OperationParameterUse code '" + codeString + "'");
        }

        @Override
        public String toCode(OperationParameterUse code) {
            if (code == OperationParameterUse.IN) {
                return "in";
            }
            if (code == OperationParameterUse.OUT) {
                return "out";
            }
            return "?";
        }

        @Override
        public String toSystem(OperationParameterUse code) {
            return code.getSystem();
        }
    }

    public static enum OperationParameterUse {
        IN,
        OUT,
        NULL;


        public static OperationParameterUse fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in".equals(codeString)) {
                return IN;
            }
            if ("out".equals(codeString)) {
                return OUT;
            }
            throw new FHIRException("Unknown OperationParameterUse code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case IN: {
                    return "in";
                }
                case OUT: {
                    return "out";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case IN: {
                    return "http://hl7.org/fhir/operation-parameter-use";
                }
                case OUT: {
                    return "http://hl7.org/fhir/operation-parameter-use";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case IN: {
                    return "This is an input parameter.";
                }
                case OUT: {
                    return "This is an output parameter.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case IN: {
                    return "In";
                }
                case OUT: {
                    return "Out";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class OperationKindEnumFactory
    implements EnumFactory<OperationKind> {
        @Override
        public OperationKind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("operation".equals(codeString)) {
                return OperationKind.OPERATION;
            }
            if ("query".equals(codeString)) {
                return OperationKind.QUERY;
            }
            throw new IllegalArgumentException("Unknown OperationKind code '" + codeString + "'");
        }

        public Enumeration<OperationKind> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("operation".equals(codeString)) {
                return new Enumeration<OperationKind>(this, OperationKind.OPERATION);
            }
            if ("query".equals(codeString)) {
                return new Enumeration<OperationKind>(this, OperationKind.QUERY);
            }
            throw new FHIRException("Unknown OperationKind code '" + codeString + "'");
        }

        @Override
        public String toCode(OperationKind code) {
            if (code == OperationKind.OPERATION) {
                return "operation";
            }
            if (code == OperationKind.QUERY) {
                return "query";
            }
            return "?";
        }

        @Override
        public String toSystem(OperationKind code) {
            return code.getSystem();
        }
    }

    public static enum OperationKind {
        OPERATION,
        QUERY,
        NULL;


        public static OperationKind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("operation".equals(codeString)) {
                return OPERATION;
            }
            if ("query".equals(codeString)) {
                return QUERY;
            }
            throw new FHIRException("Unknown OperationKind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case OPERATION: {
                    return "operation";
                }
                case QUERY: {
                    return "query";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case OPERATION: {
                    return "http://hl7.org/fhir/operation-kind";
                }
                case QUERY: {
                    return "http://hl7.org/fhir/operation-kind";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case OPERATION: {
                    return "This operation is invoked as an operation.";
                }
                case QUERY: {
                    return "This operation is a named query, invoked using the search mechanism.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case OPERATION: {
                    return "Operation";
                }
                case QUERY: {
                    return "Query";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

