/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.TimingAbbreviation;

public class TimingAbbreviationEnumFactory
implements EnumFactory<TimingAbbreviation> {
    @Override
    public TimingAbbreviation fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("QD".equals(codeString)) {
            return TimingAbbreviation.QD;
        }
        if ("QOD".equals(codeString)) {
            return TimingAbbreviation.QOD;
        }
        if ("Q4H".equals(codeString)) {
            return TimingAbbreviation.Q4H;
        }
        if ("Q6H".equals(codeString)) {
            return TimingAbbreviation.Q6H;
        }
        throw new IllegalArgumentException("Unknown TimingAbbreviation code '" + codeString + "'");
    }

    @Override
    public String toCode(TimingAbbreviation code) {
        if (code == TimingAbbreviation.QD) {
            return "QD";
        }
        if (code == TimingAbbreviation.QOD) {
            return "QOD";
        }
        if (code == TimingAbbreviation.Q4H) {
            return "Q4H";
        }
        if (code == TimingAbbreviation.Q6H) {
            return "Q6H";
        }
        return "?";
    }

    @Override
    public String toSystem(TimingAbbreviation code) {
        return code.getSystem();
    }
}

