/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.metamodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.metamodel.Element;
import org.hl7.fhir.dstu2016may.metamodel.ParserBase;
import org.hl7.fhir.dstu2016may.metamodel.Property;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.dstu2016may.utils.ToolingExtensions;
import org.hl7.fhir.dstu2016may.utils.XmlLocationAnnotator;
import org.hl7.fhir.dstu2016may.utils.XmlLocationData;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.StringPair;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.utilities.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XmlParser
extends ParserBase {
    public XmlParser(IWorkerContext context) {
        super(context);
    }

    @Override
    public Element parse(InputStream stream) throws Exception {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            factory.setNamespaceAware(true);
            if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
                TransformerFactory transformerFactory = XMLUtil.newXXEProtectedTransformerFactory();
                Transformer nullTransformer = transformerFactory.newTransformer();
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                doc = docBuilder.newDocument();
                DOMResult domResult = new DOMResult(doc);
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                spf.setValidating(false);
                SAXParser saxParser = spf.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                XmlLocationAnnotator locationAnnotator = new XmlLocationAnnotator(xmlReader, doc);
                InputSource inputSource = new InputSource(stream);
                SAXSource saxSource = new SAXSource(locationAnnotator, inputSource);
                nullTransformer.transform(saxSource, domResult);
            } else {
                DocumentBuilder builder = factory.newDocumentBuilder();
                doc = builder.parse(stream);
            }
        }
        catch (Exception e) {
            this.logError(0, 0, "(syntax)", ValidationMessage.IssueType.INVALID, e.getMessage(), ValidationMessage.IssueSeverity.FATAL);
            doc = null;
        }
        if (doc == null) {
            return null;
        }
        return this.parse(doc);
    }

    private void checkForProcessingInstruction(Document document) throws FHIRFormatError {
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 7) continue;
                this.logError(this.line(document), this.col(document), "(document)", ValidationMessage.IssueType.INVALID, "No processing instructions allowed in resources", ValidationMessage.IssueSeverity.ERROR);
            }
        }
    }

    private int line(Node node) {
        XmlLocationData loc = (XmlLocationData)node.getUserData("locationDataKey");
        return loc == null ? 0 : loc.getStartLine();
    }

    private int col(Node node) {
        XmlLocationData loc = (XmlLocationData)node.getUserData("locationDataKey");
        return loc == null ? 0 : loc.getStartColumn();
    }

    public Element parse(Document doc) throws Exception {
        this.checkForProcessingInstruction(doc);
        org.w3c.dom.Element element = doc.getDocumentElement();
        return this.parse(element);
    }

    public Element parse(org.w3c.dom.Element element) throws Exception {
        String ns = element.getNamespaceURI();
        String name = element.getLocalName();
        String path = "/" + this.pathPrefix(ns) + name;
        StructureDefinition sd = this.getDefinition(this.line(element), this.col(element), ns, name);
        if (sd == null) {
            return null;
        }
        Element result = new Element(element.getLocalName(), new Property(this.context, sd.getSnapshot().getElement().get(0), sd));
        this.checkElement(element, path, result.getProperty());
        result.markLocation(this.line(element), this.col(element));
        result.setType(element.getLocalName());
        this.parseChildren(path, element, result);
        result.numberChildren();
        return result;
    }

    private String pathPrefix(String ns) {
        if (Utilities.noString((String)ns)) {
            return "";
        }
        if (ns.equals("http://hl7.org/fhir")) {
            return "f:";
        }
        if (ns.equals("http://www.w3.org/1999/xhtml")) {
            return "h:";
        }
        if (ns.equals("urn:hl7-org:v3")) {
            return "v3:";
        }
        return "?:";
    }

    private boolean empty(org.w3c.dom.Element element) {
        for (int i = 0; i < element.getAttributes().getLength(); ++i) {
            String n = element.getAttributes().item(i).getNodeName();
            if (n.equals("xmlns") || n.startsWith("xmlns:")) continue;
            return false;
        }
        if (!Utilities.noString((String)element.getTextContent().trim())) {
            return false;
        }
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    private void checkElement(org.w3c.dom.Element element, String path, Property prop) throws FHIRFormatError {
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            if (this.empty(element)) {
                this.logError(this.line(element), this.col(element), path, ValidationMessage.IssueType.INVALID, "Element must have some content", ValidationMessage.IssueSeverity.ERROR);
            }
            String ns = "http://hl7.org/fhir";
            if (ToolingExtensions.hasExtension(prop.getDefinition(), "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
                ns = ToolingExtensions.readStringExtension(prop.getDefinition(), "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
            } else if (ToolingExtensions.hasExtension(prop.getStructure(), "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
                ns = ToolingExtensions.readStringExtension(prop.getStructure(), "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
            }
            if (!element.getNamespaceURI().equals(ns)) {
                this.logError(this.line(element), this.col(element), path, ValidationMessage.IssueType.INVALID, "Wrong namespace - expected '" + ns + "'", ValidationMessage.IssueSeverity.ERROR);
            }
        }
    }

    public Element parse(org.w3c.dom.Element base, String type) throws Exception {
        StructureDefinition sd = this.getDefinition(0, 0, "http://hl7.org/fhir", type);
        Element result = new Element(base.getLocalName(), new Property(this.context, sd.getSnapshot().getElement().get(0), sd));
        String path = "/" + this.pathPrefix(base.getNamespaceURI()) + base.getLocalName();
        this.checkElement(base, path, result.getProperty());
        result.setType(base.getLocalName());
        this.parseChildren(path, base, result);
        result.numberChildren();
        return result;
    }

    private void parseChildren(String path, org.w3c.dom.Element node, Element context) throws Exception {
        this.reapComments(node, context);
        List<Property> properties = this.getChildProperties(context.getProperty(), context.getName(), XMLUtil.getXsiType((org.w3c.dom.Element)node));
        String text = XMLUtil.getDirectText((org.w3c.dom.Element)node).trim();
        if (!Utilities.noString((String)text)) {
            Property property = this.getTextProp(properties);
            if (property != null) {
                context.getChildren().add(new Element(property.getName(), property, property.getType(), text).markLocation(this.line(node), this.col(node)));
            } else {
                this.logError(this.line(node), this.col(node), path, ValidationMessage.IssueType.STRUCTURE, "Text should not be present", ValidationMessage.IssueSeverity.ERROR);
            }
        }
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Node attr = node.getAttributes().item(i);
            if (attr.getNodeName().equals("xmlns") || attr.getNodeName().startsWith("xmlns:")) continue;
            Property property = this.getAttrProp(properties, attr.getNodeName());
            if (property != null) {
                String av = attr.getNodeValue();
                if (ToolingExtensions.hasExtension(property.getDefinition(), "http://www.healthintersections.com.au/fhir/StructureDefinition/elementdefinition-dateformat")) {
                    av = this.convertForDateFormat(ToolingExtensions.readStringExtension(property.getDefinition(), "http://www.healthintersections.com.au/fhir/StructureDefinition/elementdefinition-dateformat"), av);
                }
                if (property.getName().equals("value") && context.isPrimitive()) {
                    context.setValue(av);
                    continue;
                }
                context.getChildren().add(new Element(property.getName(), property, property.getType(), av).markLocation(this.line(node), this.col(node)));
                continue;
            }
            this.logError(this.line(node), this.col(node), path, ValidationMessage.IssueType.STRUCTURE, "Undefined attribute '@" + attr.getNodeName() + "'", ValidationMessage.IssueSeverity.ERROR);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 1) {
                Property property = this.getElementProp(properties, child.getLocalName());
                if (property != null) {
                    if (!property.isChoice() && "xhtml".equals(property.getType())) {
                        XhtmlParser xp = new XhtmlParser();
                        XhtmlNode xhtml = xp.parseHtmlNode((org.w3c.dom.Element)child);
                        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
                            for (StringPair s : xp.getValidationIssues()) {
                                this.logError(this.line(child), this.col(child), path, ValidationMessage.IssueType.INVALID, s.getName() + " " + s.getValue(), ValidationMessage.IssueSeverity.ERROR);
                            }
                        }
                        context.getChildren().add(new Element("div", property, "xhtml", new XhtmlComposer(true, false).compose(xhtml)).setXhtml(xhtml).markLocation(this.line(child), this.col(child)));
                        continue;
                    }
                    String npath = path + "/" + this.pathPrefix(child.getNamespaceURI()) + child.getLocalName();
                    Element n = new Element(child.getLocalName(), property).markLocation(this.line(child), this.col(child));
                    this.checkElement((org.w3c.dom.Element)child, npath, n.getProperty());
                    boolean ok = true;
                    if (property.isChoice()) {
                        if (property.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR)) {
                            String xsiType = ((org.w3c.dom.Element)child).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                            if (xsiType == null) {
                                this.logError(this.line(child), this.col(child), path, ValidationMessage.IssueType.STRUCTURE, "No type found on '" + child.getLocalName() + "\"", ValidationMessage.IssueSeverity.ERROR);
                                ok = false;
                            } else {
                                if (xsiType.contains(":")) {
                                    xsiType = xsiType.substring(xsiType.indexOf(":") + 1);
                                }
                                n.setType(xsiType);
                            }
                        } else {
                            n.setType(n.getType());
                        }
                    }
                    context.getChildren().add(n);
                    if (!ok) continue;
                    if (property.isResource()) {
                        this.parseResource(npath, (org.w3c.dom.Element)child, n);
                        continue;
                    }
                    this.parseChildren(npath, (org.w3c.dom.Element)child, n);
                    continue;
                }
                this.logError(this.line(child), this.col(child), path, ValidationMessage.IssueType.STRUCTURE, "Undefined element '" + child.getLocalName() + "'", ValidationMessage.IssueSeverity.ERROR);
                continue;
            }
            if (child.getNodeType() == 4) {
                this.logError(this.line(child), this.col(child), path, ValidationMessage.IssueType.STRUCTURE, "CDATA is not allowed", ValidationMessage.IssueSeverity.ERROR);
                continue;
            }
            if (Utilities.existsInList((int)child.getNodeType(), (int[])new int[]{3, 8})) continue;
            this.logError(this.line(child), this.col(child), path, ValidationMessage.IssueType.STRUCTURE, "Node type " + Integer.toString(child.getNodeType()) + " is not allowed", ValidationMessage.IssueSeverity.ERROR);
        }
    }

    private Property getElementProp(List<Property> properties, String nodeName) {
        for (Property p : properties) {
            if (p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR) || p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLTEXT)) continue;
            if (p.getName().equals(nodeName)) {
                return p;
            }
            if (!p.getName().endsWith("[x]") || nodeName.length() <= p.getName().length() - 3 || !p.getName().substring(0, p.getName().length() - 3).equals(nodeName.substring(0, p.getName().length() - 3))) continue;
            return p;
        }
        return null;
    }

    private Property getAttrProp(List<Property> properties, String nodeName) {
        for (Property p : properties) {
            if (!p.getName().equals(nodeName) || !p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR)) continue;
            return p;
        }
        return null;
    }

    private Property getTextProp(List<Property> properties) {
        for (Property p : properties) {
            if (!p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLTEXT)) continue;
            return p;
        }
        return null;
    }

    private String convertForDateFormat(String fmt, String av) throws FHIRException {
        if ("v3".equals(fmt)) {
            DateTimeType d = DateTimeType.parseV3(av);
            return d.asStringValue();
        }
        throw new FHIRException("Unknown Data format '" + fmt + "'");
    }

    private void parseResource(String string, org.w3c.dom.Element container, Element parent) throws Exception {
        org.w3c.dom.Element res = XMLUtil.getFirstChild((org.w3c.dom.Element)container);
        String name = res.getLocalName();
        StructureDefinition sd = this.context.fetchTypeDefinition(name);
        if (sd == null) {
            throw new FHIRFormatError("Contained resource does not appear to be a FHIR resource (unknown name '" + res.getLocalName() + "')");
        }
        parent.updateProperty(new Property(this.context, sd.getSnapshot().getElement().get(0), sd), parent.getProperty().getName().equals("contained") ? Element.SpecialElement.CONTAINED : Element.SpecialElement.BUNDLE_ENTRY);
        parent.setType(name);
        this.parseChildren(res.getLocalName(), res, parent);
    }

    private void reapComments(org.w3c.dom.Element element, Element context) {
        Node node;
        for (node = element.getPreviousSibling(); node != null && node.getNodeType() != 1; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 8) continue;
            context.getComments().add(0, node.getTextContent());
        }
        for (node = element.getLastChild(); node != null && node.getNodeType() != 1; node = node.getPreviousSibling()) {
        }
        while (node != null) {
            if (node.getNodeType() == 8) {
                context.getComments().add(node.getTextContent());
            }
            node = node.getNextSibling();
        }
    }

    private boolean isAttr(Property property) {
        for (Enumeration<ElementDefinition.PropertyRepresentation> r : property.getDefinition().getRepresentation()) {
            if (r.getValue() != ElementDefinition.PropertyRepresentation.XMLATTR) continue;
            return true;
        }
        return false;
    }

    private boolean isText(Property property) {
        for (Enumeration<ElementDefinition.PropertyRepresentation> r : property.getDefinition().getRepresentation()) {
            if (r.getValue() != ElementDefinition.PropertyRepresentation.XMLTEXT) continue;
            return true;
        }
        return false;
    }

    @Override
    public void compose(Element e, OutputStream stream, IParser.OutputStyle style, String base) throws Exception {
        XMLWriter xml = new XMLWriter(stream, "UTF-8");
        xml.setPretty(style == IParser.OutputStyle.PRETTY);
        xml.start();
        xml.setDefaultNamespace(e.getProperty().getNamespace());
        this.composeElement(xml, e, e.getType());
        xml.end();
    }

    private void composeElement(XMLWriter xml, Element element, String elementName) throws IOException {
        for (String s : element.getComments()) {
            xml.comment(s, true);
        }
        if (this.isText(element.getProperty())) {
            xml.enter(elementName);
            xml.text(element.getValue());
            xml.exit(elementName);
        } else if (element.isPrimitive() || element.hasType() && ParserBase.isPrimitive(element.getType())) {
            if (element.getType().equals("xhtml")) {
                xml.escapedText(element.getValue());
            } else if (this.isText(element.getProperty())) {
                xml.text(element.getValue());
            } else {
                if (element.hasValue()) {
                    xml.attribute("value", element.getValue());
                }
                if (element.hasChildren()) {
                    xml.enter(elementName);
                    for (Element child : element.getChildren()) {
                        this.composeElement(xml, child, child.getName());
                    }
                    xml.exit(elementName);
                } else {
                    xml.element(elementName);
                }
            }
        } else {
            for (Element child : element.getChildren()) {
                if (!this.isAttr(child.getProperty())) continue;
                xml.attribute(child.getName(), child.getValue());
            }
            xml.enter(elementName);
            if (element.getSpecial() != null) {
                xml.enter(element.getType());
            }
            for (Element child : element.getChildren()) {
                if (this.isText(child.getProperty())) {
                    xml.text(child.getValue());
                    continue;
                }
                if (this.isAttr(child.getProperty())) continue;
                this.composeElement(xml, child, child.getName());
            }
            if (element.getSpecial() != null) {
                xml.exit(element.getType());
            }
            xml.exit(elementName);
        }
    }
}

