/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Ratio;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.SimpleQuantity;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Substance;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Medication", profile="http://hl7.org/fhir/Profile/Medication")
public class Medication
extends DomainResource {
    @Child(name="code", type={CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Codes that identify this medication", formalDefinition="A code (or set of codes) that specify this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.")
    protected CodeableConcept code;
    @Child(name="isBrand", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="True if a brand", formalDefinition="Set to true if the item is attributable to a specific manufacturer.")
    protected BooleanType isBrand;
    @Child(name="manufacturer", type={Organization.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of the item", formalDefinition="Describes the details of the manufacturer.")
    protected Reference manufacturer;
    protected Organization manufacturerTarget;
    @Child(name="product", type={}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Administrable medication details", formalDefinition="Information that only applies to products (not packages).")
    protected MedicationProductComponent product;
    @Child(name="package", type={}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details about packaged medications", formalDefinition="Information that only applies to packages (not products).")
    protected MedicationPackageComponent package_;
    private static final long serialVersionUID = 859308699L;
    @SearchParamDefinition(name="form", path="Medication.product.form", description="powder | tablets | carton +", type="token")
    public static final String SP_FORM = "form";
    public static final TokenClientParam FORM = new TokenClientParam("form");
    @SearchParamDefinition(name="container", path="Medication.package.container", description="E.g. box, vial, blister-pack", type="token")
    public static final String SP_CONTAINER = "container";
    public static final TokenClientParam CONTAINER = new TokenClientParam("container");
    @SearchParamDefinition(name="manufacturer", path="Medication.manufacturer", description="Manufacturer of the item", type="reference")
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final ReferenceClientParam MANUFACTURER = new ReferenceClientParam("manufacturer");
    public static final Include INCLUDE_MANUFACTURER = new Include("Medication:manufacturer").toLocked();
    @SearchParamDefinition(name="package-item-code", path="Medication.package.content.item.as(CodeableConcept)", description="The item in the package", type="token")
    public static final String SP_PACKAGE_ITEM_CODE = "package-item-code";
    public static final TokenClientParam PACKAGE_ITEM_CODE = new TokenClientParam("package-item-code");
    @SearchParamDefinition(name="ingredient", path="Medication.product.ingredient.item.as(Reference)", description="The product contained", type="reference")
    public static final String SP_INGREDIENT = "ingredient";
    public static final ReferenceClientParam INGREDIENT = new ReferenceClientParam("ingredient");
    public static final Include INCLUDE_INGREDIENT = new Include("Medication:ingredient").toLocked();
    @SearchParamDefinition(name="package-item", path="Medication.package.content.item.as(Reference)", description="The item in the package", type="reference")
    public static final String SP_PACKAGE_ITEM = "package-item";
    public static final ReferenceClientParam PACKAGE_ITEM = new ReferenceClientParam("package-item");
    public static final Include INCLUDE_PACKAGE_ITEM = new Include("Medication:package-item").toLocked();
    @SearchParamDefinition(name="code", path="Medication.code", description="Codes that identify this medication", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="ingredient-code", path="Medication.product.ingredient.item.as(CodeableConcept)", description="The product contained", type="token")
    public static final String SP_INGREDIENT_CODE = "ingredient-code";
    public static final TokenClientParam INGREDIENT_CODE = new TokenClientParam("ingredient-code");

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Medication setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public BooleanType getIsBrandElement() {
        if (this.isBrand == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.isBrand");
            }
            if (Configuration.doAutoCreate()) {
                this.isBrand = new BooleanType();
            }
        }
        return this.isBrand;
    }

    public boolean hasIsBrandElement() {
        return this.isBrand != null && !this.isBrand.isEmpty();
    }

    public boolean hasIsBrand() {
        return this.isBrand != null && !this.isBrand.isEmpty();
    }

    public Medication setIsBrandElement(BooleanType value) {
        this.isBrand = value;
        return this;
    }

    public boolean getIsBrand() {
        return this.isBrand == null || this.isBrand.isEmpty() ? false : (Boolean)this.isBrand.getValue();
    }

    public Medication setIsBrand(boolean value) {
        if (this.isBrand == null) {
            this.isBrand = new BooleanType();
        }
        this.isBrand.setValue((Object)value);
        return this;
    }

    public Reference getManufacturer() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new Reference();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public Medication setManufacturer(Reference value) {
        this.manufacturer = value;
        return this;
    }

    public Organization getManufacturerTarget() {
        if (this.manufacturerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturerTarget = new Organization();
            }
        }
        return this.manufacturerTarget;
    }

    public Medication setManufacturerTarget(Organization value) {
        this.manufacturerTarget = value;
        return this;
    }

    public MedicationProductComponent getProduct() {
        if (this.product == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.product");
            }
            if (Configuration.doAutoCreate()) {
                this.product = new MedicationProductComponent();
            }
        }
        return this.product;
    }

    public boolean hasProduct() {
        return this.product != null && !this.product.isEmpty();
    }

    public Medication setProduct(MedicationProductComponent value) {
        this.product = value;
        return this;
    }

    public MedicationPackageComponent getPackage() {
        if (this.package_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.package_");
            }
            if (Configuration.doAutoCreate()) {
                this.package_ = new MedicationPackageComponent();
            }
        }
        return this.package_;
    }

    public boolean hasPackage() {
        return this.package_ != null && !this.package_.isEmpty();
    }

    public Medication setPackage(MedicationPackageComponent value) {
        this.package_ = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_CODE, "CodeableConcept", "A code (or set of codes) that specify this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property("isBrand", "boolean", "Set to true if the item is attributable to a specific manufacturer.", 0, Integer.MAX_VALUE, this.isBrand));
        childrenList.add(new Property(SP_MANUFACTURER, "Reference(Organization)", "Describes the details of the manufacturer.", 0, Integer.MAX_VALUE, this.manufacturer));
        childrenList.add(new Property("product", "", "Information that only applies to products (not packages).", 0, Integer.MAX_VALUE, this.product));
        childrenList.add(new Property("package", "", "Information that only applies to packages (not products).", 0, Integer.MAX_VALUE, this.package_));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.code;
                }
                return baseArray;
            }
            case 2055403645: {
                Base[] baseArray;
                if (this.isBrand == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.isBrand;
                }
                return baseArray;
            }
            case -1969347631: {
                Base[] baseArray;
                if (this.manufacturer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.manufacturer;
                }
                return baseArray;
            }
            case -309474065: {
                Base[] baseArray;
                if (this.product == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.product;
                }
                return baseArray;
            }
            case -807062458: {
                Base[] baseArray;
                if (this.package_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.package_;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                break;
            }
            case 2055403645: {
                this.isBrand = this.castToBoolean(value);
                break;
            }
            case -1969347631: {
                this.manufacturer = this.castToReference(value);
                break;
            }
            case -309474065: {
                this.product = (MedicationProductComponent)value;
                break;
            }
            case -807062458: {
                this.package_ = (MedicationPackageComponent)value;
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("isBrand")) {
            this.isBrand = this.castToBoolean(value);
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = this.castToReference(value);
        } else if (name.equals("product")) {
            this.product = (MedicationProductComponent)value;
        } else if (name.equals("package")) {
            this.package_ = (MedicationPackageComponent)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3059181: {
                return this.getCode();
            }
            case 2055403645: {
                throw new FHIRException("Cannot make property isBrand as it is not a complex type");
            }
            case -1969347631: {
                return this.getManufacturer();
            }
            case -309474065: {
                return this.getProduct();
            }
            case -807062458: {
                return this.getPackage();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("isBrand")) {
            throw new FHIRException("Cannot call addChild on a singleton property Medication.isBrand");
        }
        if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = new Reference();
            return this.manufacturer;
        }
        if (name.equals("product")) {
            this.product = new MedicationProductComponent();
            return this.product;
        }
        if (name.equals("package")) {
            this.package_ = new MedicationPackageComponent();
            return this.package_;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Medication";
    }

    @Override
    public Medication copy() {
        Medication dst = new Medication();
        this.copyValues(dst);
        dst.code = this.code == null ? null : this.code.copy();
        dst.isBrand = this.isBrand == null ? null : this.isBrand.copy();
        dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        dst.product = this.product == null ? null : this.product.copy();
        dst.package_ = this.package_ == null ? null : this.package_.copy();
        return dst;
    }

    protected Medication typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Medication)) {
            return false;
        }
        Medication o = (Medication)other;
        return Medication.compareDeep(this.code, o.code, true) && Medication.compareDeep(this.isBrand, o.isBrand, true) && Medication.compareDeep(this.manufacturer, o.manufacturer, true) && Medication.compareDeep(this.product, o.product, true) && Medication.compareDeep(this.package_, o.package_, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Medication)) {
            return false;
        }
        Medication o = (Medication)other;
        return Medication.compareValues(this.isBrand, o.isBrand, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.isBrand != null && !this.isBrand.isEmpty() || this.manufacturer != null && !this.manufacturer.isEmpty() || this.product != null && !this.product.isEmpty() || this.package_ != null && !this.package_.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Medication;
    }

    @Block
    public static class MedicationPackageContentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableConcept.class, Medication.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The item in the package", formalDefinition="Identifies one of the items in the package.")
        protected Type item;
        @Child(name="amount", type={SimpleQuantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity present in the package", formalDefinition="The amount of the product that is in the package.")
        protected SimpleQuantity amount;
        private static final long serialVersionUID = 1669610080L;

        public MedicationPackageContentComponent() {
        }

        public MedicationPackageContentComponent(Type item) {
            this.item = item;
        }

        public Type getItem() {
            return this.item;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this.item instanceof CodeableConcept;
        }

        public Reference getItemReference() throws FHIRException {
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this.item instanceof Reference;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public MedicationPackageContentComponent setItem(Type value) {
            this.item = value;
            return this;
        }

        public SimpleQuantity getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationPackageContentComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new SimpleQuantity();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public MedicationPackageContentComponent setAmount(SimpleQuantity value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("item[x]", "CodeableConcept|Reference(Medication)", "Identifies one of the items in the package.", 0, Integer.MAX_VALUE, this.item));
            childrenList.add(new Property("amount", "SimpleQuantity", "The amount of the product that is in the package.", 0, Integer.MAX_VALUE, this.amount));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = (Type)value;
                    break;
                }
                case -1413853096: {
                    this.amount = this.castToSimpleQuantity(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item[x]")) {
                this.item = (Type)value;
            } else if (name.equals("amount")) {
                this.amount = this.castToSimpleQuantity(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2116201613: {
                    return this.getItem();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            if (name.equals("amount")) {
                this.amount = new SimpleQuantity();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationPackageContentComponent copy() {
            MedicationPackageContentComponent dst = new MedicationPackageContentComponent();
            this.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MedicationPackageContentComponent)) {
                return false;
            }
            MedicationPackageContentComponent o = (MedicationPackageContentComponent)other;
            return MedicationPackageContentComponent.compareDeep(this.item, o.item, true) && MedicationPackageContentComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MedicationPackageContentComponent)) {
                return false;
            }
            MedicationPackageContentComponent o = (MedicationPackageContentComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.item != null && !this.item.isEmpty() || this.amount != null && !this.amount.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Medication.package.content";
        }
    }

    @Block
    public static class MedicationPackageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="container", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. box, vial, blister-pack", formalDefinition="The kind of container that this package comes as.")
        protected CodeableConcept container;
        @Child(name="content", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What is  in the package", formalDefinition="A set of components that go to make up the described item.")
        protected List<MedicationPackageContentComponent> content;
        private static final long serialVersionUID = 503772472L;

        public CodeableConcept getContainer() {
            if (this.container == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationPackageComponent.container");
                }
                if (Configuration.doAutoCreate()) {
                    this.container = new CodeableConcept();
                }
            }
            return this.container;
        }

        public boolean hasContainer() {
            return this.container != null && !this.container.isEmpty();
        }

        public MedicationPackageComponent setContainer(CodeableConcept value) {
            this.container = value;
            return this;
        }

        public List<MedicationPackageContentComponent> getContent() {
            if (this.content == null) {
                this.content = new ArrayList<MedicationPackageContentComponent>();
            }
            return this.content;
        }

        public boolean hasContent() {
            if (this.content == null) {
                return false;
            }
            for (MedicationPackageContentComponent item : this.content) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationPackageContentComponent addContent() {
            MedicationPackageContentComponent t = new MedicationPackageContentComponent();
            if (this.content == null) {
                this.content = new ArrayList<MedicationPackageContentComponent>();
            }
            this.content.add(t);
            return t;
        }

        public MedicationPackageComponent addContent(MedicationPackageContentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.content == null) {
                this.content = new ArrayList<MedicationPackageContentComponent>();
            }
            this.content.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Medication.SP_CONTAINER, "CodeableConcept", "The kind of container that this package comes as.", 0, Integer.MAX_VALUE, this.container));
            childrenList.add(new Property("content", "", "A set of components that go to make up the described item.", 0, Integer.MAX_VALUE, this.content));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -410956671: {
                    Base[] baseArray;
                    if (this.container == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.container;
                    }
                    return baseArray;
                }
                case 951530617: {
                    return this.content == null ? new Base[]{} : this.content.toArray(new Base[this.content.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -410956671: {
                    this.container = this.castToCodeableConcept(value);
                    break;
                }
                case 951530617: {
                    this.getContent().add((MedicationPackageContentComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Medication.SP_CONTAINER)) {
                this.container = this.castToCodeableConcept(value);
            } else if (name.equals("content")) {
                this.getContent().add((MedicationPackageContentComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -410956671: {
                    return this.getContainer();
                }
                case 951530617: {
                    return this.addContent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Medication.SP_CONTAINER)) {
                this.container = new CodeableConcept();
                return this.container;
            }
            if (name.equals("content")) {
                return this.addContent();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationPackageComponent copy() {
            MedicationPackageComponent dst = new MedicationPackageComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.container = this.container == null ? null : this.container.copy();
            if (this.content != null) {
                dst.content = new ArrayList<MedicationPackageContentComponent>();
                for (MedicationPackageContentComponent i : this.content) {
                    dst.content.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MedicationPackageComponent)) {
                return false;
            }
            MedicationPackageComponent o = (MedicationPackageComponent)other;
            return MedicationPackageComponent.compareDeep(this.container, o.container, true) && MedicationPackageComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MedicationPackageComponent)) {
                return false;
            }
            MedicationPackageComponent o = (MedicationPackageComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.container != null && !this.container.isEmpty() || this.content != null && !this.content.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Medication.package";
        }
    }

    @Block
    public static class MedicationProductBatchComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="lotNumber", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The assigned lot number of a batch of the specified product.")
        protected StringType lotNumber;
        @Child(name="expirationDate", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="When this specific batch of product will expire.")
        protected DateTimeType expirationDate;
        private static final long serialVersionUID = 1982738755L;

        public StringType getLotNumberElement() {
            if (this.lotNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationProductBatchComponent.lotNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.lotNumber = new StringType();
                }
            }
            return this.lotNumber;
        }

        public boolean hasLotNumberElement() {
            return this.lotNumber != null && !this.lotNumber.isEmpty();
        }

        public boolean hasLotNumber() {
            return this.lotNumber != null && !this.lotNumber.isEmpty();
        }

        public MedicationProductBatchComponent setLotNumberElement(StringType value) {
            this.lotNumber = value;
            return this;
        }

        public String getLotNumber() {
            return this.lotNumber == null ? null : (String)this.lotNumber.getValue();
        }

        public MedicationProductBatchComponent setLotNumber(String value) {
            if (Utilities.noString((String)value)) {
                this.lotNumber = null;
            } else {
                if (this.lotNumber == null) {
                    this.lotNumber = new StringType();
                }
                this.lotNumber.setValue(value);
            }
            return this;
        }

        public DateTimeType getExpirationDateElement() {
            if (this.expirationDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationProductBatchComponent.expirationDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.expirationDate = new DateTimeType();
                }
            }
            return this.expirationDate;
        }

        public boolean hasExpirationDateElement() {
            return this.expirationDate != null && !this.expirationDate.isEmpty();
        }

        public boolean hasExpirationDate() {
            return this.expirationDate != null && !this.expirationDate.isEmpty();
        }

        public MedicationProductBatchComponent setExpirationDateElement(DateTimeType value) {
            this.expirationDate = value;
            return this;
        }

        public Date getExpirationDate() {
            return this.expirationDate == null ? null : (Date)this.expirationDate.getValue();
        }

        public MedicationProductBatchComponent setExpirationDate(Date value) {
            if (value == null) {
                this.expirationDate = null;
            } else {
                if (this.expirationDate == null) {
                    this.expirationDate = new DateTimeType();
                }
                this.expirationDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("lotNumber", "string", "The assigned lot number of a batch of the specified product.", 0, Integer.MAX_VALUE, this.lotNumber));
            childrenList.add(new Property("expirationDate", "dateTime", "When this specific batch of product will expire.", 0, Integer.MAX_VALUE, this.expirationDate));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 462547450: {
                    Base[] baseArray;
                    if (this.lotNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.lotNumber;
                    }
                    return baseArray;
                }
                case -668811523: {
                    Base[] baseArray;
                    if (this.expirationDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expirationDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 462547450: {
                    this.lotNumber = this.castToString(value);
                    break;
                }
                case -668811523: {
                    this.expirationDate = this.castToDateTime(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("lotNumber")) {
                this.lotNumber = this.castToString(value);
            } else if (name.equals("expirationDate")) {
                this.expirationDate = this.castToDateTime(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 462547450: {
                    throw new FHIRException("Cannot make property lotNumber as it is not a complex type");
                }
                case -668811523: {
                    throw new FHIRException("Cannot make property expirationDate as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("lotNumber")) {
                throw new FHIRException("Cannot call addChild on a singleton property Medication.lotNumber");
            }
            if (name.equals("expirationDate")) {
                throw new FHIRException("Cannot call addChild on a singleton property Medication.expirationDate");
            }
            return super.addChild(name);
        }

        @Override
        public MedicationProductBatchComponent copy() {
            MedicationProductBatchComponent dst = new MedicationProductBatchComponent();
            this.copyValues(dst);
            dst.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
            dst.expirationDate = this.expirationDate == null ? null : this.expirationDate.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MedicationProductBatchComponent)) {
                return false;
            }
            MedicationProductBatchComponent o = (MedicationProductBatchComponent)other;
            return MedicationProductBatchComponent.compareDeep(this.lotNumber, o.lotNumber, true) && MedicationProductBatchComponent.compareDeep(this.expirationDate, o.expirationDate, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MedicationProductBatchComponent)) {
                return false;
            }
            MedicationProductBatchComponent o = (MedicationProductBatchComponent)other;
            return MedicationProductBatchComponent.compareValues(this.lotNumber, o.lotNumber, true) && MedicationProductBatchComponent.compareValues(this.expirationDate, o.expirationDate, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.lotNumber != null && !this.lotNumber.isEmpty() || this.expirationDate != null && !this.expirationDate.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Medication.product.batch";
        }
    }

    @Block
    public static class MedicationProductIngredientComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableConcept.class, Substance.class, Medication.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The product contained", formalDefinition="The actual ingredient - either a substance (simple ingredient) or another medication.")
        protected Type item;
        @Child(name="amount", type={Ratio.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity of ingredient present", formalDefinition="Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.")
        protected Ratio amount;
        private static final long serialVersionUID = -651644952L;

        public MedicationProductIngredientComponent() {
        }

        public MedicationProductIngredientComponent(Type item) {
            this.item = item;
        }

        public Type getItem() {
            return this.item;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this.item instanceof CodeableConcept;
        }

        public Reference getItemReference() throws FHIRException {
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this.item instanceof Reference;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public MedicationProductIngredientComponent setItem(Type value) {
            this.item = value;
            return this;
        }

        public Ratio getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationProductIngredientComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Ratio();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public MedicationProductIngredientComponent setAmount(Ratio value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("item[x]", "CodeableConcept|Reference(Substance|Medication)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, Integer.MAX_VALUE, this.item));
            childrenList.add(new Property("amount", "Ratio", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.", 0, Integer.MAX_VALUE, this.amount));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = (Type)value;
                    break;
                }
                case -1413853096: {
                    this.amount = this.castToRatio(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item[x]")) {
                this.item = (Type)value;
            } else if (name.equals("amount")) {
                this.amount = this.castToRatio(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2116201613: {
                    return this.getItem();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            if (name.equals("amount")) {
                this.amount = new Ratio();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationProductIngredientComponent copy() {
            MedicationProductIngredientComponent dst = new MedicationProductIngredientComponent();
            this.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MedicationProductIngredientComponent)) {
                return false;
            }
            MedicationProductIngredientComponent o = (MedicationProductIngredientComponent)other;
            return MedicationProductIngredientComponent.compareDeep(this.item, o.item, true) && MedicationProductIngredientComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MedicationProductIngredientComponent)) {
                return false;
            }
            MedicationProductIngredientComponent o = (MedicationProductIngredientComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.item != null && !this.item.isEmpty() || this.amount != null && !this.amount.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Medication.product.ingredient";
        }
    }

    @Block
    public static class MedicationProductComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="form", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="powder | tablets | carton +", formalDefinition="Describes the form of the item.  Powder; tablets; carton.")
        protected CodeableConcept form;
        @Child(name="ingredient", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Active or inactive ingredient", formalDefinition="Identifies a particular constituent of interest in the product.")
        protected List<MedicationProductIngredientComponent> ingredient;
        @Child(name="batch", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="Information about a group of medication produced or packaged from one production run.")
        protected List<MedicationProductBatchComponent> batch;
        private static final long serialVersionUID = 1132853671L;

        public CodeableConcept getForm() {
            if (this.form == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationProductComponent.form");
                }
                if (Configuration.doAutoCreate()) {
                    this.form = new CodeableConcept();
                }
            }
            return this.form;
        }

        public boolean hasForm() {
            return this.form != null && !this.form.isEmpty();
        }

        public MedicationProductComponent setForm(CodeableConcept value) {
            this.form = value;
            return this;
        }

        public List<MedicationProductIngredientComponent> getIngredient() {
            if (this.ingredient == null) {
                this.ingredient = new ArrayList<MedicationProductIngredientComponent>();
            }
            return this.ingredient;
        }

        public boolean hasIngredient() {
            if (this.ingredient == null) {
                return false;
            }
            for (MedicationProductIngredientComponent item : this.ingredient) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationProductIngredientComponent addIngredient() {
            MedicationProductIngredientComponent t = new MedicationProductIngredientComponent();
            if (this.ingredient == null) {
                this.ingredient = new ArrayList<MedicationProductIngredientComponent>();
            }
            this.ingredient.add(t);
            return t;
        }

        public MedicationProductComponent addIngredient(MedicationProductIngredientComponent t) {
            if (t == null) {
                return this;
            }
            if (this.ingredient == null) {
                this.ingredient = new ArrayList<MedicationProductIngredientComponent>();
            }
            this.ingredient.add(t);
            return this;
        }

        public List<MedicationProductBatchComponent> getBatch() {
            if (this.batch == null) {
                this.batch = new ArrayList<MedicationProductBatchComponent>();
            }
            return this.batch;
        }

        public boolean hasBatch() {
            if (this.batch == null) {
                return false;
            }
            for (MedicationProductBatchComponent item : this.batch) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationProductBatchComponent addBatch() {
            MedicationProductBatchComponent t = new MedicationProductBatchComponent();
            if (this.batch == null) {
                this.batch = new ArrayList<MedicationProductBatchComponent>();
            }
            this.batch.add(t);
            return t;
        }

        public MedicationProductComponent addBatch(MedicationProductBatchComponent t) {
            if (t == null) {
                return this;
            }
            if (this.batch == null) {
                this.batch = new ArrayList<MedicationProductBatchComponent>();
            }
            this.batch.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Medication.SP_FORM, "CodeableConcept", "Describes the form of the item.  Powder; tablets; carton.", 0, Integer.MAX_VALUE, this.form));
            childrenList.add(new Property(Medication.SP_INGREDIENT, "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient));
            childrenList.add(new Property("batch", "", "Information about a group of medication produced or packaged from one production run.", 0, Integer.MAX_VALUE, this.batch));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3148996: {
                    Base[] baseArray;
                    if (this.form == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.form;
                    }
                    return baseArray;
                }
                case -206409263: {
                    return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
                }
                case 93509434: {
                    return this.batch == null ? new Base[]{} : this.batch.toArray(new Base[this.batch.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3148996: {
                    this.form = this.castToCodeableConcept(value);
                    break;
                }
                case -206409263: {
                    this.getIngredient().add((MedicationProductIngredientComponent)value);
                    break;
                }
                case 93509434: {
                    this.getBatch().add((MedicationProductBatchComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Medication.SP_FORM)) {
                this.form = this.castToCodeableConcept(value);
            } else if (name.equals(Medication.SP_INGREDIENT)) {
                this.getIngredient().add((MedicationProductIngredientComponent)value);
            } else if (name.equals("batch")) {
                this.getBatch().add((MedicationProductBatchComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3148996: {
                    return this.getForm();
                }
                case -206409263: {
                    return this.addIngredient();
                }
                case 93509434: {
                    return this.addBatch();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Medication.SP_FORM)) {
                this.form = new CodeableConcept();
                return this.form;
            }
            if (name.equals(Medication.SP_INGREDIENT)) {
                return this.addIngredient();
            }
            if (name.equals("batch")) {
                return this.addBatch();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationProductComponent copy() {
            MedicationProductComponent dst = new MedicationProductComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.form = this.form == null ? null : this.form.copy();
            if (this.ingredient != null) {
                dst.ingredient = new ArrayList<MedicationProductIngredientComponent>();
                for (MedicationProductIngredientComponent medicationProductIngredientComponent : this.ingredient) {
                    dst.ingredient.add(medicationProductIngredientComponent.copy());
                }
            }
            if (this.batch != null) {
                dst.batch = new ArrayList<MedicationProductBatchComponent>();
                for (MedicationProductBatchComponent medicationProductBatchComponent : this.batch) {
                    dst.batch.add(medicationProductBatchComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MedicationProductComponent)) {
                return false;
            }
            MedicationProductComponent o = (MedicationProductComponent)other;
            return MedicationProductComponent.compareDeep(this.form, o.form, true) && MedicationProductComponent.compareDeep(this.ingredient, o.ingredient, true) && MedicationProductComponent.compareDeep(this.batch, o.batch, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MedicationProductComponent)) {
                return false;
            }
            MedicationProductComponent o = (MedicationProductComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.form != null && !this.form.isEmpty() || this.ingredient != null && !this.ingredient.isEmpty() || this.batch != null && !this.batch.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Medication.product";
        }
    }
}

