/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ActivityDefinitionCategory;

public class ActivityDefinitionCategoryEnumFactory
implements EnumFactory<ActivityDefinitionCategory> {
    @Override
    public ActivityDefinitionCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("diet".equals(codeString)) {
            return ActivityDefinitionCategory.DIET;
        }
        if ("drug".equals(codeString)) {
            return ActivityDefinitionCategory.DRUG;
        }
        if ("encounter".equals(codeString)) {
            return ActivityDefinitionCategory.ENCOUNTER;
        }
        if ("observation".equals(codeString)) {
            return ActivityDefinitionCategory.OBSERVATION;
        }
        if ("procedure".equals(codeString)) {
            return ActivityDefinitionCategory.PROCEDURE;
        }
        if ("supply".equals(codeString)) {
            return ActivityDefinitionCategory.SUPPLY;
        }
        if ("other".equals(codeString)) {
            return ActivityDefinitionCategory.OTHER;
        }
        throw new IllegalArgumentException("Unknown ActivityDefinitionCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(ActivityDefinitionCategory code) {
        if (code == ActivityDefinitionCategory.NULL) {
            return null;
        }
        if (code == ActivityDefinitionCategory.DIET) {
            return "diet";
        }
        if (code == ActivityDefinitionCategory.DRUG) {
            return "drug";
        }
        if (code == ActivityDefinitionCategory.ENCOUNTER) {
            return "encounter";
        }
        if (code == ActivityDefinitionCategory.OBSERVATION) {
            return "observation";
        }
        if (code == ActivityDefinitionCategory.PROCEDURE) {
            return "procedure";
        }
        if (code == ActivityDefinitionCategory.SUPPLY) {
            return "supply";
        }
        if (code == ActivityDefinitionCategory.OTHER) {
            return "other";
        }
        return "?";
    }

    @Override
    public String toSystem(ActivityDefinitionCategory code) {
        return code.getSystem();
    }
}

