/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.GroupingBehavior;

public class GroupingBehaviorEnumFactory
implements EnumFactory<GroupingBehavior> {
    @Override
    public GroupingBehavior fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("visual-group".equals(codeString)) {
            return GroupingBehavior.VISUALGROUP;
        }
        if ("logical-group".equals(codeString)) {
            return GroupingBehavior.LOGICALGROUP;
        }
        if ("sentence-group".equals(codeString)) {
            return GroupingBehavior.SENTENCEGROUP;
        }
        throw new IllegalArgumentException("Unknown GroupingBehavior code '" + codeString + "'");
    }

    @Override
    public String toCode(GroupingBehavior code) {
        if (code == GroupingBehavior.NULL) {
            return null;
        }
        if (code == GroupingBehavior.VISUALGROUP) {
            return "visual-group";
        }
        if (code == GroupingBehavior.LOGICALGROUP) {
            return "logical-group";
        }
        if (code == GroupingBehavior.SENTENCEGROUP) {
            return "sentence-group";
        }
        return "?";
    }

    @Override
    public String toSystem(GroupingBehavior code) {
        return code.getSystem();
    }
}

