/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcAllergyIntoleranceStatus {
    _1797,
    _69074,
    _31119,
    NULL;


    public static HspcAllergyIntoleranceStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1797".equals(codeString)) {
            return _1797;
        }
        if ("69074".equals(codeString)) {
            return _69074;
        }
        if ("31119".equals(codeString)) {
            return _31119;
        }
        throw new FHIRException("Unknown HspcAllergyIntoleranceStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1797: {
                return "1797";
            }
            case _69074: {
                return "69074";
            }
            case _31119: {
                return "31119";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/hspc-allergyintolerancestatus";
    }

    public String getDefinition() {
        switch (this) {
            case _1797: {
                return "Indication that a symptom or condition is subsided or healed.";
            }
            case _69074: {
                return "The state of being mistaken.";
            }
            case _31119: {
                return "The state of not likely being true.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1797: {
                return "Resolved";
            }
            case _69074: {
                return "Error";
            }
            case _31119: {
                return "Unlikely";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

