/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ImmunizationRecommendationDateCriterion {
    DUE,
    RECOMMENDED,
    EARLIEST,
    OVERDUE,
    LATEST,
    NULL;


    public static ImmunizationRecommendationDateCriterion fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("due".equals(codeString)) {
            return DUE;
        }
        if ("recommended".equals(codeString)) {
            return RECOMMENDED;
        }
        if ("earliest".equals(codeString)) {
            return EARLIEST;
        }
        if ("overdue".equals(codeString)) {
            return OVERDUE;
        }
        if ("latest".equals(codeString)) {
            return LATEST;
        }
        throw new FHIRException("Unknown ImmunizationRecommendationDateCriterion code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DUE: {
                return "due";
            }
            case RECOMMENDED: {
                return "recommended";
            }
            case EARLIEST: {
                return "earliest";
            }
            case OVERDUE: {
                return "overdue";
            }
            case LATEST: {
                return "latest";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/immunization-recommendation-date-criterion";
    }

    public String getDefinition() {
        switch (this) {
            case DUE: {
                return "Date the next dose is considered due.";
            }
            case RECOMMENDED: {
                return "At the recommended date.";
            }
            case EARLIEST: {
                return "As early as possible.";
            }
            case OVERDUE: {
                return "Date the next dose is considered overdue.";
            }
            case LATEST: {
                return "The latest date the next dose is to be given.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DUE: {
                return "Due";
            }
            case RECOMMENDED: {
                return "Recommended";
            }
            case EARLIEST: {
                return "Earliest Date";
            }
            case OVERDUE: {
                return "Past Due Date";
            }
            case LATEST: {
                return "Latest";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

