/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MetricOperationalStatus {
    ON,
    OFF,
    STANDBY,
    NULL;


    public static MetricOperationalStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("on".equals(codeString)) {
            return ON;
        }
        if ("off".equals(codeString)) {
            return OFF;
        }
        if ("standby".equals(codeString)) {
            return STANDBY;
        }
        throw new FHIRException("Unknown MetricOperationalStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ON: {
                return "on";
            }
            case OFF: {
                return "off";
            }
            case STANDBY: {
                return "standby";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/metric-operational-status";
    }

    public String getDefinition() {
        switch (this) {
            case ON: {
                return "The DeviceMetric is operating and will generate DeviceObservations.";
            }
            case OFF: {
                return "The DeviceMetric is not operating.";
            }
            case STANDBY: {
                return "The DeviceMetric is operating, but will not generate any DeviceObservations.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ON: {
                return "On";
            }
            case OFF: {
                return "Off";
            }
            case STANDBY: {
                return "Standby";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

