/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum OrderStatus {
    PENDING,
    REVIEW,
    REJECTED,
    ERROR,
    ACCEPTED,
    CANCELLED,
    REPLACED,
    ABORTED,
    COMPLETED,
    NULL;


    public static OrderStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("pending".equals(codeString)) {
            return PENDING;
        }
        if ("review".equals(codeString)) {
            return REVIEW;
        }
        if ("rejected".equals(codeString)) {
            return REJECTED;
        }
        if ("error".equals(codeString)) {
            return ERROR;
        }
        if ("accepted".equals(codeString)) {
            return ACCEPTED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("replaced".equals(codeString)) {
            return REPLACED;
        }
        if ("aborted".equals(codeString)) {
            return ABORTED;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        throw new FHIRException("Unknown OrderStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PENDING: {
                return "pending";
            }
            case REVIEW: {
                return "review";
            }
            case REJECTED: {
                return "rejected";
            }
            case ERROR: {
                return "error";
            }
            case ACCEPTED: {
                return "accepted";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case REPLACED: {
                return "replaced";
            }
            case ABORTED: {
                return "aborted";
            }
            case COMPLETED: {
                return "completed";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/order-status";
    }

    public String getDefinition() {
        switch (this) {
            case PENDING: {
                return "The order is known, but no processing has occurred at this time";
            }
            case REVIEW: {
                return "The order is undergoing initial processing to determine whether it will be accepted (usually this involves human review)";
            }
            case REJECTED: {
                return "The order was rejected because of a workflow/business logic reason";
            }
            case ERROR: {
                return "The order was unable to be processed because of a technical error (i.e. unexpected error)";
            }
            case ACCEPTED: {
                return "The order has been accepted, and work is in progress.";
            }
            case CANCELLED: {
                return "Processing the order was halted at the initiators request.";
            }
            case REPLACED: {
                return "The order has been cancelled and replaced by another.";
            }
            case ABORTED: {
                return "Processing the order was stopped because of some workflow/business logic reason.";
            }
            case COMPLETED: {
                return "The order has been completed.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PENDING: {
                return "Pending";
            }
            case REVIEW: {
                return "Review";
            }
            case REJECTED: {
                return "Rejected";
            }
            case ERROR: {
                return "Error";
            }
            case ACCEPTED: {
                return "Accepted";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case REPLACED: {
                return "Replaced";
            }
            case ABORTED: {
                return "Aborted";
            }
            case COMPLETED: {
                return "Completed";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

