/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ProcedureStatus;

public class ProcedureStatusEnumFactory
implements EnumFactory<ProcedureStatus> {
    @Override
    public ProcedureStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("in-progress".equals(codeString)) {
            return ProcedureStatus.INPROGRESS;
        }
        if ("aborted".equals(codeString)) {
            return ProcedureStatus.ABORTED;
        }
        if ("completed".equals(codeString)) {
            return ProcedureStatus.COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ProcedureStatus.ENTEREDINERROR;
        }
        throw new IllegalArgumentException("Unknown ProcedureStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(ProcedureStatus code) {
        if (code == ProcedureStatus.NULL) {
            return null;
        }
        if (code == ProcedureStatus.INPROGRESS) {
            return "in-progress";
        }
        if (code == ProcedureStatus.ABORTED) {
            return "aborted";
        }
        if (code == ProcedureStatus.COMPLETED) {
            return "completed";
        }
        if (code == ProcedureStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        return "?";
    }

    @Override
    public String toSystem(ProcedureStatus code) {
        return code.getSystem();
    }
}

