/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.PropertyRepresentation;

public class PropertyRepresentationEnumFactory
implements EnumFactory<PropertyRepresentation> {
    @Override
    public PropertyRepresentation fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("xmlAttr".equals(codeString)) {
            return PropertyRepresentation.XMLATTR;
        }
        if ("xmlText".equals(codeString)) {
            return PropertyRepresentation.XMLTEXT;
        }
        if ("typeAttr".equals(codeString)) {
            return PropertyRepresentation.TYPEATTR;
        }
        if ("cdaText".equals(codeString)) {
            return PropertyRepresentation.CDATEXT;
        }
        throw new IllegalArgumentException("Unknown PropertyRepresentation code '" + codeString + "'");
    }

    @Override
    public String toCode(PropertyRepresentation code) {
        if (code == PropertyRepresentation.NULL) {
            return null;
        }
        if (code == PropertyRepresentation.XMLATTR) {
            return "xmlAttr";
        }
        if (code == PropertyRepresentation.XMLTEXT) {
            return "xmlText";
        }
        if (code == PropertyRepresentation.TYPEATTR) {
            return "typeAttr";
        }
        if (code == PropertyRepresentation.CDATEXT) {
            return "cdaText";
        }
        return "?";
    }

    @Override
    public String toSystem(PropertyRepresentation code) {
        return code.getSystem();
    }
}

