/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.RestfulInteraction;

public class RestfulInteractionEnumFactory
implements EnumFactory<RestfulInteraction> {
    @Override
    public RestfulInteraction fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("read".equals(codeString)) {
            return RestfulInteraction.READ;
        }
        if ("vread".equals(codeString)) {
            return RestfulInteraction.VREAD;
        }
        if ("update".equals(codeString)) {
            return RestfulInteraction.UPDATE;
        }
        if ("delete".equals(codeString)) {
            return RestfulInteraction.DELETE;
        }
        if ("history".equals(codeString)) {
            return RestfulInteraction.HISTORY;
        }
        if ("history-instance".equals(codeString)) {
            return RestfulInteraction.HISTORYINSTANCE;
        }
        if ("history-type".equals(codeString)) {
            return RestfulInteraction.HISTORYTYPE;
        }
        if ("history-system".equals(codeString)) {
            return RestfulInteraction.HISTORYSYSTEM;
        }
        if ("create".equals(codeString)) {
            return RestfulInteraction.CREATE;
        }
        if ("search".equals(codeString)) {
            return RestfulInteraction.SEARCH;
        }
        if ("search-type".equals(codeString)) {
            return RestfulInteraction.SEARCHTYPE;
        }
        if ("search-system".equals(codeString)) {
            return RestfulInteraction.SEARCHSYSTEM;
        }
        if ("conformance".equals(codeString)) {
            return RestfulInteraction.CONFORMANCE;
        }
        if ("transaction".equals(codeString)) {
            return RestfulInteraction.TRANSACTION;
        }
        if ("batch".equals(codeString)) {
            return RestfulInteraction.BATCH;
        }
        if ("operation".equals(codeString)) {
            return RestfulInteraction.OPERATION;
        }
        throw new IllegalArgumentException("Unknown RestfulInteraction code '" + codeString + "'");
    }

    @Override
    public String toCode(RestfulInteraction code) {
        if (code == RestfulInteraction.NULL) {
            return null;
        }
        if (code == RestfulInteraction.READ) {
            return "read";
        }
        if (code == RestfulInteraction.VREAD) {
            return "vread";
        }
        if (code == RestfulInteraction.UPDATE) {
            return "update";
        }
        if (code == RestfulInteraction.DELETE) {
            return "delete";
        }
        if (code == RestfulInteraction.HISTORY) {
            return "history";
        }
        if (code == RestfulInteraction.HISTORYINSTANCE) {
            return "history-instance";
        }
        if (code == RestfulInteraction.HISTORYTYPE) {
            return "history-type";
        }
        if (code == RestfulInteraction.HISTORYSYSTEM) {
            return "history-system";
        }
        if (code == RestfulInteraction.CREATE) {
            return "create";
        }
        if (code == RestfulInteraction.SEARCH) {
            return "search";
        }
        if (code == RestfulInteraction.SEARCHTYPE) {
            return "search-type";
        }
        if (code == RestfulInteraction.SEARCHSYSTEM) {
            return "search-system";
        }
        if (code == RestfulInteraction.CONFORMANCE) {
            return "conformance";
        }
        if (code == RestfulInteraction.TRANSACTION) {
            return "transaction";
        }
        if (code == RestfulInteraction.BATCH) {
            return "batch";
        }
        if (code == RestfulInteraction.OPERATION) {
            return "operation";
        }
        return "?";
    }

    @Override
    public String toSystem(RestfulInteraction code) {
        return code.getSystem();
    }
}

