/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SearchModifierCode {
    MISSING,
    EXACT,
    CONTAINS,
    NOT,
    TEXT,
    IN,
    NOTIN,
    BELOW,
    ABOVE,
    TYPE,
    NULL;


    public static SearchModifierCode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("missing".equals(codeString)) {
            return MISSING;
        }
        if ("exact".equals(codeString)) {
            return EXACT;
        }
        if ("contains".equals(codeString)) {
            return CONTAINS;
        }
        if ("not".equals(codeString)) {
            return NOT;
        }
        if ("text".equals(codeString)) {
            return TEXT;
        }
        if ("in".equals(codeString)) {
            return IN;
        }
        if ("not-in".equals(codeString)) {
            return NOTIN;
        }
        if ("below".equals(codeString)) {
            return BELOW;
        }
        if ("above".equals(codeString)) {
            return ABOVE;
        }
        if ("type".equals(codeString)) {
            return TYPE;
        }
        throw new FHIRException("Unknown SearchModifierCode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MISSING: {
                return "missing";
            }
            case EXACT: {
                return "exact";
            }
            case CONTAINS: {
                return "contains";
            }
            case NOT: {
                return "not";
            }
            case TEXT: {
                return "text";
            }
            case IN: {
                return "in";
            }
            case NOTIN: {
                return "not-in";
            }
            case BELOW: {
                return "below";
            }
            case ABOVE: {
                return "above";
            }
            case TYPE: {
                return "type";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/search-modifier-code";
    }

    public String getDefinition() {
        switch (this) {
            case MISSING: {
                return "The search parameter returns resources that have a value or not.";
            }
            case EXACT: {
                return "The search parameter returns resources that have a value that exactly matches the supplied parameter (the whole string, including casing and accents).";
            }
            case CONTAINS: {
                return "The search parameter returns resources that include the supplied parameter value anywhere within the field being searched.";
            }
            case NOT: {
                return "The search parameter returns resources that do not contain a match .";
            }
            case TEXT: {
                return "The search parameter is processed as a string that searches text associated with the code/value - either CodeableConcept.text, Coding.display, or Identifier.type.text.";
            }
            case IN: {
                return "The search parameter is a URI (relative or absolute) that identifies a value set, and the search parameter tests whether the coding is in the specified value set.";
            }
            case NOTIN: {
                return "The search parameter is a URI (relative or absolute) that identifies a value set, and the search parameter tests whether the coding is not in the specified value set.";
            }
            case BELOW: {
                return "The search parameter tests whether the value in a resource is subsumed by the specified value (is-a, or hierarchical relationships).";
            }
            case ABOVE: {
                return "The search parameter tests whether the value in a resource subsumes the specified value (is-a, or hierarchical relationships).";
            }
            case TYPE: {
                return "The search parameter only applies to the Resource Type specified as a modifier (e.g. the modifier is not actually :type, but :Patient etc.).";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MISSING: {
                return "Missing";
            }
            case EXACT: {
                return "Exact";
            }
            case CONTAINS: {
                return "Contains";
            }
            case NOT: {
                return "Not";
            }
            case TEXT: {
                return "Text";
            }
            case IN: {
                return "In";
            }
            case NOTIN: {
                return "Not In";
            }
            case BELOW: {
                return "Below";
            }
            case ABOVE: {
                return "Above";
            }
            case TYPE: {
                return "Type";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

